(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12239,        348]*)
(*NotebookOutlinePosition[     12989,        375]*)
(*  CellTagsIndexPosition[     12945,        371]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["StopSolvers", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) \
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[{
  "This package contains the implementation of the procedure ",
  StyleBox["Stop",
    FontWeight->"Bold"],
  " that stops the constraint solvers available for CFLP. "
}], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<StopSolvers`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["Link5000",
            FontColor->RGBColor[0, 0, 1]], "::", "usage"}], "=", 
        "\"\<Link5000 yields an opened link to local port 5000.\>\""}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Stop::usage = 
      "\<Stop[] aborts the execution of constraint solvers available for \
CFLP.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Off[LinkOpen::"\<linkf\>", LinkConnect::"\<linkc\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["Stop", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tStop",
    FontWeight->"Bold"],
  "[",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "Perform the folowing steps:\n\t\n",
  Cell[BoxData[GridBox[{
          {
            RowBox[{\(1. \ Connect\), ",", " ", \(if\ possible\), ",", " ", 
              RowBox[{"to", " ", "port", " ", 
                StyleBox["5000",
                  FontWeight->"Bold"], " ", "on", " ", "the", " ", "local", 
                " ", "machine"}]}]},
          {
            RowBox[{
            "2.", "If", " ", "step", " ", "1", " ", "succeeds", " ", "then", 
              " ", "goto", " ", "step", " ", "3", " ", "else", " ", 
              StyleBox["Exit",
                FontWeight->"Bold"]}]},
          {
            RowBox[{
            \(3. \ [There\ exist\ constraint\ solvers\ running\ locally]\), 
              "\n", "\t\t", GridBox[{
                  {
                    RowBox[{
                      RowBox[{"3.1", " ", "Send", " ", "an", " ", 
                        StyleBox["exit",
                          FontWeight->"Bold"], " ", "message", " ", "on", 
                        " ", "link", " ", 
                        StyleBox[
                          RowBox[{
                            StyleBox["5000",
                              FontWeight->"Bold"], 
                            StyleBox[".",
                              FontWeight->"Plain"]}]], 
                        StyleBox["This",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["event",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["will",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["trigger",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["the",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["process",
                          FontWeight->"Plain"], 
                        StyleBox[" ",
                          FontWeight->"Plain"], 
                        StyleBox["listening",
                          FontWeight->"Plain"]}], "\n", "\t\t\t", 
                      RowBox[{"at", " ", "port", " ", 
                        StyleBox["5000",
                          FontWeight->"Bold"], " ", "to", " ", "abort", " ", 
                        "the", " ", "running", " ", "solvers"}]}]},
                  {
                    RowBox[{"3.2", ".", 
                      StyleBox["Exit",
                        FontWeight->"Bold"], "."}]}
                  },
                GridBaseline->Axis,
                RowAlignments->Baseline,
                ColumnAlignments->{Left},
                AutoDelete->False]}]}
          },
        GridBaseline->Axis,
        RowAlignments->Baseline,
        ColumnAlignments->{Left},
        AutoDelete->False]]],
  "\n\n ",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Stop[]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({info}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{
                StyleBox["Link5000",
                  FontColor->RGBColor[0, 0, 1]], "=", 
                \(LinkConnect["\<5000\>", LinkProtocol -> "\<TCP\>"]\)}], 
              ";", "\n", "\t\t", 
              RowBox[{"info", "=", 
                RowBox[{"LinkWrite", "[", 
                  RowBox[{
                    StyleBox["Link5000",
                      FontColor->RGBColor[0, 0, 1]], ",", "\"\<exit\>\""}], 
                  "]"}]}], ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\(info === $Failed\), ",", "\n", "\t\t\t", 
                  RowBox[{\(Pause[1]\), ";", "\n", "\t\t\t", 
                    RowBox[{
                      StyleBox["Link5000",
                        FontColor->RGBColor[0, 0, 1]], "=", 
                      \(LinkConnect["\<5000\>", LinkProtocol -> "\<TCP\>"]
                        \)}], ";", "\n", "\t\t\t", 
                    RowBox[{"info", "=", 
                      RowBox[{"LinkWrite", "[", 
                        RowBox[{
                          StyleBox["Link5000",
                            FontColor->RGBColor[0, 0, 1]], ",", 
                          "\"\<exit\>\""}], "]"}]}]}]}], "\n", "\t\t", "]"}], 
              ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\(info =!= $Failed\), ",", "\n", "\t\t\t", 
                  RowBox[{"While", "[", 
                    RowBox[{
                      RowBox[{"Not", "[", 
                        RowBox[{"LinkReadyQ", "[", 
                          StyleBox["Link5000",
                            FontColor->RGBColor[0, 0, 1]], "]"}], "]"}], ",", 
                      \(Continue[]\)}], "]"}]}], "\n", "\t\t", "]"}], ";", 
              "\n", "\t\t", \(Exit[]\)}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SolveMethods", "Subsection"],

Cell[TextData[{
  StyleBox["SolveMethods",
    FontWeight->"Bold"],
  " gives the list of assigned names of the constraint solving methods \
available in CFLP."
}], "Text"],

Cell[BoxData[
    \(\(SolveMethods = {"\<Linear\>", "\<Polynomial\>", "\<Derivative\>", 
        "\<PartialDerivative\>"}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell["Example", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
AutoGeneratedPackage->Automatic,
WindowSize->{810, 665},
WindowMargins->{{175, Automatic}, {Automatic, 56}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 67, 1, 104, "Title"],
Cell[1801, 54, 125, 3, 32, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[1951, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2018, 64, 2326, 40, 34214, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4381, 109, 39, 0, 53, "Subtitle"],
Cell[4423, 111, 195, 5, 32, "Text"],
Cell[4621, 118, 133, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4779, 125, 27, 0, 45, "Subsection"],
Cell[4809, 127, 313, 9, 27, "Input",
  InitializationCell->True],
Cell[5125, 138, 199, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5373, 149, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5432, 153, 24, 0, 52, "Section"],
Cell[5459, 155, 153, 3, 27, "Input",
  InitializationCell->True],
Cell[5615, 160, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5763, 167, 26, 0, 45, "Subsection"],
Cell[5792, 169, 3573, 92, 244, "Text"],
Cell[9368, 263, 2057, 44, 235, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[11462, 312, 34, 0, 45, "Subsection"],
Cell[11499, 314, 172, 5, 32, "Text"],
Cell[11674, 321, 200, 4, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11923, 331, 22, 0, 32, "Section"],
Cell[11948, 333, 106, 3, 27, "Input",
  InitializationCell->True],
Cell[12057, 338, 113, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[12185, 344, 26, 0, 52, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

