(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21951,        585]*)
(*NotebookOutlinePosition[     22726,        613]*)
(*  CellTagsIndexPosition[     22682,        609]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["StartSolvers", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) \
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[{
  "This package contains the implementation of the procedure that starts the \
constraint solvers available for CFLP. The specification of the constraint \
solving capabilities that are available is given by the array ",
  StyleBox["Instances",
    FontWeight->"Bold"],
  " and the variable ",
  StyleBox["$NumberOfSchedulers",
    FontWeight->"Bold"],
  ". \nPort 5000 is reserved for the service of providing a list of new ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections to the already running constraint solvers. A client gets such \
a list of connections by calling the function ",
  StyleBox["MakeLinks[]",
    FontWeight->"Bold"],
  " provided in the package ",
  StyleBox["Config.m",
    FontWeight->"Bold"],
  " (see the notebook Config.nb for implementation details)."
}], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<StartSolvers`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["Link5000",
            FontColor->RGBColor[0, 0, 1]], "::", "usage"}], "=", 
        "\"\<Link5000 yields an opened link to local port 5000.\>\""}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Start::usage = 
      "\<Start[] initializes the constraint solvers for CFLP.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\($NumberOfSchedulers::usage = 
      "\<$NumberOfSchedulers yields the current numer of running constraint \
schedulers. It has the initial value 0 and is incremented each time when the \
function Config`MakeLinks[] is (successfully) invoked.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Off[LinkOpen::"\<linkf\>", LinkConnect::"\<linkc\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["LocalSolvers", "Subsection"],

Cell[TextData[{
  StyleBox["LocalSolvers",
    FontWeight->"Bold"],
  " is a datastructure containing the links to the constraint solvers running \
locally. It is instantiated at the first call of the function ",
  StyleBox["Start[]",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker]
}, Open  ]],

Cell[CellGroupData[{

Cell["$NumberOfSchedulers", "Subsection"],

Cell[TextData[{
  StyleBox["$NumberOfSchedulers",
    FontWeight->"Bold"],
  " yields the current number of running constraint schedulers. It has the \
initial value 0 and is incremented each time when the function ",
  StyleBox["Config`MakeLinks",
    FontWeight->"Bold"],
  "[] is (successfully) invoked.\n"
}], "Text",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[BoxData[
    \(\($NumberOfSchedulers := 0; \)\)], "Input",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NumberOfInstances", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["NumberOfInstances[ ",
    FontWeight->"Bold"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn the number of running ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "-solvers"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(NumberOfInstances["\<Linear\>"] := 1; \n
    NumberOfInstances["\<Polynomial\>"] := 2; \n
    NumberOfInstances["\<Derivative\>"] := 2; \n
    NumberOfInstances["\<PartialDerivative\>"] := 0; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProcessQueries", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tProcessQueries",
    FontWeight->"Bold"],
  "[ ",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell["\<\
Process the queries received at local port 5000. The valid queries are: \
\"exit\", \"ignore\", \"close\", \"ask\", \"askmore\" and \"stop\".\
\>", "Text",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{\(ProcessQueries[]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{"res", ",", 
                StyleBox["newLinks",
                  FontColor->RGBColor[1, 0, 0]], ",", "tmpLnks", ",", 
                "crtLnk", ",", "crtMeth", ",", "crtLnks"}], "}"}], ",", "\n", 
            "\t\t", 
            RowBox[{
              RowBox[{"While", "[", 
                RowBox[{"True", ",", "\n", "\t\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{
                      RowBox[{"LinkReadyQ", "[", 
                        StyleBox["Link5000",
                          FontColor->RGBColor[0, 0, 1]], "]"}], ",", "\n", 
                      "\t\t\t\t", 
                      RowBox[{
                        RowBox[{"res", "=", 
                          RowBox[{"LinkRead", "[", 
                            StyleBox["Link5000",
                              FontColor->RGBColor[0, 0, 1]], "]"}]}], ";", 
                        "\n", "\t\t\t\t", \(Print[res]\), ";", "\n", 
                        "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                          \(res === $Failed\), ",", "\n", "\t\t\t\t\t", 
                            RowBox[{
                            \(tmpLnks = LinkCreate[]\), ";", "\n", 
                              "\t\t\t\t\t", 
                              RowBox[{
                                StyleBox["Link5000",
                                  FontColor->RGBColor[0, 0, 1]], "=", 
                                \(LinkCreate["\<5000\>", 
                                  LinkProtocol -> "\<TCP\>"]\)}], ";", "\n", 
                              "\t\t\t\t\t", \(LinkClose[tmpLnks]\), ";", 
                              "\n", "\t\t\t\t\t", \(Continue[]\)}]}], "\n", 
                          "\t\t\t\t", "]"}], ";", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                            RowBox[{"res", "===", 
                              StyleBox["\"\<exit\>\"",
                                FontColor->RGBColor[0, 0.500008, 0]]}], ",", 
                            \(Break[]\)}], "]"}], ";", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                            RowBox[{"res", "===", 
                              StyleBox["\"\<ignore\>\"",
                                FontColor->RGBColor[0, 0.500008, 0]]}], ",", 
                            "\n", "\t\t\t\t\t", 
                            RowBox[{
                            \($NumberOfSchedulers--\), ";", "\n", 
                              "\t\t\t\t\t", 
                              RowBox[{"res", "=", 
                                StyleBox["\"\<close\>\"",
                                  FontColor->RGBColor[0, 0.500008, 0]]}]}]}], 
                          "\n", "\t\t\t\t", "]"}], ";", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                            RowBox[{"res", "===", 
                              StyleBox["\"\<ask\>\"",
                                FontColor->RGBColor[0, 0.500008, 0]]}], ",", 
                            "\n", "\t\t\t\t\t", 
                            RowBox[{
                            \({crtMeth, crtLnks} = First[LocalSolvers]\), 
                              ";", "\n", "\t\t\t\t\t", 
                              \(tmpLnks = Rest[LocalSolvers]\), ";", "\n", 
                              "\t\t\t\t\t", 
                              RowBox[{"LinkWrite", "[", 
                                RowBox[{
                                  StyleBox["Link5000",
                                    FontColor->RGBColor[0, 0, 1]], ",", 
                                  \(++$NumberOfSchedulers\)}], "]"}], ";", 
                              "\n", "\t\t\t\t\t", \(Continue[]\)}]}], "\n", 
                          "\t\t\t\t", "]"}], ";", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                            RowBox[{"res", "===", 
                              StyleBox["\"\<askmore\>\"",
                                FontColor->RGBColor[0, 0.500008, 0]]}], ",", 
                            "\n", "\t\t\t\t\t", 
                            RowBox[{
                              RowBox[{"While", "[", 
                                RowBox[{"True", ",", "\n", "\t\t\t\t\t\t", 
                                  RowBox[{"If", "[", 
                                    RowBox[{
                                    \(crtLnks === {}\), ",", "\n", 
                                      "\t\t\t\t\t\t\t", 
                                      RowBox[{"If", "[", 
                                        RowBox[{
                                        \(tmpLnks === {}\), ",", "\n", 
                                        "\t\t\t\t\t\t\t\t", 
                                        RowBox[{
                                        RowBox[{"LinkWrite", "[", 
                                        RowBox[{
                                        StyleBox["Link5000",
                                        FontColor->RGBColor[0, 0, 1]], ",", 
                                        StyleBox["\"\<stop\>\"",
                                        FontColor->RGBColor[0, 0.500008, 
                                        0]]}], "]"}], ";", "\n", 
                                        "\t\t\t\t\t\t\t\t", \(Break[]\)}], 
                                        ",", "\n", "\t\t\t\t\t\t\t\t", 
                                        \({crtMeth, crtLnks} = 
                                        First[tmpLnks]; \n\t\t\t\t\t\t\t\t
                                        tmpLnks = Rest[tmpLnks]\)}], "\n", 
                                        "\t\t\t\t\t\t\t", "]"}], ",", "\n", 
                                      "\t\t\t\t\t\t\t", 
                                      RowBox[{
                                      \(crtLnk = First[crtLnks]\), ";", "\n", 
                                        "\t\t\t\t\t\t\t", 
                                        \(crtLnks = Rest[crtLnks]\), ";", 
                                        "\n", "\t\t\t\t\t\t\t", 
                                        \(LinkWrite[crtLnk, 
                                        Unevaluated[LinkCreate[]]]\), ";", 
                                        "\n", "\t\t\t\t\t\t\t", 
                                        \(While[Not[LinkReadyQ[crtLnk]], 
                                        Continue[]]\), ";", "\n", 
                                        "\t\t\t\t\t\t\t", 
                                        \(res = LinkRead[crtLnk]\), ";", 
                                        "\n", "\t\t\t\t\t\t\t", 
                                        RowBox[{"LinkWrite", "[", 
                                        RowBox[{
                                        StyleBox["Link5000",
                                        FontColor->RGBColor[0, 0, 1]], ",", 
                                        \({crtMeth, res}\)}], "]"}], ";", 
                                        "\n", "\t\t\t\t\t\t\t", 
                                        \(Break[]\)}]}], "\n", 
                                    "\t\t\t\t\t\t", "]"}]}], "\n", 
                                "\t\t\t\t\t", "]"}], ";", "\n", "\t\t\t\t\t", 
                              \(Continue[]\)}]}], "\n", "\t\t\t\t", "]"}], 
                        ";", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                            RowBox[{"res", "===", 
                              StyleBox["\"\<close\>\"",
                                FontColor->RGBColor[0, 0.500008, 0]]}], ",", 
                            "\n", "\t\t\t\t\t", 
                            RowBox[{
                              RowBox[{"LinkClose", "[", 
                                StyleBox["Link5000",
                                  FontColor->RGBColor[0, 0, 1]], "]"}], ";", 
                              "\n", "\t\t\t\t\t", 
                              RowBox[{
                                StyleBox["Link5000",
                                  FontColor->RGBColor[0, 0, 1]], "=", 
                                \(LinkCreate["\<5000\>", 
                                  LinkProtocol -> "\<TCP\>"]\)}]}]}], "\n", 
                          "\t\t\t\t", "]"}]}]}], "\n", "\t\t\t", "]"}]}], 
                "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
              RowBox[{"Map", "[", 
                RowBox[{
                \(LinkWrite[#, Unevaluated[Exit[]]]&\), ",", "\n", "\t\t\t", 
                  RowBox[{"Complement", "[", 
                    RowBox[{\(Links[]\), ",", 
                      RowBox[{"{", 
                        RowBox[{"$ParentLink", ",", 
                          StyleBox["Link5000",
                            FontColor->RGBColor[0, 0, 1]]}], "}"}]}], 
                    "]"}]}], "]"}], ";", "\n", "\t\t", \(Exit[]\)}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Start", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tStart",
    FontWeight->"Bold"],
  "[",
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Performs the folowing steps:\n",
  StyleBox["1",
    FontWeight->"Bold"],
  ". Start the local constraint solvers\n",
  StyleBox["2",
    FontWeight->"Bold"],
  ". Maintains open the local port 5000 for receiving (from some scheduler) \
queries to connect/disconnect to the local constraint solvers."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Start[]\), ":=", "\n", "\t", 
        RowBox[{"If", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  StyleBox["Link5000",
                    FontColor->RGBColor[0, 0, 1]], "=", 
                  \(LinkCreate["\<5000\>", LinkProtocol -> "\<TCP\>"]\)}], 
                ")"}], "===", "$Failed"}], ",", "\n", "\t\t", 
            \(Print["\<Solvers were already started.\>"]; \n\t\tExit[]\), 
            ",", "\n", "\t\t", 
            \(LocalSolvers = \n\t\t\t
              Block[{i}, \n\t\t\t\tPrint["\<Starting solvers ...\>"]; \n
                \t\t\t\tMap[{#, 
                      Table[\n\t\t\t\t\t\t\t
                        LinkLaunch[
                          StringJoin[\n\t\t\t\t\t\t\t\t\t
                            "\<math -mathlink -initfile \>", \n
                            \t\t\t\t\t\t\t\t\t#<>"\<.m\>", \n
                            \t\t\t\t\t\t\t\t\t
                            "\< -run Loop[] -batchoutput\>"]], {i, 
                          NumberOfInstances[#]}]}&, \n\t\t\t\t\tSolveMethods]
                  \n\t\t\t]; \n\t\tProcessQueries[]\)}], "\n", "\t", "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SolveMethods", "Subsection"],

Cell[TextData[{
  StyleBox["SolveMethods",
    FontWeight->"Bold"],
  " gives the list of assigned names of the constraint solving methods \
available in CFLP."
}], "Text"],

Cell[BoxData[
    \(\(SolveMethods = {"\<Linear\>", "\<Polynomial\>", "\<Derivative\>", 
        "\<PartialDerivative\>"}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell["Example", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{706, 509},
WindowMargins->{{19, Automatic}, {Automatic, 10}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 68, 1, 104, "Title"],
Cell[1802, 54, 125, 3, 32, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[1952, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2019, 64, 2326, 40, 736, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4382, 109, 39, 0, 53, "Subtitle"],
Cell[4424, 111, 825, 20, 104, "Text"],
Cell[5252, 133, 134, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5411, 140, 27, 0, 45, "Subsection"],
Cell[5441, 142, 313, 9, 27, "Input",
  InitializationCell->True],
Cell[5757, 153, 184, 5, 27, "Input",
  InitializationCell->True],
Cell[5944, 160, 345, 6, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6338, 172, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[6397, 176, 24, 0, 52, "Section"],
Cell[6424, 178, 153, 3, 27, "Input",
  InitializationCell->True],
Cell[6580, 183, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6728, 190, 34, 0, 45, "Subsection"],
Cell[6765, 192, 369, 10, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7171, 207, 41, 0, 45, "Subsection"],
Cell[7215, 209, 413, 10, 68, "Text"],
Cell[7631, 221, 183, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7851, 230, 39, 0, 45, "Subsection"],
Cell[7893, 232, 478, 20, 86, "Text"],

Cell[CellGroupData[{
Cell[8396, 256, 125, 3, 42, "Subsubsection"],
Cell[8524, 261, 287, 6, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8860, 273, 36, 0, 45, "Subsection"],
Cell[8899, 275, 314, 14, 68, "Text"],
Cell[9216, 291, 257, 5, 50, "Text"],

Cell[CellGroupData[{
Cell[9498, 300, 142, 6, 42, "Subsubsection"],
Cell[9643, 308, 9261, 164, 859, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[18953, 478, 27, 0, 45, "Subsection"],
Cell[18983, 480, 304, 14, 68, "Text"],
Cell[19290, 496, 423, 11, 86, "Text"],

Cell[CellGroupData[{
Cell[19738, 511, 83, 2, 42, "Subsubsection"],
Cell[19824, 515, 1301, 28, 267, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21174, 549, 34, 0, 45, "Subsection"],
Cell[21211, 551, 172, 5, 32, "Text"],
Cell[21386, 558, 200, 4, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[21635, 568, 22, 0, 32, "Section"],
Cell[21660, 570, 106, 3, 27, "Input",
  InitializationCell->True],
Cell[21769, 575, 113, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[21897, 581, 26, 0, 52, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

