(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9962,        330]*)
(*NotebookOutlinePosition[     10629,        354]*)
(*  CellTagsIndexPosition[     10585,        350]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Polynomial", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[StyleBox[
"\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, \
Tsukuba."]], "Text"],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[StyleBox[
"This package contains the implementations of constraint solvers for systems \
of polynomial\nequations over the field of complex numbers."]], "Text"],

Cell[BoxData[
    \(\(BeginPackage[
      "\<Polynomial`\>", {"\<Substitutions`\>", "\<MainLoop`\>"}]; \)\)], 
  "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(Off[$MaxExtraPrecision::"\<meprec\>"]; \n$MaxExtraPrecision = 0; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(PolySolve::usage = 
      "\<PolySolve[eqs,var,elims] attempts to \[Ellipsis]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Off[Solve::"\<svars\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["PolySolve", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["PolySolve[ ",
    FontWeight->"Bold"],
  StyleBox["eqs, vars, elims ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : set of polynomial equations\n\t",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list of basic variables\n\t",
  StyleBox["elims",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list eliminable variables\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\treturn value:\n\t\t ",
  StyleBox["{",
    FontWeight->"Bold"],
  "{},{}",
  StyleBox["}",
    FontWeight->"Bold"],
  "  if no the eqs is inconsistent (no solutions)\n\t\t ",
  StyleBox["{",
    FontWeight->"Bold"],
  "{},{{{},",
  StyleBox["  ",
    FontWeight->"Bold"],
  StyleBox["eqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "}}",
  StyleBox["} ",
    FontWeight->"Bold"],
  " if ",
  StyleBox["PolySolve",
    FontWeight->"Bold"],
  " can not solve eqs \n\t\t ",
  StyleBox["{",
    FontWeight->"Bold"],
  "{},{{sol1,",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1},{sol2,",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "2},\[Ellipsis]}",
  StyleBox["}",
    FontWeight->"Bold"],
  " \n\t\t if ",
  StyleBox["PolySolve",
    FontWeight->"Bold"],
  " is able to find the partial answer substitutions sol1,sol2,\[Ellipsis] \
for ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ".\n\t\t ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1, ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "2 represent the  residual equations of ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(PolySolve[eqs_, vars_, elims_] := \n\t
      Block[{result, answer}, \n\t\tresult = Solve[eqs, vars, elims]; \n\t\t
        If[Head[result] === Solve, \n\t\t\t{{}, {{{}, eqs}}}, \n\t\t\t
          result = Simplify[result]; \n\t\t\t
          answer = 
            Map[\(({#, \(eqs /. #\) /. {True -> Sequence[]}})\)&, result]; \n
          \t\t\t{{}, answer}\n\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[BoxData[
    \(<< Polynomial`\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolySolve[{v == 3.0, x == v\ t, u == 5.0, y == u*t - 1/2\ g\ t^2, 
        g == 9.8, t == 7.0}, \n{v, x, u, y, g, t}, {}]\)], "Input"],

Cell[BoxData[
    \({{}, {{{x \[Rule] 21.0000000000000008`, 
            y \[Rule] \(-205.100000000000015`\), v \[Rule] 3.`, 
            u \[Rule] 5.`, g \[Rule] 9.80000000000000071`, 
            t \[Rule] 7.`}, {}}}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(PolySolve[{v^2 == 9, x*y^2 - 9*z*v + x\ z == 4}, {v, x, y, z}, {}]\)], 
  "Input"],

Cell[BoxData[
    \({{}, {{{v \[Rule] 3, z \[Rule] \(4 - x\ y\^2\)\/\(\(-27\) + x\)}, {
            x\ y\^2 - \(27\ \((4 - x\ y\^2)\)\)\/\(\(-27\) + x\) + 
                \(x\ \((4 - x\ y\^2)\)\)\/\(\(-27\) + x\) == 4}}, {{
            v \[Rule] \(-3\), z \[Rule] \(4 - x\ y\^2\)\/\(27 + x\)}, {
            x\ y\^2 + \(27\ \((4 - x\ y\^2)\)\)\/\(27 + x\) + 
                \(x\ \((4 - x\ y\^2)\)\)\/\(27 + x\) == 4}}}}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{657, 570},
WindowMargins->{{60, Automatic}, {Automatic, 17}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 66, 1, 102, "Title"],
Cell[1800, 54, 182, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[2007, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2074, 64, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[4437, 109, 39, 0, 64, "Subtitle"],
Cell[4479, 111, 174, 2, 50, "Text"],
Cell[4656, 115, 243, 7, 27, "Input",
  InitializationCell->True],
Cell[4902, 124, 168, 4, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5095, 132, 27, 0, 45, "Subsection"],
Cell[5125, 134, 186, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5360, 144, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5419, 148, 24, 0, 54, "Section"],
Cell[5446, 150, 124, 3, 27, "Input",
  InitializationCell->True],
Cell[5573, 155, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5721, 162, 31, 0, 45, "Subsection"],
Cell[5755, 164, 2007, 86, 248, "Text"],

Cell[CellGroupData[{
Cell[7787, 254, 125, 3, 42, "Subsubsection"],
Cell[7915, 259, 472, 9, 171, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8448, 275, 22, 0, 54, "Section"],
Cell[8473, 277, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[8637, 284, 168, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8842, 294, 26, 0, 54, "Section"],
Cell[8871, 296, 47, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[8943, 301, 154, 2, 43, "Input"],
Cell[9100, 305, 233, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9370, 314, 102, 2, 27, "Input"],
Cell[9475, 318, 435, 6, 83, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

