(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8755,        277]*)
(*NotebookOutlinePosition[      9482,        303]*)
(*  CellTagsIndexPosition[      9438,        299]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["MainLoop", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[
"\[Copyright]1998 Research Institute for Symbolic Computation (RISC-Linz) "], 
  "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementations of a constraint solver \
for systems of linear equations. \
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<MainLoop`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Loop::usage = "\<Loop[]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CloseLinks::usage = "\<CloseLinks[]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($QueryLink::usage = 
      "\<$QueryLink is the link object for the connection between the \
constraint solver and the process which connects it to constraint \
scheduler(s).\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["Loop", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Loop[  ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "Evaluate all expressions available on the links to which the constraint \
solver is connected.\n\tand write back the result of their evaluation.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(Loop[] := \n\t
      Block[{expr, lnks}, \n\t\t
        While[True, \n\t\t\t
          If[LinkReadyQ[$ParentLink], \n\t\t\t\texpr = LinkRead[$ParentLink]; 
            \n\t\t\t\t
            If[expr =!= $Failed, \ \n\t\t\t\t\t
              If[Head[expr] === LinkObject, 
                expr = expr\[LeftDoubleBracket]1\[RightDoubleBracket]]; \n
              \t\t\t\t\tLinkWrite[$ParentLink, expr]\n\t\t\t\t], \n\t\t\t\t
            lnks = Complement[Links[], {$ParentLink}]; \n\t\t\t\t
            Scan[\n\t\t\t\t\t
              If[LinkReadyQ[#], \n\t\t\t\t\t\texpr = LinkRead[#]; \n
                  \t\t\t\t\t\t
                  If[expr =!= $Failed, \n\t\t\t\t\t\t\t
                    If[expr === "\<close\>", LinkClose[#], LinkWrite[#, expr]]
                      \n\t\t\t\t\t\t]\n\t\t\t\t\t]&, lnks]\n\t\t\t]\n\t\t]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["PortNumber", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tPortNumber",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["link",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "]\n",
  StyleBox["Input\n\tlink",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a link object that uses the TCP underlying communication protocol.\n",
  StyleBox["Output\n \t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "The port number of ",
  StyleBox["link",
    FontSlant->"Italic"],
  " represented as a string.\n ",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(PortNumber[lnk_LinkObject] := \n\t
      Block[{}, \n\t
        \(StringTake[#, 
              \(StringPosition[#, "\<@\>", 1]\)\[LeftDoubleBracket]1, 1
                  \[RightDoubleBracket] - 1]&\)[First[Cases[lnk, x_ :> x]]]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[BoxData[
    \(<< MainLoop`\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{706, 509},
WindowMargins->{{3, Automatic}, {9, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 64, 1, 104, "Title"],
Cell[1798, 54, 131, 3, 32, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[1954, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2021, 64, 2326, 40, 36114, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4384, 109, 39, 0, 53, "Subtitle"],
Cell[4426, 111, 124, 3, 32, "Text"],
Cell[4553, 116, 190, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4768, 125, 27, 0, 45, "Subsection"],
Cell[4798, 127, 132, 3, 27, "Input",
  InitializationCell->True],
Cell[4933, 132, 144, 3, 27, "Input",
  InitializationCell->True],
Cell[5080, 137, 283, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5412, 149, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5471, 153, 24, 0, 52, "Section"],
Cell[5498, 155, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5646, 162, 26, 0, 45, "Subsection"],
Cell[5675, 164, 469, 15, 122, "Text"],
Cell[6147, 181, 943, 19, 331, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7127, 205, 32, 0, 45, "Subsection"],
Cell[7162, 207, 698, 27, 140, "Text"],
Cell[7863, 236, 335, 8, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8247, 250, 22, 0, 32, "Section"],
Cell[8272, 252, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[8436, 259, 168, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8641, 269, 26, 0, 52, "Section"],
Cell[8670, 271, 45, 1, 27, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

