(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      8273,        278]*)
(*NotebookOutlinePosition[      8940,        302]*)
(*  CellTagsIndexPosition[      8896,        298]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Linear", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[StyleBox[
"\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, \
Tsukuba."]], "Text"],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementations of a constraint solver \
for systems of linear equations. \
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Linear`\>", {"\<Substitutions`\>", "\<MainLoop`\>"}]; 
    \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(Off[$MaxExtraPrecision::"\<meprec\>"]; \n$MaxExtraPrecision = 0; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(LinSolve::usage = 
      "\<LinSolve[eqs,vars,elims] attempts to \[Ellipsis]\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Off[Solve::"\<svars\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["LinSolve", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["LinSolve[ ",
    FontWeight->"Bold"],
  StyleBox["eqs, vars, elims ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : set of linear equations\n\t",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list of basic variables\n\t",
  StyleBox["elims",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list eliminable variables\n",
  StyleBox["Output",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  "{},{}",
  StyleBox["}",
    FontWeight->"Bold"],
  "  if ",
  StyleBox["eqs",
    FontSlant->"Italic"],
  " are inconsistent (no solutions) \n\t",
  StyleBox["{",
    FontWeight->"Bold"],
  "{},{{",
  StyleBox["sol",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", ",
  StyleBox["resteqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "}}",
  StyleBox["}",
    FontWeight->"Bold"],
  " \n\twhere sol is the partial answer substitutions for ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontSlant->"Italic"],
  "and  ",
  StyleBox["resteqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are the residual equations of ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(LinSolve[eqs_, vars_, elims_] := \n\t
      Block[{result = Solve[eqs, vars, elims]}, \n\t\t
        If[Head[result] === Solve, \n\t\t\t\t{{}, {{{}, eqs}}}, \n
          \t\t\t\t{{}, 
            Map[\(({#, Simplify[eqs /. #] /. {True \[Rule] Sequence[]}})\)&, 
              result]}\n\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example", "Section"],

Cell[BoxData[
    \(<< Linear`\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{612, 525},
WindowMargins->{{53, Automatic}, {Automatic, 82}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 62, 1, 102, "Title"],
Cell[1796, 54, 182, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[2003, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2070, 64, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[4433, 109, 39, 0, 53, "Subtitle"],
Cell[4475, 111, 124, 3, 32, "Text"],
Cell[4602, 116, 234, 6, 27, "Input",
  InitializationCell->True],
Cell[4839, 124, 168, 4, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5032, 132, 27, 0, 45, "Subsection"],
Cell[5062, 134, 185, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5296, 144, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5355, 148, 24, 0, 54, "Section"],
Cell[5382, 150, 124, 3, 27, "Input",
  InitializationCell->True],
Cell[5509, 155, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5657, 162, 30, 0, 45, "Subsection"],
Cell[5690, 164, 1628, 71, 230, "Text"],
Cell[7321, 237, 397, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7767, 251, 22, 0, 52, "Section"],
Cell[7792, 253, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[7956, 260, 168, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8161, 270, 26, 0, 52, "Section"],
Cell[8190, 272, 43, 1, 27, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

