(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      9179,        282]*)
(*NotebookOutlinePosition[      9846,        306]*)
(*  CellTagsIndexPosition[      9802,        302]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Derivative", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[StyleBox[
"\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, \
Tsukuba."]], "Text"],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of a constraint solver for \
systems of ordinary diferential equations over the complex numbers. \
\>", 
  "Text"],

Cell[BoxData[
    \(\(BeginPackage[
      "\<Derivative`\>", {"\<Substitutions`\>", "\<MainLoop`\>"}]; \)\)], 
  "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(DiffSolve::usage = "\<DiffSolve\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(Off[DSolve::"\<pde\>", DSolve::"\<nvld\>"]; \nOff[Solve::"\<svars\>"]; 
    \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["idxList, crtIdx", "Subsection"],

Cell[BoxData[
    \(idxList = {}; \ncrtIdx = 0; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiffSolve", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(DiffSolve[systList_List] := \n\t
      Block[{result, newVars = {}}, \n\t\t
        result = Fold[DiffSolveAux1, {{{}, {}}}, systList]; \n
        \t\t{newVars, result}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiffSolveAux1", "Subsection"],

Cell[BoxData[
    \(\(DiffSolveAux1[l_List, x_] := 
      Map[DiffSolveAux2[#, x]&, l] /. Null -> Sequence[]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiffSolveAux2", "Subsection"],

Cell[BoxData[
    \(\(DiffSolveAux2[{crtSubst_, crtEqs_}, {eqs__, {fs_, {v_}}}] := \n\t
      Block[{\n\t\t\tmySubst, \n\t\t\t
          fVars = Complement[fs, \((First/@crtSubst)\)], \n\t\t\t
          myEqs = DeleteCases[Simplify[ApplySubst[{eqs}, crtSubst]], True]}, 
        \n\t\tIf[MemberQ[myEqs, False], \n\t\t\tReturn[Sequence[]], \n\t\t\t
          If[fVars === {} \[Or] myEqs === {}, \n\t\t\t\t
            Return[{crtSubst, Join[crtEqs, myEqs]}]]\n\t\t]; \n\t\t
        mySubst = DSolve[myEqs, \(\((#[v])\)&\)/@\ fVars, v]; \n\t\t
        If[Head[mySubst] === DSolve, \n\t\t\t{crtSubst, Join[crtEqs, myEqs]}, 
          \n\t\t\tmySubst = mySubst /. {C[i_] :> DiffConst[i]}; \n\t\t\t
          mySubst = 
            Apply[Rule[Head[#1], Apply[Global`\[Lambda], {{v}, #2}]]&, mySubst
              \ , {2}]; \n\t\t\t
          idxList = 
            Union[Map[Symbol["\<c\>"<>ToString[# + crtIdx]]&, idxList]]; \n
          \t\t\tnewVars = Join[newVars, idxList]; \n\t\t\t
          crtIdx += Length[idxList]; \n\t\t\tidxList = {}; \n\t\t\t
          Apply[Sequence, \n\t\t\t\t
            Map[NewPartialSolution[crtSubst, crtEqs, #]&, mySubst]]\n\t\t]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DiffConst", "Subsection"],

Cell[BoxData[
    \(\(DiffConst[x_Integer] := \n\t
      Block[{}, \n\t\tAppendTo[idxList, x]; \n\t\t
        Symbol["\<c\>"<>ToString[x + crtIdx]]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["NewPartialSolution", "Subsection"],

Cell[BoxData[
    \(\(NewPartialSolution[\[Sigma]Old_, eqs_, \[Sigma]_] := \n\t
      Block[{newEqs = 
            DeleteCases[Simplify[ApplySubst[eqs, \[Sigma]]], True]}, \n\t\t
        If[MemberQ[newEqs, False], \n\t\t\t{}, \n
          \t\t\t{Join[ApplySubst[\[Sigma]Old, \[Sigma]], \[Sigma]], newEqs}\n
          \t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell["Example", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowSize->{657, 570},
WindowMargins->{{39, Automatic}, {Automatic, 33}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 66, 1, 102, "Title"],
Cell[1800, 54, 182, 3, 50, "Text"],

Cell[CellGroupData[{
Cell[2007, 61, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2074, 64, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[4437, 109, 39, 0, 64, "Subtitle"],
Cell[4479, 111, 165, 4, 50, "Text"],
Cell[4647, 117, 243, 7, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4915, 128, 27, 0, 45, "Subsection"],
Cell[4945, 130, 140, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5134, 139, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5193, 143, 24, 0, 54, "Section"],
Cell[5220, 145, 171, 4, 43, "Input",
  InitializationCell->True],
Cell[5394, 151, 123, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5542, 158, 37, 0, 45, "Subsection"],
Cell[5582, 160, 123, 3, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5742, 168, 31, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[5798, 172, 125, 3, 42, "Subsubsection"],
Cell[5926, 177, 302, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6277, 190, 35, 0, 45, "Subsection"],
Cell[6315, 192, 215, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[6567, 202, 35, 0, 45, "Subsection"],
Cell[6605, 204, 1283, 23, 379, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7925, 232, 31, 0, 45, "Subsection"],
Cell[7959, 234, 231, 5, 91, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8227, 244, 40, 0, 45, "Subsection"],
Cell[8270, 246, 434, 9, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8753, 261, 22, 0, 54, "Section"],
Cell[8778, 263, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[8942, 270, 168, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[9125, 278, 26, 0, 54, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

