(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     37508,       1149]*)
(*NotebookOutlinePosition[     38202,       1174]*)
(*  CellTagsIndexPosition[     38158,       1170]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["SchedulerInterface", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains interface functions between the CFLP \
interpreter and the CFLP constraint scheduler. \
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<SchedulerInterface`\>", {"\<Debug`\>"}]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Stop::usage = "\<\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(StartCFLP::usage = 
      "\<StartCFLP[ ] creates the Mathlink connections needed for a CFLP \
session.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSEnd::usage = 
      "\<CSEnd[ ] closes the Mathlink connections of the CFLP session.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetCSType::usage = 
      "\<SetCSType[tyVals] defines the `Type` function to the constraint \
scheduler such that it coincides with the `Type` function of the constraint \
interpreter.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(GetCSConnections::usage = 
      "\<GetCSConnections[] prints the connections established between \
constraint scheduler and constraint solvers.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SendCSQuery::usage = 
      "\<SendCSQuery[ msg ] sends the message msg to the constraint scheduler\
\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSSchedule::usage = 
      "\<CSSchedule[] is the actual call to the constraint scheduler.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(QueryForResources::usage; \nResetLocalResources::usage; \n
    ResetRemoteResources::usage; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Query::usage = "\<Query[id] \>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["CSEnd", "Subsection"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(CSEnd[\ ]\), ":=", "\n", "\t", 
          RowBox[{"(", 
            RowBox[{\(NotebookClose[$CFLPsyntax]\), ";", "\n", "\t\t", 
              StyleBox[\(CloseCFLPTraceWindow[]\),
                FontWeight->"Bold"], 
              StyleBox[";",
                FontWeight->"Bold"], "\n", "\t\t", \(CloseCSTraceWindow[]\), 
              ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\(MemberQ[Links[], CSlink]\), ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"SendCSQuery", "[", 
                      RowBox[{"{", 
                        StyleBox["\"\<End\>\"",
                          FontColor->RGBColor[0, 0, 1]], "}"}], "]"}], ";", 
                    "\n", "\t\t\t", \(Print["\<done.\>"]\)}], ",", "\n", 
                  "\t\t\t", \(Print["\<link already disabled.\>"]\)}], 
                "]"}]}], ")"}]}], ";"}], 
      StyleBox[" ",
        FontWeight->"Bold"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetCSConnections", "Subsection"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(GetCSConnections[] := \n\t
      If[CSlink === {}, \n\t\t\t
        Print["\<Warning: connection to scheduler is dead.\>"], \n\t\t
        Scan[GetMethConnections, \n
          \t\t\t{"\<Linear\>", "\<Polynomial\>", "\<Derivative\>", 
            "\<PartialDerivative\>"}]]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["GetMethConnections", "Subsection"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(GetMethConnections[meth_]\), ":=", "\n", "\t", 
        RowBox[{"Print", "[", 
          RowBox[{"meth", ",", "\"\< connections:\>\"", ",", 
            RowBox[{"SendCSQuery", "[", 
              RowBox[{"{", 
                RowBox[{
                  StyleBox["\"\<GetLinks\>\"",
                    FontColor->RGBColor[0, 0, 1]], ",", "meth"}], "}"}], 
              "]"}]}], "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Query", "Subsection"],

Cell[BoxData[
    \(\(Query[_] := {}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SendCSQuery", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tSendCSQuery[ ",
    FontWeight->"Bold"],
  StyleBox["msg",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["msg ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a message of the form ",
  StyleBox["{ ",
    FontWeight->"Bold"],
  StyleBox["id, item",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)],
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[", \[Ellipsis], item",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_n\)\)],
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["}",
    FontWeight->"Bold"],
  " where ",
  StyleBox["id",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the message tag (a string) and ",
  StyleBox["item",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  ",\[Ellipsis], ",
  StyleBox["item",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_n\)\)]],
  " is the data content of the message. ",
  StyleBox["msg",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is sent by the functional logic interpreter to the constraint solving \
scheduler.\nThe valid messages to the scheduler are:\n\t(1) { ",
  StyleBox["\"End\" ",
    FontWeight->"Bold"],
  "}, \n\t(2) { ",
  StyleBox["\"GetResults\"",
    FontWeight->"Bold"],
  ", ",
  StyleBox["id ",
    FontSlant->"Italic"],
  "},\n\t(3) {",
  StyleBox["\"Confirm\"",
    FontWeight->"Bold"],
  " }, \n\t(4) { ",
  StyleBox["\"GetLinks\"",
    FontWeight->"Bold"],
  " },  \n\t(5) { ",
  StyleBox["\"CSolve\"",
    FontWeight->"Bold"],
  StyleBox[", cs, \[Sigma], gv, pv",
    FontSlant->"Italic"],
  " }, \n\t(6) { ",
  StyleBox["\"SetConstructors\"",
    FontWeight->"Bold"],
  ", {c",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  ", \[Ellipsis], c",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_n\)\)]],
  "}}\nwhere:\n\t",
  StyleBox["id",
    FontSlant->"Italic"],
  " = a query index, \n\t",
  StyleBox["cs",
    FontSlant->"Italic"],
  " = a set of constraint equations, \n\t",
  StyleBox["\[Sigma]",
    FontSlant->"Italic"],
  " = partial answer substitution, \n\t",
  StyleBox["gv",
    FontSlant->"Italic"],
  " = the variables of ",
  StyleBox["cs",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["pv",
    FontSlant->"Italic"],
  " = the parameters of ",
  StyleBox["cs",
    FontSlant->"Italic"],
  "\n\tc",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  ", \[Ellipsis], c",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_n\)\)]],
  " = constructor symbols"
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell["", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[TextData[{
  "The ",
  StyleBox["{ \"End\" }",
    FontWeight->"Bold"],
  " message directs the scheduler to close the connections to the constraint \
solvers. The connection interpreter-scheduler is broken and the scheduler \
stops running. "
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"SendCSQuery", "[", 
          RowBox[{"{", 
            StyleBox["\"\<End\>\"",
              FontColor->RGBColor[0, 0, 1]], "}"}], "]"}], ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"LinkWrite", "[", 
                RowBox[{"CSlink", ",", 
                  RowBox[{"{", 
                    StyleBox["\"\<End\>\"",
                      FontColor->RGBColor[0, 0, 1]], "}"}]}], "]"}], ";", 
              "\n", "\t\t", \(LinkClose[CSlink]\), ";", "\n", "\t\t", 
              \(CSlink = {}\)}]}], "\n", "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[TextData[{
  "The ",
  StyleBox["{ \"GetResults\", ",
    FontWeight->"Bold"],
  StyleBox["id ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  " message is sent by the interpreter to the scheduler when solutions to the \
system of constraints with index ",
  StyleBox["id",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " are requested. The scheduler replies by sending back all the messages \
collected so far on the local stack. (the ",
  StyleBox["myStack",
    FontWeight->"Bold"],
  " container variable maintained by the ",
  StyleBox["Scheduler`Schedule[]",
    FontWeight->"Bold"],
  " routine). The last message received by the interpreter is ",
  StyleBox["\"y\"",
    FontColor->RGBColor[0, 0, 1]],
  " if all the answer solutions of the query ",
  StyleBox["id",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " were computed and sent back, and ",
  StyleBox["\"n\"",
    FontColor->RGBColor[0, 0, 1]],
  " otherwise."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(SendCSQuery[{"\<GetResults\>", id_Integer}]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["resultCS",
                    FontColor->RGBColor[1, 0, 0]], "=", "\"\<\>\""}], ",", 
                "returnedResult"}], "}"}], ",", "\n", "\t\t", 
            RowBox[{
            \(If[CSlink === {}, \n\t\t\t
                Print["\<Warning: connection to scheduler is dead.\>"]; 
                Return[{}]]\), ";", "\n", "\t\t", 
              RowBox[{"LinkWrite", "[", 
                RowBox[{"CSlink", ",", 
                  RowBox[{"{", 
                    StyleBox[\("\<GetResults\>", id\),
                      FontColor->RGBColor[0, 0, 1]], "}"}]}], "]"}], ";", 
              "\n", "\t\t", 
              RowBox[{"While", "[", 
                RowBox[{"True", ",", "\n", "\t\t\t", 
                  RowBox[{
                  \(If[Not[LinkReadyQ[CSlink]], Continue[]]\), ";", "\n", 
                    "\t\t\t", 
                    RowBox[{
                      StyleBox["resultCS",
                        FontColor->RGBColor[1, 0, 0]], "=", 
                      \(LinkRead[CSlink]\)}], ";", "\n", "\t\t\t", 
                    RowBox[{"Switch", "[", 
                      RowBox[{
                        RowBox[{"Head", "[", 
                          StyleBox["resultCS",
                            FontColor->RGBColor[1, 0, 0]], "]"}], ",", "\n", 
                        "\t\t\t\t", "String", ",", \(Break[]\), ",", "\n", 
                        "\t\t\t\t", "List", ",", 
                        RowBox[{"CSPrint", "[", 
                          RowBox[{"1", ",", 
                            RowBox[{"Sequence", " ", "@@", " ", 
                              StyleBox["resultCS",
                                FontColor->RGBColor[1, 0, 0]]}]}], "]"}], 
                        ",", "\n", "\t\t\t\t", "_", ",", 
                        \( (*\ process\ the\ computed\ answer\ returned\ by\ 
                            the\ scheduler\ *) \), "\n", "\t\t\t\t", 
                        RowBox[{
                          RowBox[{"returnedResult", "=", 
                            RowBox[{"ProcessResults", "[", 
                              RowBox[{"Rest", "[", 
                                RowBox[{"List", " ", "@@", " ", 
                                  StyleBox["resultCS",
                                    FontColor->RGBColor[1, 0, 0]]}], "]"}], 
                              "]"}]}], ";", "\n", "\t\t\t\t", 
                          \( (*\ Print["\<returnedResult=\>", 
                              returnedResult]; \ *) \), "\n", "\t\t\t\t", 
                          RowBox[{"AppendTo", "[", 
                            RowBox[{
                              RowBox[{
                                StyleBox["Query",
                                  FontColor->RGBColor[0, 0, 1]], "[", 
                                RowBox[{"First", "[", 
                                  StyleBox["resultCS",
                                    FontColor->RGBColor[1, 0, 0]], "]"}], 
                                "]"}], ",", "returnedResult"}], "]"}]}]}], 
                      "\n", "\t\t\t", "]"}]}]}], "\n", "\t\t", "]"}], ";", 
              "\n", "\t\t", 
              \( (*\ Print["\<GetResults got:\>", resultCS]; \ *) \), "\n", 
              "\t\t", 
              StyleBox["resultCS",
                FontColor->RGBColor[1, 0, 0]]}]}], "\n", "\t", "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[TextData[{
  "The ",
  StyleBox["{ \"Confirm\"",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  " message is asks the scheduler to confirm the availability of the link \
interpreter-scheduler. The scheduler answers with ",
  StyleBox["\"Confirmed\"",
    FontColor->RGBColor[0, 0, 1]],
  " if the link is available."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"SendCSQuery", "[", 
          RowBox[{"{", 
            StyleBox["\"\<Confirm\>\"",
              FontColor->RGBColor[0, 0, 1]], "}"}], "]"}], ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({res}\), ",", "\n", "\t\t", 
            RowBox[{
            \(If[CSlink === {}, \n\t\t\t
                Print["\<Warning: connection to scheduler is dead.\>"]; 
                Return["\<.\>"]]\), ";", "\n", "\t\t", 
              RowBox[{"LinkWrite", "[", 
                RowBox[{"CSlink", ",", 
                  RowBox[{"{", 
                    StyleBox["\"\<Confirm\>\"",
                      FontColor->RGBColor[0, 0, 1]], "}"}]}], "]"}], ";", 
              "\n", "\t\t", 
              \(While[True, \n\t\t\tIf[Not[LinkReadyQ[CSlink]], Continue[]]; 
                \n\t\t\tIf[LinkRead[CSlink] === "\<Confirmed\>", \n\t\t\t\t
                  Print["\<done.\>"]; \n\t\t\t\tBreak[]\n\t\t\t]\n\t\t]
                \)}]}], "\n", "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[TextData[{
  "The ",
  StyleBox["{ \"GetLinks\", ",
    FontWeight->"Bold"],
  StyleBox["meth ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  " message asks the scheduler for information about the links available to \
the solvers that are available and that implement the constraint solving \
method ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ". The scheduler returns a message of the form \[Ellipsis]"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"SendCSQuery", "[", 
          RowBox[{"{", 
            StyleBox[\("\<GetLinks\>", meth_\),
              FontColor->RGBColor[0, 0, 1]], "}"}], "]"}], ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({res}\), ",", "\n", "\t\t", 
            RowBox[{
            \(If[CSlink === {}, \n\t\t\t
                Print["\<Warning: connection to scheduler is dead.\>"]; 
                Return["\<.\>"]]\), ";", "\n", "\t\t", 
              RowBox[{"LinkWrite", "[", 
                RowBox[{"CSlink", ",", 
                  RowBox[{"{", 
                    StyleBox[\("\<GetLinks\>", meth\),
                      FontColor->RGBColor[0, 0, 1]], "}"}]}], "]"}], ";", 
              "\n", "\t\t", 
              \(While[True, \n\t\t\tIf[Not[LinkReadyQ[CSlink]], Continue[]]; 
                \n\t\t\tres = LinkRead[CSlink]; \n\t\t\tBreak[]\n\t\t]\), 
              ";", "\n", "\t\t", "res"}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(SendCSQuery[msg_]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                StyleBox["resultCS",
                  FontColor->RGBColor[1, 0, 0]], ",", "processedResults"}], 
              "}"}], ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"If", "[", 
                RowBox[{
                \(CSlink === {}\), ",", "\n", "\t\t\t", 
                  \(Print["\<connection to scheduler is dead.\>"]; \n\t\t\t
                  Return["\<dead.\>"]\), ",", "\n", "\t\t\t", 
                  RowBox[{
                  \(LinkWrite[CSlink, msg]\), ";", "\n", "\t\t\t", 
                    \(LinkFlush[CSlink]\), ";", "\n", "\t\t\t", 
                    RowBox[{"While", "[", 
                      RowBox[{"True", ",", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                          \(LinkReadyQ[CSlink]\), ",", "\n", "\t\t\t\t\t", 
                            RowBox[{
                              RowBox[{
                                StyleBox["resultCS",
                                  FontColor->RGBColor[1, 0, 0]], "=", 
                                \(LinkRead[CSlink]\)}], ";", "\n", 
                              "\t\t\t\t\t", 
                              RowBox[{"Switch", "[", 
                                RowBox[{
                                  RowBox[{"Head", "[", 
                                    StyleBox["resultCS",
                                      FontColor->RGBColor[1, 0, 0]], "]"}], 
                                  ",", "\n", "\t\t\t\t\t\t", "String", ",", 
                                  \(Break[]\), ",", "\n", "\t\t\t\t\t\t", 
                                  "List", ",", 
                                  RowBox[{"CSPrint", "[", 
                                    RowBox[{"1", ",", 
                                      RowBox[{"Sequence", " ", "@@", " ", 
                                        StyleBox["resultCS",
                                        FontColor->RGBColor[1, 0, 0]]}]}], 
                                    "]"}], ",", "\n", "\t\t\t\t\t\t", "_", 
                                  ",", "\n", "\t\t\t\t\t\t", 
                                  RowBox[{
                                    RowBox[{"processedResults", "=", 
                                      RowBox[{"ProcessResults", "[", 
                                        RowBox[{"Rest", "[", 
                                        RowBox[{"List", " ", "@@", " ", 
                                        StyleBox["resultCS",
                                        FontColor->RGBColor[1, 0, 0]]}], 
                                        "]"}], "]"}]}], ";", "\n", 
                                    "\t\t\t\t\t\t", 
                                    RowBox[{"AppendTo", "[", 
                                      RowBox[{
                                        RowBox[{
                                        StyleBox["Query",
                                        FontColor->RGBColor[0, 0, 1]], "[", 
                                        RowBox[{"First", "[", 
                                        StyleBox["resultCS",
                                        FontColor->RGBColor[1, 0, 0]], "]"}], 
                                        "]"}], ",", "processedResults"}], 
                                      "]"}]}]}], "\n", "\t\t\t\t\t", 
                                "]"}]}]}], "\n", "\t\t\t\t", "]"}]}], "\n", 
                      "\t\t\t", "]"}]}]}], "\n", "\t\t", "]"}], ";", "\n", 
              "\t\t", 
              StyleBox["resultCS",
                FontColor->RGBColor[1, 0, 0]]}]}], "\n", "\t", "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" StartCFLP", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tStartCFLP[  ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tSet up the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections among the CFLP components"
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(StartCFLP[\ ] := \n\t
      If[MemberQ[Links[], CSlink], \n\t\t
        Print["\<connection to scheduler is already available.\>"], \n\t\t
        Print["\<connecting\[Ellipsis]\>"]; \n\t\t
        OpenCSTraceWindow[WindowTitle \[Rule] "\<Scheduler Trace\>"]; \n\t\t
        OpenCFLPTraceWindow[WindowTitle \[Rule] "\<CFLP Trace\>"]; \n\t\t
        SetPanel[]; \n\t\t
        If[Head[$CFLPsyntax] =!= NotebookObject \[Or] \n\t\t\t\t
            NotebookInformation[$CFLPsyntax] === $Failed, \n
          \t\t\t$CFLPsyntax = 
            NotebookOpen[Global`$cflpSrcDirectory<>"\<CFLPsyntax.nb\>"]\n
          \t\t]; \ \n\t\t
        CSlink = 
          LinkLaunch[
            "\<math -mathlink -initfile Scheduler.m -run Schedule[] \
-batchoutput\>"]; \n\t\tSendCSQuery[{"\<Confirm\>"}]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ProcessResults", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["ProcessResults[{ ",
    FontWeight->"Bold"],
  StyleBox["v, \[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", ",
    FontWeight->"Bold"],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" } ]",
    FontWeight->"Bold"]
}], "Text"],

Cell[TextData[{
  "where\n\t",
  StyleBox["v",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list of variables\n\t",
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : substitution\n\t",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : list of equations\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox[" ",
    FontWeight->"Bold"],
  "compute the pair ",
  StyleBox["{ ",
    FontWeight->"Bold"],
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["', ",
    FontWeight->"Bold"],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["' }",
    FontWeight->"Bold"],
  " where ",
  StyleBox["\[Sigma]'",
    FontWeight->"Bold"],
  " is the substitution which satisfies ",
  StyleBox["\[Sigma]'=\[Sigma] \[SmallCircle] \[Sigma]'",
    FontWeight->"Bold"],
  StyleBox[".",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(ProcessResults[{v_, \[Sigma]_, eqs_List}] := \n\t
      Prepend[\n\t\t
        ReplaceAll[\n\t\t{Inner[Rule, v, v //. \[Sigma], List], eqs}, \n
          \t\t{DelayMark[x_] :> x, 
            \((Rule | RuleDelayed)\)[x_, x_] :> Sequence[]}], v]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["QueryForResources", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["QueryForResources[ ]",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(QueryForResources[] := \n\t
      Block[{resourceCell}, \n\t\t
        CSLaunchNotebookCFLP = 
          NotebookOpen[Global`$cflpSrcDirectory<>"\<CSLaunch.nb\>", 
            Visible -> False]; \n\t
        NotebookLocate[{Global`$cflpSrcDirectory<>"\<CSLaunch.nb\>", 
            "\<resources\>"}]; \n\t\t
        resourceCell = 
          NotebookRead[CSLaunchNotebookCFLP] /. \n
            \t\t\t\t{
              Rule[InitializationCell, True] -> 
                Rule[InitializationCell, False], \n\t\t\t\t\t
              "\<Input\>" -> "\<Text\>"}; \n\t\t
        UserNotebookCFLP = 
          NotebookOpen[Global`$cflpSrcDirectory<>"\<UserPanel1.nb\>"]; \n\t\t
        NotebookLocate[{Global`$cflpSrcDirectory<>"\<UserPanel1.nb\>", 
            "\<resources\>"}]; \n\t\t
        numberOfResources = 
          Length[ListOfValues = Cases[resourceCell, "\<=\>", \[Infinity]]]; \n
        \t\tNotebookWrite[UserNotebookCFLP, resourceCell]\n\t]; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetLocalResources", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["ResetLocalResources[ ]",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(ResetLocalResources[] := \n\t
      Block[{w, ListOfValues}, \n\t\t
        NotebookLocate[{Global`$cflpSrcDirectory<>"\<UserPanel1.nb\>", 
            "\<resources\>"}]; \n\t\t
        resourceCell = 
          NotebookRead[UserNotebookCFLP] /. \n
            \t\t\t\t{
              Rule[InitializationCell, False] -> 
                Rule[InitializationCell, True], \n\t\t\t\t
              "\<Text\>" -> "\<Input\>"}; \n
        \t\t (*\ perform\ a\ superficial\ correctness\ check\ *) \n\t\t
        ListOfValues = 
          Cases[resourceCell, List[_, "\<=\>", w_] :> w, \[Infinity]]; \n\t\t
        If[And[\n\t\t\t\tLength[ListOfValues] == numberOfResources, \n\t\t\t\t
            Complement[ListOfValues, \n
                \t\t\t\t\t{"\<0\>", "\<1\>", "\<2\>", "\<3\>", "\<4\>", 
                  "\<5\>", "\<6\>", "\<7\>", "\<8\>", "\<9\>", "\<10\>", 
                  "\<11\>", "\<12\>"}] === {}], \n\t\t\t
          NotebookWrite[CSLaunchNotebookCFLP, resourceCell]; \n\t\t\t
          NotebookSave[CSLaunchNotebookCFLP]; \n\t\t\t
          RenameFile[$cflpSrcDirectory<>"\<CSLaunch.m\>", $cflpPkgDirectory<>
              "\<CSLaunch.m\>"]\n\t\t]; \n\t\t
        NotebookLocate[{Global`$cflpSrcDirectory<>"\<CSLaunch.nb\>", 
            "\<remote\>"}]; \n\t\tNotebookClose[UserNotebookCFLP]; \n\t\t
        resourceCell = 
          NotebookRead[CSLaunchNotebookCFLP] /. \n
            \t\t\t\t{
              Rule[InitializationCell, True] -> 
                Rule[InitializationCell, False], \n\t\t\t\t\t
              "\<Input\>" -> "\<Text\>"}; \n\t\t
        UserNotebookCFLP = 
          NotebookOpen[Global`$cflpSrcDirectory<>"\<UserPanel2.nb\>"]; \n\t\t
        SetSelectedNotebook[UserNotebookCFLP]; \n\t\t
        NotebookLocate[{Global`$cflpSrcDirectory<>"\<UserPanel2.nb\>", 
            "\<remote\>"}]; \n\t\t
        NotebookWrite[UserNotebookCFLP, resourceCell]\ \n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetRemoteResources", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["ResetRemoteResources[ ]",
    FontWeight->"Bold"]
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(ResetRemoteResources[] := \n\t
      Block[{}, \n\t\tSetSelectedNotebook[UserNotebookCFLP]; \n\t\t
        NotebookLocate["\<remote\>"]; \n\t\t
        resourceCell = 
          NotebookRead[UserNotebookCFLP] /. \n
            \t\t\t\t{
              Rule[InitializationCell, False] -> 
                Rule[InitializationCell, True], \n\t\t\t\t
              "\<Text\>" -> "\<Input\>"}; \n\t\t
        SetSelectedNotebook[CSLaunchNotebookCFLP]; \n\t\t
        NotebookLocate["\<remote\>"]; \n\t\t
        NotebookWrite[CSLaunchNotebookCFLP, resourceCell]; \n\t\t
        NotebookSave[CSLaunchNotebookCFLP]; \n\t\t
        RenameFile[$cflpSrcDirectory<>"\<CSLaunch.m\>", $cflpPkgDirectory<>
            "\<CSLaunch.m\>"]; \n\t\tNotebookClose[UserNotebookCFLP]; \n\t\t
        NotebookClose[CSLaunchNotebookCFLP]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Stop", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Stop[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  "Stop the current CFLP session."
}], "Text"],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{\(Stop[\ ]\), ":=", "\n", "\t", 
          RowBox[{"(", 
            RowBox[{\(NotebookClose[$CFLPsyntax]\), ";", "\n", "\t\t", 
              StyleBox[\(CloseCFLPTraceWindow[]\),
                FontWeight->"Bold"], 
              StyleBox[";",
                FontWeight->"Bold"], "\n", "\t\t", \(CloseCSTraceWindow[]\), 
              ";", "\n", "\t\t", 
              \(NotebookClose[Debug`Private`\[Bullet]ctrlPanel]\), ";", "\n", 
              "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\(MemberQ[Links[], CSlink]\), ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"SendCSQuery", "[", 
                      RowBox[{"{", 
                        StyleBox["\"\<End\>\"",
                          FontColor->RGBColor[0, 0, 1]], "}"}], "]"}], ";", 
                    "\n", "\t\t\t", \(Print["\<done.\>"]\)}], ",", "\n", 
                  "\t\t\t", \(Print["\<link already disabled.\>"]\)}], "]"}], 
              ";", "\n", "\t\t", \(Exit[]\)}], "\n", "\t", ")"}]}], ";"}], 
      StyleBox[" ",
        FontWeight->"Bold"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell["Package Demo", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{31, Automatic}, {8, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 74, 1, 102, "Title"],
Cell[1808, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2030, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2097, 66, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4460, 111, 39, 0, 53, "Subtitle"],
Cell[4502, 113, 132, 3, 32, "Text"],
Cell[4637, 118, 164, 4, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4826, 126, 27, 0, 45, "Subsection"],
Cell[4856, 128, 126, 3, 27, "Input",
  InitializationCell->True],
Cell[4985, 133, 212, 5, 43, "Input",
  InitializationCell->True],
Cell[5200, 140, 200, 5, 27, "Input",
  InitializationCell->True],
Cell[5403, 147, 294, 6, 59, "Input",
  InitializationCell->True],
Cell[5700, 155, 253, 5, 43, "Input",
  InitializationCell->True],
Cell[5956, 162, 210, 5, 43, "Input",
  InitializationCell->True],
Cell[6169, 169, 204, 5, 27, "Input",
  InitializationCell->True],
Cell[6376, 176, 192, 4, 59, "Input",
  InitializationCell->True],
Cell[6571, 182, 137, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[6745, 190, 24, 0, 54, "Section"],
Cell[6772, 192, 183, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6980, 201, 27, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[7032, 205, 83, 2, 42, "Subsubsection"],
Cell[7118, 209, 1079, 24, 139, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8246, 239, 38, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8309, 243, 83, 2, 42, "Subsubsection"],
Cell[8395, 247, 379, 8, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8823, 261, 40, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8888, 265, 83, 2, 42, "Subsubsection"],
Cell[8974, 269, 514, 12, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9537, 287, 27, 0, 45, "Subsection"],
Cell[9567, 289, 120, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9724, 297, 33, 0, 45, "Subsection"],
Cell[9760, 299, 348, 15, 68, "Text"],
Cell[10111, 316, 2745, 105, 302, "Text"],

Cell[CellGroupData[{
Cell[12881, 425, 69, 2, 42, "Subsubsection"],
Cell[12953, 429, 260, 7, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13250, 441, 83, 2, 42, "Subsubsection"],
Cell[13336, 445, 757, 18, 107, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[14130, 468, 69, 2, 42, "Subsubsection"],
Cell[14202, 472, 1005, 32, 86, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15244, 509, 83, 2, 42, "Subsubsection"],
Cell[15330, 513, 3677, 73, 331, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19044, 591, 69, 2, 42, "Subsubsection"],
Cell[19116, 595, 420, 14, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19573, 614, 83, 2, 42, "Subsubsection"],
Cell[19659, 618, 1111, 24, 219, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20807, 647, 69, 2, 42, "Subsubsection"],
Cell[20879, 651, 498, 16, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21414, 672, 83, 2, 42, "Subsubsection"],
Cell[21500, 676, 1076, 24, 203, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[22613, 705, 83, 2, 42, "Subsubsection"],
Cell[22699, 709, 3883, 71, 363, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[26631, 786, 32, 0, 45, "Subsection"],
Cell[26666, 788, 353, 14, 86, "Text"],

Cell[CellGroupData[{
Cell[27044, 806, 83, 2, 42, "Subsubsection"],
Cell[27130, 810, 898, 18, 251, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28077, 834, 36, 0, 45, "Subsection"],
Cell[28116, 836, 393, 16, 50, "Text"],
Cell[28512, 854, 402, 17, 104, "Text"],
Cell[28917, 873, 836, 33, 32, "Text"],

Cell[CellGroupData[{
Cell[29778, 910, 83, 2, 42, "Subsubsection"],
Cell[29864, 914, 353, 8, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[30266, 928, 39, 0, 45, "Subsection"],
Cell[30308, 930, 166, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[30499, 940, 83, 2, 42, "Subsubsection"],
Cell[30585, 944, 1059, 23, 219, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31693, 973, 41, 0, 45, "Subsection"],
Cell[31737, 975, 168, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[31930, 985, 83, 2, 42, "Subsubsection"],
Cell[32016, 989, 2006, 38, 427, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[34071, 1033, 42, 0, 45, "Subsection"],
Cell[34116, 1035, 169, 6, 50, "Text"],

Cell[CellGroupData[{
Cell[34310, 1045, 83, 2, 42, "Subsubsection"],
Cell[34396, 1049, 922, 18, 251, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35367, 1073, 26, 0, 45, "Subsection"],
Cell[35396, 1075, 278, 12, 86, "Text"],

Cell[CellGroupData[{
Cell[35699, 1091, 83, 2, 42, "Subsubsection"],
Cell[35785, 1095, 1221, 26, 187, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37067, 1128, 22, 0, 54, "Section"],
Cell[37092, 1130, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[37261, 1137, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[37449, 1145, 31, 0, 54, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

