(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     87363,       2781]*)
(*NotebookOutlinePosition[     88579,       2825]*)
(*  CellTagsIndexPosition[     88447,       2817]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Scheduler", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of the constraint \
scheduler. The constraint scheduler is the CFLP system component which \
handles the solving process of constraints by commonicating with specific \
constraint solvers.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(BeginPackage["\<Scheduler`\>", \n
      \t{"\<TermSyntax`\>", \n\t\t"\<TypeSyntax`\>", \n\t\t"\<Types`\>", \n
        \t\t"\<Substitutions`\>", \n\t\t"\<CSLaunch`\>"\n\t}\n]; \)\)], 
  "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \("Copyright 1998-1999 Institute RISC-Linz and Institute of Information \
Sciences and Electronics, Tsukuba."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Schedule::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\(CSolve::usage; \)\ \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Ask::usage = 
      "\<Ask[meth] gets available data from the link associated with \
meth.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(GetVars::usage = "\<GetVars[expr] yields the variables of expr.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Vars::usage = 
      "\<Vars[i] gives the list of variables in ConstraintTree\
\[LeftDoubleBracket]{i,\[Ellipsis]}\[RightDoubleBracket].\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SetCSQuery::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsPolyTerm::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsVar::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["SetCSConstrs",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<SetCSConstrs[slist] defines the function `IsConstructor` with \
value True on all elements of `slist`.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["CSClear",
            FontWeight->"Bold"], "::", "usage"}], "=", 
        "\"\<CSClear[slist] undefines the function `IsConstructor` for the \
elements of ``slist.\>\""}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($TLevel::usage = "\<\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(MapIdx::usage = "\<\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[BoxData[
    \(\(Off[Solve::"\<svars\>", LinkObject::"\<linkv\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Initialization",
  FontWeight->"Bold"]], "Subsection"],

Cell[BoxData[
    \($TLevel = 0; \nDefaultExternal[]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MsgQueue", "Subsection"],

Cell[BoxData[
    \(Clear[MsgQueue]; \nMsgQueue = {}; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSClear", "Subsection"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox["CSClear",
            FontWeight->"Bold"], "[", "constructors_List", "]"}], ":=", 
        \(Function[IsConstructor[#] =. ; #]\ /@\ constructors\)}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetCSConstrs", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(SetCSConstrs[l_List] := Scan[Function[IsConstructor[#] = True]\ , l]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearCSConstrs", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(ClearCSConstrs[l_List] := 
      Scan[Function[IsConstructor[#] = False]\ , \ l]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsConstructor", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsConstructor[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a constructor symbol and False otherwise.\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(IsConstructor[c_?AtomQ]\  /; \ 
        c\[LeftDoubleBracket]0\[RightDoubleBracket]\  =!= \ Symbol\  := \ 
      True; \nIsConstructor[_]\  := \ False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsPolyValue", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsPolyValue[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " denotes a CFLP value, and False otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsPolyValue[_Real | _Rational | _Integer | _Complex] := True; \n
    IsPolyValue[s_Symbol] /; Not[IsVar[s]] := True; \n
    IsPolyValue[_?\((Or[IsConstructor[#], IsExternal[#]]&)\)[args__]] := 
      And\ @@\ \((IsPolyValue\ /@\ {args})\); \nIsPolyValue[_] := False; \)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CnstrIdx", "Subsection"],

Cell[TextData[{
  StyleBox["CnstrIdx",
    FontWeight->"Bold"],
  " identifies the current index of the constraint set sent to the constraint \
scheduler."
}], "Text"],

Cell[BoxData[
    \(\(CnstrIdx := 0; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Shared Variables", "Section"],

Cell[CellGroupData[{

Cell["Shared Variables Visible from the Outside: Vars.", "Subsection"],

Cell[CellGroupData[{

Cell["Vars", "Subsubsection"],

Cell[TextData[{
  StyleBox["Vars",
    FontWeight->"Bold"],
  " is a table with entries for the variables of the queries submitted to the \
scheduler. \n",
  StyleBox["Vars[1]",
    FontWeight->"Bold"],
  " is the list of variables of the first query, \[Ellipsis], ",
  StyleBox["Vars[CnstrIdx]",
    FontWeight->"Bold"],
  " is the list of variables for the ",
  StyleBox["CnstrIdx",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\^th\)]],
  " query."
}], "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Private Shared Variables & Tables:  ConstraintTree, Answer, \
NodeStatus.\
\>", "Subsection"],

Cell[CellGroupData[{

Cell["Answer", "Subsubsection"],

Cell[TextData[{
  StyleBox["Answer",
    FontWeight->"Bold"],
  " is a container for the results (partial solutions) returned by contraint \
solvers."
}], "Text",
  CellTags->"answer"]
}, Open  ]],

Cell[CellGroupData[{

Cell["NodeStatus", "Subsubsection"],

Cell[TextData[{
  StyleBox["NodeStatus[{ ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold"], "1"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] ,",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold"], "k"]}], TraditionalForm]]],
  StyleBox["}]",
    FontWeight->"Bold"],
  " keeps the current state of the solving process of ",
  StyleBox["ConstraintTree\[LeftDoubleBracket] ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["i",
            FontWeight->"Bold"], "1"], TraditionalForm]]],
  StyleBox[", \[Ellipsis] ,",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["i",
              FontWeight->"Bold"], "k"]}], TraditionalForm]]],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[RightDoubleBracket] ",
    FontWeight->"Bold"],
  ".\nA node can be in one of the following states: \"idle\"(the node is not \
currently processed), \"waiting\"(the node waits for the generation of a \
son), \"done\"(the node is a leaf node), and \"ready\" (a son node is \
available in  ",
  StyleBox[ButtonBox["Answer",
    ButtonData:>"answer",
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{
          StyleBox["  ",
            FontWeight->"Bold"], 
          RowBox[{
            StyleBox["[",
              FontWeight->"Bold"], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            RowBox[{
              StyleBox["{",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              RowBox[{
                SubscriptBox[
                  StyleBox["i",
                    FontWeight->"Bold"], "1"], 
                StyleBox[",",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox["\[Ellipsis]",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[" ",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                StyleBox[",",
                  FontWeight->"Bold",
                  FontSlant->"Italic"], 
                FormBox[
                  RowBox[{" ", 
                    SubscriptBox[
                      StyleBox["i",
                        FontWeight->"Bold"], "k"]}],
                  "TraditionalForm"]}], " ", 
              StyleBox["}",
                FontWeight->"Bold"]}], 
            StyleBox[" ",
              FontWeight->"Bold"], 
            StyleBox["]",
              FontWeight->"Bold"]}], 
          StyleBox[" ",
            FontWeight->"Bold"]}], TraditionalForm]]],
  "). By default, all nodes are in an  \"idle\" state."
}], "Text"],

Cell[BoxData[
    \(\(NodeStatus[_] := "\<idle\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Interface Scheduler/Constraint Solvers.", "Section"],

Cell[CellGroupData[{

Cell["Communication with external solvers", "Subsection"],

Cell[CellGroupData[{

Cell["SetCSQuery", "Subsubsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["SetCSQuery[",
    FontWeight->"Bold"],
  StyleBox[" cs, \[Sigma], vars, elims ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of constraints generated by a CFLP refutation\n",
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : variable substitution generated by a CFLP refutation\n",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the list of basic variables of ",
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["elims",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": the list of eliminable variables of ",
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tget data available from ",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " and produce a query to the constraint scheduler."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(SetCSQuery[cs_, \[Sigma]_, vars_, elims_] := \n\t
      \(Block[{\n\t\t\te, tmp\[Sigma], new\[Sigma] = \[Sigma], newcs = {}, \n
          \t\t\toldcs = cs, tvars = vars}, \n\t\t
        \(Vars[\(++CnstrIdx\)] = Union[vars, elims]; \)\n
          \t\t (*\ preprocess\ cs\ *) \n\t\t
          While[oldcs =!= {}, \n\t\t\te = First[oldcs]; \n\t\t\t
            tmp\[Sigma] = 
              If[MatchQ[e, eq[_?IsVar, _?IsPolyTerm]], \n
                \t\t\t\t\t{
                  e\[LeftDoubleBracket]1\[RightDoubleBracket] -> 
                    e\[LeftDoubleBracket]2\[RightDoubleBracket]}, \n\t\t\t\t\t
                If[MatchQ[e, eq[_?IsPolyTerm, _?IsVar]], \n
                  \t\t\t\t\t\t{
                    e\[LeftDoubleBracket]2\[RightDoubleBracket] -> 
                      e\[LeftDoubleBracket]1\[RightDoubleBracket]}, \n
                  \t\t\t\t\t\t{}\n\t\t\t\t\t]\n\t\t\t\t]; \n\t\t\t
            oldcs = Rest[oldcs]; \n\t\t\t
            If[tmp\[Sigma] === {}, \n\t\t\t\tAppendTo[newcs, e], \n\t\t\t\t
              new\[Sigma] = Join[new\[Sigma], tmp\[Sigma]]; \n\t\t\t\t
              oldcs = ApplySubst[oldcs, tmp\[Sigma]]; \n\t\t\t\t
              newcs = ApplySubst[newcs, tmp\[Sigma]]; \n\t\t\t\t
              tvars = GetVars[tvars /. tmp\[Sigma]]\n\t\t\t]\n\t\t]; \n\t\t
        SchPrint[{"\<\[DoubleRightArrow]\>", 
            \[Bullet]cnstr[new\[Sigma], MethodList, tvars, newcs]}]; \n\t\t
        AppendTo[ConstraintTree, 
          \[Bullet]cnstr[new\[Sigma], MethodList, tvars, newcs]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Ask"]], "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Ask[ ",
    FontWeight->"Bold"],
  StyleBox["meth ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  StyleBox["\n"],
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" : a method identifier\n"],
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["get the data available from the links associated with "],
  StyleBox["meth. ",
    FontSlant->"Italic"],
  StyleBox["The data will be stored in "],
  StyleBox["Answer",
    FontWeight->"Bold"],
  StyleBox["[ "],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[" ] as follows:\n"],
  StyleBox["Answer",
    FontWeight->"Bold"],
  StyleBox["[ "],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[" ] = {"],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", { "],
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]]],
  StyleBox[", "],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]]],
  StyleBox[" },\[Ellipsis]., { "],
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]]],
  StyleBox[","],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]]],
  StyleBox[" }} where:\n\[Diamond]"],
  StyleBox[" vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" are the new variables introduced by a "],
  StyleBox["meth",
    FontSlant->"Italic"],
  StyleBox["-solver for expressing the solutions of "],
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  StyleBox["[ "],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[" ]\n\[Diamond] { "],
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_j\)\)]]],
  StyleBox[", "],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_j\)\)]]],
  StyleBox[" } represents the "],
  StyleBox["j",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["-th solution of "],
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  StyleBox["[ "],
  StyleBox["i",
    FontSlant->"Italic"],
  StyleBox[" ] returned by a "],
  StyleBox["meth",
    FontSlant->"Italic"],
  StyleBox["-solver (1 \[LessEqual] "],
  StyleBox["j",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" \[LessEqual] "],
  StyleBox["m",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["): "],
  StyleBox["\[Sigma]",
    FontWeight->"Bold"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_j\)\)],
    FontWeight->"Bold"]],
  StyleBox[" is a substitution and "],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[Cell[BoxData[
      \(TraditionalForm\`\(\ \_j\)\)]]],
  StyleBox[" is a system (list) of constraints. "]
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{\(Ask[meth_]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", "\n", "\t\t", 
          RowBox[{
          \({IDX, sol, tmpList = {}, tmpAnswer, \n\t\t\tit, 
              itlim = Length[SolverList[meth]], \n\t\t\telem}\), ",", "\n", 
            "\t\t", 
            RowBox[{
              RowBox[{"For", "[", 
                RowBox[{
                \(it = 1\), ",", \(it <= itlim\), ",", \(it++\), ",", "\n", 
                  "\t\t\t", 
                  RowBox[{
                  \(elem = 
                      \(SolverList[meth]\)\[LeftDoubleBracket]it
                        \[RightDoubleBracket]\), ";", "\n", "\t\t\t", 
                    RowBox[{"If", "[", 
                      RowBox[{
                      \(elem\[LeftDoubleBracket]2\[RightDoubleBracket] === 
                          "\<idle\>"\), ",", "\n", "\t\t\t\t", 
                        \(AppendTo[tmpList, elem]\), ",", "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                          \(LinkReadyQ[
                              elem\[LeftDoubleBracket]1\[RightDoubleBracket]]
                              \), ",", "\n", "\t\t\t\t\t", 
                            RowBox[{
                            \(While[
                                LinkReadyQ[
                                  elem\[LeftDoubleBracket]1
                                    \[RightDoubleBracket]], 
                                sol = 
                                  LinkRead[
                                    elem\[LeftDoubleBracket]1
                                      \[RightDoubleBracket]]]\), ";", "\n", 
                              "\t\t\t\t\t", 
                              \(tmpAnswer = 
                                sol\[LeftDoubleBracket]1
                                    \[RightDoubleBracket] /. {Equal -> eq}\), 
                              ";", "\n", "\t\t\t\t\t", 
                              \({IDX, sol} = tmpAnswer\), ";", "\n", 
                              "\t\t\t\t\t", 
                              \(AppendTo[
                                tmpList, {
                                  elem\[LeftDoubleBracket]1
                                    \[RightDoubleBracket], "\<idle\>"}]\), 
                              ";", "\n", "\t\t\t\t\t", 
                              RowBox[{\(NodeStatus[IDX]\), "=", 
                                StyleBox["\"\<ready\>\"",
                                  FontColor->RGBColor[1, 0, 0]]}], 
                              StyleBox[";",
                                FontColor->RGBColor[1, 0, 0]], "\n", 
                              "\t\t\t\t\t", \(Answer[IDX] = sol\), ";", "\n", 
                              "\t\t\t\t\t", 
                              \(SchPrint[{meth, "\<[\>", 
                                  elem\[LeftDoubleBracket]1, 2
                                    \[RightDoubleBracket], "\<,\>", 
                                  elem\[LeftDoubleBracket]1, 3
                                    \[RightDoubleBracket], 
                                  "\<] \[DoubleRightArrow] \>", \n
                                  \t\t\t\t\t\t\t\t
                                  Map[Join[First[#], Last[#]]&, Last[sol]]}]
                                \)}], ",", "\n", "\t\t\t\t\t", 
                            \(AppendTo[tmpList, elem]\)}], "\n", "\t\t\t\t", 
                          "]"}]}], "\n", "\t\t\t", "]"}]}]}], "\n", "\t\t", 
                "]"}], ";", "\n", "\t\t", \(SolverList[meth] = tmpList\)}]}], 
          "\n", "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MethodSolve", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["MethodSolve[ ",
    FontWeight->"Bold"],
  StyleBox["meth, lnk ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["][ ",
    FontWeight->"Bold"],
  StyleBox["cs, id",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellTags->"MethodSolve"],

Cell[TextData[{
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : a method identifier\n",
  StyleBox["lnk",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : link to a ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "-solver\n",
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : system of constraints (list format)\n",
  StyleBox["id",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : unique identifier of ",
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " in the solution search tree"
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[StyleBox["Effect",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Text"],

Cell["...", "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Implementation ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Bold"],
  StyleBox["Linear",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[")",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellDingbat->None],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(MethodSolve["\<Linear\>", lnk_]\)[Cs_, idx_]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({Vs = GetVars[Cs], gv}\), ",", "\n", "\t\t", 
            RowBox[{\(gv = GV \[Intersection] Vs\), ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{
                \(gv === {}\), ",", "\n", "\t\t\t", 
                  \(NodeStatus[idx] = "\<ready\>"; \n\t\t\t
                  Answer[idx] = {{}, {{{}, Cs}}}; \n\t\t\t"\<idle\>"\), ",", 
                  "\n", "\t\t\t", 
                  RowBox[{
                  \(SchPrint[{Cs, "\<\[DoubleRightArrow] Linear[\>", 
                        lnk\[LeftDoubleBracket]2\[RightDoubleBracket], 
                        "\<,\>", 
                        lnk\[LeftDoubleBracket]3\[RightDoubleBracket], 
                        "\<]\>"}]\), ";", "\n", "\t\t\t", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"LinkWrite", "[", 
                          RowBox[{"#4", ",", "\n", "\t\t\t\t", 
                            RowBox[{"Unevaluated", "[", 
                              RowBox[{"EvaluatePacket", "[", 
                                RowBox[{"{", 
                                  RowBox[{"#5", ",", 
                                    RowBox[{
                                      StyleBox["Linear`LinSolve",
                                        FontColor->RGBColor[1, 0, 0]], "[", 
                                      " ", \(#1, #2, #6\), "]"}]}], "}"}], 
                                "]"}], "]"}]}], "]"}], "&"}], "[", "\n", 
                      "\t\t\t\t", \(Cs /. eq -> Equal, gv, Vs, lnk, idx, 
                      Complement[Vs, gv]\), "]"}], ";", "\n", "\t\t\t", 
                    "\"\<waiting\>\""}]}], "\n", "\t\t", "]"}]}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(idx\)\" is similar to \
existing symbol \"\!\(IDX\)\"."\)], "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Implementation ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Bold"],
  StyleBox["Polynomial",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[")",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(MethodSolve["\<Polynomial\>", lnk_]\)[Cs_, idx_]\), ":=", "\n", 
        "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({Vs = GetVars[Cs], gv}\), ",", "\n", "\t\t", 
            RowBox[{\(gv = GV \[Intersection] Vs\), ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{
                \(gv === {}\), ",", "\n", "\t\t\t", 
                  \(NodeStatus[idx] = "\<ready\>"; \n\t\t\t
                  Answer[idx] = {{}, {{{}, Cs}}}; \n\t\t\t"\<idle\>"\), ",", 
                  "\n", "\t\t\t", 
                  RowBox[{
                  \(SchPrint[{Cs, gv, "\<,\>", Complement[Vs, gv], 
                        "\<\[DoubleRightArrow] Polynomial[\>", 
                        lnk\[LeftDoubleBracket]2\[RightDoubleBracket], 
                        "\<,\>", 
                        lnk\[LeftDoubleBracket]3\[RightDoubleBracket], 
                        "\<]\>"}]\), ";", "\n", "\t\t\t", 
                    RowBox[{
                      RowBox[{
                        RowBox[{"LinkWrite", "[", 
                          RowBox[{"#4", ",", "\n", "\t\t\t\t", 
                            RowBox[{"Unevaluated", "[", 
                              RowBox[{"EvaluatePacket", "[", 
                                RowBox[{"{", 
                                  RowBox[{"#5", ",", 
                                    RowBox[{
                                      StyleBox["Polynomial`PolySolve",
                                        FontColor->RGBColor[1, 0, 0]], "[", 
                                      " ", \(#1, #2, #6\), "]"}]}], "}"}], 
                                "]"}], "]"}]}], "]"}], "&"}], "[", "\n", 
                      "\t\t\t\t", \(Cs /. eq -> Equal, gv, Vs, lnk, idx, 
                      Complement[Vs, gv]\), "]"}], ";", "\n", "\t\t\t", 
                    "\"\<waiting\>\""}]}], "\n", "\t\t", "]"}]}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Implementation ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Bold"],
  StyleBox["Derivative",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[")",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(MethodSolve["\<Derivative\>", lnk_]\)[Cs_, idx_]\), ":=", "\n", 
        "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
            \(SchPrint[{Cs, "\<\[DoubleRightArrow] Derivative[\>", 
                  lnk\[LeftDoubleBracket]2\[RightDoubleBracket], "\<,\>", 
                  lnk\[LeftDoubleBracket]3\[RightDoubleBracket], "\<]\>"}]\), 
              ";", "\n", "\t\t", 
              RowBox[{
                RowBox[{
                  RowBox[{"LinkWrite", "[", 
                    RowBox[{"#2", ",", "\n", "\t\t\t", 
                      RowBox[{"Unevaluated", "[", 
                        RowBox[{"EvaluatePacket", "[", 
                          RowBox[{"{", 
                            RowBox[{"#3", ",", 
                              RowBox[{
                                StyleBox["Derivative`DiffSolve",
                                  FontColor->RGBColor[1, 0, 0]], "[", " ", 
                                "#1", "]"}]}], "}"}], "]"}], "]"}]}], "]"}], 
                  "&"}], "[", "\n", "\t\t\t", \(Cs /. eq -> Equal, lnk, idx
                \), "]"}], ";", "\n", "\t\t", "\"\<waiting\>\""}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox["Implementation ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["(",
    FontWeight->"Bold"],
  StyleBox["PartialDerivative",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[")",
    FontWeight->"Bold"]
}], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\(MethodSolve["\<PartialDerivative\>", lnk_]\)[Cs_, idx_]\), ":=", 
        "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
            \(SchPrint[{Cs, "\<\[DoubleRightArrow] PartialDerivative[\>", 
                  lnk\[LeftDoubleBracket]2\[RightDoubleBracket], "\<,\>", 
                  lnk\[LeftDoubleBracket]3\[RightDoubleBracket], "\<]\>"}]\), 
              ";", "\n", "\t\t", 
              RowBox[{
                RowBox[{
                  RowBox[{"LinkWrite", "[", 
                    RowBox[{"#2", ",", "\n", "\t\t\t", 
                      RowBox[{"Unevaluated", "[", 
                        RowBox[{"EvaluatePacket", "[", 
                          RowBox[{"{", 
                            RowBox[{"#3", ",", 
                              RowBox[{
                                StyleBox["PartialDerivative`PDiffSolve",
                                  FontColor->RGBColor[1, 0, 0]], "[", " ", 
                                "#1", "]"}]}], "}"}], "]"}], "]"}]}], "]"}], 
                  "&"}], "[", "\n", "\t\t\t", \(Cs /. eq -> Equal, lnk, idx
                \), "]"}], ";", "\n", "\t\t", "\"\<waiting\>\""}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Clasifiers", "Section"],

Cell[CellGroupData[{

Cell["GetNeededEqs", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tGetNeededEqs[ ",
    FontWeight->"Bold"],
  StyleBox["eqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\teqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a system (list) of constraints\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["The subsystem of ",
    FontSlant->"Plain"],
  StyleBox["eqs",
    FontWeight->"Bold"],
  StyleBox[" whose variables are related to the principal variables of ",
    FontSlant->"Plain"],
  StyleBox["eqs",
    FontWeight->"Bold"],
  StyleBox[".",
    FontSlant->"Plain"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker,
  FontSlant->"Italic"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(GetNeededEqs[eqs_] := \n\t
      Block[{nv = GV, neweqs, oldeqs = eqs}, \n\t\t
        While[True, \n\t\t\t
          neweqs = 
            Select[oldeqs, \((GetVars[#] \[Intersection] nv =!= {})\)&]; \n
          \t\t\tIf[neweqs === {}, Return[Complement[eqs, oldeqs]]]; \n\t\t\t
          nv = Union[nv, GetVars[neweqs]]; \n\t\t\t
          oldeqs = Complement[oldeqs, neweqs]\n\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsVar", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsVar[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a constraint variable (i.e., it belongs to ",
  StyleBox["Vars[CnstrIdx]",
    FontWeight->"Bold"],
  ")\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(IsVar[x_] := MemberQ[Vars[CnstrIdx], x]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsPolyTerm", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsPolyTerm[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if  ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  denotes a polynomial term\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[IsPolyTerm]; \nIsPolyTerm[_?IsVar | _?IsPolyValue] := True; \n
    IsPolyTerm[\((Plus | Times)\)[x_, y__]] := 
      IsPolyTerm[x]\  \[And] \ IsPolyTerm[Plus[y]]; \n
    IsPolyTerm[Power[_?IsPolyTerm, _Integer | _Rational]] := True; \n
    IsPolyTerm[_] := False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsLinTerm", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsLinTerm[",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tterm ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["True",
    FontWeight->"Bold"],
  " if ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a  ",
  StyleBox["linear",
    FontSlant->"Italic"],
  "  term\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(IsLinTerm[_?IsVar] := True; \n
    IsLinTerm[_Real | _Rational | _Integer | _Complex] := True; \n
    IsLinTerm[Times[\(-1\), x__]] := IsLinTerm[Times[x]]; \n
    IsLinTerm[Plus[x_, y__]] := IsLinTerm[x]\  \[And] \ IsLinTerm[Plus[y]]; \n
    IsLinTerm[_] := False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary functions", "Section"],

Cell[CellGroupData[{

Cell["GetVars", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tGetVars[",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe (list of) variables of ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(GetVars[t_] := Union[Cases[{t}, \ _Symbol?IsVar, \ \(-1\)]]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constraint Preprocessors", "Section"],

Cell[CellGroupData[{

Cell["NewCV", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNewCV[  ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["see implementation",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        StyleBox["NewCV",
          FontWeight->"Bold"], "]"}], ";", "\n", 
      RowBox[{
        RowBox[{
          StyleBox["NewCV",
            FontWeight->"Bold"], "[", "]"}], ":=", \(Module[{z}, z]\)}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Preprocess", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Preprocess[ ",
    FontWeight->"Bold"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ][",
    FontWeight->"Bold"],
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tmeth ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[":",
    FontWeight->"Bold"],
  " a method identifier",
  StyleBox["\n\tcnstrs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "list of constraints\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "An equivalent list of constraints ",
  StyleBox["cnstrs'",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " which is more suitable for a ",
  StyleBox[ButtonBox["meth",
    ButtonData:>"MethodSolve",
    ButtonStyle->"Hyperlink"],
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ButtonBox["-solver",
    ButtonData:>"MethodSolve",
    ButtonStyle->"Hyperlink"],
  ". "
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(\(Preprocess["\<Linear\>"]\)[eqs_] := eqs; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\(Preprocess["\<Polynomial\>"]\)[cs_] := 
      \(Preprocess["\<Linear\>"]\)[cs]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\(Preprocess["\<Derivative\>" | "\<PartialDerivative\>"]\)[cs_] := 
      cs; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Dropped implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic"],

Cell[BoxData[
    \(\(\(Preprocess["\<Linear\>"]\)[eqs_] := \n\t
      Block[{Qterms = 
            Cases[eqs, \n\t\t\t\t\t
              Power[u_, v_Rational] :> {u, Denominator[v]}, \[Infinity]], 
          NewV, \[Pi]exp}, \n\t\t
        If[Qterms === {}, \n\t\t\teqs, \n\t\t\tNewV = NewCV[]; \n\t\t\t
          AppendTo[Vars[CnstrIdx], NewV]; \n\t\t\t
          \[Pi]exp = 
            LCM\ @@\ Cases[
                Qterms, {Qterms\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
                    x_} :> x]; \n\t\t\t
          Append[eqs //. \n
              \t\t\t\t\t{
                Qterms\[LeftDoubleBracket]1, 1\[RightDoubleBracket] :> 
                  NewV^\[Pi]exp, \n\t\t\t\t\t\t
                Power[Power[u_, v_], Rational[x_, y_]] :> Power[u, v*x/y]}, 
            eq[Qterms\[LeftDoubleBracket]1, 1\[RightDoubleBracket], 
              NewV^\[Pi]exp]]\n\t\t]\n\t]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Constraint Filters", "Section"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Filter[ ",
    FontWeight->"Bold"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ][",
    FontWeight->"Bold"],
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\tmeth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : constraint solving method identifier",
  StyleBox["\n\tcnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontSlant->"Italic"],
  ":",
  StyleBox[" ",
    FontWeight->"Bold"],
  "list of constraints\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["See implementation",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "Filter",
  StyleBox["[\"Polynomial\"]",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{
          StyleBox[\(Filter["\<Polynomial\>"]\),
            FontWeight->"Bold"], "[", "Cs_", "]"}], ":=", " ", "\n", 
        \(Block[{}, \n\t
          \(Function[{\ #, Complement[Cs, #]}]\)\n\t\t\t[
            Select[Cs, MatchQ[#, eq[_?IsPolyTerm, _?IsPolyTerm]]&]]\n\t]\)}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Filter",
  StyleBox["[\"",
    FontWeight->"Bold"],
  StyleBox["Linear",
    FontWeight->"Bold"],
  StyleBox["\"]",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(\(Filter["\<Linear\>"]\)[Cs_]\),
          FontWeight->"Bold"], 
        StyleBox[":=",
          FontWeight->"Bold"], "\n", "\t", 
        \(Block[{eq1 = {}, eq2 = {}}, \n\t\t
          Scan[\n\t\t\t
            \((If[MatchQ[#, eq[_?IsLinTerm, _?IsLinTerm]], \n\t\t\t\t
                  AppendTo[eq1, #], \n\t\t\t\tAppendTo[eq2, #]\n\t\t\t])\)&, 
            Cs]; {eq1, eq2}]\)}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Filter",
  StyleBox["[\"",
    FontWeight->"Bold"],
  StyleBox["PartialDerivative",
    FontWeight->"Bold"],
  StyleBox["\"]",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\(Filter["\<PartialDerivative\>"]\)[Cs_] := \n\t
      Block[{\n\t\t\teq1 = {}, eq2 = {}, \n\t\t\tf, x, \n\t\t\tlocalCs}, \n
        \t\tlocalCs = 
          Map[{#, Union[
                  Cases[#, 
                    \(\(Derivative[_, __]\)[f_]\)[x__?IsVar] :> {f, {x}}, 
                    \[Infinity]]]}&, Cs]; \n\t\t
        Scan[\n\t\t\t
          If[Length[#\[LeftDoubleBracket]2, 2\[RightDoubleBracket]] != 1, 
              AppendTo[eq2, #\[LeftDoubleBracket]1\[RightDoubleBracket]], 
              AppendTo[eq1, #\[LeftDoubleBracket]2\[RightDoubleBracket]]]&, \n
          \t\t\tTranspose[{Cs, localCs}]\n\t\t]; \n\t\t{eq1, eq2}\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "Filter",
  StyleBox["[\"Derivative\"]",
    FontWeight->"Bold"]
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\(Filter["\<Derivative\>"]\)[Cs_] := \n\t
      Block[{\n\t\t\tmyTransp := \((If[#1 === {}, {}, Transpose[#1]])\)&, \n
          \t\t\teq1 = {}, eq2 = {}, f, x, \n\t\t\tlocalCs}, \n\t\t
        localCs = 
          Map[{#, Map[Union, 
                  myTransp[
                    Cases[#, \(\(Derivative[_]\)[f_]\)[x_?IsVar] -> {f, x}, 
                      \[Infinity]]]]}&, Cs]; \n\t\t
        Scan[\((If[
                Or[Length[#\[LeftDoubleBracket]2, 2\[RightDoubleBracket]] == 
                    0, Length[#\[LeftDoubleBracket]2, 2, 2
                        \[RightDoubleBracket]] != 1], \n\t\t\t\t\t
                AppendTo[eq2, #\[LeftDoubleBracket]1\[RightDoubleBracket]], \n
                \t\t\t\t\t
                AppendTo[eq1, #\[LeftDoubleBracket]2\[RightDoubleBracket]]])
              \)&, \n\t\t\tTranspose[{Cs, localCs}]]; \n
        \t\t{Sort[eq1, OrderedQ[{#1[\([2, 2, 1]\)], #2[\([2, 2, 1]\)]}]&], 
          eq2}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Constraint Scheduler", "Section"],

Cell[CellGroupData[{

Cell["CSolve", "Subsection",
  CellTags->"CSolve"],

Cell[TextData[{
  StyleBox["Syntax calls",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tCSolve[[{",
    FontWeight->"Bold"],
  StyleBox["subst,meths,eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  StyleBox[",idx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]\n\tCSolve[{",
    FontWeight->"Bold"],
  StyleBox["subst,meths,eqs,resteqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  StyleBox[",idx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["subst",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" :",
    FontWeight->"Bold"],
  " current answer substitution",
  StyleBox["\neqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[":",
    FontWeight->"Bold"],
  " the system of equations for the ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solver, where ",
  StyleBox["meth",
    FontSlant->"Italic"],
  " is the first method identifier of ",
  StyleBox["meths",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["resteqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[":",
    FontWeight->"Bold"],
  " equations to be solved by the methods of ",
  StyleBox["meths",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " except the first",
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["meths",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[": ",
    FontWeight->"Bold"],
  "list of constraint solving  methods for ",
  StyleBox["eqs\nidx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" :",
    FontWeight->"Bold"],
  " identifier of the system of constraints {",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ",",
  StyleBox[" resteqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "}"
}], "Text",
  CellMargins->{{45, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation details",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  "A system ",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " of constraints is encoded as a tuple of the form:\n",
  StyleBox["\[LeftAngleBracket]",
    FontWeight->"Bold"],
  " ",
  StyleBox["\[Sigma], meths, vars, eqs, resteqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\[RightAngleBracket]",
    FontWeight->"Bold"],
  ", where \n",
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the current answer substitution of ",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["meths",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of identifiers of the constraint solving methods that must be \
applied to the system ",
  StyleBox["eqs\[Union]resteqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " of constraints\n",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the set of variables of ",
  StyleBox["cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n",
  StyleBox["eqs\[SubsetEqual]cnstrs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the subset of constraints that can be processed by a ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solver, where ",
  StyleBox["meth",
    FontSlant->"Italic"],
  " is the first identifier of ",
  StyleBox["meths",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " \n",
  StyleBox["resteqs=cnstrs-eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Global variables\n",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  "\nAll the constraint systems submitted by the interpreter to the \
constraint scheduler are stored in the global data structure ",
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  ". The index of a constraint system is the position at which the \
representation of the constraint system appears in ",
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  ".  \n",
  StyleBox["NodeStatus",
    FontWeight->"Bold",
    Background->GrayLevel[0.900008]],
  "\n",
  StyleBox["NodeStatus",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["idx",
    FontSlant->"Italic"],
  " ] represents the state of the constraint system with index ",
  StyleBox["idx",
    FontSlant->"Italic"],
  ". A system of ",
  StyleBox["cnstr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " constraints can be in one of the following states: \n\"done\" if it is \
already in solved form; \n\"ready\" if a ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solver is ready to return the results of processing ",
  StyleBox["cnstr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\"idle\" if no ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solver is processing ",
  StyleBox["cnstr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\"waiting\" if a ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solver is processing ",
  StyleBox["cnstr",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(CSolve[\[Bullet]cnstr[\[Sigma]_, Ms_, csvars_, eqs_, 
            resteqs_:  List[]], idx_List]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", "\n", "\t\t", 
          RowBox[{
          \({newVars, CnstrIdx = First[idx], \n\t\t\teqs1, eqs2, i, \n\t\t\t
              GV = csvars, \n\t\t\tmeth, result}\), ",", "\n", "\t\t", 
            RowBox[{"Switch", "[", 
              RowBox[{\(NodeStatus[idx]\), ",", "\n", "\t\t\t", 
                StyleBox["\"\<done\>\"",
                  FontColor->RGBColor[1, 0, 0]], ",", 
                \(\[Bullet]cnstr[{}, {}, {}, eqs]\), ",", "\n", "\t\t\t", 
                StyleBox["\"\<ready\>\"",
                  FontColor->RGBColor[1, 0, 0]], ",", "\n", "\t\t\t", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["IsOver",
                        FontColor->RGBColor[1, 0, 1]], "[", "CnstrIdx", 
                      "]"}], "=", "False"}], ";", "\n", "\t\t\t", 
                  \({newVars, result} = Answer[idx]\), ";", "\n", "\t\t\t", 
                  \(Answer[idx] =. \), ";", "\n", "\t\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{
                    \(result === {}\), ",", "\n", "\t\t\t\t", 
                      \( (*\ detect\ inconsistency\ *) \), "\n", "\t\t\t\t", 
                      RowBox[{
                        RowBox[{\(NodeStatus[idx]\), "=", 
                          StyleBox["\"\<done\>\"",
                            FontColor->RGBColor[1, 0, 0]]}], ";", "\n", 
                        "\t\t\t\t", \(\[Bullet]cnstr[{}, {}, {}, {}]\)}], 
                      ",", "\n", "\t\t\t\t", 
                      RowBox[{
                        RowBox[{\(NodeStatus[idx]\), "=", 
                          StyleBox["\"\<idle\>\"",
                            FontColor->RGBColor[1, 0, 0]]}], ";", "\n", 
                        "\t\t\t\t", 
                        \(If[\((Length[result] == 1)\) \[And] 
                            result\[LeftDoubleBracket]1, 1
                                \[RightDoubleBracket] === {}, \n\t\t\t\t\t
                          \[Bullet]cnstr[\n\t\t\t\t\t\t\[Sigma], \n
                            \t\t\t\t\t\tRest[Ms], \n\t\t\t\t\t\tcsvars, \n
                            \t\t\t\t\t\t
                            Join[result\[LeftDoubleBracket]1, 2
                                \[RightDoubleBracket], \n\t\t\t\t\t\t\t
                              resteqs]\n\t\t\t\t\t], \n\t\t\t\t\t
                          Vars[CnstrIdx] = Join[Vars[CnstrIdx], newVars]; \n
                          \t\t\t\t\t
                          Map[\n\t\t\t\t\t\t
                            \[Bullet]cnstr[
                                ApplySubst[
                                    \[Sigma], #\[LeftDoubleBracket]1
                                      \[RightDoubleBracket]] 
                                  \[Union] #\[LeftDoubleBracket]1
                                    \[RightDoubleBracket], \n\t\t\t\t\t\t\t
                                DeleteCases[MethodList, First[Ms]], \n
                                \t\t\t\t\t\t\t
                                Union[csvars, 
                                  GetVars[#\[LeftDoubleBracket]1
                                      \[RightDoubleBracket]]], \n
                                \t\t\t\t\t\t\t
                                ApplySubst[
                                    Join[resteqs, #\[LeftDoubleBracket]2
                                        \[RightDoubleBracket]], #
                                      \[LeftDoubleBracket]1
                                      \[RightDoubleBracket]] /. \n
                                  \t\t\t\t\t\t\t\t{
                                    eq[u_, u_] :> Sequence[]}]&, \n
                            \t\t\t\t\t\tresult]\t\t\n\t\t\t\t]\)}]}], "\n", 
                    "\t\t\t", "]"}]}], ",", "\n", "\t\t\t", 
                StyleBox["\"\<waiting\>\"",
                  FontColor->RGBColor[1, 0, 0]], ",", "\n", "\t\t\t", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["IsOver",
                        FontColor->RGBColor[1, 0, 1]], "[", "CnstrIdx", 
                      "]"}], "=", "False"}], ";", "\n", "\t\t\t", 
                  \(Ask[First[Ms]]\), ";", "\n", "\t\t\t", 
                  \(\[Bullet]cnstr[\[Sigma], Ms, csvars, eqs, resteqs]\)}], 
                ",", "\n", "\t\t\t", 
                StyleBox["\"\<idle\>\"",
                  FontColor->RGBColor[1, 0, 0]], ",", "\n", "\t\t\t", 
                RowBox[{
                  RowBox[{
                    RowBox[{
                      StyleBox["IsOver",
                        FontColor->RGBColor[1, 0, 1]], "[", "CnstrIdx", 
                      "]"}], "=", "False"}], ";", "\n", "\t\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{
                    \(Ms === {} \[Or] \ eqs === {}\), ",", "\n", "\t\t\t\t", 
                      RowBox[{
                        RowBox[{\(NodeStatus[idx]\), "=", 
                          StyleBox["\"\<done\>\"",
                            FontColor->RGBColor[1, 0, 0]]}], ";", "\n", 
                        "\t\t\t\t", 
                        \(SchPrint[\n\t\t\t\t\t
                          \[Bullet][CnstrIdx, \n\t\t\t\t\t\tVars[CnstrIdx], \n
                            \t\t\t\t\t\t\[Sigma], \n\t\t\t\t\t\t
                            GetNeededEqs[eqs]]\n\t\t\t\t]\), ";", "\n", 
                        "\t\t\t\t", \(\[Bullet]cnstr[{}, {}, {}, {}]\)}], 
                      ",", "\n", "\t\t\t\t", 
                      RowBox[{
                      \(meth = First[Ms]; \), "\n", "\t\t\t\t", 
                        \( (*\ preprocess\ the\ constraints\ *) \), ";", 
                        "\n", "\t\t\t\t", 
                        \({eqs1, eqs2} = 
                          \(Filter[meth]\)[\(Preprocess[meth]\)[eqs]]\), ";", 
                        "\n", "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                          \(Length[eqs1] == 0\), ",", "\n", "\t\t\t\t\t", 
                            \(\[Bullet]cnstr[\[Sigma], Rest[Ms], csvars, eqs]
                              \), ",", "\n", "\t\t\t\t\t", 
                            RowBox[{"Block", "[", 
                              RowBox[{
                                RowBox[{"{", 
                                  RowBox[{"pos", "=", 
                                    RowBox[{"Position", "[", 
                                      RowBox[{\(SolverList[meth]\), ",", 
                                        RowBox[{"{", 
                                        RowBox[{"_", ",", 
                                        StyleBox["\"\<idle\>\"",
                                        FontColor->RGBColor[1, 0, 0]]}], 
                                        "}"}]}], "]"}]}], "}"}], ",", "\n", 
                                "\t\t\t\t\t\t", 
                                \(If[pos =!= {}, \n\t\t\t\t\t\t\t
                                  NodeStatus[idx] = "\<waiting\>"; \n
                                  \t\t\t\t\t\t\t
                                  SolverList[meth] = \n\t\t\t\t\t\t\t\t
                                    MapAt[\n
                                      \t\t\t\t\t\t\t\t\t{#
                                        \[LeftDoubleBracket]1
                                        \[RightDoubleBracket], 
                                        \(MethodSolve[
                                        meth, #\[LeftDoubleBracket]1
                                        \[RightDoubleBracket]]\)[eqs1, 
                                        idx]}&, \n\t\t\t\t\t\t\t\t\t
                                      SolverList[meth], First[pos]]; \n
                                  \t\t\t\t\t\t\t
                                  \[Bullet]cnstr[\[Sigma], Ms, csvars, eqs1, 
                                    eqs2], \n\t\t\t\t\t\t\t
                                  \[Bullet]cnstr[\[Sigma], Ms, csvars, eqs]]
                                  \)}], "]"}]}], "]"}]}]}], "\n", "\t\t\t", 
                    "]"}]}]}], "\n", "\t\t", "]"}]}], "\n", "\t", "]"}]}], 
      ";"}]], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSolve[xs_, _] := xs; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ReturnMessages", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tReturnMessages[",
    FontWeight->"Bold"],
  StyleBox["msg",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "Send back to the interpreter all messages collected in ",
  StyleBox["SchedulerList",
    FontWeight->"Bold"],
  ". Finally, send ",
  StyleBox["msg",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " to the interpreter."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[ReturnMessages]\), ";", "\n", 
      RowBox[{\(ReturnMessages[retmsg_]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"While", "[", 
                RowBox[{
                  RowBox[{
                    StyleBox["SchedulerList",
                      FontColor->RGBColor[0, 0.299992, 0]], "=!=", \({}\)}], 
                  ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"LinkWrite", "[", 
                      RowBox[{"$ParentLink", ",", 
                        RowBox[{"First", "[", 
                          StyleBox["SchedulerList",
                            FontColor->RGBColor[0, 0.299992, 0]], "]"}]}], 
                      "]"}], ";", "\n", "\t\t\t", 
                    RowBox[{
                      StyleBox["SchedulerList",
                        FontColor->RGBColor[0, 0.299992, 0]], "=", 
                      RowBox[{"Rest", "[", 
                        StyleBox["SchedulerList",
                          FontColor->RGBColor[0, 0.299992, 0]], "]"}]}]}]}], 
                "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
              \(LinkWrite[$ParentLink, retmsg]\)}]}], "\t", "\n", "\t", 
          "]"}]}], ";"}]], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Schedule", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tSchedule[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["see implementation",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation details",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  StyleBox["Schedule",
    FontWeight->"Bold"],
  " implements: \n(a) the scheduling algorithm of solving the sets of \
constraints generated by the interpreter. \n(b) the interface of the \
scheduler to the functional logic interpreter."
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "If a message is received from the interpreter, the following actions are \
performed:\n1) If a {",
  StyleBox["\"CSolve\"",
    FontColor->RGBColor[0, 0, 1]],
  ", ",
  StyleBox["info",
    FontSlant->"Italic"],
  "} message is received then:"
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "create a constraint solving query from the data contained in ",
  StyleBox["info",
    FontSlant->"Italic"],
  ". The newly generated query is added to the ",
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  " constraint pool maintained by the Schedule[] routine.\nsend the message ",
  
  StyleBox["\"Query OK\"",
    FontColor->RGBColor[0, 0, 1]],
  " to the interpreter."
}], "Text",
  CellMargins->{{83, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "2) If a {",
  StyleBox["\"SetConstructors\"",
    FontColor->RGBColor[0, 0, 1]],
  ", ",
  StyleBox["info",
    FontSlant->"Italic"],
  " } message is received from the interpreter then:\n\tdeclare as \
constructors for the scheduler the constructor symbols specified in ",
  StyleBox["info",
    FontSlant->"Italic"],
  ",\n\tsend the message ",
  StyleBox["\"Constructors OK\"",
    FontColor->RGBColor[0, 0, 1]],
  " to the interpreter.\n3) If a {",
  StyleBox["\"Confirm\"",
    FontColor->RGBColor[0, 0, 1]],
  "} message is received from the interpreter then:\n\tsend the message ",
  StyleBox["\"Confirmed\"",
    FontColor->RGBColor[0, 0, 1]],
  " to the interpreter\n4) If a {",
  StyleBox["\"GetLinks\"",
    FontColor->RGBColor[0, 0, 1]],
  ",",
  StyleBox[" meth",
    FontSlant->"Italic"],
  "} message is received from the interpreter then\n\tsend to the scheduler a \
message with information about the links available to ",
  StyleBox["meth",
    FontSlant->"Italic"],
  "\[Dash]solvers\n5) If an {",
  StyleBox["\"End\"",
    FontColor->RGBColor[0, 0, 1]],
  "} message is received from the interpreter then: \n\t(a) stop the locally \
running constraint solvers; \n\t(b) break the ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection to the interpreter, \n\t(c) stop the scheduling process.\n6) \
If a {",
  StyleBox["\"GetResults\"",
    FontColor->RGBColor[0, 0, 1]],
  ", ",
  StyleBox["id",
    FontSlant->"Italic"],
  " } message is received from the interpreter then:"
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "send back to the interpreter all messages collected so far on the local \
list ",
  StyleBox["SchedulerList",
    FontWeight->"Bold"],
  " of the scheduler\nsend the message ",
  StyleBox["\"y\"",
    FontColor->RGBColor[0, 0, 1]],
  " if all the solutions computed for the query ",
  StyleBox["id",
    FontSlant->"Italic"],
  " are already generated, and ",
  StyleBox["\"n\"",
    FontColor->RGBColor[0, 0, 1]],
  " otherwise."
}], "Text",
  CellMargins->{{80, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "7) If a {",
  StyleBox["\"Reset\"",
    FontColor->RGBColor[0, 0, 1]],
  "} message is received from the interpreter then: \n\t\[Ellipsis]\n\tsend \
the message ",
  StyleBox["\"Reset OK\"",
    FontColor->RGBColor[0, 0, 1]],
  " back to the interpreter"
}], "Text",
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "While no message is being received from the interpreter, the scheduling \
process acts on the constraints collected so far in the ",
  StyleBox["ConstraintTree",
    FontWeight->"Bold"],
  " constraint tree."
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "The following types of messages are collected on the local list ",
  StyleBox["SchedulerList",
    FontWeight->"Bold"],
  " of the scheduler:"
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  "A) messages for tracing the evolution of the constraint scheduling process\
\nB) messages containing answer solutions; such a message is of the form:\n",
  StyleBox["\[Bullet][idx,vars,\[Sigma],eqs]",
    FontWeight->"Bold"],
  " where:\n",
  StyleBox["idx",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the query index; it uniquely identifies the query received from the \
interpreter\n",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the set of constraint variables\n",
  StyleBox["\[Sigma]",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the computed answer substitution\n",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the susbsystem of constraints which could not be reduced to an answer \
substitution."
}], "Text",
  CellMargins->{{69, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[Schedule]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    RowBox[{\(Schedule[]\), ":=", "\n", "\t", 
      RowBox[{"Block", "[", 
        RowBox[{
          RowBox[{"{", "\n", "\t\t\t", 
            RowBox[{
              RowBox[{
                StyleBox["ConstraintTree",
                  FontColor->RGBColor[0, 0.299992, 0]], "=", \({}\)}], ",", 
              "\n", "\t\t\t", 
              RowBox[{
                StyleBox["SchedulerList",
                  FontColor->RGBColor[0, 0.299992, 0]], "=", \({}\)}], ",", 
              "\n", "\t\t\t", "msg", ",", "retmsg", ",", 
              StyleBox["IsOver",
                FontColor->RGBColor[1, 0, 1]], ",", "id", ",", "itt", ",", 
              "\n", "\t\t\t", \(CnstrIdx = 0\), ",", "pendingLinks", ",", 
              "CSl"}], "}"}], ",", "\n", "\t\t", 
          RowBox[{
            RowBox[{
              RowBox[{
                StyleBox["IsOver",
                  FontColor->RGBColor[1, 0, 1]], "[", "_", "]"}], ":=", 
              "False"}], ";", "\n", "\t\t", \(CSStart[]\), ";", "\n", 
            "\t\t", 
            RowBox[{"While", "[", 
              RowBox[{"True", ",", "\n", "\t\t\t", 
                RowBox[{"If", "[", 
                  RowBox[{
                  \(LinkReadyQ[$ParentLink]\), ",", "\n", "\t\t\t\t", 
                    RowBox[{
                    \(msg = LinkRead[$ParentLink]\), ";", "\n", "\t\t\t\t", 
                      RowBox[{
                        StyleBox["retmsg",
                          FontColor->RGBColor[1, 0, 0]], "=", 
                        RowBox[{"Switch", "[", 
                          RowBox[{"msg", ",", "\n", "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              RowBox[{
                                StyleBox["\"\<CSolve\>\"",
                                  FontColor->RGBColor[0, 0, 1]], ",", "__"}], 
                              "}"}], ",", "\n", "\t\t\t\t\t\t", 
                            \(SetCSQuery\ @@\ Rest[msg]; "\<Query OK\>"\), 
                            ",", "\n", "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              RowBox[{
                                StyleBox["\"\<SetConstructors\>\"",
                                  FontColor->RGBColor[0, 0, 1]], ",", "_"}], 
                              "}"}], ",", "\n", "\t\t\t\t\t\t", 
                            \(SetCSConstrs[CSl = Last[msg]]; 
                            "\<Constructors OK\>"\), ",", "\n", 
                            "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              StyleBox["\"\<Confirm\>\"",
                                FontColor->RGBColor[0, 0, 1]], "}"}], ",", 
                            StyleBox["\"\<Confirmed\>\"",
                              FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                            "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              StyleBox[\("\<GetLinks\>", _\),
                                FontColor->RGBColor[0, 0, 1]], "}"}], ",", 
                            \(\({#\[LeftDoubleBracket]1, 2
                                    \[RightDoubleBracket], #
                                    \[LeftDoubleBracket]1, 3
                                    \[RightDoubleBracket]}&\)/@
                              SolverList[Last[msg]]\), ",", "\n", 
                            "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              StyleBox["\"\<End\>\"",
                                FontColor->RGBColor[0, 0, 1]], "}"}], ",", 
                            \(CSEnd[]; Break[]\), ",", "\n", "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              RowBox[{
                                StyleBox["\"\<GetResults\>\"",
                                  FontColor->RGBColor[0, 0, 1]], ",", "_"}], 
                              "}"}], ",", "\n", "\t\t\t\t\t\t", 
                            \(id = Last[msg]; \n\t\t\t\t\t\t
                            If[IsOver[id], \n\t\t\t\t\t\t\t
                              ReturnMessages["\<y\>"], \n\t\t\t\t\t\t\t
                              ReturnMessages["\<n\>"]; \n\t\t\t\t\t\t\t
                              ConstraintTree = MapIdx[ConstraintTree]\n
                              \t\t\t\t\t\t]; "\<!\>"\), ",", "\n", 
                            "\t\t\t\t\t\t", 
                            RowBox[{"{", 
                              StyleBox["\"\<Reset\>\"",
                                FontColor->RGBColor[0, 0, 1]], "}"}], ",", 
                            "\n", "\t\t\t\t\t\t", 
                            RowBox[{
                            \(pendingLinks = 
                                Cases[\n\t\t\t\t\t\t\t\t
                                  Union\ @@\ 
                                    Map[CSLaunch`SolverList, 
                                      CSLaunch`MethodList], \n
                                  \t\t\t\t\t\t\t\t{x_, "\<waiting\>"} :> x]
                                  \), ";", "\n", "\t\t\t\t\t\t", 
                              \(While[pendingLinks =!= {}, \n\t\t\t\t\t\t\t\t
                                pendingLinks = 
                                  pendingLinks /. \n
                                    \t\t\t\t\t\t\t\t\t\t{
                                      x_LinkObject?LinkReadyQ :> 
                                        \((LinkRead[x]; {})\)}; \n
                                \t\t\t\t\t\t\t\t
                                pendingLinks = Complement[pendingLinks, {}]\n
                                \t\t\t\t\t\t]\), ";", "\n", "\t\t\t\t\t\t", 
                              \(ConstraintTree = {}\), ";", \(CnstrIdx = 0\), 
                              ";", "\n", "\t\t\t\t\t\t", 
                              \(ClearCSConstrs[CSl]\), ";", "\n", 
                              "\t\t\t\t\t\t", 
                              RowBox[{"Clear", "[", 
                                RowBox[{
                                "Vars", ",", "Answer", ",", "NodeStatus", 
                                  ",", 
                                  StyleBox["IsOver",
                                    FontColor->RGBColor[1, 0, 1]]}], "]"}], 
                              ";", "\n", "\t\t\t\t\t\t", 
                              RowBox[{
                                RowBox[{
                                  StyleBox["IsOver",
                                    FontColor->RGBColor[1, 0, 1]], "[", "_", 
                                  "]"}], ":=", "False"}], ";", "\n", 
                              "\t\t\t\t\t\t", 
                              \(NodeStatus[_] := "\<idle\>"\), ";", "\n", 
                              "\t\t\t\t\t\t", 
                              RowBox[{
                                StyleBox["SchedulerList",
                                  FontColor->RGBColor[0, 0.299992, 0]], "=", 
                                \({}\)}], ";", "\n", "\t\t\t\t\t\t", 
                              "\"\<Reset OK\>\""}], ",", "\n", 
                            "\t\t\t\t\t\t", "_", ",", "\"\<??\>\""}], "\n", 
                          "\t\t\t\t\t", "]"}]}], ";", "\n", "\t\t\t\t", 
                      RowBox[{"If", "[", 
                        RowBox[{
                          RowBox[{
                            StyleBox["retmsg",
                              FontColor->RGBColor[1, 0, 0]], "=!=", 
                            "\"\<!\>\""}], ",", 
                          RowBox[{"ReturnMessages", "[", 
                            StyleBox["retmsg",
                              FontColor->RGBColor[1, 0, 0]], "]"}]}], 
                        "]"}]}], ",", "\n", "\t\t\t\t", 
                    \( (*\ link\ is\ not\ ready\ *) \), "\n", "\t\t\t\t", 
                    \(If[ConstraintTree =!= {}, \n\t\t\t\t\t
                      ConstraintTree = MapIdx[ConstraintTree]\n\t\t\t\t]\)}], 
                  "\n", "\t\t\t", "]"}]}], "\n", "\t\t", "]"}], ";", "\n", 
            "\t\t", \(Exit[]\)}]}], "\n", "\t", "]"}]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SchPrint", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[SchPrint]\), ";", "\n", 
      RowBox[{\(SchPrint[xs_]\), ":=", 
        RowBox[{"AppendTo", "[", 
          RowBox[{
            StyleBox["SchedulerList",
              FontColor->RGBColor[0, 0.299992, 0]], ",", "xs"}], "]"}]}], 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MapIdx", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tMapIdx[ ",
    FontWeight->"Bold"],
  StyleBox["tree",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Process (i.e., apply the ",
  ButtonBox["CSolve",
    ButtonData:>"CSolve",
    ButtonStyle->"Hyperlink"],
  " procedure to) the constraint systems of ",
  StyleBox["tree",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text",
  CellMargins->{{47, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
    \(Clear[MapIdx]\), ";", "\n", \(MapIdx[l_, {id_?IsOver}] := l\), ";", 
      "\n", 
      RowBox[{\(MapIdx[l_, {id_}]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{
                RowBox[{
                  StyleBox["IsOver",
                    FontColor->RGBColor[1, 0, 1]], "[", "id", "]"}], "=", 
                "True"}], ";", "\n", "\t\t", 
              \(If[Head[l] === List, \n\t\t\t
                MapIndexed[MapIdx[#1, Prepend[#2, id]]&, l], \n\t\t\t
                CSolve[l, {id}]\n\t\t]\)}]}], "\n", "\t", "]"}]}], ";", "\n", 
      \(MapIdx[{l__}, id_: {}] := 
        MapIndexed[MapIdx[#1, Join[id, #2]]&, {l}]\), ";", "\n", 
      \(MapIdx[\[Bullet]cnstr[u__], id_] := CSolve[\[Bullet]cnstr[u], id]\), 
      ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell[BoxData[
    \(<< Scheduler.m\)], "Input"],

Cell[BoxData[
    \(CSStart[]\)], "Input"],

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \(Scheduler`Privare`CnstrIdx = 0; 
    Scheduler`Private`ConstraintTree = {}\)], "Input"],

Cell[BoxData[
    \(IsVar[x]\)], "Input"],

Cell[BoxData[
    \(IsPolyTerm[y*z]\)], "Input"],

Cell[BoxData[
    \(MatchQ[eq[x, y*z], eq[_?IsVar, _?IsPolyTerm]]\)], "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{19, Automatic}, {Automatic, 13}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{597.562, 842.375},
"PaperOrientation"->"Portrait",
"Magnification"->1},
Magnification->1
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "answer"->{
    Cell[12916, 455, 184, 6, 32, "Text",
      CellTags->"answer"]},
  "MethodSolve"->{
    Cell[27273, 902, 495, 21, 68, "Text",
      CellTags->"MethodSolve"]},
  "CSolve"->{
    Cell[52946, 1824, 50, 1, 45, "Subsection",
      CellTags->"CSolve"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"answer", 88170, 2804},
  {"MethodSolve", 88258, 2807},
  {"CSolve", 88347, 2810}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 65, 1, 102, "Title"],
Cell[1799, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2021, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2088, 66, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4451, 111, 39, 0, 53, "Subtitle"],
Cell[4493, 113, 253, 5, 50, "Text"],

Cell[CellGroupData[{
Cell[4771, 122, 337, 8, 139, "Input",
  InitializationCell->True],
Cell[5111, 132, 140, 2, 39, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5288, 139, 27, 0, 45, "Subsection"],
Cell[5318, 141, 121, 3, 27, "Input",
  InitializationCell->True],
Cell[5442, 146, 125, 3, 27, "Input",
  InitializationCell->True],
Cell[5570, 151, 199, 5, 27, "Input",
  InitializationCell->True],
Cell[5772, 158, 177, 4, 27, "Input",
  InitializationCell->True],
Cell[5952, 164, 245, 5, 27, "Input",
  InitializationCell->True],
Cell[6200, 171, 123, 3, 27, "Input",
  InitializationCell->True],
Cell[6326, 176, 123, 3, 27, "Input",
  InitializationCell->True],
Cell[6452, 181, 118, 3, 27, "Input",
  InitializationCell->True],
Cell[6573, 186, 357, 9, 43, "Input",
  InitializationCell->True],
Cell[6933, 197, 334, 9, 43, "Input",
  InitializationCell->True],
Cell[7270, 208, 129, 3, 27, "Input",
  InitializationCell->True],
Cell[7402, 213, 128, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7579, 222, 34, 0, 64, "Subtitle"],
Cell[7616, 224, 154, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7795, 231, 24, 0, 54, "Section"],
Cell[7822, 233, 128, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7975, 240, 78, 1, 45, "Subsection"],
Cell[8056, 243, 134, 3, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8227, 251, 30, 0, 45, "Subsection"],
Cell[8260, 253, 134, 3, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8431, 261, 29, 0, 45, "Subsection"],
Cell[8463, 263, 315, 9, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8815, 277, 34, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8874, 281, 125, 3, 42, "Subsubsection"],
Cell[9002, 286, 179, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9230, 296, 36, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[9291, 300, 125, 3, 42, "Subsubsection"],
Cell[9419, 305, 186, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9654, 315, 35, 0, 45, "Subsection"],
Cell[9692, 317, 578, 23, 104, "Text"],
Cell[10273, 342, 252, 5, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[10562, 352, 33, 0, 45, "Subsection"],
Cell[10598, 354, 493, 20, 86, "Text"],

Cell[CellGroupData[{
Cell[11116, 378, 125, 3, 42, "Subsubsection"],
Cell[11244, 383, 370, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11663, 396, 30, 0, 45, "Subsection"],
Cell[11696, 398, 167, 5, 32, "Text"],
Cell[11866, 405, 119, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12034, 414, 35, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[12094, 418, 70, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[12189, 422, 29, 0, 42, "Subsubsection"],
Cell[12221, 424, 484, 16, 50, "Text"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12754, 446, 103, 3, 45, "Subsection"],

Cell[CellGroupData[{
Cell[12882, 453, 31, 0, 42, "Subsubsection"],
Cell[12916, 455, 184, 6, 32, "Text",
  CellTags->"answer"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13137, 466, 35, 0, 42, "Subsubsection"],
Cell[13175, 468, 3148, 98, 86, "Text"],
Cell[16326, 568, 128, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[16515, 578, 62, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[16602, 582, 57, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[16684, 586, 35, 0, 42, "Subsubsection"],
Cell[16722, 588, 368, 15, 68, "Text"],
Cell[17093, 605, 751, 26, 86, "Text"],
Cell[17847, 633, 255, 9, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18139, 647, 125, 3, 42, "Subsubsection"],
Cell[18267, 652, 1628, 29, 443, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19944, 687, 45, 0, 45, "Subsection"],
Cell[19992, 689, 550, 23, 104, "Text"],
Cell[20545, 714, 2784, 102, 106, "Text"],

Cell[CellGroupData[{
Cell[23354, 820, 125, 3, 42, "Subsubsection"],
Cell[23482, 825, 3706, 69, 395, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[27237, 900, 33, 0, 45, "Subsection"],
Cell[27273, 902, 495, 21, 68, "Text",
  CellTags->"MethodSolve"],
Cell[27771, 925, 699, 27, 86, "Text"],
Cell[28473, 954, 87, 2, 32, "Text"],
Cell[28563, 958, 111, 2, 32, "Text"],

Cell[CellGroupData[{
Cell[28699, 964, 298, 12, 42, "Subsubsection"],

Cell[CellGroupData[{
Cell[29022, 980, 1969, 37, 235, "Input",
  InitializationCell->True],
Cell[30994, 1019, 173, 3, 39, "Message"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[31216, 1028, 302, 12, 42, "Subsubsection"],
Cell[31521, 1042, 2049, 39, 251, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[33607, 1086, 302, 12, 42, "Subsubsection"],
Cell[33912, 1100, 1348, 28, 139, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[35297, 1133, 285, 11, 42, "Subsubsection"],
Cell[35585, 1146, 1370, 28, 139, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[37016, 1181, 29, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[37070, 1185, 34, 0, 45, "Subsection"],
Cell[37107, 1187, 507, 21, 104, "Text"],
Cell[37617, 1210, 424, 14, 32, "Text"],

Cell[CellGroupData[{
Cell[38066, 1228, 125, 3, 42, "Subsubsection"],
Cell[38194, 1233, 496, 10, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38739, 1249, 27, 0, 45, "Subsection"],
Cell[38769, 1251, 855, 38, 140, "Text"],

Cell[CellGroupData[{
Cell[39649, 1293, 125, 3, 42, "Subsubsection"],
Cell[39777, 1298, 145, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39971, 1307, 32, 0, 45, "Subsection"],
Cell[40006, 1309, 778, 35, 140, "Text"],

Cell[CellGroupData[{
Cell[40809, 1348, 125, 3, 42, "Subsubsection"],
Cell[40937, 1353, 370, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41356, 1366, 31, 0, 45, "Subsection"],
Cell[41390, 1368, 750, 35, 140, "Text"],

Cell[CellGroupData[{
Cell[42165, 1407, 125, 3, 42, "Subsubsection"],
Cell[42293, 1412, 365, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42719, 1426, 38, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[42782, 1430, 29, 0, 45, "Subsection"],
Cell[42814, 1432, 609, 26, 122, "Text"],

Cell[CellGroupData[{
Cell[43448, 1462, 125, 3, 42, "Subsubsection"],
Cell[43576, 1467, 168, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43805, 1478, 43, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[43873, 1482, 27, 0, 45, "Subsection"],
Cell[43903, 1484, 303, 13, 86, "Text"],

Cell[CellGroupData[{
Cell[44231, 1501, 125, 3, 42, "Subsubsection"],
Cell[44359, 1506, 355, 11, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[44763, 1523, 32, 0, 45, "Subsection"],
Cell[44798, 1525, 752, 32, 122, "Text"],
Cell[45553, 1559, 500, 17, 32, "Text"],

Cell[CellGroupData[{
Cell[46078, 1580, 83, 2, 42, "Subsubsection"],
Cell[46164, 1584, 147, 3, 27, "Input",
  InitializationCell->True],
Cell[46314, 1589, 186, 4, 27, "Input",
  InitializationCell->True],
Cell[46503, 1595, 182, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[46722, 1604, 91, 2, 42, "Subsubsection"],
Cell[46816, 1608, 942, 19, 235, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[47819, 1634, 37, 0, 34, "Section"],
Cell[47859, 1636, 841, 36, 140, "Text"],

Cell[CellGroupData[{
Cell[48725, 1676, 100, 4, 45, "Subsection"],

Cell[CellGroupData[{
Cell[48850, 1684, 125, 3, 42, "Subsubsection"],
Cell[48978, 1689, 429, 11, 91, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[49456, 1706, 176, 8, 29, "Subsection"],

Cell[CellGroupData[{
Cell[49657, 1718, 125, 3, 42, "Subsubsection"],
Cell[49785, 1723, 527, 13, 123, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50361, 1742, 187, 8, 29, "Subsection"],

Cell[CellGroupData[{
Cell[50573, 1754, 125, 3, 42, "Subsubsection"],
Cell[50701, 1759, 757, 15, 219, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[51507, 1780, 100, 4, 45, "Subsection"],

Cell[CellGroupData[{
Cell[51632, 1788, 125, 3, 42, "Subsubsection"],
Cell[51760, 1793, 1057, 20, 219, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[52878, 1820, 43, 0, 54, "Section"],

Cell[CellGroupData[{
Cell[52946, 1824, 50, 1, 45, "Subsection",
  CellTags->"CSolve"],
Cell[52999, 1827, 716, 30, 86, "Text"],
Cell[53718, 1859, 1424, 57, 104, "Text"],

Cell[CellGroupData[{
Cell[55167, 1920, 133, 3, 42, "Subsubsection"],
Cell[55303, 1925, 1627, 59, 176, "Text"],
Cell[56933, 1986, 1691, 55, 230, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[58661, 2046, 125, 3, 42, "Subsubsection"],
Cell[58789, 2051, 8441, 152, 1083, "Input",
  InitializationCell->True],
Cell[67233, 2205, 181, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67463, 2216, 36, 0, 45, "Subsection"],
Cell[67502, 2218, 584, 23, 86, "Text"],

Cell[CellGroupData[{
Cell[68111, 2245, 125, 3, 42, "Subsubsection"],
Cell[68239, 2250, 1433, 31, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[69721, 2287, 30, 0, 45, "Subsection"],
Cell[69754, 2289, 305, 13, 86, "Text"],

Cell[CellGroupData[{
Cell[70084, 2306, 133, 3, 42, "Subsubsection"],
Cell[70220, 2311, 358, 8, 68, "Text"],
Cell[70581, 2321, 366, 11, 50, "Text"],
Cell[70950, 2334, 504, 14, 68, "Text"],
Cell[71457, 2350, 1629, 47, 230, "Text"],
Cell[73089, 2399, 553, 17, 50, "Text"],
Cell[73645, 2418, 377, 11, 68, "Text"],
Cell[74025, 2431, 331, 8, 50, "Text"],
Cell[74359, 2441, 265, 7, 32, "Text"],
Cell[74627, 2450, 915, 26, 140, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[75579, 2481, 125, 3, 42, "Subsubsection"],
Cell[75707, 2486, 121, 3, 27, "Input",
  InitializationCell->True],
Cell[75831, 2491, 8117, 146, 859, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[83997, 2643, 30, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[84052, 2647, 125, 3, 42, "Subsubsection"],
Cell[84180, 2652, 354, 9, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84583, 2667, 28, 0, 45, "Subsection"],
Cell[84614, 2669, 344, 15, 68, "Text"],
Cell[84961, 2686, 351, 12, 32, "Text"],

Cell[CellGroupData[{
Cell[85337, 2702, 125, 3, 42, "Subsubsection"],
Cell[85465, 2707, 938, 21, 203, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[86464, 2735, 22, 0, 54, "Section"],
Cell[86489, 2737, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[86658, 2744, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[86868, 2754, 31, 0, 54, "Section"],
Cell[86902, 2756, 47, 1, 27, "Input"],
Cell[86952, 2759, 42, 1, 27, "Input"],
Cell[86997, 2762, 40, 1, 27, "Input"],
Cell[87040, 2765, 107, 2, 27, "Input"],
Cell[87150, 2769, 41, 1, 27, "Input"],
Cell[87194, 2772, 48, 1, 27, "Input"],
Cell[87245, 2775, 78, 1, 27, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

