(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)













BeginPackage["Scheduler`",
	{"TermSyntax`",
		"TypeSyntax`",
		"Types`",
		"Substitutions`",
		"CSLaunch`"
	}
];





Schedule::usage;

CSolve::usage; 

Ask::usage=
  "Ask[meth] gets available data from the link associated with meth.";

GetVars::usage="GetVars[expr] yields the variables of expr.";

Vars::usage=
  "Vars[i] gives the list of variables in \
ConstraintTree\[LeftDoubleBracket]{i,\[Ellipsis]}\[RightDoubleBracket].";

SetCSQuery::usage;

IsPolyTerm::usage;

IsVar::usage;

SetCSConstrs::usage=
  "SetCSConstrs[slist] defines the function `IsConstructor` with value True \
on all elements of `slist`.";

CSClear::usage=
  "CSClear[slist] undefines the function `IsConstructor` for the elements of \
``slist.";

$TLevel::usage="";

MapIdx::usage="";



Off[Solve::"svars",LinkObject::"linkv"];



Begin["`Private`"];



$TLevel=0;
DefaultExternal[];



Clear[MsgQueue];
MsgQueue={};



CSClear[constructors_List]:=Function[IsConstructor[#]=.;#] /@ constructors;





SetCSConstrs[l_List]:=Scan[Function[IsConstructor[#]=True] ,l];





ClearCSConstrs[l_List]:=Scan[Function[IsConstructor[#]=False] , l];





IsConstructor[c_?AtomQ] /; 
    c\[LeftDoubleBracket]0\[RightDoubleBracket] =!= Symbol := True;
IsConstructor[_] := False;







IsPolyValue[_Real|_Rational|_Integer|_Complex]:=True;
IsPolyValue[s_Symbol]/;Not[IsVar[s]]:=True;
IsPolyValue[_?(Or[IsConstructor[#],IsExternal[#]]&)[args__]]:=
  And @@ (IsPolyValue /@ {args});
IsPolyValue[_]:=False;





CnstrIdx:=0;



















NodeStatus[_]:="idle";















SetCSQuery[cs_,\[Sigma]_,vars_,elims_]:=
	Block[{
			e,tmp\[Sigma],new\[Sigma]=\[Sigma],newcs={},
			oldcs=cs,tvars=vars},
		Vars[++CnstrIdx]=Union[vars,elims];
		(* preprocess cs *)
		While[oldcs=!={},
			e=First[oldcs];
			tmp\[Sigma]=If[MatchQ[e,eq[_?IsVar,_?IsPolyTerm]],
					{e\[LeftDoubleBracket]1\[RightDoubleBracket]->
                e\[LeftDoubleBracket]2\[RightDoubleBracket]},
					If[MatchQ[e,eq[_?IsPolyTerm,_?IsVar]],
						{e\[LeftDoubleBracket]2\[RightDoubleBracket]->
                  e\[LeftDoubleBracket]1\[RightDoubleBracket]},
						{}
					]
				];
			oldcs=Rest[oldcs];
			If[tmp\[Sigma]==={},
				AppendTo[newcs,e],
				new\[Sigma]=Join[new\[Sigma],tmp\[Sigma]];
				oldcs=ApplySubst[oldcs,tmp\[Sigma]];
				newcs=ApplySubst[newcs,tmp\[Sigma]];
				tvars=GetVars[tvars/.tmp\[Sigma]]
			]
		];
		SchPrint[{"\[DoubleRightArrow]",
        \[Bullet]cnstr[new\[Sigma],MethodList,tvars,newcs]}];
		AppendTo[ConstraintTree,\[Bullet]cnstr[new\[Sigma],MethodList,tvars,newcs]
	];









Ask[meth_]:=
	Block[
		{IDX,sol,tmpList={},tmpAnswer,
			it,itlim=Length[SolverList[meth]],
			elem},
		For[it=1,it<=itlim,it++,
			elem=SolverList[meth]\[LeftDoubleBracket]it\[RightDoubleBracket];
			If[elem\[LeftDoubleBracket]2\[RightDoubleBracket]==="idle",
				AppendTo[tmpList,elem],
				If[LinkReadyQ[elem\[LeftDoubleBracket]1\[RightDoubleBracket]],
					While[LinkReadyQ[elem\[LeftDoubleBracket]1\[RightDoubleBracket]],
            sol=LinkRead[elem\[LeftDoubleBracket]1\[RightDoubleBracket]]];
					tmpAnswer=sol\[LeftDoubleBracket]1\[RightDoubleBracket]/.{Equal->eq};
					{IDX,sol}=tmpAnswer;
					AppendTo[
            tmpList,{elem\[LeftDoubleBracket]1\[RightDoubleBracket],"idle"}];
					NodeStatus[IDX]="ready";
					Answer[IDX]=sol;
					SchPrint[{meth,"[",elem\[LeftDoubleBracket]1,2\[RightDoubleBracket],",",
              elem\[LeftDoubleBracket]1,3\[RightDoubleBracket],
              "] \[DoubleRightArrow] ",
								Map[Join[First[#],Last[#]]&,Last[sol]]}],
					AppendTo[tmpList,elem]
				]
			]
		];
		SolverList[meth]=tmpList
	];













MethodSolve["Linear",lnk_][Cs_,idx_]:=
	Block[{Vs=GetVars[Cs],gv},
		gv=GV\[Intersection]Vs;
		If[gv==={},
			NodeStatus[idx]="ready";
			Answer[idx]={{},{{{},Cs}}};
			"idle",
			SchPrint[{Cs,"\[DoubleRightArrow] Linear[",
          lnk\[LeftDoubleBracket]2\[RightDoubleBracket],",",
          lnk\[LeftDoubleBracket]3\[RightDoubleBracket],"]"}];
			LinkWrite[#4,
				Unevaluated[EvaluatePacket[{#5,Linear`LinSolve[ #1,#2,#6]}]]]&[
				Cs/.eq->Equal,gv,Vs,lnk,idx,Complement[Vs,gv]];
			"waiting"
		]
	];





MethodSolve["Polynomial",lnk_][Cs_,idx_]:=
	Block[{Vs=GetVars[Cs],gv},
		gv=GV\[Intersection]Vs;
		If[gv==={},
			NodeStatus[idx]="ready";
			Answer[idx]={{},{{{},Cs}}};
			"idle",
			SchPrint[{Cs,gv,",",Complement[Vs,gv],"\[DoubleRightArrow] Polynomial[",
          lnk\[LeftDoubleBracket]2\[RightDoubleBracket],",",
          lnk\[LeftDoubleBracket]3\[RightDoubleBracket],"]"}];
			LinkWrite[#4,
				Unevaluated[EvaluatePacket[{#5,Polynomial`PolySolve[ #1,#2,#6]}]]]&[
				Cs/.eq->Equal,gv,Vs,lnk,idx,Complement[Vs,gv]];
			"waiting"
		]
	];



MethodSolve["Derivative",lnk_][Cs_,idx_]:=
	Block[{},
		SchPrint[{Cs,"\[DoubleRightArrow] Derivative[",
        lnk\[LeftDoubleBracket]2\[RightDoubleBracket],",",
        lnk\[LeftDoubleBracket]3\[RightDoubleBracket],"]"}];
		LinkWrite[#2,
			Unevaluated[EvaluatePacket[{#3,Derivative`DiffSolve[ #1]}]]]&[
			Cs/.eq->Equal,lnk,idx];
		"waiting"
	];



MethodSolve["PartialDerivative",lnk_][Cs_,idx_]:=
	Block[{},
		SchPrint[{Cs,"\[DoubleRightArrow] PartialDerivative[",
        lnk\[LeftDoubleBracket]2\[RightDoubleBracket],",",
        lnk\[LeftDoubleBracket]3\[RightDoubleBracket],"]"}];
		LinkWrite[#2,
			Unevaluated[EvaluatePacket[{#3,PartialDerivative`PDiffSolve[ #1]}]]]&[
			Cs/.eq->Equal,lnk,idx];
		"waiting"
	];











GetNeededEqs[eqs_]:=
	Block[{nv=GV,neweqs,oldeqs=eqs},
		While[True,
			neweqs=Select[oldeqs,(GetVars[#]\[Intersection]nv=!={})&];
			If[neweqs==={},Return[Complement[eqs,oldeqs]]];
			nv=Union[nv,GetVars[neweqs]];
			oldeqs=Complement[oldeqs,neweqs]
		]
	];







IsVar[x_]:=MemberQ[Vars[CnstrIdx],x];







Clear[IsPolyTerm];
IsPolyTerm[_?IsVar|_?IsPolyValue]:=True;
IsPolyTerm[(Plus|Times)[x_,y__]]:=IsPolyTerm[x] \[And] IsPolyTerm[Plus[y]];
IsPolyTerm[Power[_?IsPolyTerm,_Integer|_Rational]]:=True;
IsPolyTerm[_]:=False;







IsLinTerm[_?IsVar]:=True;
IsLinTerm[_Real|_Rational|_Integer|_Complex]:=True;
IsLinTerm[Times[-1,x__]]:=IsLinTerm[Times[x]];
IsLinTerm[Plus[x_,y__]]:=IsLinTerm[x] \[And] IsLinTerm[Plus[y]];
IsLinTerm[_]:=False;









GetVars[t_]:=Union[Cases[{t}, _Symbol?IsVar, -1]];









Clear[NewCV];
NewCV[]:=Module[{z},z];









Preprocess["Linear"][eqs_]:=eqs;

Preprocess["Polynomial"][cs_]:=Preprocess["Linear"][cs];

Preprocess["Derivative"|"PartialDerivative"][cs_]:=cs;













Filter["Polynomial"][Cs_]:= 
Block[{},
	Function[{ #,Complement[Cs,#]}]
			[Select[Cs,MatchQ[#,eq[_?IsPolyTerm,_?IsPolyTerm]]&]]
	];





Filter["Linear"][Cs_]:=
	Block[{eq1={},eq2={}},
		Scan[
			(If[MatchQ[#,eq[_?IsLinTerm,_?IsLinTerm]],
				AppendTo[eq1,#],
				AppendTo[eq2,#]
			])&,Cs];{eq1,eq2}];





Filter["PartialDerivative"][Cs_]:=
	Block[{
			eq1={},eq2={},
			f,x,
			localCs},
		localCs=
      Map[{#,Union[
              Cases[#,Derivative[_,__][f_][x__?IsVar]:>{f,{x}},
                \[Infinity]]]}&,Cs];
		Scan[
			If[Length[#\[LeftDoubleBracket]2,2\[RightDoubleBracket]]!=1,
          AppendTo[eq2,#\[LeftDoubleBracket]1\[RightDoubleBracket]],
          AppendTo[eq1,#\[LeftDoubleBracket]2\[RightDoubleBracket]]]&,
			Transpose[{Cs,localCs}]
		];
		{eq1,eq2}
	];





Filter["Derivative"][Cs_]:=
	Block[{
			myTransp:=(If[#1==={},{},Transpose[#1]])&,
			eq1={},eq2={},f,x,
			localCs},
		localCs=
      Map[{#,Map[Union,
              myTransp[
                Cases[#,Derivative[_][f_][x_?IsVar]->{f,x},\[Infinity]]]]}&,
        Cs];
		Scan[(If[
            Or[Length[#\[LeftDoubleBracket]2,2\[RightDoubleBracket]]==0,
              Length[#\[LeftDoubleBracket]2,2,2\[RightDoubleBracket]]!=1],
					AppendTo[eq2,#\[LeftDoubleBracket]1\[RightDoubleBracket]],
					AppendTo[eq1,#\[LeftDoubleBracket]2\[RightDoubleBracket]]])&,
			Transpose[{Cs,localCs}]];
		{Sort[eq1,OrderedQ[{#1[[2,2,1]],#2[[2,2,1]]}]&],eq2}
	];

















CSolve[\[Bullet]cnstr[\[Sigma]_,Ms_,csvars_,eqs_,resteqs_:List[]],idx_List]:=
	Block[
		{newVars,CnstrIdx=First[idx],
			eqs1,eqs2,i,
			GV=csvars,
			meth,result},
		Switch[NodeStatus[idx],
			"done",\[Bullet]cnstr[{},{},{},eqs],
			"ready",
			IsOver[CnstrIdx]=False;
			{newVars,result}=Answer[idx];
			Answer[idx]=.;
			If[result==={},
				(* detect inconsistency *)
				NodeStatus[idx]="done";
				\[Bullet]cnstr[{},{},{},{}],
				NodeStatus[idx]="idle";
				If[(Length[result]==1)
              \[And]result\[LeftDoubleBracket]1,1\[RightDoubleBracket]==={},
					\[Bullet]cnstr[
						\[Sigma],
						Rest[Ms],
						csvars,
						Join[result\[LeftDoubleBracket]1,2\[RightDoubleBracket],
							resteqs]
					],
					Vars[CnstrIdx]=Join[Vars[CnstrIdx],newVars];
					Map[
						\[Bullet]cnstr[
                ApplySubst[
                    \[Sigma],#\[LeftDoubleBracket]1\[RightDoubleBracket]]
                    \[Union]#\[LeftDoubleBracket]1\[RightDoubleBracket],
							DeleteCases[MethodList,First[Ms]],
							Union[csvars,GetVars[#\[LeftDoubleBracket]1\[RightDoubleBracket]]],
							ApplySubst[
                    Join[resteqs,#\[LeftDoubleBracket]2
                        \[RightDoubleBracket]],#\[LeftDoubleBracket]1
                      \[RightDoubleBracket]]/.
								{eq[u_,u_]:>Sequence[]}]&,
						result]		
				]
			],
			"waiting",
			IsOver[CnstrIdx]=False;
			Ask[First[Ms]];
			\[Bullet]cnstr[\[Sigma],Ms,csvars,eqs,resteqs],
			"idle",
			IsOver[CnstrIdx]=False;
			If[Ms==={}\[Or] eqs==={},
				NodeStatus[idx]="done";
				SchPrint[
					\[Bullet][CnstrIdx,
						Vars[CnstrIdx],
						\[Sigma],
						GetNeededEqs[eqs]]
				];
				\[Bullet]cnstr[{},{},{},{}],
				meth=First[Ms];
				(* preprocess the constraints *);
				{eqs1,eqs2}=Filter[meth][Preprocess[meth][eqs]];
				If[Length[eqs1]==0,
					\[Bullet]cnstr[\[Sigma],Rest[Ms],csvars,eqs],
					Block[{pos=Position[SolverList[meth],{_,"idle"}]},
						If[pos=!={},
							NodeStatus[idx]="waiting";
							SolverList[meth]=
								MapAt[
									{#\[LeftDoubleBracket]1\[RightDoubleBracket],
                      MethodSolve[
                          meth,#\[LeftDoubleBracket]1\[RightDoubleBracket]][
                        eqs1,idx]}&,
									SolverList[meth],First[pos]];
							\[Bullet]cnstr[\[Sigma],Ms,csvars,eqs1,eqs2],
							\[Bullet]cnstr[\[Sigma],Ms,csvars,eqs]]]]
			]
		]
	];

CSolve[xs_,_]:=xs;







Clear[ReturnMessages];
ReturnMessages[retmsg_]:=
	Block[{},
		While[SchedulerList=!={},
			LinkWrite[$ParentLink,First[SchedulerList]];
			SchedulerList=Rest[SchedulerList]
		];
		LinkWrite[$ParentLink,retmsg]	
	];



























Clear[Schedule];

Schedule[]:=
	Block[{
			ConstraintTree={},
			SchedulerList={},
			msg,retmsg,IsOver,id,itt,
			CnstrIdx=0,pendingLinks,CSl},
		IsOver[_]:=False;
		CSStart[];
		While[True,
			If[LinkReadyQ[$ParentLink],
				msg=LinkRead[$ParentLink];
				retmsg=Switch[msg,
						{"CSolve",__},
						SetCSQuery @@ Rest[msg];"Query OK",
						{"SetConstructors",_},
						SetCSConstrs[CSl=Last[msg]];"Constructors OK",
						{"Confirm"},"Confirmed",
						{"GetLinks",_},{#\[LeftDoubleBracket]1,2\[RightDoubleBracket],#
                    \[LeftDoubleBracket]1,3\[RightDoubleBracket]}&/@
              SolverList[Last[msg]],
						{"End"},CSEnd[];Break[],
						{"GetResults",_},
						id=Last[msg];
						If[IsOver[id],
							ReturnMessages["y"],
							ReturnMessages["n"];
							ConstraintTree=MapIdx[ConstraintTree]
						];"!",
						{"Reset"},
						pendingLinks=Cases[
								Union @@ Map[CSLaunch`SolverList,CSLaunch`MethodList],
								{x_,"waiting"}:>x];
						While[pendingLinks=!={},
								pendingLinks=pendingLinks/.
										{x_LinkObject?LinkReadyQ:>(LinkRead[x];{})};
								pendingLinks=Complement[pendingLinks,{}]
						];
						ConstraintTree={};CnstrIdx=0;
						ClearCSConstrs[CSl];
						Clear[Vars,Answer,NodeStatus,IsOver];
						IsOver[_]:=False;
						NodeStatus[_]:="idle";
						SchedulerList={};
						"Reset OK",
						_,"??"
					];
				If[retmsg=!="!",ReturnMessages[retmsg]],
				(* link is not ready *)
				If[ConstraintTree=!={},
					ConstraintTree=MapIdx[ConstraintTree]
				]
			]
		];
		Exit[]
	]





Clear[SchPrint];
SchPrint[xs_]:=AppendTo[SchedulerList,xs];









Clear[MapIdx];
MapIdx[l_,{id_?IsOver}]:=l;
MapIdx[l_,{id_}]:=
	Block[{},
		IsOver[id]=True;
		If[Head[l]===List,
			MapIndexed[MapIdx[#1,Prepend[#2,id]]&,l],
			CSolve[l,{id}]
		]
	];
MapIdx[{l__},id_:{}]:=MapIndexed[MapIdx[#1,Join[id,#2]]&,{l}];
MapIdx[\[Bullet]cnstr[u__],id_]:=CSolve[\[Bullet]cnstr[u],id];



End[];

EndPackage[];















