(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     34884,       1164]*)
(*NotebookOutlinePosition[     35719,       1193]*)
(*  CellTagsIndexPosition[     35675,       1189]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Rewrite Rule Definitions", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of command Def for \
defining rewrite rules.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<RewriteRuleDefs`\>", \n\t{"\<RewriteRules`\>"}]; 
    \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(Def::usage = 
      "\<Def[vars, {rule1, rule2, \[Ellipsis], rulen}] returns \"\[DownTee]\" \
if all rules `rulei` are well typed and \"\[UpTee]\" otherwise. Side effect:\n\
\[Bullet] append the results of encoding rulei (1\[LessEqual]i\[LessEqual]m) \
to RewriteRuleList[f], where f is the head function symbol of rulei. Here, m \
is the index of last well typed rule.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(MkCFLPRule::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = \n\t
      Join[\n\t\t{"\<Variables`\>", "\<TermSyntax`\>", "\<Types`\>", \n
          \t\t\t\t"\<Terms`\>", "\<TypeChecker`\>", 
          "\<Debug`\>"}, $ContextPath]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["FormFunction", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tFormFunction[ ",
    FontWeight->"Bold"],
  StyleBox["params,lvars,term,cnd",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["params,lvars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : lists of Mathematica symbols\n",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a term,\n",
  StyleBox["cnd",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : pair of the form ",
  StyleBox["{ ",
    FontWeight->"Bold"],
  StyleBox["ppeqs, eqs ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}",
    FontWeight->"Bold"],
  " where ",
  StyleBox["ppeqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of parameter passing equations and ",
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a list of initial equations. These four terms are those involved in \
the encoding of a conditional rewrite rule ",
  StyleBox["R.",
    FontWeight->"Bold"]
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tthe encoding corresponding to ",
  StyleBox["R",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  " ",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Subsubsection",
  PageWidth->Infinity,
  CellDingbat->None],

Cell[BoxData[
    StyleBox[
      \(FormFunction[par_, localVar_, t_, {c___}] := \n\t
        Function[par, \n\t\tModule[localVar, RewritesTo[t, c]]\n\t]; \),
      FontFamily->"Courier"]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsCFLPRule", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tIsCFLPRule[",
    FontWeight->"Bold"],
  StyleBox["expr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a valid ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " expression\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "Return ",
  StyleBox["False",
    FontWeight->"Bold"],
  " if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is not a CFLP rewrite rule, and ",
  StyleBox["True",
    FontWeight->"Bold"],
  " if it can be."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[IsCFLPRule]\), ";", "\n", 
      StyleBox[\(IsCFLPRule[_RightArrow | _RewriteRule] := True\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"], "\n", 
      \(IsCFLPRule[DoubleLeftArrow[_RightArrow, _]] := True\), ";", "\n", 
      \(IsCFLPRule[_] := False\), ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MkCFLPRule", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tMkCFLPRule[",
    FontWeight->"Bold"],
  StyleBox["expr ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\texpr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a rule in visual or CFLP representation\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "the CFLP representation of ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Remarks",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\t",
    FontWeight->"Bold"],
  "The CFLP representation of a rule ",
  StyleBox["term1\[Rule]term2\[DoubleLeftArrow]cond",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is ",
  StyleBox["RewriteRule[",
    FontWeight->"Bold"],
  StyleBox["term1,term2,cond",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[MkCFLPRule]\), ";", "\n", 
      StyleBox[
        \(MkCFLPRule[RightArrow[lhs_, rhs_]] := RewriteRule[lhs, rhs, {}]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"], "\n", 
      \(MkCFLPRule[DoubleLeftArrow[RightArrow[lhs_, rhs_], cnd_]] := \n\t
        RewriteRule[lhs, rhs, cnd]\), ";", "\n", 
      \(MkCFLPRule[r_RewriteRule] := r\), ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Def", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tDef[",
    FontWeight->"Bold"],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["}] \n   or\n   \tDef[",
    FontWeight->"Bold"],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",  {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["rule",
            FontWeight->"Bold",
            FontSlant->"Italic"], 
          StyleBox["n",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox["}, TypeCheck->",
    FontWeight->"Bold"],
  StyleBox["b",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  Cell[BoxData[GridBox[{
          {
            StyleBox[
              RowBox[{
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["1",
                      FontWeight->"Bold"]],
                  "TraditionalForm"], ",", " ", "\[Ellipsis]", " ", ",", 
                " ", 
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontWeight->"Bold",
                      FontSlant->"Plain"]],
                  "TraditionalForm"]}],
              FontWeight->"Bold"], ":", \(conditional\ rewrite\ rules\)},
          {
            StyleBox["vars",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
              RowBox[{
              "the", " ", "list", " ", "of", " ", "variables", " ", 
                "appearing", " ", "in", " ", 
                StyleBox[
                  FormBox[
                    RowBox[{" ", 
                      SubscriptBox[
                        StyleBox["rule",
                          FontWeight->"Bold",
                          FontSlant->"Italic"], 
                        StyleBox["1",
                          FontWeight->"Bold"]]}],
                    "TraditionalForm"],
                  FontWeight->"Bold"]}], 
              StyleBox[",",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox["\[Ellipsis]",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[",",
                FontWeight->"Bold"], 
              StyleBox[" ",
                FontWeight->"Bold"], 
              StyleBox[
                FormBox[
                  SubscriptBox[
                    StyleBox["rule",
                      FontWeight->"Bold",
                      FontSlant->"Italic"], 
                    StyleBox["n",
                      FontWeight->"Bold",
                      FontSlant->"Plain"]],
                  "TraditionalForm"],
                FontWeight->"Bold"]}]},
          {
            StyleBox["b",
              FontWeight->"Bold",
              FontSlant->"Italic"], ":", 
            RowBox[{
              StyleBox["True",
                FontWeight->"Bold"], " ", "or", " ", 
              StyleBox["False",
                FontWeight->"Bold"]}]}
          },
        ColumnAlignments->{Left}]]],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tfor every conditional rewrite rule ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " of the form  ",
  StyleBox["f[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["] \[RightArrow] t \[DoubleLeftArrow] ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  " \[And]\[CenterEllipsis]\[And] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["p",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " perform the following steps\n\t\[Diamond] type check ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " only if the option ",
  StyleBox["TypeCheck ->True",
    FontWeight->"Bold"],
  " is specified, or no ",
  StyleBox["TypeCheck",
    FontWeight->"Bold"],
  " option is specified but \n\ttype-checking is switched on; \n\t if ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " is ill typed then give an error message and return \"\[UpTee]\",\n\t\
\[Diamond] add ",
  Cell[BoxData[
      SubscriptBox[
        StyleBox["rule",
          FontWeight->"Bold",
          FontSlant->"Italic"], 
        StyleBox["i",
          FontWeight->"Bold"]]]],
  " to the list of conditional rewrite rules associated with ",
  StyleBox["f",
    FontWeight->"Bold"],
  ". \n\t\[Diamond] Return \"\[DownTee]\" if all conditional rewrite rules \
were successfully inserted in the corresponding rewrite rule lists.\n",
  StyleBox["Remarks",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tThe encoding of a CRR of the form  ",
  StyleBox["f[",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox[" , \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["m",
            FontWeight->"Bold"]], TraditionalForm]]],
  StyleBox["] \[RightArrow] t \[DoubleLeftArrow] ",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]]],
  " \[And]\[CenterEllipsis]\[And] ",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["s",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["p",
            FontWeight->"Bold",
            FontSlant->"Plain"]], TraditionalForm]]],
  " is \n\t",
  StyleBox["Function[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)],
    FontWeight->"Bold"],
  StyleBox["}, Module[{",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_r\)],
    FontWeight->"Bold"],
  StyleBox["}, RewritesTo[t , {",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(x\_1 \[CupCap] \)\)],
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ s\_1\)\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)],
    FontWeight->"Bold"],
  StyleBox["\[CupCap]",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`s\_m\)],
    FontWeight->"Bold"],
  StyleBox["}, {",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["e",
            FontWeight->"Bold",
            FontSlant->"Plain"], 
          StyleBox["1",
            FontWeight->"Bold"]], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] ,",
    FontWeight->"Bold"],
  Cell[BoxData[
      FormBox[
        RowBox[{" ", 
          SubscriptBox[
            StyleBox["e",
              FontWeight->"Bold",
              FontSlant->"Plain"], 
            StyleBox["p",
              FontWeight->"Bold",
              FontSlant->"Plain"]]}], TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["}]]] ",
    FontWeight->"Bold"],
  ",",
  StyleBox["\n\t",
    FontWeight->"Bold"],
  "where ",
  Cell[BoxData[
      \(TraditionalForm\`v\_1\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis] , ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`v\_r\)],
    FontWeight->"Bold"],
  " are the rule variables,",
  StyleBox[" ",
    FontWeight->"Bold"],
  "and is added to the list ",
  StyleBox["RewriteRuleList[f]",
    FontWeight->"Bold"],
  " of conditional rewrite rules \n\tassociated with ",
  StyleBox["f",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Def[{}, True | False, _Integer]\  := "\<\[DownTee]\>"; \)\)], "Input",\

  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(Def[V_List, {rs___?IsCFLPRule}, opts___] := \n\t
      Block[\n\t\t{answer, \n\t\t\tsaveType = DownValues[Type], \n\t\t\t
          oldV = Select[
              V /. {e_Pattern :> 
                    e\[LeftDoubleBracket]1\[RightDoubleBracket]}, IsVar], \n
          \t\t\tnewrs, \n\t\t\ttempV}, \n\t\t
        newrs = {rs} /. {TildeTilde \[Rule] eq}; \n\t\t
        newrs = Map[MkCFLPRule, newrs]; \n\t\ttempV = SetVariables[V]; \n\t\t
        answer = 
          Def[newrs, \n\t\t\t\t
            \(TypeCheck /. {opts}\) /. Options[TSolve`TSolve], 1]; \n\t\t
        ClearVariables[V]; \n\t\tSetVariables[oldV]; \n\t\t
        DownValues[Type] = saveType; \n\t\tanswer]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    RowBox[{
      RowBox[{
        RowBox[{"Def", "[", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                StyleBox[\(RewriteRule[lhs_, rhs_, cnd_]\),
                  ShowSpecialCharacters->False,
                  ShowStringCharacters->True], ",", "rs___RewriteRule"}], 
              "}"}], ",", "tyChk_", ",", "n_Integer"}], "]"}], ":=", "\n", 
        "\t", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"Block", "[", 
              RowBox[{
              \({\n\t\t\t\tsaveType = DownValues[Type], \n\t\t\t\t
                  fsymb\  = \ 
                    If[Head[lhs]\  === \ Symbol, \ lhs, \ Head[lhs]], \n
                  \t\t\t\tCFLPlhs = 
                    If[Head[lhs]\  === \ Symbol, lhs[], ListToCons[lhs]], \n
                  \t\t\t\tCFLPrhs = ListToCons[rhs], \n\t\t\t\t
                  CFLPcnd = WeakListToCons[cnd], \n\t\t\t\tparameter, cond, 
                  lhsV, rhsV, localV}\), ",", "\n", "\t\t\t", 
                RowBox[{
                \(If[Head[CFLPcnd] =!= List, CFLPcnd = List[CFLPcnd]]\), ";", 
                  "\n", "\t\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{"tyChk", ",", "\n", "\t\t\t\t", 
                      RowBox[{"If", "[", 
                        RowBox[{
                          RowBox[{
                            RowBox[{"Tc", "[", 
                              RowBox[{
                                
                                StyleBox[
                                  \(RewriteRule[CFLPlhs, CFLPrhs, 
                                    ToFormula[CFLPcnd]]\),
                                  ShowSpecialCharacters->False,
                                  ShowStringCharacters->True], ",", 
                                \(KeepTypes -> False\)}], "]"}], "===", 
                            "\"\<\[UpTee]\>\""}], ",", "\n", "\t\t\t\t\t", 
                          \(Print["\<Type check error at rule #\>", n]; \n
                          \t\t\t\t\tDownValues[Type] = saveType; \n\t\t\t\t\t
                          Return["\<\[UpTee]\>"]\), ",", "\n", "\t\t\t\t\t", 
                          \(DownValues[Type] = saveType\)}], "\n", 
                        "\t\t\t\t", "]"}]}], "\n", "\t\t\t", "]"}], ";", 
                  "\n", "\t\t\t", 
                  \(If[IsConstructor[fsymb], \n\t\t\t\t\t
                    Print["\<Constructor symbol \>", \ fsymb, \ 
                      "\< redefined as a defined symbol.\>"]; \ \n\t\t\t\t\t
                    IsConstructor[fsymb]\  =. \ ]\), ";", "\n", "\t\t\t", 
                  \(IsDefinedSymbol[fsymb]\  = \ True\), ";", "\n", "\t\t\t", 
                  \(IsFunctionSymbol[fsymb]\  = \ True\), ";", "\n", 
                  "\t\t\t", \({parameter, \ cond}\  = Uniform[CFLPlhs]\), 
                  ";", "\n", "\t\t\t", \(lhsV\  = \ Var[CFLPlhs]\), ";", " ", 
                  "\n", "\t\t\t", \(rhsV\  = \ Var[{CFLPrhs, \ CFLPcnd}]\), 
                  ";", " ", "\n", "\t\t\t", 
                  \(localV\  = \ Union[rhsV, \ lhsV]\), ";", " ", "\n", 
                  "\t\t\t", 
                  RowBox[{"If", "[", 
                    RowBox[{\($CFLPTraceLevel > 0\), ",", "\n", "\t\t\t\t", 
                      RowBox[{
                        RowBox[{"Print", "[", 
                          RowBox[{
                          "\"\<Adding rule #\>\"", ",", "n", ",", 
                            "\"\<: \>\"", ",", 
                            
                            StyleBox[
                              \(RewriteRule\ @@
                                \ {CFLPlhs, CFLPrhs, CFLPcnd}\),
                              ShowSpecialCharacters->False,
                              ShowStringCharacters->True]}], "]"}], ";", 
                        "\n", "\t\t\t\t", 
                        \(PrintVarDecl[localV, \ Complement[rhsV, lhsV]]
                          \)}]}], "\n", "\t\t\t", "]"}], ";", "\n", "\t\t\t", 
                  \(AppendTo[RewriteRuleList[fsymb], \n\t\t\t\t
                    FormFunction[parameter, localV, CFLPrhs, {cond, CFLPcnd}]]
                    \)}]}], "\n", "\t\t", "]"}], ";", "\n", "\t\t", 
            \(Def[{rs}, tyChk, n + 1]\)}], ")"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(Def[___] := 
      \((Print["\<Error: wrong expressions specified as rewrite rules\>"]; 
        "\<\[UpTee]\>")\); \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Flattening", "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{\(Clear[Flattening]\), ";", "\n", 
      StyleBox[
        \(Flattening[s_] := \n\t
          Module[{Global`w}, \n\t\tAppendTo[Cond, ppeq[Global`w, s]]; \n\t\t
            PatternVar = Join[PatternVar, Var[s]]; \n\t\tGlobal`w]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["PrintVarDecl", "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[PrintVarDecl]; \n
    PrintVarDecl[argVset_, argXV_] := \n\t
      Module[\n\t\t{vset = Sort[argVset], xV = Sort[argXV], suffix1, suffix2, 
          \n\t\tmyInfix = 
            Function[{x, y}, If[Length[x] > 1, Infix[x, y], First[x]]], \n\t\t
          suffix = Function[x, If[Length[x] > 1, "\<s\>", "\<\>"]]}, \n\t\t
        Switch[vset, \n\t\t\t{}, \(-1\), \n\t\t\t{__}, 
          Print["\<Symbol\>", suffix[vset], "\< \>", \n\t\t\t\t
            myInfix[vset, "\<,\>"], "\< declared as  variable\>", \ 
            suffix[vset], "\<.\>"]]; \n\t\t
        Switch[xV, \n\t\t\t{}, \(-1\), \n\t\t\t{__}, 
          Print["\<Symbol\>", suffix[xV], "\< \>", \n\t\t\t\t
            myInfix[xV, "\<,\>"], "\< declared as extra variable\>", 
            suffix[xV], "\<.\>"]\n\t\t]\n\t]; \t\t\)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Uniform", "Subsection",
  Evaluatable->False],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tUniform[ ",
    FontWeight->"Bold"],
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  : a term\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text",
  CellMargins->{{17, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left],

Cell[TextData[{
  "if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is a constant then return",
  StyleBox[" {{},{}} \n",
    FontWeight->"Bold"],
  "if  ",
  StyleBox["term",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "  is of the form  ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[
            RowBox[{
              StyleBox["f",
                FontSlant->"Plain"], "[", \(term\_1\)}],
            "TraditionalForm"], ",", "\[Ellipsis]", ",", \(term\_n\)}], 
        TraditionalForm]],
    FontWeight->"Bold"],
  StyleBox["]",
    FontWeight->"Bold"],
  " then return a pair ",
  StyleBox["{vars,eqs}",
    FontWeight->"Bold"],
  " where ",
  StyleBox["vars",
    FontWeight->"Bold"],
  " is a list of ",
  StyleBox["n",
    FontSlant->"Italic"],
  " fresh variables ",
  Cell[BoxData[
      \(TraditionalForm\`w\_1\)],
    FontWeight->"Bold"],
  StyleBox[",\[Ellipsis],",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`w\_n\)],
    FontWeight->"Bold"],
  " and eqs is the list of parameter passing equations ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox[\(w\_i\),
            "TraditionalForm"], "\[CupCap]", \(term\_i\)}], 
        TraditionalForm]],
    FontWeight->"Bold"]
}], "Text",
  CellMargins->{{51, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Example\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Uniform[f[x,r[a],b]]",
    FontWeight->"Bold"],
  " returns the pair \n\t\
{{w$144,w$145,w$146},{w$144\[CupCap]x,w$145\[CupCap]r[a],w$146\[CupCap]b}}"
}], "Text",
  CellMargins->{{17, Inherited}, {Inherited, Inherited}},
  TextAlignment->Left],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
    \(Clear[Uniform]\), ";", "\n", \(Uniform[s_Symbol] := {{}, {}}\), ";", 
      "\n", 
      StyleBox[
        \(Uniform[s_] := \n
          Block[{Cond\  = \ {}, \ PatternVar\  = \ {}}, 
            \ {List\ @@\ \(Flattening\ /@\ s\), \ Cond}]\),
        FontFamily->"Courier"], 
      StyleBox[";",
        FontFamily->"Courier"]}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(On[General::"\<spell\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell[BoxData[
    \(f \[RightArrow] x + {y} // FullForm\)], "Input"],

Cell[BoxData[
    \(f \[RightArrow] x + g[{y}] \[DoubleLeftArrow] {a, b, {c, d}}\)], "Input"],

Cell[BoxData[
    \(<< TSolve.m\)], "Input"],

Cell[BoxData[
    \(Context[ListToCons]\)], "Input"],

Cell[BoxData[
    \(Def[{x, y}, {
        f \[RightArrow] x + g[{y}] \[DoubleLeftArrow] {a, b, {c, d}}}, 
      TypeCheck -> False]\)], "Input"],

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \(Def[{f \[RightArrow] {x + y}}, False, 1]\)], "Input"],

Cell[BoxData[
    \({f \[RightArrow] x + {y}} // FullForm\)], "Input"],

Cell[BoxData[
    \(RewriteRuleList[f] // FullForm\)], "Input"],

Cell[BoxData[
    \(CSEnd[]\)], "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{Automatic, 31}, {-11, Automatic}},
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 80, 1, 102, "Title"],
Cell[1814, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2036, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2103, 66, 2324, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4464, 111, 39, 0, 53, "Subtitle"],
Cell[4506, 113, 109, 3, 32, "Text"],
Cell[4618, 118, 229, 6, 43, "Input",
  InitializationCell->True],
Cell[4850, 126, 131, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5006, 133, 27, 0, 45, "Subsection"],
Cell[5036, 135, 478, 8, 75, "Input",
  InitializationCell->True],
Cell[5517, 145, 123, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5689, 154, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5748, 158, 24, 0, 54, "Section"],
Cell[5775, 160, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[5961, 167, 344, 8, 75, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[6330, 179, 56, 1, 45, "Subsection",
  Evaluatable->False],
Cell[6389, 182, 367, 15, 68, "Text"],
Cell[6759, 199, 943, 34, 86, "Text"],
Cell[7705, 235, 210, 9, 50, "Text"],

Cell[CellGroupData[{
Cell[7940, 248, 165, 7, 42, "Subsubsection"],
Cell[8108, 257, 293, 7, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8450, 270, 54, 1, 45, "Subsection",
  Evaluatable->False],
Cell[8507, 273, 513, 22, 104, "Text"],
Cell[9023, 297, 266, 12, 32, "Text"],

Cell[CellGroupData[{
Cell[9314, 313, 125, 3, 42, "Subsubsection"],
Cell[9442, 318, 440, 10, 75, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9931, 334, 54, 1, 45, "Subsection",
  Evaluatable->False],
Cell[9988, 337, 475, 19, 104, "Text"],
Cell[10466, 358, 220, 7, 32, "Text"],
Cell[10689, 367, 477, 19, 50, "Text"],

Cell[CellGroupData[{
Cell[11191, 390, 125, 3, 42, "Subsubsection"],
Cell[11319, 395, 523, 12, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11891, 413, 47, 1, 45, "Subsection",
  Evaluatable->False],
Cell[11941, 416, 10589, 363, 368, "Text"],

Cell[CellGroupData[{
Cell[22555, 783, 125, 3, 42, "Subsubsection"],
Cell[22683, 788, 240, 7, 27, "Input",
  InitializationCell->True],
Cell[22926, 797, 857, 18, 267, "Input",
  InitializationCell->True],
Cell[23786, 817, 4407, 84, 571, "Input",
  InitializationCell->True],
Cell[28196, 903, 299, 8, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[28544, 917, 54, 1, 45, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[28623, 922, 125, 3, 42, "Subsubsection"],
Cell[28751, 927, 448, 11, 107, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[29248, 944, 56, 1, 29, "Subsection",
  Evaluatable->False],

Cell[CellGroupData[{
Cell[29329, 949, 125, 3, 42, "Subsubsection"],
Cell[29457, 954, 980, 19, 267, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[30486, 979, 51, 1, 29, "Subsection",
  Evaluatable->False],
Cell[30540, 982, 593, 25, 104, "Text"],
Cell[31136, 1009, 1391, 53, 68, "Text"],
Cell[32530, 1064, 347, 10, 68, "Text"],

Cell[CellGroupData[{
Cell[32902, 1078, 125, 3, 42, "Subsubsection"],
Cell[33030, 1083, 468, 13, 91, "Input",
  InitializationCell->True]
}, Closed]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[33559, 1103, 22, 0, 34, "Section"],
Cell[33584, 1105, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[33753, 1112, 130, 3, 27, "Input",
  InitializationCell->True],
Cell[33886, 1117, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[34096, 1127, 31, 0, 54, "Section"],
Cell[34130, 1129, 68, 1, 27, "Input"],
Cell[34201, 1132, 93, 1, 27, "Input"],
Cell[34297, 1135, 44, 1, 27, "Input"],
Cell[34344, 1138, 52, 1, 27, "Input"],
Cell[34399, 1141, 144, 3, 27, "Input"],
Cell[34546, 1146, 40, 1, 27, "Input"],
Cell[34589, 1149, 73, 1, 27, "Input"],
Cell[34665, 1152, 70, 1, 27, "Input"],
Cell[34738, 1155, 63, 1, 27, "Input"],
Cell[34804, 1158, 40, 1, 27, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

