(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     28321,        850]*)
(*NotebookOutlinePosition[     28958,        873]*)
(*  CellTagsIndexPosition[     28914,        869]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[TextData[StyleBox["Examples",
  FontSlant->"Italic",
  FontColor->RGBColor[0, 0, 1]]], "Subtitle",
  TextAlignment->Left,
  FontSize->25],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< TSolve.m\)], "Input"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 1: The 8-Queen Problem", "Subsubsection"],

Cell[BoxData[
    \(TSolve[Queen[8] \[TildeTilde] x, {x, y, m, n}, \n\t
      DefinedFunctionSymbol -> {\n\t\t\t
          NQueen \[Proportion] Int \[ShortRightArrow] TyList[Int], \n\t\t\t
          QueenPos \[Proportion] Int\[Cross]Int \[ShortRightArrow] 
            TyList[Int], \n\t\t\t
          NoAttack \[Proportion] TyList[Int]\[Cross]TyList[Int] 
            \[ShortRightArrow] Bool, \n\t\t\t
          QueenPos \[Proportion] Int \[ShortRightArrow] Int\n\t\t}, \n\t
      Rule -> {\n\t\t\tPos[n] \[RightArrow] m, \n\t\t\t
          NQueen[n] \[RightArrow] QueenPos[1, n], \n\t\t\t
          QueenPos[m, n] \[RightArrow] 
            \[LeftAngleBracket]Pos[n], y\[RightAngleBracket] 
            \[DoubleLeftArrow] 
            \((\((m < n)\) \[TildeTilde] True \[And] 
                \((y \[TildeTilde] QueenPos[m + 1, n])\))\), \n\t\t\t
          QueenPos[n, n] \[RightArrow] {Pos[n]}, \n\t\t}\n]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(a != b // FullForm\)], "Input"],

Cell[BoxData[
    TagBox[
      StyleBox[\(Unequal[a, b]\),
        ShowSpecialCharacters->False,
        ShowStringCharacters->True],
      FullForm]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(DefinedFunctionSymbol[\n\t
      NQueen \[Proportion] Int \[ShortRightArrow] TyList[Int], \n\t
      Pos \[Proportion] Int \[ShortRightArrow] Int, \n\t
      QueenPos \[Proportion] Int\[Cross]Int \[ShortRightArrow] Int, \n\t
      IntegerSet \[Proportion] Int \[ShortRightArrow] Int, \n\t
      Element \[Proportion] Int\[Cross]TyList[Int] \[ShortRightArrow] Int, \n
      \tIntegerSetAux \[Proportion] Int\[Cross]Int \[ShortRightArrow] Int]; 
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[{x, y, m, n, p, q, r}, \n\tNQueen[n] \[RightArrow] QueenPos[1, n], 
      \n\tQueenPos[n, n] \[DoubleLeftArrow] {Pos[n]}, \n\t
      QueenPos[m, n] \[RightArrow] 
        \[LeftAngleBracket]p, q\[RightAngleBracket] \[DoubleLeftArrow] 
        \((\((m < n)\) \[TildeTilde] True \[And] p \[TildeTilde] Pos[n] 
            \[And] q \[TildeTilde] QueenPos[m + 1, n] \[And] 
            NoAttack[p, 1, q, n] \[TildeTilde] True)\), \n\t
      NoAttack[m, p, {}, n] \[RightArrow] True, \n\t
      NoAttack[m, p, \[LeftAngleBracket]q, r\[RightAngleBracket], n] 
        \[RightArrow] Unequal[m, q] \[DoubleLeftArrow] \n\tPos[n] 
        \[RightArrow] m \[DoubleLeftArrow] 
        Element[m, IntegerSet[n]] \[TildeTilde] True, \n\t
      Element[m, \[LeftAngleBracket]m, n\[RightAngleBracket]] \[RightArrow] 
        True, \n\t
      Element[m, \[LeftAngleBracket]p, n\[RightAngleBracket]] \[RightArrow] 
        Element[m, n], \n\tElement[m, {}] \[RightArrow] False, \n\t
      IntegerSet[n] \[RightArrow] 
        \[LeftAngleBracket]1, IntegerSetAux[2, n]\[RightAngleBracket], \n\t
      IntegerSetAux[m, n] \[RightArrow] 
        \[LeftAngleBracket]m, p\[RightAngleBracket] \[DoubleLeftArrow] 
        \((\((m < n)\) \[TildeTilde] True \[And] 
            \((p \[TildeTilde] IntegerSetAux[m + 1, n])\))\), \n\t
      IntegerSetAux[n, n] \[RightArrow] {n}\n]\)], "Input"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{Pos[3] \[TildeTilde] x}, {x, m, n, p, q}, \n\t
      DefinedFunctionSymbol -> {\n\t\t\t
          Pos \[Proportion] Int \[ShortRightArrow] Int, \n\t\t\t
          IntegerSet \[Proportion] Int \[ShortRightArrow] Int, \n\t\t\t
          Element \[Proportion] Int\[Cross]TyList[Int] \[ShortRightArrow] 
            Int, \n\t\t\t
          IntegerSetAux \[Proportion] Int\[Cross]Int \[ShortRightArrow] Int}, 
      \n\tRule -> {\n\t\t\t
          Pos[n] \[RightArrow] m \[DoubleLeftArrow] 
            Element[m, IntegerSet[n]] \[TildeTilde] True, \n\t\t\t
          Element[m, \[LeftAngleBracket]m, n\[RightAngleBracket]] 
            \[RightArrow] True, \n\t\t\t
          Element[m, \[LeftAngleBracket]p, n\[RightAngleBracket]] 
            \[RightArrow] Element[m, n], \n\t\t\t
          Element[m, {}] \[RightArrow] False, \n\t\t\t
          IntegerSet[n] \[RightArrow] 
            \[LeftAngleBracket]1, IntegerSetAux[2, n]\[RightAngleBracket], \n
          \t\t\tIntegerSetAux[m, n] \[RightArrow] 
            \[LeftAngleBracket]m, p\[RightAngleBracket] \[DoubleLeftArrow] 
            \((\((m < n)\) \[TildeTilde] True \[And] 
                \((p \[TildeTilde] IntegerSetAux[m + 1, n])\))\), \n\t\t\t
          IntegerSetAux[n, n] \[RightArrow] {n}}, \n\tTypeCheck -> False]\)], 
  "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(Pos[n] \[RightArrow] m 
          \[DoubleLeftArrow] 
          \(m \[Element] IntegerSet[n]\) \[TildeTilde] True\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          Pos[ n], m, 
          eq[ 
            Element[ m, 
              IntegerSet[ n]], True]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n\),
          Infix[ {m, n}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]m
        \[InvisibleSpace]" declared as extra \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", m, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(\(m \[Element] 
            \[LeftAngleBracket]m, n\[RightAngleBracket]\) \[RightArrow] True
          \)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          Element[ m, 
            Cons[ m, n]], True, True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n\),
          Infix[ {m, n}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(\(m \[Element] 
            \[LeftAngleBracket]p, n\[RightAngleBracket]\) \[RightArrow] 
          \(m \[Element] n\)\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          Element[ m, 
            Cons[ p, n]], 
          Element[ m, n], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n, p\),
          Infix[ {m, n, p}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n, p}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]4
        \[InvisibleSpace]": "\[InvisibleSpace]\(\(m \[Element] \[Bullet]\) 
          \[RightArrow] False\)\),
      SequenceForm[ "Adding rule #", 4, ": ", 
        RewriteRule[ 
          Element[ m, \[Bullet]], False, True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]m
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", m, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]5
        \[InvisibleSpace]": "\[InvisibleSpace]\(IntegerSet[n] \[RightArrow] 
          \[LeftAngleBracket]1, IntegerSetAux[2, n]\[RightAngleBracket]\)\),
      SequenceForm[ "Adding rule #", 5, ": ", 
        RewriteRule[ 
          IntegerSet[ n], 
          Cons[ 1, 
            IntegerSetAux[ 2, n]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]6
        \[InvisibleSpace]": "\[InvisibleSpace]\(IntegerSetAux[m, n] 
          \[RightArrow] \[LeftAngleBracket]m, p\[RightAngleBracket] 
          \[DoubleLeftArrow] 
          \(\(m < n\) \[TildeTilde] True && 
            p \[TildeTilde] IntegerSetAux[1 + m, n]\)\)\),
      SequenceForm[ "Adding rule #", 6, ": ", 
        RewriteRule[ 
          IntegerSetAux[ m, n], 
          Cons[ m, p], 
          And[ 
            eq[ 
              Less[ m, n], True], 
            eq[ p, 
              IntegerSetAux[ 
                Plus[ 1, m], n]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n, p\),
          Infix[ {m, n, p}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n, p}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]p
        \[InvisibleSpace]" declared as extra \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", p, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]7
        \[InvisibleSpace]": "\[InvisibleSpace]\(IntegerSetAux[n, n] 
          \[RightArrow] 
          \[LeftAngleBracket]n, \[Bullet]\[RightAngleBracket]\)\),
      SequenceForm[ "Adding rule #", 7, ": ", 
        RewriteRule[ 
          IntegerSetAux[ n, n], 
          Cons[ n, \[Bullet]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{x \[Rule] 1, m \[Rule] m, n \[Rule] n, p \[Rule] p, q \[Rule] q}, {
        x \[Rule] 2, m \[Rule] m, n \[Rule] n, p \[Rule] p, q \[Rule] q}, {
        x \[Rule] 3, m \[Rule] m, n \[Rule] n, p \[Rule] p, q \[Rule] q}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Set\)\)], "Input"],

Cell[BoxData[
    \("lhs = rhs evaluates rhs and assigns the result to be the value of lhs. \
From then on, lhs is replaced by rhs whenever it appears. {l1, l2, ... } = \
{r1, r2, ... } evaluates the ri, and assigns the results to be the values of \
the corresponding li."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?Element\)\)], "Input"],

Cell[BoxData[
    \(Information::"notfound" \( : \ \) 
      "Symbol \!\(\"Element\"\) not found."\)], "Message"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Constructor[Pos \[Proportion] Int \[ShortRightArrow] Int]\)], "Input"],

Cell[BoxData[
    \({Pos}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefinedFunctionSymbol[
      QueenPos \[Proportion] Int\[Cross]Int \[ShortRightArrow] TyList[Int]]
      \)], "Input"],

Cell[BoxData[
    \({QueenPos}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \("done."\)], "Print"]
}, Open  ]],

Cell[BoxData[
    \(DefinedFunctionSymbol[
      NQueen \[Proportion] Int \[ShortRightArrow] TyList[Int], 
      QueenPos \[Proportion] Int\[Cross]Int \[ShortRightArrow] TyList[Int]]
      \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Constructor[Pos]\)], "Input"],

Cell[BoxData[
    \({Pos}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[{y, m, n}, {\n\t\t\tNQueen[n] \[RightArrow] QueenPos[1, n], \n\t\t\t
        QueenPos[m, n] \[RightArrow] 
          \[LeftAngleBracket]Pos[m], y\[RightAngleBracket] \[DoubleLeftArrow] 
          \((\((m < n)\) \[TildeTilde] True \[And] 
              \((y \[TildeTilde] QueenPos[m + 1, n])\))\), \n\t\t\t
        QueenPos[n, n] \[RightArrow] {Pos[n]}\n\t\t}\n]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(NQueen[n] \[RightArrow] 
          QueenPos[1, n]\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          NQueen[ n], 
          QueenPos[ 1, n], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(QueenPos[m, n] \[RightArrow] 
          \[LeftAngleBracket]Pos[m], y\[RightAngleBracket] \[DoubleLeftArrow] 
          \(\(m < n\) \[TildeTilde] True && 
            y \[TildeTilde] QueenPos[1 + m, n]\)\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          QueenPos[ m, n], 
          Cons[ 
            Pos[ m], y], 
          And[ 
            eq[ 
              Less[ m, n], True], 
            eq[ y, 
              QueenPos[ 
                Plus[ 1, m], n]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n, y\),
          Infix[ {m, n, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]y
        \[InvisibleSpace]" declared as extra \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", y, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(QueenPos[n, n] \[RightArrow] 
          \[LeftAngleBracket]Pos[n], \[Bullet]\[RightAngleBracket]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          QueenPos[ n, n], 
          Cons[ 
            Pos[ n], \[Bullet]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \("\[DownTee]"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearSignature[Pos, NQueen, QueenPos]\)], "Input"],

Cell[BoxData[
    \({Pos, NQueen, QueenPos}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[
      \[LeftAngleBracket]Pos[1], QueenPos[2, 8]\[RightAngleBracket] 
        \[TildeTilde] x, {x, y, m, n}, \n\t
      DefinedFunctionSymbol -> {\n\t\t\t
          NQueen \[Proportion] Int \[ShortRightArrow] TyList[Int], \n\t\t\t
          QueenPos \[Proportion] Int\[Cross]Int \[ShortRightArrow] 
            TyList[Int]\n\t\t}, \n\t
      Constructor -> {Pos \[Proportion] Int \[ShortRightArrow] Int}, \n\t
      Rule -> {\n\t\t\tNQueen[n] \[RightArrow] QueenPos[1, n], \n\t\t\t
          QueenPos[m, n] \[RightArrow] 
            \[LeftAngleBracket]Pos[m], y\[RightAngleBracket] 
            \[DoubleLeftArrow] 
            \((\((m < n)\) \[TildeTilde] True \[And] 
                \((y \[TildeTilde] QueenPos[m + 1, n])\))\), \n\t\t\t
          QueenPos[n, n] \[RightArrow] {Pos[n]}\n\t\t}, \n\t
      TypeCheck -> False]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(NQueen[n] \[RightArrow] 
          QueenPos[1, n]\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          NQueen[ n], 
          QueenPos[ 1, n], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(QueenPos[m, n] \[RightArrow] 
          \[LeftAngleBracket]Pos[m], y\[RightAngleBracket] \[DoubleLeftArrow] 
          \(\(m < n\) \[TildeTilde] True && 
            y \[TildeTilde] QueenPos[1 + m, n]\)\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          QueenPos[ m, n], 
          Cons[ 
            Pos[ m], y], 
          And[ 
            eq[ 
              Less[ m, n], True], 
            eq[ y, 
              QueenPos[ 
                Plus[ 1, m], n]]]]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(m, n, y\),
          Infix[ {m, n, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {m, n, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]y
        \[InvisibleSpace]" declared as extra \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", y, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(QueenPos[n, n] \[RightArrow] 
          \[LeftAngleBracket]Pos[n], \[Bullet]\[RightAngleBracket]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          QueenPos[ n, n], 
          Cons[ 
            Pos[ n], \[Bullet]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]n
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", n, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{x \[Rule] 
          \[LeftAngleBracket]Pos[1], 
            \[LeftAngleBracket]Pos[2], 
              \[LeftAngleBracket]Pos[3], 
                \[LeftAngleBracket]Pos[4], 
                  \[LeftAngleBracket]Pos[5], 
                    \[LeftAngleBracket]Pos[6], 
                      \[LeftAngleBracket]Pos[7], 
                        \[LeftAngleBracket]Pos[8], 
                          \[Bullet]\[RightAngleBracket]\[RightAngleBracket]\
\[RightAngleBracket]\[RightAngleBracket]\[RightAngleBracket]\
\[RightAngleBracket]\[RightAngleBracket]\[RightAngleBracket], y \[Rule] y, 
        m \[Rule] m, n \[Rule] n}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \("done."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{x, z} \[TildeTilde] map[f, {y, 1}], {x, y, z}, \n\t
      Constructor -> {g \[Proportion] Float \[ShortRightArrow] Float}, \n\t
      DefinedFunctionSymbol -> {
          f \[Proportion] Float \[ShortRightArrow] Float, 
          map \[Proportion] 
              \((Float \[ShortRightArrow] Float)\)\[Cross]TyList[Float] 
            \[ShortRightArrow] TyList[Float]}, \n\t\n]\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(map\)\" is similar to \
existing symbol \"\!\(Map\)\"."\)], "Message"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(f[x] \[RightArrow] 
          x + g[x]\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          f[ x], 
          Plus[ x, 
            g[ x]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]" "\
\[InvisibleSpace]x
        \[InvisibleSpace]" declared as  \
variable"\[InvisibleSpace]\*"\<\"\"\>"\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", x, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(map[f, \[Bullet]] 
          \[RightArrow] \[Bullet]\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          map[ f, \[Bullet]], \[Bullet], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(map[f, 
            \[LeftAngleBracket]x, z\[RightAngleBracket]] \[RightArrow] 
          \[LeftAngleBracket]f[x], map[f, z]\[RightAngleBracket]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          map[ f, 
            Cons[ x, z]], 
          Cons[ 
            f[ x], 
            map[ f, z]], True]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, z\),
          Infix[ {x, z}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, z}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{y \[Rule] x$184, z \[Rule] 1 + g[1]}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \("link already disabled."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(RewriteruleList[f]\)], "Input"],

Cell[BoxData[
    \(General::"spell1" \( : \ \) 
      "Possible spelling error: new symbol name \"\!\(RewriteruleList\)\" is \
similar to existing symbol \"\!\(RewriteRuleList\)\"."\)], "Message"],

Cell[BoxData[
    \(RewriteruleList[f]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Calculus`Private`VariantsRule[f[x$124]]\)], "Input"],

Cell[BoxData[
    \({Null}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSEnd[]\)], "Input"],

Cell[BoxData[
    \("done."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{x, x} \[TildeTilde] {1, y}, {x \[Proportion] Float, 
        y \[Proportion] Compl}]\)], "Input"],

Cell[BoxData[
    \("Type check error : can not type the goal."\)], "Print"],

Cell[BoxData[
    \("\[UpTee]"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tc[1]\)], "Input"],

Cell[BoxData[
    \(Compl\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Context[Float]\)], "Input"],

Cell[BoxData[
    \("Types`"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tc[{x, y}, 
      TypedVars -> {x \[Proportion] Float, 
          y \[Proportion] \[Placeholder] \[ShortRightArrow] Int}]\)], "Input"],

Cell[BoxData[
    \(TyList[Float]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Tc[x, TypedVars -> {x \[Proportion] Float}]\)], "Input"],

Cell[BoxData[
    \(Float\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{883, 586},
WindowMargins->{{Automatic, 37}, {150, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 142, 4, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[1898, 59, 44, 1, 27, "Input"],
Cell[1945, 62, 71, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2053, 68, 55, 0, 42, "Subsubsection"],
Cell[2111, 70, 920, 16, 235, "Input"],

Cell[CellGroupData[{
Cell[3056, 90, 51, 1, 27, "Input"],
Cell[3110, 93, 162, 5, 27, "Output"]
}, Open  ]],
Cell[3287, 101, 485, 8, 123, "Input"],

Cell[CellGroupData[{
Cell[3797, 113, 1389, 23, 235, "Input"],
Cell[5189, 138, 71, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5297, 144, 1323, 23, 251, "Input"],
Cell[6623, 169, 451, 12, 23, "Print"],
Cell[7077, 183, 553, 12, 23, "Print"],
Cell[7633, 197, 355, 8, 23, "Print"],
Cell[7991, 207, 401, 10, 23, "Print"],
Cell[8395, 219, 553, 12, 23, "Print"],
Cell[8951, 233, 436, 11, 23, "Print"],
Cell[9390, 246, 562, 12, 23, "Print"],
Cell[9955, 260, 341, 8, 23, "Print"],
Cell[10299, 270, 338, 7, 23, "Print"],
Cell[10640, 279, 425, 10, 23, "Print"],
Cell[11068, 291, 338, 7, 23, "Print"],
Cell[11409, 300, 665, 18, 23, "Print"],
Cell[12077, 320, 562, 12, 23, "Print"],
Cell[12642, 334, 355, 8, 23, "Print"],
Cell[13000, 344, 414, 10, 23, "Print"],
Cell[13417, 356, 338, 7, 23, "Print"],
Cell[13758, 365, 256, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14051, 374, 41, 1, 27, "Input"],
Cell[14095, 377, 285, 4, 55, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14417, 386, 45, 1, 27, "Input"],
Cell[14465, 389, 113, 2, 23, "Message"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14615, 396, 90, 1, 27, "Input"],
Cell[14708, 399, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14784, 405, 138, 3, 27, "Input"],
Cell[14925, 410, 44, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15006, 416, 40, 1, 27, "Input"],
Cell[15049, 419, 40, 1, 23, "Print"]
}, Open  ]],
Cell[15104, 423, 202, 4, 27, "Input"],

Cell[CellGroupData[{
Cell[15331, 431, 49, 1, 27, "Input"],
Cell[15383, 434, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15459, 440, 398, 6, 107, "Input"],
Cell[15860, 448, 342, 9, 23, "Print"],
Cell[16205, 459, 338, 7, 23, "Print"],
Cell[16546, 468, 658, 18, 23, "Print"],
Cell[17207, 488, 562, 12, 23, "Print"],
Cell[17772, 502, 355, 8, 23, "Print"],
Cell[18130, 512, 417, 10, 23, "Print"],
Cell[18550, 524, 338, 7, 23, "Print"],
Cell[18891, 533, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18974, 539, 70, 1, 27, "Input"],
Cell[19047, 542, 57, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19141, 548, 866, 16, 203, "Input"],
Cell[20010, 566, 342, 9, 23, "Print"],
Cell[20355, 577, 338, 7, 23, "Print"],
Cell[20696, 586, 658, 18, 23, "Print"],
Cell[21357, 606, 562, 12, 23, "Print"],
Cell[21922, 620, 355, 8, 23, "Print"],
Cell[22280, 630, 417, 10, 23, "Print"],
Cell[22700, 642, 338, 7, 23, "Print"],
Cell[23041, 651, 656, 13, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23734, 669, 40, 1, 27, "Input"],
Cell[23777, 672, 40, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23854, 678, 417, 7, 91, "Input"],
Cell[24274, 687, 173, 3, 23, "Message"],
Cell[24450, 692, 339, 10, 23, "Print"],
Cell[24792, 704, 338, 7, 23, "Print"],
Cell[25133, 713, 336, 8, 23, "Print"],
Cell[25472, 723, 495, 13, 23, "Print"],
Cell[25970, 738, 553, 12, 23, "Print"],
Cell[26526, 752, 73, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26636, 758, 40, 1, 27, "Input"],
Cell[26679, 761, 57, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26773, 767, 51, 1, 27, "Input"],
Cell[26827, 770, 197, 3, 39, "Message"],
Cell[27027, 775, 52, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27116, 781, 72, 1, 27, "Input"],
Cell[27191, 784, 40, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27268, 790, 40, 1, 27, "Input"],
Cell[27311, 793, 40, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27388, 799, 125, 2, 27, "Input"],
Cell[27516, 803, 76, 1, 23, "Print"],
Cell[27595, 806, 44, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27676, 812, 38, 1, 27, "Input"],
Cell[27717, 815, 39, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27793, 821, 47, 1, 27, "Input"],
Cell[27843, 824, 42, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27922, 830, 154, 3, 27, "Input"],
Cell[28079, 835, 47, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28163, 841, 76, 1, 27, "Input"],
Cell[28242, 844, 39, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

