(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     14516,        413]*)
(*NotebookOutlinePosition[     15150,        436]*)
(*  CellTagsIndexPosition[     15106,        432]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(<< TSolve.m\)], "Input"],

Cell[BoxData[
    \("Copyright 1998-1999 Institute RISC-Linz and Institute of Information \
Sciences and Electronics, Tsukuba."\)], "Print"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TypeConstructor[ElComponent]\)], "Input"],

Cell[BoxData[
    \({ElComponent}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(parallel[{compR[R1] compR[R2]}, s[I0, V0], s[I1, V1]] \[TildeTilde] True
      \)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearVariables[{I0, V0, I1, V1}]\)], "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Clear[compR]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(compR[R2]\)], "Input"],

Cell[BoxData[
    \(\[Lambda][{sIn$, sOut$}, resistor[R2, sIn$, sOut$]]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[compR]; \n
    compR[R_] = \[Lambda][{sIn, sOut}, resistor[R, sIn, sOut]]\)], "Input"],

Cell[BoxData[
    \(\[Lambda][{sIn, sOut}, resistor[R, sIn, sOut]]\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(Off[Def]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ClearVariables[{R, InI, InIs, InV, OutI, OutV, sIn, sIns, sOut}]\)], 
  "Input"],

Cell[BoxData[
    \({}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[
      parallel[\n\t\t{compR[R1], compR[R2]}, \n\t\ts[I0, V0], s[I1, V1]] 
        \[TildeTilde] True, \n\t{I1, V1}, \n\t
      Constructor -> {s : Float\[Cross]Float \[ShortRightArrow] ElSignal, 
          R1 : Float, R2 : Float, I0 : Float, V0 : Float}, \n\t
      DefinedFunctionSymbol -> \n
        \t\t{resistor : 
            Float\[Cross]ElSignal\[Cross]ElSignal \[ShortRightArrow] Bool, \n
          \t\t\tcompR : 
            Float \[ShortRightArrow] 
              \((ElSignal\[Cross]ElSignal \[ShortRightArrow] Bool)\), \n\t\t\t
          elJoin : TyList[ElSignal]\[Cross]Float \[ShortRightArrow] Float, \n
          \t\t\tjunction : 
            TyList[ElSignal]\[Cross]TyList[ElSignal] \[ShortRightArrow] Bool, 
          \n\t\t\tparallel : 
            TyList[ElSignal\[Cross]ElSignal \[ShortRightArrow] Bool]
                  \[Cross]ElSignal\[Cross]ElSignal \[ShortRightArrow] Bool\n
          \t\t}, \n\t
      RuleVars -> {R, InI, V, InIs, InV, OutI, OutV, sIn, sIn1, sIn2, sOut, 
          sOut1, sOut2, \n\t\t\tcomp, compList, \n\t\t\tsInList, sOutList\n
          \t\t}, \n\t
      Rule -> \n\t\t{\n\t\t\t
          resistor[R, s[InI, InV], s[InI, OutV]] \[RightArrow] True 
            \[DoubleLeftArrow] OutV - InV \[TildeTilde] R\ InI, \n\t\t\t
          elJoin[{}, V] \[RightArrow] 0, \n\t\t\t
          elJoin[\([s[InI, InV] | sInList]\), V] \[RightArrow] InI + InIs 
            \[DoubleLeftArrow] {InV \[TildeTilde] V, 
              elJoin[sInList, V] \[TildeTilde] InIs}, \n\t\t\t
          junction[sInList, sOutList] \[RightArrow] True \[DoubleLeftArrow] 
            elJoin[sInList, V] \[TildeTilde] elJoin[sOutList, V], \n\t\t\t
          parallel[{comp}, sIn, sOut] \[RightArrow] comp[sIn, sOut], \n\t\t\t
          parallel[\([comp | compList]\), sIn, sOut] \[RightArrow] True 
            \[DoubleLeftArrow] {\n\t\t\t\t\t
              comp[sIn1, sOut1] \[TildeTilde] True, \n\t\t\t\t\t
              parallel[compList, sIn2, sOut2] \[TildeTilde] True, \n\t\t\t\t\t
              junction[{sIn}, {sIn1, sIn2}] \[TildeTilde] True, \n\t\t\t\t\t
              junction[{sOut1, sOut2}, {sOut}] \[TildeTilde] True\n\t\t\t\t}\n
          \t\t}\n]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(resistor[R, s[InI, InV], 
            s[InI, OutV]] \[RightArrow] True \[DoubleLeftArrow] 
          \(-InV\) + OutV \[TildeTilde] InI\ R\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          resistor[ R, 
            s[ InI, InV], 
            s[ InI, OutV]], True, {
          eq[ 
            Plus[ 
              Times[ -1, InV], OutV], 
            Times[ InI, R]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(InI, InV, OutV, R\),
          Infix[ {InI, InV, OutV, R}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {InI, InV, OutV, R}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(elJoin[\[Bullet], V] 
          \[RightArrow] 0\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          elJoin[ \[Bullet], V], 0, {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]V
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", V, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(elJoin[\([
            s[InI, InV] | sInList]\), V] \[RightArrow] InI + InIs 
          \[DoubleLeftArrow] {InV \[TildeTilde] V, 
            elJoin[sInList, V] \[TildeTilde] InIs}\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          elJoin[ 
            Cons[ 
              s[ InI, InV], sInList], V], 
          Plus[ InI, InIs], {
          eq[ InV, V], 
          eq[ 
            elJoin[ sInList, V], InIs]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(InI, InIs, InV, sInList, V\),
          Infix[ {InI, InIs, InV, sInList, V}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {InI, InIs, InV, sInList, V}, ","], " declared as  variable", 
        "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]InIs
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", InIs, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]4
        \[InvisibleSpace]": "\[InvisibleSpace]\(junction[sInList, sOutList] 
          \[RightArrow] True \[DoubleLeftArrow] 
          elJoin[sInList, V] \[TildeTilde] elJoin[sOutList, V]\)\),
      SequenceForm[ "Adding rule #", 4, ": ", 
        RewriteRule[ 
          junction[ sInList, sOutList], True, {
          eq[ 
            elJoin[ sInList, V], 
            elJoin[ sOutList, V]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(sInList, sOutList, V\),
          Infix[ {sInList, sOutList, V}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {sInList, sOutList, V}, ","], " declared as  variable", "s", 
        "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]V
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", V, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]5
        \[InvisibleSpace]": "\[InvisibleSpace]\(parallel[\([comp | \[Bullet]]
            \), sIn, sOut] \[RightArrow] comp[sIn, sOut]\)\),
      SequenceForm[ "Adding rule #", 5, ": ", 
        RewriteRule[ 
          parallel[ 
            Cons[ comp, \[Bullet]], sIn, sOut], 
          comp[ sIn, sOut], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(comp, sIn, sOut\),
          Infix[ {comp, sIn, sOut}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {comp, sIn, sOut}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]6
        \[InvisibleSpace]": "\[InvisibleSpace]\(parallel[\([comp | compList]
            \), sIn, sOut] \[RightArrow] True 
          \[DoubleLeftArrow] {comp[sIn1, sOut1] \[TildeTilde] True, 
            parallel[compList, sIn2, sOut2] \[TildeTilde] True, 
            junction[\([sIn | \[Bullet]]\), \([sIn1, {sIn2}]\)] \[TildeTilde] 
              True, junction[\([sOut1, {sOut2}]\), \([sOut | \[Bullet]]\)] 
              \[TildeTilde] True}\)\),
      SequenceForm[ "Adding rule #", 6, ": ", 
        RewriteRule[ 
          parallel[ 
            Cons[ comp, compList], sIn, sOut], True, {
          eq[ 
            comp[ sIn1, sOut1], True], 
          eq[ 
            parallel[ compList, sIn2, sOut2], True], 
          eq[ 
            junction[ 
              Cons[ sIn, \[Bullet]], 
              Cons[ sIn1, 
                Cons[ sIn2, \[Bullet]]]], True], 
          eq[ 
            junction[ 
              Cons[ sOut1, 
                Cons[ sOut2, \[Bullet]]], 
              Cons[ sOut, \[Bullet]]], True]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(comp, compList, sIn, sIn1, sIn2, sOut, sOut1, 
          sOut2\),
          Infix[ {comp, compList, sIn, sIn1, sIn2, sOut, sOut1, sOut2}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {comp, compList, sIn, sIn1, sIn2, sOut, sOut1, sOut2}, ","], 
        " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(sIn1, sIn2, sOut1, sOut2\),
          Infix[ {sIn1, sIn2, sOut1, sOut2}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as extra variable\"\>", "\[InvisibleSpace]", 
        "\<\"s\"\>", "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {sIn1, sIn2, sOut1, sOut2}, ","], 
        " declared as extra variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("sol="\[InvisibleSpace]Bool\),
      SequenceForm[ "sol=", Bool],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[\("hV:"\[InvisibleSpace]{}\),
      SequenceForm[ "hV:", {}],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{I1 \[Rule] I0, V1 \[Rule] \(I0\ R1\ R2\)\/\(R1 + R2\) + V0}}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(?R\)\)], "Input"],

Cell[BoxData[
    \("Global`R"\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[TSolve]\)], "Input"],

Cell[BoxData[
    \({NSolution \[Rule] 256, Rule \[Rule] {}, Initialize \[Rule] False, 
      Constructor \[Rule] {}, DefinedFunctionSymbol \[Rule] {}, 
      RuleVars \[Rule] {}, TypeCheck \[Rule] True}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
WindowSize->{520, 455},
WindowMargins->{{89, Automatic}, {16, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 44, 1, 27, "Input"],
Cell[1778, 54, 140, 2, 39, "Print"],
Cell[1921, 58, 71, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2029, 64, 61, 1, 27, "Input"],
Cell[2093, 67, 47, 1, 27, "Output"]
}, Open  ]],
Cell[2155, 71, 112, 2, 27, "Input"],

Cell[CellGroupData[{
Cell[2292, 77, 65, 1, 27, "Input"],
Cell[2360, 80, 36, 1, 27, "Output"]
}, Open  ]],
Cell[2411, 84, 45, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2481, 89, 42, 1, 27, "Input"],
Cell[2526, 92, 85, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2648, 98, 112, 2, 43, "Input"],
Cell[2763, 102, 80, 1, 27, "Output"]
}, Open  ]],
Cell[2858, 106, 41, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[2924, 111, 100, 2, 27, "Input"],
Cell[3027, 115, 36, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3100, 121, 2218, 38, 603, "Input"],
Cell[5321, 161, 564, 15, 39, "Print"],
Cell[5888, 178, 601, 13, 23, "Print"],
Cell[6492, 193, 324, 8, 23, "Print"],
Cell[6819, 203, 316, 6, 23, "Print"],
Cell[7138, 211, 608, 16, 39, "Print"],
Cell[7749, 229, 628, 13, 23, "Print"],
Cell[8380, 244, 339, 7, 23, "Print"],
Cell[8722, 253, 510, 12, 39, "Print"],
Cell[9235, 267, 610, 13, 23, "Print"],
Cell[9848, 282, 333, 7, 23, "Print"],
Cell[10184, 291, 425, 10, 23, "Print"],
Cell[10612, 303, 586, 12, 23, "Print"],
Cell[11201, 317, 1144, 28, 87, "Print"],
Cell[12348, 347, 714, 14, 39, "Print"],
Cell[13065, 363, 632, 13, 23, "Print"],
Cell[13700, 378, 137, 3, 23, "Print"],
Cell[13840, 383, 131, 3, 23, "Print"],
Cell[13974, 388, 99, 2, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14110, 395, 39, 1, 27, "Input"],
Cell[14152, 398, 43, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14232, 404, 48, 1, 27, "Input"],
Cell[14283, 407, 217, 3, 43, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

