(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     21059,        742]*)
(*NotebookOutlinePosition[     21778,        768]*)
(*  CellTagsIndexPosition[     21734,        764]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Debug", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text"],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains functions for tracing the evolution of CFLP \
computations and for controlling a CFLP session.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Debug`\>", {"\<TermSyntax`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(ClearCFLPTraceWindow::usage = 
      "\<ClearCFLPTraceWindow[] clears the current trace window of the \
interpreter.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(IsClosedPanel::usage = 
      "\<IsClosedPanel[] returns True if the CFLP control panel is closed and \
False otherwise.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(ClearCSTraceWindow::usage = 
      "\<ClearCSTraceWindow[] clears the current trace window of the \
constraint solving component.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(CloseCFLPTraceWindow::usage = 
      "\<CloseCFLPTraceWindow[] closes the current trace window of the \
interpreter.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(CloseCSTraceWindow::usage = 
      "\<CloseCSTraceWindow[] closes the current trace window of the \
constraint solving component.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(OpenCFLPTraceWindow::usage = 
      "\<OpenCFLPTraceWindow[options] opens a trace window for the CFLP \
interpreter using the specified options.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(OpenCSTraceWindow::usage = 
      "\<OpenCSTraceWindow[options] opens a trace window for the constraint \
solving component using the specified options.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(DPrint::usage = 
      "\<DPrint[level,expr] prints `expr` into the trace window of the \
interpreter if `level` is less than or equal to $CFLPTraceLevel.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(CSPrint::usage = 
      "\<CSPrint[level,expr] prints `expr` into the trace window of the \
constraint scheduler if `level` is less than or equal to $CFLPTraceLevel.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\($CFLPTraceLevel::usage = 
      "\<$CFLPTraceLevel controls the granularity of trace output.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \($CSWindow::usage = "\<\>"; $TraceWindow::usage = "\<\>"; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(MessageOff::usage = "\<\>"; MessageOn::usage = "\<\>"; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(SetPanel::usage = "\<\>"; MessageOn::usage = "\<\>"; 
    ResetPanel::usage = "\<\>"; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->GrayLevel[0]],

Cell[CellGroupData[{

Cell[TextData["\[Bullet]ctrlPanel"], "Subsection"],

Cell[TextData[{
  StyleBox["\[Bullet]ctrlPanel",
    FontWeight->"Bold"],
  " is the identifier of the \"Control Panel\" palette. "
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[\[Bullet]ctrlPanel]; \n\[Bullet]ctrlPanel := Null; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$TraceWindow, $CSWindow", "Subsection"],

Cell[BoxData[
    \($TraceWindow := Null; \n$CSWindow := Null; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["$CFLPTraceLevel", "Subsection"],

Cell[BoxData[
    \(\($CFLPTraceLevel := 2; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSPrint", "Subsection"],

Cell[BoxData[
    \(Clear[CSPrint]; \n
    CSPrint[level_, expr___] /; 
        And[Head[$CSWindow] === NotebookObject, 
          level \[LessEqual] $CFLPTraceLevel] := \n\t
      NotebookWrite[$CSWindow, \n\t\t
        Cell[BoxData[
            RowBox[Function[StyleBox[ToBoxes[#, StandardForm]]]/@\ {expr}]], 
          "\<Message\>", \n\t\t\tGeneratedCell \[Rule] True]]; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearCFLPTraceWindow", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["ClearCFLPTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tClear the current trace window"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[ClearCFLPTraceWindow]; \n
    ClearCFLPTraceWindow[] := \n\t
      If[$TraceWindow =!= Null, \n\t\t
        SelectionMove[$TraceWindow, All, Notebook]; \n\t\t
        NotebookDelete[$TraceWindow]\n\t]; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ClearCSTraceWindow", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["ClearCSTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tClear the current trace window\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[ClearCSTraceWindow]; \n
    ClearCSTraceWindow[] := \n\t
      If[$CSWindow =!= Null, \n\t\tSelectionMove[$CSWindow, All, Notebook]; \n
        \t\tNotebookDelete[$CSWindow]]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["CloseCFLPTraceWindow", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["CloseCFLPTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tClose the current trace window\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(Clear[CloseCFLPTraceWindow]; \n
    CloseCFLPTraceWindow[] := \n\t
      If[$TraceWindow =!= Null, \n\t\t
        NotebookClose[$TraceWindow]; $TraceWindow = Null]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell["CloseCSTraceWindow", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["CloseCSTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tClose the current trace window"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[CloseCSTraceWindow]; \n
    CloseCSTraceWindow[] := \n\t
      If[$CSWindow =!= Null, \n\t\t
        NotebookClose[$CSWindow]; $CSWindow = Null]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["DPrint", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[DPrint]; \n
    DPrint[level_, \*"\"\<\!\(\[Implies]\^cs\)\>\"", expr__] /; 
        And[Head[$TraceWindow] === NotebookObject, 
          level \[LessEqual] $CFLPTraceLevel] := \n\t
      NotebookWrite[$TraceWindow, \n\t\t
        Cell[BoxData[
            RowBox[Function[StyleBox[ToBoxes[#, StandardForm]]]/@
                \ {\*"\"\<\!\(\( \[Implies] \^cs\)\)\>\"", expr}]], 
          "\<Message\>", \n\t\t\tCellFrame -> True, \n\t\t\t
          GeneratedCell \[Rule] True]]; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]],

Cell[BoxData[
    \(\(DPrint[level_, expr___] /; 
        And[Head[$TraceWindow] === NotebookObject, 
          level \[LessEqual] $CFLPTraceLevel] := \n\t\t
      NotebookWrite[$TraceWindow, \n\t\t
        Cell[BoxData[
            RowBox[Function[StyleBox[ToBoxes[#, StandardForm]]]/@\ {expr}]], 
          "\<Message\>", \n\t\t\tGeneratedCell \[Rule] True]]; \)\)], "Input",\

  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsClosedPanel", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsClosedPanel[",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn ",
  StyleBox["True",
    FontWeight->"Bold"],
  " if the CFLP control panel is closed and ",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(IsClosedPanel[] := 
      Or[\[Bullet]ctrlPanel === Null, 
        NotebookInformation[\[Bullet]ctrlPanel] === $Failed]; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MessageOff", "Subsection"],

Cell[BoxData[
    \(\(MessageOff[] := \(($CFLPTraceLevel = 0)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["MessageOn", "Subsection"],

Cell[BoxData[
    \(\(MessageOn[] := \(($CFLPTraceLevel = 2)\); \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["OpenCFLPTraceWindow", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["OpenCFLPTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tCreate a window named ",
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where trace messages will be displayed (see function ",
  StyleBox["DPrint",
    FontWeight->"Bold"],
  ").\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(OpenCFLPTraceWindow[opts___Rule]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({curr = SelectedNotebook[]}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"If", "[", 
                RowBox[{\($TraceWindow =!= Null\), ",", 
                  StyleBox[\(CloseCFLPTraceWindow[]\),
                    FontWeight->"Bold"]}], "]"}], ";", "\n", "\t\t", 
              \($TraceWindow = \n\t\t\t
                If[ValueQ[$FrontEnd], \n\t\t\t\t\t
                  NotebookCreate[opts, \n\t\t\t\t\tWindowSize -> {400, 120}, 
                    \n\t\t\t\t\tWindowTitle -> "\<CFLP Trace\>", \n\t\t\t\t\t
                    WindowElements -> {"\<VerticalScrollBar\>", 
                        "\<HorizontalScrollBar\>"}, \n\t\t\t\t\t
                    Magnification -> 1]]\), ";", "\n", "\t\t", 
              \(SetSelectedNotebook[curr]\)}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["OpenCSTraceWindow",
  FontWeight->"Bold"]], "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["OpenCSTraceWindow[",
    FontWeight->"Bold"],
  StyleBox[" name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tCreate a window named ",
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ", where trace messages of priority will be displayed (see function ",
  StyleBox["CSPrint",
    FontWeight->"Bold"],
  ").\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{"Clear", "[", 
        StyleBox["OpenCSTraceWindow",
          FontWeight->"Bold"], "]"}], ";", "\n", 
      RowBox[{\(OpenCSTraceWindow[opts___Rule]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({curr = SelectedNotebook[]}\), ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"If", "[", 
                RowBox[{\($CSWindow =!= Null\), ",", 
                  StyleBox[\(CloseCSTraceWindow[]\),
                    FontWeight->"Bold"]}], "]"}], ";", "\n", "\t\t", 
              \($CSWindow = \n\t\t\t
                If[ValueQ[$FrontEnd], \n\t\t\t\t\t
                  NotebookCreate[opts, \n\t\t\t\t\tWindowSize -> {400, 120}, 
                    \n\t\t\t\t\tWindowTitle -> "\<Scheduler Trace\>", \n
                    \t\t\t\t\t
                    WindowElements -> {"\<VerticalScrollBar\>", 
                        "\<HorizontalScrollBar\>"}, \n\t\t\t\t\t
                    Magnification -> 1]]\), ";", "\n", "\t\t", 
              \(SetSelectedNotebook[curr]\)}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetPanel", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(ResetPanel[] := \n\t
      Block[{}, \n\t\tNotebookClose[\[Bullet]ctrlPanel]; \n\t\t
        \[Bullet]ctrlPanel = 
          NotebookOpen[Global`$cflpSrcDirectory<>"\<ControlPanel1.nb\>"]\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetPanel", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[SetPanel]; \n
    SetPanel[] := \n\t
      If[\n\t\t\t
        \[Bullet]ctrlPanel === Null \[Or] \n\t\t\t\t
          NotebookInformation[\[Bullet]ctrlPanel] =!= $Failed, \n\t\t
        \[Bullet]ctrlPanel = 
          NotebookOpen[Global`$cflpSrcDirectory<>"\<ControlPanel1.nb\>"]\n
        \t\t]; \)], "Input",
  InitializationCell->True,
  FontColor->GrayLevel[0]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["End"]], "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->GrayLevel[0],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell[BoxData[
    \(<< Debug`\)], "Input"],

Cell[BoxData[
    \(OpenCFLPTraceWindow[]\)], "Input"],

Cell[BoxData[
    \(CloseCFLPTraceWindow[]\)], "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
Evaluator->"Local",
WindowSize->{706, 484},
WindowMargins->{{31, Automatic}, {1, Automatic}},
FontColor->GrayLevel[0.0901961]
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 61, 1, 102, "Title"],
Cell[1795, 54, 169, 4, 50, "Text"],

Cell[CellGroupData[{
Cell[1989, 62, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2056, 65, 2326, 40, 34214, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4419, 110, 39, 0, 53, "Subtitle"],
Cell[4461, 112, 140, 3, 32, "Text"],
Cell[4604, 117, 141, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4770, 124, 27, 0, 45, "Subsection"],
Cell[4800, 126, 213, 5, 43, "Input",
  InitializationCell->True],
Cell[5016, 133, 217, 5, 43, "Input",
  InitializationCell->True],
Cell[5236, 140, 226, 5, 43, "Input",
  InitializationCell->True],
Cell[5465, 147, 213, 5, 43, "Input",
  InitializationCell->True],
Cell[5681, 154, 226, 5, 43, "Input",
  InitializationCell->True],
Cell[5910, 161, 241, 5, 43, "Input",
  InitializationCell->True],
Cell[6154, 168, 249, 5, 43, "Input",
  InitializationCell->True],
Cell[6406, 175, 254, 6, 43, "Input",
  InitializationCell->True],
Cell[6663, 183, 267, 6, 43, "Input",
  InitializationCell->True],
Cell[6933, 191, 192, 5, 27, "Input",
  InitializationCell->True],
Cell[7128, 198, 145, 3, 27, "Input",
  InitializationCell->True],
Cell[7276, 203, 143, 3, 27, "Input",
  InitializationCell->True],
Cell[7422, 208, 174, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7645, 218, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7704, 222, 24, 0, 54, "Section"],
Cell[7731, 224, 171, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7927, 233, 50, 0, 45, "Subsection"],
Cell[7980, 235, 143, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[8148, 243, 125, 3, 42, "Subsubsection"],
Cell[8276, 248, 145, 3, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8470, 257, 45, 0, 45, "Subsection"],
Cell[8518, 259, 131, 3, 43, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8686, 267, 37, 0, 45, "Subsection"],
Cell[8726, 269, 114, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[8877, 277, 29, 0, 45, "Subsection"],
Cell[8909, 279, 444, 10, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[9390, 294, 42, 0, 45, "Subsection"],
Cell[9435, 296, 395, 16, 86, "Text"],

Cell[CellGroupData[{
Cell[9855, 316, 125, 3, 42, "Subsubsection"],
Cell[9983, 321, 296, 7, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10328, 334, 40, 0, 45, "Subsection"],
Cell[10371, 336, 474, 19, 104, "Text"],
Cell[10848, 357, 282, 6, 91, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[11167, 368, 42, 0, 29, "Subsection"],
Cell[11212, 370, 476, 19, 104, "Text"],
Cell[11691, 391, 265, 6, 75, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[11993, 402, 40, 0, 29, "Subsection"],
Cell[12036, 404, 393, 16, 86, "Text"],

Cell[CellGroupData[{
Cell[12454, 424, 125, 3, 42, "Subsubsection"],
Cell[12582, 429, 252, 6, 75, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12883, 441, 28, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[12936, 445, 125, 3, 42, "Subsubsection"],
Cell[13064, 450, 576, 12, 139, "Input",
  InitializationCell->True],
Cell[13643, 464, 434, 10, 107, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[14126, 480, 35, 0, 45, "Subsection"],
Cell[14164, 482, 518, 22, 86, "Text"],

Cell[CellGroupData[{
Cell[14707, 508, 125, 3, 42, "Subsubsection"],
Cell[14835, 513, 213, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15097, 524, 32, 0, 45, "Subsection"],
Cell[15132, 526, 135, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15304, 534, 31, 0, 45, "Subsection"],
Cell[15338, 536, 134, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[15509, 544, 41, 0, 45, "Subsection"],
Cell[15553, 546, 655, 26, 104, "Text"],
Cell[16211, 574, 1022, 20, 203, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17270, 599, 81, 1, 45, "Subsection"],
Cell[17354, 602, 666, 26, 104, "Text"],
Cell[18023, 630, 1155, 24, 219, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19215, 659, 32, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[19272, 663, 125, 3, 42, "Subsubsection"],
Cell[19400, 668, 295, 7, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[19744, 681, 30, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[19799, 685, 125, 3, 42, "Subsubsection"],
Cell[19927, 690, 392, 10, 123, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[20380, 707, 42, 0, 54, "Section"],
Cell[20425, 709, 178, 6, 27, "Input",
  InitializationCell->True],
Cell[20606, 717, 185, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[20828, 728, 31, 0, 54, "Section"],
Cell[20862, 730, 42, 1, 27, "Input"],
Cell[20907, 733, 54, 1, 27, "Input"],
Cell[20964, 736, 55, 1, 27, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

