(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    123830,       4044]*)
(*NotebookOutlinePosition[    125078,       4091]*)
(*  CellTagsIndexPosition[    124909,       4081]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["The CFLP Calculus", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[StyleBox[
"\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, \
Tsukuba."]], "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell["\<\
This package contains the implementation of the CFLP calculus. CFLP \
is an extension of the calculi LCNC and Higher Order LNC with rules for \
handling constraints, AND-parallelism and OR-parallelism.\
\>", "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<Calculus`\>", \n
      \t{"\<Terms`\>", "\<RewriteRules`\>", "\<Debug`\>", 
        "\<Substitutions`\>", "\<SchedulerInterface`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(TcCall::usage\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(cflpInterrupt::usage = 
      "\<cflpInterrupt is a global variable for the internal use of \
CallTSolve. It is used for signaling the occurrence of a user interrupt \
event.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CallTSolve::usage = 
      "\<CallTSolve[{form1,\[Ellipsis]}, vars] attempts to solve the set of \
equational formulas {form1,\[Ellipsis]} for the variables `vars`.
		It is the designed to be called by the term algebra solver `TSolve` and by \
the type checker `Tc`.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(TSolveRules::usage; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLP::usage = 
      "\<CFLP[eqns,cnstrs] attempts to solve the system of equations `eqns` \
and constraints `cnstrs` for the set of Temporary symbols of `eqns` and \
`cnstrs`. \n
		It is designed to be called by CallTSolve.\>"\ ; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsConstrV::usage = 
      "\<IsConstrV[expr] yields True if `expr` is a CFLP constructor term and \
yields False otherwise. A CFLP constructor term is a term consisting only of \
bound variables, constructors and external operators. A weak version of the \
variable occur check test is imposed.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(IsValue::usage = 
      "\<IsValue[expr] yields True if `expr` is a CFLP value and yields False \
otherwise. A CFLP value is a term consisting only of bound variables, \
constructors and external operators.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPRules::usage = 
      "\<CFLPRules gives the list of inference rules of the CFLP calculus. \
The inference rules are tried from left to right.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPANDRules::usage = 
      "\<CFLPANDRules gives the list of inference rules of the CFLP calculus \
for AND contexts. The inference rules are tried from left to right.\>"; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\($ContextPath = 
      Join[{"\<Variables`\>", "\<TermSyntax`\>", "\<TypeSyntax`\>", 
          "\<Types`\>"}, $ContextPath]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(Off[RuleDelayed::"\<argr\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["IsConstrV", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsConstrV[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a CFLP term consisting of variables, constructors and external \
operators.\n\tOtherwise, return False."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[IsConstrV, IsConstrVAux]; \nIsConstrV[term_Function] := True; \n
    IsConstrV[t_] := IsConstrVAux[t]; \n
    IsConstrVAux[_?IsConstructor | _?IsVar] := True; \n
    IsConstrVAux[_?IsConstrVAux[___?IsConstrVAux]] := True; \n
    IsConstrVAux[_] := False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsValue", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsValue[ ",
    FontWeight->"Bold"],
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tReturn True if ",
  StyleBox["expr",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a CFLP value, and False otherwise."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[IsVarValue]; \n
    IsVarValue[_?IsConstructor | _?IsExternal | _?IsVar] := True; \n
    IsVarValue[_?IsExternal[___]] := True; \n
    IsVarValue[_?IsVarValue[___?IsVarValue]] := True; \n
    IsVarValue[_] := False; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(Clear[IsValue]; \n
    IsValue[term_] := And[IsVarValue[term], Var[term] === {}]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" ComputedAnswer ", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(ComputedAnswer[gV_, \[Sigma]_] := \n\t\t
      FixedPoint[ApplySubst[#, \[Sigma]]&, 
        Select[\[Sigma], 
          MemberQ[gV, #\[LeftDoubleBracket]1\[RightDoubleBracket]]&]]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewCFLP", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(NewCFLP[EqType_, RewritesTo[t_, cs1_List, cs2_List], rhs_, forms___]
          \), ":=", "\n", "\t", 
        RowBox[{"(", 
          RowBox[{
            RowBox[{"If", "[", 
              RowBox[{
                StyleBox["addType",
                  FontColor->RGBColor[1, 0, 0]], ",", "\n", "\t\t\t", 
                \(TypeChecker`Tc[{Sequence\ @@\ cs1, EqType[t, rhs], 
                    Sequence\ @@\ cs2}, \n\t\t\t\t
                  TypeChecker`KeepTypes -> True]\)}], "]"}], ";", "\n", 
            "\t\t", \({Sequence\ @@\ cs1, EqType[t, rhs], Sequence\ @@\ cs2, 
              forms}\)}], ")"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" NewCFLPImitation (reconsider)", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(NewCFLPImitation[EqType_, f_, X_, params_List, t_, {forms___}, 
        Cs_] := \n\t
      Block[\n\t\t{mapsTo, newVars = Table[Module[{x}, x], {Length[params]}], 
          \[Lambda]term, \n\t\t\tGlobal`Substitution = Global`Substitution}, 
        \n\t\t\[Lambda]term\  = \ 
          \(\[Lambda][#1, \ #2]&\)\n\t\t\t\t[newVars, 
            f\ @@\ Table[
                \(Module[{H}, \ H\ @@\ #]&\)\ [newVars], {Arity[f]}]]; \n\t\t
        mapsTo = X -> \[Lambda]term; \n\t\t
        Global`Substitution = 
          Append[Global`Substitution\  /. \ mapsTo, mapsTo]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" NewCFLPProjection (reconsider)", "Subsection"],

Cell[BoxData[
    \(Clear[NewCFLPProjection]; \n
    NewCFLPProjection[EqType_, X_, params_List, t_, {forms___}, Cs_] := \n\t
      Block[{mapsTo, \[Lambda]dummy, \[Lambda]vars = NewX\ /@\ params, \n
          \t\t\t\[Lambda]term, Global`Substitution = Global`Substitution}, \n
        \t\t\[Lambda]term = 
          Function[{x, vars}, \n\t\t\t\t
            x\ @@\ Table[Module[{H}, H\ @@\ vars], {i, Arity[x]}]]; \t\n\t\t
        Scan[\n\t\t\t\t
          \((CFLP\ @@
                \(({{EqType[t, 
                          \[Lambda]term[#\[LeftDoubleBracket]2
                              \[RightDoubleBracket], params]], forms}, Cs} /. 
                    X -> Function\ @@
                        \ {\[Lambda]vars, 
                          \[Lambda]term[#\[LeftDoubleBracket]1
                              \[RightDoubleBracket], \[Lambda]vars]})\))\)&, 
          \n\t\tTranspose[{\[Lambda]vars, params}]\n\t\t]\n\t]; \)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]],

Cell[CellGroupData[{

Cell[" EmptySequence", "Subsection"],

Cell[BoxData[
    \(\(EmptySequence := Sequence[]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Closed]],

Cell[CellGroupData[{

Cell[" NewEqns", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tNewEqns[ eq | ppeq",
    FontWeight->"Bold"],
  StyleBox[", ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "{",
  StyleBox["s_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1",
  StyleBox[",\[Ellipsis],s_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["n",
    FontSlant->"Italic"],
  "},{",
  StyleBox["t_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1",
  StyleBox[",\[Ellipsis],t_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["n",
    FontSlant->"Italic"],
  "}",
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["s_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1",
  StyleBox[",\[Ellipsis],s_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["n",
    FontSlant->"Italic"],
  ", ",
  StyleBox["t_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "1",
  StyleBox[",\[Ellipsis],t_",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["n",
    FontSlant->"Italic"],
  " : CFLP terms\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sequence of equations ",
  StyleBox["s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "_1\[TildeTilde]",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "_1,\[Ellipsis],",
  StyleBox["s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "_",
  StyleBox["n",
    FontSlant->"Italic"],
  "\[TildeTilde]",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "_",
  StyleBox["n",
    FontSlant->"Italic"],
  " if the first argument is ",
  StyleBox["eq",
    FontWeight->"Bold"],
  ", or the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " sequence of equations ",
  StyleBox["s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "_1\[CupCap]t_1,\[Ellipsis],",
  StyleBox["s",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["_n",
    FontSlant->"Italic"],
  "\[CupCap]",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["_n",
    FontSlant->"Italic"],
  " if the first argument is ",
  StyleBox["ppeq",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(NewEqns[h_, s_, t_] := 
      Sequence\ @@\ 
        Table[h[s\[LeftDoubleBracket]i\[RightDoubleBracket], 
            t\[LeftDoubleBracket]i\[RightDoubleBracket]], {i, Length[s]}]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[" VariantsRule", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tVariantsRule[ ",
    FontWeight->"Bold"],
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  StyleBox[",...,a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  StyleBox["]",
    FontWeight->"Bold"],
  StyleBox[", n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] ",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\t",
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  StyleBox[",...,a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  StyleBox["]",
    FontWeight->"Bold"],
  StyleBox[" ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a term whose head ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a defined function symbol\n\t",
  StyleBox["n ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": a positive integer\n",
  StyleBox["Output",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "\n\tIf the ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "-th conditional rewrite rule associated to ",
  StyleBox["f",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is"
}], "Text"],

Cell[TextData[{
  StyleBox["f ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["[b",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  StyleBox[",...,b",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  StyleBox["] \[RightArrow] r \[DoubleLeftArrow] {cond",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  StyleBox[",\[Ellipsis], cond",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_p\)\)]],
  StyleBox["}",
    FontWeight->"Bold"]
}], "Text"],

Cell[TextData[{
  "then return the expression \[Sigma]",
  StyleBox["[RewritesTo[r,{b",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  "\[TildeTilde]",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  StyleBox[",...,b",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  "\[TildeTilde]",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  "}",
  StyleBox[" ,{cond",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)],
    FontWeight->"Bold"],
  StyleBox[", \[Ellipsis], cond",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_p\)\)],
    FontWeight->"Bold"],
  "}",
  StyleBox["]]",
    FontWeight->"Bold"],
  " where ",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  ",\[Ellipsis], ",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  "are fresh variables and \[Sigma]={",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  "\[RightTeeArrow]",
  StyleBox["a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_1\)\)]],
  ",\[Ellipsis], ",
  StyleBox["x",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  "\[RightTeeArrow]",
  StyleBox["a",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_m\)\)]],
  "}"
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(VariantsRule[f_Symbol, nr_] := 
      \(\(RewriteRuleList[f]\)\[LeftDoubleBracket]nr
          \[RightDoubleBracket]\)[]; \n
    VariantsRule[f_[args___], nr_] := 
      \(\(RewriteRuleList[f]\)\[LeftDoubleBracket]nr\[RightDoubleBracket]\)[
        args]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontColor->RGBColor[0, 0, 0.501961],
  Background->None]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox[" "],
  StyleBox["\[Bullet]sys, \[Bullet]Nsys, \[Bullet]ORsys, \[Bullet]waitsys.",
    FontWeight->"Bold"]
}], "Section"],

Cell[TextData[{
  StyleBox[
  "The inference rules of the CFLP calculus act on data structures \
representing the successive goals computed in CFLP derivations. \nThe \
following symbols were chosen as data constructors for CFLP goals: "],
  StyleBox["\[Bullet]sys, \[Bullet]Nsys, \[Bullet]ORsys, ",
    FontWeight->"Bold"],
  ButtonBox["\[Bullet]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  ButtonBox["waitsys",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  StyleBox[". ",
    FontWeight->"Bold"],
  StyleBox["We briefly describe  the meaning of these constructors:"]
}], "Text"],

Cell[TextData[{
  StyleBox["\[Bullet]sys[ ",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\[Sigma], vars, eqs, cs ",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["]",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" denotes the system of equations "],
  StyleBox["eqs \[Union] cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" in variables "],
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[", where "],
  StyleBox["eqs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" are the equations treated by the FLP interpreter and "],
  StyleBox["cs",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[
  " are the constraints. This is the data structure on which the all the \
inference rules of the interpreter,  except "],
  ButtonBox["[wait]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  StyleBox[", act. "]
}], "Text"],

Cell[TextData[{
  ButtonBox["\[Bullet]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  ButtonBox["waitsys[ idx, ",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  ButtonBox["\[Ellipsis]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  ButtonBox[" ]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  StyleBox[
  " denotes a placeholder to the interpreter for the results to the "],
  StyleBox["idx",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  "-th query sent by the interpreter to the constraint scheduler. This data \
structure is generated by an evaluation rule associated to the "],
  StyleBox["\[Bullet]sys",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " data structure in the base case II when a system of constraints (with \
index "],
  StyleBox["idx",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[") must be solved. The inference rule "],
  StyleBox["[wait]",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" associated to "],
  StyleBox["\[Bullet]waitsys",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " is designed to periodically query the scheduler for solutions to the "],
  StyleBox["idx",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["-th query."]
}], "Text"],

Cell[TextData[{
  StyleBox["\[Bullet]Nsys[ ",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\[Sigma], vars, term, e,  ",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["{",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["r,i,l",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["}",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[", forms, cs ",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["]",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " is a data structure used for handling the alternative search branches of \
the solution tree generated by the "],
  StyleBox["[on]",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" and "],
  StyleBox["[onpp]",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" inference rules of CFLP. "]
}], "Text"],

Cell[TextData[{
  StyleBox["\[Bullet]ORsys[ ",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["\[Sigma], vars, forms, cs ",
    FontWeight->"Bold",
    FontSlant->"Italic",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["]",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " is a data structure used for handling the alternative search branches of \
the solution tree generated by the "],
  StyleBox["[seqOR]",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" inference rule of CFLP."]
}], "Text"],

Cell[TextData[{
  StyleBox["\[Bullet]ORbranches[ \[Bullet]sys[\[Ellipsis]],\[Ellipsis]]",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " is a data structure used for handling the alternative search branches of \
the solution tree generated by the [||\[Dash]OR] inference rule of CFLP."]
}], "Text"],

Cell[TextData[{
  StyleBox["\[Bullet]ANDbranches[ \[Bullet]sys[\[Ellipsis]],\[Ellipsis]]",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[
  " is a data structure used for handling the alternative search branches of \
the solution tree generated by the "],
  StyleBox["[parAND]",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox[" inference rule of CFLP."]
}], "Text"],

Cell[BoxData[
    \(\(Clear[\[Bullet]sys, \[Bullet]Nsys, \[Bullet]ORsys, \[Bullet]ANDsys, 
      \[Bullet]ORbranches, \[Bullet]waitsys]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Inference Rules for the Base Cases "]], "Section",
  CellDingbat->"\[FilledSmallSquare]"],

Cell["\<\
These rules are for the situation when the interpreter stops \
evaluating the goal. \
\>", "Text"],

Cell[TextData[{
  "The first base case (rule ",
  ButtonBox["[b]",
    ButtonData:>"b",
    ButtonStyle->"Hyperlink"],
  ") is for the situation when the interpreter transformed the functional \
logic component of the goal into an empty system of equations and no \
constraints were generated. In this case the answer substitution can be \
immediatly computed. "
}], "Text"],

Cell[TextData[{
  "The second base case (rule ",
  ButtonBox["[cs1]",
    ButtonData:>"cs1",
    ButtonStyle->"Hyperlink"],
  ") is for the situation when the interpreter transformed the functional \
logic component of the goal into an empty system of equations and a system of \
constraints (that has to be solved) was generated. In this case the \
interpreter invokes the constraint scheduler to solve the system of \
constraints that was generated."
}], "Text"],

Cell[TextData[{
  "The third base case (rule ",
  ButtonBox["[cs2]",
    ButtonData:>"cs2",
    ButtonStyle->"Hyperlink"],
  ") for the situation when the constraint scheduler is explicitely called \
with the operator \[WatchIcon]. "
}], "Text"],

Cell[TextData[{
  "The rules ",
  ButtonBox["[cs1]",
    ButtonData:>"cs1",
    ButtonStyle->"Hyperlink"],
  " and ",
  ButtonBox["[cs2]",
    ButtonData:>"cs2",
    ButtonStyle->"Hyperlink"],
  " implement the mechanism of passing the constraints to the constraint \
scheduler. There is one more rule, ",
  ButtonBox["[wait]",
    ButtonData:>"wait",
    ButtonStyle->"Hyperlink"],
  ", which implements the mechanism of getting the answer solutions from the \
constraint scheduler."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell[" cflp", "Section"],

Cell[TextData[{
  StyleBox["cflp",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " contains the inference rules of the CFLP interpreter."
}], "Text"],

Cell[CellGroupData[{

Cell["Base case 1", "Subsection",
  CellDingbat->"\[FilledSmallSquare]"],

Cell[BoxData[
    \(\(Clear[cflp]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["b",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{}, {}\[RightAngleBracket] \[DoubleLongRightArrow] ",
  StyleBox["\[LeftAngleBracket]{}, {}\[RightAngleBracket]",
    FontVariations->{"Underline"->True}]
}], "Subsection",
  CellDingbat->None,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell["Implementation ", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic",
  CellTags->"b"],

Cell[BoxData[
    \(\(\[Bullet]sys[\[Sigma]_, gv_, {}, {}] := \n\t
      Block[{\[Theta], \[Tau]}, \n\t\t
        \[Theta] = 
          Inner[\n\t\t\t\tRule, \n\t\t\t\tinitialVars, \n\t\t\t\t
            FixedPoint[ApplySubst[#, \[Sigma]]&, initialVars], \n\t\t\t\t
            List]; \n\t\t\(nSols--\); \n\t\t
        DPrint[1, \*"\"\<\!\(\[Implies]\^b\)\>\"", \[Theta]]; \n\t\t
        AppendTo[result, \[Theta]]; \n\t\t{}\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(\[Bullet]sys[\[Sigma]_, gv_, {}] := \n\t
      Block[{\[Tau]}, \n\t\t
        AppendTo[result, \[Sigma] /. {_?IsVar[\[Tau]_] :> \[Tau]}]; \n\t\t{}\n
        \t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell["Base case 2", "Subsection",
  CellDingbat->"\[FilledSmallSquare]"],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["cs1",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)]],
  " ",
  StyleBox["wait ",
    FontSlant->"Italic"],
  "[{}, cs]"
}], "Subsection",
  CellDingbat->None,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic",
  CellTags->"cs1"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(\[Bullet]sys[\[Sigma]_, gv_, {}, cs_]\), ":=", "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({sentOK}\), ",", "\n", "\t\t", 
            RowBox[{
            \(DPrint[1, \*"\"\<\!\(\( \[Implies] \^cs\)\)\>\"", cs, gv, 
                Join[Complement[Var[{cs, \[Sigma]}], gv], pV], \[Sigma]]\), 
              ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{
                  RowBox[{"!", 
                    StyleBox["callCS",
                      FontColor->RGBColor[1, 0, 0]]}], ",", "\n", 
                  "\t\t\t\t", 
                  RowBox[{
                    RowBox[{
                      StyleBox["callCS",
                        FontColor->RGBColor[1, 0, 0]], "=", "True"}], ";", 
                    "\n", "\t\t\t\t", 
                    RowBox[{"SendCSQuery", "[", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["\"\<SetConstructors\>\"",
                            FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                          "\t\t\t\t\t\t", 
                          \(Complement[
                            Cases[Cases[DownValues[IsConstructor], 
                                RuleDelayed[x__] :> {x}\[LeftDoubleBracket]1, 
                                    1, 1\[RightDoubleBracket]], \n
                              \t\t\t\t\t\t\t_Symbol], pV]\)}], "}"}], 
                      "]"}]}]}], "]"}], ";", "\n", "\t\t", 
              RowBox[{
                StyleBox["queryIndex",
                  FontColor->RGBColor[1, 0, 0]], "++"}], ";", "\n", "\t\t", 
              RowBox[{"sentOK", "=", 
                RowBox[{"SendCSQuery", "[", 
                  RowBox[{"{", 
                    RowBox[{
                      StyleBox["\"\<CSolve\>\"",
                        FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                      "\t\t\t\t\t", \(Union[cs]\), ",", "\[Sigma]", ",", 
                      "gv", ",", 
                      \(Join[Complement[Var[{cs, \[Sigma]}], gv], pV]\)}], 
                    "}"}], "]"}]}], ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{\(sentOK === "\<dead.\>"\), ",", "\n", "\t\t\t", 
                  RowBox[{
                    StyleBox[\(queryIndex--\),
                      FontColor->RGBColor[1, 0, 0]], ";", \({}\)}], ",", 
                  "\n", "\t\t\t", 
                  RowBox[{"\[Bullet]waitsys", "[", 
                    RowBox[{
                      StyleBox["queryIndex",
                        FontColor->RGBColor[1, 0, 0]], ",", "gv", ",", 
                      \(Length[\[Sigma]]\), ",", \({}\)}], "]"}]}], "\n", 
                "\t\t", "]"}]}]}], "\n", "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell["Base case 3", "Subsection",
  CellDingbat->"\[FilledSmallSquare]"],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["cs2",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket] { \[WatchIcon], forms }, cs \[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)]],
  " ",
  StyleBox["wait ",
    FontSlant->"Italic"],
  "[{forms}, cs ]"
}], "Subsection",
  CellDingbat->None,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic",
  CellTags->"cs2"],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(\[Bullet]sys[\[Sigma]_, gv_, {\[WatchIcon], forms___}, cs_]\), ":=", 
        "\n", "\t", 
        RowBox[{"Block", "[", 
          RowBox[{\({}\), ",", "\n", "\t\t", 
            RowBox[{
            \(DPrint[1, \*"\"\<\!\(\[Implies]\^cs\)\>\"", cs, gv, 
                Join[Complement[Var[{cs, \[Sigma]}], gv], pV], \[Sigma]]\), 
              ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{
                  RowBox[{"!", 
                    StyleBox["callCS",
                      FontColor->RGBColor[1, 0, 0]]}], ",", "\n", 
                  "\t\t\t\t", 
                  RowBox[{
                    RowBox[{
                      StyleBox["callCS",
                        FontColor->RGBColor[1, 0, 0]], "=", "True"}], ";", 
                    "\n", "\t\t\t\t", 
                    RowBox[{"SendCSQuery", "[", 
                      RowBox[{"{", 
                        RowBox[{
                          StyleBox["\"\<SetConstructors\>\"",
                            FontColor->RGBColor[0, 0, 1]], ",", "\n", 
                          "\t\t\t\t\t\t", 
                          \(Complement[
                            Cases[Cases[DownValues[IsConstructor], 
                                RuleDelayed[x__] :> {x}\[LeftDoubleBracket]1, 
                                    1, 1\[RightDoubleBracket]], \n
                              \t\t\t\t\t\t\t_Symbol], pV]\)}], "}"}], 
                      "]"}]}]}], "]"}], ";", "\n", "\t\t", 
              RowBox[{
                StyleBox["queryIndex",
                  FontColor->RGBColor[1, 0, 0]], "++"}], ";", "\n", "\t\t", 
              \( (*\ Print["\<constraints:\>", Union[cs]]; \n\t\t
                Print["\<variables:\>", {gv, 
                    Join[Complement[Var[{cs, \[Sigma]}], gv], pV]}]; \ *) \), 
              "\n", "\t\t", 
              RowBox[{"SendCSQuery", "[", 
                RowBox[{"{", 
                  RowBox[{
                    StyleBox["\"\<CSolve\>\"",
                      FontColor->RGBColor[0, 0, 1]], ",", "\n", "\t\t\t\t\t", 
                    \(Union[cs]\), ",", "\[Sigma]", ",", "gv", ",", 
                    \(Join[Complement[Var[{cs, \[Sigma]}], gv], pV]\)}], 
                  "}"}], "]"}], ";", "\n", "\t\t", 
              RowBox[{"\[Bullet]waitsys", "[", 
                RowBox[{
                  StyleBox["queryIndex",
                    FontColor->RGBColor[1, 0, 0]], ",", "gv", ",", 
                  \(Length[\[Sigma]]\), ",", \({forms}\)}], "]"}]}]}], "\n", 
          "\t", "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["wait\[Dash]rule"], "Subsection",
  CellTags->"wait"],

Cell[TextData[{
  "[",
  StyleBox["wait",
    FontColor->RGBColor[1, 0, 0]],
  "]\t",
  StyleBox["wait ",
    FontSlant->"Italic"],
  "[ {}, cs ]\[DoubleLongRightArrow]",
  StyleBox[" ",
    FontWeight->"Plain"],
  StyleBox["\[LeftAngleBracket]{},cs'\[RightAngleBracket]",
    FontVariations->{"Underline"->True}],
  StyleBox["   if ",
    FontWeight->"Plain"],
  "cs",
  StyleBox[" ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\_\[Sigma]\%CSolve\)]],
  "cs'\n\t",
  StyleBox["wait ",
    FontSlant->"Italic"],
  "[ forms, cs ]",
  Cell[BoxData[
      FormBox[
        SubscriptBox["\[DoubleLongRightArrow]", 
          StyleBox["\[Sigma]",
            FontWeight->"Plain"]], TraditionalForm]]],
  "\[LeftAngleBracket]{forms}\[Sigma], cs'\[RightAngleBracket]",
  StyleBox[" if ",
    FontWeight->"Plain"],
  "cs",
  StyleBox[" ",
    FontWeight->"Plain"],
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\_\[Sigma]\%CSolve\)]],
  "cs'"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\[Bullet]ORbranches[x__, {}] := \[Bullet]ORbranches[x]; \n
    \[Bullet]ORbranches[x_] := x; \n\[Bullet]ORbranches[] := {}; \)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(Clear[NewSys]; \n
    NewSys[gv_, {}, l\[Sigma]_, {v_, \[Sigma]_, eqs_}] := \n\t
      Block[{}, \n\t\tSetVariables[v]; \n\t\tAppendTo[result, \[Sigma]]; {}\n
        \t]; \nNewSys[gv_, forms_, l\[Sigma]_, {v_, \[Sigma]_, eqs_}] := \n\t
      Block[{}, \n\t\tSetVariables[v]; \n\t\t
        \[Bullet]sys[\[Sigma], Union[gv, Var[\[Sigma]]], 
          Join[forms, Map[CSMark, eqs]] /. \[Sigma], {}]\n\t]; \n
    NewSys[x_] := Block[{}, Print["\<NewSys:\>", x]; {}]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<wait\>"] := 
      \[Bullet]waitsys[id_, gv_, l\[Sigma]_, forms_] :> \n\t\t
        Block[{tmp, answer, res, \[Bullet]ORbranches}, \n\t\t\t
          answer = SendCSQuery[{"\<GetResults\>", id}]; \n\t\t\t
          tmp = Query[id]; \n\t\t\tQuery[id] = {}; \n\t\t\t
          res = Apply[\[Bullet]ORbranches, 
              Map[NewSys[gv, forms, l\[Sigma], #]&, tmp]]; \n\t\t\t
          AppendTo[res, 
            If[answer === "\<y\>", {}, 
              \[Bullet]waitsys[id, gv, l\[Sigma], forms]]]\n\t\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Termination due to sufficient number of solutions", "Subsection"],

Cell[TextData[{
  "This is the case when a sufficient number of answer substitutions were \
computed (see option ",
  ButtonBox["NSolution",
    ButtonData:>{
      FrontEnd`FileName[ {}, "TSolve.nb", CharacterEncoding -> "ISO8859-1"], 
      "TSolveOptions"},
    ButtonStyle->"Hyperlink"],
  " of ",
  ButtonBox["TSolve",
    ButtonData:>{
      FrontEnd`FileName[ {}, "TSolve.nb", CharacterEncoding -> "ISO8859-1"], 
      "TSolver"},
    ButtonStyle->"Hyperlink"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation ",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<B\>"] := x_ /; nSols \[LessEqual] 0 :> {}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Parallel-OR rule", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["||\[Dash]OR",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket] { form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[Ellipsis] form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ", forms }, cs \[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)]],
  " ",
  StyleBox["wait ",
    FontSlant->"Italic"],
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_idx\)\)]],
  "[  {forms}, cs ]"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell["Implementation", "Subsubsection",
  CellDingbat->None,
  FontSlant->"Italic",
  CellTags->"or"],

Cell[BoxData[
    \(\(cflp["\<||\[Dash]OR\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {or\[Dash]eq_DoubleVerticalBar, forms___}, 
          cs_] :> \n\t\t
        Block[{OR\[Dash]systems = 
              Apply[\[Bullet]ORbranches, 
                Map[\[Bullet]sys[\[Sigma], gv, {#, forms}, cs]&, 
                  or\[Dash]eq]]}, \n\t\t\t
          DPrint[1, Superscript["\<\[Implies]\>", "\<OR\>"], 
            OR\[Dash]systems]; \n\t\t\tOR\[Dash]systems\n\t\t]; \)\)], "Input",\

  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Sequential\[Dash]OR rule "], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["OR",
    FontColor->RGBColor[1, 0, 0]],
  "] \t\[LeftAngleBracket]{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[Or]\[Ellipsis]\[Or]form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ", forms}, \
cs\[RightAngleBracket]\[DoubleLongRightArrow]\[LeftAngleBracket]{form",
  Cell[BoxData[
      \(TraditionalForm\`\_i\)]],
  ",cs},cs\[RightAngleBracket] ",
  StyleBox[" where 1 ",
    FontWeight->"Plain"],
  "\[LessEqual] ",
  StyleBox["i",
    FontSlant->"Italic"],
  " \[LessEqual] n"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]sys[{}, \[Bullet]ORsys[x__]] := \[Bullet]sys[x]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<seq\[Dash]OR\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {or\[Dash]eq_Or, forms___}, cs_] :> \n\t\t
        Block[{}, \n\t\t\t
          DPrint[1, 
            Superscript["\<\[Implies]\>", "\<OR\>"], {First[or\[Dash]eq], 
              forms}]; \n\t\t\t
          \[Bullet]sys[\n\t\t\t\t
            \[Bullet]sys[\[Sigma], gv, {First[or\[Dash]eq], forms}, cs], \n
            \t\t\t\t\[Bullet]ORsys[\[Sigma], gv, {Rest[or\[Dash]eq], forms}, 
              cs]\n\t\t\t]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Sequential\[Dash]AND rule "], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["seq\[Dash]AND",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}, forms}, \
cs\[RightAngleBracket]\[DoubleLongRightArrow]\[LeftAngleBracket]{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",forms}, cs\[RightAngleBracket]"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<seq\[Dash]AND\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {and\[Dash]eq_List, forms___}, cs_] :> \n\t
        \[Bullet]sys[\[Sigma], gv, {Sequence\ @@\ and\[Dash]eq, forms}, cs]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["parallel\[Dash]AND rule "], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["||\[Dash]AND",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[And]\[Ellipsis]\[And]form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ", forms}, \
cs\[RightAngleBracket]\[DoubleLongRightArrow]\[LeftAngleBracket]forms",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[Wedge]\[Ellipsis]\[Wedge]forms",
  Cell[BoxData[
      \(TraditionalForm\`\_k\)]],
  ", forms}, cs\[RightAngleBracket]\n\t\t",
  StyleBox["where ",
    FontWeight->"Plain"],
  "{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}=forms",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[UnionPlus]\[Ellipsis]\[UnionPlus]forms",
  Cell[BoxData[
      \(TraditionalForm\`\_k\)]],
  "\n\t\t",
  StyleBox["and ",
    FontWeight->"Plain"],
  "forms",
  Cell[BoxData[
      FormBox[
        SubscriptBox["", 
          StyleBox["j",
            FontSlant->"Plain"]], TraditionalForm]]],
  StyleBox[" are minimal subsets of ",
    FontWeight->"Plain"],
  "{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}",
  StyleBox[" such that \n\t\t",
    FontWeight->"Plain"],
  "Vars",
  StyleBox["[",
    FontWeight->"Plain"],
  "forms",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox["", 
            StyleBox["j",
              FontSlant->"Plain"]],
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["]\[Intersection]",
    FontWeight->"Plain"],
  "Vars",
  StyleBox["[",
    FontWeight->"Plain"],
  "{form",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],form",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}",
  StyleBox["-",
    FontWeight->"Plain"],
  "forms",
  Cell[BoxData[
      FormBox[
        StyleBox[
          SubscriptBox["", 
            StyleBox["j",
              FontSlant->"Plain"]],
          FontSlant->"Italic"], TraditionalForm]]],
  StyleBox["]",
    FontWeight->"Plain"],
  "=\[EmptySet]"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[ANDSelectionCriterium]; \n
    ANDSelectionCriterium[e_] := 
      MemberQ[e, _?\((MemberQ[tmpvars, #]&)\), \[Infinity]]; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(Clear[\[Bullet]ANDPartition]; \n
    \[Bullet]ANDPartition[eqs_List] := \[Bullet]ANDPartitionAux[eqs, {}]; 
    \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    RowBox[{
    \(Clear[\[Bullet]ANDPartitionAux]\), ";", "\n", 
      \(\[Bullet]ANDPartitionAux[{}, ps_List] := ps\), ";", 
      StyleBox["\n",
        ShowStringCharacters->True,
        NumberMarks->True], 
      RowBox[{
        RowBox[{
          StyleBox[
            RowBox[{
              StyleBox["\[Bullet]",
                ShowStringCharacters->True,
                NumberMarks->True], "ANDPartitionAux"}]], "[", 
          StyleBox[\({form_, \ forms___}, \ ps_List\),
            ShowStringCharacters->True,
            NumberMarks->True], 
          StyleBox["]",
            ShowStringCharacters->True,
            NumberMarks->True]}], 
        StyleBox[" ",
          ShowStringCharacters->True,
          NumberMarks->True], 
        StyleBox[":=",
          ShowStringCharacters->True,
          NumberMarks->True], 
        StyleBox[" ",
          ShowStringCharacters->True,
          NumberMarks->True], 
        RowBox[{
          StyleBox["Block",
            ShowStringCharacters->True,
            NumberMarks->True], 
          StyleBox["[",
            ShowStringCharacters->True,
            NumberMarks->True], 
          RowBox[{
            
            StyleBox[
              \({tmpvars\  = \ Var[form], \ newp\  = \ {form}, \ newforms, \ 
                oldforms\  = \ {forms}}\),
              ShowStringCharacters->True,
              NumberMarks->True], 
            StyleBox[",",
              ShowStringCharacters->True,
              NumberMarks->True], 
            StyleBox[" ",
              ShowStringCharacters->True,
              NumberMarks->True], 
            RowBox[{
              
              StyleBox[
                \(While[True, \ 
                  newforms\  = \ Select[oldforms, \ ANDSelectionCriterium]; \ 
                  \n\t\t\tIf[newforms\  === \ {}, \ \n\t\t\t\tBreak[], \ \n
                    \t\t\t\ttmpvars\  = \ Var[newforms]; \ \n\t\t\t\t
                    newp\  = \ Join[newp, \ newforms]; \ \n\t\t\t\t
                    oldforms\  = \ Complement[oldforms, \ newforms]]]\),
                ShowStringCharacters->True,
                NumberMarks->True], 
              StyleBox[";",
                ShowStringCharacters->True,
                NumberMarks->True], 
              StyleBox[" ",
                ShowStringCharacters->True,
                NumberMarks->True], 
              StyleBox["\n",
                ShowStringCharacters->True,
                NumberMarks->True], 
              StyleBox["\t\t",
                ShowStringCharacters->True,
                NumberMarks->True], 
              RowBox[{
                StyleBox[
                  RowBox[{
                    StyleBox["\[Bullet]",
                      ShowStringCharacters->True,
                      NumberMarks->True], "ANDPartitionAux"}]], "[", 
                RowBox[{"oldforms", ",", " ", 
                  StyleBox[\(Append[ps, \ newp]\),
                    ShowStringCharacters->True,
                    NumberMarks->True]}], 
                StyleBox["]",
                  ShowStringCharacters->True,
                  NumberMarks->True]}]}]}], 
          StyleBox["]",
            ShowStringCharacters->True,
            NumberMarks->True]}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<||\[Dash]AND\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {and\[Dash]eqs_And, forms___}, cs_] :> \n
        \t\tBlock[{neweqs = Flatten[List\ @@\ and\[Dash]eqs, 1], 
            eqPartition}, \n\t\t\t
          eqPartition = \[Bullet]ANDPartition[neweqs]; \n\t\t\t
          If[Length[eqPartition] > 1, \n\t\t\t\t
            \[Bullet]sys[\[Sigma], gv, {Wedge\ @@\ eqPartition, forms}, cs], 
            \n\t\t\t\t
            \[Bullet]sys[\[Sigma], gv, {First[eqPartition], forms}, cs]\n
            \t\t\t]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[TextData[{
  "[",
  StyleBox["AND\[Dash]1",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{}\[Wedge]\[Ellipsis]\[Wedge]{}, forms}, cs\
\[RightAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)]],
  "\[LeftAngleBracket]forms}, cs\[RightAngleBracket]",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox["",
            "TraditionalForm"], 
          FormBox["",
            "TraditionalForm"]}], TraditionalForm]]]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<AND\[Dash]1\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {form : Wedge[{} ... ], forms___}, cs_] :> 
        \n\t\t\((DPrint[1, \*"\"\<\!\(\[Implies]\^AND\)\>\"", {forms}]; 
          \[Bullet]sys[\[Sigma], gv, {forms}, cs])\); \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]],

Cell[TextData[{
  "[",
  StyleBox["AND\[Dash]2",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]forms",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[Wedge]\[Ellipsis]\[Wedge]forms",
  Cell[BoxData[
      \(TraditionalForm\`\_k\)]],
  ", forms}, cs\[RightAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleLongRightArrow]\_\(\(\[Sigma]\_1\) 
          \[Ellipsis]\[Sigma]\_k\)\)]],
  "\[LeftAngleBracket]forms",
  Cell[BoxData[
      \(TraditionalForm\`\('\_1\)\)]],
  "\[Wedge]\[Ellipsis]\[Wedge]forms'",
  Cell[BoxData[
      \(TraditionalForm\`\(\ \_k\)\)]],
  ", forms}, cs \[Union] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Union]\+\(i = 1\)\%k\)]],
  Cell[BoxData[
      \(TraditionalForm\`cs\_k\)]],
  "\[RightAngleBracket]\n\t\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  "\[LeftAngleBracket]forms,{}\[RightAngleBracket]",
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\_\(\[Sigma]\_i\)\)]],
  "\[LeftAngleBracket]forms'",
  Cell[BoxData[
      \(TraditionalForm\`\_i\)]],
  ", ",
  Cell[BoxData[
      \(TraditionalForm\`cs\_i\)]],
  "\[RightAngleBracket] ",
  Cell[BoxData[
      FormBox[
        RowBox[{
          FormBox["",
            "TraditionalForm"], 
          FormBox["",
            "TraditionalForm"]}], TraditionalForm]]]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<AND\[Dash]2\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {andform_Wedge, forms___}, cs_] :> \n\t
        Block[\n\t\t\t{cflpFailed = False, \n\t\t\t\tnewSystems, tmp, \n
            \t\t\t\t\[Sigma]New, csNew, gvNew = gv, \n\t\t\t\tandformNew, 
            current\[Dash]sys}, \n
          \t\t\t (*\ 
            generate\ the\ states\ of\ the\ interpreter\ which\ are\ processed
              \ simultaneously\ *) \n\t\t\t
          newSystems = 
            Map[\[Bullet]sys[{}, gv \[Intersection] Var[#], 
                  Append[#, True], {}]&, andform]; \n\t\t\t
          \(newSystems = newSystems /. CFLPRules;\)\n
          \t\t\t (*\ d\\etect\ inconsistencies\ *) ; \n\t\t\t
          \(If[cflpFailed, Return[{}]]; \)\n
          \t\t\t (*\ generate\ the\ new\ AND\[Dash]goal\ *) ; \n\t\t\t
          \[Sigma]New = {}; csNew = cs; \n\t\t\tandformNew = Wedge[]; \n\t\t\t
          While[newSystems =!= Wedge[], \n\t\t\t\t
            current\[Dash]sys = First[newSystems]; \n\t\t\t\t
            \[Sigma]New = 
              Join[\[Sigma]New, 
                current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]]; 
            \n\t\t\t\t
            gvNew = Union[gvNew, 
                current\[Dash]sys\[LeftDoubleBracket]2\[RightDoubleBracket]]; 
            \n\t\t\t\t
            csNew = ApplySubst[csNew, 
                current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]]; 
            \n\t\t\t\t
            csNew = Join[csNew, 
                current\[Dash]sys\[LeftDoubleBracket]4\[RightDoubleBracket]]; 
            \n\t\t\t\t
            AppendTo[\n\t\t\t\t\tandformNew, \n\t\t\t\t\t
              ApplySubst[\n\t\t\t\t\t\t
                Drop[current\[Dash]sys\[LeftDoubleBracket]3
                    \[RightDoubleBracket], {
                    Length[current\[Dash]sys\[LeftDoubleBracket]3
                        \[RightDoubleBracket]]}], \n\t\t\t\t\t\t
                current\[Dash]sys\[LeftDoubleBracket]1\[RightDoubleBracket]\n
                \t\t\t\t\t]\n\t\t\t\t]; \n\t\t\t\t
            newSystems = Rest[newSystems]\n\t\t\t]; \n\t\t\t
          DPrint[1, 
            Subsuperscript["\<\[Implies]\>", \[Sigma]New, "\<AND\>"], {
              Join[\[Sigma], \[Sigma]New], {andformNew, forms}, gvNew, 
              csNew}]; \n\t\t\t
          \[Bullet]sys[Join[\[Sigma], \[Sigma]New], 
            gvNew, {andformNew, forms}, csNew]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Removal of trivial equations & Variable elimination ", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["t",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{x\[TildeTilde]x, forms}, cs\[RightAngleBracket] \
\[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, cs\[RightAngleBracket]\n\t\
\[LeftAngleBracket]{x\[CupCap]x, forms}, cs\[RightAngleBracket] \
\[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, cs\[RightAngleBracket]\n[",
  
  StyleBox["v",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{x\[TildeEqual] s, forms }, cs\[RightAngleBracket] ",
  
  Cell[BoxData[
      \(TraditionalForm\`\[DoubleLongRightArrow]\)]],
  " ",
  StyleBox["fail",
    FontSlant->"Italic"],
  "  ",
  StyleBox["if ",
    FontWeight->"Plain"],
  "s\[Element]T(F",
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]],
  ",V) ",
  StyleBox["with ",
    FontWeight->"Plain"],
  "x\[Element]Vars(s)",
  StyleBox["\n\t",
    FontSlant->"Italic"],
  "\[LeftAngleBracket]{x\[TildeEqual] s, forms }, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleLongRightArrow]\_\(\[Sigma] = {x \[RightArrow] s}\)\)]],
  " ",
  StyleBox["\[LeftAngleBracket] ",
    FontSlant->"Italic"],
  "{forms}\[Sigma], cs \[Sigma] \[RightAngleBracket]  ",
  StyleBox["if ",
    FontWeight->"Plain"],
  "s\[Element]T(F",
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]],
  ",V)",
  StyleBox[" with ",
    FontWeight->"Plain"],
  "x\[Element]V-Vars(s)"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<t\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {\((eq | ppeq)\)[x_, x_], forms___}, 
          cs_] :> \n\t\t
        Block[{}, \n\t\t\t
          DPrint[1, \*"\"\<\!\(\[Implies]\^t\)\>\"", {forms}]; \n\t\t\t
          \[Bullet]sys[\[Sigma], gv, {forms}, cs]]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<v1\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {_[x_?IsVar, y_?IsVar], forms___}, cs_] :> 
        \n\t\tBlock[{\[Sigma]new = If[MemberQ[gv, x], y -> x, x -> y], 
            newforms}, \n\t\t\tnewforms = ApplySubst[{forms}, \[Sigma]new]; \n
          \t\t\tDPrint[1, 
            Subsuperscript["\<\[Implies]\>", \[Sigma]new, "\<v\>"], 
            newforms]; \n\t\t\t
          \[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], \[Sigma]new], \n\t\t\t\t\t
            If[MemberQ[gv, x], Append[gv, y], gv], \n\t\t\t\t\tnewforms, \n
            \t\t\t\t\tApplySubst[cs, \[Sigma]new]\n\t\t\t\t]\n\t\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<v2\>"] := 
      \[Bullet]sys[\[Sigma]_, 
            gv_, {_[x_?IsVar, t_Function] | _[t_Function, x_?IsVar], 
              forms___}, cs_] /; Or[IsConstrV[t], IsValue[t]] :> \n\t\t
        Block[{\[Sigma]new, newforms}, \n\t\t\t
          If[MemberQ[t, x, \(-1\)], \n\t\t\t\tcflpFailed = True; {}, \n
            \t\t\t\t\[Sigma]new = x \[Rule] t; \n\t\t\t\t
            newforms = ApplySubst[{forms}, \[Sigma]new]; \n\t\t\t\t
            DPrint[1, Subsuperscript["\<\[Implies]\>", \[Sigma]new, "\<v\>"], 
              newforms]; \n\t\t\t\t
            If[IsHiVar[x], 
              Map[SetHiVar, Cases[t, f_?IsVar[__] :> f, \[Infinity]]]]; \n
            \t\t\t\t\[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], \[Sigma]new], \n
              \t\t\t\t\tIf[MemberQ[gv, x], Join[gv, Var[t]], gv], \n\t\t\t\t\t
              newforms, \n\t\t\t\t\tApplySubst[cs, \[Sigma]new]\n\t\t\t\t]\n
            \t\t\t]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<v3\>"] := 
      \[Bullet]sys[\[Sigma]_, 
            gv_, {_[x_?IsVar, t_] | _[t_, x_?IsVar], forms___}, cs_] /; 
          Or[IsConstrV[t], IsValue[t]] :> \n\t\t
        Block[{\[Sigma]new}, \n\t\t\t
          If[MemberQ[t, x, \(-1\)], \n\t\t\t\tcflpFailed = True; {}, \n
            \t\t\t\t\[Sigma]new = x \[Rule] t; \n\t\t\t\t
            DPrint[1, Subsuperscript["\<\[Implies]\>", \[Sigma]new, "\<v\>"], 
              ApplySubst[{forms}, \[Sigma]new]]; \n\t\t\t\t
            \[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], \[Sigma]new], \n
              \t\t\t\t\tIf[MemberQ[gv, x], Join[gv, Var[t]], gv], \n\t\t\t\t\t
              ApplySubst[{forms}, \[Sigma]new], \n\t\t\t\t\t
              ApplySubst[cs, \[Sigma]new]\n\t\t\t\t]\n\t\t\t]\n\t\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Transfer to the Constraint Store ", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["xdel",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{\[LeftCeiling]t\[TildeTilde]t\[RightCeiling], \
forms}, cs\[RightAngleBracket] \
\[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, cs\[RightAngleBracket]\n[",
  
  StyleBox["xfer",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{\[LeftCeiling]e\[RightCeiling], forms}, {e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}\[RightAngleBracket] \[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, \
{e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",e}\[RightAngleBracket]\n[",
  StyleBox["D",
    FontColor->RGBColor[1, 0, 0]],
  "] \t\[LeftAngleBracket]{s\[TildeTilde]t, forms}, {e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}\[RightAngleBracket] \[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, \
{e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",s\[TildeTilde]t}\[RightAngleBracket]",
  StyleBox[" if ",
    FontWeight->"Plain"],
  "s\[TildeTilde]t",
  StyleBox[" is a differential equation",
    FontWeight->"Plain"],
  "\n\t\[LeftAngleBracket]{s\[CupCap]t, forms}, {e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "}\[RightAngleBracket] \[DoubleLongRightArrow]\[LeftAngleBracket]{forms}, \
{e",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],e",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",s\[TildeTilde]t}\[RightAngleBracket]",
  StyleBox[" if ",
    FontWeight->"Plain"],
  "s\[TildeTilde]t",
  StyleBox[" is a differential equation",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<xdel\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {CSMark[eq[u_, u_]], forms___}, cs_] :> \n
        \tBlock[{}, \n\t\t
          DPrint[1, Superscript["\<\[Implies]\>", "\<xdel\>"], {forms}]; \n
          \t\t\[Bullet]sys[\[Sigma], gv, {forms}, cs]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<xfer\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {CSMark[e_], forms___}, cs_] :> \n\t
        Block[{}, \n\t\t
          DPrint[1, Superscript["\<\[Implies]\>", "\<xfer\>"], {forms}]; \n
          \t\t\[Bullet]sys[\[Sigma], gv, {forms}, Append[cs, e]]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<D\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {\((eq | ppeq)\)[s_, t_], forms___}, 
            cs_] /; Not[FreeQ[eq[s, t], _?IsHiVar]] :> 
        \[Bullet]sys[\[Sigma], gv, {forms}, Append[cs, eq[s, t]]]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outermost narrowing", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["on",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{f[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "]\[TildeEqual]t, forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",r\[TildeTilde]t,form,forms}, cs\[RightAngleBracket]\n\t",
  StyleBox["if ",
    FontWeight->"Plain"],
  "f[l",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],l",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "] \[RightArrow] r \[DoubleLeftArrow] form",
  StyleBox[" is a fresh variant of some rule of ",
    FontWeight->"Plain"],
  "R"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\[Bullet]sys[{}, \[Bullet]Nsys[_, _, _, _, {}, _, _]] := {}; \n
    \[Bullet]sys[{}, 
        \[Bullet]Nsys[\[Sigma]_, gv_, t_, e_, {s_, nr_, l_}, {forms___}, 
          cs_]] := \n\t
      Block[{neweqns = NewCFLP[e, VariantsRule[s, nr], t, forms]}, \n\t\t
        DPrint[1, \*"\"\<\!\(\[Implies]\^on\)\>\"", neweqns]; \n\t\t
        If[l == nr, \n\t\t\t\[Bullet]sys[\[Sigma], gv, neweqns, cs], \n\t\t\t
          \[Bullet]sys[\n\t\t\t\t\[Bullet]sys[\[Sigma], gv, neweqns, cs], \n
            \t\t\t\t\[Bullet]Nsys[\[Sigma], gv, t, 
              e, {s, nr + 1, l}, {forms}, cs]\n\t\t\t]\n\t\t]\n\t]; \)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<on\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \n
          \t\t{eq[s : 
                  \((f_?IsDefinedSymbol)\)\n\t\t\t\t\t\t\t | 
                    \((f_?IsDefinedSymbol[___])\), t_]\n\t\t\t\t\t | 
              eq[t_, s : 
                  \((f_?IsDefinedSymbol)\)\n\t\t\t\t\t\t\t\t | 
                    \((f_?IsDefinedSymbol[___])\)], forms___}, cs_] :> \n\t\t
        If[RewriteRuleList[f] === {}, \n\t\t\t{}, \n\t\t\t
          \[Bullet]sys[{}, \n\t\t\t\t
            \[Bullet]Nsys[\[Sigma], gv, t, 
              eq, {s, 1, Length[RewriteRuleList[f]]}, {forms}, cs]\n\t\t\t]\n
          \t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Simplification rule", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["simplif",
    FontColor->RGBColor[1, 0, 0]],
  "] \[LeftAngleBracket]{\[CurlyPhi][",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[TildeEqual] t, forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{\[LeftFloor]e\[RightFloor], forms}, \
cs\[RightAngleBracket]\n\t\t",
  StyleBox["where ",
    FontWeight->"Plain"],
  "e=Simplify[\[CurlyPhi][",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[TildeEqual] t]  ",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["\[CurlyPhi]",
    FontSlant->"Italic"],
  "\[Element]",
  Cell[BoxData[
      \(TraditionalForm\`F\_e\)]]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<simplif1\>"] := 
      \[Bullet]sys[\[Sigma]_, 
            gv_, {\((eq | ppeq)\)[\((\[CurlyPhi]_)\)[args__], t_], forms___}, 
            cs_] /; And[IsExternal[\[CurlyPhi]], 
            Not[IsValue[\[CurlyPhi][args]]]] :> \n\t\t
        \[Bullet]sys[\[Sigma], gv, 
          \[Bullet]spl[Simplify[eq[\[CurlyPhi][args], t]], forms], cs]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<simplif2\>"] := 
      \[Bullet]sys[\[Sigma]_, 
            gv_, {\((eq | ppeq)\)[s_, \((\[Psi]_)\)[args__]], forms___}, 
            cs_] /; And[IsExternal[\[Psi]], Not[IsValue[\[Psi][args]]]] :> \n
        \t\[Bullet]sys[\[Sigma], gv, 
          \[Bullet]spl[Simplify[eq[s, \[Psi][args]]], forms], cs]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Imitation rule", "Subsection"],

Cell[TextData[{
  "\n[",
  StyleBox["xi",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{\[LeftFloor]\[CurlyPhi][",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[TildeEqual] t\[RightFloor], forms}, cs\[RightAngleBracket] \
\[DoubleLongRightArrow]\[LeftAngleBracket]{",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  "\[TildeTilde]",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ", \[Ellipsis], ",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "\[TildeTilde]",
  Cell[BoxData[
      \(TraditionalForm\`x\_m\)]],
  ",\[LeftCeiling]\[CurlyPhi][",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]\[TildeEqual] y]\[RightCeiling],forms}, cs\[RightAngleBracket]\n\twhere ",
  
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  ",y\[Element]V",
  StyleBox[" are fresh variables",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<xi1\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \[Bullet]spl[_[t_, t_], forms___], cs_] :> 
        \n\t\[Bullet]sys[\[Sigma], gv, {forms}, cs]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<xi2\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, 
            \[Bullet]spl[eq[\[CurlyPhi]_[args__], t_], forms___], cs_] /; 
          IsExternal[\[CurlyPhi]] :> \n\t\t
        Block[{newV = NewX/@{args}, neweqs, eqMarked}, \n\t\t\t
          neweqs = {NewEqns[eq, {args}, newV]}; \n\t\t\t
          \(Function[eqMarked = CSMark[eq[\[CurlyPhi]\ @@\ newV, #]]; 
              AppendTo[newV, #]]\)[NewX[]]; \n\t\t\t
          neweqs = Join[neweqs, {eqMarked, eq[Last[newV], t], forms}]; \n
          \t\t\tDPrint[1, Superscript["\<\[Implies]\>", "\<i\>"], neweqs]; \n
          \t\t\t\[Bullet]sys[\[Sigma], Join[gv, newV], neweqs, cs]\n\t\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<xi3\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, 
            \[Bullet]spl[eq[s_, \[Psi]_[args__]], forms___], cs_] /; 
          IsExternal[\[Psi]] :> \n\t\t
        Block[{newV = NewX/@{args}, neweqs, eqMarked}, \n\t\t\t
          neweqs = {NewEqns[eq, {args}, newV]}; \n\t\t\t
          \(Function[eqMarked = CSMark[eq[#, \[Psi]\ @@\ newV]]; 
              AppendTo[newV, #]]\)[NewX[]]; \n\t\t\t
          neweqs = Join[neweqs, {eqMarked, eq[s, Last[newV]], forms}]; \n
          \t\t\tDPrint[1, Superscript["\<\[Implies]\>", "\<i\>"], neweqs]; \n
          \t\t\t\[Bullet]sys[\[Sigma], Join[gv, newV], neweqs, cs]\n\t\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[TextData[{
  "Otherwise the simplified equation ",
  StyleBox["e",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " does not have sides with external operators at root position. In this \
case, ",
  StyleBox["e",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " will be treated like any other equation."
}], "Text"],

Cell[BoxData[
    \(\(cflp["\<xi4\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \[Bullet]spl[e_, forms___], cs_] :> \n\t
        \[Bullet]sys[\[Sigma], gv, {e, forms}, cs]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Outermost narrowing on flex terms with projection binding",
  FontSize->14]], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["ovp",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[TildeEqual] t, forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{",
  Cell[BoxData[
      \(TraditionalForm\`s\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[TildeEqual] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]\[Lambda][{",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "}, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]]",
  StyleBox["} ",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[TextData[{
  "[",
  StyleBox["ovp\[Dash]pp",
    FontColor->RGBColor[1, 0, 0]],
  "] \n\t\[LeftAngleBracket]{X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[CupCap] t, forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{",
  Cell[BoxData[
      \(TraditionalForm\`s\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[CupCap] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]\[Lambda][{",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "}, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]]",
  StyleBox["} \n\t\n\t",
    FontWeight->"Plain"],
  "\[LeftAngleBracket]{t\[CupCap]X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "], forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{",
  Cell[BoxData[
      \(TraditionalForm\`s\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[CupCap] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]\[Lambda][{",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "}, ",
  Cell[BoxData[
      \(TraditionalForm\`x\_i\)]],
  "[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]]",
  StyleBox["} ",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[TextData[StyleBox["Implementation (disabled)",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox[
"Outermost narrowing on flex terms with imitation binding",
  FontSize->14]], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["ovi",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[TildeEqual] t, forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[TildeEqual] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]",
  StyleBox["} ",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[TextData[{
  "[",
  StyleBox["ovi\[Dash]pp",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\n\t\[LeftAngleBracket]{X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "] \[CupCap] t, forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[CupCap] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]",
  StyleBox["}\n\t \n\t",
    FontWeight->"Plain"],
  "\[LeftAngleBracket]{t\[CupCap]X[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "], forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm\`\(\[DoubleLongRightArrow]\_\[Theta]\)\)]],
  "\[LeftAngleBracket]{g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`s\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`s\_n\)]],
  "]]\[CupCap] t,forms}\[Theta], cs \[Theta]\[RightAngleBracket]\n\t",
  StyleBox["if  ",
    FontWeight->"Plain"],
  StyleBox["n",
    FontSlant->"Italic"],
  " \[GreaterEqual] 1, ",
  StyleBox["t",
    FontSlant->"Italic"],
  StyleBox["  not flex, and ",
    FontWeight->"Plain"],
  "\[Theta]=",
  StyleBox["{",
    FontWeight->"Plain"],
  "X\[Rule]g[",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "1"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "],\[Ellipsis],",
  Cell[BoxData[
      FormBox[
        SubscriptBox[
          StyleBox["H",
            FontSlant->"Plain"], "m"], TraditionalForm]]],
  "[",
  Cell[BoxData[
      \(TraditionalForm\`x\_1\)]],
  ",\[Ellipsis],",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  "]",
  StyleBox["} ",
    FontWeight->"Plain"]
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation (partially enabled)",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[CFLPImitation]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[g_, 
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], t_?IsNotFlex], 
            forms___}, cs_]] := \n\t
      Block[{tmp}, \n\t\t
        DPrint[1, "\<imitation rule:\>", EqType[X[params], t]]; \n\t\t
        tmp = \(Function[\n
              \t\t\t\t\t{#2, 
                X -> \((
                    Apply[\[Lambda], 
                        \(Function[{#3, #1\ @@\ 
                                \((Function[#4, #4\ @@\ #3]\ /@\ #2)\)}]
                            \)[#1, #2, #3, #4]] /. {x_?IsConstructor[] :> x})
                    \)}]\)\n\t\t\t[g, Table[NewX[], {Arity[g]}], 
            Table[NewX[], {Length[{params}]}], NewX[]]; \n\t\t
        CFLP[\[Bullet]sys[
            Append[\[Sigma], tmp\[LeftDoubleBracket]2\[RightDoubleBracket]], 
            If[MemberQ[gv, X], 
              Join[gv, tmp\[LeftDoubleBracket]1\[RightDoubleBracket]], gv], 
            cv, ApplySubst[{EqType[t, X\ [params]], forms}, 
              tmp\[LeftDoubleBracket]2\[RightDoubleBracket]], 
            ApplySubst[cs, tmp\[LeftDoubleBracket]2\[RightDoubleBracket]]]]\n
        \t]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[g_, 
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[t_?IsNotFlex, X_?IsVar[params__]], 
            forms___}, cs_]] := \n\t
      Block[{tmp}, \n\t\t
        DPrint[1, "\<imitation rule:\>", EqType[t, X[params]]]; \n\t\t
        tmp = \(Function[\n
              \t\t\t\t\t{#2, 
                X -> \((
                    Apply[\[Lambda], 
                        \(Function[{#3, #1\ @@\ 
                                \((Function[#4, #4\ @@\ #3]\ /@\ #2)\)}]
                            \)[#1, #2, #3, #4]] /. {x_?IsConstructor[] :> x})
                    \)}]\)\n\t\t\t[g, Table[NewX[], {Arity[g]}], 
            Table[NewX[], {Length[{params}]}], NewX[]]; \n\t\t
        CFLP[\[Bullet]sys[
            Append[\[Sigma], tmp\[LeftDoubleBracket]2\[RightDoubleBracket]], 
            If[MemberQ[gv, X], 
              Join[gv, tmp\[LeftDoubleBracket]1\[RightDoubleBracket]], gv], 
            cv, ApplySubst[{EqType[t, X\ [params]], forms}, 
              tmp\[LeftDoubleBracket]2\[RightDoubleBracket]], 
            ApplySubst[cs, tmp\[LeftDoubleBracket]2\[RightDoubleBracket]]]]\n
        \t]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(cflp["\<ovi1\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \n
            \t\t{\((eq | ppeq)\)[x_?IsVar[params__?IsVar], t_?IsVarValue], 
              forms___}, cs_] /; 
          \((Length[Union[{params}]] == Length[{params}])\) :> \n\t\t
        Block[{\[Sigma]new = \(x \[Rule] Function[#1, #2]&\)[{params}, t], 
            newforms}, \n\t\t\tnewforms = ApplySubst[{forms}, \[Sigma]new]; \n
          \t\t\tDPrint[1, 
            Subsuperscript["\<\[Implies]\>", \[Sigma]new, "\<ovi\>"], {
              forms}]; \n\t\t\t
          \[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], \[Sigma]new], \n\t\t\t\t\t
            If[MemberQ[gv, x], 
              Join[gv, 
                Var[\[Sigma]new\[LeftDoubleBracket]2\[RightDoubleBracket]]], 
              gv], \n\t\t\t\t\tnewforms, \n\t\t\t\t\t
            ApplySubst[cs, \[Sigma]new]\n\t\t\t\t]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(cflp["\<ovi2\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \n
            \t\t{\((eq | ppeq)\)[t_?IsVarValue, x_?IsVar[params__?IsVar]], 
              forms___}, cs_] /; 
          \((Length[Union[{params}]] == Length[{params}])\) :> \n\t\t
        Block[{\[Sigma]new = \(x \[Rule] Function[#1, #2]&\)[{params}, t], 
            newforms}, \n\t\t\tnewforms = ApplySubst[{forms}, \[Sigma]new]; \n
          \t\t\tDPrint[1, 
            Subsuperscript["\<\[Implies]\>", \[Sigma]new, "\<ovi\>"], {
              forms}]; \n\t\t\t
          \[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], \[Sigma]new], \n\t\t\t\t\t
            If[MemberQ[gv, x], 
              Join[gv, 
                Var[\[Sigma]new\[LeftDoubleBracket]2\[RightDoubleBracket]]], 
              gv], \n\t\t\t\t\tnewforms, \n\t\t\t\t\t
            ApplySubst[cs, \[Sigma]new]\n\t\t\t\t]\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], f_?IsVarValue], 
            forms___}, cs_]] = \n\t
      CFLPImitation[f, 
        \[Bullet]sys[\[Sigma], gv, cv, {EqType[X[params], f], forms}, cs]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], 
              f_?IsConstructor], forms___}, cs_]] = \n\t
      CFLPImitation[f, 
        \[Bullet]sys[\[Sigma], gv, cv, {EqType[X[params], f], forms}, cs]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[f_?IsConstructor, 
              X_?IsVar[params__]], forms___}, cs_]] := \n\t
      CFLPImitation[f, 
        \[Bullet]sys[\[Sigma], gv, cv, {EqType[X[params], f], forms}, cs]]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], 
              f_?IsConstructor[args___]], forms___}, cs_]] = \n\t
      CFLPImitation[f, 
        \[Bullet]sys[\[Sigma], gv, cv, {EqType[X[params], f[args]], forms}, 
          cs]]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, cv_, \n
          \t\t{\((EqType : eq | ppeq)\)[f_?IsConstructor[args___], 
              X_?IsVar[params__]], forms___}, cs_]] = \n\t
      CFLPImitation[f, 
        \[Bullet]sys[\[Sigma], gv, cv, {EqType[f[args], X[params]], forms}, 
          cs]]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[t_?IsNotFlex, X_?IsVar[params__]], 
            forms___}, cs_]] := \n\t{}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPImitation[
        \[Bullet]sys[\[Sigma]_, gv_, 
          cv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], t_?IsNotFlex], 
            forms___}, cs_]] := \n\t{}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  StyleBox[" [",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["ovp",
    FontSize->14,
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  StyleBox["] ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["Outermost narrowing on flex terms with projection binding",
    FontSize->14]
}], "Subsection",
  CellDingbat->"\[EmptyCircle]"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(Clear[CFLPProjection]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPProjection[
        \[Bullet]sys[\[Sigma]_, 
          gv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], t_?IsNotFlex], 
            forms___}, cs_]] := \n\t
      \((DPrint[1, "\<projection rule:\>", EqType[X[params], t]]; \n\t\t
        Join\ @@\ 
          Map[CFLPImitation[#, 
                \[Bullet]sys[\[Sigma], gv, {EqType[X[params], t], forms}, 
                  cs]]&, \n\t\t\t\t
            Select[{params}, \((Head[Arity[#]] =!= Arity)\)&]])\); \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLPProjection[
        \[Bullet]sys[\[Sigma]_, 
          gv_, {\((EqType : eq | ppeq)\)[t_?IsNotFlex, X_?IsVar[params__]], 
            forms___}, cs_]] := \n\t
      \((DPrint[1, "\<projection rule:\>", EqType[X[params], t]]; \n\t\t
        Join\ @@\ 
          Map[CFLPImitation[#, 
                \[Bullet]sys[\[Sigma], gv, {EqType[t, X[params]], forms}, 
                  cs]]&, \n\t\t\t\t
            Select[{params}, \((Head[Arity[#]] =!= Arity)\)&]])\); \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[TextData[{
  StyleBox[" [ov] ",
    FontSize->14,
    FontWeight->"Bold"],
  StyleBox["Outermost narrowing for flex terms",
    FontSize->14]
}], "Text"],

Cell[BoxData[
    \(\(CFLP[
        \[Bullet]sys[\[Sigma]_, 
          gv_, {\((EqType : eq | ppeq)\)[X_?IsVar[params__], t_?IsNotFlex], 
            forms___}, cs_]] := \n\t
      Join[\n\t\t
        CFLPImitation[
          \[Bullet]sys[\[Sigma], gv, {EqType[X[params], t], forms}, cs]], \n
        \t\tCFLPProjection[
          \[Bullet]sys[\[Sigma], gv, {EqType[X[params], t], forms}, cs]]\n
        \t]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CFLP[
        \[Bullet]sys[\[Sigma]_, 
          gv_, {\((EqType : eq | ppeq)\)[t_?IsNotFlex, X_?IsVar[params__]], 
            forms___}, cs_]] := \n\t
      Join[\n\t\t
        CFLPImitation[
          \[Bullet]sys[\[Sigma], gv, {EqType[t, X[params]], forms}, cs]], \n
        \t\tCFLPProjection[
          \[Bullet]sys[\[Sigma], gv, {EqType[t, X[params]], forms}, cs]]\n
        \t]; \)\)], "Input",
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[" Variable elimination  for parameter passing equations", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["vp",
    FontColor->RGBColor[1, 0, 0]],
  "]\t{x\[CupCap]s, forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow] ",
  StyleBox["failed",
    FontSlant->"Italic"],
  StyleBox["   \n\t",
    FontWeight->"Plain"],
  "{s\[CupCap]x, forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow] ",
  StyleBox["failed",
    FontSlant->"Italic"],
  StyleBox["   \n\t\tif ",
    FontWeight->"Plain"],
  "x\[Element]Vars(s)\n\t\[LeftAngleBracket]{x\[CupCap]s, forms}, cs\
\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleLongRightArrow]\_\(\[Sigma] = {x \[Rule] s}\)\)]],
  "\[LeftAngleBracket]{ forms}\[Sigma], cs \[Sigma]\[RightAngleBracket]\n\t\
\[LeftAngleBracket]{s\[CupCap]x, forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleLongRightArrow]\_\(\[Sigma] = {x \[Rule] s}\)\)]],
  "\[LeftAngleBracket]{ forms}\[Sigma], cs \[Sigma]\[RightAngleBracket]\n\t\t\
",
  StyleBox["if ",
    FontWeight->"Plain"],
  "x\[Element]V-Vars(s)"
}], "Subsection",
  CellDingbat->None,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<vp\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {form : ppeq[s_, x_?IsVar] | ppeq[x_?IsVar, s_], forms___}, 
          cs_] :> \n\t\t
        If[MemberQ[s, x, \(-1\)], \n\t\t\tcflpFailed = True; \n\t\t\t{}, \n
          \t\t\t\(Function[\n\t\t\t\t
              DPrint[1, Subsuperscript["\<\[Implies]\>", #1, "\<v\>"], 
                ApplySubst[{forms}, #1]]; \n\t\t\t\t
              \[Bullet]sys[\n\t\t\t\t\tAppend[\[Sigma], #1], \n\t\t\t\t\t#2, 
                \n\t\t\t\t\tApplySubst[{forms}, #1], \n\t\t\t\t\tcs]]\)[
            x \[Rule] s, If[MemberQ[gv, x], Join[gv, Var[s]], gv]]\n\t\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outermost narrowing for parameter passing equations", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["onpp",
    FontColor->RGBColor[1, 0, 0]],
  "]\t\[LeftAngleBracket]{f[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "]\[CupCap]t, forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{ s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis], s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ", r\[CupCap]t, form, forms}, cs\[RightAngleBracket]\n\t\
\[LeftAngleBracket]{t\[CupCap]f[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "], forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{ s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis], s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "\[CupCap]l",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ", r\[CupCap]t, form, forms}, cs\[RightAngleBracket]\n\t\t",
  StyleBox["if ",
    FontWeight->"Plain"],
  "f[l",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],l",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "] \[RightArrow] r \[DoubleLeftArrow] form",
  StyleBox[" is a fresh variant of some rule of ",
    FontWeight->"Plain"],
  "R"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<onpp\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, \n
          \t\t{ppeq[
                s : \((f_?IsDefinedSymbol)\)\n\t\t\t\t\t\t\t | 
                    \((f_?IsDefinedSymbol[___])\), t_]\n\t\t\t\t\t | 
              ppeq[t_, 
                s : \((f_?IsDefinedSymbol)\)\n\t\t\t\t\t\t\t | 
                    \((f_?IsDefinedSymbol[___])\)], forms___}, cs_] :> \n\t\t
        If[RewriteRuleList[f] === {}, \n\t\t\t{}, \n\t\t\t
          \[Bullet]sys[{}, \n\t\t\t\t
            \[Bullet]Nsys[\[Sigma], gv, t, 
              ppeq, {s, 1, Length[RewriteRuleList[f]]}, {forms}, cs]\n\t\t\t]
            \n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Imitation", "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["i",
    FontColor->RGBColor[1, 0, 0]],
  "]  \t\[LeftAngleBracket]{ x\[TildeEqual] f[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ", \[Ellipsis], s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "], forms}, cs\[RightAngleBracket] ",
  Cell[BoxData[
      \(TraditionalForm
      \`\[DoubleLongRightArrow]\_\(\[Sigma] \[RightArrow] 
          f[x\_1, \ \[Ellipsis], \ x\_n]\)\)]],
  "\[LeftAngleBracket] {s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[TildeTilde]x",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis], s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "\[TildeTilde]",
  Cell[BoxData[
      \(TraditionalForm\`x\_n\)]],
  ", forms}\[Sigma], cs \[Sigma] \[RightAngleBracket]  \n\t",
  StyleBox["if ",
    FontWeight->"Plain"],
  "x\[Element]V",
  StyleBox[" and ",
    FontWeight->"Plain"],
  "f[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ", \[Ellipsis], s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "]\[NotElement]T(F",
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]],
  ",V)"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{\(cflp["\<i\>"]\), ":=", "\n", "\t", 
        RowBox[{
        \(\[Bullet]sys[\[Sigma]_, gv_, \n
            \t\t{eq[s_, x_?IsVar] | eq[x_?IsVar, s_], forms___}, \n\t\tcs_]
            \), ":>", "\n", "\t\t", 
          RowBox[{"Block", "[", 
            RowBox[{\({}\), ",", "\n", "\t\t\t", 
              RowBox[{"Apply", "[", 
                RowBox[{
                  RowBox[{"Function", "[", "\n", "\t\t\t\t\t", 
                    RowBox[{
                      RowBox[{"If", "[", 
                        RowBox[{
                          StyleBox["addType",
                            FontColor->RGBColor[1, 0, 0]], ",", 
                          \(TypeChecker`Tc[#1, TypeChecker`KeepTypes -> True]
                            \)}], "]"}], ";", "\n", "\t\t\t\t\t\t", 
                      \(DPrint[1, \n\t\t\t\t\t\t\t
                        Subsuperscript["\<\[Implies]\>", x \[Rule] #1, 
                          "\<i\>"], 
                        ApplySubst[{NewEqns[eq, s, #1], forms}, x \[Rule] #1]]
                        \), ";", "\n", "\t\t\t\t\t", 
                      \(\[Bullet]sys[\n\t\t\t\t\t\t
                        Append[\[Sigma], x \[Rule] #1], \n\t\t\t\t\t\t#2, \n
                        \t\t\t\t\t\t
                        ApplySubst[{NewEqns[eq, s, #1], forms}, 
                          x \[Rule] #1], \n\t\t\t\t\t\tcs]\)}], "]"}], ",", 
                  \(\({#, If[MemberQ[gv, x], Join[gv, List\ @@\ #], gv]}&\)[
                    NewC/@\ s]\)}], "\n", "\t\t\t", "]"}]}], "\n", "\t\t", 
            "]"}]}]}], ";"}]], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData["Decomposition rule for \[Lambda]\[Dash]terms"], "Subsection"],

Cell[TextData[{
  "[",
  StyleBox["d\[Lambda]",
    FontColor->RGBColor[1, 0, 0]],
  "]  \[LeftAngleBracket]{ \[Lambda][{x1,\[Ellipsis],xn}, term1]\[TildeTilde] \
\[Lambda][{y1,\[Ellipsis],yn}, term2], forms}, cs\[RightAngleBracket] \
\[DoubleLongRightArrow]\[LeftAngleBracket]{term1 \[TildeTilde] term2, forms}\
\[Sigma], cs\[RightAngleBracket]\n\twhere \
\[Sigma]={x1\[Rule]z1,\[Ellipsis],xn\[Rule]zn,y1\[Rule]z1,\[Ellipsis]yn\[Rule]\
zn} with z1,\[Ellipsis],zn\[Element]V fresh variables"
}], "Subsubsection",
  CellDingbat->None,
  FontSize->14,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{\(cflp["\<d\[Lambda]\>"]\), ":=", 
        RowBox[{
        \(\[Bullet]sys[\[Sigma]_, gv_, \n
            \t\t{e_[s_Function, t_Function], forms___}, cs_]\), ":>", "\n", 
          "\t", 
          RowBox[{"Block", "[", 
            RowBox[{\({}\), ",", "\n", "\t\t", 
              RowBox[{
                RowBox[{"Function", "[", "\n", "\t\t\t", 
                  RowBox[{
                  \(DPrint[1, 
                      \*"\"\<\!\(\[Implies]\^d\[Lambda]\)\>\"", {
                        e[s\ @@#, t\ @@#], forms}]\), ";", "\n", "\t\t  ", 
                    RowBox[{"If", "[", 
                      RowBox[{
                        StyleBox["addType",
                          FontColor->RGBColor[1, 0, 0]], ",", 
                        \(TypeChecker`Tc[#, TypeChecker`KeepTypes -> True]
                          \)}], "]"}], ";", "\n", "\t\t\t", 
                    \(\[Bullet]sys[\[Sigma], gv, {e[s\ @@#, t\ @@#], forms}, 
                      cs]\)}], "]"}], "[", 
                \(NewX\ /@\ s\[LeftDoubleBracket]1\[RightDoubleBracket]\), 
                "]"}]}], "\n", "\t", "]"}]}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell["Decomposition rule for constructor terms", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["d",
    FontColor->RGBColor[1, 0, 0]],
  "]  \t\[LeftAngleBracket]{ f \[TildeEqual] c[t",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],t",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "], forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{f[]\[TildeEqual] c[t",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],t",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "],forms}, cs \[RightAngleBracket] if f\[Element]F, c\[Element]F",
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]],
  "\n\t\[LeftAngleBracket]{ c[s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "]\[TildeTilde] c[t",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],t",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "], forms}, cs\[RightAngleBracket] \[DoubleLongRightArrow]\
\[LeftAngleBracket]{s",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  "\[TildeTilde] t",
  Cell[BoxData[
      \(TraditionalForm\`\_1\)]],
  ",\[Ellipsis],s",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  "\[TildeTilde]t",
  Cell[BoxData[
      \(TraditionalForm\`\_n\)]],
  ",forms}, cs \[RightAngleBracket] if c\[Element]F",
  Cell[BoxData[
      \(TraditionalForm\`\_c\)]]
}], "Subsection",
  CellDingbat->None,
  Background->GrayLevel[0.900008]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<d1\>"] := \n\t
      \[Bullet]sys[\[Sigma]_, gv_, \n
          \t\t{_[s_?AtomQ, t_?IsConstructorTerm] | _[t_?IsConstructorTerm, 
                s_?AtomQ], forms___}, cs_] :> \n\t\t
        If[t === s \[Or] t === s[], \n\t\t\t
          DPrint[1, \*"\"\<\!\(\[Implies]\^d\)\>\"", {forms}]; 
          \[Bullet]sys[\[Sigma], gv, {forms}, cs], \n\t\t\t
          cflpFailed = True; {}\n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(cflp["\<d2\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {e_[\((f_?IsConstructor)\)[fargs___], 
              \((g_?IsConstructor)\)[gargs___]], forms___}, cs_] :> \n\t\t
        If[f === g \[And] Length[{fargs}] == Length[{gargs}], \n\t\t\t
          DPrint[1, 
            \*"\"\<\!\(\[Implies]\^d\)\>\"", {NewEqns[e, {fargs}, {gargs}], 
              forms}]; \n\t\t\t
          \[Bullet]sys[\[Sigma], gv, {NewEqns[e, {fargs}, {gargs}], forms}, 
            cs], \n\t\t\tcflpFailed = True; \n\t\t\t{}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " [",
  StyleBox["oth",
    FontColor->RGBColor[1, 0, 0]],
  "] Otherwise"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(cflp["\<oth\>"] := 
      \[Bullet]sys[_, _, {e : _[f_[___], g_[___]], ___}, _] :> \n\t\t
        Block[{}, \n\t\t\t
          DPrint[1, Superscript["\<\[Implies]\>", "\<oth\>"], {}]; \n
          \t\t\t{}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" CFLPRules", "Section"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\(CFLPRules := 
      Map[cflp, \n
        \t\t{\n\t\t\t\t"\<AND\[Dash]1\>", \n\t\t\t\t"\<AND\[Dash]2\>", \n
          \t\t\t\t"\<B\>", "\<wait\>", \n\t\t\t\t"\<seq\[Dash]OR\>", \n
          \t\t\t\t"\<||\[Dash]OR\>", \t\t\t\t\n\t\t\t\t"\<seq\[Dash]AND\>", \n
          \t\t\t\t"\<||\[Dash]AND\>", \n\t\t\t\t"\<t\>", \n\t\t\t\t"\<v1\>", 
          \n\t\t\t\ \ "\<v2\>", \n\t\t\t\t"\<v3\>", \n\t\t\t\t"\<xdel\>", \n
          \t\t\t\t"\<xfer\>", \n\t\t\t\t"\<D\>", \n\t\t\t\t"\<on\>", \n
          \t\t\t\t"\<ovi1\>", \n\t\t\t\t"\<ovi2\>", \n\t\t\t\t"\<simplif1\>", 
          \n\t\t\t\t"\<simplif2\>", \n\t\t\t\t"\<xi1\>", \n\t\t\t\t"\<xi2\>", 
          \n\t\t\t\t"\<xi3\>", \n\t\t\t\t"\<xi4\>", \n\t\t\t\t"\<vp\>", \n
          \t\t\t\t"\<onpp\>", \n\t\t\t\t"\<i\>", \n\t\t\t\t"\<d\[Lambda]\>", 
          \n\t\t\t\t"\<d1\>", \n\t\t\t\t"\<d2\>", \n\t\t\t\t"\<oth\>"}]; \)\ 
    \)\)], "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" CallTSolve", "Section"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tCallTSolve",
    FontWeight->"Bold"],
  "[ ",
  StyleBox["form, vars, elims, n,",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["typeInfo",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "]\n",
  StyleBox["Input",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  StyleBox["form",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the equational formula to be solved\n",
  StyleBox["vars",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " : the basic variables of ",
  StyleBox["form\nelims",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": the eliminable variables of ",
  StyleBox["form\nn",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": the maximum number of solutions required by the user\n",
  StyleBox["typeInfo",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": boolean optional argument. If True then types are inferred and \
associated to all the variables which are introduced during a CFLP \
derivation. It has the dafault value False."
}], "Text",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[TextData[{
  StyleBox["Output\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a list containing the first ",
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " solutions computed for ",
  StyleBox["form",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Local Variables",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[TextData[{
  StyleBox["callCS",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": boolean flag. By default False, it is set on True after the first query \
of the constraint scheduler.\n",
  StyleBox["hV",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": the higher order variables that appear in derivative (partial \
derivative) equations.\n",
  StyleBox["gV",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": set of goal variables. \n",
  StyleBox["nSols",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": maximum number of solutions to be computed.\n",
  StyleBox["pV",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ":  set of parameters (eliminable variables).\n",
  StyleBox["queryIndex",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": integer used for indexing the constraint solving queries.\n",
  StyleBox["result ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": list of computed results.\n",
  StyleBox["sysCrt",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  ": data structure representing the current goal of the CFLP derivation "
}], "Text",
  CellMargins->{{48, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    RowBox[{
      RowBox[{
      \(CallTSolve[eqs_, vars_List, elims_List, ns_, typeInfo_:  False]\), 
        ":=", "\n", "\t", 
        RowBox[{"Block", "[", "\n", "\t\t", 
          RowBox[{
            RowBox[{"{", 
              RowBox[{
                RowBox[{
                  StyleBox["addType"], "=", "typeInfo"}], ",", "\n", 
                "\t\t\t", 
                RowBox[{
                  StyleBox["callCS"], "=", "False"}], ",", "\n", "\t\t\t", 
                StyleBox["gV"], ",", 
                StyleBox["hV"], ",", "\n", "\t\t\t", 
                RowBox[{
                  StyleBox["queryIndex"], "=", "0"}], ",", "\n", "\t\t\t", 
                RowBox[{
                  StyleBox["result"], "=", \({}\)}], ",", "\n", "\t\t\t", 
                RowBox[{
                  StyleBox["pV"], "=", \(Constructor\ @@\ elims\)}], ",", 
                "\n", "\t\t\t", 
                RowBox[{
                  StyleBox["nSols"], "=", "ns"}], ",", "initialVars", ",", 
                "\n", "\t\t\t", 
                StyleBox["sysCrt"], ",", "\n", "\t\t\t", 
                \(oldV = 
                  Select[Join[vars, elims] /. {
                        e_Pattern :> 
                          e\[LeftDoubleBracket]1\[RightDoubleBracket]}, IsVar]
                    \)}], "\n", "\t\t", "}"}], ",", "\n", "\t\t", 
            RowBox[{
              RowBox[{"initialVars", "=", 
                RowBox[{"(", 
                  RowBox[{
                    StyleBox["gV"], "=", \(SetVariables[vars]\)}], ")"}]}], 
              ";", "\n", "\t\t", 
              RowBox[{
                StyleBox["sysCrt"], "=", \(\[Bullet]sys[{}, gV, eqs]\)}], 
              ";", "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{"TcCall", ",", "\n", "\t\t\t", 
                  RowBox[{"FixedPoint", "[", 
                    RowBox[{\(ReplaceAll[#, TSolveRules]&\), ",", 
                      StyleBox["sysCrt"]}], "]"}], ",", "\n", "\t\t\t", 
                  RowBox[{
                    RowBox[{"AppendTo", "[", 
                      RowBox[{
                        StyleBox["sysCrt"], ",", \({}\)}], "]"}], ";", "\n", 
                    "\t\t\t", 
                    RowBox[{
                      StyleBox["hV"], "=", 
                      \(Union\ @@\ 
                        Map[Cases[#, 
                              \(\(Derivative[__]\)[f_?IsVar]\)[__] :> f, 
                              \[Infinity]]&, eqs]\)}], ";", "\n", "\t\t\t", 
                    RowBox[{"Map", "[", 
                      RowBox[{"SetHiVar", ",", 
                        StyleBox["hV"]}], "]"}], ";", "\n", "\t\t\t", 
                    RowBox[{"While", "[", 
                      RowBox[{
                        RowBox[{
                          StyleBox["sysCrt"], "=!=", \({}\)}], ",", "\n", 
                        "\t\t\t\t", 
                        RowBox[{"If", "[", 
                          RowBox[{
                          \(NotebookFind[Debug`Private`\[Bullet]ctrlPanel, 
                                "\<Interrupting\>", Next] =!= $Failed\), ",", 
                            "\n", "\t\t\t\t\t", 
                            RowBox[{
                            \(cflpInterrupt = True\), ";", "\n", 
                              "\t\t\t\t\t", \(Print["\<Interrupted\>"]\), 
                              ";", "\n", "\t\t\t\t\t", 
                              RowBox[{
                                StyleBox["result"], "=", \({}\)}], ";", "\n", 
                              "\t\t\t\t\t", \(Break[]\)}], ",", "\n", 
                            "\t\t\t\t\t", 
                            RowBox[{
                              StyleBox["sysCrt"], "=", 
                              RowBox[{
                                StyleBox["sysCrt"], "/.", 
                                "TSolveRules"}]}]}], "\n", "\t\t\t\t", 
                          "]"}]}], "\n", "\t\t\t", "]"}]}]}], "\n", "\t\t", 
                "]"}], ";", "\n", "\t\t", 
              RowBox[{
                StyleBox["result"], "=", 
                RowBox[{
                  RowBox[{"Function", "[", 
                    RowBox[{"Select", "[", 
                      RowBox[{"#", ",", 
                        RowBox[{
                          RowBox[{\(Head[#] =!= Rule\), "\[Or]", 
                            RowBox[{"MemberQ", "[", 
                              RowBox[{
                                StyleBox["gV"], ",", 
                                \(#\[LeftDoubleBracket]1
                                  \[RightDoubleBracket]\)}], "]"}]}], 
                          "&"}]}], "]"}], "]"}], " ", "/@", " ", 
                  StyleBox["result"]}]}], ";", "\n", "\t\t", 
              RowBox[{"ClearVariables", "[", 
                StyleBox["gV"], "]"}], ";", "\n", "\t\t", 
              \(SetVariables[oldV]\), ";", "\n", "\t\t", 
              RowBox[{"Map", "[", 
                RowBox[{\(\((IsHiVar[#] =. )\)&\), ",", 
                  StyleBox["hV"]}], "]"}], ";", "\n", "\t\t", 
              \( (*\ reset\ the\ scheduler\ *) \), "\n", "\t\t", 
              RowBox[{"If", "[", 
                RowBox[{
                  StyleBox["callCS"], ",", \(SendCSQuery[{"\<Reset\>"}]\)}], 
                "]"}], ";", " ", "\n", "\t\t", 
              RowBox[{"Simplify", "[", 
                StyleBox["result"], "]"}]}]}], "\n", "\t", "]"}]}], ";"}]], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  Background->None]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EndPackage Demo", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell["Package Demo", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{4, Automatic}, {Automatic, 16}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "b"->{
    Cell[30585, 1072, 101, 3, 42, "Subsubsection",
      CellTags->"b"]},
  "cs1"->{
    Cell[32117, 1127, 102, 3, 42, "Subsubsection",
      CellTags->"cs1"]},
  "cs2"->{
    Cell[35670, 1219, 102, 3, 42, "Subsubsection",
      CellTags->"cs2"]},
  "wait"->{
    Cell[38587, 1289, 67, 1, 29, "Subsection",
      CellTags->"wait"]},
  "or"->{
    Cell[43046, 1446, 101, 3, 42, "Subsubsection",
      CellTags->"or"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"b", 124466, 4062},
  {"cs1", 124551, 4065},
  {"cs2", 124638, 4068},
  {"wait", 124726, 4071},
  {"or", 124809, 4074}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 73, 1, 102, "Title"],
Cell[1807, 54, 210, 4, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2042, 62, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2109, 65, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4472, 110, 39, 0, 53, "Subtitle"],
Cell[4514, 112, 225, 4, 50, "Text"],
Cell[4742, 118, 255, 5, 43, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5022, 127, 27, 0, 45, "Subsection"],
Cell[5052, 129, 121, 3, 27, "Input",
  InitializationCell->True],
Cell[5176, 134, 283, 6, 43, "Input",
  InitializationCell->True],
Cell[5462, 142, 377, 7, 75, "Input",
  InitializationCell->True],
Cell[5842, 151, 124, 3, 27, "Input",
  InitializationCell->True],
Cell[5969, 156, 335, 7, 59, "Input",
  InitializationCell->True],
Cell[6307, 165, 403, 7, 75, "Input",
  InitializationCell->True],
Cell[6713, 174, 315, 6, 59, "Input",
  InitializationCell->True],
Cell[7031, 182, 255, 5, 43, "Input",
  InitializationCell->True],
Cell[7289, 189, 283, 6, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7621, 201, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[7680, 205, 24, 0, 54, "Section"],
Cell[7707, 207, 183, 5, 27, "Input",
  InitializationCell->True],
Cell[7893, 214, 229, 5, 27, "Input",
  InitializationCell->True],
Cell[8125, 221, 134, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[8284, 228, 31, 0, 45, "Subsection"],
Cell[8318, 230, 555, 21, 104, "Text"],

Cell[CellGroupData[{
Cell[8898, 255, 125, 3, 42, "Subsubsection"],
Cell[9026, 260, 361, 7, 107, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[9436, 273, 29, 0, 29, "Subsection"],
Cell[9468, 275, 484, 20, 86, "Text"],

Cell[CellGroupData[{
Cell[9977, 299, 125, 3, 42, "Subsubsection"],
Cell[10105, 304, 322, 7, 91, "Input",
  InitializationCell->True],
Cell[10430, 313, 182, 4, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10661, 323, 38, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[10724, 327, 125, 3, 42, "Subsubsection"],
Cell[10852, 332, 346, 9, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11247, 347, 30, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[11302, 351, 125, 3, 42, "Subsubsection"],
Cell[11430, 356, 794, 19, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[12273, 381, 52, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[12350, 385, 125, 3, 42, "Subsubsection"],
Cell[12478, 390, 684, 14, 155, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13211, 410, 53, 0, 29, "Subsection"],
Cell[13267, 412, 1011, 19, 203, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[14315, 436, 36, 0, 29, "Subsection"],
Cell[14354, 438, 190, 5, 27, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[14581, 448, 30, 0, 29, "Subsection"],
Cell[14614, 450, 1269, 60, 104, "Text"],
Cell[15886, 512, 1183, 53, 50, "Text"],

Cell[CellGroupData[{
Cell[17094, 569, 125, 3, 42, "Subsubsection"],
Cell[17222, 574, 370, 10, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[17641, 590, 35, 0, 29, "Subsection"],
Cell[17679, 592, 1545, 66, 140, "Text"],
Cell[19227, 660, 586, 22, 32, "Text"],
Cell[19816, 684, 1653, 67, 50, "Text"],

Cell[CellGroupData[{
Cell[21494, 755, 125, 3, 42, "Subsubsection"],
Cell[21622, 760, 405, 10, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[22088, 777, 148, 4, 34, "Section"],
Cell[22239, 783, 606, 16, 68, "Text"],
Cell[22848, 801, 1004, 34, 68, "Text"],
Cell[23855, 837, 1422, 46, 86, "Text"],
Cell[25280, 885, 983, 34, 50, "Text"],
Cell[26266, 921, 543, 17, 50, "Text"],
Cell[26812, 940, 326, 7, 50, "Text"],
Cell[27141, 949, 388, 10, 50, "Text"],
Cell[27532, 961, 298, 7, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[27867, 973, 113, 1, 54, "Section"],
Cell[27983, 976, 108, 3, 32, "Text"],
Cell[28094, 981, 374, 9, 68, "Text"],
Cell[28471, 992, 464, 10, 68, "Text"],
Cell[28938, 1004, 245, 7, 32, "Text"],
Cell[29186, 1013, 496, 16, 50, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29719, 1034, 24, 0, 54, "Section"],
Cell[29746, 1036, 155, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[29926, 1045, 72, 1, 45, "Subsection"],
Cell[30001, 1048, 196, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[30234, 1059, 326, 9, 61, "Subsection"],

Cell[CellGroupData[{
Cell[30585, 1072, 101, 3, 42, "Subsubsection",
  CellTags->"b"],
Cell[30689, 1077, 592, 13, 215, "Input",
  InitializationCell->True],
Cell[31284, 1092, 345, 9, 91, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],
Cell[31656, 1105, 72, 1, 45, "Subsection"],

Cell[CellGroupData[{
Cell[31753, 1110, 339, 13, 61, "Subsection"],

Cell[CellGroupData[{
Cell[32117, 1127, 102, 3, 42, "Subsubsection",
  CellTags->"cs1"],
Cell[32222, 1132, 2931, 61, 283, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[35180, 1197, 72, 1, 29, "Subsection"],

Cell[CellGroupData[{
Cell[35277, 1202, 368, 13, 61, "Subsection"],

Cell[CellGroupData[{
Cell[35670, 1219, 102, 3, 42, "Subsubsection",
  CellTags->"cs2"],
Cell[35775, 1224, 2763, 59, 267, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[38587, 1289, 67, 1, 29, "Subsection",
  CellTags->"wait"],
Cell[38657, 1292, 1092, 40, 77, "Subsubsection"],

Cell[CellGroupData[{
Cell[39774, 1336, 103, 2, 42, "Subsubsection"],
Cell[39880, 1340, 226, 5, 59, "Input",
  InitializationCell->True],
Cell[40109, 1347, 644, 13, 203, "Input",
  InitializationCell->True],
Cell[40756, 1362, 703, 16, 139, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[41508, 1384, 71, 0, 29, "Subsection"],
Cell[41582, 1386, 487, 15, 32, "Text"],

Cell[CellGroupData[{
Cell[42094, 1405, 104, 2, 42, "Subsubsection"],
Cell[42201, 1409, 155, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[42405, 1418, 38, 0, 45, "Subsection"],
Cell[42446, 1420, 575, 22, 59, "Subsubsection"],

Cell[CellGroupData[{
Cell[43046, 1446, 101, 3, 42, "Subsubsection",
  CellTags->"or"],
Cell[43150, 1451, 629, 15, 91, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43828, 1472, 57, 0, 29, "Subsection"],
Cell[43888, 1474, 634, 24, 59, "Subsubsection"],

Cell[CellGroupData[{
Cell[44547, 1502, 103, 2, 42, "Subsubsection"],
Cell[44653, 1506, 244, 7, 27, "Input",
  InitializationCell->True],
Cell[44900, 1515, 668, 15, 139, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[45617, 1536, 58, 0, 29, "Subsection"],
Cell[45678, 1538, 581, 21, 59, "Subsubsection"],

Cell[CellGroupData[{
Cell[46284, 1563, 103, 2, 42, "Subsubsection"],
Cell[46390, 1567, 374, 9, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[46813, 1582, 56, 0, 29, "Subsection"],
Cell[46872, 1584, 2225, 91, 112, "Subsubsection"],

Cell[CellGroupData[{
Cell[49122, 1679, 103, 2, 42, "Subsubsection"],
Cell[49228, 1683, 307, 8, 43, "Input",
  InitializationCell->True],
Cell[49538, 1693, 291, 8, 43, "Input",
  InitializationCell->True],
Cell[49832, 1703, 3408, 92, 187, "Input",
  InitializationCell->True],
Cell[53243, 1797, 706, 15, 139, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[53964, 1815, 571, 19, 59, "Subsubsection"],

Cell[CellGroupData[{
Cell[54560, 1838, 103, 2, 42, "Subsubsection"],
Cell[54666, 1842, 417, 9, 44, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[55098, 1854, 1408, 49, 82, "Subsubsection"],

Cell[CellGroupData[{
Cell[56531, 1907, 103, 2, 42, "Subsubsection"],
Cell[56637, 1911, 2586, 51, 539, "Input",
  InitializationCell->True]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[59272, 1968, 74, 0, 29, "Subsection"],
Cell[59349, 1970, 1480, 50, 111, "Subsubsection"],

Cell[CellGroupData[{
Cell[60854, 2024, 103, 2, 42, "Subsubsection"],
Cell[60960, 2028, 450, 11, 76, "Input",
  InitializationCell->True],
Cell[61413, 2041, 787, 16, 187, "Input",
  InitializationCell->True],
Cell[62203, 2059, 1102, 21, 299, "Input",
  InitializationCell->True],
Cell[63308, 2082, 946, 19, 251, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[64303, 2107, 55, 0, 29, "Subsection"],
Cell[64361, 2109, 1998, 67, 110, "Subsubsection"],

Cell[CellGroupData[{
Cell[66384, 2180, 103, 2, 42, "Subsubsection"],
Cell[66490, 2184, 445, 10, 91, "Input",
  InitializationCell->True],
Cell[66938, 2196, 451, 11, 91, "Input",
  InitializationCell->True],
Cell[67392, 2209, 400, 10, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[67841, 2225, 41, 0, 29, "Subsection"],
Cell[67885, 2227, 1036, 39, 76, "Subsubsection"],

Cell[CellGroupData[{
Cell[68946, 2270, 103, 2, 42, "Subsubsection"],
Cell[69052, 2274, 784, 16, 203, "Input",
  InitializationCell->True],
Cell[69839, 2292, 799, 18, 187, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[70687, 2316, 41, 0, 29, "Subsection"],
Cell[70731, 2318, 886, 32, 76, "Subsubsection"],

Cell[CellGroupData[{
Cell[71642, 2354, 103, 2, 42, "Subsubsection"],
Cell[71748, 2358, 536, 13, 59, "Input",
  InitializationCell->True],
Cell[72287, 2373, 499, 12, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[72835, 2391, 36, 0, 29, "Subsection"],
Cell[72874, 2393, 1156, 42, 93, "Subsubsection"],

Cell[CellGroupData[{
Cell[74055, 2439, 103, 2, 42, "Subsubsection"],
Cell[74161, 2443, 335, 8, 43, "Input",
  InitializationCell->True],
Cell[74499, 2453, 835, 17, 139, "Input",
  InitializationCell->True],
Cell[75337, 2472, 820, 17, 139, "Input",
  InitializationCell->True],
Cell[76160, 2491, 330, 11, 50, "Text"],
Cell[76493, 2504, 331, 8, 43, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76873, 2518, 116, 2, 29, "Subsection"],
Cell[76992, 2522, 2247, 92, 76, "Subsubsection"],
Cell[79242, 2616, 4326, 177, 144, "Subsubsection"],
Cell[83571, 2795, 114, 2, 42, "Subsubsection"]
}, Open  ]],

Cell[CellGroupData[{
Cell[83722, 2802, 115, 2, 45, "Subsection"],
Cell[83840, 2806, 1993, 80, 76, "Subsubsection"],
Cell[85836, 2888, 3819, 153, 144, "Subsubsection"],

Cell[CellGroupData[{
Cell[89680, 3045, 123, 2, 42, "Subsubsection"],
Cell[89806, 3049, 126, 3, 27, "Input",
  InitializationCell->True],
Cell[89935, 3054, 1223, 24, 203, "Input"],
Cell[91161, 3080, 1223, 24, 203, "Input"],
Cell[92387, 3106, 955, 18, 219, "Input",
  InitializationCell->True],
Cell[93345, 3126, 955, 18, 219, "Input",
  InitializationCell->True],
Cell[94303, 3146, 376, 9, 59, "Input",
  InitializationCell->True],
Cell[94682, 3157, 381, 9, 59, "Input",
  InitializationCell->True],
Cell[95066, 3168, 382, 9, 59, "Input",
  InitializationCell->True],
Cell[95451, 3179, 402, 9, 59, "Input",
  InitializationCell->True],
Cell[95856, 3190, 408, 9, 75, "Input",
  InitializationCell->True],
Cell[96267, 3201, 274, 6, 59, "Input",
  InitializationCell->True],
Cell[96544, 3209, 274, 6, 59, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[96867, 3221, 371, 14, 29, "Subsection"],

Cell[CellGroupData[{
Cell[97263, 3239, 103, 2, 42, "Subsubsection"],
Cell[97369, 3243, 127, 3, 27, "Input",
  InitializationCell->True],
Cell[97499, 3248, 572, 13, 91, "Input",
  InitializationCell->True],
Cell[98074, 3263, 572, 13, 91, "Input",
  InitializationCell->True],
Cell[98649, 3278, 158, 6, 33, "Text"],
Cell[98810, 3286, 463, 11, 107, "Input"],
Cell[99276, 3299, 463, 11, 107, "Input"]
}, Closed]]
}, Open  ]],
Cell[99766, 3314, 76, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[99867, 3318, 1099, 31, 148, "Subsection"],

Cell[CellGroupData[{
Cell[100991, 3353, 103, 2, 42, "Subsubsection"],
Cell[101097, 3357, 804, 17, 219, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[101950, 3380, 73, 0, 29, "Subsection"],
Cell[102026, 3382, 1593, 59, 93, "Subsubsection"],

Cell[CellGroupData[{
Cell[103644, 3445, 103, 2, 42, "Subsubsection"],
Cell[103750, 3449, 803, 18, 187, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104602, 3473, 31, 0, 29, "Subsection"],
Cell[104636, 3475, 1196, 46, 79, "Subsubsection"],

Cell[CellGroupData[{
Cell[105857, 3525, 103, 2, 42, "Subsubsection"],
Cell[105963, 3529, 1761, 36, 283, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[107773, 3571, 76, 0, 29, "Subsection"],
Cell[107852, 3573, 584, 13, 76, "Subsubsection"],

Cell[CellGroupData[{
Cell[108461, 3590, 103, 2, 42, "Subsubsection"],
Cell[108567, 3594, 1234, 26, 156, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],
Cell[109828, 3624, 62, 0, 29, "Subsection"],

Cell[CellGroupData[{
Cell[109915, 3628, 1410, 50, 78, "Subsection"],

Cell[CellGroupData[{
Cell[111350, 3682, 103, 2, 42, "Subsubsection"],
Cell[111456, 3686, 582, 13, 150, "Input",
  InitializationCell->True],
Cell[112041, 3701, 697, 15, 134, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[112787, 3722, 110, 5, 29, "Subsection"],

Cell[CellGroupData[{
Cell[112922, 3731, 103, 2, 42, "Subsubsection"],
Cell[113028, 3735, 391, 10, 75, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[113480, 3752, 29, 0, 34, "Section"],

Cell[CellGroupData[{
Cell[113534, 3756, 103, 2, 42, "Subsubsection"],
Cell[113640, 3760, 945, 15, 523, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[114634, 3781, 30, 0, 54, "Section"],
Cell[114667, 3783, 484, 21, 68, "Text"],
Cell[115154, 3806, 838, 25, 122, "Text"],
Cell[115995, 3833, 300, 12, 50, "Text"],

Cell[CellGroupData[{
Cell[116320, 3849, 126, 3, 42, "Subsubsection"],
Cell[116449, 3854, 1202, 37, 158, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[117688, 3896, 125, 3, 42, "Subsubsection"],
Cell[117816, 3901, 5512, 116, 603, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[123377, 4023, 34, 0, 54, "Section"],
Cell[123414, 4025, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[123583, 4032, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],
Cell[123771, 4040, 31, 0, 54, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

