(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     13292,        451]*)
(*NotebookOutlinePosition[     13987,        476]*)
(*  CellTagsIndexPosition[     13943,        472]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Typing Rules", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[
"This package contains the definitions of the inference rules for \
type\[Dash]checking CFLP expressions."], "Text"],

Cell[BoxData[
    \(\(BeginPackage[
      "\<TypeRules`\>", {"\<Variables`\>", "\<TermSyntax`\>", 
        "\<TypeSyntax`\>", "\<Types`\>"}]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(cflpTypeRules::usage; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(\\[Bullet]tcsum::usage; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[CellGroupData[{

Cell["Begin", "Section"],

Cell[BoxData[
    \(\(Begin["\<`Private`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[" \[Bullet]tc"], "Section"],

Cell[TextData[{
  StyleBox["\[Bullet]tc",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " contains the inference rules of the CFLP type checker. "
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["\[EmptySquare]",
    FontColor->RGBColor[1, 0, 0]],
  "] Type rule for the empty type ",
  StyleBox["\[EmptySquare]",
    FontColor->RGBColor[1, 0, 0]]
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]tc["\<\[EmptySquare]\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {eq[FuncType[\[EmptySquare], \[Tau]1_], \[Tau]2_]\n\t\t | 
              eq[\[Tau]1_, FuncType[\[EmptySquare], \[Tau]2_]], forms___}] :> 
        \[Bullet]sys[\[Sigma], gv, {eq[\[Tau]1, \[Tau]2], forms}]; \)\)], 
  "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["t",
    FontColor->RGBColor[1, 0, 0]],
  "] Removal of trivial equations"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]tc["\<t\>"] := 
      \[Bullet]sys[\[Sigma]_, gv_, {eq[\[Tau]_, \[Tau]_], forms___}] :> 
        \[Bullet]sys[\[Sigma], gv, {forms}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["v",
    FontColor->RGBColor[1, 0, 0]],
  "] Variable elimination"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Clear[prec]; \nprec[Int] = 0; prec[Rat] = 1; prec[Float] = 2; 
    prec[Compl] = 3; \)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(\[Bullet]tc["\<v\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {eq[x_?IsVar, \[Tau]_] | eq[\[Tau]_, x_?IsVar], forms___}] :> 
        \n\t\tBlock[{new\[Sigma]}, \n\t\t\t
          If[MemberQ[\[Tau], x, \(-1\)], \n\t\t\t\t{}, \n\t\t\t\t
            new\[Sigma] = 
              If[MemberQ[{Int, Rat, Float, Compl}, \[Tau]], 
                x \[Rule] x[\[Tau]], x \[Rule] \[Tau]]; \n\t\t\t\t
            \[Bullet]sys[Prepend[\[Sigma] /. new\[Sigma], new\[Sigma]], 
              gv, {forms} /. new\[Sigma]]\n\t\t\t]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  "[",
  StyleBox["sum",
    FontColor->RGBColor[1, 0, 0]],
  "] Type rule for sum types"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]tc["\<sum1\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {eq[_?IsVar[\[Tau]_], _?IsVar[\[Tau]_]], forms___}] :> \n\t\t
        \[Bullet]sys[\[Sigma], gv, {forms}]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(\[Bullet]tc["\<sum2\>"] := 
      \[Bullet]sys[\[Sigma]_, 
          gv_, {eq[\[Alpha]1_?IsVar[\[Tau]1_], \[Alpha]2_?IsVar[\[Tau]2_]], 
            forms___}] :> \n\t
        Block[{new\[Sigma]}, \n\t\t\t
          new\[Sigma] = 
            If[prec[\[Tau]1] > prec[\[Tau]2], 
              \[Alpha]2[\[Tau]2] \[Rule] \[Alpha]2[\[Tau]1], 
              \[Alpha]1[\[Tau]1] \[Rule] \[Alpha]1[\[Tau]2]]; \n\t\t\t
          \[Bullet]sys[\[Sigma] /. new\[Sigma], gv, {forms} /. new\[Sigma]]\n
          \t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]],

Cell[BoxData[
    \(\(\[Bullet]tc["\<sum3\>"] := \n\t
      \[Bullet]sys[\[Sigma]_, 
            gv_, {eq[x_?IsVar[\[Tau]1_], \[Tau]2_] | 
                eq[\[Tau]2_, x_?IsVar[\[Tau]1_]], forms___}] /; 
          MemberQ[{Int, Rat, Float, Compl}, \[Tau]2] :> \n\t\t
        Block[{new\[Sigma]}, \n\t\t\t
          new\[Sigma] = \n\t\t\t\t
            If[\[Tau]1 === \[Tau]2, \n\t\t\t\t\t{}, \n\t\t\t\t\t
              If[prec[\[Tau]1] > prec[\[Tau]2], {
                  x[\[Tau]1] \[Rule] x[\[Tau]2]}, {
                  x[\[Tau]2] \[Rule] x[\[Tau]1]}]\n\t\t\t\t]; \n\t\t\t
          \[Bullet]sys[\[Sigma] /. new\[Sigma], gv, {forms} /. new\[Sigma]]\t
          \n\t\t]; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " [",
  StyleBox["d",
    FontColor->RGBColor[1, 0, 0]],
  "] Decomposition rule"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]tc["\<d\>"] := \n\t
      \[Bullet]sys[\[Sigma]_, 
          gv_, {eq[f_[args1__], f_[args2__]], forms___}] :> \n\t
        \[Bullet]sys[\[Sigma], gv, 
          Join[Inner[eq, f[args1], f[args2], List], {forms}]]; \)\)], "Input",\

  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
  " [",
  StyleBox["oth",
    FontColor->RGBColor[1, 0, 0]],
  "] Otherwise"
}], "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(\[Bullet]tc["\<oth\>"] := _ :> {}; \)\)], "Input",
  InitializationCell->True,
  FontFamily->"Courier New",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 0, 0.500008],
  Background->GrayLevel[1]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[" cflpTypeRules", "Section"],

Cell[TextData[{
  StyleBox["cflpTypeRules",
    FontWeight->"Bold"],
  " is the list of type rules used for type\[Dash]checking CFLP expressions \
(terms, goals, conditional rewrite-rules)."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(cflpTypeRules := 
      \(Map[\[Bullet]tc, {"\<\[EmptySquare]\>", "\<t\>", "\<v\>", "\<sum1\>", 
          "\<sum2\>", 
          \(\*"\""sum3 "\<,\>" d "\<,\>" oth \*"\"\<}];\> "\)\)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["EndPackage Demo", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Package Demo", "Section"],

Cell[BoxData[
    \(<< TypeRules.m\)], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{25, Automatic}, {-7, Automatic}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 68, 1, 102, "Title"],
Cell[1802, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2024, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2091, 66, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4454, 111, 39, 0, 53, "Subtitle"],
Cell[4496, 113, 131, 2, 32, "Text"],
Cell[4630, 117, 224, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[4879, 126, 27, 0, 45, "Subsection"],
Cell[4909, 128, 181, 5, 27, "Input",
  InitializationCell->True],
Cell[5093, 135, 183, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[5325, 146, 34, 0, 64, "Subtitle"],

Cell[CellGroupData[{
Cell[5384, 150, 24, 0, 54, "Section"],
Cell[5411, 152, 183, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[5631, 162, 41, 0, 54, "Section"],
Cell[5675, 164, 164, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[5864, 173, 204, 7, 45, "Subsection"],

Cell[CellGroupData[{
Cell[6093, 184, 103, 2, 42, "Subsubsection"],
Cell[6199, 188, 475, 11, 43, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6723, 205, 126, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[6874, 214, 103, 2, 42, "Subsubsection"],
Cell[6980, 218, 326, 8, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7355, 232, 118, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[7498, 241, 103, 2, 42, "Subsubsection"],
Cell[7604, 245, 263, 7, 43, "Input",
  InitializationCell->True],
Cell[7870, 254, 712, 15, 139, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8631, 275, 123, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[8779, 284, 103, 2, 42, "Subsubsection"],
Cell[8885, 288, 364, 9, 43, "Input",
  InitializationCell->True],
Cell[9252, 299, 688, 16, 91, "Input",
  InitializationCell->True],
Cell[9943, 317, 836, 18, 187, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[10828, 341, 117, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[10970, 350, 103, 2, 42, "Subsubsection"],
Cell[11076, 354, 409, 11, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[11534, 371, 110, 5, 45, "Subsection"],

Cell[CellGroupData[{
Cell[11669, 380, 103, 2, 42, "Subsubsection"],
Cell[11775, 384, 218, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12054, 397, 33, 0, 54, "Section"],
Cell[12090, 399, 202, 5, 32, "Text"],

Cell[CellGroupData[{
Cell[12317, 408, 103, 2, 42, "Subsubsection"],
Cell[12423, 412, 283, 6, 27, "Input",
  InitializationCell->True]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12755, 424, 34, 0, 34, "Section"],
Cell[12792, 426, 166, 5, 27, "Input",
  InitializationCell->True],
Cell[12961, 433, 173, 5, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13171, 443, 31, 0, 54, "Section"],
Cell[13205, 445, 47, 1, 27, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

