(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20533,        704]*)
(*NotebookOutlinePosition[     21607,        744]*)
(*  CellTagsIndexPosition[     21506,        737]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["CSLaunch", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection",
  InitializationCell->True],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{

Cell["Package Description", "Subtitle"],

Cell[TextData[{
  "This package contains functions to instantiate the distributed \
configuration of the CFLP system. The main functions provided by this package \
are ",
  StyleBox["CSStart[ ]",
    FontWeight->"Bold"],
  " and ",
  StyleBox["CSEnd[ ]",
    FontWeight->"Bold"],
  ". \n",
  StyleBox["CSStart[ ]",
    FontWeight->"Bold"],
  " creates links to the constraint solvers running on the machines specified \
in ",
  StyleBox["WorkStations",
    FontWeight->"Bold"],
  ". \n",
  StyleBox["CSEnd[ ]",
    FontWeight->"Bold"],
  " closes the links created by ",
  StyleBox["CSStart[ ]",
    FontWeight->"Bold"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(BeginPackage["\<CSLaunch`\>"]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[CellGroupData[{

Cell["Usage", "Subsection"],

Cell[BoxData[
    \(\(WorkStations::usage = 
      "\<WorkStations gives the list of assigned names of the computers on \
which the CFLP constraint solvers are being run. An empty string represents \
the name of the local machine.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(SolverList::usage = 
      "\<SolverList[meth] gives the list of MathLink connections to the \
solvers implementing the method `meth`\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSStart::usage = 
      "\<CSStart[] creates links to constraint solvers.\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(CSEnd::usage = 
      "\<CSEnd[] closes the links to the constraint solvers.\>"; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]],

Cell[BoxData[
    \(\(MethodList::usage = 
      "\<MethodList gives the list of assigned names of the constraint \
solving methods. Currently, there are available four constraint solving \
method names: \"Linear\", \"Polynomial\", \"Derivative\" and \
\"PartialDerivative\".\>"; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Implementation", "Subtitle"],

Cell[BoxData[
    \(\(Off[LinkConnect::"\<linkc\>", LinkOpen::"\<linkf\>", 
      LinkObject::"\<linkn\>", LinkObject::"\<linkd\>"]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(\(Begin["\<`Private`\>"]; \)\ \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[CellGroupData[{

Cell["CSEnd", "Subsection"],

Cell[BoxData[
    \(\(CSEnd[] := Scan[ResetSolvers, MethodList]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.500008]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CSStart", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["\n\tCSStart[ ]",
    FontWeight->"Bold"],
  "\n",
  StyleBox["Effect",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[TextData[{
  "open ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections to the constraint solvers running on the machines specified \
in the list ",
  StyleBox["WorkStations",
    FontWeight->"Bold"],
  "."
}], "Text",
  CellMargins->{{46, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(CSStart[] := Scan[SetSolverConnections, WorkStations]; \)\)], "Input",\

  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SetSolverConnections", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["SetSolverConnections[ ",
    FontWeight->"Bold"],
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] \n\t",
    FontWeight->"Bold"],
  "where ",
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is the name assigned to a computer.\n",
  StyleBox["Effect\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "connect the constraint solver to the solvers running on ",
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell["This call launches the local solvers.", "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{\(SetSolverConnections["\<\>"]\), ":=", "\n", "\t", 
        RowBox[{"Map", "[", 
          RowBox[{
            RowBox[{
              RowBox[{"(", 
                RowBox[{
                  RowBox[{"Do", "[", "\n", "\t\t\t\t", 
                    RowBox[{
                      RowBox[{\(SolverList[#]\), "=", 
                        RowBox[{"Append", "[", 
                          RowBox[{\(SolverList[#]\), ",", 
                            RowBox[{"{", 
                              RowBox[{
                                RowBox[{
                                  StyleBox["CreateMethLink",
                                    FontColor->RGBColor[1, 0, 0]], "[", "#", 
                                  "]"}], ",", "\"\<idle\>\""}], "}"}]}], 
                          "]"}]}], ",", "\n", "\t\t\t\t", 
                      \({Instances[#]}\)}], "]"}], ";", "#"}], ")"}], "&"}], 
            ",", "MethodList"}], "]"}]}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[TextData[{
  "This call establishes connections to the solvers running on machine ",
  StyleBox["name",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "."
}], "Text"],

Cell[BoxData[
    \(\(SetSolverConnections[name_String] := \n\t
      Block[{Link5000, nrC, info}, \n\t\t
        Link5000 = LinkConnect["\<5000@\>"<>name, LinkProtocol -> "\<TCP\>"]; 
        \n\t\tinfo = LinkWrite[Link5000, "\<ask\>"]; \n\t\t
        If[info === $Failed, \n\t\t\tPause[1]; \n\t\t\t
          Link5000 = 
            LinkConnect["\<5000@\>"<>name, LinkProtocol -> "\<TCP\>"]; \n
          \t\t\tinfo = LinkWrite[Link5000, "\<ask\>"]\n\t\t]; \n\t\t
        If[info =!= $Failed, \n\t\t\tnrC = LinkRead[Link5000]; \n\t\t\t
          If[nrC > 15, \n\t\t\t\tLinkWrite[Link5000, "\<ignore\>"], \n\t\t\t\t
            While[True, \n\t\t\t\t\tLinkWrite[Link5000, "\<askmore\>"]; \n
              \t\t\t\t\tWhile[Not[LinkReadyQ[Link5000]], Continue[]]; \n
              \t\t\t\t\t
              While[LinkReadyQ[Link5000], info = LinkRead[Link5000]; 
                Print[info]]; \n\t\t\t\t\t
              If[info === "\<stop\>", \n\t\t\t\t\t\t
                LinkWrite[Link5000, "\<close\>"]; \n\t\t\t\t\t\tBreak[], \n
                \t\t\t\t\t\t
                SolverList[info\[LeftDoubleBracket]1\[RightDoubleBracket]] = 
                  Join[SolverList[
                      info\[LeftDoubleBracket]1\[RightDoubleBracket]], 
                    WaitAndConnect[
                      info\[LeftDoubleBracket]2\[RightDoubleBracket]]]\n
                \t\t\t\t\t]\n\t\t\t\t]\n\t\t\t]; \n\t\t\tLinkClose[Link5000]\n
          \t\t\t (*\ , LinkWrite[$ParentLink, {"\<FFF\>"}]\ *) \n\t\t]\n\t]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CreateMethLink", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["CreateMethLink[ ",
    FontWeight->"Bold"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] \n\t",
    FontWeight->"Bold"],
  "where ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a method solving identifier\n",
  StyleBox["Return Value\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "a link object to a local instance of a ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "-solver."
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(CreateMethLink[meth_String] := \n\t
      Block[{l}, \n\t\t
        l = LinkLaunch[
            StringJoin[\n\t\t\t\t"\<math -mathlink -initfile \>", \n\t\t\t\t
              meth, "\<.m -batchoutput\>"]]; \n\t\t
        While[Not[LinkReadyQ[l]], Continue[]]; \n\t\tLinkWrite[l, "\<OK\>"]; 
        \n\t\tWhile[Not[LinkReadyQ[l]], Continue[]]; \n\t\tLinkRead[l]; l]; 
    \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["CloseLink", "Subsection"],

Cell[BoxData[
    \(\(CloseLink[lnk_LinkObject] := \n\t
      If[IsLocalLink[lnk], \n\t\tLinkWrite[lnk, Unevaluated[Exit[]]], \n\t\t
        LinkWrite[lnk, "\<close\>"]\n\t]; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Instances", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["Instances[ ",
    FontWeight->"Bold"],
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] \n\t",
    FontWeight->"Bold"],
  "where ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is the identifier of a constraint solving method.\n",
  StyleBox["Result\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  "the number of constraint solvers implementing ",
  StyleBox["meth",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " that will run locally"
}], "Text"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(Instances["\<Linear\>"] = 2; \nInstances["\<Polynomial\>"] = 2; \n
    Instances["\<Derivative\>"] = 1; \n
    Instances["\<PartialDerivative\>"] = 1; \)], "Input",
  InitializationCell->True,
  GeneratedCell->True,
  ShowStringCharacters->True,
  FontColor->RGBColor[0, 0, 0.6],
  CellTags->"resources"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["IsLocalLink", "Subsection"],

Cell[TextData[{
  StyleBox["Syntax call\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["IsLocalLink[ ",
    FontWeight->"Bold"],
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ] \n\t",
    FontWeight->"Bold"],
  "where ",
  StyleBox["link",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ",
    FontWeight->"Bold"],
  "is a ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connection to a constraint solver\n",
  StyleBox["Result\n\t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["True",
    FontWeight->"Bold"],
  " if the constraint solver was launched by the constraint scheduler\n\t",
  StyleBox["False",
    FontWeight->"Bold"],
  " otherwise\n",
  StyleBox["Implementation",
    FontWeight->"Bold",
    FontSlant->"Italic"]
}], "Text"],

Cell[BoxData[
    \(\(\(IsLocalLink[lnk_LinkObject] := 
      StringMatchQ[First[lnk], "\<math*\>"]; \)\t\)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Closed]],

Cell[CellGroupData[{

Cell["MethodList", "Subsection"],

Cell[TextData[{
  StyleBox["MethodList",
    FontWeight->"Bold"],
  " gives the list of assigned names of the constraint solving methods."
}], "Text"],

Cell[BoxData[
    \(\(MethodList := {"\<Linear\>", "\<Polynomial\>", "\<Derivative\>", 
        "\<PartialDerivative\>"}; \)\)], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WaitAndConnect", "Subsection"],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Implementation",
  FontWeight->"Bold",
  FontSlant->"Italic"]], "Subsubsection",
  CellDingbat->None],

Cell[BoxData[
    \(\(WaitAndConnect[name_String] := \n\t
      Block[{lnk}, \n\t\tlnk = LinkConnect[name]; \n\t\t
        If[lnk === $Failed, \n\t\t\t{}, \n\t\t\t
          While[Not[LinkReadyQ[lnk], Continue[]]]; \n\t\t\t
          If[LinkWrite[lnk, "\<OK\>"] =!= $Failed, \n\t\t\t\tLinkRead[lnk]; \n
            \t\t\t\t{{lnk, "\<idle\>"}}, \n\t\t\t\t{}]\n\t\t]\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["ResetSolvers", "Subsection"],

Cell[BoxData[
    \(\(ResetSolvers[name_String] := \n\t
      Block[{lnks = Map[First, SolverList[name]]}, \n\t\t
        Scan[\((LinkWrite[#, "\<close\>"]; 
              While[Not[LinkReadyQ[#]], Continue[]])\)&, \n\t\t\tlnks]; \n\t\t
        Scan[LinkClose, lnks]; \n\t\tSolverList[name] = {}\n\t]; \)\)], 
  "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SolverList", "Subsection"],

Cell[TextData[{
  StyleBox["SolverList[ ",
    FontWeight->"Bold"],
  StyleBox["meth ",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  " gives the list of ",
  StyleBox["MathLink",
    FontSlant->"Italic"],
  " connections to the constraint solvers available for ",
  StyleBox["meth",
    FontSlant->"Italic"],
  ". It is created/updated during ",
  StyleBox["SetSolverConnections",
    FontWeight->"Bold"],
  " calls. It has the syntax:\n\t",
  StyleBox["{{link_",
    FontWeight->"Bold"],
  StyleBox["1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[" ,state_",
    FontWeight->"Bold"],
  StyleBox["1",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["},\[Ellipsis],{link _",
    FontWeight->"Bold"],
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox[",state_",
    FontWeight->"Bold"],
  StyleBox["n",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["}}\n",
    FontWeight->"Bold"],
  "where ",
  StyleBox["link_",
    FontWeight->"Bold"],
  StyleBox["i",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is a ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " link object to a constraint solver of method ",
  StyleBox["meth",
    FontSlant->"Italic"],
  ", and ",
  StyleBox["state_",
    FontWeight->"Bold"],
  StyleBox["i",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the state of the constraint solver. A constraint solver can be in one \
of the following states: ",
  StyleBox["idle",
    FontSlant->"Italic"],
  " or ",
  StyleBox["waiting",
    FontSlant->"Italic"],
  ". The status of a constraint solver is controlled by the constraint \
scheduler."
}], "Text"],

Cell[BoxData[
    RowBox[{
      RowBox[{
        StyleBox[\(SolverList[_]\),
          FontWeight->"Bold"], "=", \({}\)}], ";"}]], "Input",
  InitializationCell->True,
  FontColor->RGBColor[0, 0, 0.6]]
}, Open  ]],

Cell[CellGroupData[{

Cell["WorkStations", "Subsection"],

Cell[TextData[{
  StyleBox["WorkStations",
    FontWeight->"Bold"],
  " gives the list of assigned names of the computers on which the CFLP \
constraint solvers are being run."
}], "Text"],

Cell[BoxData[
    \(\(WorkStations = {"\<\>"}; \)\)], "Input",
  InitializationCell->True,
  GeneratedCell->True,
  ShowStringCharacters->True,
  FontColor->RGBColor[0, 0, 0.6],
  CellTags->"remote"]
}, Open  ]],

Cell[CellGroupData[{

Cell["End", "Section"],

Cell[BoxData[
    \(\(End[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]],

Cell[BoxData[
    \(\(EndPackage[]; \)\)], "Input",
  PageWidth->Infinity,
  InitializationCell->True,
  ShowSpecialCharacters->False,
  FontColor->RGBColor[0, 0, 0.6]]
}, Closed]],

Cell["Example", "Section"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{Automatic, 30}, {Automatic, 12}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellTags->True
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "resources"->{
    Cell[14639, 466, 324, 8, 88, "Input",
      InitializationCell->True,
      CellTags->"resources"]},
  "remote"->{
    Cell[19871, 672, 199, 6, 40, "Input",
      InitializationCell->True,
      CellTags->"remote"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"resources", 21260, 725},
  {"remote", 21379, 729}
  }
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 64, 1, 102, "Title"],
Cell[1798, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2020, 63, 64, 1, 42, "Subsubsection",
  InitializationCell->True],
Cell[2087, 66, 2326, 40, 698, "Text",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[4450, 111, 39, 0, 53, "Subtitle"],
Cell[4492, 113, 638, 23, 86, "Text"],
Cell[5133, 138, 190, 5, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[5348, 147, 27, 0, 45, "Subsection"],
Cell[5378, 149, 317, 6, 59, "Input",
  InitializationCell->True],
Cell[5698, 157, 242, 5, 43, "Input",
  InitializationCell->True],
Cell[5943, 164, 182, 4, 27, "Input",
  InitializationCell->True],
Cell[6128, 170, 188, 5, 27, "Input",
  InitializationCell->True],
Cell[6319, 177, 362, 7, 59, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[6730, 190, 34, 0, 64, "Subtitle"],
Cell[6767, 192, 210, 4, 27, "Input",
  InitializationCell->True],
Cell[6980, 198, 129, 3, 27, "Input",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[7134, 205, 27, 0, 45, "Subsection"],
Cell[7164, 207, 147, 3, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[7348, 215, 29, 0, 45, "Subsection"],
Cell[7380, 217, 235, 10, 68, "Text"],
Cell[7618, 229, 330, 11, 32, "Text"],

Cell[CellGroupData[{
Cell[7973, 244, 125, 3, 42, "Subsubsection"],
Cell[8101, 249, 156, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[8306, 259, 42, 0, 45, "Subsection"],
Cell[8351, 261, 655, 25, 104, "Text"],

Cell[CellGroupData[{
Cell[9031, 290, 125, 3, 42, "Subsubsection"],
Cell[9159, 295, 53, 0, 32, "Text"],
Cell[9215, 297, 1055, 23, 75, "Input",
  InitializationCell->True],
Cell[10273, 322, 176, 6, 32, "Text"],
Cell[10452, 330, 1593, 28, 459, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12094, 364, 36, 0, 45, "Subsection"],
Cell[12133, 366, 647, 26, 104, "Text"],

Cell[CellGroupData[{
Cell[12805, 396, 125, 3, 42, "Subsubsection"],
Cell[12933, 401, 471, 10, 155, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[13453, 417, 31, 0, 45, "Subsection"],
Cell[13487, 419, 252, 5, 91, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[13776, 429, 31, 0, 45, "Subsection"],
Cell[13810, 431, 676, 26, 104, "Text"],

Cell[CellGroupData[{
Cell[14511, 461, 125, 3, 42, "Subsubsection"],
Cell[14639, 466, 324, 8, 88, "Input",
  InitializationCell->True,
  CellTags->"resources"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15012, 480, 33, 0, 45, "Subsection"],
Cell[15048, 482, 836, 33, 140, "Text"],
Cell[15887, 517, 182, 4, 27, "Input",
  InitializationCell->True]
}, Closed]],

Cell[CellGroupData[{
Cell[16106, 526, 32, 0, 29, "Subsection"],
Cell[16141, 528, 150, 4, 32, "Text"],
Cell[16294, 534, 199, 4, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[16530, 543, 36, 0, 45, "Subsection"],

Cell[CellGroupData[{
Cell[16591, 547, 125, 3, 42, "Subsubsection"],
Cell[16719, 552, 451, 9, 203, "Input",
  InitializationCell->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17219, 567, 34, 0, 45, "Subsection"],
Cell[17256, 569, 382, 8, 123, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[17675, 582, 32, 0, 45, "Subsection"],
Cell[17710, 584, 1691, 66, 122, "Text"],
Cell[19404, 652, 202, 6, 27, "Input",
  InitializationCell->True]
}, Open  ]],

Cell[CellGroupData[{
Cell[19643, 663, 34, 0, 45, "Subsection"],
Cell[19680, 665, 188, 5, 32, "Text"],
Cell[19871, 672, 199, 6, 40, "Input",
  InitializationCell->True,
  CellTags->"remote"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20107, 683, 22, 0, 54, "Section"],
Cell[20132, 685, 161, 5, 27, "Input",
  InitializationCell->True],
Cell[20296, 692, 168, 5, 27, "Input",
  InitializationCell->True]
}, Closed]],
Cell[20479, 700, 26, 0, 34, "Section"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

