(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40248,       1179]*)
(*NotebookOutlinePosition[     41025,       1207]*)
(*  CellTagsIndexPosition[     40981,       1203]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Examples", "Title",
  FontColor->RGBColor[0, 0, 0.500008]],

Cell["\<\
\[Copyright]1998-1999 Research Institute for Symbolic Computation \
(RISC-Linz) and Institute of Information Sciences and Electronics, Tsukuba.\
\
\>", "Text",
  InitializationCell->True],

Cell[CellGroupData[{

Cell["NO WARRANTY", "Subsubsection"],

Cell["\<\
The program was produced on an experimental basis in the
course of the research and development conducted during the project
and is provided to users as so produced on an experimental basis.
Accordingly, the program is provided without any warranty whatsoever,
whether express, implied, statutory or otherwise. The term \"warranty\"
used herein includes, but is not limited to, any warranty of the
quality, performance, merchantability and fitness for a particular
purpose of the program and the nonexistence of any infringement or
violation of any right of any third party.

Each user of the program will agree and understand, and be
deemed to have agreed and understood, that there is no warranty
whatsoever for the program and, accordingly, the entire risk arising
from or otherwise connected with the program is assumed by the user.

Therefore, neither ICOT, the copyright holder, or any other
organization that participated in or was otherwise related to the
development of the program and their respective officials, directors,
officers and other employees shall be held liable for any and all
damages, including, without limitation, general, special, incidental
and consequential damages, arising out of or otherwise in connection
with the use or inability to use the program or any product, material
or result produced or otherwise obtained by using the program,
regardless of whether they have been advised of, or otherwise had
knowledge of, the possibility of such damages at any time during the
project or thereafter. Each user will be deemed to have agreed to the
foregoing by his or her commencement of use of the program. The term
\"use\" as used herein includes, but is not limited to, the use,
modification, copying and distribution of the program and the
production of secondary products from the program.

In the case where the program, whether in its original form or
modified, was distributed or delivered to or received by a user from
any person, organization or entity other than ICOT, unless it makes or
grants independently of ICOT any specific warranty to the user in
writing, such person, organization or entity, will also be exempted
from and not be held liable to the user for any such damages as noted
above as far as the program is concerned.\t\
\>", "Text"]
}, Closed]],

Cell[CellGroupData[{

Cell["Example 1", "Subsubsection",
  FontSize->14],

Cell[TextData[{
  StyleBox["Ballistic problem ",
    FontVariations->{"Underline"->True}],
  "\n"
}], "Text",
  FontSize->14,
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< TSolve.m\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \("Copyright 1998-1999 Institute RISC-Linz and Institute of Information \
Sciences and Electronics, Tsukuba."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StartCFLP[]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell[TextData[{
  "Consider the problem of finding the falling point of an object. The object \
is launched with initial speed (",
  StyleBox["Vx",
    FontColor->RGBColor[1, 0, 0]],
  ",",
  StyleBox["Vy",
    FontColor->RGBColor[1, 0, 0]],
  ") from the ground and an incidence angle ",
  StyleBox["\[Alpha]",
    FontColor->RGBColor[1, 0, 0]],
  " with the ground. We denote by (",
  StyleBox["Xf",
    FontColor->RGBColor[1, 0, 0]],
  ",",
  StyleBox["Yf",
    FontColor->RGBColor[1, 0, 0]],
  ") the falling point and by ",
  StyleBox["Tf",
    FontColor->RGBColor[1, 0, 0]],
  " the falling time."
}], "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefinedSymbol[\n\t
      ballistic1 : 
        Float\[Cross]Float\[Cross]Float\[Cross]Float\[Cross]Float\[Cross]Float
            \[Cross]Float \[ShortRightArrow] Bool, \n\t
      ballistic2 : 
        Float\[Cross]Float\[Cross]Float\[Cross]Float\[Cross]Float\[Cross]Float
            \[Cross]Float \[ShortRightArrow] Bool\n]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({ballistic1, ballistic2}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[{Vy, Vx, \[Alpha], V0, Xf, Tf, Yf}, \n
      \t{ballistic1[Vy, Vx, \[Alpha], V0, Xf, Tf, Yf] \[RightArrow] True 
          \[DoubleLeftArrow] {Vy \[TildeTilde] Vx\ Tan[\[Alpha]], 
            Vx\^2 + Vy\^2 \[TildeTilde] V0, Xf \[TildeTilde] Vx\ Tf, 
            Yf \[TildeTilde] \(-\(981\/200\)\)\ Tf\^2 + Vy\ Tf}}]\)], "Input",\

  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(ballistic1[Vy, Vx, \[Alpha], 
            V0, Xf, Tf, Yf] \[RightArrow] True 
          \[DoubleLeftArrow] {Vy \[TildeTilde] Vx\ Tan[\[Alpha]], 
            Vx\^2 + Vy\^2 \[TildeTilde] V0, Xf \[TildeTilde] Tf\ Vx, 
            Yf \[TildeTilde] \(-\(\(981\ Tf\^2\)\/200\)\) + Tf\ Vy}\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          ballistic1[ Vy, Vx, \[Alpha], V0, Xf, Tf, Yf], True, {
          eq[ Vy, 
            Times[ Vx, 
              Tan[ \[Alpha]]]], 
          eq[ 
            Plus[ 
              Power[ Vx, 2], 
              Power[ Vy, 2]], V0], 
          eq[ Xf, 
            Times[ Tf, Vx]], 
          eq[ Yf, 
            Plus[ 
              Times[ 
                Rational[ -981, 200], 
                Power[ Tf, 2]], 
              Times[ Tf, Vy]]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]\),
          Infix[ {Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]}, ","], 
        " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \("\[DownTee]"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[
      ballistic1[Vy, Vx, Pi/4, 500. , Xf, Tf, 0. ] \[TildeTilde] True, {Vy, 
        Vx, Xf, Tf}]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({{Tf \[Rule] \(-3.22352462810232376`\), 
        Vx \[Rule] \(-15.811388300841898`\), 
        Vy \[Rule] \(-15.811388300841898`\), 
        Xf \[Rule] 50.9683995922528154`}, {Tf \[Rule] 0.`, 
        Vx \[Rule] \(-15.811388300841898`\), 
        Vy \[Rule] \(-15.811388300841898`\), Xf \[Rule] 0.`}, {
        Tf \[Rule] 0.`, Vx \[Rule] 15.811388300841898`, 
        Vy \[Rule] 15.811388300841898`, Xf \[Rule] 0.`}, {
        Tf \[Rule] 3.22352462810232376`, Vx \[Rule] 15.811388300841898`, 
        Vy \[Rule] 15.811388300841898`, Xf \[Rule] 50.9683995922528154`}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Upon the query, four answers are computed, but only the last one is \
correct, since the falling time ",
  StyleBox["Tf",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  " should be a positive number. This is due to the fact that our constraints \
are too weak. If we constrain Tf to be a positive real, then TSolve will \
generate the desired solution:"
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[{Vy, Vx, \[Alpha], V0, Xf, Tf, Yf}, \n
      \t{ballistic2[Vy, Vx, \[Alpha], V0, Xf, Tf, Yf] \[RightArrow] True 
          \[DoubleLeftArrow] {Vy \[TildeTilde] Vx\ Tan[\[Alpha]], 
            Vx\^2 + Vy\^2 \[TildeTilde] V0, Xf \[TildeTilde] Vx\ Tf, 
            Yf \[TildeTilde] \(-\(981\/200\)\)\ Tf\^2 + Vy\ Tf, \[WatchIcon], 
            \((Tf > 0)\) \[TildeTilde] True}}]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(ballistic[Vy, Vx, \[Alpha], 
            V0, Xf, Tf, Yf] \[RightArrow] True 
          \[DoubleLeftArrow] {Vy \[TildeTilde] Vx\ Tan[\[Alpha]], 
            Vx\^2 + Vy\^2 \[TildeTilde] V0, Xf \[TildeTilde] Tf\ Vx, 
            Yf \[TildeTilde] \(-\(\(981\ Tf\^2\)\/200\)\) + Tf\ Vy, 
            \[WatchIcon], \(Tf > 0\) \[TildeTilde] True}\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          ballistic[ Vy, Vx, \[Alpha], V0, Xf, Tf, Yf], True, {
          eq[ Vy, 
            Times[ Vx, 
              Tan[ \[Alpha]]]], 
          eq[ 
            Plus[ 
              Power[ Vx, 2], 
              Power[ Vy, 2]], V0], 
          eq[ Xf, 
            Times[ Tf, Vx]], 
          eq[ Yf, 
            Plus[ 
              Times[ 
                Rational[ -981, 200], 
                Power[ Tf, 2]], 
              Times[ Tf, Vy]]], \[WatchIcon], 
          eq[ 
            Greater[ Tf, 0], True]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]\),
          Infix[ {Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {Tf, V0, Vx, Vy, Xf, Yf, \[Alpha]}, ","], 
        " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \("\[DownTee]"\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "Note that after the constraints were solved (i.e., after the occurence of \
the operator  \[WatchIcon]), we require the solutions to satisfy the \
additional constraint ",
  StyleBox["Tf>0",
    FontFamily->"Fixed",
    FontWeight->"Bold"],
  ". In the current implementation, ",
  StyleBox[">",
    FontFamily->"Fixed",
    FontWeight->"Bold"],
  " is an external operator but there is no constraint solver available to \
handle inequalities. Therefore, this inequality can be \"solved\" only if Tf \
is bound to a numeric value (",
  StyleBox["Int",
    FontWeight->"Bold"],
  ", ",
  StyleBox["Float",
    FontWeight->"Bold"],
  ", or ",
  StyleBox["Rat",
    FontWeight->"Bold"],
  ")."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[
      ballistic2[Vy, Vx, Pi/4, 500. , Xf, Tf, 0. ] \[TildeTilde] True, {Vy, 
        Vx, Xf, Tf}]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({{Vy \[Rule] 15.811388300841898`, Vx \[Rule] 15.811388300841898`, 
        Xf \[Rule] 50.9683995922528154`, Tf \[Rule] 3.22352462810232376`}}
      \)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 2", "Subsubsection",
  FontSize->14],

Cell[TextData[{
  StyleBox["Piano mover's problem (restricted version)",
    FontVariations->{"Underline"->True}],
  "\nThe problem is to move a rectangle ",
  StyleBox["R",
    FontColor->RGBColor[0, 0, 1]],
  " of length ",
  StyleBox["L",
    FontColor->RGBColor[1, 0, 0]],
  " and width ",
  StyleBox["l",
    FontColor->RGBColor[1, 0, 0]],
  " through a right-angled corridor. We assume the corridor has the \
horizontal width ",
  StyleBox["Cor\[Dash]Hor",
    FontColor->RGBColor[1, 0, 0]],
  " and the vertical width ",
  StyleBox["Cor\[Dash]Ver",
    FontColor->RGBColor[1, 0, 0]],
  ". \nThe following movement was choosen (see Figure): ",
  StyleBox["R",
    FontColor->RGBColor[0, 0, 1]],
  " slides in the angle with one point of contact with the x\[Dash]axis (B) \
and a second point of contact with the y\[Dash]axis (A). This path is always \
a solution, assuming that the problem can be solved. \nWe want to determine \
the minimal width ",
  StyleBox["Cor\[Dash]Hor",
    FontColor->RGBColor[1, 0, 0]],
  " when ",
  StyleBox["Cor\[Dash]Ver",
    FontColor->RGBColor[1, 0, 0]],
  ", ",
  StyleBox["L",
    FontColor->RGBColor[1, 0, 0]],
  " and ",
  StyleBox["l",
    FontColor->RGBColor[1, 0, 0]],
  " are known."
}], "Text",
  FontSize->14,
  FontWeight->"Bold"],

Cell[TextData[{
  "We notice that for our particular movement, H is the height of the \
intersection point between the upper envelope E of the moving rectangle and \
the line corresponding to the vertical wall of the right-angled corridor.\nWe \
first determine the parametric equation of the upper envelope. We \
parameterize the coordinates ",
  StyleBox["x",
    FontSlant->"Italic"],
  " and ",
  StyleBox["y",
    FontSlant->"Italic"],
  " in terms of the cosine of the angle between the tangent to E  in A and \
the ",
  StyleBox["x",
    FontSlant->"Italic"],
  "-axis."
}], "Text"],

Cell[GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40003;0000MA000`40n007
h00ObjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]
E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<^]E@00bjeE003;[ED00<_o
o`00\
\>"], "Graphics",
  ImageSize->{203, 117},
  ImageMargins->{{0, Inherited}, {Inherited, 0}}],

Cell[CellGroupData[{

Cell[BoxData[
    \(Constructor[Pt : Float\[Cross]Float \[ShortRightArrow] POINT]\)], 
  "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({Pt}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function symbols ",
  StyleBox["xProj",
    FontWeight->"Bold"],
  " and ",
  StyleBox["yProj",
    FontWeight->"Bold"],
  " define the x and y coordinates of a point in the Cartesian system \
depicted in the Figure. "
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(DefinedSymbol[
      x\[Dash]Point : 
        Float\[Cross]Float\[Cross]Float \[ShortRightArrow] POINT, 
      y\[Dash]Point : 
        Float\[Cross]Float\[Cross]Float \[ShortRightArrow] POINT, \n\t
      xProj : POINT \[ShortRightArrow] Float, \n\t
      yProj : POINT \[ShortRightArrow] Float\n]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({x\[Dash]Point, y\[Dash]Point, xProj, yProj}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "The function symbols ",
  StyleBox["x\[Dash]Point",
    FontWeight->"Bold"],
  " and ",
  StyleBox["y\[Dash]Point",
    FontWeight->"Bold"],
  " are defined as follows:\n",
  StyleBox["x\[Dash]Point[ ",
    FontWeight->"Bold"],
  StyleBox["len, w, t ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["] ",
    FontWeight->"Bold"],
  "is the x\[Dash]coordinate of the intersection point of the upper-edge of \
the moving rectangle with the x-axis,\n",
  StyleBox["y\[Dash]Point[ ",
    FontWeight->"Bold"],
  StyleBox["len, w, t ",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  StyleBox["]",
    FontWeight->"Bold"],
  " is the y\[Dash]coordinate of the intersection point of the upper-edge of \
the moving rectangle with the y-axis,\nwhere:"
}], "Text"],

Cell[TextData[{
  StyleBox["len",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the length of the moving rectangle\n",
  StyleBox["w",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the width of the moving rectangle\n",
  StyleBox["t",
    FontWeight->"Bold",
    FontSlant->"Italic"],
  " is the cosine of the angle between the upper\[Dash]edge of the moving \
rectangle and the x\[Dash]axis"
}], "Text",
  CellMargins->{{44, Inherited}, {Inherited, Inherited}},
  TextAlignment->AlignmentMarker],

Cell[CellGroupData[{

Cell[BoxData[
    \(Def[{x, y, len, w, t}, \n
      \t{\n\t\txProj[Pt[x, y]] \[RightArrow] x, \n\t\t
        yProj[Pt[x, y]] \[RightArrow] y, \n\t\t
        x\[Dash]Point[len, w, t] \[RightArrow] 
          Pt[len*t + w/\@\(1 - t\^2\), 0] \[DoubleLeftArrow] \[WatchIcon], \n
        \t\ty\[Dash]Point[len, w, t] \[RightArrow] 
          Pt[0, len*\@\(1 - t\^2\) + w/t] \[DoubleLeftArrow] \[WatchIcon]\n
        \t}]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(xProj[Pt[x, y]] \[RightArrow] 
          x\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          xProj[ 
            Pt[ x, y]], x, {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, y\),
          Infix[ {x, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(yProj[Pt[x, y]] \[RightArrow] 
          y\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          yProj[ 
            Pt[ x, y]], y, {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, y\),
          Infix[ {x, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(x\[Dash]Point[len, w, t] 
          \[RightArrow] Pt[len\ t + w\/\@\(1 - t\^2\), 0] \[DoubleLeftArrow] 
          \[WatchIcon]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          x\[Dash]Point[ len, w, t], 
          Pt[ 
            Plus[ 
              Times[ len, t], 
              Times[ 
                Power[ 
                  Plus[ 1, 
                    Times[ -1, 
                      Power[ t, 2]]], 
                  Rational[ -1, 2]], w]], 0], {\[WatchIcon]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(len, t, w\),
          Infix[ {len, t, w}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {len, t, w}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]4
        \[InvisibleSpace]": "\[InvisibleSpace]\(y\[Dash]Point[len, w, t] 
          \[RightArrow] Pt[0, len\ \@\(1 - t\^2\) + w\/t] \[DoubleLeftArrow] 
          \[WatchIcon]\)\),
      SequenceForm[ "Adding rule #", 4, ": ", 
        RewriteRule[ 
          y\[Dash]Point[ len, w, t], 
          Pt[ 0, 
            Plus[ 
              Times[ len, 
                Power[ 
                  Plus[ 1, 
                    Times[ -1, 
                      Power[ t, 2]]], 
                  Rational[ 1, 2]]], 
              Times[ 
                Power[ t, -1], w]]], {\[WatchIcon]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(len, t, w\),
          Infix[ {len, t, w}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {len, t, w}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \("\[DownTee]"\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "In the specification of the equational goal provided to the ",
  StyleBox["TSolve",
    FontWeight->"Bold"],
  " call we introduced the additional higher-order variables: ",
  StyleBox["x0, y0,",
    FontWeight->"Bold"],
  " and ",
  StyleBox["u",
    FontWeight->"Bold"],
  ". Their intended meaning is:\n",
  StyleBox["x0[t]",
    FontWeight->"Bold"],
  " is the x-coordinate of the intersection point of the upper-edge of the \
rectangle with the x-axis,\n",
  StyleBox["y0[t]",
    FontWeight->"Bold"],
  " is the y-coordinate of the intersection point of the upper-edge of the \
rectangle with the y-axis,\n",
  StyleBox["u",
    FontWeight->"Bold"],
  " is a function in t which is used to express the constraint that the point \
A (whose parametric representation is Pt[x[t],y[t]]) is placed on the upper \
edge of the moving rectangle."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[{\n\t\tx0[t] \[TildeTilde] xProj[x\[Dash]Point[L, l, t]], \n\t\t
        y0[t] \[TildeTilde] yProj[y\[Dash]Point[L, l, t]], \n\t\t
        x \[TildeTilde] \[Lambda][{t}, x0[t] - u[t]*x0[t]], \n\t\t
        y \[TildeTilde] \[Lambda][{t}, u[t]*y0[t]], \n\t\t
        \(y'\)[t]*x0[t] + \(x'\)[t]*y0[t] \[TildeTilde] 0\n\t}, \n
      \t{x, y, u, x0, y0}, \n\t{t}, \n\t
      Constructor -> {L : Float, l : Float}\n]\)], "Input",
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    \({{u \[Rule] 
          \[Lambda][{x$508}, 
            \(x$508\ \((
                  l\^2\ x$508 + l\ L\ \@\(1 - x$508\^2\) + 
                    L\^2\ x$508\ \((\(-1\) + x$508\^2)\)\^2)\)\)\/\(l\^2 + 
                2\ l\ L\ x$508\ \@\(1 - x$508\^2\) - 
                L\^2\ x$508\^2\ \((\(-1\) + x$508\^2)\)\)], 
        x \[Rule] 
          \[Lambda][{x$508}, 
            L\ x$508 + l\/\@\(1 - x$508\^2\) - 
              \(x$508\ \((L\ x$508 + l\/\@\(1 - x$508\^2\))\)\ 
                  \((l\^2\ x$508 + l\ L\ \@\(1 - x$508\^2\) + 
                      L\^2\ x$508\ \((\(-1\) + x$508\^2)\)\^2)\)\)\/\(l\^2 + 
                  2\ l\ L\ x$508\ \@\(1 - x$508\^2\) - 
                  L\^2\ x$508\^2\ \((\(-1\) + x$508\^2)\)\)], 
        x0 \[Rule] \[Lambda][{x$508}, L\ x$508 + l\/\@\(1 - x$508\^2\)], 
        y \[Rule] 
          \[Lambda][{x$508}, 
            \(x$508\ \((l\/x$508 + L\ \@\(1 - x$508\^2\))\)\ 
                \((l\^2\ x$508 + l\ L\ \@\(1 - x$508\^2\) + 
                    L\^2\ x$508\ \((\(-1\) + x$508\^2)\)\^2)\)\)\/\(l\^2 + 
                2\ l\ L\ x$508\ \@\(1 - x$508\^2\) - 
                L\^2\ x$508\^2\ \((\(-1\) + x$508\^2)\)\)], 
        y0 \[Rule] \[Lambda][{x$508}, l\/x$508 + L\ \@\(1 - x$508\^2\)]}}\)], 
  "Output"]
}, Open  ]],

Cell[TextData[{
  "Note the use of the wait operator \[WatchIcon] : it allows the user to \
trigger the solving of the constraints before the interpreter starts \
processing the equations in x and y. In this way, the solutions to the higher \
order variables ",
  StyleBox["x0",
    FontWeight->"Bold"],
  " and ",
  StyleBox["y0",
    FontWeight->"Bold"],
  " are computed as soon as possible."
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 3", "Subsubsection",
  FontSize->14],

Cell[TextData[{
  StyleBox[
  "(Higher order goal)\.08\nFind the coefficients of the polynomial of degree \
3: ",
    FontSize->14],
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox["a",
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox[\(x\^3\),
            FontWeight->"Bold"]}], 
        StyleBox["+",
          FontWeight->"Bold"], 
        RowBox[{
          StyleBox["b",
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox[\(x\^2\),
            FontWeight->"Bold"]}], 
        StyleBox["+",
          FontWeight->"Bold"], 
        RowBox[{
          StyleBox["c",
            FontWeight->"Bold",
            FontColor->RGBColor[1, 0, 0]], 
          StyleBox[" ",
            FontWeight->"Bold"], 
          StyleBox["x",
            FontWeight->"Bold"]}], 
        StyleBox["+",
          FontWeight->"Bold"], 
        StyleBox["d",
          FontWeight->"Bold",
          FontColor->RGBColor[1, 0, 0]]}]],
    FontSize->14],
  StyleBox[" which coincides with the polynomial of degree 4: ",
    FontSize->14],
  Cell[BoxData[
      RowBox[{
        RowBox[{
          StyleBox["m",
            FontColor->RGBColor[1, 0, 0]], " ", \(x\^4\)}], "+", 
        RowBox[{
          StyleBox["n",
            FontColor->RGBColor[1, 0, 0]], " ", \(x\^3\)}], "+", 
        RowBox[{
          StyleBox["p",
            FontColor->RGBColor[1, 0, 0]], " ", \(x\^2\)}], "+", 
        RowBox[{
          StyleBox["q",
            FontColor->RGBColor[1, 0, 0]], " ", "x"}], "+", 
        StyleBox["r",
          FontColor->RGBColor[1, 0, 0]]}]],
    FontSize->14],
  StyleBox[" for x = 1, 2, 3, 4. ",
    FontSize->14]
}], "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n\t
      \[Bullet]map[
          \[Lambda][{z}, a\ z\^3 + b\ z\^2 + c\ z + d], {1, 2, 3, 4}] 
        \[TildeTilde] \[Bullet]map[f, {1, 2, 3, 4}], \n\t{a, b, c, d}, {z}, \n
      \tDefinedSymbol -> {
          \[Bullet]map : 
            \((Float \[ShortRightArrow] Float)\)\[Cross]TyList[Float] 
              \[ShortRightArrow] TyList[Float], \n\t\t\t
          f : Float \[ShortRightArrow] Float}, \n\tRuleVars -> {x, y, z, t}, 
      \n\tRule -> {f[x] \[RightArrow] m\ x\^4 + n\ x\^3 + p\ x\^2 + q\ x + r, 
          \n\t\t\t\[Bullet]map[x, \[Bullet]] \[RightArrow] \[Bullet], \n\t\t\t
          \[Bullet]map[x, \([y | z]\)] \[RightArrow] \([x[y] | t]\) 
            \[DoubleLeftArrow] t \[TildeTilde] \[Bullet]map[x, z]}, \n\t
      Constructor -> {m, n, p, q, r}\n]\)], "Input",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(f[x] \[RightArrow] 
          r + q\ x + p\ x\^2 + n\ x\^3 + m\ x\^4\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          f[ x], 
          Plus[ r, 
            Times[ q, x], 
            Times[ p, 
              Power[ x, 2]], 
            Times[ n, 
              Power[ x, 3]], 
            Times[ m, 
              Power[ x, 4]]], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]x
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", x, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(\[Bullet]map[x, \[Bullet]] 
          \[RightArrow] \[Bullet]\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          \[Bullet]map[ x, \[Bullet]], \[Bullet], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]x
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", x, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(\[Bullet]map[x, Cons[y, z]] 
          \[RightArrow] Cons[x[y], t] \[DoubleLeftArrow] 
          t \[TildeTilde] \[Bullet]map[x, z]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          \[Bullet]map[ x, 
            Cons[ y, z]], 
          Cons[ 
            x[ y], t], {
          eq[ t, 
            \[Bullet]map[ x, z]]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(t, x, y, z\),
          Infix[ {t, x, y, z}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {t, x, y, z}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]t
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", t, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{a \[Rule] 10\ m + n, b \[Rule] \(-35\)\ m + p, c \[Rule] 50\ m + q, 
        d \[Rule] \(-24\)\ m + r}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(CSConnect[]\)], "Input"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell["The dual problem:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n\t
      \[Bullet]map[
          \[Lambda][{z}, m\ z\^4 + n\ z\^3 + p\ z\^2 + q\ z + r], {1, 2, 3, 
            4}] \[TildeTilde] \[Bullet]map[f, {1, 2, 3, 4}], \n
      \t{m, n, p, q, r}, {z}, \n\t
      DefinedSymbol -> {
          \[Bullet]map : 
            \((Float \[ShortRightArrow] Float)\)\[Cross]TyList[Float] 
              \[ShortRightArrow] TyList[Float], \n\t\t\t
          f : Float \[ShortRightArrow] Float}, \n\tRuleVars -> {x, y, z}, \n\t
      Rule -> {\n\t\t\tf[x] \[RightArrow] a\ x\^3 + b\ x\^2 + c\ x + d, \n
          \t\t\t\[Bullet]map[x, {}] \[RightArrow] {}, \n\t\t\t
          \[Bullet]map[x, \([y | z]\)] \[RightArrow] 
            \([x[y] | \[Bullet]map[x, z]]\)\n\t\t}, \n\t
      Constructor -> {a : Float, b, c, d}\n]\)], "Input",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(f[x] \[RightArrow] 
          d + c\ x + b\ x\^2 + a\ x\^3\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          f[ x], 
          Plus[ d, 
            Times[ c, x], 
            Times[ b, 
              Power[ x, 2]], 
            Times[ a, 
              Power[ x, 3]]], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]x
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", x, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(\[Bullet]map[x, \[Bullet]] 
          \[RightArrow] \[Bullet]\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          \[Bullet]map[ x, \[Bullet]], \[Bullet], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]x
        \[InvisibleSpace]" declared as  variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ "Symbol", "", " ", x, " declared as  variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]3
        \[InvisibleSpace]": "\[InvisibleSpace]\(\[Bullet]map[x, Cons[y, z]] 
          \[RightArrow] Cons[x[y], \[Bullet]map[x, z]]\)\),
      SequenceForm[ "Adding rule #", 3, ": ", 
        RewriteRule[ 
          \[Bullet]map[ x, 
            Cons[ y, z]], 
          Cons[ 
            x[ y], 
            \[Bullet]map[ x, z]], {}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, y, z\),
          Infix[ {x, y, z}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, y, z}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{m \[Rule] 1\/24\ \((\(-d\) + r)\), 
        n \[Rule] a + \(5\ \((d - r)\)\)\/12, 
        p \[Rule] b - \(35\ \((d - r)\)\)\/24, 
        q \[Rule] c + \(25\ \((d - r)\)\)\/12}}\)], "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Example 4", "Subsubsection",
  FontSize->14],

Cell["\<\
Solving this problem requires solving capabilities for linear, \
polynomial, and differential equations\
\>", "Text",
  FontWeight->"Bold"],

Cell[CellGroupData[{

Cell[BoxData[
    \(<< TSolve.m\)], "Input"],

Cell[BoxData[
    \("Copyright 1998-1999 Institute RISC-Linz and Institute of Information \
Sciences and Electronics, Tsukuba."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(StartCFLP[]\)], "Input"],

Cell[BoxData[
    \("connection to scheduler established."\)], "Print"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(TSolve[\n
      \t{f[x] \[TildeTilde] g[y], g[y\^2] \[TildeTilde] g[z\^2 - 1], 
        \(h'\)[u] \[TildeTilde] z*u\^y, \(h'\)[1] \[TildeTilde] 4}, \n
      \t{x, y, z, h}, \n\t{u}, \n\t
      Constructor -> {g : Compl \[ShortRightArrow] Compl}, \n\t
      DefinedSymbol -> {f[Compl] \[ShortRightArrow] Compl}, \n\t
      RuleVars -> {x, y}, \n\t
      Rule -> {f[x*\((x + 1)\)] \[RightArrow] g[y] \[DoubleLeftArrow] 
            x \[TildeTilde] y, 
          f[x] \[RightArrow] g[y] \[DoubleLeftArrow] x + y \[TildeTilde] 3}]
      \)], "Input",
  FontSize->14,
  FontColor->RGBColor[0, 0, 1]],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]1
        \[InvisibleSpace]": "\[InvisibleSpace]\(f[x\ \((1 + x)\)] 
          \[RightArrow] g[y] \[DoubleLeftArrow] x \[TildeTilde] y\)\),
      SequenceForm[ "Adding rule #", 1, ": ", 
        RewriteRule[ 
          f[ 
            Times[ x, 
              Plus[ 1, x]]], 
          g[ y], {
          eq[ x, y]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, y\),
          Infix[ {x, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]y
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", y, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Adding rule #"\[InvisibleSpace]2
        \[InvisibleSpace]": "\[InvisibleSpace]\(f[x] \[RightArrow] g[y] 
          \[DoubleLeftArrow] x + y \[TildeTilde] 3\)\),
      SequenceForm[ "Adding rule #", 2, ": ", 
        RewriteRule[ 
          f[ x], 
          g[ y], {
          eq[ 
            Plus[ x, y], 3]}]],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      RowBox[{
      "\<\"Symbol\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\" \"\>", "\[InvisibleSpace]", 
        InterpretationBox[\(x, y\),
          Infix[ {x, y}, ","],
          Editable->False], "\[InvisibleSpace]", 
        "\<\" declared as  variable\"\>", "\[InvisibleSpace]", "\<\"s\"\>", 
        "\[InvisibleSpace]", "\<\".\"\>"}],
      SequenceForm[ "Symbol", "s", " ", 
        Infix[ {x, y}, ","], " declared as  variable", "s", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    InterpretationBox[
      \("Symbol"\[InvisibleSpace]""\[InvisibleSpace]" "\[InvisibleSpace]y
        \[InvisibleSpace]" declared as extra variable"\[InvisibleSpace]""\
\[InvisibleSpace]"."\),
      SequenceForm[ 
      "Symbol", "", " ", y, " declared as extra variable", "", "."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({{h \[Rule] \[Lambda][{u}, c1 + \(4\ u\^\(1 - \@15\)\)\/\(1 - \@15\)], 
        x \[Rule] 15 - \@15, y \[Rule] \(-\@15\), z \[Rule] 4}, {
        h \[Rule] \[Lambda][{u}, c2 + \(4\ u\^\(1 + \@15\)\)\/\(1 + \@15\)], 
        x \[Rule] 15 + \@15, y \[Rule] \@15, z \[Rule] 4}, {
        h \[Rule] \[Lambda][{u}, c3 + \(4\ u\^\(1 - \@15\)\)\/\(1 - \@15\)], 
        x \[Rule] 3 + \@15, y \[Rule] \(-\@15\), z \[Rule] 4}, {
        h \[Rule] \[Lambda][{u}, c4 + \(4\ u\^\(1 + \@15\)\)\/\(1 + \@15\)], 
        x \[Rule] 3 - \@15, y \[Rule] \@15, z \[Rule] 4}}\)], "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 800}, {0, 600}},
AutoGeneratedPackage->Automatic,
WindowToolbars->"RulerBar",
WindowSize->{711, 482},
WindowMargins->{{33, Automatic}, {14, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
ShowCellTags->True
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 64, 1, 102, "Title"],
Cell[1798, 54, 197, 5, 50, "Text",
  InitializationCell->True],

Cell[CellGroupData[{
Cell[2020, 63, 36, 0, 42, "Subsubsection"],
Cell[2059, 65, 2298, 39, 698, "Text"]
}, Closed]],

Cell[CellGroupData[{
Cell[4394, 109, 50, 1, 29, "Subsubsection"],
Cell[4447, 112, 147, 6, 52, "Text"],

Cell[CellGroupData[{
Cell[4619, 122, 76, 2, 27, "Input"],
Cell[4698, 126, 140, 2, 39, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4875, 133, 76, 2, 27, "Input"],
Cell[4954, 137, 71, 1, 23, "Print"]
}, Open  ]],
Cell[5040, 141, 637, 22, 50, "Text"],

Cell[CellGroupData[{
Cell[5702, 167, 390, 8, 75, "Input"],
Cell[6095, 177, 58, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6190, 183, 386, 7, 83, "Input"],
Cell[6579, 192, 974, 26, 60, "Print"],
Cell[7556, 220, 646, 13, 23, "Print"],
Cell[8205, 235, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8288, 241, 170, 4, 27, "Input"],
Cell[8461, 247, 603, 11, 59, "Output"]
}, Open  ]],
Cell[9079, 261, 398, 9, 68, "Text"],

Cell[CellGroupData[{
Cell[9502, 274, 444, 7, 83, "Input"],
Cell[9949, 283, 1096, 29, 60, "Print"],
Cell[11048, 314, 646, 13, 23, "Print"],
Cell[11697, 329, 46, 1, 27, "Output"]
}, Open  ]],
Cell[11758, 333, 721, 23, 68, "Text"],

Cell[CellGroupData[{
Cell[12504, 360, 170, 4, 27, "Input"],
Cell[12677, 366, 182, 3, 27, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12908, 375, 50, 1, 43, "Subsubsection"],
Cell[12961, 378, 1281, 40, 147, "Text"],
Cell[14245, 420, 589, 16, 86, "Text"],
Cell[14837, 438, 985, 18, 125, 910, 16, "GraphicsData", 
"Bitmap", "Graphics"],

Cell[CellGroupData[{
Cell[15847, 460, 129, 3, 27, "Input"],
Cell[15979, 465, 38, 1, 27, "Output"]
}, Open  ]],
Cell[16032, 469, 253, 9, 32, "Text"],

Cell[CellGroupData[{
Cell[16310, 482, 362, 8, 75, "Input"],
Cell[16675, 492, 78, 1, 27, "Output"]
}, Open  ]],
Cell[16768, 496, 792, 26, 86, "Text"],
Cell[17563, 524, 518, 16, 68, "Text"],

Cell[CellGroupData[{
Cell[18106, 544, 460, 9, 160, "Input"],
Cell[18569, 555, 328, 9, 23, "Print"],
Cell[18900, 566, 553, 12, 23, "Print"],
Cell[19456, 580, 328, 9, 23, "Print"],
Cell[19787, 591, 553, 12, 23, "Print"],
Cell[20343, 605, 673, 18, 42, "Print"],
Cell[21019, 625, 568, 12, 23, "Print"],
Cell[21590, 639, 701, 19, 37, "Print"],
Cell[22294, 660, 568, 12, 23, "Print"],
Cell[22865, 674, 46, 1, 27, "Output"]
}, Open  ]],
Cell[22926, 678, 875, 24, 122, "Text"],

Cell[CellGroupData[{
Cell[23826, 706, 483, 8, 187, "Input"],
Cell[24312, 716, 1287, 25, 306, "Output"]
}, Open  ]],
Cell[25614, 744, 407, 11, 68, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26058, 760, 50, 1, 43, "Subsubsection"],
Cell[26111, 763, 1866, 63, 71, "Text"],

Cell[CellGroupData[{
Cell[28002, 830, 861, 16, 221, "Input"],
Cell[28866, 848, 533, 16, 25, "Print"],
Cell[29402, 866, 316, 6, 23, "Print"],
Cell[29721, 874, 352, 8, 23, "Print"],
Cell[30076, 884, 316, 6, 23, "Print"],
Cell[30395, 892, 518, 14, 23, "Print"],
Cell[30916, 908, 571, 12, 23, "Print"],
Cell[31490, 922, 333, 7, 23, "Print"],
Cell[31826, 931, 139, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32002, 938, 44, 1, 27, "Input"],
Cell[32049, 941, 71, 1, 23, "Print"]
}, Open  ]],
Cell[32135, 945, 33, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[32193, 949, 840, 17, 259, "Input"],
Cell[33036, 968, 470, 14, 25, "Print"],
Cell[33509, 984, 316, 6, 23, "Print"],
Cell[33828, 992, 352, 8, 23, "Print"],
Cell[34183, 1002, 316, 6, 23, "Print"],
Cell[34502, 1010, 450, 12, 23, "Print"],
Cell[34955, 1024, 562, 12, 23, "Print"],
Cell[35520, 1038, 214, 4, 43, "Output"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[35783, 1048, 50, 1, 43, "Subsubsection"],
Cell[35836, 1051, 149, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[36010, 1059, 44, 1, 27, "Input"],
Cell[36057, 1062, 140, 2, 39, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36234, 1069, 44, 1, 27, "Input"],
Cell[36281, 1072, 71, 1, 23, "Print"]
}, Open  ]],

Cell[CellGroupData[{
Cell[36389, 1078, 614, 13, 163, "Input"],
Cell[37006, 1093, 429, 12, 23, "Print"],
Cell[37438, 1107, 553, 12, 23, "Print"],
Cell[37994, 1121, 333, 7, 23, "Print"],
Cell[38330, 1130, 394, 11, 23, "Print"],
Cell[38727, 1143, 553, 12, 23, "Print"],
Cell[39283, 1157, 333, 7, 23, "Print"],
Cell[39619, 1166, 589, 8, 219, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

