(***********************************************************************
This file was generated automatically by the Mathematica front end.
It contains Initialization cells from a Notebook file, which typically
will have the same name as this file except ending in ".nb" instead of
".m".

This file is intended to be loaded into the Mathematica kernel using
the package loading commands Get or Needs.  Doing so is equivalent to
using the Evaluate Initialiation Cells menu command in the front end.

DO NOT EDIT THIS FILE.  This entire file is regenerated automatically 
each time the parent Notebook file is saved in the Mathematica front end.
Any changes you make to this file will be overwritten.
***********************************************************************)























BeginPackage["ElDemo`",{"TSolve`"}];







resistor::usage=
  "resistor[R,S,V0,I0,V1,I1] describes a resistor with input voltage/current \
s[V0,I0] and output s[V1,I1]." ;

capacitor::usage=
  "capacitor[R,S,s[V0,I0],s[V1,I1]] describes a capacitor with input \
voltage/current s[V0,I0] and output s[V1,I]." ;

junction::usage=
  "junction[InSignals,OutSignals] describes a junction of inputs InSignals \
and outputs OutSignals. L and R are lists of electrical signals." ;

elJoin::usage=
  "elJoin[S,L,V] describes the join operation of inputs L and outputs R. \
Here, L is a list of pairs s[Vi,Ii] modelling the signals, where V equals all \
Vi and I is the sum of Ii." ;

CComp::usage=
  "CComp[C0] describes a capacitor with characteristic capacity C0." ;

RComp::usage=
  "RComp[R] describes a resistor with characteristic resistance R." ;

s::usage; ElSignal::usage;

serial::usage=
  "serial[compList, s[V1,I1], s[V2,I2]] is a predicate which describes the \
relation between the input signal s[V1,I1] and the output signal s[V2,I2] for \
the serial connection of the electrical components of `compList`.";

parallel::usage=
  "serial[compList, s[V1,I1], s[V2,I2]] is a predicate which describes the \
relation between the input signal s[V1,I1] and the output signal s[V2,I2] for \
the parallel connection of the electrical components of `compList`.";

PConnect::usage=
  "PConnect[Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S.";

SConnect::usage=
  "SConnect[S, Clist, s[V0,I0], s[V1,I1]] is the electrical component \
representing the serial connection of the unary components of list Clist, \
with input s[V0,I0], output s[V1,I1] and system frequency S.";



Begin["`Private`"];



$ContextPath=Join[$CFLPpackages,$ContextPath];







TypeConstructor[ElSignal]





Constructor[s:Float\[Cross]Float\[ShortRightArrow]ElSignal]











DefinedSymbol[
	resistor:Float\[Cross]ElSignal\[Cross]ElSignal\[ShortRightArrow]Bool,
	capacitor:Float\[Cross]ElSignal\[Cross]ElSignal\[ShortRightArrow]Bool
]











Def[{R,S,V1,I1,V2,I2},
	{resistor[R,s[V1,I1],s[V2,I2]]\[RightArrow]True
      \[DoubleLeftArrow]{-V1+V2\[TildeTilde]I1 R,I1\[TildeTilde]I2}}]











Def[{C0,V1,I1,V2,I2},
	{capacitor[C0,s[V1,I1],s[V2,I2]]\[RightArrow]True
      \[DoubleLeftArrow]{V1-V2\[TildeTilde]I1/C0,I1\[TildeTilde]I2}}]









RComp[R_]=\[Lambda][{sIn,sOut},resistor[R,sIn,sOut]];

CComp[C0_]:=\[Lambda][{sIn,sOut},capacitor[C0,sIn,sOut]];

















DefinedSymbol[
	serial:TyList[ElSignal\[Cross]ElSignal\[ShortRightArrow]Bool]\[Cross]ElSignal
        \[Cross]ElSignal\[ShortRightArrow]Bool]



Def[{comp,compList,sIn,sOut,sBetw},
	{serial[{},sIn,sIn]\[RightArrow]True,
		serial[Cons[comp,compList],sIn,sOut]\[RightArrow]True
      \[DoubleLeftArrow]{comp[sIn,sBetw]\[TildeTilde]True,
        serial[compList,sBetw,sOut]\[TildeTilde]True}}]

























DefinedSymbol[elJoin:TyList[ElSignal]\[Cross]Float\[ShortRightArrow]Float]



Def[{I1,I2,V,sInList},
	{elJoin[{},V]\[RightArrow]0,
		elJoin[Cons[s[V,I1],sInList],V]\[RightArrow]I1+I2\[DoubleLeftArrow]I2
        \[TildeTilde]elJoin[sInList,V]}];















DefinedSymbol[
  junction:TyList[ElSignal]\[Cross]TyList[ElSignal]\[ShortRightArrow]Bool]



Def[{sInList,sOutList,V},
	{junction[sInList,sOutList]\[RightArrow]True
      \[DoubleLeftArrow]elJoin[sInList,V]\[TildeTilde]elJoin[sOutList,V]}];

















DefinedSymbol[
	parallel:
    TyList[ElSignal\[Cross]ElSignal\[ShortRightArrow]Bool]\[Cross]ElSignal
        \[Cross]ElSignal\[ShortRightArrow]Bool]



Def[{comp,compList,sIn,sIn1,sIn2,sOut,sOut1,sOut2},
	{parallel[{comp},sIn,sOut]\[RightArrow]comp[sIn,sOut],
		parallel[Cons[comp,compList],sIn,sOut]\[RightArrow]True
      \[DoubleLeftArrow]{comp[sIn1,sOut1]\[TildeTilde]True,
				parallel[compList,sIn2,sOut2]\[TildeTilde]True,
        junction[{sIn},{sIn1,sIn2}]\[TildeTilde]True,
        junction[{sOut1,sOut2},{sOut}]\[TildeTilde]True}}]















SConnect[compList_]=\[Lambda][{sIn,sOut},serial[compList,sIn,sOut]];



PConnect[compList_]=\[Lambda][{sIn,sOut},parallel[compList,sIn,sOut]];





End[]





EndPackage[]























































































































