(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 3.0,
MathReader 3.0, or any compatible application. The data for the notebook 
starts with the line of stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     32781,        943]*)
(*NotebookOutlinePosition[     33575,        971]*)
(*  CellTagsIndexPosition[     33531,        967]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[" This appendix gives all the program of TIP.", "Section"],

Cell[TextData[{
  "  Function ",
  StyleBox[" ",
    FontWeight->"Bold"],
  StyleBox["\[CapitalGamma]FormQ", "Subsubsection"],
  "[x]  checks whether an expression is  \[CapitalGamma]-form ."
}], "Text"],

Cell[BoxData[
    \(\[CapitalGamma]FormQ[\[CapitalGamma][_, _]]\  := \ True; \n
    \[CapitalGamma]FormQ[_]\  := \ False; \)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["VarQ", "Subsubsection"],
  "[x] checks whether x is a propositional variable or an integer variable.   \
"
}], "Text"],

Cell[BoxData[
    \(\(\ VarQ[x_Symbol] /; x =!= True\ \  \[And] x =!= False\  := True; \ \n
    \ VarQ[_] := False; \)\)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["Neg",
    FontWeight->"Bold"],
  StyleBox["PVarQ", "Subsubsection"],
  "[x] checks whether x is a negated propositional variable.  "
}], "Text"],

Cell[BoxData[
    \(NegPVarQ[\[Not] x_Symbol] /; x =!= True\ \  \[And] x =!= False := \ 
      True; \nNegPVarQ[_] := False; \)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["PLiteral", "Subsubsection"],
  StyleBox["Q",
    FontWeight->"Bold"],
  "[p] checks whether p is a propositional variable or a negated  \
propositional variable"
}], "Text"],

Cell[BoxData[
    \(PLiteralQ[p_] := VarQ[p] \[Or] NegPVarQ[p]; \n
    NotPLiteralQ[p_] := \[Not] PLiteralQ[p]\)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["BoundedQ", "Subsubsection"],
  "[x] checks whether a variable x is properly bounded."
}], "Text"],

Cell[BoxData[
    \(BoundedQ[m_Integer \[LessEqual] x_?VarQ \[LessEqual] n_Integer] := 
      True; \nBoundedQ[_] := \ False; \)], "Input"],

Cell[TextData[{
  " Function ",
  StyleBox["ConstraintQ", "Subsubsection"],
  "[c] checks whether an expression c  is a  constraint . Note that we use == \
 to  denote the equality of symbol of ",
  Cell[BoxData[
      \(TraditionalForm\`\(L\^+\)\)]],
  "."
}], "Text"],

Cell[BoxData[
    \(\(ConstraintQ[
        x_ \[GreaterEqual] y_ | x_ > y_ | x_ \[LessEqual] y_\  | \ 
          x_ < y_\ \  | \ x_ \[Equal] y_\ ] := \ True; \n
    ConstraintQ[_]\  := \ False; \ \)\)], "Input"],

Cell[TextData[{
  "Function  ",
  StyleBox["PredOrder", "Subsubsection"],
  "[x,y] defines a predicate order in a \[CapitalGamma]-formula."
}], "Text"],

Cell[BoxData[
    \(PredOrder[x_?VarQ, r_[_, _]]\  := \ True; \n
    PredOrder[Not[_], r_[_, _]]\  := \ True; \n
    PredOrder[x_, y_]\  := False\)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["PLiteral2IPvar", "Subsubsection"],
  "[e] translates a propositional variable e= ",
  StyleBox["p", "Input"],
  " and a formula e=",
  StyleBox["\[Not]p ", "Input"],
  "into IP-formulas."
}], "Text"],

Cell[BoxData[
    \(\(PLiteral2IPvar[x_?VarQ] := 
      Bounds\[LeftDoubleBracket]\(Position[Bounds, x]\)\[LeftDoubleBracket]1, 
          1\[RightDoubleBracket], 2\[RightDoubleBracket]\ ; \n
    PLiteral2IPvar[\[Not] x_?VarQ] := 
      1 - Bounds
          \[LeftDoubleBracket]\(Position[Bounds, x]\)\[LeftDoubleBracket]1, 1
            \[RightDoubleBracket], 2\[RightDoubleBracket]\ ; \ \)\)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["Raux", "Subsubsection"],
  "[x,y,z] is an auxiliary function of ",
  StyleBox["RuleR", "Subsubsection"],
  "[x]",
  "."
}], "Text"],

Cell[BoxData[
    \(\(Raux[{x___?PLiteralQ, y___\ ?NotPLiteralQ}, m_, n_]\ \  := 
      Module[{newvarlist = Map[Unique[d]&, {y}]}, 
        Bounds = 
          Bounds \[Union] Map[0 \[LessEqual] # \[LessEqual] 1&, newvarlist]; 
        \n\t\tPrepend[
          Map[RuleR, 
            MapThread[
              Function[{d, a}, d > 0\  \[Implies] a], {newvarlist, {y}}]], 
          \((Apply[Plus, newvarlist \[Union] Map[PLiteral2IPvar, {x}]] 
              \[GreaterEqual] m\ \ n)\)]]; \)\)], "Input"],

Cell[TextData[{
  "Function  ",
  StyleBox["RuleE", "Subsubsection"],
  "[x] defines rule E."
}], "Text"],

Cell[BoxData[
    \(\(RuleE[x_]\  := \ 
      x //. {p_ \[Implies] q_\  -> \ \[Not] p \[Or] q, \ 
          p_ \[DoubleLeftRightArrow] q_\  -> \ 
            \((\ p \[Implies] q)\) \[And] \ \((q \[Implies] p)\)}; \)\)], 
  "Input"],

Cell[TextData[{
  "Function  ",
  StyleBox["RuleT", "Subsubsection"],
  "[x] defines rule T."
}], "Text"],

Cell[BoxData[
    \(RuleT[x1_ \[Or] x2_] := \[CapitalGamma][1, {RuleT[x1], RuleT[x2]}]; \n
    RuleT[x1_ \[And] x2_] := \[CapitalGamma][2, {RuleT[x1], RuleT[x2]}]; \n
    RuleT[\[Not] x_] := \[Not] RuleT[x]\ ; \n
    RuleT[atleast[m_, S_]] := \[CapitalGamma][m, Map[RuleT, S]]; \n
    RuleT[atmost[m_, S_]] := 
      \[CapitalGamma][Length[S] - m, Map[RuleT, Map[Not, S]]]; \n
    RuleT[none[S_]] := \[CapitalGamma][Length[S], Map[RuleT, Map[Not, S]]]; \n
    RuleT[x_?VarQ] := PVarDecl[x]; \nRuleT[x_?ConstraintQ] := IPVarDecl[x]; \n
    RuleT[True] := Throw[{True, Bounds}]; \n
    RuleT[False] := Throw["\<Wrong specification\>"]\)], "Input"],

Cell[TextData[{
  "Function  ",
  StyleBox["RuleN", "Subsubsection"],
  StyleBox[" ", "Subsubsection"],
  "[x] defines rule N."
}], "Text"],

Cell[BoxData[
    \(RuleN[\[CapitalGamma][m_, S_]] := \[CapitalGamma][m, Map[RuleN, S]]; \n
    RuleN[\[Not] \[CapitalGamma][m_, S_]] := 
      \[CapitalGamma][Length[S] - m + 1, Map[RuleN, Map[Not, S]]]; \n
    RuleN[\[Not] \((x1_ == x2_)\)] := \[CapitalGamma][1, {x1 > x2, x1 < x2}]; 
    \nRuleN[x_] := x; \)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox[" ", "Subsubsection"],
  StyleBox["RuleF", "Subsubsection"],
  "[x] defines rule  F."
}], "Text"],

Cell[BoxData[{
    \(RuleF[x_] := x\  //. {RF1, RF2}\), 
    \(RF1 = \ 
      \[CapitalGamma]\ [1, {x1___, \[CapitalGamma][1, {x2___}], x3___}]\  :> 
        \ \[CapitalGamma][1, {x1, x2, x3}]; \n
    RF2\  = \ \[CapitalGamma][m_, {x1___, \[CapitalGamma][n_, S_], x2___}] /; 
          m == Length[{x1, x2}] + 1 \[And] n == Length[S]\  :> \ \ 
        \[CapitalGamma][n + m - 1, S \[Union] {x1, x2}]; \)}], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox[" Rule", "Subsubsection"],
  StyleBox["R", "Subsubsection"],
  "[x] defines rule R."
}], "Text"],

Cell[BoxData[
    \(RuleR[r_[x1_, x2_]] := r[x1, x2]; \n
    RuleR[p_?PLiteralQ] := PLiteral2IPvar[p] \[GreaterSlantEqual] 1; \n
    RuleR[\[CapitalGamma][m_, S_]] /; m == Length[S] := Map[RuleR, S]; \n
    RuleR[\[CapitalGamma][m_, \ S_]]\  /; m < Length[S] := \ 
      Raux[Sort[S, PredOrder], m, 1]; \n
    RuleR[d_ > 0 \[Implies] \[CapitalGamma][m_, S_]] /; m == Length[S] := 
      Map[RuleR, Map[\((d > 0 \[Implies] #)\)&, S]]; \n
    RuleR[d_ > 0 \[Implies] \[CapitalGamma][m_, S_]] /; m < Length[S] := 
      Raux[Sort[S, PredOrder], m, d]; \n
    RuleR[d_ > 0 \[Implies] p_?PLiteralQ] := 
      PLiteral2IPvar[p] \[GreaterSlantEqual] d; \n
    RuleR[d_ > 0 \[Implies] x1_ \[GreaterSlantEqual] x2_] := \ 
      Module[{L}, \((x1 - x2\  \[GreaterSlantEqual] \ L \((1 - d\ )\))\)\_L]; 
    \nRuleR[d_ > 0 \[Implies] x1_ > x2_] := 
      Module[{L}, \((x1 - x2\  > \ \((L - 1)\)\ \((1 - d\ )\))\)\_L]; 
    RuleR[d_ > 0 \[Implies] x1_ \[LessSlantEqual] x2_] := 
      Module[{U}, \((x1 - x2\  \[LessSlantEqual] U\ \((1 - d\ )\))\)\^U]; \n
    RuleR[d_ > 0 \[Implies] x1_ < x2_] := 
      Module[{U}, \((x1 - x2\  < \((U + 1)\)\ \((1 - d\ )\))\)\^U]; \n
    RuleR[d_ > 0 \[Implies] x1_ == x2_] := {
        RuleR[d > 0 \[Implies] x1 \[GreaterSlantEqual] x2], 
        RuleR[d > 0 \[Implies] x1 \[LessSlantEqual] x2]}; \)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["Lowerbound", "Subsubsection"],
  "[A] computes the  lowerbound of  constraint A with  respects to the  given \
  Bounds, where  Bounds is specifed as  a list of terms of the form a  \
\[LessEqual]x\[LessEqual]b.   ",
  StyleBox["Lowerbound", "Subsubsection"],
  " uses  auxiliary  function ",
  StyleBox["Lb", "Subsubsection"],
  "."
}], "Text"],

Cell[BoxData[{
    \(Lowerbound[A_?AtomQ\ ] := Lb[A\ ]; \nLowerbound[A_\ ] := \ Map[Lb, A]; 
    \nLb[term : a_*\ \ x_\ ]\  /; \ a > 0\  := 
      Module[{i = 
            \(Position[Bounds, _ \[LessEqual] x \[LessEqual] _]
                \)\[LeftDoubleBracket]1, 1\[RightDoubleBracket]}, 
        term /. {
            Bounds\[LeftDoubleBracket]i, 2\[RightDoubleBracket] \[Rule] 
              Bounds\[LeftDoubleBracket]i, 1\[RightDoubleBracket]}]; \n
    Lb[term : a_\ *\ x_\ ]\  /; \ a < 0\ \  := 
      Module[{i = 
            \(Position[Bounds, _ \[LessEqual] x \[LessEqual] _]
                \)\[LeftDoubleBracket]1, 1\[RightDoubleBracket]}, 
        term /. {
            Bounds\[LeftDoubleBracket]i, 2\[RightDoubleBracket] \[Rule] 
              Bounds\[LeftDoubleBracket]i, 3\[RightDoubleBracket]}]; \n
    Lb[x_?VarQ\ ]\ \  := 
      Bounds\[LeftDoubleBracket]\(Position[
            Bounds, _ \[LessEqual] x \[LessEqual] _]\)\[LeftDoubleBracket]1, 1
          \[RightDoubleBracket], 1\[RightDoubleBracket]\), 
    \(Lb[a_\ ]\  := a\)}], "Input"],

Cell[TextData[{
  "Likewise function ",
  StyleBox["Upperbound", "Subsubsection"],
  " is defined."
}], "Text"],

Cell[BoxData[
    \(Upperbound[A_] := \ Map[Ub, A]; \ \nUpperbound[A_?AtomQ] := Ub[A\ ]; \n
    Ub[term : a_*x_\ ]\  /; \ a > 0\  := 
      Module[{i = 
            \(Position[Bounds, _ \[LessEqual] x \[LessEqual] _]
                \)\[LeftDoubleBracket]1, 1\[RightDoubleBracket]}, 
        term /. {
            Bounds\[LeftDoubleBracket]i, 2\[RightDoubleBracket] \[Rule] 
              Bounds\[LeftDoubleBracket]i, 3\[RightDoubleBracket]}]; \n
    Ub[term : a_*\ x_\ ]\  /; \ a < 0\ \  := 
      Module[{i = 
            \(Position[Bounds, _ \[LessEqual] x \[LessEqual] _]
                \)\[LeftDoubleBracket]1, 1\[RightDoubleBracket]}, 
        term /. {
            Bounds\[LeftDoubleBracket]i, 2\[RightDoubleBracket] \[Rule] 
              Bounds\[LeftDoubleBracket]i, 1\[RightDoubleBracket]}]; \n
    Ub[x_?VarQ\ ]\  := 
      Bounds\[LeftDoubleBracket]\(Position[
            Bounds, _ \[LessEqual] x \[LessEqual] _]\)\[LeftDoubleBracket]1, 1
          \[RightDoubleBracket], 3\[RightDoubleBracket]; \ \n
    Ub[a_\ ]\  := \ a; \)], "Input"],

Cell[TextData[{
  "\nFunction ",
  StyleBox["RRC", "Subsubsection"],
  "[x] (Remove Redundant Constraints) is defined below using the following    \
auxiliary functions: ",
  StyleBox[" RCaux ", "Subsubsection"],
  " checks whether a given constraint is redundant and outputs ",
  StyleBox["{}", "Output"],
  " if redundant or else  a simplified constraint after substituting the    \
value of the Bounds."
}], "Text"],

Cell[BoxData[
    \(RRC[A_] := \ Map[RCaux, A]; \n
    RCaux[\ \((A_ \[LessEqual] B_)\)\^U_\ ] := 
      Module[{Uw = Upperbound[A]}, \n\t\t
        If[Uw > 0, A \[LessEqual] \((B /. {U \[Rule] Uw})\), {}]]; \n
    RCaux[\(\((A_ < B_)\)\ \)\^U_] := \n\t
      Module[{Uw = Upperbound[A]}, \n\t\t
        If[Uw \[GreaterEqual] 0, A < \((B /. {U \[Rule] Uw})\), {}]]; \n
    RCaux[\ \(\((A_ \[GreaterEqual] B_)\)\ \)\_L_]\  := 
      Module[{Lw = Lowerbound[A]}, \n\t\t
        If[Lw < 0, A \[GreaterEqual] \((B\  /. {L \[Rule] Lw})\), {}]]; \n
    RCaux[\(\((A_ > B_)\)\ \)\_L_] := \n\t
      Module[{Lw = Lowerbound[A]}, \n\t\t
        If[Lw \[LessEqual] 0, A > \((B /. {L \[Rule] Lw})\), {}]]; \n
    RCaux[A_] := A\)], "Input"],

Cell[TextData[{
  "Function ",
  StyleBox["MakeBounds", "Subsubsection"],
  "[x] checks whether the input bound of each integer variable is right and   \
generates a decision variable and its bound for each  propositional    \
variable."
}], "Text"],

Cell[BoxData[
    \(MakeBounds[\ x_?BoundedQ\ ] := \ x; \n
    MakeBounds[x_?VarQ] := 0 \[LessEqual] Pvar\_x \[LessEqual] 1; \)], "Input"],

Cell[TextData[{
  "Founction ",
  StyleBox["PVarDecl", "Subsubsection"],
  "[e] checks  whether each propositional variable is properly declared."
}], "Text"],

Cell[BoxData[
    \(\(PVarDecl[v_] := 
      If[MemberQ[Bounds, v, {2, 3}], v, 
        Print["\<Propositional Variable \>", \ \ v, "\< not declared.\>"]; \ 
        \n\t\tThrow[Bounds]]; \)\)], "Input"],

Cell[TextData[{
  "Founction ",
  StyleBox["IP",
    FontWeight->"Bold"],
  StyleBox["VarDecl", "Subsubsection"],
  "[e] checks  whether each integer variable  is properly declared."
}], "Text"],

Cell[BoxData[
    \(IPVarDecl[v_?VarQ] := 
      If[MemberQ[Bounds, v, 2], v, 
        Print["\<Integer variable \>", \ \ v, "\< not declared.\>"]; \ \n\t\t
        Throw[Bounds]]; \nIPVarDecl[t : f_[__]] := Map[IPVarDecl, t]; \n
    IPVarDecl[x_Integer] := x; \n
    IPVarDecl[x_] := \ 
      Module[{}, Print["\<Constraint \>", x, "\< is not well formed\>"]; 
        Throw[Bounds]]\)], "Input"],

Cell[TextData[{
  "Founction ",
  StyleBox["IneqSimplify", "Subsubsection"],
  "[e] simplifies expressions."
}], "Text"],

Cell[BoxData[
    \(IneqSimplify[a_ > \ b_]\  := \ Simplify[a\  - b]\  > 0; \n
    IneqSimplify[a_ \[GreaterEqual] \ b_]\  := \ 
      Simplify[a\  - b]\ \  \[GreaterEqual] 0; \n
    IneqSimplify[a_ < \ b_]\  := \ Simplify[a\  - b]\  < 0; \n
    IneqSimplify[a_ \[LessEqual] \ b_]\  := \ 
      Simplify[a\  - b]\ \  \[LessEqual] 0; \)], "Input"],

Cell[TextData[{
  "Founction ",
  StyleBox["Options", "Subsubsection"],
  "[GenIP]  specifies that the generated IP-formulas will be simplified."
}], "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[GenIP] = {IPFormSimplify -> True}\)], "Input"],

Cell[BoxData[
    \({IPFormSimplify \[Rule] True}\)], "Output"]
}, Open  ]],

Cell[TextData[{
  "This is the main function ",
  StyleBox["GenIP", "Subsubsection"],
  ".  ",
  StyleBox["GenIP", "Subsubsection"],
  " needs three arguments ",
  StyleBox["spec", "Input"],
  " , ",
  StyleBox["decl ", "Input"],
  "and",
  StyleBox[" opts", "Input"],
  ".  ",
  StyleBox["spec", "Input"],
  " is  a logical specification,  ",
  StyleBox["decl", "Input"],
  " is a list of propositional variables and  the bounds of  integer \
variables of the form  a \[LessEqual]x\[LessEqual]b, and ",
  StyleBox["opts", "Input"],
  " is an option to specify whether the generated IP-formulas will be \
simplified or not with ",
  StyleBox["IPFormSimplify->True", "Input"],
  "  or ",
  StyleBox["IPFormSimplify->False.", "Input"],
  " "
}], "Text"],

Cell[BoxData[
    \(GenIP[spec_, decl_, opts___] := \ \n\t
      Catch[Block[{Pvar = Unique[\[Delta]]\ , Bounds = Map[MakeBounds, decl]}
            \ , \t\ \n\t\t
          With[{ipform = 
                Flatten[{
                    \(Composition[RRC, Flatten, RuleR, RuleF, RuleN, RuleT, 
                        RuleE]\)[spec]}]}, \ \ 
            If[\(IPFormSimplify /. {opts}\) /. Options[GenIP], 
                Map[IneqSimplify, ipform], ipform, ipform] \[Union] Bounds]]]
        \)], "Input"],

Cell["Following are test examples:", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x1 + x2 + z \[GreaterEqual] 0 \[And] \((p1 \[Or] p2 \[Or] p3)\), {\ p1, 
        p3, 1 \[LessEqual] x1 \[LessEqual] 10, 
        1 \[LessEqual] x2 \[LessEqual] 10}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Integer variable "\[InvisibleSpace]z
        \[InvisibleSpace]" not declared."\),
      SequenceForm[ "Integer variable ", z, " not declared."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0 \[LessEqual] \[Delta]$124\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$124\_p3 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x1 + x2 \[GreaterEqual] 0 \[And] \((p1 \[Or] p2 \[Or] p3)\), {\ p1, p2, 
        p3, 1 \[LessEqual] x1 \[LessEqual] 10, 
        1 \[LessEqual] x2 \[LessEqual] 10}, IPFormSimplify -> False]\)], 
  "Input"],

Cell[BoxData[
    \({x1 + x2 \[GreaterEqual] 0, 
      \[Delta]$125\_p1 + \[Delta]$125\_p2 + \[Delta]$125\_p3 \[GreaterEqual] 
        1, 0 \[LessEqual] \[Delta]$125\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$125\_p2 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$125\_p3 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x1 + x2 \[GreaterEqual] 0 \[And] \((p1 \[Or] p2 \[Or] p3)\), {\ p1, p2, 
        p3, 1 \[LessEqual] x1 \[LessEqual] 10, 
        1 \[LessEqual] x2 \[LessEqual] 10}]\)], "Input"],

Cell[BoxData[
    \({x1 + x2 \[GreaterEqual] 0, 
      \(-1\) + \[Delta]$127\_p1 + \[Delta]$127\_p2 + \[Delta]$127\_p3 
        \[GreaterEqual] 0, 0 \[LessEqual] \[Delta]$127\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$127\_p2 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$127\_p3 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x1 + x2 \[GreaterEqual] 0 \[And] \((p1 \[Or] p2 \[Or] p3)\), {\ p1, p3, 
        1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Propositional Variable "\[InvisibleSpace]p2
        \[InvisibleSpace]" not declared."\),
      SequenceForm[ "Propositional Variable ", p2, " not declared."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0 \[LessEqual] \[Delta]$129\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$129\_p3 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x1 + x2 + z \[GreaterEqual] 0 \[And] 
        \((p1 \[Or] False \[Or] p2 \[Or] p3)\), {\ z, p1, p2, p3, 
        1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Integer variable "\[InvisibleSpace]z
        \[InvisibleSpace]" not declared."\),
      SequenceForm[ "Integer variable ", z, " not declared."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0 \[LessEqual] \[Delta]$130\_z \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$130\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$130\_p2 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$130\_p3 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x + y + z \[GreaterEqual] 0 \[And] \((p1 \[Or] p2 \[Or] p3)\), {\ p1, 
        1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Integer variable "\[InvisibleSpace]x
        \[InvisibleSpace]" not declared."\),
      SequenceForm[ "Integer variable ", x, " not declared."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0 \[LessEqual] \[Delta]$131\_p1 \[LessEqual] 1, 
      1 \[LessEqual] x1 \[LessEqual] 10, 1 \[LessEqual] x2 \[LessEqual] 10}
      \)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ p, {\ p}]\)], "Input"],

Cell[BoxData[
    \({\(-1\) + \[Delta]$132\_p \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$132\_p \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ \[Not] p\ , {p}]\)], "Input"],

Cell[BoxData[
    \({\(-\[Delta]$133\_p\) \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$133\_p \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP\ [\ 
      x + y \[GreaterEqual] 1\ , {1 \[LessEqual] x \[LessEqual] 10, 
        1 \[LessEqual] y \[LessEqual] 10}]\)], "Input"],

Cell[BoxData[
    \({\(-1\) + x + y \[GreaterEqual] 0, 1 \[LessEqual] x \[LessEqual] 10, 
      1 \[LessEqual] y \[LessEqual] 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[
      x + y \[GreaterEqual] 2 \[Or] x + y \[LessEqual] 20, {
        1 \[LessEqual] x \[LessEqual] 10, 1 \[LessEqual] y \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    \({\(-1\) + d$137 + d$138 \[GreaterEqual] 0, 
      0 \[LessEqual] d$137 \[LessEqual] 1, 
      0 \[LessEqual] d$138 \[LessEqual] 1, 1 \[LessEqual] x \[LessEqual] 10, 
      1 \[LessEqual] y \[LessEqual] 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[
      x + y \[GreaterEqual] 3 \[Or] x + y \[LessEqual] 20, {
        1 \[LessEqual] x \[LessEqual] 10, 1 \[LessEqual] y \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    \({\(-1\) + d$145 + d$146 \[GreaterEqual] 0, 
      \(-2\) - d$146 + x + y \[GreaterEqual] 0, 
      0 \[LessEqual] d$145 \[LessEqual] 1, 
      0 \[LessEqual] d$146 \[LessEqual] 1, 1 \[LessEqual] x \[LessEqual] 10, 
      1 \[LessEqual] y \[LessEqual] 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[
      x + y \[GreaterEqual] 2 \[Or] x + y \[LessEqual] 8, {
        1 \[LessEqual] x \[LessEqual] 10, 1 \[LessEqual] y \[LessEqual] 10}]
      \)], "Input"],

Cell[BoxData[
    \({\(-1\) + d$153 + d$154 \[GreaterEqual] 0, 
      \(-20\) + 12\ d$153 + x + y \[LessEqual] 0, 
      0 \[LessEqual] d$153 \[LessEqual] 1, 
      0 \[LessEqual] d$154 \[LessEqual] 1, 1 \[LessEqual] x \[LessEqual] 10, 
      1 \[LessEqual] y \[LessEqual] 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\ \ GenIP[a \[And] b \[Implies] c \[Or] d, {a, b, c, d}]\)\)], "Input"],

Cell[BoxData[
    \({1 - \[Delta]$159\_a - \[Delta]$159\_b + \[Delta]$159\_c + 
          \[Delta]$159\_d \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$159\_a \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$159\_b \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$159\_c \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$159\_d \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GenIP[
      \((a \[LessEqual] 2 \[Or] b \[LessEqual] 3)\) \[DoubleLeftRightArrow] 
        \((e \[LessEqual] 8 \[Or] f \[GreaterEqual] 7)\), {
        3 \[LessEqual] a \[LessEqual] 10, 4 \[LessEqual] b \[LessEqual] 10, 
        1 \[LessEqual] c \[LessEqual] 10, 1 \[LessEqual] e \[LessEqual] 10, 
        1 \[LessEqual] f \[LessEqual] 10}\ ]\ \ \ \)\)], "Input"],

Cell[BoxData[
    \({\(-8\)\ d$173 + e > 0, 
      \(-1\) + d$163 + d$164 + d$165 \[GreaterEqual] 0, 
      \(-1\) + d$171 + d$172 + d$173 \[GreaterEqual] 0, 
      \(-1\) - 6\ d$163 + f \[GreaterEqual] 0, \(-11\) + 4\ d$173 + f < 0, 
      \(-10\) + b + 7\ d$171 \[LessEqual] 0, 
      \(-10\) + a + 8\ d$172 \[LessEqual] 0, 
      \(-10\) + 2\ d$164 + e \[LessEqual] 0, 
      0 \[LessEqual] d$163 \[LessEqual] 1, 
      0 \[LessEqual] d$164 \[LessEqual] 1, 
      0 \[LessEqual] d$165 \[LessEqual] 1, 
      0 \[LessEqual] d$171 \[LessEqual] 1, 
      0 \[LessEqual] d$172 \[LessEqual] 1, 
      0 \[LessEqual] d$173 \[LessEqual] 1, 1 \[LessEqual] c \[LessEqual] 10, 
      1 \[LessEqual] e \[LessEqual] 10, 1 \[LessEqual] f \[LessEqual] 10, 
      3 \[LessEqual] a \[LessEqual] 10, 4 \[LessEqual] b \[LessEqual] 10}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GenIP[
      \((a \[LessEqual] 2 \[Or] b \[LessEqual] 3)\) \[DoubleLeftRightArrow] 
        \((e \[LessEqual] 8 \[Or] f \[GreaterEqual] 7)\), {
        1 \[LessEqual] a \[LessEqual] 10, 1 \[LessEqual] b \[LessEqual] 10, 
        1 \[LessEqual] e \[LessEqual] 10, 
        1 \[LessEqual] f \[LessEqual] 10\ \ }\ , IPFormSimplify -> False]\ \ 
    \)\)], "Input"],

Cell[BoxData[
    \({\(-2\) + a > \(-2\)\ \((1 - d$190)\), 
      \(-3\) + b > \(-3\)\ \((1 - d$190)\), 
      \(-8\) + e > \(-8\)\ \((1 - d$198)\), 
      d$188 + d$189 + d$190 \[GreaterEqual] 1, 
      d$196 + d$197 + d$198 \[GreaterEqual] 1, 
      \(-7\) + f \[GreaterEqual] \(-6\)\ \((1 - d$188)\), 
      \(-7\) + f < 4\ \((1 - d$198)\), 
      \(-2\) + a \[LessEqual] 8\ \((1 - d$197)\), 
      \(-3\) + b \[LessEqual] 7\ \((1 - d$196)\), 
      \(-8\) + e \[LessEqual] 2\ \((1 - d$189)\), 
      0 \[LessEqual] d$188 \[LessEqual] 1, 
      0 \[LessEqual] d$189 \[LessEqual] 1, 
      0 \[LessEqual] d$190 \[LessEqual] 1, 
      0 \[LessEqual] d$196 \[LessEqual] 1, 
      0 \[LessEqual] d$197 \[LessEqual] 1, 
      0 \[LessEqual] d$198 \[LessEqual] 1, 1 \[LessEqual] a \[LessEqual] 10, 
      1 \[LessEqual] b \[LessEqual] 10, 1 \[LessEqual] e \[LessEqual] 10, 
      1 \[LessEqual] f \[LessEqual] 10}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GenIP[
      \((\((atleast[3, {p1, p2, p3, p4, p5\ }] \[Or] \ 
                atmost[3, {p3, p4, p5, p6, p8, p9}])\) \[And] 
            \[Not] none[{p5, p6, p7}])\) \[Implies] 
        atmost[2, {p6, p7, p8, p9}], {p1, p2, p3, p4, p5, p6, p7, p8, p9}]\ \ 
    \n\)\)], "Input"],

Cell[BoxData[
    \({\(-1\) + d$213 + d$214 + d$215 \[GreaterEqual] 0, 
      1 - d$214 - \[Delta]$211\_p5 \[GreaterEqual] 0, 
      5 - 3\ d$215 - \[Delta]$211\_p1 - \[Delta]$211\_p2 - \[Delta]$211\_p3 - 
          \[Delta]$211\_p4 - \[Delta]$211\_p5 \[GreaterEqual] 0, 
      1 - d$214 - \[Delta]$211\_p6 \[GreaterEqual] 0, 
      1 - d$214 - \[Delta]$211\_p7 \[GreaterEqual] 0, 
      4 - 2\ d$213 - \[Delta]$211\_p6 - \[Delta]$211\_p7 - \[Delta]$211\_p8 - 
          \[Delta]$211\_p9 \[GreaterEqual] 0, 
      \(-4\)\ d$215 + \[Delta]$211\_p3 + \[Delta]$211\_p4 + 
          \[Delta]$211\_p5 + \[Delta]$211\_p6 + \[Delta]$211\_p8 + 
          \[Delta]$211\_p9 \[GreaterEqual] 0, 
      0 \[LessEqual] d$213 \[LessEqual] 1, 
      0 \[LessEqual] d$214 \[LessEqual] 1, 
      0 \[LessEqual] d$215 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p2 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p3 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p4 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p5 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p6 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p7 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p8 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$211\_p9 \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GenIP[
      a + b > 0 \[Implies] c \[GreaterEqual] e \[Or] f \[GreaterEqual] 2, 
      \ {1 \[LessEqual] a \[LessEqual] 10, 1 \[LessEqual] b \[LessEqual] 10, 
        1 \[LessEqual] c \[LessEqual] 10, 1 \[LessEqual] \ e \[LessEqual] 10, 
        1 \[LessEqual] f \[LessEqual] 10}]\ \n\ \)\)], "Input"],

Cell[BoxData[
    \({\(-1\) + d$221 + d$222 + d$223 \[GreaterEqual] 0, 
      9 + c - 9\ d$222 - e \[GreaterEqual] 0, 
      \(-1\) - d$221 + f \[GreaterEqual] 0, 
      a + b + 20\ \((\(-1\) + d$223)\) \[LessEqual] 0, 
      0 \[LessEqual] d$221 \[LessEqual] 1, 
      0 \[LessEqual] d$222 \[LessEqual] 1, 
      0 \[LessEqual] d$223 \[LessEqual] 1, 1 \[LessEqual] a \[LessEqual] 10, 
      1 \[LessEqual] b \[LessEqual] 10, 1 \[LessEqual] c \[LessEqual] 10, 
      1 \[LessEqual] e \[LessEqual] 10, 1 \[LessEqual] f \[LessEqual] 10}\)], 
  "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(GenIP[
      atleast[1, {atmost[2, {p1, p2, p3}], p4, p5}], {p1, p2, p3, p4, p5}]\ \n
    \ \)\)], "Input"],

Cell[BoxData[
    \({2 - \[Delta]$231\_p1 - \[Delta]$231\_p2 - \[Delta]$231\_p3 + 
          \[Delta]$231\_p4 + \[Delta]$231\_p5 \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$231\_p1 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$231\_p2 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$231\_p3 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$231\_p4 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$231\_p5 \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[
      atleast[1, {a, 
          atmost[2, {atleast[1, {xx, yy, zz}], 
              atmost[2, {r, atmost[1, {ww, we, wr}], tt}], b, c, d}], 
          atmost[1, {e, f}], g}], {a, b, c, d, e, f, g, r, xx, yy, zz, ww, 
        we, wr, tt}]\)], "Input"],

Cell[BoxData[
    \({3 - 3\ d$235 + d$237 + d$238 - \[Delta]$233\_b - \[Delta]$233\_c - 
          \[Delta]$233\_d \[GreaterEqual] 0, 
      1 + d$235 + \[Delta]$233\_a - \[Delta]$233\_e - \[Delta]$233\_f + 
          \[Delta]$233\_g \[GreaterEqual] 0, 
      \(-d$237\) + \[Delta]$233\_r \[GreaterEqual] 0, 
      \(-d$237\) + \[Delta]$233\_tt \[GreaterEqual] 0, 
      3 - 2\ d$237 - \[Delta]$233\_we - \[Delta]$233\_wr - \[Delta]$233\_ww 
        \[GreaterEqual] 0, 1 - d$238 - \[Delta]$233\_xx \[GreaterEqual] 0, 
      1 - d$238 - \[Delta]$233\_yy \[GreaterEqual] 0, 
      1 - d$238 - \[Delta]$233\_zz \[GreaterEqual] 0, 
      0 \[LessEqual] d$235 \[LessEqual] 1, 
      0 \[LessEqual] d$237 \[LessEqual] 1, 
      0 \[LessEqual] d$238 \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_a \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_b \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_c \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_d \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_e \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_f \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_g \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_r \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_tt \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_we \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_wr \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_ww \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_xx \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_yy \[LessEqual] 1, 
      0 \[LessEqual] \[Delta]$233\_zz \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[1 >= z \[Or] x, {x}]\)], "Input"],

Cell[BoxData[
    InterpretationBox[
      \("Integer variable "\[InvisibleSpace]z
        \[InvisibleSpace]" not declared."\),
      SequenceForm[ "Integer variable ", z, " not declared."],
      Editable->False]], "Print"],

Cell[BoxData[
    \({0 \[LessEqual] \[Delta]$240\_x \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[x == x, {1 <= x <= 100}]\)], "Input"],

Cell[BoxData[
    \({True, {1 \[LessEqual] x \[LessEqual] 100}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[1 >= 0 \[And] q, {q}]\)], "Input"],

Cell[BoxData[
    \({\(-1\) + \[Delta]$242\_q \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$242\_q \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[p \[And] p, {p}, IPFormSimplify -> False\ ]\)], "Input"],

Cell[BoxData[
    \({\[Delta]$243\_p \[GreaterEqual] 1, 
      0 \[LessEqual] \[Delta]$243\_p \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[p \[And] p, {p}, IPFormSimplify -> True]\)], "Input"],

Cell[BoxData[
    \({\(-1\) + \[Delta]$244\_p \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$244\_p \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[p \[And] True, {p}]\)], "Input"],

Cell[BoxData[
    \({\(-1\) + \[Delta]$245\_p \[GreaterEqual] 0, 
      0 \[LessEqual] \[Delta]$245\_p \[LessEqual] 1}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(GenIP[p \[And] False, {p}]\)], "Input"],

Cell[BoxData[
    \("Wrong specification"\)], "Output"]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"X 3.0",
ScreenRectangle->{{0, 1024}, {0, 768}},
WindowSize->{724, 403},
WindowMargins->{{22, Automatic}, {122, Automatic}},
PrintingCopies->1,
PrintingPageRange->{Automatic, Automatic},
PrintingOptions->{"PaperSize"->{612, 792},
"PaperOrientation"->"Portrait",
"Magnification"->1}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1731, 51, 63, 0, 54, "Section"],
Cell[1797, 53, 203, 6, 32, "Text"],
Cell[2003, 61, 135, 2, 43, "Input"],
Cell[2141, 65, 161, 5, 32, "Text"],
Cell[2305, 72, 131, 2, 43, "Input"],
Cell[2439, 76, 187, 6, 32, "Text"],
Cell[2629, 84, 138, 2, 43, "Input"],
Cell[2770, 88, 216, 7, 32, "Text"],
Cell[2989, 97, 123, 2, 43, "Input"],
Cell[3115, 101, 140, 4, 32, "Text"],
Cell[3258, 107, 139, 2, 43, "Input"],
Cell[3400, 111, 269, 8, 50, "Text"],
Cell[3672, 121, 211, 4, 43, "Input"],
Cell[3886, 127, 151, 4, 32, "Text"],
Cell[4040, 133, 158, 3, 59, "Input"],
Cell[4201, 138, 242, 8, 32, "Text"],
Cell[4446, 148, 404, 7, 43, "Input"],
Cell[4853, 157, 174, 7, 32, "Text"],
Cell[5030, 166, 503, 10, 75, "Input"],
Cell[5536, 178, 105, 4, 32, "Text"],
Cell[5644, 184, 231, 5, 27, "Input"],
Cell[5878, 191, 105, 4, 32, "Text"],
Cell[5986, 197, 645, 10, 171, "Input"],
Cell[6634, 209, 139, 5, 32, "Text"],
Cell[6776, 216, 322, 5, 75, "Input"],
Cell[7101, 223, 139, 5, 32, "Text"],
Cell[7243, 230, 415, 7, 75, "Input"],
Cell[7661, 239, 138, 5, 32, "Text"],
Cell[7802, 246, 1335, 22, 213, "Input"],
Cell[9140, 270, 388, 10, 50, "Text"],
Cell[9531, 282, 1059, 20, 139, "Input"],
Cell[10593, 304, 111, 4, 32, "Text"],
Cell[10707, 310, 1051, 20, 139, "Input"],
Cell[11761, 332, 418, 10, 68, "Text"],
Cell[12182, 344, 729, 14, 217, "Input"],
Cell[12914, 360, 249, 6, 50, "Text"],
Cell[13166, 368, 138, 2, 43, "Input"],
Cell[13307, 372, 158, 4, 32, "Text"],
Cell[13468, 378, 203, 4, 59, "Input"],
Cell[13674, 384, 194, 6, 32, "Text"],
Cell[13871, 392, 397, 8, 107, "Input"],
Cell[14271, 402, 120, 4, 32, "Text"],
Cell[14394, 408, 346, 6, 75, "Input"],
Cell[14743, 416, 157, 4, 32, "Text"],

Cell[CellGroupData[{
Cell[14925, 424, 74, 1, 27, "Input"],
Cell[15002, 427, 63, 1, 27, "Output"]
}, Open  ]],
Cell[15080, 431, 751, 24, 68, "Text"],
Cell[15834, 457, 504, 10, 107, "Input"],
Cell[16341, 469, 44, 0, 32, "Text"],

Cell[CellGroupData[{
Cell[16410, 473, 214, 4, 27, "Input"],
Cell[16627, 479, 224, 5, 23, "Print"],
Cell[16854, 486, 221, 4, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17112, 495, 242, 5, 27, "Input"],
Cell[17357, 502, 393, 7, 45, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17787, 514, 214, 4, 27, "Input"],
Cell[18004, 520, 402, 7, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18443, 532, 208, 4, 27, "Input"],
Cell[18654, 538, 238, 5, 23, "Print"],
Cell[18895, 545, 221, 4, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19153, 554, 240, 5, 27, "Input"],
Cell[19396, 561, 224, 5, 23, "Print"],
Cell[19623, 568, 330, 6, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[19990, 579, 206, 4, 27, "Input"],
Cell[20199, 585, 224, 5, 23, "Print"],
Cell[20426, 592, 166, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20629, 600, 52, 1, 27, "Input"],
Cell[20684, 603, 132, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20853, 610, 59, 1, 27, "Input"],
Cell[20915, 613, 128, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21080, 620, 155, 3, 27, "Input"],
Cell[21238, 625, 143, 2, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21418, 632, 184, 4, 27, "Input"],
Cell[21605, 638, 239, 4, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[21881, 647, 184, 4, 27, "Input"],
Cell[22068, 653, 288, 5, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22393, 663, 183, 4, 27, "Input"],
Cell[22579, 669, 290, 5, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22906, 679, 93, 1, 27, "Input"],
Cell[23002, 682, 354, 6, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[23393, 693, 385, 6, 27, "Input"],
Cell[23781, 701, 836, 16, 75, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[24654, 722, 383, 7, 43, "Input"],
Cell[25040, 731, 924, 18, 75, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[26001, 754, 301, 6, 75, "Input"],
Cell[26305, 762, 1323, 23, 119, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[27665, 790, 324, 5, 43, "Input"],
Cell[27992, 797, 551, 10, 43, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[28580, 812, 129, 3, 43, "Input"],
Cell[28712, 817, 436, 7, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[29185, 829, 277, 6, 59, "Input"],
Cell[29465, 837, 1589, 28, 131, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31091, 870, 59, 1, 27, "Input"],
Cell[31153, 873, 224, 5, 23, "Print"],
Cell[31380, 880, 81, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31498, 886, 63, 1, 27, "Input"],
Cell[31564, 889, 77, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31678, 895, 60, 1, 27, "Input"],
Cell[31741, 898, 132, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[31910, 905, 82, 1, 27, "Input"],
Cell[31995, 908, 123, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32155, 915, 79, 1, 27, "Input"],
Cell[32237, 918, 132, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32406, 925, 58, 1, 27, "Input"],
Cell[32467, 928, 132, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[32636, 935, 59, 1, 27, "Input"],
Cell[32698, 938, 55, 1, 27, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

