#include <stdio.h>
#include <time.h>
#define VARSIZE 10
#define VECNUM 1000
#define ARRNUM 300

struct vector {
  int tail[VECNUM];
  int head[VECNUM];
};
struct pair {
    int first;
    int second;
    struct pair *nextp;
};
struct points {
  int solu[ARRNUM];
  struct points *nextp;
};
struct vector d[10000],sv;
struct pair *vpair,*vp;
int  A[ARRNUM][ARRNUM],M[ARRNUM],C[ARRNUM],
     B[ARRNUM],S[ARRNUM],OPS[ARRNUM],I[ARRNUM][ARRNUM];
int m,n,i,j,k,l,sum,row,varnum,stop;

struct vector comp(p)/*compare the tail and head, who is more expensive*/
struct vector p;

{int order,sum1,sum2,num;
 
    sum1=0;sum2=0;
    for(i=1; i<m+1; i++){
	sum1=sum1+p.tail[i]*M[i];
	sum2=sum2+p.head[i]*M[i];
    }
    for(i=1; i<n+1; i++){
	sum1=sum1+p.tail[m+i]*C[i];
	sum2=sum2+p.head[m+i]*C[i];
    }
    if (sum2>sum1){
	for(i=1; i<m+n+1; i++){
	    num=p.tail[i];
	    p.tail[i]=p.head[i];
	    p.head[i]=num;
       	}
    }
    else {
	if (sum2==sum1){ /* sort by lexicographic order */
	    order=0;
	    for(i=1; i<m+n+1; i++){
		if (p.tail[i]<p.head[i]){
		    order=1;
		    break;
		}
		else{
		    if(p.tail[i]>p.head[i])
			break;
		}
	    }
	    if(order)
		for(i=1; i<m+n+1; i++){
	              num=p.tail[i];
	              p.tail[i]=p.head[i];
	              p.head[i]=num;
       	        }
	}
    }
    return p;

}

void Svec(p,q)/* generate S(p,q) */
struct vector p,q;
{ 
    for(i=1; i<m+n+1; i++){
	if (p.tail[i]>q.tail[i]){
     	    sv.tail[i]=p.head[i];
	    sv.head[i]=p.tail[i]-q.tail[i]+q.head[i];
       	}
       	else {
       	    sv.tail[i]=q.tail[i]-p.tail[i]+p.head[i];
	    sv.head[i]=q.head[i];
	}
    }
    sv=comp(sv);
}

struct vector Redu(r)/* reduce S(p,q) */
struct vector r;
{int i,j,t,stop,retail,rehead;
 
     for(j=1; j<sum+1; j++){
	    retail=1;
	    rehead=1;
	    for(i=1; i<m+n+1; i++){
	       if (r.tail[i]<d[j].tail[i])
		   retail=0;
	       if (r.head[i]<d[j].tail[i])
		   rehead=0;
	    }
   	    if(retail){/*r can be reduced by d[j] in tail*/
	        for(i=1; i<m+n+1; i++)
		   r.tail[i]=r.tail[i]-d[j].tail[i]+d[j].head[i];
                /* check whether r parallises d[j], 
                   r.tail-d[j].tail=r.head-d[j].head*/
                stop=0;
                for(i=1;i<m+n+1;i++)
                  if(r.tail[i]!=r.head[i]){
                     stop=1;
                     break;
                  }
                if(stop){
	          r=comp(r);
		  j=0;
                }
                else{
                  r.tail[1]=-1000;
                  j=sum+1;
                }
                
	    }
      	    else {
	        if(rehead){/*r can be reduced by d[j] in head*/
		   for(i=1; i<m+n+1; i++)
	              r.head[i]=r.head[i]-d[j].tail[i]+d[j].head[i];
                   /* check whether r is parallel: r.tail=r.head*/
                   stop=0;
                   for(i=1;i<m+n+1;i++)
                      if(r.tail[i]!=r.head[i]){
                         stop=1;
                         break;
                      }
                  if(stop){
	             r=comp(r);
		     j=0;
                  }
                  else{
                     r.tail[1]=-1000;
                     j=sum+1;
                  }

	       
	    }
	}
    }
    return r;
}	    

struct vector GMin(r,u)/* find minial Grobner basis */
struct vector r;
int u;
{int i,j,renum;
    for(j=1; j<sum+1; j++){
      if(j!=u){     
	renum=1;
	for(i=1; i<m+n+1; i++){
	    if (r.tail[i]<d[j].tail[i]){
		renum=0;
	    }
   	}
	if(renum){
	    r.tail[1]=-1000;
	    j=sum+1;
	}
      }
  }
  return r;
}

struct vector GRedu(r,u)/* find reduced Grobner basis */
struct vector r;
int u;
{int i,j,renum;
   
      	for(j=1; j<sum+1; j++){
           if(j!=u){
	       renum=1;
	       for(i=1; i<m+n+1; i++)
		 if (r.head[i]<d[j].tail[i]){
		     renum=0;
	             break;
                 }
	       if(renum){
		 for(i=1; i<m+n+1; i++)
	                r.head[i]=r.head[i]-d[j].tail[i]+d[j].head[i];
	         r=comp(r);
		 j=1;
	       }
	   }
	}
        return r;
}	    

ECinput()/* input equations and Min function */

{int coef,sig;
 char str[VARSIZE],c,chr[VARSIZE];


 /*input equations */
    
    printf("\nInput equations :\n");
    
    row=0;varnum=0;
    sig=1;
     while(strcmp(str,".")){
	row++;
	scanf("%s",str);
	
        while(strcmp(str,"=")){
	    
	    if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    if(strcmp(str,"x")){
		coef=atoi(str);
	        scanf("%s",str);
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    n=atoi(str);
	    if(n>varnum)
	       varnum=n;
	    if(sig){
		A[row][n]=coef;
	    }
	    else {
	      A[row][n]=-coef;
	    }
	    scanf("%s",str);
	}
	scanf("%s",str);
	sig=1;
	if(!(strcmp(str,"-"))){
	    scanf("%s",str);
		sig=0;
	}
	if(sig){
	    B[row]=atoi(str);
	}
	else{
	    B[row]=-atoi(str);
	}    
	scanf("%s",str);
	sig=1;
    }
/* input function Min cx */ 
    m=row;n=varnum;
    printf("\nInput function cx\n");
    sig=1;
    scanf("%s",str);
    while(strcmp(str,".")){
	  if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    if(strcmp(str,"x")){
		coef=atoi(str);
	        scanf("%s",str);
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    n=atoi(str);
	    if(sig){
	      C[n]=coef;
	    }
	    else {
	      C[n]=-coef;
	    }
	    scanf("%s",str);
	}
}
CIP()/* find the optimal solution of CIP by
	check the feasibility of all left constraints
	including complicated constraints and
	probabilistic constraints */
{int LA[ARRNUM][ARRNUM],Lb[ARRNUM];/* coefficients A and b of
				      complicated constraints */
 int FS[ARRNUM];/* A feasible solution of CIP */
 int PA[ARRNUM][ARRNUM],Pb[ARRNUM];/* coefficient A and b of
				      probabilistic constraints */
 int SA[ARRNUM][ARRNUM];/* a set of samples of random D */
 int sn;/* the number of samples */
 int RD[ARRNUM][ARRNUM];/* a set of random Di */
 int rn;/* the number of random variables */
 float prob,r,fr,ffr;/* probability */
 float M;/* lot splitting */
 int row;/* the number of rows of complicated constraints */
 int prow;/* the number of rows of probabilistic costraints */
 int Cx,cx;/* the values of objective function */
 int nonneg,k,check;
 struct points *so,*vso,*po,*pool; /* points generated by walking
			              all directions of test set of CIP */
 
void LCinput()/* input left (complicated) constraints */
{int coef,sig,k;
 char str[VARSIZE],c,chr[VARSIZE];

 /* input equations */
    printf("\nComplicated constraints :\n");
    row=0;
    sig=1;
     while(strcmp(str,".")){
	row++;
	scanf("%s",str);
	
        while(strcmp(str,"=<")){
	    
	    if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    if(strcmp(str,"x")){
		coef=atoi(str);
	        scanf("%s",str);
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    k=atoi(str);
	    if(sig){
		LA[row][k]=coef;
	    }
	    else {
	        LA[row][k]=-coef;
	    }
	    scanf("%s",str);
	}
	scanf("%s",str);
	sig=1;
	if(!(strcmp(str,"-"))){
	    scanf("%s",str);
		sig=0;
	}
	if(sig){
	    Lb[row]=atoi(str);
	}
	else{
	    Lb[row]=-atoi(str);
	}    
	scanf("%s",str);
	sig=1;
    }


}

void PRinput()/* input all probabilistic constraints
		and probability */
{int i,j,k,t;
 int coef,sig;
 char str[VARSIZE],c,chr[VARSIZE];
 /* input equations or unequations */
    printf("\nProbabilistic constraints:\n");
    rn=0;
    prow=0;
    sig=1;
     while(strcmp(str,".")){
	prow++;
	scanf("%s",str);
	
        while(strcmp(str,"=<")){
	    
	    if(!(strcmp(str,"+"))){
		scanf("%s",str);
		sig=1;
	    }
	    if(!(strcmp(str,"-"))){
		scanf("%s",str);
		sig=0;
	    }
	    k=0;
	    if(strcmp(str,"x")){
	      if(!(strcmp(str,"d"))){
		coef=1;
		scanf("%s",str);
		k=atoi(str);
		if (k>rn)
		  rn=k;
		scanf("%s",str);
	      }
	      else{
		coef=atoi(str);
	        scanf("%s",str);
		if(!(strcmp(str,"d"))){
		  scanf("%s",str);
		  k=atoi(str);
		  if (k>rn)
		    rn=k;
		  scanf("%s",str);
		}
	      }
	    }
	    else{
		coef=1;
	    }
	    scanf("%s",str);
	    t=atoi(str);
	    if(sig){
		PA[prow][t]=coef;
	    }
	    else {
	        PA[prow][t]=-coef;
	    }
	    if(k)
	      RD[prow][t]=k;
	    scanf("%s",str);
	}
	scanf("%s",str);
	sig=1;
	if(!(strcmp(str,"-"))){
	    scanf("%s",str);
		sig=0;
	}
	if(sig){
	    Pb[prow]=atoi(str);
	}
	else{
	    Pb[prow]=-atoi(str);
	}    
	scanf("%s",str);
	sig=1;
    }

     /* input the probability */
     printf("\nProbability prob=");
     scanf("%f",&prob);
     /* input the lot splitting */
     printf("\nLot splitting M=");
     scanf("%f",&M);
     /* input samples of random variables */
     printf("\nNumber of samples sn= ");
     scanf("%d",&sn);
     printf("\n%d samples:\n",sn);
     scanf("%s",str);
     i=1;j=1;
     while(strcmp(str,".")){
       SA[i][j]=atoi(str);
       j++;
       if(j>rn){
	 i++;
	 j=1;
       }
       scanf("%s",str);
     }
     for(i=1;i<sn+1;i++)
       SA[i][0]=0;
     
}
 
int CHeck()/* check whether the point is feasible
	      for complicated constraints and
	      probabilistic constraints*/
{ int check,ax,i,j,k,t,tt;
  float r,split,rax;
  check=1;
  /* check whether the point is feasible
     for complicated constraints */
  for(i=1;i<row+1;i++){
    ax=0;
    for(j=1;j<n+1;j++)
      ax=ax+FS[j]*LA[i][j];
    if(ax>Lb[i]){
      check=0;
      break;
    }
  }
  /* check whether the point is feasible
     for probabilistic constraints */
  if(check){
    t=0;
    for(k=1;k<sn+1;k++){
      tt=1;
      for(i=1;i<prow+1;i++){
	rax=0;
	for(j=1;j<n+1;j++)
	  if(SA[k][RD[i][j]]){
	    split=SA[k][RD[i][j]]/M;
	    rax=rax+FS[j]*PA[i][j]*split;
	  }
	  else{
	    rax=rax+FS[j]*PA[i][j];
	  }
	if(rax>Pb[i]){
	  tt=0;
	  break;
	}
      }
      if(tt)
	t++;
    }
    ffr=t;
    if(prob*sn>ffr){
      check=0;
    }
    FS[n+1]=t;
  }
  return check;
}
struct points *Gen()/* generate a link space */
{struct points *p;

 if(pool==NULL){
   p=(struct points*)malloc(sizeof(struct points));
   return p;
 }
 else{
   p=pool;
   pool=pool->nextp;
   return p;
 }
}
void Free(struct points *po)/* release a link space */
{
  po->nextp=pool;
  pool=po;
}

/* CIP solver start */
 /* input left (complicated) constraints */
 LCinput(); 
 /* input probabilistic constraints */
 PRinput();

 /* walk all directions from optimal solution of RIP */

 /* check first whether the optimal solution of RIP
    is feasible for CIP */
 for(i=1;i<n+1;i++)
     FS[i]=OPS[i];
 if (CHeck()==1) {
    /* output optimal solution */
    printf("\n the optimal solution of IP:\n");
    for(i=1; i<n+1; i++)
	printf("x%d=%d, ",i,FS[i]);
    printf("\n");
    r=FS[n+1];prob=sn;
    printf("\nthe probability r=%f\n",r/prob);
    cx=0;
    for(j=1;j<n+1;j++)
       cx=cx+FS[j]*C[j];
    printf("\ncost=%d\n",cx);
 }
 else {
   /* construct a link table for all feasible solution */
    pool=NULL;
    vso=Gen();
    so=vso;
    for(i=1;i<n+1;i++)
      so->solu[i]=FS[i];
    so->nextp=NULL;
    /* keep the optimal solution of IP in OPS,
       the objective function in Cx, first give a big number to Cx */
    Cx=1000000;k=0;
    /* walk all driections by ops+(d.tail-d.head) */
    
    while(vso!=NULL){
      k++;
      for(i=1;i<sum+1;i++){
	/* generate new point in FS */
	nonneg=0;
        for(j=1;j<n+1;j++){
	  FS[j]=vso->solu[j]+d[i].tail[j]-d[i].head[j];
	  if (FS[j]<0)
	    nonneg=1;
	}

	/* check the point: 1.nonnegative 2.feasible */
	if(nonneg==0){
	  check=CHeck();
	  if (check==1){
	      cx=0;
	      for(j=1;j<n+1;j++)
	        cx=cx+FS[j]*C[j];
	      if(cx<Cx){
	         Cx=cx;
	         for(j=1;j<n+2;j++)
	         OPS[j]=FS[j];
	      }
	  }
	  else{
	    cx=0;
	    for(j=1;j<n+1;j++)
	       cx=cx+FS[j]*C[j];
	    if(cx<Cx){
	       po=Gen();
               for(j=1;j<n+1;j++)
	         po->solu[j]=FS[j];
	       po->nextp=NULL;
               so->nextp=po;
	       so=so->nextp;
	    }
	  }
	}

      }
      po=vso;
      vso=vso->nextp;
      /* release the point po */
      Free(po);
    }
    /* get a conclution */
    printf("\nResult:\n");
    if (Cx==1000000){
	printf("\n**** The problem has no optimal solution ! ****\n");
    }
    else{ /* output the optimal solution */
	cx=0;
	for(j=1;j<n+1;j++)
	  cx=cx+OPS[j]*C[j];
	r=OPS[n+1];prob=sn;
	printf("\nProbability = %f, Cost = %d \n",r/prob,cx);
        printf("\n Optimal solution :\n");
	for(j=1;j<n+1;j++)
	  printf("x%d=%d, ",j,OPS[j]);
        printf("\n");
    }

 }
 
}

main( )
{time_t starttime,endtime;
    printf("********************************************\n");
    printf("*                                          *\n");
    printf("*                  SIPS                    *\n");
    printf("*               version 1.0                *\n");
    printf("*                                          *\n");
    printf("*                 Qiang  Li                *\n");
    printf("*            University of Tsukuba         *\n");
    printf("*                                          *\n");
    printf("*                 Yike Guo                 *\n");
    printf("*   Dept. of Computing, Imperial College   *\n");
    printf("*                                          *\n");
    printf("*          Co-operated under AITEC         *\n");
    printf("*            research projet 1997          *\n");
    printf("*                                          *\n");
    printf("********************************************\n");         
    printf("\nRIP input (following two input items):\n");
    /* call input function */
    ECinput();
    /*time(&starttime);*/
    m=row;
    n=varnum;
    for(i=1; i<row+1; i++)
        M[i]=1000;
    
    /* generate fundamental segments d1,...,dn */
    for(k=1; k<n+1; k++){
        for(i=1; i<m+1; i++){
	    d[k].tail[i]=A[i][k];
	    d[k].head[i]=0;
	}
	for(j=1; j<n+1; j++){
            d[k].tail[m+j]=0;
	    if(k==j){
	       d[k].head[m+j]=1;
	    }   
	    else{
	      d[k].head[m+j]=0;
	    }
	}
    }
    /* generate pair of vectors */
    vpair=(struct pair*)malloc(sizeof(struct pair));
    vp=vpair;
    for(i=1;i<n;i++){
	for(j=i+1;j<n+1;j++){
	    vp->first=i;
	    vp->second=j;
            vp->nextp=(struct pair*)malloc(sizeof(struct pair));
            vp=vp->nextp;
            vp->nextp=NULL;

	}
    }
    /* generate S(p,q) and reduce S(p,q) */
    sum=n;
    while(vpair->nextp!=NULL){
        /* generate S(p,q)*/
	Svec(d[vpair->first],d[vpair->second]);
        vpair=vpair->nextp;
	/*check whether sv.tail==sv.head */
        stop=1;
        for(i=1;i<m+n+1;i++)
	  if(sv.tail[i]!=sv.head[i]){
             stop=0;
             break;
          }
        if (stop){
           sv.tail[1]=-1000;
	}
        else { /* reduce S(p,q)*/
	     sv=Redu(sv);
        }

      /* add reduced S(p,q) into Grobner basis */	
	 if(sv.tail[1]!=-1000){
	     sum=sum+1;
	     for(i=1; i<m+n+1; i++){
	        d[sum].tail[i]=sv.tail[i];
	        d[sum].head[i]=sv.head[i];
             }
	    /* add new pair of vectors */
	     for(i=1;i<sum;i++){
                 /*check whether two vectors are prime,
                   gcd(sv.tail,d[i].tail)=1*/
                   stop=0;
	           for(j=1;j<m+n+1;j++)
		      if(sv.tail[j]*d[i].tail[j]!=0){
                              stop=1;
                              break;
                      }
                   if(stop){
		      vp->first=i;
		      vp->second=sum;
                      vp->nextp=(struct pair*)malloc(sizeof(struct pair));
                      vp=vp->nextp;
                      vp->nextp=NULL;
                   }

	     }
         }
         
    }
    /* find the minimal Grobner basis, reduce every vector*/
    for(k=1; k<sum+1; k++){
        d[k]=GMin(d[k],k);
	if(d[k].tail[1]==-1000){
	    for(i=k; i<sum; i++)
		d[i]=d[i+1];
	    sum=sum-1;
	    k=k-1;
	}
    }
    /* find the reduced Grobner basis, reduce every vector*/
    for(k=1; k<sum+1; k++){
        d[k]=GRedu(d[k],k);
    }
    /* output Grobner basis
    printf("\nreduced Grobner basis :\n");
    k=1;
    while(k<sum+1){
	printf("[(");
        for(i=1; i<m+n+1; i++)
	  printf("%d,",d[k].tail[i]);
	printf(")->(");
	for(i=1; i<m+n+1; i++)
	  printf("%d,",d[k].head[i]);
        printf(")]\n");
	k++;
    }
    printf("\nRGB size=%d",sum);*/
    /* find optimal solution */
    for(i=1; i<m+1; i++)
	S[i]=B[i];
    for(i=1; i<n+1; i++)
	S[m+i]=0;
    for(i=1; i<m+n+1; i++){
	OPS[i]=S[i];
    }
    k=1;
    while(k<sum+1){
	j=1;
	for(i=1; i<m+n+1; i++){
	    S[i]=S[i]-d[k].tail[i]+d[k].head[i];
	    if (S[i]<0){
		j=0;
		i=m+n+1;
	    }
	}
       if (j){
	   for(i=1; i<m+n+1; i++)
	      OPS[i]=S[i];
           k=1;
       }
       else {
	 for(i=1; i<m+n+1; i++)
	      S[i]=OPS[i];
         k++;
       }
    }
    /* detect whether IP{A,>c}(b) is feasible */
    j=0;
    for(i=1; i<m+1; i++)
	if (OPS[i]){
	    j=1;
	    i=m;
	}
    if (j){
	printf("\nthere is no feasible solution\n");
    }
    else {/* output optimal solution */
      /* delete external variables y from test set of EIP*/
        l=0;
        for(i=1;i<sum+1;i++){
	  k=1;
	  for(j=1;j<m+1;j++)
	    if(d[i].tail[j]!=0){
	      k=0;
	      break;
	    }
	  if(k){
	    l++;
	    for(j=1;j<n+1;j++)
	      A[l][j]=d[i].tail[m+j];
	    for(j=1;j<n+1;j++)
	      A[l][n+j]=d[i].head[m+j];
	  }
	}
	for(i=1;i<l+1;i++)
	  for(j=1;j<n+1;j++){
	    d[i].tail[j]=A[i][j];
	    d[i].head[j]=A[i][n+j];
	  }
	sum=l;
	/* print the test set of IP 
	for(i=1;i<sum+1;i++){
	  printf("\n[(");
	  for(j=1;j<n+1;j++)
	    printf("%d,",d[i].tail[j]);
	  printf(")->(");
	  for(j=1;j<n+1;j++)
	    printf("%d,",d[i].head[j]);
	  printf(")]");
	}
	printf("\nRGB size=%d\n",sum);*/
	/* print optimal solution */
        for(i=1;i<n+1;i++)
	  B[i]=OPS[m+i];
	for(i=1;i<n+1;i++)
	  OPS[i]=B[i];
        /*printf("\n the optimal solution:\n");
        for(i=1; i<n; i++)
	    printf("x%d=%d, ",i,OPS[i]);
        printf("x%d=%d\n",n,OPS[n]);*/
	
    }
    /*time(&endtime);
    printf("\nCPU time=%d sec.\n",endtime-starttime);*/
    /* call CIP solver */
    /*time(&starttime);*/
    CIP();
    /*time(&endtime);
    printf("\nCPU time=%d sec.\n",endtime-starttime);*/
    
    
}
