%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
% UTILITY

exec(X):- call(X),!.

append([],Y,Y).
append([W|X],Y,[W|Z]):- append(X,Y,Z).

member(H,[H|_T]).
member(H,[_H|T]):- member(H,T).

reverse(X,Y):- rev(X,[],Y).
rev([],Y,Y).
rev([W|X],Y,Z):- rev(X,[W|Y],Z).


%length([],0).
%length([_|T],N):- length(T,N1), N is N1+1.

listtoconj([H],H):-!.
listtoconj([H|T],(H,TT)):-
    listtoconj(T,TT).


name_concat(NameList,NewName):-
        name_concat1(NameList,S), name(NewName,S).
name_concat1([H|L],S):-
        name(H,SH), append(SH,SL,S), name_concat1(L,SL).
name_concat1([],[]).


toList(Str,List):-
	name('[',[DKakko]),name(']',[DKokka]),
	name('(',[CKakko]),name(')',[CKokka]),
	name('.',[Period]),name(',',[Camma]),
	list(Str,[], [DKakko,DKokka,CKakko,CKokka,Period,Camma],List),!.

list([DKakko,DKokka|Z],Z,[DKakko,DKokka|_],[]).
list([Period,CKakko|X],Z,
	[DKakko,DKokka,CKakko,CKokka,Period,Camma],[H|T]):-
	elm(X,[Camma|X1], [DKakko,DKokka,CKakko,CKokka,Period,Camma], H),
	X2=[CKokka|Z],
	list(X1,X2,[DKakko,DKokka,CKakko,CKokka,Period,Camma],T).


elm([DKakko,DKokka|X], X, [DKakko,DKokka|_Z], []):-!.
elm([Period,CKakko|X], Y, 
	[DKakko,DKokka,CKakko,CKokka,Period,Camma], Z):-!,
	list([Period,CKakko|X],Y,
	     [DKakko,DKokka,CKakko,CKokka,Period,Camma],Z).

elm(X,Y, [_,_,_,_,_,Camma],R):- elm1(X,Y,Camma,Z),name(R,Z).
elm1([Camma|X],[Camma|X],Camma,[]).
elm1([W|X],Y,Camma,[W|Z]):- elm1(X,Y,Camma,Z).

%%
%% out(+Obj, +Message)
%% 
out(_Obj, Message):- %NON-GUI
	clause(gui(off),true),!, format('~w',[Message]).
out(Obj, Message):- %GUI.
	rdb:output(Obj, Message). 


showHyp(Obj,Hyp):-
	\+(\+((
		  numbervars(Hyp,0,_),
		  out(Obj,'\nSearch Result is \n'),
		  writeClause(Obj,Hyp),
		  out(Obj,'\n\n')
	      ))).

writeClause(Obj,Cls):-
	(clause(gui(off),true) -> writeClause(Cls);
	    rdb:writeCls(Obj,Cls)).

writeClause([H]):- !,format('~w. ',[H]).
	    
writeClause([H|T]):- %with body
	format('~w :- ',[H]),
	writeClauseB(T,1).
writeClauseB([H],X):-!,
	(X>2 -> format('~n     ',[]);true),
	 format('~w.',[H]).
writeClauseB([H|T],X):-
	(X>2 ->(X1 is 1, format('~n     ',[]));X1 is X+1),
	format('~w, ',[H]),writeClauseB(T,X1).

%% 
%% print_err(+Obj, +Message)
%% 
print_err(_Obj, Message):-
	clause(gui(off),true),!, %NON-GUI
	format(user_err,'~w',[Message]).
print_err(Obj, Message):-
	rdb:output(Obj,Message).


listtoconj([H],H).
listtoconj([H|T],(H,TT)):-
	listtoconj(T,TT).
