%Copyright (C) 1999 Koichi FURUKAWA
%
%Prolog to SQL translator
%
%This program is based on the following Prolog to SQL compiler
%
% --------------------------------------------------------------------------------------
%
% This Prolog to SQL compiler may be distributed free of charge provided that it is
% not used in commercial applications without written consent of the author, and
% that the copyright notice remains unchanged.
%
%                    (C) Copyright by Christoph Draxler, Munich
%                        Version 1.1 of Dec. 21st 1992
%
% I would like to keep in my hands the further development and distribution of the
% compiler. This does not mean that I don't want other people to suggest or even
% implement improvements - quite on the contrary: I greatly appreciate contributions 
% and if they make sense to me I will incorporate them into the compiler (with due
% credits given!). 
% 
% For further development of the compiler, address your requests, comments and
% criticism to the author:
%
%                    Christoph Draxler
%                    CIS Centre for Information and Speech Processing
%                    Ludwig-Maximilians-University Munich
%                    Wagmuellerstr. 23 
%                    D 80538 Munich
%                    Tel : ++49 / +89 / 211 06 64 (-60)
%                    Fax : ++49 / +89 / 211 06 74
%                    Mail: draxler@cis.uni-muenchen.de
%
%
% A report describing the implementation is available upon request from the
% author. 
%
%
% RELEASE INFORMATION
% ===================
% Current version is v. 1.1 of Dec. 21st 1992.
% Version 1.0 Sept. 3 1992
% --------------------------------------------------------------------------------------

translate(PLG, SQL, Prefix, Postfix):-
	trans(PLG, Internal,[]),!,
	convert(Internal, SQL, Prefix,Postfix).


trans([Head|Body],SQL,SQLz):-
	exec((
	findall([Conj,Proj],(
	append(Body,[Head],Hyp),
	pred2table(Hyp,Table),
	exec((tokenize(Head,Proj,0,No),
	tokenize(Table,Goal,No,_Noz) )),
	linearize(Goal,Conj) ),
	Disj))),
	query_gen(Disj,SQL,SQLz),!.

trans([Head|Body],SQL,SQLz):-
	exec((
	findall([Conj,Proj],(
	[Head|Body]=Hyp,
	pred2table(Hyp,Table),
	exec((tokenize(Head,Proj,0,No),
	tokenize(Table,Goal,No,_Noz) )),
	linearize(Goal,Conj) ),
	Disj))),
	query_gen(Disj,SQL,SQLz).


tokenize(X, '$var$'(No),No, Noz):- var(X),!, X='$var$'(No),Noz is No+1.
tokenize('$var$'(ID), '$var$'(ID), No,No):-integer(ID),!.
tokenize([],[],No,No):-!.
tokenize(Const, '$const$'(Const), No,No):- functor(Const,_,0),!.
tokenize(Term, Token, No, Noz):-
	Term=..[F|Args],
	tokenize_arg(Args,TArgs,No,Noz),
	Token=..[F|TArgs].

tokenize_arg([],[],No,No).
tokenize_arg([H|T],[HT|TT],No,Noz):-
	tokenize(H,HT,No,Nom),
	tokenize_arg(T,TT,Nom,Noz).

pred2table([H],Rel):-dg_trans((H:-Rel)).
pred2table([\+(H)],\+(Rel)):- dg_trans((H:-Rel)),!.
pred2table([\+(H)], \+(Rel)):-!, pred2table(H,Rel).

pred2table([H],H):- predicate_property(H,built_in),!.
pred2table([H],Rel):- !,pred2table(H,Rel).
pred2table([H|T], (Rel,TT)):-
	pred2table([H],Rel),
	pred2table(T,TT).

linearize( ((A,B),C), (LinA, (LinB,LinC)) ):-!,
	linearize(A,LinA), linearize(B,LinB),linearize(C,LinC).
linearize( (A,B), (LinA,LinB)):-!,
	linearize(A,LinA), linearize(B,LinB).
linearize((A;_B), LinA):-linearize(A,LinA).
linearize((_A;B), LinB):-linearize(B,LinB).
linearize(\+(A), \+(LinA)):- !, linearize(A,LinA).
linearize(A,A):- \+(A=(_;_)).


query_gen([], SQL,SQL).
query_gen([[Conj,Proj]|T],[SQL|SQLT],SQLZ):-
	translate_conj(Conj, From,[], Where,[], [],Dictz, 0,_),
	translate_proj(Proj,Dictz, Select),
	SQL=query(Select, From, Where),
	query_gen(T,SQLT,SQLZ).


translate_conj(Goal, F,Fz, W,Wz, D,Dz, N,Nz):-
	\+(Goal = (_,_)),!,
	translate_goal(Goal,F,Fz, W,Wz, D,Dz, N,Nz).
translate_conj((Goal,Conj), F,Fz, W,Wz, D,Dz, N,Nz):-
	translate_goal(Goal, F,Fm, W,Wm, D,Dm, N,Nm),
	translate_conj(Conj, Fm,Fz,Wm,Wz,Dm,Dz,Nm,Nz).


translate_goal(Res is Exp, F,F, W,Wz, D,Dz, N,N):- 
	translate_builtin(Res, Exp, W,Wz, D,Dz).

translate_goal(\+(Neg), F,F, W,Wz, D,D, N,N):- 
	all_builtin(Neg),!,
	translate_negComp(Neg, W,Wz,D).

translate_goal(\+(Neg),F,F, W,Wz, D,D, N,Nz):-!, 
        translate_conj(Neg, From,[], Where,[], D,_Dz, N,Nz),
        W = [negated_existential_subquery([*],From,Where)|Wz].

translate_goal(Comp, F,F, W,Wz, D,D, N,N):- 
	Comp =..[OP,LeftArg,RightArg],
	comparison(OP,SQLOP),!,
	translate_comp(LeftArg,RightArg, SQLOP, D, W,Wz).

translate_goal(Simple, [From|Fz],Fz, W,Wz, D,Dz, N,Nz):- 
	Simple=..[Func|Args],
	translate_functor(Func,From,N,Nz),
	translate_args(Args,From, 1, W,Wz,D,Dz).


%%%%%%% ꂼ̕ϊ
translate_functor(F, rel(F,RVar), N,Nz):-
	name_concat(['rel',N],RVar),
	Nz is N+1.

translate_args([], _F, _Pos, W,W, D,D).
translate_args([A|Args], F, Pos, W,Wz, D,Dz):-
	translate_arg(A,F,Pos,W,Wm,D,Dm),
	Pos1 is Pos+1,
	translate_args(Args, F, Pos1, Wm,Wz, Dm,Dz).

translate_arg('$var$'(No), rel(Table,RVar), Pos, W,Wz, D,D):-
	member(dict(No,PRVar, PAtt),D),!,
	dg_att(Pos, Table,Att),
	(PRVar = is ->
	    W=[comp(att(RVar,Att),=,PAtt) |Wz]
	;W=[comp(att(RVar,Att),=,att(PRVar,PAtt)) |Wz]).

translate_arg('$var$'(No), rel(Table,RVar), Pos, W,W,D,Dz):-!,
	dg_att(Pos,Table,Att),
	Dz=[dict(No,RVar,Att)|D].

translate_arg('$const$'(Const), rel(Table,RVar), Pos, W,Wz, D,D):-
	dg_att(Pos, Table,Att),
	W=[comp(att(RVar,Att),=,'$const$'(Const)) |Wz].


translate_builtin('$var$'(No), Exp, W,Wz, D,D):-
	member(dict(No,RV, PExp),D),!,
	evaluable_expression(Exp, D, ArithExp),

	(RV=is -> 
	    W = [comp(PExp,=,ArithExp) |Wz]
	; W=[comp(att(RV,PExp), =, ArithExp)|Wz]).


translate_builtin('$var$'(No), Exp, W,W, D,Dz):-
	evaluable_expression(Exp, D, ArithExp),
	Dz=[dict(No,is,ArithExp)|D].

translate_builtin('$const$'(Const), Exp, W,Wz, D,D):-
	evaluable_expression(Exp, D, ArithExp),
	W=[comp('$const$'(Const), =, ArithExp) |Wz].

translate_builtin(Left,Right, W,Wz,D,D):-
	evaluable_expression(Left,D,LeftExp),
	evaluable_expression(Right,D,RightExp),
	W=[comp(LeftExp,=,RightExp)|Wz].

evaluable_expression(Left + Right, Dict, LeftAr + RightAr):-
	evaluable_expression(Left,Dict, LeftAr),
	evaluable_expression(Right,Dict, RightAr).
evaluable_expression(Left - Right, Dict, LeftAr - RightAr):-
	evaluable_expression(Left,Dict, LeftAr),
	evaluable_expression(Right,Dict, RightAr).
evaluable_expression(Left * Right, Dict, LeftAr * RightAr):-
	evaluable_expression(Left,Dict, LeftAr),
	evaluable_expression(Right,Dict, RightAr).
evaluable_expression(Left / Right, Dict, LeftAr / RightAr):-
	evaluable_expression(Left,Dict, LeftAr),
	evaluable_expression(Right,Dict, RightAr).

evaluable_expression('$var$'(No),Dict, Exp):-
	member(dict(No,RVar,Att),Dict),!,
	(RVar=is ->
	    Exp=Att
	;Exp = att(RVar,Att)).
evaluable_expression('$const$'(Const), _Dict, '$const$'(Const)).

all_builtin((H,T)):- 
	functor(H,F,_A),sql_builtin(F),
	all_builtin(T).
all_builtin((H,T)):- 
	functor(H,F,_A),comparison(F,_),
	all_builtin(T).
all_builtin(H):-functor(H,F,_A),sql_builtin(F).
all_builtin(H):-functor(H,F,_A),comparison(F,_).

translate_negComp((Neg,Conj), W,Wz,D):-
	translate_neg(Neg,W,Wm,D),
	translate_negComp(Conj,Wm,Wz,D).
translate_negComp(Neg,W,Wz,D):- \+(Neg=(_,_)),
	translate_neg(Neg,W,Wz,D).

translate_neg(Neg, W,Wz,D):-
	Neg=..[F, Left,Right],
	comparison(F,SQLOp),
	neg_comparison(SQLOp, SQLNOp),
	translate_comp(Left,Right,SQLNOp,D,W,Wz).

translate_comp(LeftArg,RightArg, SQLOP, D, W,Wz):-
	evaluable_expression(LeftArg,D,LeftExp),
	evaluable_expression(RightArg,D,RightExp),
	W=[comp(LeftExp, SQLOP, RightExp)|Wz].


translate_proj(Term, Dict, SelectList):-
	Term=..[_F|Args],
	proj_args(1, Args,SelectList,Dict).

proj_args(_N, [], [], _Dict).
proj_args(N, [A|Args],  [Att|AttT],Dict):-
	retrieve_arg(N, A,Att,Dict),!,
	N1 is N+1,
	proj_args(N1, Args, AttT,Dict).

proj_args(N, [_A|Args],  AttT,Dict):-
	proj_args(N, Args, AttT,Dict).

retrieve_arg(N, '$var$'(No), Att, Dict):-
	member(dict(No,RVar,AttName),Dict),!,
	(RVar = is -> 
	    Att = as(AttName,N)
	;Att = att(RVar,AttName,N)).


retrieve_arg(N,'$const$'(Const),Att,_Dict):-
	Att = const(Const,N).



sql_builtin(concat).
sql_builtin(substring).
sql_builtin(substr).
sql_builtin(upper).
sql_builtin(lower).
sql_builtin(trim).
sql_builtin(like).
sql_builtin(in).


comparison(=,=).
comparison(=:=,=).
comparison(=/=,<>).
comparison(\==,<>). comparison(\=,<>).
comparison(<,<).  comparison(=<,<=).  comparison(<=,<=).
comparison(>,>).  comparison(>=,>=).  comparison(=>,>=).
comparison(@<,<). comparison(@=<,<=). comparison(@<=,<=).
comparison(@>,>). comparison(@=>,>=). comparison(@>=,>=).

neg_comparison(=,<>).
neg_comparison(=:=,<>).
neg_comparison(=/=,=).
neg_comparison(\==,=). neg_comparison(\=,=).
neg_comparison(<,>=).  neg_comparison(=<,>).   neg_comparison(<=,>).
neg_comparison(>,<=).  neg_comparison(>=,<).   neg_comparison(=>,<).
neg_comparison(@<,>=). neg_comparison(@=<,>).  neg_comparison(@<=,>).
neg_comparison(@>,<=). neg_comparison(@=>,<).  neg_comparison(@>=,<).


get_type('$const$'(Const),number):-
	number(Const).
get_type('$const$'(Const),string):-
	atomic(Const).


convert(Internal, SQL, Prefix,Postfix):-
	convert1(Internal,InternalList,Postfix),
	append(Prefix,InternalList,SQLList),
	name_concat(SQLList,SQL).

convert1([Query],SQL,SQLz):-!,
	convert_query(Query,SQL,SQLz).

convert1([Query|T],SQL,SQLz):-
	convert_query(Query,SQL,[' UNION '|SQLm]),
	convert1(T,SQLm,SQLz).

convert_query(query(Select,From,Where),At,Atz):-
	convert_clause('SELECT DISTINCT',Select,',', At, [' '|At1]),
	convert_clause('FROM',  From,  ',', At1,[' '|At2]),
	convert_clause('WHERE', Where, 'AND', At2, Atz).

convert_query(negated_existential_subquery(Select,From,Where),At,Atz):-
	At = ['NOT EXISTS('|At1],
	convert_clause('SELECT DISTINCT',Select,',', At1, [' '|At2]),
	convert_clause('FROM',  From,  ',', At2,[' '|At3]),
	convert_clause('WHERE', Where, 'AND', At3, [')'|Atz]).


convert_clause(_Keywork, [], _, At,At).

convert_clause(Keyword, [Column|RestColumns], Separator, At,Atz):-
	At = [Keyword, ' '|At1],
	convert_clause([Column|RestColumns],Separator, At1,Atz).

convert_clause(Keyword,Function, [Column], Separator, At,Atz):-
	At = [Keyword, ' ', Function,'('|At1],
	convert_claues([Column],Separator, At1,[')'|Atz]).


convert_clause([Item],_, At,Atz):-
	convert_column(Item,At,Atz).

convert_clause([Item,NextItem|RestItems],Separator, At,Atz):-
	convert_column(Item, At, [' ',Separator,' '|At1]),
	convert_clause([NextItem|RestItems],Separator, At1, Atz).


convert_column('*', ['*'|At],At).
convert_column(att(RangeVar, Attribute),[RangeVar,'.',Attribute|At], At).
convert_column(att(RangeVar, Attribute,No),
	[RangeVar,'.',Attribute,' AS ',Name|At], At):-
	name_concat([att,No],Name).
convert_column(as(Exp, No), At,Atz):-
	name_concat([att,No],Name),
	convert_column(Exp, At,[' AS ',Name|Atz]).

convert_column(rel(Relation,RangeVar), [Relation,' ',RangeVar|At],At).

convert_column(const(Const, No),At,Atz):-
	name_concat([att,No],Name),
	At=['\'',Const,'\'', ' AS ',Name|Atz].


convert_column('$const$'(String),['\'',String,'\''|At],At):-
	get_type('$const$'(String),string).

convert_column('$const$'(Number),[Number|At],At):-
	get_type('$const$'(Number),number).


convert_column(comp(LeftArg,Operator,RightArg),At,Atz):- 
	convert_column(LeftArg, At,[' ',Operator,' '|At1]),
	convert_column(RightArg, At1,Atz).


convert_column(LeftExpr * RightExpr, ['('|At],Atz):-
	convert_column(LeftExpr,At, ['*'|At1]),
	convert_column(RightExpr,At1,[')'|Atz]).

convert_column(LeftExpr / RightExpr, ['('|At],Atz):-
	convert_column(LeftExpr,At, ['/'|At1]),
	convert_column(RightExpr,At1,[')'|Atz]).

convert_column(LeftExpr + RightExpr, ['('|At],Atz):-
	convert_column(LeftExpr,At, ['+'|At1]),
	convert_column(RightExpr,At1,[')'|Atz]).

convert_column(LeftExpr - RightExpr, ['('|At],Atz):-
	convert_column(LeftExpr,At, ['-'|At1]),
	convert_column(RightExpr,At1,[')'|Atz]).

convert_column(negated_existential_subquery(Select,From,Where),At,Atz):-
   convert_query(negated_existential_subquery(Select,From,Where),At,Atz).
