%%%
%%% Copyright (C) 1999 Koichi FURUKAWA
%%%



:- dynamic dg_path/2.
search(Obj, EX, MSH, Result):-
	gen_path(MSH,Path),!,
	astar(Obj, Path, EX, Result).




:- dynamic dg_path/2. 

gen_path([[_No,_Ins,_Mode,_Pt,[]]|_MSHBody], []). 
gen_path([[_No,_Ins,_Mode,Pt,Mt]|MSHBody], Path_set):- 

	(clause(dg_path(_,_),true)-> abolish(dg_path/2);true),

        regist_var(Mt,1), 	
        reverse(MSHBody,MSHr),!,
	dg_set(c,CLim), 
	choice(MSHr, CLim, [],Selected),!, 
        (clause(dg_path(_,_),true)-> abolish(dg_path/2);true),
        regist_paths(Pt,[]), 
	path(Selected, CLim),!,

	gen_path3(Mt,CLim, Path_set).


gen_path3(Mt, CLim, Path_set):-
	get_path(Mt,MPath),
	union_path(MPath,CLim,MUnion), !,
	(MUnion=[] -> Path_set=fail; path_sort(MUnion,Path_set)).
gen_path3(_Mt, _CLim, fail).



regist_var([],_).
regist_var([H|T],D):-
	clause(dg_path(H, Dep),true),!,
	(Dep > D -> (retract(dg_path(H,Dep)), assertz(dg_path(H,D)))
    ;true),
	regist_var(T,D).
regist_var([H|T],D):-	
	assertz(dg_path(H,D)),regist_var(T,D).



choice([],_C, S,S).
choice([[_Index,_Ins,_Mode,_Pt,[]]|MSH],C,S,Sz):-!, 
	choice(MSH,C,S,Sz).
choice([[Index, _Ins, _Mode, Pt,Mt]|MSH], C, S,Sz):-
	check_var(Mt,MVar),
	choice1([Index,Pt,MVar],MSH,C,S,Sz).


choice1([_Index,_Pt,[]], MSH, C, S,Sz):-!, 
	choice(MSH,C,S,Sz).
choice1([Index,Pt,MVar], MSH, C, S,Sz):-
	min_depth(MVar,Min),
	choice2(Min, [Index,Pt,MVar], MSH, C, S,Sz).

choice2(Min, _IndexPtMVar, MSH, C, S,Sz):-
	Min > C,!,
	choice(MSH,C,S,Sz).
choice2(Min, [Index,Pt,MVar], MSH, C, S,Sz):-
	Min1 is Min+1,
	regist_var(Pt,Min1), 
	choice(MSH,C, [[Index,Pt,MVar]|S],Sz).



check_var([],[]).
check_var([H|T], [(H,Dep)|T1]):-
	clause(dg_path(H,Dep),true),!,
	check_var(T,T1).
check_var([_|T],T1):- check_var(T,T1).

min_depth([(_H,D)],D):-!.
min_depth([(_H,D)|T],MIN):- min_depth(T,D,MIN).
min_depth([],Min,Min).
min_depth([(_,D)|T], Tmp, Min):- D<Tmp,!,min_depth(T,D,Min).
min_depth([_|T], Tmp,Min):- min_depth(T,Tmp,Min).


regist_paths([],_).
regist_paths([H|T],X):-
	regist_path(H,X),
	regist_paths(T,X).

regist_path(H,X):-clause(dg_path(H,X),true),!.
regist_path(H,X):-assertz(dg_path(H,X)).



path([], _C).
path([[No,Plus,Minus]|T], C):-
	get_path(Plus,PP),!, 	
	union_path(PP,C,MUnion), 	
	assert_path(Minus, MUnion, No),
	path(T, C).
path([_|T],C):-path(T,C).

get_path([],[]).
get_path([H|T],[HR|TR]):-!,
	setof(Path, dg_path(H,Path), HR),
	get_path(T,TR).

union_path(H,C,Union):-
	union_path1(H,C,Tmp),
	putLen(Tmp,C,Union).

putLen([],_C,[]).
putLen([H|T],C,[(H,Rest)|TR]):-
	length(H,HL),
	Rest is C-HL,
	putLen(T,C,TR).


union_path1([H],_C,H):-!.
union_path1([H,H1|T],C, Res):- 
	union_path2(H,H1,C,HNew,[]), 
	(HNew = [] -> Res = [];
	    union_path1([HNew|T],C,Res)).

union_path2([],_O, _C, R,R).
union_path2([H|T],O,C, R,Rz):-
	union_path3(H,O,C, R,Rm), 
	union_path2(T,O,C, Rm,Rz).

union_path3(_H,[],_C, R,R).
union_path3(H,[O|T],C,R,Rz):- 
	(union_path4(H,O,C, UNION) ->
	    (R=[UNION|Rm],union_path3(H,T,C,Rm,Rz))
	;union_path3(H,T,C,R,Rz)
    ).


union_path4(_,_,-1, _R):-!,fail. 
union_path4([],O, C, O):- length(O,OL),!,C-OL >=0.
union_path4(H,[], C, H):- length(H,HL),!,C-HL >=0.
union_path4([W|H],[W|O],C,  [W|R]):- !,C1 is C-1,
	union_path4(H,O,C1, R).
union_path4([W|H],[Z|O],C,  [W|R]):-W>Z,!,C1 is C-1, 
	union_path4(H,[Z|O],C1, R).
union_path4([W|H],[Z|O],C,  [Z|R]):- C1 is C-1,
	union_path4([W|H],O,C1, R).


assert_path([], _MUnion,  _No).
assert_path([H|Minus], MUnion, No):-
	assert_path1(MUnion, H, No),
	assert_path(Minus,MUnion, No).

assert_path1([],_H,_No). 
assert_path1([(Path,Rest)|Union], (Minus,D), No):-
	Rest-D >=0,!,
	regist_path(Minus,[No|Path]),
	assert_path1(Union, (Minus,D), No).
assert_path1([_|Union], Minus, No):-
	assert_path1(Union, Minus, No).

path_sort([X],[X]):-!.
path_sort(X,Y):- div(X,Part1,Part2),
	path_sort(Part1,S1), path_sort(Part2,S2),
	path_merge(S1,S2,Y).
div([],[],[]).
div([H|T],[H|PT],P2):- div(T,P2,PT).

path_merge([],S,S).
path_merge(S,[],S).

path_merge([(P1,L1)|T1], [(P2,L2)|T2], [(P1,L1)|Y]):-L1>L2,!,
	path_merge(T1,[(P2,L2)|T2],Y).
path_merge([L1|T1], [L2|T2],[L2|Y]):-path_merge([L1|T1],T2,Y).


:- dynamic dg_bestpass/1. 
:- dynamic dg_best/2.     
:- dynamic dg_change/1.   


astar(_Obj, fail, EX, EX):-!. 
astar(Obj, Path, Pos, Result):-

	astar_init,  
	gen_init_hyp(Path,Init), 

	dg_set(nodes, Nodes),
	((evalInitHyp(Obj, Init, InitHyp, Nodes, NNodes),
	  \+(InitHyp=[])) ->
	  (s_sort(InitHyp,Sorted),
	   Sorted=[h(Cost,[_K,_TH,Hyp|_])|_Rest],
	   assert(dg_best(Cost,Hyp)),
	   astar(Obj, NNodes, Sorted))
	;true),!,
	 astar_result(Pos,Result).


astar_init:-
	(clause(dg_bestpass(_),true)->abolish(dg_bestpass/1);true),
	(clause(dg_best(_,_),true)-> abolish(dg_best/2);true),
	(clause(dg_change(_),true)-> abolish(dg_change/1);true),
	assert(dg_change(false)),
	assert(dg_bestpass(0)).


astar_result(_Pos, Result):-
	clause(dg_best(Cost, Result),true),
	rpass(Cost).

astar_result(Pos,[Pos]).


gen_init_hyp([], Init):-!,
	dg_msh(0,Ins,Mode, _Pt, _Mt),
	findall([0,Th,[Hyp],[]],
	        refine(head,Ins,Mode,[],Hyp,Th),
	Init).

gen_init_hyp(Path,Init):- genInitHyp(Path,Init).

genInitHyp([],[]).
genInitHyp([(Path, Len)|T],Hyp):-
	genInitHyp(T,HypT),
	makeHyp(Path,[], Ins, [],Mode, [],Mt),  
	dg_set(c,CLim), C is CLim-Len,
	genInitHyp(C, Path, Ins, Mode, Mt, HypH),
	append(HypH,HypT,Hyp).

makeHyp([], TIns, [Ins|TIns], TMode, [Mode|TMode],TMt, [Mt|TMt]):- 
	dg_msh(0,Ins,Mode,_Pt,Mt).
makeHyp([No|R], TIns, InsR,  TMode, ModeR, TMt, MtR):-
	dg_msh(No,Ins,Mode,_Pt,Mt),
	makeHyp(R, [Ins|TIns], InsR, [Mode|TMode], ModeR, [Mt|TMt],MtR).

genInitHyp(Len,Path, [Ins|InsR], [Mode|ModeR],[_Mt|MtR],HypH):-
	getBind(Ins,Mode, NewMode, MtR),
	findall([Len,Th,[Head|Body],Path],
	     (hrefine(Ins,NewMode,[],Head, Thm, [], MType),
	      brefine(InsR, ModeR, Thm, Body, Th, MType,[])),
	      HypH).



getBind(_,+, +, _):-!.
getBind(I,-, new, MtR):- in(I,MtR),!.
getBind(_I,-, same, _MtR):-!.
getBind(_I,#,#, _):-!.
getBind([], _, [], _):-!.
getBind([H|T], [MH|MT], [NMH|NMT], MtR):-!,
	getBind(H,MH,NMH,MtR),
	getBind(T,MT,NMT,MtR).
getBind(I,M,M, _):- functor(I,_,0),!.
getBind(I,M,NM, MtR):-
	I=..[F|IA],
	M=..[F|IM],
	getBind(IA,IM,NIM,MtR),
	NM=..[F|NIM].

in(I,[Mt|_MtR]):- in2(I,Mt).
in(I,[_|MtR]):- in(I,MtR).
in2(I,[X|_]):-X=..[_,I].
in2(I,[_|T]):-in2(I,T).


hrefine(I, +, Th, X, [X/I|Th], M,M):- var(X).
hrefine(I, +, Th, L, Th, M,M):- !,refine_mem(I,Th,L).
hrefine(I, #, Th, I, Th, M,M):- !.
hrefine(I, same, Th, L, Th, M,M):- !,refine_mem(I,Th,L).
hrefine(I, new, Th, L,  Th, M,M):-refine_mem(I,M,L).
hrefine(I, new, Th, X,  [X/I|Th], M,[X/I|M]):-!,var(X).
hrefine([],_,Th, [],Th, M,M):-!.
hrefine([I|IT],[T|TT],Th,[L|LT],NT, M,Mz):-!,
	hrefine(I,  T,  Th,  L, NT1, M,Mm), 
	hrefine(IT,TT, NT1, LT, NT,  Mm,Mz).
hrefine(X, _X, Th, X,Th, M,M):-functor(X,_,0),!.
hrefine(I, T, Th, L, NTh, M,Mz):-
	I=..[F|AI],
	T=..[F|AT],
	hrefine(AI,AT,Th,AL,NTh, M,Mz),
	L=..[F|AL].

brefine(I, +, Th, L, Th, M,M):- !,refine_mem(I,Th,L).
brefine(I, #, Th, I, Th, M,M):- !.
brefine(I, -, Th, L, Th, M,Mz):- refine_del(I,M,L,Mz).
brefine(I, -, Th, L, Th, M,M):- refine_mem(I,Th,L).
brefine(I, -, Th, X, [X/I|Th], M,M):-!,var(X).
brefine([],_, Th, [], Th, M,M):-!.
brefine([I|IT],[T|TT],Th,[L|LT],NT, M,Mz):-!,
	brefine(I,  T,  Th,  L, NT1, M,Mm), 
	brefine(IT,TT, NT1, LT, NT,  Mm,Mz).
brefine(X, _X, Th, X,Th, M,M):-functor(X,_,0),!.
brefine(I, T, Th, L, NTh, M,Mz):- \+(I=[]),
	I=..[F|AI],
	T=..[F|AT],
	brefine(AI,AT,Th,AL,NTh, M,Mz),
	L=..[F|AL].

refine_del(I,[L/X|T], L, T):- X==I.
refine_del(I,[H|T],   L, [H|T1]):-
	refine_del(I,T,L,T1).

refine(head,I, +, Th, X, [X/I|Th]):- var(X).
refine(_, I, +, Th, L, Th):- !,refine_mem(I,Th,L).
refine(_, I, #, Th, I, Th):- !.
refine(_, I, -, Th, L, Th):- refine_mem(I,Th,L).
refine(_, I, -, Th, X, [X/I|Th]):-!,var(X).
refine(_, [],_,Th, [],Th):-!.
refine(HB, [I|IT],[T|TT],Th,[L|LT],NT):-!,
	refine(HB, I,T,Th,L,NT1), refine(HB, IT,TT,NT1,LT,NT).
refine(_, X, _X, Th, X,Th):-functor(X,_,0),!.
refine(HB, I, T, Th, L, NTh):-
	I=..[F|AI],
	T=..[F|AT],
	refine(HB, AI,AT,Th,AL,NTh),
	L=..[F|AL].

refine_mem(I,[L/X|_],L):- X==I.
refine_mem(I,[_|T],L):- refine_mem(I,T,L).


evalInitHyp(_Obj, [], [], No,No).
evalInitHyp(_Obj,  _, [], No,No):- No<0.
evalInitHyp(Obj, [[C,TH,Hyp,Path]|Init], InitHyp, Nodes,NNodes):-
	Nodes1 is Nodes-1,
	(calc_cost(Obj, Hyp, C, Costs) ->
	 (InitHyp=[h(Costs,[0,TH,Hyp,Path])|InitHypz],
	  evalInitHyp(Obj,Init,InitHypz,Nodes1, NNodes))
	;evalInitHyp(Obj,Init,InitHyp,Nodes1,NNodes)).


%%%%%
%Search Process
%%%%%

astar(_Obj, _Nodes, []). 
astar(Obj, Nodes, _Hyp):- Nodes<0,!,
	out(Obj,'Resource Limited.\n').

astar(Obj, Nodes, [h(Cost, [_K,_Th,Hyp,_Path])|Open]):-prune(Cost),!,
	(rbetter(Cost)->
	   (dg_best(A,B), retract(dg_best(A,B)),
	    retract(dg_change(_)), assert(dg_change(true)),
	    assert(dg_best(Cost,Hyp)))
	;true),
	(noNeed ->
	    astar(Obj, Nodes, Open)
	;(terminated(Open,NewOpen), astar(Obj, Nodes, NewOpen))).

astar(Obj, Nodes, [Best|Open]):-
	expand(Obj, Best,Nodes, (NNodes,Res)),
	s_sort(Res,Res1),
	merge(Res1,Open,Open1),

	(noNeed-> astar(Obj,NNodes,Open1)
	;(terminated(Open1,NewOpen), 
	  astar(Obj,NNodes,NewOpen))).

merge([],X,X).
merge(X,[],X).
merge([X|T],[Y|T1], [X|TT]):-
	scomp(X,Y),!,merge(T,[Y|T1],TT).
merge( XT,  [Y|T1], [Y|TT]):-
	merge(XT,T1,TT).

s_sort([],[]):-!.
s_sort([X],[X]):-!.
s_sort(X,Y):-div(X,Part1,Part2), 
	s_sort(Part1,S1),s_sort(Part2,S2),
	s_merge(S1,S2,Y).

s_merge([],S,S).
s_merge(S,[],S).
s_merge([L|X],[R|Y], [L|Z]):-
	scomp(L,R),!,s_merge(X,[R|Y],Z).
s_merge(X, [R|Y], [R|Z]):-
	s_merge(X,Y,Z).


scomp(h([G|_], _), h([G1|_], _)):- G>G1.
scomp(h([G,F|_], _), h([G,F1|_], _)):- F>F1.

prune([_,_,_,0,_]). 
prune([G,_,_,_,_]):- G<0.
prune([_,_,_,_,C]):- dg_set(c,CLim),C>=CLim.
prune([_,_,P,_,_]):-dg_set(min,Min),P<Min.



rpass([_G,F,P,N,_C]):-
	T is 100*N, dg_set(noise,NLim),T1 is(P+N)*NLim,!,
	T =< T1, F>0.5.

rbetter([G,F,P,N,C]):-
	clause(dg_best([Gb,Fb,Pb,Nb,Cb],_), true),!,
	(F>Fb; (rpass([G,F,P,N,C]), \+(rpass([Gb,Fb,Pb,Nb,Cb])))).


noNeed:- dg_change(false).
noNeed:- clause(dg_best(Cost,_),true), \+(rpass(Cost)),
	abolish(dg_change/1), assert(dg_change(false)).


terminated(X,Y):-
	dg_best([_,F|_],_),terminated(F,X,Y),
	abolish(dg_change/1), assert(dg_change(false)).

terminated(_F, [], []).
terminated(F, [h([G|_],_)|T], TR):- F>=G,!,
	terminated(F,T,TR).
terminated(F, [H|T],[H|TR]):- terminated(F,T,TR).


expand(Obj, h([G,F,P,N,C], [K,Th,Hyp,Path]), Node, Result):-
	getBody(K, Path, Th, NK, Bodies), 
	NC is C+1,
	expand1(Obj, Bodies, Hyp, NC, NK, Path, Res, Node, No),

	Result=(No, [h([G,F,P,N,C],[NK,Th,Hyp,Path])|Res]).

expand(_Obj, _Hyp, Node, (Node,[])).


getBody(K, Path, Th, NK, Bodies):-
	getK(K, Path, NK, Lit, Mode),
	setof([NLit,NTh], refine(body,Lit,Mode,Th,NLit,NTh),Bodies).

getK(K, Path, NK, Lit, Mode):-
	NK is K+1, \+(member(NK, Path)), dg_msh(NK, Lit,Mode, _,_).
getK(K, Path, NK, Lit, Mode):-
	K1 is K+1, dg_msh(K1,_,_,_,_),
	getK(K1, Path,NK,Lit,Mode).

expand1(_Obj, [], _Hyp, _C, _K, _Path, [], Node,Node).

expand1(Obj, [[Lit,Th]|T], Hyp, C,K, Path, Result, Node,Nodez):-
	Node > 0,
	append(Hyp,[Lit],NHyp),
	(calc_cost(Obj, NHyp, C,Costs)->
	 (Result = [h(Costs,[K,Th,NHyp,Path])|Rest],
	  Node1 is Node-1,
	  expand1(Obj,T,Hyp,C,K,Path,Rest,Node1,Nodez))
	;expand1(Obj, T, Hyp, C,K,Path,Result,Node,Nodez)).

expand1(_Obj,  _LitTH, _Hyp, _C, _K, _Path, [], No,No). 


%%%%%%%%%% MUST BE MODIFIED

calc_cost(Obj, Hyp, L, Cost):-
	\+(\+( (numbervars(Hyp,0,_),writeClause(Obj,Hyp)) )),
	calc_cost1(Obj, Hyp, L, Cost),!,
	out(Obj,'\n').

calc_cost(Obj, _Hyp, _L, _Cost):-
	out(Obj,'\n'),!,
	fail.


calc_cost1(Obj, [Head|Body], C, [G,F,P,N,C]):-!,
	Head=..[PF|HeadArgs],
	make_instance(HeadArgs,VarArgs,Ins,[]),
	PHead =..[PF|VarArgs],
	append([PHead|Ins],Body,PHyp),

	translate(PHyp, SQL,[],[]),
	rdb:getCount(Obj, SQL, P),
	name_concat([' P=',P],OutP),out(Obj,OutP),

	G is P-C,clause(dg_bestpass(Bestpass),true),!,
	G > Bestpass,

	dg_ex(PF/PA, NF/PA), 
	NHead=..[NF|VarArgs],

	(NF = '$neg$' -> NHyp=[NHead|Body]
	;append([NHead|Body],Ins,NHyp)),

	translate(NHyp,NSQL,[],[]),
	rdb:getCount(Obj,NSQL, N),
	name_concat([' : N=',N],OutN),out(Obj,OutN),

	F is G-N,
	((Bestpass < F, rpass([G,F,P,N,C])) ->
	    (retract(dg_bestpass(Bestpass)),assert(dg_bestpass(F)))
	;true).



del_instance([],[]).
del_instance([H|T],[H|T1]):- var(H),!,
	del_instance(T,T1).
del_instance([_H|T],[X|T1]):- var(X),
	del_instance(T,T1).

make_instance([],[], I,I).
make_instance([H|T],[H|T1],I,Iz):- var(H),!,
	make_instance(T,T1,I,Iz).
make_instance([H|T],[X|T1],[(X=H)|Im],Iz):- var(X),
	make_instance(T,T1,Im,Iz).
