% Copyright (C) 1999 Koichi FURUKAWA
%
% RDB.pl
% Relational Database(JDBC) interface

:- module(rdb,
	[
	getNewObj/1,  %getNewObj(-OBJ).
	dbset/3,      %dbset(+Obj, +Label, +Str)
	connect/2,    %connect(+Obj, -Res),
	getColName/3, %getColName(+Obj, +TableName, -ColName)
	getOne/3,     %getOne(+Obj, +SQL, -ListofArgs)
	getCount/3,   %getCount(+Obj, +SQL, -Count)
	execSQL/3,    %execSQL(+Obj,+SQL,-Res)
	update/3,     %update(+Obj,+SQL,-Res).
	output/2,     %output(+Obj, +Str),
	writeCls/2,   %writeCls(+Obj, +Term),
	disconnect/2  %disconnect(+Obj, -Res)
    ]).

:- use_module(library(jasper)).
:- load_foreign_resource(rdb).

foreign(method('DG', getNewObj, [static]),java,
	getNewObj([-object('DG')]) ).

foreign(method('DG',dbset,[instance]),java,
	dbset(+object('DG'),+string,+string)).

foreign(method('DG', connect, [instance]),java,
	connect(+object('DG'),[-boolean]) ).

foreign(method('DG', getColName, [instance]),java,
	%getColName(+object('DG'), +string, [-term]) ).
       getColName(+object('DG'), +string, [-chars]) ).

foreign(method('DG', getOne, [instance]),java,
	%getOne(+object('DG'), +string, [-term]) ).
       getOne(+object('DG'), +string, [-chars]) ).

foreign(method('DG', getCount, [instance]),java,
	getCount(+object('DG'), +string, [-integer]) ).

foreign(method('DG', execSQL, [instance]),java,
	%execSQL(+object('DG'),  +string, [-term] ) ).
       execSQL(+object('DG'),  +string, [-chars] ) ).

foreign(method('DG', update, [instance]),java,
	update(+object('DG'), +string, [-boolean]) ).

foreign(method('DG', output, [instance]),java,
	output(+object('DG'), +string) ).

foreign(method('DG', writeCls, [instance]),java,
	writeCls(+object('DG'), +term) ).

foreign(method('DG', disconnect, [instance]),java,
	disconnect(+object('DG'),[-boolean]) ).



foreign_resource(rdb,
	[method('DG', getNewObj, [static]),
	 method('DG', dbset,[instance]),
	 method('DG', connect, [instance]),
	 method('DG', getColName, [instance]),
	 method('DG', getOne, [instance]),
	 method('DG', getCount, [instance]),
	 method('DG', execSQL, [instance]),
	 method('DG', update,  [instance]),
	 method('DG', output, [instance]),
	 method('DG', writeCls, [instance]),
	 method('DG', disconnect, [instance])
	]).
