%Copyright (C) 1999 Koich FURUKAWA
%
%MSH Construction
%

:- dynamic dg_type/2.
:- dynamic dg_msh/5.

construct_msh(Obj, MODEH, Pos,MSH):-

	writeClause(Obj,[Pos]),
	out(Obj,' is used for MSH generation\n'),!,

	out(Obj,'\n Constructing MSH '),

	copy_term(MODEH, modeh(FA, [Pt,Mt,_St], Mode,Pos) ),
	(clause(dg_type(_,_),true)->abolish(dg_type/2);true),
	assert_type(Pt,0), 
	getModeb(FA,ModeB),
	dg_set(i,Depth), 

	const_body(Obj, 1, Depth, ModeB, 1,Body,[]),!,
	out(Obj,' done\n\n'),

	MSH = [[0,Pos,Mode,Pt,Mt]|Body],

	assert_msh(MSH),
	assert_type(Mt,0),
	hash(MSH,MSHVar),
	\+(\+( (numbervars(MSHVar,0,_), show_msh(Obj, MSHVar)))).


getModeb(F/A, ModeB):-
	clause(dg_determination(F/A,_),true),!, 
	findall(modeb(Pred/Arity,A2,A3,A4),
	       (determination(F/A, Pred/Arity),
	        dg_modeb(Pred/Arity,A2,A3,A4)),
		ModeB).
getModeb(_FA, ModeB):- 
	findall(modeb(A1,A2,A3,A4), dg_modeb(A1,A2,A3,A4), ModeB).

assert_type([],_D).
assert_type([H|T],D):-
	clause(dg_type(H,_Dp),true),!, 
	assert_type(T,D).
assert_type([H|T],D):-
	assert(dg_type(H,D)),
	assert_type(T,D).


const_body(_Obj, I,ILim, _ModeB, _No, B,B):-I>ILim,!.
const_body(Obj, I,ILim,ModeB, No, B,Bz):-
	%modeb loop No1͎mshNo\킷
	body_loop(Obj, ModeB, I, B,Bm, No,No1),
	(No=:=No1 -> I1 is ILim+1; I1 is I+1), 
	const_body(Obj,I1,ILim, ModeB, No1, Bm,Bz).


body_loop(_Obj, [], _D, B,B,No,No). 
body_loop(Obj, [modeb(Func/Arity,[Pt,Mt,_St],Mode,Var)|T],D, B,Bz, No,Noz):-
	setof(Pt, (get_Ptype(D,Pt,0), chk_com(Func/Arity,Pt)), Ptlist),
	gen_body(Obj,Ptlist, [Pt,Mt],Var,Mode, D, B,Bm, No,Nom),
	body_loop(Obj,T,D,Bm,Bz,Nom,Noz).

body_loop(Obj, [_|T], D, B,Bz,N,Nz):-
	body_loop(Obj,T,D,B,Bz,N,Nz).

get_Ptype(_D, [],1). 
get_Ptype(D, [any(X)|T], _I):- 
	clause(dg_type(H,J),true), J is D-1,
	H=..[_F,X], get_Ptype(D,T,1).
get_Ptype(D, [any(X)|T], I):-
	clause(dg_type(H,J),true), J=\= D, J=\= D-1,
	H=..[_F,X], get_Ptype(D,T,I).

get_Ptype(D,[H|T],_I):-
	clause(dg_type(H,J),true), J is D-1,
	get_Ptype(D,T,1).
get_Ptype(D,[H|T],I):-
	clause(dg_type(H,J),true), J =\= D, J =\= D-1,
	get_Ptype(D,T,I).


chk_com(Func/Arity,PLIST):- clause(dg_commutative(Func/Arity),true),!,
	chk_com(PLIST).
chk_com(_,_). 

chk_com([_H]). 
chk_com([H,H1|T]):- H @>=H1, chk_com([H1|T]).



gen_body(Obj, PtVList, [Pt,Mt], Var, Mode, Depth, B,Bz, N,Nz):-
	mshTrans(Pt,Var,PtVList, SQL),
	out(Obj,'.'),
	rdb:execSQL(Obj, SQL, ResStr),!, %Get Result (list of Lists)
	toList(ResStr,Res),
	gen_body1(Res,[Pt,Mt],Var,Mode,Depth,B,Bz,N,Nz).

mshTrans(Pt,Var, PtVList, SQL):-
	copy_term([Pt,Var],[Pt1,Var1]),
	make_internal(PtVList, Pt1, Var1, Int,[]),
	makeSQL(Int, SQLList,[]), %SQLList is List of Lists
	name_concat(SQLList,SQL).

make_internal([], _Pt,_Var, Int,Int).
make_internal([H|T], Pt, Var, I,Iz):-
	ptMatch(Pt,H, EQList),
	trans([Var|EQList],I,Im),
	make_internal(T,Pt,Var,Im,Iz).

ptMatch([],[],[]).
ptMatch([H|T],[H1|T1], [X=Y|R]):-
	H=..[F,X],
	H1=..[F,Y],
	ptMatch(T,T1,R).

makeSQL([query(Select,From,Where)],At,Atz):-
	convert_clause('SELECT DISTINCT',Select,',', At, [' '|At1]),	
	convert_clause('FROM',  From,  ',', At1,[' WHERE ('|At2]),
	convert_clause(Where, 'AND', At2, [')'|Atz]).

makeSQL([query(_Select,_From,Where)|T],At,Atz):-
	makeSQL(T,At,[' OR ('|Atm]),
	convert_clause(Where, 'AND', Atm, [')'|Atz]).



gen_body1([], _PTMT, _Var, _Mode, _Depth, B,B,N,N).
gen_body1([Arg|T],[Pt,Mt],Var,Mode,Depth,[B|Bm],Bz,N,Nz):-
	copy_term([Pt,Mt,Var],[Pt1,Mt1,Var1]),
	Var1=..[_F|Arg],
	assert_type(Mt1,Depth),
	B=[N,Var1,Mode,Pt1,Mt1],
	N1 is N+1,
	gen_body1(T,[Pt,Mt], Var, Mode, Depth, Bm,Bz,N1,Nz).

		 

assert_msh(MSH):-
	(clause(dg_msh(_,_,_,_,_),true) -> abolish(dg_msh/5);true),
	assertMSH(MSH).
assertMSH([]).
assertMSH([[No,Ins,Mode,Pt,Mt]|T]):-
	assert(dg_msh(No,Ins,Mode,Pt,Mt)),
	assertMSH(T).


hash(MSH,MSHVar):-
	findall(Type, dg_type(Type,_Depth), Types),
	assign_var(Types,VTypes),
	hash(MSH,VTypes,MSHVar).

assign_var([],[]).
assign_var([H|T], [VH|VT]):-
	var(X), H=..[_,C],VH=[C,X], 
	assign_var(T,VT).

hash([],_,[]).
hash([[_No,Ins,Mode,_Pt,_Mt]|BT],Types, [M|MT]):-
	hash1(Ins,Mode,Types,M),
	hash(BT,Types,MT).

hash1(C,+,Types,X):-!, member([C,X],Types).
hash1(C,-,Types,X):-!, member([C,X],Types).
hash1(C,#,_Types,C):-!.
hash1([Ins|InsT],[Mode|ModeT],Types,[InsX|InsTX]):-!, 
	hash1(Ins,Mode,Types,InsX),
	hash1(InsT,ModeT,Types,InsTX).
hash1(C,_Mode,_Type,C):-functor(C,_F,0),!.
hash1(C,Mode,Types,X):-
	C=..[F|Arg], Mode=..[F|ArgM],
	hash1(Arg,ArgM,Types,ArgsX),
	X=..[F|ArgsX].

show_msh(Obj,MSHVar):- 
        out(Obj,'MSH is \n'),
        writeClause(Obj,MSHVar),
	out(Obj, '\n').
