%%% Copyright (C) 1999 Koichi FURUKAWA
%%%
%%%

%%% OP and Dynamic Declaration
:- op(100, fx, (#)).

%For Datagol COMMANDs
:- dynamic dg_set/2.
:- dynamic dg_modeh/4.  
:- dynamic dg_modeb/4.
:- dynamic dg_commutative/1. 
:- dynamic dg_determination/2.

%For Prolog to SQL translater
:- dynamic dg_ex/2.    
:- dynamic dg_trans/1. 
:- dynamic dg_att/3.   

%For Connection to DB
:- dynamic dg_driver/1.
:- dynamic dg_url/1.
:- dynamic dg_name/1.
:- dynamic dg_passwd/1. 

:- dynamic tablename/1.
:- dynamic viewname/1. 
:- dynamic gui/1.  

%for Result
:- dynamic dg_hyp/1.  


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

start(File,Obj):-
	showCopyright,  
	init,           

	readCls(Obj,File),!,
	chk,!,
	db_init(Obj),!,   
	db_init2(Obj,No),!,

	main(Obj,No).
start(_File, _Obj).

start(Obj):-
	chk,!,
	db_init2(Obj,No),!,%Set ViewName and getColName
	main(Obj,No).
start(_Obj).

chk:-clause(dg_modeh(_,_,_,_),true),clause(dg_modeb(_,_,_,_),true).

showCopyright:-
	format('Copyright (C) 1999 Koichi FURUKAWA.~n~n',[]).

init:-
	assert(gui(off)), %NON-GUI
	init_sets,        %initialize of parameters
	init_modes,       %initialize of Mode Dec
	init_db.          %initialize of db property

init_sets:-
	(clause(dg_set(_,_),true)->abolish(dg_set/2);true),
	assert(dg_set(c,4)),  
	assert(dg_set(i,3)),  
	assert(dg_set(nodes,10000)), 
	assert(dg_set(noise,0)), 
	assert(dg_set(min,1)).   

init_modes:-
	(clause(dg_modeh(_,_,_,_),true)->abolish(dg_modeh/4);true),
	(clause(dg_modeb(_,_,_,_),true)->abolish(dg_modeb/4);true),
	(clause(dg_commutative(_),true)-> abolish(dg_commutative/1);true),
	(clause(dg_determination(_,_),true)->abolish(dg_determination/2);true),
	(clause(dg_ex(_,_),true) -> abolish(dg_ex/2);true),
	(clause(dg_hyp(_),true)-> abolish(dg_hyp/1);true),

	(clause(dg_trans(_),true)->abolish(dg_trans/1);true),
	(clause(dg_att(_,_,_),true) -> abolish(dg_att/3);true),

	(clause(tablename(_),true)->abolish(tablename/1);true),
	assert(tablename('DGTABLE')),
	(clause(viewname(_),true)->abolish(viewname/1);true),
	assert(viewname('DGVIEW')).


init_db:-
	(clause(dg_driver(_),true)->abolish(dg_driver/1);true),
	(clause(dg_url(_),true)->abolish(dg_url/1);true),
	(clause(dg_name(_),true)->abolish(dg_name/1);true),
	(clause(dg_passwd(_),true)->abolish(dg_passwd/1);true).


readCls(Obj, [F|Files]):-
	on_exception(_,see(F),
	            (name_concat([F,': File Not Found\n'], Message),
		    out(Obj,Message),!,fail)),
	 read(X)-> scan(Obj, X, [F|Files]).

scan(_Obj, end_of_file, [_]):- seen.
scan(Obj, end_of_file, [_,File|InF]):-
	seen,
	on_exception(_, see(F),
	            (name_concat([F,': File Not Fount\n'], Message),
		    out(Obj, Message),!,fail)),
	read(X)-> scan(Obj,X,[File|InF]).

scan(Obj, X, F):-
	scan1(Obj, X),
	read(Y)-> scan(Obj, Y, F).


scan1(Obj, (:-H,T)):-!, scan1(Obj,(:-H)), scan1(Obj,(:-	T)).
scan1(_Obj, (:-H)):- predicate_property(H,built_in),!,call(H).
scan1(_Obj, (:-H)):- dg_built_in(H),call(H).
scan1(Obj, (:-H)):-!,out(Obj,'Illegal Command:'),out(Obj,H). 
scan1(_Obj, (H:-B)):- assertz(dg_trans((H:-B))).

dg_built_in(modeh(_)).
dg_built_in(modeb(_)).
dg_built_in(set(_,_)).
dg_built_in(commutative(_/_)).
dg_built_in(determination(_/_,_/_)).
dg_built_in(ex(_/_,_/_)).

dg_built_in(table(_)).    %Tmp Table's name
dg_built_in(view(_)).     %Tmp View's name
dg_built_in(driver(_)).   %driver name (JDBC Driver).
dg_built_in(db(_)).       %URL of DB
dg_built_in(name(_)).     %UserName
dg_built_in(password(_)). %Password


%%
%% COMMANDS
%%  called from readCls/2

modeh(H):- make_modes(dg_modeh, H, MH), assertz(MH).
modeb(B):- make_modes(dg_modeb, B, MB), assertz(MB).

make_modes(MHB, Pred, MODES):-
	functor(Pred,F,Arity),
	Pred=..[F|Args],
	make_modes(Args, P,[], M,[], S,[], LitArg, VarArg),
	Lit=..[F|LitArg], Var=..[F|VarArg],
	MODES=..[MHB, F/Arity, [P,M,S], Lit, Var].

make_modes([], P,P, M,M, S,S, [],[]).
make_modes([A|A1], P,Pz, M,Mz, S,Sz, [L|L1], [V|V1]):-
	make_modes_arg(A, P,Pm, M,Mm, S,Sm, L, V),
	make_modes(A1, Pm,Pz, Mm,Mz, Sm,Sz, L1, V1).

make_modes_arg(+Type, [P|Pz],Pz, M,M, S,S, +,X):-!,var(X), P=..[Type,X].
make_modes_arg(-Type, P,P, [M|Mz],Mz, S,S, -,X):-!,var(X), M=..[Type,X].
make_modes_arg(#Type, P,P, M,M, [S|Sz],Sz, #,X):-!,var(X), S=..[Type,X].

make_modes_arg(Const, P,P, M,M, S,S, Const, Const):-
	functor(Const, _F, 0),!.
make_modes_arg(Term, P,Pz, M,Mz, S,Sz, L,V):-
	Term =..[F|Args],
	make_modes(Args, P,Pz, M,Mz, S,Sz, LArgs, VArgs),
	L =..[F|LArgs], V=..[F|VArgs].


commutative(Pred/Arity):-clause(dg_commutative(Pred/Arity),_),!.
commutative(Pred/Arity):- integer(Arity),
	assertz(dg_commutative(Pred/Arity)).


determination(Pred/Arity, Pred1/Arity1):-
	clause(dg_determination(Pred/Arity, Pred1/Arity1),_),!.
determination(Pred/Arity, Pred1/Arity1):-
	integer(Arity), integer(Arity1),
	assert(dg_determination(Pred/Arity, Pred1/Arity1)).


set(X,Y):- checkSet(set(X,Y)), set1(X,Y).

set1(X,Y):- clause(dg_set(X,OLD),true),
	retract(dg_set(X,OLD)), assertz(dg_set(X,Y)).
set1(X,Y):- assertz(dg_set(X,Y)).

checkSet(set(c,X)):- integer(X), X>0.
checkSet(set(i,X)):- integer(X), X>0.
checkSet(set(nodes,X)):- integer(X), X>0.
checkSet(set(noise,X)):- integer(X), 0 =< X, X =< 100.
checkSet(set(min,X)):- integer(X), X>0.


ex(Pos/Parity,Neg/Narity):- clause(dg_ex(Pos/Parity,Neg/Narity),true),!.
ex(Pos/Parity,Neg/Narity):- assertz(dg_ex(Pos/Parity,Neg/Narity)).


table(Table):-clause(tablename(Table),true),!.
table(Table):-retract(tablename(_)),assert(tablename(Table)).
view(View):-clause(viewname(View),true),!.
view(View):-retract(viewname(_)),assert(viewname(View)).


driver(D):- clause(dg_driver(D),true),!.
driver(D):- (retract(dg_driver(_));true), assert(dg_driver(D)).
db(D):- clause(dg_url(D),true),!.
db(D):- (retract(dg_url(_));true), assert(dg_url(D)).
name(D):- clause(dg_name(D),true),!.
name(D):- (retract(dg_name(_));true), assert(dg_name(D)).
password(D):- clause(dg_passwd(D),true),!.
password(D):- (retract(dg_passwd(_));true), assert(dg_passwd(D)).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%
%% db_init(+Obj).
%%
db_init(Obj):-
	(clause(dg_driver(D),true) -> rdb:dbset(Obj,driver,D);true),
	(clause(dg_url(U),true)    -> rdb:dbset(Obj,url,U);true),
	(clause(dg_name(N),true)   -> rdb:dbset(Obj,name,N);true),
	(clause(dg_passwd(P),true) -> rdb:dbset(Obj,passwd,P);true),

	out(Obj, 'Connecting to DB .. \n'),!,
	rdb:connect(Obj, true). %Connection


db_init2(Obj,No):-
	viewname(ViewName),
	rdb:dbset(Obj,view,ViewName), 
	get_colname(Obj), %get Colname and assert those for createViews.
	createViews(Obj, No).


get_colname(Obj):-
	out(Obj,'Getting Table Info '),
	findall(Table, dg_trans((_Pred:-Table)), Tables),
	flat(Tables,T1,[]), deldup(T1,NewTables),!,
	get_colname(Obj, NewTables),
	out(Obj,' done\n').


flat([H|T],R,Rz):- flat1(H,R,Rm),flat(T,Rm,Rz).
flat([],R,R).

flat1((H,T),R,Rz):-!,flat1(H,R,Rm),flat1(T,Rm,Rz).
flat1(\+(H),R,Rz):-!,flat1(H,R,Rz).
flat1(H,X,X):-predicate_property(H,built_in),!. 
flat1(H,[F|X],X):- functor(H,F,_A).

deldup([],[]).
deldup([H|T],Z):- member(H,T),!,deldup(T,Z).
deldup([H|T],[H|Z]):- deldup(T,Z).

%Table_Name_Loop
get_colname(_,[]).
get_colname(Obj,[TableName|T]):-
	out(Obj,'.'),
	rdb:getColName(Obj, TableName, ColNameStr),
	toList(ColNameStr,ColNames),
	assert_att(TableName, ColNames),
	get_colname(Obj,T).

assert_att(TableName, [[No,ColName, _ColType, _ColLen]|T]):-
	assertz(dg_att(No,TableName,ColName)),
	assert_att(TableName,T).
assert_att(_TableName, []).


createViews(Obj, No):-
	out(Obj,'Create Temporal Views '),
	findall(F/A, (dg_trans((Pred:-_Table)),functor(Pred,F,A)),Prem),
	deldup(Prem,Preds),

	viewname(ViewName),!,
	createViews(Obj,Preds, ViewName, 0,No, PredTable),
	out(Obj,' done\n'),

	retractall(dg_att(_,_,_)),
	retractall(dg_trans(_)),  

	assertViewDec(PredTable),
	get_colname(Obj).



createViews(_Obj,[],_View,No,No, []).
createViews(Obj,[F/A|T],View,No, Noz, [(Pred:-Table)|Res]):-

	functor(Pred,F,A),
	Pred=..[F|Args],
	name_concat([View,No],ViewName),
	Table=..[ViewName|Args],

	translate([Pred], SQL, ['CREATE VIEW ',ViewName,' AS '],[]),
	out(Obj,'.'),
	rdb:update(Obj,SQL,UpdateRes),!,
	(UpdateRes = true ->
	 (No1 is No+1,createViews(Obj,T,View,No1,Noz,Res))
	;(out(Obj, 'Cannot Create View \n'),
	  No1 is No-1,
	  delViews(Obj,View,No1),!,fail)).

createViews(Obj,[F/A|_T],View,No,_Noz, _Res):-
	name_concat(['\n',F,'/',A,
	' Illegal Decralation Create Temporal View Failed\n'],Msg),
	out(Obj,Msg),!,
	No1 is No-1,
	delViews(Obj, View,No1),!,
	fail.


assertViewDec([]).
assertViewDec([H|T]):-
	assert(dg_trans(H)),
	assertViewDec(T).


%%%
%%% main(+OBJ,+No)
%%%

main(Obj,No):-
	findall(modeh(FA,PMS,Mode,Var),dg_modeh(FA,PMS,Mode,Var),MODEH),!,
	out(Obj,'\n Start Learning\n\n'),
	modeh_loop(Obj, MODEH,No),
	showResult(Obj).


modeh_loop(Obj,[],No):-No1 is No-1,
	viewname(ViewName),
	out(Obj,'Delete Temporal Views '),
	delViews(Obj,ViewName,No1). 

modeh_loop(Obj,[modeh(F/A,PMS,Mode,Var)|Rest],No):-
	functor(Head,F,A),dg_trans((Head:-Body)),!,

	(ex_loop(Obj,modeh(F/A,PMS,Mode,Var),(Head:-Body),[],_Res) ->
	 modeh_loop(Obj,Rest,No)
	;(out(Obj,'ex_loop fail\n'), modeh_loop(Obj,[],No))).


ex_loop(Obj,modeh(FA,PMS,Mode,Var), Org,R,Rz):-
	get_one_pos(Obj,FA,EX),  

	(genNeg(Mode,EX,Org,FLAG); 
	    (out(Obj, 'Automatic Negative Dec Generation Fail\n'),
	     out(Obj, 'Illegal Modeh Declaration or No ex/2 Declaration\n'),
	     delTable(Obj,R),!,fail)),

	construct_msh(Obj, modeh(FA,PMS,Mode,Var),EX, MSH),!,

	out(Obj, 'Search Start\n'),
	search(Obj, EX, MSH, Result),
	out(Obj, 'Search End\n'),

	showHyp(Obj,Result),    
	assert(dg_hyp(Result)), 
	delNeg(FA,FLAG),!,      

	updateEX(Obj,R,Result),!,
	ex_loop(Obj, modeh(FA,PMS,Mode,Var), Org,[Result|R],Rz).


%unify if get_one_pos is fail.
ex_loop(Obj, modeh(F/A,_PMS,_Mode,_Var),Org, R,R):-
	functor(Head,F,A), 
	retract(dg_trans((Head:-_Body))),
	assert(dg_trans(Org)),
	delTable(Obj,R). 



get_one_pos(Obj, F/A, EX):-
	functor(EX,F,A),
	translate([EX],SQL,[],[]),
	out(Obj, 'Get One Pos From DB..'),
	rdb:getOne(Obj,SQL,ArgsStr),
	toList(ArgsStr,Args),!, 
	(EX=..[F|Args]-> out(Obj,'done\n');
	    (out(Obj,'No Example\n'),!,fail)).

genNeg(Mode,_EX, _Org,false):- 
	functor(Mode,F,A),
	clause(dg_ex(F/A, _),true),!.
genNeg(Mode, EX, Org,true):-  
	functor(Mode,F,A),
	EX=..[F|Arg],
	Mode=..[F|MArg],

	genNeg1(MArg,Arg,NewArg,NegList,[]),!, 
	\+(NegList=[]),
	listtoconj(NegList,NegConj),

	NewEX=..[F|NewArg],

	copy_term(Org, (NewEX:-PosView)),

	NEG=..['$neg$'|NewArg], 

	asserta(dg_trans((NEG:-(PosView,NegConj)))),
	asserta(dg_ex(F/A, '$neg$'/A)).

genNeg1([],[],[],Z,Z).
genNeg1([H|T], [H1|T1],[H2|T2], Neg,Negz):-
	genNeg2(H,H1,H2,Neg,Negm),
	genNeg1(T,T1,T2,Negm,Negz).
genNeg2(#,H,Var,[\+(Var=H)|Z],Z):-!,var(Var).
genNeg2(_,_H,Var,Z,Z):-var(Var).



delNeg(_FA, false).
delNeg(F/A, true):-
	functor(X,'$neg$',A),
	retract(dg_trans((X:-_))),
	retract(dg_ex(F/A,'$neg$'/A)).

updateEX(Obj, [], [Head|Body]):-!,
	createTable(Obj,Head, ColName),
	insertData(Obj, [Head|Body]),
	updateTrans(Head, ColName).


updateEX(Obj, _R, [Head|Body]):-

	Head=..[PF|HeadArgs],
	make_instance(HeadArgs,VarArgs,Ins,[]),
	PHead=..[PF|VarArgs],
	append([PHead|Ins],Body,PHyp),

	viewname(ViewName),
	translate(PHyp, SQL1,['CREATE VIEW ',ViewName,' AS '],[]),!,
	rdb:update(Obj,SQL1,_Res2),!,

	delCovered(Obj,ViewName),

	name_concat(['DROP VIEW ',ViewName],SQL2),
	rdb:update(Obj,SQL2,_Res3). %View̏


delCovered(Obj,ViewName):-
	tablename(TableName),
	findall(ColName, dg_att(_,TableName,ColName), Cols),
	make_del_where(Cols, WHERE,[], TableName,ViewName),
	name_concat(['DELETE FROM ', TableName, ' WHERE '|WHERE], SQL),
	rdb:update(Obj, SQL,_R).

make_del_where([X],W,Wz, Table,View):-!,
	make_del_where1(Table, View, X,W,Wz).

make_del_where([X|T], W, Wz, Table,View):-
	make_del_where1(Table, View, X, W, [' AND '|Wm]),
	make_del_where(T, Wm, Wz, Table, View).

make_del_where1(Table, View, ColName, W,Wz):-
	W=[Table,'.',ColName, ' = ', View,'.',ColName|Wz].


%%%%%%%%% 
createTable(Obj, Head, ColName):-
	dg_trans((Head:-Relation)), functor(Relation,ViewName,_),

	functor(Relation,ViewName,_),
	rdb:getColName(Obj, ViewName, ColNameStr),
	toList(ColNameStr,ColNameR), 	
	reverse(ColNameR,ColName),
	coltoSQL(ColName, SQLm,[' )']), 

	tablename(TableName),
	name_concat(['CREATE TABLE ',TableName,' ( '|SQLm],SQL),
	rdb:update(Obj,SQL,_Res).


coltoSQL([H],S,Sz):- !,coltoSQL1(H,S,Sz).
coltoSQL([H|T],S,Sz):- coltoSQL1(H, S,[' , '|Sm]),
	coltoSQL(T,Sm,Sz).

coltoSQL1([_No,ColName,ColType,ColLen], S, Sz):-needLen(ColType),!,
	S=[ColName, ' ', ColType,'(',ColLen,')' |Sz].
coltoSQL1([_No,ColName,ColType,_], S, Sz):-
	S=[ColName,' ',ColType |Sz].

needLen(X):- member(X,['CHAR','VARCHAR']).


%%%
insertData(Obj, [Head|Body]):-
	tablename(TableName),

	Head=..[F|Args],
	make_Args(Args,NewArgs,HeadCond,[]), 
	NewHead=..[F|NewArgs],
	(HeadCond=[] -> true
	;(translate([NewHead,\+HeadCond],SQL,
	     ['INSERT INTO ',TableName,' '],[]),
	      %write(SQL),nl,
	      rdb:update(Obj,SQL,_Res1) )
	),

	(Body=[]->true
	;(append([NewHead|HeadCond],[\+Body], NewHyp),
	  translate(NewHyp, SQL1, ['INSERT INTO ',TableName,' '],[]),
	  rdb:update(Obj,SQL1,_Res2))
	).

	
make_Args([],[], X,X).
make_Args([H|T], [New|TT], [(New=H)|I], Iz):-var(H),member_chk(H,T),!,
	make_Args(T,TT,I,Iz).
make_Args([H|T], [H|TT], I,Iz):-var(H),
	make_Args(T,TT,I,Iz).
make_Args([H|T], [New|TT], [(New=H)|I],Iz):-
	make_Args(T,TT,I,Iz).

member_chk(H,[W|_T]):- H==W.
member_chk(H,[_|T]):- member_chk(H,T).


updateTrans(Head, ColName):-
	tablename(TableName),
	functor(Head,F,A),functor(Tmp,F,A),
	dg_trans((Tmp:-Relation)),
	retract(dg_trans((Tmp:-Relation))),

	functor(New, F,A), functor(R,TableName,A),
	New=..[_|Arg], R=..[_|Arg],
	assert(dg_trans((New:-R))),
	assert_att(TableName,ColName).

delViews(Obj,_VIEW,No):-No<0,out(Obj,' done\n').
delViews(Obj,VIEW,No):-
	name_concat(['DROP VIEW ',VIEW,No],SQL),
	out(Obj,'.'),
	rdb:update(Obj,SQL,_Res),
	No1 is No-1,
	delViews(Obj,VIEW,No1).

delTable(_Obj,[]):-!.
delTable(Obj,_R):-
	tablename(TABLE),
	name_concat(['DROP TABLE ',TABLE],SQL),
	rdb:update(Obj,SQL,_Res),
	retractall(dg_att(_,TABLE,_)).


showResult(Obj):-
	findall(Hyp,dg_hyp(Hyp),Hyps),
	out(Obj,'\n\n Obtained Result is \n'),
	showResult(Obj,Hyps).

showResult(Obj,[]):- out(Obj,'\n').
showResult(Obj,[H|T]):-
	\+(\+((
	       numbervars(H,0,_),
	       writeClause(Obj,H)
	   ))),
	   out(Obj,'\n'),
	   showResult(Obj,T).

