%%% Copyright (C) 1999 Koichi FURUKAWA
%
% GUI.pl

tmpfilename('.dgtmp').

%%
%% setSets(Obj,Data).
%%
setSets(Obj,Data):-
	init_sets,
	tmpfilename(FileName),
	tmpWrite(Data,FileName),
	(readCls(Obj,[FileName])->true;init_sets).

%%
%% setModes(Obj,Data).
%%
setModes(Obj,Data):-
	init_modes,
	tmpfilename(FileName),
	tmpWrite(Data,FileName),
	(readCls(Obj,[FileName])->true;init_modes).
%%
%% saveFile(FileName,Data).
%%
saveFile(FileName,Data):-
	open(FileName, write, S),!,
	write(S,Data),
	save_data(S),
	flush_output(S),
	close(S).

%%
%% run(Obj)
%%
run(Obj):-
	(clause(gui(_),true)->abolish(gui/1);true),
	assert(gui(on)),!, %GUIOnɂĂStart
	start(Obj). %db_init2(Obj) and main(Obj).

%%
%% tmpWrite(Data,FileName).
%%   make temp file
tmpWrite(Data, FileName):-
	open(FileName, write, S),!,
	write(S,Data),
	flush_output(S),
	close(S).

%%
%% save_data(Str).
%%   write Mode or Param info to Stream St
save_data(St):-
	save_sets(St),
	save_modes(St),
	save_db(St),
	save_hyp(St).

save_sets(St):-
	clause(dg_set(X,Y),true),
	format(St, ':- set(~w,~w).~n', [X,Y]),fail.
save_sets(_St).

save_modes(St):- 
	clause(dg_modeh(H,_,_,_),true),
	format(St, ':-modeh(~w).~n', [H]), fail.
save_modes(St):-
	clause(dg_modeb(B,_,_,_),true),
	format(St, ':-modeb(~w).~n', [B]), fail.
save_modes(St):-
	clause(dg_determination(X,Y),true),
	format(St, ':-determination(~w,~w).~n',[X,Y]),fail.
save_modes(St):-
	clause(dg_commutative(X),true),
	format(St, ':-commutative(~w).~n',[X]),fail.
save_modes(St):-
	clause(dg_trans(X),true),
	\+(\+(( 
	       numbervars(X,0,_), 
	       format(St, '~w.~n',[X])
	   ))),fail.
save_modes(St):-
	clause(dg_ex(X,Y),true),
	format(St, ':-ex(~w,~w).~n',[X,Y]),fail.

save_modes(_St).

save_db(St):-
	clause(dg_driver(X),true),
	format(St, 'driver(~w).~n',[X]),fail.
save_db(St):-
	clause(dg_url(X),true),
	format(St, 'url(~w).~n',[X]),fail.
save_db(St):-
	clause(dg_name(X),true),
	format(St, 'name(~w).~n',[X]),fail.
save_db(St):-
	clause(dg_passwd(X),true),
	format(St, 'passwd(~w).~n',[X]),fail.
save_db(_St).

save_hyp(St):-
	clause(dg_hyp(Hyp),true),
	\+(\+(( 
	       numbervars(Hyp,0,_), 
	       writeHyp(St,Hyp)
	   ))),fail.
save_hyp(_St).

writeHyp(S, [Head]):- format(S, '~w. ~n',[Head]).
writeHyp(S, [Head|Body]):- \+(Body=[]),
	format(S, '~w:-',[Head]),
	writeHypBody(S, Body,0).

writeHypBody(S, [Body],X):- 
	(X>3 -> format(S,'~n      ',[]);true),
	format(S,'~w. ',[Body]).
writeHypBody(S, [Body|T],X):- \+(T=[]),
	(X>3 ->(X1 is 0, format(S,'~n      ',[]));X1 is X+1),
	format(S,'~w,',[Body]),
	writeHypBody(S, T,X1).
