//Copyright (C) 1999 Koichi FURUKAWA
//Datagol.java


import java.awt.*;
import java.awt.event.*;
import java.io.*;

public class Datagol {
  public static void main(String argv[]){
    try {
      DatagolFrame df = new DatagolFrame("Datagol/RDB", 800, 500);
    } catch (Exception ex){
      System.out.println(ex);
    }
  }
  Datagol(){}
}

class DatagolFrame extends Frame {
  
  static DBPLG db=null;

  int x, y;
  DBDialog conDialog;

  MenuBar menubar;
  Menu menu1; 

  Menu set;
  MenuItem iSave, iLoad, iExec, iShow_Hyp, iQuit;
  MenuItem iMode, iParam;

  Menu menu2; 
  MenuItem iConnect, iDisconnect, iTable_View, iSQLQuery;

  EditPanel pEdit; 
  OutPanel output;

  Font font;

  DatagolFrame( String title, int sizex, int sizey){
    font = new Font("",Font.PLAIN,16);
    setFont(font);

    x = sizex; y = sizey;

    setSize(x,y);
    setTitle(title);

    menu1 = new Menu("Menu");
    set = new Menu("setting");  
    set.add(iMode = new MenuItem("Modes"));
    set.add(iParam = new MenuItem("Parameter"));

    menu1.add(set); 
    menu1.addSeparator();
    menu1.add(iLoad = new MenuItem("Load File"));
    menu1.add(iSave = new MenuItem("Save File"));
    menu1.addSeparator();
    menu1.add(iExec = new MenuItem("Exec"));
    menu1.addSeparator();
    menu1.add(iShow_Hyp = new MenuItem("Show Result"));
    menu1.addSeparator();
    menu1.add(iQuit = new MenuItem("Quit"));

    menu2 = new Menu("DB");
    menu2.add(iConnect = new MenuItem("Connect to DB"));
    menu2.add(iDisconnect = new MenuItem("Disconnect"));
    menu2.addSeparator();
    menu2.add(iTable_View = new MenuItem("Table/View Info"));
    menu2.addSeparator();
    menu2.add(iSQLQuery = new MenuItem("SQL Query"));
    
    menubar = new MenuBar();
    menubar.add(menu1);
    menubar.add(menu2);
    setMenuBar(menubar);


    output = new OutPanel();
    db = new DBPLG(output);
    pEdit = new EditPanel(db);

    setLayout(new GridLayout(1,2,3,3));
    add(pEdit);
    add(output);

    iMode.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	pEdit.showPanel("Mode");
      }
    });
    
    iParam.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	pEdit.showPanel("Parameter");
      }
    });

    iLoad.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){

	FileDialog loadDialog = 
	  new FileDialog(new Frame(),"Load",FileDialog.LOAD);
	loadDialog.show();

	if(loadDialog.getFile() != null){
	  String loadfile=
	    loadDialog.getDirectory()+loadDialog.getFile();

	  pEdit.setText( db.loadFile(loadfile));
	}
      }
    });

    iSave.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){

	FileDialog saveDialog =
	  new FileDialog(new Frame(),"Save",FileDialog.SAVE);
	saveDialog.show();
	if(saveDialog.getFile() != null){
	  String savefile=
	    saveDialog.getDirectory()+saveDialog.getFile();
	  db.saveFile(savefile, pEdit.getText());
	}
      }
    });

    iExec.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	db.run();
      }
    });


    iShow_Hyp.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	db.showResult();
      }
    });

    iQuit.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	dispose();
	db.disconnect();
	System.exit(0);
      }
    });

    iConnect.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	conDialog.init(400,300,db);
      }
    });

    iDisconnect.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	db.disconnect();
      }
    });

    iTable_View.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	db.getTable();
      }
    });

    iSQLQuery.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	pEdit.showPanel("SQL");
      }
    });

    show();
    conDialog = new DBDialog(this);
  }
}

class EditPanel extends Panel {

  QueryPanel pSQL,pMode;
  ParamPanel pParam;
  CardLayout CL;
  DBPLG db;

  EditPanel(DBPLG dbplg){
    db=dbplg;

    setLayout(CL = new CardLayout());

    pSQL = new QueryPanel("SQL",db,true);
    pMode = new QueryPanel("Mode",db,false); 
    pParam = new ParamPanel("Parameter", 18,db);
    
    add("SQL", pSQL);
    add("Mode", pMode);
    add("Parameter", pParam);
  }
  
  void showPanel(String str){
    CL.show(this,str);
  }

  void setText(String str){
    pMode.setText(str);
  }

  String getText(){
    return(pMode.getText());
  }

  void setParam(String param, String val){
    pParam.setText(param,val);
  }

}

class QueryPanel extends Panel { 
  Label lab;
  Button exec, cls;
  TextArea ta;
  Panel p;
  DBPLG db=null;
  boolean flag=false;

  QueryPanel(String str, DBPLG dbplg, boolean bool){
    lab = new Label(str);
    db=dbplg;
    flag = bool;

    ta = new TextArea();
    ta.setEditable(true);
    exec = new Button("Exec");
    cls = new Button("Cls");

    p = new Panel();
    p.add(exec);
    p.add(cls);
    
    setLayout(new BorderLayout(3,3));
    add("North",lab);
    add("Center",ta);
    add("South",p);

    cls.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	ta.setText("");
      }
    });

    exec.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	db.execQuery(lab.getText(),ta.getText());
	if(flag)
	  ta.setText("");
      }
    });
  }

  void setText(String str){
    ta.setText(str);
  }
  String getText(){
    return (ta.getText());
  }
}


class ParamPanel extends Panel {
  Label lab;
  FormPanel pC, pI, pNoise,pNodes;
  Panel pbutton,pform;
  Button ok, dft;
  DBPLG db;
  
  ParamPanel(String str, int size, DBPLG dbplg){
    db=dbplg;

    pC = new FormPanel("Max Length", size, "4","default");
    pI = new FormPanel("Variable Depth", size, "3","default");
    pNoise = new FormPanel("Noise", size, "0","default");
    pNodes = new FormPanel("Max Nodes", size, "10000","default");

    pform = new Panel();
    pform.setLayout(new GridLayout(5,1,3,3));
    pform.add(lab = new Label(str));
    pform.add(pC);
    pform.add(pI);
    pform.add(pNoise);
    pform.add(pNodes);

    ok = new Button("OK");
    dft = new Button("Default");
    pbutton = new Panel();
    pbutton.add(ok);
    pbutton.add(dft);


    add(pform);
    add(pbutton);

    dft.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	pC.setDefault();
	pI.setDefault();
	pNoise.setDefault();
	pNodes.setDefault();
      }
    });
    ok.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){

	db.execQuery(
		      "Parameter",
		      ":-set(c,"+pC.getText()+").\n"+
		      ":-set(i,"+pI.getText()+").\n"+
		      ":-set(noise,"+pNoise.getText()+").\n"+
		      ":-set(nodes,"+pNodes.getText()+").\n"
		      );
      }
    });
  }

  void setText(String param, String val){
    if(param.equals("c"))pC.setText(val);
    else if(param.equals("i"))pI.setText(val);
    else if(param.equals("noise"))pNoise.setText(val);
    else if(param.equals("nodes"))pNodes.setText(val);
  }

}


class FormPanel extends Panel {
  Label lab;
  TextField tf;
  Button bt;
  String df="";
  
  FormPanel(String s, int size, String initval, String btname){
    df = initval;
    lab = new Label(s);
    tf = new TextField(initval,size);
    bt = new Button(btname);
    setLayout(new BorderLayout());
    add("West",lab);
    add("Center",tf);
    add("East",bt);

    bt.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	tf.setText(df);
      }
    });
  }

  public String getLabelText(){
    return (getLabel()+"="+getText());
  }

  public String getText(){
    return (delspace(tf.getText()));
  }
  public String getLabel(){
    return (lab.getText());
  }
  public void setDefault(){
    tf.setText(df);
  }
  public void setText(String str){
    tf.setText(str);
  }
  public String delspace(String str){
    int first=0,last;
    last = str.length()-1;
    while(first<=last && ' '==str.charAt(first))
      first++;
    while(first<=last && ' '==str.charAt(last))
      last--;
    return str.substring(first,last+1);
  }
}



class DBDialog extends Dialog {
  FormPanel driver, url, name, passwd;
  Button connect, cancel, load, save;
  Panel bp, pform;
  DBPLG db=null;

  DBDialog(DatagolFrame parent){
    super(parent, "Connection Dialog", true);

    pform = new Panel();
    pform.add(driver = new FormPanel("Driver", 25, "","Cls"));
    pform.add(url = new FormPanel("URL", 25,"","Cls"));
    pform.add(name = new FormPanel("Username", 25,"","Cls"));
    pform.add(passwd = new FormPanel("Password", 25,"","Cls"));

    passwd.tf.setEchoChar('*');
    
    bp = new Panel();
    bp.add(connect = new Button("Connect"));
    bp.add(cancel = new Button("Cancel"));
    bp.add(load = new Button("load"));
    bp.add(save = new Button("save"));

    setLayout(new BorderLayout(3,3));
    add("Center",pform);
    add("South",bp);
    setResizable(false);

    connect.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){

	db.setDRIVER(driver.getText());
	db.setURL(url.getText());
	db.setNAME(name.getText());
	db.setPASSWD(passwd.getText());

	db.connect();
	setVisible(false);
      }
    });

    cancel.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	setVisible(false);
      }
    });
    
    load.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	FileDialog filedialog = 
	  new FileDialog(new Frame(),"Load",FileDialog.LOAD);
	filedialog.show();
	filedialog.setModal(true);
	if(filedialog.getFile() != null){
	  try{
	    FileReader fr = 
	      new FileReader(filedialog.getDirectory()+filedialog.getFile());
	    BufferedReader br = new BufferedReader(fr);
	    String str;
	    while(true){
	      str = br.readLine();
	      if(str==null){break;
	      }else if (0==str.indexOf("Driver=")){
		driver.setText(str.substring("Driver=".length()));
	      }else if (0==str.indexOf("URL=")){
		url.setText(str.substring("URL=".length()));
	      }else if (0==str.indexOf("Username=")){
		name.setText(str.substring("Username=".length()));
	      }else if (0==str.indexOf("Password=")){
		passwd.setText(str.substring("Password=".length()));
	      }else {}
	    }
	    br.close();
	  }catch (Exception ex){
	    db.out(ex.getMessage());
	  }
	}        
      }
    });
    
    save.addActionListener(new ActionListener(){
      public void actionPerformed(ActionEvent e){
	FileDialog filedialog =
	  new FileDialog(new Frame(),"Save",FileDialog.SAVE);
	filedialog.show();

	if(filedialog.getFile() != null){
	  try{
	    String str;
	    FileWriter fw =
	      new FileWriter(filedialog.getDirectory()+filedialog.getFile());
	    BufferedWriter bw = new BufferedWriter(fw);
	    
	    str = driver.getLabelText();
	    bw.write(str,0,str.length());
	    bw.newLine();
	    str = url.getLabelText();
	    bw.write(str,0,str.length());
	    bw.newLine();
	    str = name.getLabelText();
	    bw.write(str,0,str.length());
	    bw.newLine();
	    str = passwd.getLabelText();
	    bw.write(str,0,str.length());
	    bw.newLine();

	    bw.flush();
	    bw.close();
	  } catch (Exception ex){
	    db.out(ex.getMessage());
	  }
	}
      }
    });
  }
  
  void init(int sizex, int sizey, DBPLG dbplg){
    setSize(sizex, sizey);
    db=dbplg;
    setVisible(true);
  }
}
