// Copyright (C) 1999 Koichi FURUKAWA

import java.sql.*;
import java.util.*;

import jasper.*;

public class DG{
  String VIEWNAME = "DGVIEW";
  String DRIVER = "";
  String URL = "";
  String NAME = "";
  String PASSWD = "";

  Connection con = null;

  OutPanel out = null;

  SICStus sp; 

  static public void main(String args[]){
    int i;
    DG obj = new DG(null); 

    if(args.length == 0) {
      System.exit(1);
    }

    for(i=0;i<args.length;i++){
      if(args[i].equals("-driver")){
	i++;
	obj.setDRIVER(args[i]); 
      }else if(args[i].equals("-db")){
	i++;
	obj.setURL(args[i]); 
      }else if(args[i].equals("-name")){
	i++;
	obj.setNAME(args[i]);
      }else if(args[i].equals("-password")){
	i++;
	obj.setPASSWD(args[i]);
      } else {
	break;
      }
    }

    SPTerm list = new SPTerm(obj.sp);

    try{
      for(int j=(args.length-1);j>=i;j--){
	list.consList(new SPTerm(obj.sp, args[j]), list);
      }
    }catch(Exception ex){
      ex.printStackTrace();
      System.exit(0);
    }
    obj.start(list,obj);
  }


  //Constructor
  DG (OutPanel outpanel){
    init();
    out = outpanel;
    try{
      //Init SICStus Prolog
      sp = new SICStus(null,null);
      sp.restore("datagol.sav");
    } catch (Exception ex){
      ex.printStackTrace();
      output(ex.getMessage());
    }
  }

  void init(){
    con = null;
    DRIVER = "";
    URL = "";
    NAME = "";
    PASSWD = "";
  }

  void initSetAndMode(){
    try {
      SPPredicate pred = new SPPredicate(sp, "init_sets",0,"");
      if(!sp.query(pred, new SPTerm[]{})){
	output("init_set fail\n");
      }
      SPPredicate pred1 = new SPPredicate(sp, "init_modes",0,"");
      if(!sp.query(pred1, new SPTerm[]{})){
	output("init_modes fail\n");
      }
    } catch (Exception ex){
      ex.printStackTrace();
      output(ex.getMessage());
    }
  }

  void start(SPTerm Filenames, DG obj){
    try{
      SPPredicate pred = new SPPredicate(sp,"start",2,"");
      SPTerm term1 = Filenames;
      SPTerm term2 = new SPTerm(sp).putObject(obj);

      if(!sp.query(pred, new SPTerm[] {term1, term2}) ){
	output("start/2 fail\n");
      }
      obj.disconnect();
    } catch (Exception ex){
      ex.printStackTrace();
      output(ex.getMessage());
    }
  }

  void dbset(String str, String val){
    if(str.equals("driver")){
      setDRIVER(val);
    } else if(str.equals("url")){
      setURL(val);
    } else if(str.equals("name")){
      setNAME(val);
    } else if(str.equals("passwd")){
      setPASSWD(val);
    } else if(str.equals("view")){
      setVIEWNAME(val);
    }
  }

  void setVIEWNAME(String str){
    VIEWNAME = str;
  }
  void setDRIVER(String str){
    DRIVER = str;
  }
  void setURL(String str){
    URL = str;
  }
  void setNAME(String str){
    NAME = str;
  }
  void setPASSWD(String str){
    PASSWD = str;
  }

  String getDRIVER(){
    return DRIVER;
  }
  String getURL(){
    return URL;
  }
  String getNAME(){
    return NAME;
  }
  String getPASSWD(){
    return PASSWD;
  }


  boolean isConnected(){
    return (con != null);
  }

  boolean connect(){
    if(!isConnected()){
      try{
	Class.forName(DRIVER).newInstance();
	con = DriverManager.getConnection(URL,NAME,PASSWD);
	out("Connected to "+URL+"\n");
	return true;
      } catch (Exception ex){
	ex.printStackTrace();
	out("Connection Error\n"+ ex.getMessage()+"\n");
	return false;
      }
    }
    else {
      out("Already Connected\n");
      return true;
    }
  }
  

  boolean disconnect(){
    if(isConnected()){
      try{
	con.close();
	init();
	out("Disconnected\n");
	return true;
      }catch (Exception ex){
	out("Disconnect Error\n" +ex.getMessage());
	init();
	return false;
      }
    }else
      return true;
  }
  
  String getOne(String SQL){
    SPTerm list = new SPTerm(sp);

    try{
      Statement stmt = con.createStatement();
      ResultSet rs = stmt.executeQuery(SQL);

      if(rs.next()) {
	ResultSetMetaData rsMData = rs.getMetaData();
	int column = rsMData.getColumnCount();
	for(;column>=1;column--){
	  list.consList(new SPTerm(sp,rs.getString(column)), list);
	}
	rs.close();
	stmt.close();
	return list.toString();
      } else{
	rs.close();
	stmt.close();
	return list.toString();
      }
    } catch (Exception ex){
      out("GetOne Error\n"+ex.getMessage());
      return list.toString();
    }
  }

  int getCount(String SQL){
    try{

      Statement stmt = con.createStatement();
      stmt.executeUpdate("CREATE VIEW "+VIEWNAME+" AS "+SQL);
      ResultSet rs =
	stmt.executeQuery("SELECT COUNT(*) FROM "+VIEWNAME);
      rs.next();
      int count = rs.getInt(1);
      rs.close();
      stmt.executeUpdate("DROP VIEW "+VIEWNAME);
      stmt.close();
      return count;

    } catch (Exception ex){
      ex.printStackTrace();
      out("GetCount Error\n"+ex.getMessage());
      return 0;
    }
  }


  String execSQL(String SQL){
    try{
      Statement stmt = con.createStatement();
      ResultSet rs = stmt.executeQuery(SQL);
      SPTerm result = getResultSetList(rs);
      rs.close();
      stmt.close();
      return result.toString();
    } catch (Exception ex){
      ex.printStackTrace();
      out("ExecSQL Error\n" +ex.getMessage());
      return "[]";
    }
  }

  SPTerm getResultSetList(ResultSet rs){
    SPTerm list = new SPTerm(sp);
    try{
      ResultSetMetaData rsMData = rs.getMetaData();
      
      while(rs.next()){
	SPTerm collist = new SPTerm(sp);
	for (int column = rsMData.getColumnCount(); column>0;column--){
	  collist.consList(new SPTerm(sp, rs.getString(column)), collist);
	}
	list.consList(collist,list);
      }
      return list;
    } catch (Exception ex){
      ex.printStackTrace();
      out("GetResultSetList Error\n" +ex.getMessage());
      return list;
    }
  }

  String getColName(String tablename){
    SPTerm list = new SPTerm(sp);
    try{
      DatabaseMetaData dbmeta = con.getMetaData();
      ResultSet rs = dbmeta.getColumns(null,null,tablename,null);
      if(rs != null){
	int i=0;
	while(rs.next()){
	  i++;
	  SPTerm l = new SPTerm(sp);
	  l.consList(new SPTerm(sp,rs.getString(7)),l); 
	  l.consList(new SPTerm(sp,getColType(rs.getShort(5))),l);
	  l.consList(new SPTerm(sp,rs.getString(4)),l); 
	  l.consList(new SPTerm(sp,i),l); 
	  list.consList(l,list);
	}
      }
      return list.toString();
    } catch(Exception ex){
      ex.printStackTrace();
      out("getColName Error\n" +ex.getMessage());
      return list.toString();
    }
  }


  String getColType(short type){
    String str;

    switch (type){
    case Types.BIGINT : 
      str = "BIGINT"; break;
    case Types.BINARY : 
      str = "BINARY"; break;
    case Types.BIT : 
      str = "BIT"; break;
    case Types.CHAR : 
      str = "CHAR"; break;
    case Types.DATE : 
      str = "DATE"; break;
    case Types.DECIMAL : 
      str = "DECIMAL"; break;
    case Types.DOUBLE : 
      str = "DOUBLE"; break;
    case Types.FLOAT : 
      str = "FLOAT"; break;
    case Types.INTEGER : 
      str = "INTEGER"; break;
    case Types.LONGVARBINARY : 
      str = "LONGVARBINARY"; break;
    case Types.LONGVARCHAR : 
      str = "LONGVARCHAR"; break;
    case Types.NULL : 
      str = "NULL"; break;
    case Types.NUMERIC : 
      str = "NUMERIC"; break;
    case Types.OTHER : 
      str = "OTHER"; break;
    case Types.REAL : 
      str = "REAL"; break;
    case Types.SMALLINT : 
      str = "SMALLINT"; break;
    case Types.TIME : 
      str = "TIME"; break;
    case Types.TIMESTAMP : 
      str = "TIMESTAMP"; break;
    case Types.TINYINT : 
      str = "TINYINT"; break;
    case Types.VARBINARY : 
      str = "VARBINARY"; break;
    case Types.VARCHAR : 
      str = "VARCHAR"; break;
    default: str = "[]";
    }
    return str;
  }


  boolean update(String SQL){
    try{
      Statement stmt = con.createStatement();
      stmt.executeUpdate(SQL);
      return true;
    } catch (Exception ex){
      ex.printStackTrace();
      out("update Error\n" +ex.getMessage());
      return false;
    }
  }


  void output(String str){
    if(out == null)
      System.out.print(str);
    else
      out.addText(str);
  }

  void out(String str){
    if(out == null)
      System.out.print(str);
    else
      out.showText(str);
  }

  void writeCls(SPTerm HypList){
    int i;
    SPTerm[] Hyp = HypList.toTermArray();

    if(Hyp.length == 1){ 
      output(Hyp[0].toString()+".");
    } else{
      output(Hyp[0].toString()+" :- ");
      for(i=1;i<Hyp.length-1;i++){
	output(Hyp[i].toString()+",");
	if(i%2==0)output("\n     ");
      }
      output(Hyp[i].toString()+".");
    }
  }

}
