/* Copyright (C) 1999 Koichi FURUKAWA

 */

import java.sql.*;
import java.util.*;
import java.io.*;

import jasper.*;

public class DBPLG {
  String tableInfo = null;
  DG dg;

  DBPLG(OutPanel output){
    dg = new DG(output);
    dg.initSetAndMode();
  }

  void connect(){
    tableInfo=null;
    dg.connect();
  }

  void disconnect(){
    tableInfo=null;
    dg.disconnect();
  }

  void setDRIVER(String str){
    dg.setDRIVER(str);
  }
  void setURL(String str){
    dg.setURL(str);
  }
  void setNAME(String str){
    dg.setNAME(str);
  }
  void setPASSWD(String str){
    dg.setPASSWD(str);
  }

  void out(String str){
    dg.out(str);
  }

  void run(){
    try{
      if(!dg.isConnected()){
	dg.out("Not Connected\n");
      }else{
	dg.out("");
	SPPredicate pred = new SPPredicate(dg.sp, "run", 1,"");
	SPTerm term = new SPTerm(dg.sp).putObject(dg);
	dg.sp.query(pred, new SPTerm[] {term});
      }
    }catch (Exception ex){
      dg.out("run Error\n" +ex.getMessage());
    }
  }

  String loadFile(String filename){
    StringBuffer strbuf = new StringBuffer();
    FileInputStream fin;
    DataInputStream din;
    char b;

    try{
      fin = new FileInputStream(filename);
      din = new DataInputStream(fin);
      try{
	while(true){
	  b = (char)din.readByte();
	  strbuf.append(b);
	}
      }catch(EOFException ex){
	return strbuf.toString();
      }catch(IOException ex){
	return ("IO Error\n");
      }finally{
	fin.close();
      }
    }catch(FileNotFoundException ex){
      return("File Not Found\n");
    }catch(IOException ex){
      return("Closing ERROR");
    }
  }

  void saveFile(String filename, String Contents){
    try{
      SPPredicate pred = new SPPredicate(dg.sp, "saveFile",2,"");
      SPTerm term = new SPTerm(dg.sp,filename);
      SPTerm term1 = new SPTerm(dg.sp,Contents);
      dg.sp.query(pred, new SPTerm[] {term, term1});
    }catch(Exception ex){
      ex.printStackTrace();
      dg.out("SaveFile ERROR\n"+ex.getMessage());
    }
  }

  void showResult(){
    try{
      dg.out("");
      SPPredicate pred = new SPPredicate(dg.sp,"showResult",1,"");
      SPTerm term = new SPTerm(dg.sp).putObject(dg);
      dg.sp.query(pred, new SPTerm[] {term});
    }catch(Exception ex){
      dg.out("Run ERROR\n"+ex.getMessage());
    }
  }

  void getTable(){
    try{
      if(!dg.isConnected()){
	dg.out("Not Connected\n");
      } else if(tableInfo != null){
	dg.out(tableInfo);
      } else {
	DatabaseMetaData dbmeta = dg.con.getMetaData();
	StringBuffer strbuf = new StringBuffer();
	ResultSet rstable = dbmeta.getTables(null,null,null,null);
	while(rstable.next()){
	  String catalog_name = rstable.getString(1);
	  String schema_name = rstable.getString(2);
	  String table_name = rstable.getString(3);
	  String table_type = rstable.getString(4);
	  
	  if(table_type != null && 
	     (table_type.equals("SYSTEM TABLE") ||
	      table_type.equals("SYSTEM VIEW"))) continue;

	  strbuf.append(table_name+" ("+table_type+")\n");

	  ResultSet rscolumn =
	    dbmeta.getColumns(catalog_name,schema_name,table_name,null);
	    if(rscolumn != null){
	    while(rscolumn.next()){
	      String column_name = rscolumn.getString(4); 
	      String column_type = rscolumn.getString(6); 
	      strbuf.append("\t"+column_name+"("+column_type+")\n");
	    }
	    rscolumn.close();
	  }

	  ResultSet rsprimarykeys
	    = dbmeta.getPrimaryKeys(catalog_name, schema_name, table_name);
	  strbuf.append("Primary Key = ");
	  if(rsprimarykeys != null){
	    while(rsprimarykeys.next()){
	      strbuf.append(rsprimarykeys.getString(4)+" ");
	    }
	    rsprimarykeys.close();
	  }
	  strbuf.append("\n");

	  strbuf.append("Imported Key = ");
	  ResultSet rsimportedkeys
	    = dbmeta.getImportedKeys(catalog_name,schema_name,table_name);
	  if(rsimportedkeys != null){
	    while(rsimportedkeys.next()){
	      strbuf.append(rsimportedkeys.getString(7)+":"+
			    rsimportedkeys.getString(8)+" ");
	    }
	    rsimportedkeys.close();
	  }
	  strbuf.append("\n");

	  strbuf.append("Exported Key = ");
	  ResultSet rsexportedkeys
	    = dbmeta.getExportedKeys(catalog_name,schema_name,table_name);
	  if(rsexportedkeys !=null){
	    while(rsexportedkeys.next()){
	      strbuf.append(rsexportedkeys.getString(7)+":"+
			    rsexportedkeys.getString(8)+" ");
	    }
	    rsexportedkeys.close();
	  }
	  strbuf.append("\n\n");
	}
	rstable.close();
	tableInfo = strbuf.toString();
	dg.out(tableInfo);
      }
    } catch (Exception ex){
      dg.out("Get Table Info ERROR\n" +ex.getMessage());
      tableInfo = null;
    }
  }

  void execQuery(String label, String str){
    if(label.equals("SQL")){
      sqlQuery(str);
    } else if(label.equals("Mode")){
      setModes(str);
    } else if(label.equals("Parameter")){
      setSets(str);
    } else {
      dg.out(label+"ERROR Illegal Label\n");
    }
  }

  void setModes(String str){
    try{
      SPPredicate pred = new SPPredicate(dg.sp,"setModes",2,"");

      SPTerm term1 = new SPTerm(dg.sp).putObject(dg);
      SPTerm term2 = new SPTerm(dg.sp,str);

      if(!dg.sp.query(pred, new SPTerm[]{term1, term2})){
	SPPredicate pred1 = new SPPredicate(dg.sp,"init_modes",0,"");
	dg.sp.query(pred1, new SPTerm[]{});
	dg.out("Mode Set Failed \n");
      }else
	dg.out("Mode Set .. done\n");
    }catch (Exception ex){
      ex.printStackTrace();
      dg.out("setModes ERROR\n"+ex.getMessage());
    }
  }

  void setSets(String str){
    try{
      SPPredicate pred = new SPPredicate(dg.sp,"setSets",2,"");

      SPTerm term1 = new SPTerm(dg.sp).putObject(dg);
      SPTerm term2 = new SPTerm(dg.sp,str);

      if(!dg.sp.query(pred, new SPTerm[]{term1,term2})){
	SPPredicate pred1 = new SPPredicate(dg.sp,"init_sets",0,"");
	dg.sp.query(pred1, new SPTerm[]{});
	dg.out("Parameter Set Failed \n");
      }else
	dg.out("Parameter Set .. done\n");
    }catch (Exception ex){
      dg.out("setSets ERROR\n"+ex.getMessage());
    }
  }


  void sqlQuery(String str){
    try{
      if(!dg.isConnected()){
	dg.out("Not Connected\n");
      } else {
	Statement stmt = dg.con.createStatement();
	ResultSet rs = stmt.executeQuery(str);
	String Output = getResultSetContents(rs);
	dg.out(Output);
	rs.close();
	stmt.close();
      }
    }catch (Exception ex){
      dg.out("Sql Query ERROR\n" +ex.getMessage());
    }
  }


  String getResultSetContents(ResultSet rs){
    try{
      int i;
      StringBuffer strbuf = new StringBuffer();
      ResultSetMetaData rsMData = rs.getMetaData();
      int column = rsMData.getColumnCount();
      int[] displaySizes = new int[column];
      boolean[] numbers = new boolean[column];
      for(i=0; i < column; i++){
	displaySizes[i] = rsMData.getColumnDisplaySize(i+1);
	numbers[i] = isNumber(rsMData.getColumnType(i+1));

	String str = getDisplayString(rsMData.getColumnName(i+1),
				      displaySizes[i],
				      numbers[i]);
	strbuf.append(str + " ");
      }

      strbuf.setCharAt(strbuf.length()-1, '\n');
      strbuf.append(getSeparator(displaySizes));

      while(rs.next()){
	for(i=0;i < column; i++){
	  String str1 = getDisplayString(rs.getString(i+1),
					 displaySizes[i],
					 numbers[i]);
	  strbuf.append(str1 + " ");
	}
	strbuf.setCharAt(strbuf.length()-1, '\n');
      }

      return strbuf.toString();
    } catch(Exception ex){
      dg.out("GetResultSetContents ERROR\n"+ex.getMessage());
      return null;
    }
  }

  boolean isNumber(int type) {
    boolean number = false;
    switch(type){
    case Types.BIGINT:
    case Types.DECIMAL:
    case Types.DOUBLE:
    case Types.FLOAT:
    case Types.INTEGER:
    case Types.NUMERIC:
    case Types.REAL:
    case Types.SMALLINT:
    case Types.TINYINT:
      number = true;
      break;
    default:
      number = false;
      break;
    }

    return number;
  }

  String getDisplayString(String str, int s){
    return getDisplayString(str, s, false);
  }

  String getDisplayString(String str, int s, boolean number){
    int i;
    if(str == null){
      str = " ";
    }

    StringBuffer strbuf = new StringBuffer(str.replace('\n',' '));
    
    int blanks = s-str.length();
    blanks = blanks > 0 ? blanks:0;
    StringBuffer strbuf2 = new StringBuffer();
    for (i=0; i < blanks;i++){
      strbuf2.append(" ");
    }

    if(number){
      strbuf.insert(0,strbuf2.toString());
    } else {
      strbuf.append(strbuf2.toString());
    }

    strbuf.setLength(s);
    return strbuf.toString();
  }

  String getSeparator(int[] sizes){
    StringBuffer strbuf = new StringBuffer();
    int i,j;
    int c = sizes.length;
    
    for(i=0;i<c;i++){
      for(j=0;j<sizes[i];j++){
	strbuf.append("-");
      }
      strbuf.append(" ");
    }
    strbuf.setCharAt(strbuf.length() -1, '\n');
    return strbuf.toString();
  }
}
