%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
%util.pl

%FOR BUILT-IN TYPE
any(_).

'$append'([],Y,Y).
'$append'([W|X], Y, [W|Z]):- '$append'(X,Y,Z).

'$reverse'(X,Y):- '$rev'(X,[],Y).
'$rev'([],Y,Y).
'$rev'([W|X], Y, Z):- '$rev'(X,[W|Y],Z).

'$member'(H, [H|_T]).
'$member'(H, [_|T]):- '$member'(H,T).

'$name_concat'(NameList, NewName):-
	'$name_concat1'(NameList, S), name(NewName, S).

'$name_concat1'([],[]).
'$name_concat1'([H|T],S):-
	name(H,SH), 
	'$append'(SH,ST,S),
	'$name_concat1'(T,ST).

'$select'([H|T],H,T).
'$select'([H|T],W,[H|T1]):- '$select'(T,W,T1).

'$length'([],0).
'$length'([_H|T],L):- '$length'(T,L1), L is L1+1.

'$listtoconj'([H],(H)).
'$listtoconj'([H|T],(H,TC)):-
	'$listtoconj'(T,TC).

'$conjapp'((W,X),Y,(W,Z)):- '$conjapp'(X,Y,Z).
'$conjapp'((X),Y,(X,Y)).

'$writeMSH'([H]):-!,
	format('~n~w.',[H]).

'$writeMSH'([H|T]):-
	format('~n~w:-',[H]),
	'$writeMSHBody'(0,T).

'$writeMSHBody'(N, [H]):-!,
	'$writeBlank'(N),
	format('~w.',[H]).
'$writeMSHBody'(N, [H|T]):-
	'$writeBlank'(N),	
	format('~w, ',[H]),
	N1 is N+1,
	'$writeMSHBody'(N1,T).


'$writeHyp'((H,T)):-!,
	format('~n~w:-',[H]),
	'$writeHypBody'(0,T).
'$writeHyp'(H):-
	format('~n~w.',[H]).

'$writeHypBody'(N, (H,T)):-!,
	'$writeBlank'(N),	
	format('~w, ',[H]),
	N1 is N+1,
	'$writeHypBody'(N1,T).

'$writeHypBody'(N, H):-
	'$writeBlank'(N),
	format('~w.',[H]).

'$writeBlank'(N):- 
	0 =:= N mod 3,!,
	format( '~n     ',[]).
'$writeBlank'(_N).

'$print_err'([]).
'$print_err'([H|T]):-
	format(user_output, '~w. Error~n', [H]),
	'$print_err'(T).
