%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
% search.pl


'$search'(PosList, NegList, MSH, Result):-
	'$gen_path'(MSH,Path),!,
	findall(IC, '$$ic'(IC),ICList),
	'$astar'(Path, PosList, NegList,ICList,Result).


:- dynamic '$$path'/2. %'$$path'(Term, Length).

'$gen_path'([[_No,_Ins,_Mode,_Pt,[]]|_MSHBody], []). %No -type
'$gen_path'([[_No,_Ins,_Mode,Pt,Mt]|MSHBody], Path_set):- 

	(clause('$$path'(_,_),true)-> abolish('$$path'/2);true),

        '$regist_var'(Mt,1), 	
        '$reverse'(MSHBody,MSHr),!,
	'$$set'(c,CLim), 
	'$choice'(MSHr, CLim, [],Selected),!, 
        (clause('$$path'(_,_),true)-> abolish('$$path'/2);true),
        '$regist_paths'(Pt,[]), %+type
	'$path'(Selected, CLim),!,

	'$gen_path3'(Mt,CLim, Path_set).


'$gen_path3'(Mt, CLim, Path_set):-
	'$get_path'(Mt,MPath),
	'$union_path'(MPath,CLim,MUnion), !,
	(MUnion=[] -> Path_set=fail; '$path_sort'(MUnion,Path_set)).
'$gen_path3'(_Mt, _CLim, fail).



'$regist_var'([],_).
'$regist_var'([H|T],D):-
	clause('$$path'(H, Dep),true),!,
	(Dep > D -> (retract('$$path'(H,Dep)), assertz('$$path'(H,D)))
    ;true),
	'$regist_var'(T,D).
'$regist_var'([H|T],D):-	
	assertz('$$path'(H,D)),'$regist_var'(T,D).

%choice(MSH,CLim,[],Selected).
%MSH = [[Index, Ins, Mode,Pt,Mt]...]

'$choice'([],_C, S,S).
'$choice'([[_Index,_Ins,_Mode,_Pt,[]]|MSH],C,S,Sz):-!, 
	'$choice'(MSH,C,S,Sz).
'$choice'([[Index, _Ins, _Mode, Pt,Mt]|MSH], C, S,Sz):-
	'$check_var'(Mt,MVar),
	'$choice1'([Index,Pt,MVar],MSH,C,S,Sz).


'$choice1'([_Index,_Pt,[]], MSH, C, S,Sz):-!, 
	'$choice'(MSH,C,S,Sz).
'$choice1'([Index,Pt,MVar], MSH, C, S,Sz):-
	'$min_depth'(MVar,Min),
	'$choice2'(Min, [Index,Pt,MVar], MSH, C, S,Sz).

'$choice2'(Min, _IndexPtMVar, MSH, C, S,Sz):-
	Min > C,!,
	'$choice'(MSH,C,S,Sz).
'$choice2'(Min, [Index,Pt,MVar], MSH, C, S,Sz):-
	Min1 is Min+1,
	'$regist_var'(Pt,Min1), 
	'$choice'(MSH,C, [[Index,Pt,MVar]|S],Sz).


%check_var(Mt,  MVar)
'$check_var'([],[]).
'$check_var'([H|T], [(H,Dep)|T1]):-
	clause('$$path'(H,Dep),true),!,
	'$check_var'(T,T1).
'$check_var'([_|T],T1):- '$check_var'(T,T1).

'$min_depth'([(_H,D)],D):-!.
'$min_depth'([(_H,D)|T],MIN):- '$min_depth'(T,D,MIN).
'$min_depth'([],Min,Min).
'$min_depth'([(_,D)|T], Tmp, Min):- D<Tmp,!,'$min_depth'(T,D,Min).
'$min_depth'([_|T], Tmp,Min):- '$min_depth'(T,Tmp,Min).

%regist_paths(Pt,X).
'$regist_paths'([],_).
'$regist_paths'([H|T],X):-
	'$regist_path'(H,X),
	'$regist_paths'(T,X).

'$regist_path'(H,X):-clause('$$path'(H,X),true),!.
'$regist_path'(H,X):-assertz('$$path'(H,X)).


%path(Selected, CLim).
'$path'([], _C).
'$path'([[No,Plus,Minus]|T], C):-
	'$get_path'(Plus,PP),!, 	
	'$union_path'(PP,C,MUnion), 	
	'$assert_path'(Minus, MUnion, No),
	'$path'(T, C).
'$path'([_|T],C):-'$path'(T,C).

%get_path(+type_List,  -Res,-Res).
'$get_path'([],[]).
'$get_path'([H|T],[HR|TR]):-!,
	setof(Path, '$$path'(H,Path), HR),
	'$get_path'(T,TR).

%union_path(ListOfList, CLim, Result)
'$union_path'(H,C,Union):-
	'$union_path1'(H,C,Tmp),
	'$putLen'(Tmp,C,Union).

'$putLen'([],_C,[]).
'$putLen'([H|T],C,[(H,Rest)|TR]):-
	'$length'(H,HL),
	Rest is C-HL,
	'$putLen'(T,C,TR).


'$union_path1'([H],_C,H):-!.
'$union_path1'([H,H1|T],C, Res):- 
	'$union_path2'(H,H1,C,HNew,[]), 
	(HNew = [] -> Res = [];
	    '$union_path1'([HNew|T],C,Res)).

'$union_path2'([],_O, _C, R,R).
'$union_path2'([H|T],O,C, R,Rz):-
	'$union_path3'(H,O,C, R,Rm), 
	'$union_path2'(T,O,C, Rm,Rz).

'$union_path3'(_H,[],_C, R,R).
'$union_path3'(H,[O|T],C,R,Rz):- 
	('$union_path4'(H,O,C, UNION) ->
	    (R=[UNION|Rm],'$union_path3'(H,T,C,Rm,Rz))
	;'$union_path3'(H,T,C,R,Rz)
    ).



'$union_path4'(_,_,-1, _R):-!,fail. 
'$union_path4'([],O, C, O):- '$length'(O,OL),!,C-OL >=0.
'$union_path4'(H,[], C, H):- '$length'(H,HL),!,C-HL >=0.
'$union_path4'([W|H],[W|O],C,  [W|R]):- !,C1 is C-1,
	'$union_path4'(H,O,C1, R).
'$union_path4'([W|H],[Z|O],C,  [W|R]):-W>Z,!,C1 is C-1, 
	'$union_path4'(H,[Z|O],C1, R).
'$union_path4'([W|H],[Z|O],C,  [Z|R]):- C1 is C-1,
	'$union_path4'([W|H],O,C1, R).


%assert_path(Minus, MUnion, No),
'$assert_path'([], _MUnion,  _No).
'$assert_path'([H|Minus], MUnion, No):-
	'$assert_path1'(MUnion, H, No),
	'$assert_path'(Minus,MUnion, No).

'$assert_path1'([],_H,_No). 
'$assert_path1'([(Path,Rest)|Union], (Minus,D), No):-
	Rest-D >=0,!,
	'$regist_path'(Minus,[No|Path]),
	'$assert_path1'(Union, (Minus,D), No).
'$assert_path1'([_|Union], Minus, No):-
	'$assert_path1'(Union, Minus, No).

'$path_sort'([X],[X]):-!.
'$path_sort'(X,Y):- '$div'(X,Part1,Part2),
	'$path_sort'(Part1,S1), '$path_sort'(Part2,S2),
	'$path_merge'(S1,S2,Y).
'$div'([],[],[]).
'$div'([H|T],[H|PT],P2):- '$div'(T,P2,PT).

'$path_merge'([],S,S).
'$path_merge'(S,[],S).

'$path_merge'([(P1,L1)|T1], [(P2,L2)|T2], [(P1,L1)|Y]):-L1>L2,!,
	'$path_merge'(T1,[(P2,L2)|T2],Y).
'$path_merge'([L1|T1], [L2|T2],[L2|Y]):-'$path_merge'([L1|T1],T2,Y).


:- dynamic '$$bestpass'/1.
:- dynamic '$$best'/2.
:- dynamic '$$change'/1.

'$astar'(fail, [Pos|_], _Neg, _IC, Pos):-!, 
	'$$msh'(0, Pos, _Mode, _Pt, _Mt).

'$astar'(Path, [Pos|PosList], NegList,ICList, Result):-
	'$astar_init',
	'$$set'(nodes,Nodes),
	'$gen_init_hyp'(Path,Init),
	'$evalInitHyp'(Init,InitHyp,[Pos|PosList],NegList,ICList,Nodes,NNodes),

	(\+(InitHyp=[]) ->
	    ('$s_sort'(InitHyp,Sorted),
	    Sorted = [h(Cost,[_K,_Th,Hyp|_])|_Rest],
	    assert('$$best'(Cost,Hyp)),
	    '$astarSearch'(NNodes, Sorted, [Pos|PosList],NegList,ICList))
	;true),!,
	'$astar_result'(Pos,Result).

'$astar_init':-
	(clause('$$bestpass'(_),true)->abolish('$$bestpass'/1);true),
	(clause('$$best'(_,_),true)-> abolish('$$best'/2);true),
	(clause('$$change'(_),true)-> abolish('$$change'/1);true),
	assert('$$change'(false)), 
	assert('$$bestpass'(0)).

%% astar_result
'$astar_result'(_Pos, Result):-
	clause('$$best'(Cost,Result),true),
	'$rpass'(Cost).
'$astar_result'(Pos, Pos):-!,
	'$$msh'(0, Pos, _Mode, _Pt, _Mt).
	

%%%%%
%gen_init_hyp(Path,Init).
'$gen_init_hyp'([],Init):-!, 
	'$$msh'(0,Ins,Mode, _Pt, _Mt),
	findall([0,Th,[Hyp],[]],
	'$refine'(head,Ins,Mode,[],Hyp,Th), 
	Init).

'$gen_init_hyp'(Path,Init):- '$genInitHyp'(Path,Init).

'$genInitHyp'([],[]).
'$genInitHyp'([(Path, Len)|T],Hyp):-
	'$genInitHyp'(T,HypT),
	'$makeHyp'(Path,[], Ins, [],Mode, [],Mt),  
	'$$set'(c,CLim), C is CLim-Len,
	'$genInitHyp'(C, Path, Ins, Mode, Mt, HypH),
	'$append'(HypH,HypT,Hyp).

'$makeHyp'([], TIns, [Ins|TIns], TMode, [Mode|TMode],TMt, [Mt|TMt]):- 
	'$$msh'(0,Ins,Mode,_Pt,Mt).
'$makeHyp'([No|R], TIns, InsR,  TMode, ModeR, TMt, MtR):-
	'$$msh'(No,Ins,Mode,_Pt,Mt),
	'$makeHyp'(R, [Ins|TIns], InsR, [Mode|TMode], ModeR, [Mt|TMt],MtR).




'$genInitHyp'(Len,Path, [Ins|InsR], [Mode|ModeR],[_Mt|MtR],HypH):-
	'$getBind'(Ins,Mode, NewMode, MtR),
	findall([Len,Th,[Head|Body],Path],
	     ('$hrefine'(Ins,NewMode,[],Head, Thm, [], MType),
	      '$brefine'(InsR, ModeR, Thm, Body, Th, MType,[])),
	      HypH).

%getBind(Ins,Mode, NewMode, MtR)
'$getBind'(_,+, +, _):-!.
'$getBind'(I,-, '$new', MtR):- '$in'(I,MtR),!.
'$getBind'(_I,-, '$same', _MtR):-!.
'$getBind'(_I,#,#, _):-!.
'$getBind'([], _, [], _):-!.
'$getBind'([H|T], [MH|MT], [NMH|NMT], MtR):-!,
	'$getBind'(H,MH,NMH,MtR),
	'$getBind'(T,MT,NMT,MtR).
'$getBind'(I,M,M, _):- functor(I,_,0),!.
'$getBind'(I,M,NM, MtR):-
	I=..[F|IA],
	M=..[F|IM],
	'$getBind'(IA,IM,NIM,MtR),
	NM=..[F|NIM].

'$in'(I,[Mt|_MtR]):- '$in2'(I,Mt).
'$in'(I,[_|MtR]):- '$in'(I,MtR).
'$in2'(I,[X|_]):-X=..[_,I].
'$in2'(I,[_|T]):-'$in2'(I,T).


%hrefine(Ins, Mode, Th, Hyp, NewTh, MTypeList,MTypeList)
'$hrefine'(I, +, Th, X, [X/I|Th], M,M):- var(X).
'$hrefine'(I, +, Th, L, Th, M,M):- !,'$refine_mem'(I,Th,L).
'$hrefine'(I, #, Th, I, Th, M,M):- !.
'$hrefine'(I, '$same', Th, L, Th, M,M):- !,'$refine_mem'(I,Th,L).
'$hrefine'(I, '$new', Th, L,  Th, M,M):-'$refine_mem'(I,M,L).
'$hrefine'(I, '$new', Th, X,  [X/I|Th], M,[X/I|M]):-!,var(X).
'$hrefine'([],_,Th, [],Th, M,M):-!.
'$hrefine'([I|IT],[T|TT],Th,[L|LT],NT, M,Mz):-!,
	'$hrefine'(I,  T,  Th,  L, NT1, M,Mm), 
	'$hrefine'(IT,TT, NT1, LT, NT,  Mm,Mz).
'$hrefine'(X, _X, Th, X,Th, M,M):-functor(X,_,0),!.
'$hrefine'(I, T, Th, L, NTh, M,Mz):-
	I=..[F|AI],
	T=..[F|AT],
	'$hrefine'(AI,AT,Th,AL,NTh, M,Mz),
	L=..[F|AL].

'$brefine'(I, +, Th, L, Th, M,M):- !,'$refine_mem'(I,Th,L).
'$brefine'(I, #, Th, I, Th, M,M):- !.
'$brefine'(I, -, Th, L, Th, M,Mz):- '$refine_del'(I,M,L,Mz).
'$brefine'(I, -, Th, L, Th, M,M):- '$refine_mem'(I,Th,L).
'$brefine'(I, -, Th, X, [X/I|Th], M,M):-!,var(X).
'$brefine'([],_, Th, [], Th, M,M):-!.
'$brefine'([I|IT],[T|TT],Th,[L|LT],NT, M,Mz):-!,
	'$brefine'(I,  T,  Th,  L, NT1, M,Mm), 
	'$brefine'(IT,TT, NT1, LT, NT,  Mm,Mz).
'$brefine'(X, _X, Th, X,Th, M,M):-functor(X,_,0),!.
'$brefine'(I, T, Th, L, NTh, M,Mz):- \+(I=[]),
	I=..[F|AI],
	T=..[F|AT],
	'$brefine'(AI,AT,Th,AL,NTh, M,Mz),
	L=..[F|AL].

%refine_del(I,M,L,Mz):-
'$refine_del'(I,[L/X|T], L, T):- X==I.
'$refine_del'(I,[H|T],   L, [H|T1]):-
	'$refine_del'(I,T,L,T1).

%%%%%
%evalInitHyp(Init,InitHyp, [Pos|PosList],NegList, Nodes, NNodes),

'$evalInitHyp'([], [], _P,_N,_IC, No,No).
'$evalInitHyp'(_,  [], _P,_N,_IC, No,No):- No<0.
'$evalInitHyp'([[C,TH,Hyp,Path]|Init],InitHyp, Pos,Neg,IC, Nodes,NNodes):-
	Nodes1 is Nodes-1,
	'$toConj'(Hyp,CHyp),
	('$calc_cost'(Pos,Neg,IC, CHyp, C, Costs)->
	    (InitHyp=[h(Costs,[0,TH,CHyp,Path])|InitHypz],
	    '$evalInitHyp'(Init,InitHypz, Pos,Neg,IC,Nodes1,NNodes))
	;'$evalInitHyp'(Init,InitHyp, Pos,Neg,IC, Nodes1,NNodes)).
'$toConj'([H],H).
'$toConj'([H|B],(H:-Bconj)):-
	'$listtoconj'(B,Bconj).



'$astarSearch'(Nodes,  [], _P, _N, _IC):-
	'$$set'(nodes,N),
	NN1 is N-Nodes,
	format('~n~d Hypotheses are tested~n',[NN1]).

'$astarSearch'(Nodes, _Hyp, _p, _N, _IC):-Nodes<0,!,
	format('Resource Limit.~n',[]).
'$astarSearch'(Nodes,[h(Cost,[_K,_Th,Hyp,_Path])|Open],Pos,Neg,IC):-
	'$prune'(Cost),!,
	('$rbetter'(Cost)->
	    ('$$best'(A,B),retract('$$best'(A,B)),
	    abolish('$$change'/1),assert('$$change'(true)),
	    assert('$$best'(Cost,Hyp)))
	;true),
	('$noNeed' ->
	    '$astarSearch'(Nodes,Open,Pos,Neg,IC)
	;('$terminated'(Open,NewOpen),
	'$astarSearch'(Nodes,NewOpen,Pos,Neg,IC))).

'$astarSearch'(Nodes, [Best|Open], Pos,Neg,IC):-
	'$expand'(Best,Nodes, Pos,Neg,IC, (NNodes,Res)),
	'$s_sort'(Res,Res1),
	'$merge'(Res1,Open,Open1),
	('$noNeed' ->
	    '$astarSearch'(NNodes,Open1,Pos,Neg,IC)
	;('$terminated'(Open1,NewOpen),
	'$astarSearch'(NNodes,NewOpen,Pos,Neg,IC))).


'$merge'([],X,X).
'$merge'(X,[],X).
'$merge'([X|T],[Y|T1], [X|TT]):-
	'$scomp'(X,Y),!,'$merge'(T,[Y|T1],TT).
'$merge'( XT,  [Y|T1], [Y|TT]):-
	'$merge'(XT,T1,TT).

'$s_sort'([],[]):-!.
'$s_sort'([X],[X]):-!.
'$s_sort'(X,Y):-'$div'(X,Part1,Part2), 
	'$s_sort'(Part1,S1),'$s_sort'(Part2,S2),
	'$s_merge'(S1,S2,Y).

'$s_merge'([],S,S).
'$s_merge'(S,[],S).
'$s_merge'([L|X],[R|Y], [L|Z]):-
	'$scomp'(L,R),!,'$s_merge'(X,[R|Y],Z).
'$s_merge'(X, [R|Y], [R|Z]):-
	'$s_merge'(X,Y,Z).

%[G,F,P,N,C,IC]
'$scomp'(h([G|_], _), h([G1|_], _)):- G>G1.
'$scomp'(h([G,F|_], _), h([G,F1|_], _)):- F>F1.

%PRUNE [G,F,P,N,C,IC]
'$prune'([_,_,_,0,_,_]). %N=0.
'$prune'([G,_,_,_,_,_]):- G<0.
'$prune'([_,_,_,_,C,_]):- '$$set'(c,CLim),C>=CLim.

%rpass
'$rpass'([_G,F,P,N,_C,0]):-%IC=0
	T is 100*N, '$$set'(noise,NLim),T1 is(P+N)*NLim,!,
	T =< T1, F>0.5.

'$rbetter'([G,F,P,N,C,IC]):-
	clause('$$best'([Gb,Fb,Pb,Nb,Cb,ICb],_), true),!,
	(F>Fb; ('$rpass'([G,F,P,N,C,IC]), \+('$rpass'([Gb,Fb,Pb,Nb,Cb,ICb])))).



%terminatedNeed

'$noNeed':- '$$change'(false).
'$noNeed':- clause('$$best'(Cost,_),true), \+('$rpass'(Cost)),
	abolish('$$change'/1), assert('$$change'(false)).

'$terminated'(X,Y):-
	'$$best'([_,F|_],_),'$terminated'(F,X,Y),
	abolish('$$change'/1), assert('$$change'(false)).

'$terminated'(_F, [], []).
'$terminated'(F, [h([G|_],_)|T], TR):- F>=G,!,
	'$terminated'(F,T,TR).
'$terminated'(F, [H|T],[H|TR]):- '$terminated'(F,T,TR).


%refinement OP
'$refine'(head,I, +, Th, X, [X/I|Th]):- var(X).
'$refine'(_, I, +, Th, L, Th):- !,'$refine_mem'(I,Th,L).
'$refine'(_, I, #, Th, I, Th):- !.
'$refine'(_, I, -, Th, L, Th):- '$refine_mem'(I,Th,L).
'$refine'(_, I, -, Th, X, [X/I|Th]):-!,var(X).
'$refine'(_, [],_,Th, [],Th):-!.
'$refine'(HB, [I|IT],[T|TT],Th,[L|LT],NT):-!,
	'$refine'(HB, I,T,Th,L,NT1), '$refine'(HB, IT,TT,NT1,LT,NT).
'$refine'(_, X, _X, Th, X,Th):-functor(X,_,0),!.
'$refine'(HB, I, T, Th, L, NTh):-
	I=..[F|AI],
	T=..[F|AT],
	'$refine'(HB, AI,AT,Th,AL,NTh),
	L=..[F|AL].

'$refine_mem'(I,[L/X|_],L):- X==I.
'$refine_mem'(I,[_|T],L):- '$refine_mem'(I,T,L).


%%%%%%%
%expand(Best,Nodes, Pos,Neg,IC, (NNodes,Res)),

'$expand'(h([G,F,P,N,C,ICCost], [K,Th,Hyp,Path]), Node, Pos,Neg,IC, Result):-
	'$getBody'(K, Path, Th, NK, Bodies), 
	NC is C+1,
	'$expand1'(Pos,Neg,IC, Bodies, Hyp, NC, NK, Path, Res, Node, No),

	Result=(No, [h([G,F,P,N,C,ICCost],[NK,Th,Hyp,Path])|Res]).

'$expand'(_Hyp, Node, _Pos,_Neg,_IC, (Node,[])).


'$getBody'(K, Path, Th, NK, Bodies):-
	'$getK'(K, Path, NK, Lit, Mode),
	setof([NLit,NTh], 
	'$refine'(body,Lit,Mode,Th,NLit,NTh),
	Bodies).


'$getK'(K, Path, NK, Lit, Mode):-
	NK is K+1, \+('$member'(NK, Path)), '$$msh'(NK, Lit,Mode, _,_).
'$getK'(K, Path, NK, Lit, Mode):-
	K1 is K+1, '$$msh'(K1,_,_,_,_),
	'$getK'(K1, Path,NK,Lit,Mode).


%BODIES = [[NewLiteral, NewTh]...]
'$expand1'(_Pos,_Neg,_IC, [], _Hyp, _C, _K, _Path, [], Node,Node).

'$expand1'(Pos,Neg,IC, [[Lit,Th]|T], Hyp, C,K, Path, Result, Node,Nodez):-
	Node > 0,
	Node1 is Node-1,

	'$hyp_append'(Hyp,Lit,NHyp),

	('$calc_cost'(Pos, Neg,IC, NHyp, C,Costs)->
	 (Result = [h(Costs,[K,Th,NHyp,Path])|Rest],
	  '$expand1'(Pos,Neg,IC,T,Hyp,C,K,Path,Rest,Node1,Nodez))
	;'$expand1'(Pos,Neg,IC, T, Hyp, C,K,Path,Result,Node1,Nodez)).

'$expand1'(_Pos,_Neg,_IC, _Hyp, _C, _K, _Path, [], No,No):- No<0.

'$hyp_append'((H:-T),Lit,(H:-NT)):-'$conjapp'(T,Lit,NT).
'$hyp_append'(H,Lit,(H:-Lit)).

'$hyp_append'(K,(H:-T),Lit,(H:-NT),P,NP):-
	'$hyp_append2'(K,T,Lit,NT,P,NP).
'$hyp_append'(K,H,Lit,(H:-Lit), P,NP):-'$append'(P,K,NP).

'$hyp_append2'(K,Body,Lit,(Body,Lit),[P],[P,K]):-K>P.
'$hyp_append2'(K,Body,Lit,(Lit,Body),[P],[K,P]):-K<P.
'$hyp_append2'(K,(B,Bt),Lit,(B,BtN), [P|Pt], [P|NPt]):- K>P,!,
	'$hyp_append2'(K,Bt,Lit,BtN,Pt,NPt).
'$hyp_append2'(K,Body,Lit,(Lit,Body), Path, [K|Path]).


'$calc_cost'([EX|Pos],Neg, IC, Head, C, [G,F,P,N,C,ICNo]):-
	\+(Head = (_:-_)),!,
	\+(\+((
	       numbervars(Head,0,_),
	       '$writeHyp'(Head)
	   ))),
	'$$set'(h,Depth),
	'$hentailed_ex'(pos,[EX], Head,Depth, 0, 1),
	
	'$hentailed_ex'(pos,Pos,  Head,Depth, 0, PCost), P is PCost+1,
	format('  P=~d',[P]),
	G is P-C,!,
	clause('$$bestpass'(Bestpass),true),
	G > Bestpass,

	'$hentailed_ex'(neg,Neg, Head, Depth,0, NCost),
	'$hentailed_ex'(ic, IC,  Head, Depth,0, ICNo), ICCost is ICNo*100,
	N is NCost+ICCost,
	F is G-N,
	format(',N=~d',[NCost]),
	((Bestpass < F, '$rpass'([G,F,P,N,C,ICNo]))->
	    (retract('$$bestpass'(Bestpass)),assert('$$bestpass'(F)))
	;true).

'$calc_cost'([EX|Pos],Neg, IC, Hyp, C, [G,F,P,N,C,ICNo]):-
	\+(\+((
	       numbervars(Hyp,0,_),
	       '$writeHyp'(Hyp)
	   ))),
        '$$set'(h,Depth),
	asserta(Hyp),
	('$entailed_ex'(pos,[EX], Depth, 0,1); (retract(Hyp),!,fail)),
	'$entailed_ex'(pos,Pos, Depth, 0,PCost), P is PCost+1,
	format('  P=~d',[P]),
	G is P-C,!,
	clause('$$bestpass'(Bestpass),true),
	(G > Bestpass; (retract(Hyp),!,fail)),
	'$entailed_ex'(neg, Neg, Depth, 0, NCost),
	'$entailed_ex'(ic,  IC,  Depth, 0, ICNo), ICCost is ICNo*100,
	retract(Hyp),
	N is NCost+ICCost,
	F is G-N,
	format(',N=~d',[NCost]),
	((Bestpass < F, '$rpass'([G,F,P,N,C,ICNo])) ->
	    (retract('$$bestpass'(Bestpass)),assert('$$bestpass'(F)))
	;true).

'$hentailed_ex'(_X, [], _Cls,_D,No,No).
'$hentailed_ex'(X,[P|Rest],Cls, Depth, No,Noz):-
	\+(X=ic),
	functor(P,F,A),functor(Cls,F,A),!,
	(\+(\+((P=Cls)))->
	 Nom is No+1; Nom is No),
	'$hentailed_ex'(X,Rest,Cls,Depth,Nom,Noz).

'$hentailed_ex'(X,[P|Rest],Cls, Depth, No,Noz):-
	'$hentailed_ex1'(X,P,Cls,Depth,No,Nom),
	'$hentailed_ex'(X,Rest,Cls,Depth,Nom,Noz).
	

'$hentailed_ex1'(pos, H, Cls, Depth, No,Noz):-
	asserta(Cls),
	('$pos_eval'(H,Depth)->Noz is No+1;Noz is No),
	retract(Cls).

'$hentailed_ex1'(_,H, Cls, Depth, No,Noz):- 
	asserta(Cls),
	('$eval'(H, Depth)-> Noz is No+1;Noz is No),
	retract(Cls).


'$entailed_ex'(_, [], _D, No,No).
'$entailed_ex'(pos, [H|T], Depth, No,Noz):-
	('$pos_eval'(H,Depth)-> No1 is No+1;No1 is No),
	'$entailed_ex'(pos,T,Depth,No1,Noz).

'$entailed_ex'(neg,[H|T], Depth, No,Noz):-
	('$eval'(H, Depth)->No1 is No+1;No1 is No),
	'$entailed_ex'(neg,T,Depth,No1,Noz).

'$entailed_ex'(ic,[H|T], Depth, No,Noz):-
	('$eval'(H, Depth)->No1 is No+1;No1 is No),
	'$entailed_ex'(ic,T,Depth,No1,Noz).

