%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
% parser.pl


:- dynamic '$$set'/2.  %set(Arg,Value). Arg = {h,i,c,noise,nodes}
:- dynamic '$$modeh'/4. %modeh(Lit,[+,-,#], Lit(+,-,#), Lit(Var)
:- dynamic '$$modeb'/4. %modeh(Lit,[+,-,#], Lit(+,-,#), Lit(Var)
:- dynamic '$$observable'/2. %Observable(ObservablePred,Target).
:- dynamic '$$ic'/1.  %Integrity Constraint '*ic'((:-hoge,hoge,,)).
:- dynamic '$$determination'/2. %determination(Pred/Arity, Pred/Arity).
:- dynamic '$$commutative'/1.  %commutative(Pred/Arity).
:- dynamic '$$neg'/1.

'$parse'(File):-
	'$parse_init',
	'$name_concat'([File, '.pl'], InF),!,
	on_exception(_, see(InF), 
	('$name_concat'([InF,' Not Found '],Err),
	 '$print_err'([Err]),!,fail)),
	'$readCls'(InF).

'$parse_init':-
	(clause('$$set'(_,_),true)->abolish('$$set'/2);true),
	(clause('$$modeh'(_,_,_,_),true)->abolish('$$modeh'/4);true),
	(clause('$$modeb'(_,_,_,_),true)->abolish('$$modeb'/4);true),
	(clause('$$neg'(_),true)->retractall('$$neg'(_));true),
	(clause('$$ic'(_),true)->retractall('$$ic'(_));true),
	(clause('$$observable'(_,_),true)->
	 retractall('$$observable'/(_,_));true),
	(clause('$$determination'(_,_),true)->
	 retractall('$$determination'(_,_));true),
	(clause('$$commutative'(_),true)->
	 retractall('$$commutative'(_));true),

	asserta('$$set'(c,4)),
	asserta('$$set'(i,3)),
	asserta('$$set'(h,100)),
	asserta('$$set'(noise,0)),
	asserta('$$set'(nodes,10000)).

'$readCls'(File):-
	read(X) -> '$scan'(X, [File]).

'$scan'(end_of_file, [_H]):- seen.
'$scan'(end_of_file, [_H,File|InF]):- 
	seen,
	see(File),
	'$readCls'([File|InF]).

'$scan'((:-[File]), InF):-
	'$name_concat'([File, '.pl'], NInF),
	see(NInF), read(X) -> '$scan'(X, [NInF|InF]).

'$scan'(X, InF):-
	'$scan1'(X), read(Y) -> '$scan'(Y,InF).

'$scan1'((:-H, T)):- ic((:-H,T)).
%'$scan1'((:-H, T)):-!, '$scan1'((:-H)), '$scan1'((:-T)).
'$scan1'((:-H)):- predicate_property(H, built_in),!,call(H).
'$scan1'((:-H)):- '$dg_built_in'(H),!,call(H).

'$scan1'((H,T)):- '$scan1'(H), '$scan1'(T).
'$scan1'((:-Neg)):- ground(Neg),!,assertz('$$neg'(Neg)).
'$scan1'((:-IC)):- ic((:-IC)).
'$scan1'(EX_BK):- assertz(EX_BK).

'$notCommand'((H,T)):- \+(predicate_property(H,built_in)),
	\+('$dg_built_in'(H)),
	'$notCommand'(T).
'$notCommand'(H):- \+(predicate_property(H,built_in)),
	\+('$dg_built_in'(H)).

'$dg_built_in'(modeh(_)).
'$dg_built_in'(modeb(_)).
'$dg_built_in'(set(_,_)).
'$dg_built_in'(commutative(_/_)).
'$dg_built_in'(determination(_/_,_/_)).
'$dg_built_in'(ic(_)).
'$dg_built_in'(observable(_/_)).
'$dg_built_in'(observable(_/_,_/_)).

%%% COMMANDS
generalise(Pred/Arity):-
	functor(Var,Pred,Arity),
	'$$modeh'(O,PMS,Mode,Var),!,
	(clause('**hyp'(_),true)->abolish('**hyp'/1);true),
	'$learn_prepare'(Mode,Pos,Neg),
	'$learn'(Pos,Neg,modeh(O,PMS,Mode,Var)),
	'$show_result'.
generalize(Pred/Arity):-!,
	format('No Modeh for ~w/~d.~n',[Pred,Arity]).
generalize(X):-
	'$print_err'([generalise(X)]).

modeh(H):- '$make_modes'('$$modeh', H, MH), !,assertz(MH).
modeh(H):- '$print_err'([(:-modeh(H))]).

modeb(H):- '$make_modes'('$$modeb', H, MH), assertz(MH).
modeb(H):- '$print_err'([(:-modeb(H))]).

%'$make_modes'(+HB, +H, -MH)
'$make_modes'(MHB, Pred, MODES):-
	Pred=..[F|Args],
	functor(Pred,F,Arity),
	'$make_modes'(Args, P,[], M,[], S,[], LitArg, VarArg),
	Lit =..[F|LitArg],
	Var =..[F|VarArg],
	%MODES =..[MHB, Pred, [P,M,S], Lit, Var].
	MODES =..[MHB, F/Arity, [P,M,S], Lit, Var].

'$make_modes'([], P,P, M,M, S,S, [],[]).
'$make_modes'([A|A1], P,Pz, M,Mz, S,Sz, [L|L1], [V|V1]):-
	'$make_modes_arg'(A, P,Pm, M,Mm, S,Sm, L,V),
	'$make_modes'(A1, Pm,Pz, Mm,Mz, Sm,Sz, L1,V1).

'$make_modes_arg'(+Type, [P|Pz],Pz, M,M, S,S, +,X):-!,var(X), P=..[Type,X].
'$make_modes_arg'(-Type, P,P, [M|Mz],Mz, S,S, -,X):-!,var(X), M=..[Type,X].
'$make_modes_arg'(#Type, P,P, M,M, [S|Sz],Sz, #,X):-!,var(X), S=..[Type,X].
'$make_modes_arg'(Const, P,P, M,M, S,S, Const, Const):-
	functor(Const, _F, 0),!.
'$make_modes_arg'(Term, P,Pz, M,Mz, S,Sz, L,V):-
	Term =..[F|Args],
	'$make_modes'(Args, P,Pz, M,Mz, S,Sz, LArgs, VArgs),
	L =..[F|LArgs],
	V =..[F|VArgs].

commutative(Pred/Arity):-
	clause('$$commutative'(Pred/Arity),true),!.
commutative(Pred/Arity):- integer(Arity),
	assertz('$$commutative'(Pred/Arity)).
commutative(H):-
	'$print_err'([(:-commutative(H))]).

determination(Pred/Arity, Pred1/Arity1):-
	clause('$$determination'(Pred/Arity, Pred1/Arity1), true),!.
determination(Pred/Arity, Pred1/Arity1):-
	integer(Arity), integer(Arity1),
	assertz('$$determination'(Pred/Arity, Pred1/Arity1)).
determination(H,H1):-
	'$print_err'([(:-determination(H,H1))]).


set(X,Y):- '$checkSet'(set(X,Y)), '$set1'(X,Y).
set(X,Y):- '$print_err'([(:-set(X,Y))]).

'$set1'(X,Y):- clause('$$set'(X,Old),true),!,
	retract('$$set'(X,Old)),
	assertz('$$set'(X,Y)).
'$set1'(X,Y):-assertz('$$set'(X,Y)).

'$checkSet'(set(c,Y)):- integer(Y), Y>0.
'$checkSet'(set(i,Y)):- integer(Y),Y>0.
'$checkSet'(set(h,Y)):- integer(Y),Y>0.
'$checkSet'(set(noise,Y)):- integer(Y),100 >= Y, Y>=0.
'$checkSet'(set(nodes,Y)):- integer(Y),Y>0.


ic((:-H)):- clause('$$ic'(H),true).
ic((:-H)):- assertz('$$ic'(H)),!.
ic(X):- '$print_err'([(:-ic(X))]).

observable(Pred/Arity, Pred1/Arity1):-
	clause('$$observable'(Pred/Arity, Pred1/Arity1), true),!.
observable(Pred/Arity, Pred1/Arity1):-
	integer(Arity),integer(Arity1),
	assertz('$$observable'(Pred/Arity, Pred1/Arity1)).
observable(Pred/Arity, Pred1/Arity1):-	
	'$print_err'([(:-observable(Pred/Arity, Pred1/Arity1))]).

observable(Pred/Arity):-
	clause('$$observable'(Pred/Arity,_),true),!.
observable(Pred/Arity):-
	integer(Arity),
	assertz('$$observable'(Pred/Arity,_)).
observable(Pred/Arity):-
	'$print_err'([(:-observable(Pred/Arity))]).
