%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
% MSH.pl MSH Construction


:- dynamic '$$type'/2. % type(TYPE(INS),D). This is used in MSH Construction
:- dynamic '$$msh'/5.  %msh(No,Ins,Mode,Pt,Mt).

'$make_msh'(EX, modeh(Type,PMS,Mode,Var), MSH):-
	\+(\+((EX=Var))), !,
	(clause('$$msh'(_,_,_,_,_),true)-> abolish('$$msh'/5);true),
	'$exec'((
	     copy_term(modeh(Type,PMS,Mode,Var),modeh(Type1,PMS1,Mode1,Var1)),
	     Var1=EX,
	     '$const_msh'(modeh(Type1,PMS1,Mode1,Var1), MSH)
	 )).
%Abductive Induction
'$make_msh'(EX,modeh(Type,PMS,Mode,Var),MSH):-
	'$$set'(h,H),
	'$peval'(EX,Mode,H,Red),

	'$all_ground'(Red),
	'$all_notinDB'(Red),
	'$make_msh_abd'(Red, modeh(Type,PMS,Mode,Var,MSH)).

'$make_msh_abd'(Red,modeh(Type,PMS,Mode,Var,MSH)):-
	'$select'(Red, Pos, Rest),
	'$exec'((
	     (clause('$msh'(_,_,_,_,_),true)-> abolish('$msh'/5);true),
	     '$assert_red'(Rest),
	     copy_term(modeh(Type,PMS,Mode,Var),modeh(Type1,PMS1,Mode1,Var1)),
	     Var1=Pos,
	     '$const_msh'(modeh(Type1,PMS1,Mode1,Var1),MSH),
	     '$retract_red'(Rest)
	 )).



'$all_ground'([]).
'$all_ground'([H|T]):- ground(H),'$all_ground'(T).

'$all_notinDB'([]).
'$all_notinDB'([H|T]):- \+clause(H,true), '$all_notinDB'(T).

'$assert_red'([]).
'$assert_red'([H|T]):- assertz(H), '$assert_red'(T).

'$retract_red'([]).
'$retract_red'([H|T]):- retract(H),'$retract_red'(T).


'$const_msh'(modeh(FuncArity, [Pt,Mt,St], Mode,Var), MSH):-
	(clause('$$type'(_,_),true)->abolish('$$type'/2);true),
	'$assert_type'(Pt,0),
	'$getModeB'(FuncArity,ModeB),
	'$$set'(i,Depth),
	'$gen_pos'(FuncArity,[Pt,Mt,St],Mode,Var,Pos),
	'$const_body'(Pos,1,Depth,ModeB,1,Body,[]),!,
	'$assert_type'(Mt,0),!,
	MSH = [[0,Var,Mode,Pt,Mt]|Body],
	'$assert_msh'(MSH),
	'$hash'(MSH,MSHVar),
	\+(\+((numbervars(MSHVar,0,_),nl,'$show_msh'(MSHVar)))).

%getModeB(Func/Arity,ModeB) 
'$getModeB'(F/A,ModeB):- %determination
	clause('$$determination'(F/A,_),true),!,
	findall(modeb(Pred/Arity,A2,A3,A4),
	       ('$$determination'(F/A,Pred/Arity),
	       '$$modeb'(Pred/Arity,A2,A3,A4)),
	       ModeB).
'$getModeB'(_FuncArity,ModeB):-
	findall(modeb(A1,A2,A3,A4), '$$modeb'(A1,A2,A3,A4),ModeB).

%'$gen_pos'(FuncArity,[Pt,Mt,St],Mode,Pos)
'$gen_pos'(F/A,[Pt,Mt,St],Mode,_Var,Pos):-
	clause('$$commutative'(F/A),true),!,
	'$pt_sort'(Pt,Sorted), 	%sort Pt
	'$gen_newPos'(Mode, Sorted,_,Mt,_,St,_, Pos). 	

'$gen_pos'(_FA, _PtMtSt, _Mode,Pos,Pos).

'$pt_sort'([X],[X]):-!.
'$pt_sort'(X,Y):- '$div'(X,Part1,Part2),
	'$pt_sort'(Part1,S1), '$pt_sort'(Part2,S2),
	'$pt_merge'(S1,S2,Y).

'$pt_merge'([],S,S).
'$pt_merge'(S,[],S).
'$pt_merge'([X|XT],[Y|YT],[X|TT] ):- X @=<Y,!,
	'$pt_merge'(XT,[Y|YT],TT).
'$pt_merge'([X|XT],[Y|YT],[Y|TT] ):- 
	'$pt_merge'([X|XT],YT,TT).

%'$gen_newPos'(Mode, Sorted,Mt,St, Pos).
'$gen_newPos'(+,[P|Pt],Pt, Mt,Mt, St,St, PA):-!,P=..[_F,PA].
'$gen_newPos'(-,Pt,Pt, [M|Mt],Mt, St,St, MA):-!,M=..[_F,MA].
'$gen_newPos'(#,Pt,Pt, Mt,Mt, [S|St],St, SA):-!,S=..[_F,SA].
'$gen_newPos'(Const, Pt,Pt,Mt,Mt,St,St, Const):- functor(Const,_F,0),!.
%'$gen_newPos'([], Pt,Pt,Mt,Mt,St,St,[]):-!.
'$gen_newPos'([H|T],Pt,Ptz, Mt,Mtz, St,Stz, [HR|TR]):-!,
	'$gen_newPos'(H,Pt, Ptm, Mt, Mtm, St, Stm, HR),
	'$gen_newPos'(T,Ptm,Ptz, Mtm,Mtz, Stm,Stz, TR).
'$gen_newPos'(Pred,Pt,Ptz,Mt,Mtz,St,Stz,Pos):-
	Pred=..[F|Args],
	'$gen_newPos'(Args,Pt,Ptz,Mt,Mtz,St,Stz,PArgs),
	Pos=..[F|PArgs].

'$assert_type'([],_D).
'$assert_type'([H|T],D):-
	clause('$$type'(H,_Dp),true),!, '$assert_type'(T,D).
'$assert_type'([H|T],D):-
	assertz('$$type'(H,D)), '$assert_type'(T,D).


%%% const_body(Pos,I, ILim, ModeBList, No, Body, Bodyz)
%%% Body = [[No,INST,MODE, Pt,Mt],,,]

'$const_body'(_Pos, I,ILim, _ModeB, _No, B,B):-I>ILim,!.
'$const_body'(Pos, I, ILim, ModeB, No, B, Bz):-
	'$body_loop'(ModeB,Pos, I, B,Bm, No, No1),
	(No =:= No1 -> I1 is ILim+1; I1 is I+1),
	'$const_body'(Pos, I1,ILim,ModeB, No1, Bm,Bz).

%modeb_loop
'$body_loop'([], _Pos, _D, B,B, No,No).
'$body_loop'([modeb(PredArity,[Pt,Mt,St],Mode,Var)|T], Pos, D, B,Bz, No,Noz):-
	'$$set'(h,Heasy),
	setof([Var,Mode,Pt,Mt],
	     ('$get_Ptype'(D,Pt,0), 
	     '$com_chk'(PredArity,Pt),
	     '$eval'(Var,Heasy),
	     \+(Var=Pos),
	     '$type_chk'(Mt,Heasy),
	     '$type_chk'(St,Heasy),
	     '$assert_type'(Mt,D)),
	     BLit),
	     '$addBody'(BLit,B,Bm,No,Nom),
	     '$body_loop'(T, Pos, D, Bm,Bz, Nom,Noz).

'$body_loop'([_H|T], Pos, D,B,Bz,No,Noz):-
	'$body_loop'(T,Pos, D,B,Bz,No,Noz).

'$type_chk'([],_D):-!.
'$type_chk'([H|T],D):-'$eval'(H,D), '$type_chk'(T,D).

'$addBody'([],B,B,No,No).
'$addBody'([[Ins,Mode,Pt,Mt]|T], [[No,Ins,Mode,Pt,Mt]|B],Bz,No,Noz):-
	No1 is No+1,
	'$addBody'(T,B,Bz,No1,Noz).

%get_Ptype(Depth, Pt, Indicator).
'$get_Ptype'(_D, [], 1).
'$get_Ptype'(D, [any(X)|T], _I):-
	clause('$$type'(H,J),true), J is D-1,
	H=..[_F,X], '$get_Ptype'(D,T,1).
'$get_Ptype'(D, [any(X)|T], I):-
	clause('$$type'(H,J),true), J =\= D, J =\= D-1,
	H=..[_F,X], '$get_Ptype'(D,T,I).
'$get_Ptype'(D,[H|T],_I):-
	clause('$$type'(H,J),true), J is D-1, '$get_Ptype'(D,T,1).
'$get_Ptype'(D,[H|T],I):-
	clause('$$type'(H,J),true), J =\= D, J =\= D-1,
	'$get_Ptype'(D,T,I).

'$com_chk'(PredArity,Pt):-clause('$$commutative'(PredArity),true),!,
	'$com_chk'(Pt).
'$com_chk'(_PredArity,_Pt).
'$com_chk'([_H]).
'$com_chk'([H,H1|T]):- H @=<H1,'$com_chk'([H1|T]).

	
'$hash'(MSH,MSHVar):-
	findall(Type, '$$type'(Type, _D), Types),
	'$assign_var'(Types,VTypes),
	'$hash'(MSH,VTypes,MSHVar).

'$assign_var'([],[]).
'$assign_var'([H|T], [VH|VT]):-
	var(X), H=..[_F,C], VH=[C,X],
	'$assign_var'(T,VT).

'$hash'([],_,[]).
'$hash'([[_No,Ins,Mode,_Pt,_Mt]|BT],Types, [M|MT]):-
	'$hash1'(Ins,Mode,Types,M),
	'$hash'(BT,Types,MT).

'$hash1'(C,+,Types,X):-!, '$member'([C,X],Types).
'$hash1'(C,-,Types,X):-!, '$member'([C,X],Types).
'$hash1'(C,#,_Types,C):-!.
'$hash1'([Ins|InsT],[Mode|ModeT],Types,[InsX|InsTX]):-!, 
	'$hash1'(Ins,Mode,Types,InsX),
	'$hash1'(InsT,ModeT,Types,InsTX).
'$hash1'(C,_Mode,_Type,C):-functor(C,_F,0),!.
'$hash1'(C,Mode,Types,X):-
	C=..[F|Arg], Mode=..[F|ArgM],
	'$hash1'(Arg,ArgM,Types,ArgsX),
	X=..[F|ArgsX].

'$show_msh'(MSHVar):-
	format('MSH is ',[]),
	'$writeMSH'(MSHVar).

'$assert_msh'(MSH):-
	(clause('$$msh'(_,_,_,_,_),true)->abolish('$$msh'/5);true),
	'$assert_msh1'(MSH,0).
'$assert_msh1'([],_No).
'$assert_msh1'([[No,Ins,Mode,Pt,Mt]|T],_):-
	assertz('$$msh'(No,Ins,Mode,Pt,Mt)),
	'$assert_msh1'(T,No).
