%%%%
% Copyright (C) 1999 Koichi FURUKAWA
%
% a-datagol.pl
%

%%% OP and Dynamic Declaration %%%
:- op(100,fx, (#)).

:-[parser].
:-[eval].
:-[msh].
:-[search].
:-[util].


run(Argv):- datagol([Argv]).

datagol([Argv|_]):-
	'$showCopyRight',
	(clause('$$hyp'(_),true) -> abolish('$$hyp'/1);true),
	'$parse'(Argv),!,
	'$main',
	'$show_result'.

'$showCopyRight':-
	format('Copyright (C) 1999 Koichi FURUKAWA ~n',[]).
%%%%%%%%% MAIN %%%%%
'$main':-
	'$$modeh'(O, PMS,Mode,Var),
	'$exec'((
	     '$learn_prepare'(Mode, Pos, Neg), 
	     '$learn'(Pos,Neg,modeh(O,PMS,Mode,Var))
	 )),
	 fail.
'$main'.

'$exec'(H):-H,!.

%GET EXAMPLES
'$learn_prepare'(Mode, Pos,Neg):-
	functor(Mode, F, A),
	'$learn_pred'(F/A, Pred),
	format('Learning ~w/~d with ~w.~n', [F,A,Pred]),
	'$getPos'(Pred,Pos),
	'$getNeg'(Pred,Neg).

'$learn_pred'(F/A, Pred):-
	setof(F1/A1, '$$observable'(F1/A1, F/A), Pred),!.
'$learn_pred'(F/A, [F/A]).

'$getPos'([],[]).
'$getPos'([F/A|Rest], Pos):-
	'$getPos'(Rest,RestPos),
	functor(X, F,A),
	findall(X, (clause(X,true),ground(X)), HPos ),
	'$append'(HPos, RestPos, Pos).
'$getNeg'([],[]).
'$getNeg'([F/A|Rest], Neg):-
	'$getNeg'(Rest,RestNeg),
	functor(X, F,A),
	findall(X, (clause('$$neg'(X),true),ground(X)), HNeg ),
	'$append'(HNeg, RestNeg, Neg).


%%%% learn (Inner Loop).
:- dynamic '$$hyp'/1.

'$learn'([], _Neg, _modeh). 
'$learn'([P|Pos], Neg, MH):-
	'$$set'(h,H),
	'$pos_eval'(P,H),!,
	'$learn'(Pos,Neg,MH).

'$learn'([P|Pos], Neg,MH):-
	format('~n ~w is used for MSH generation.~n',[P]),
	'$make_msh'(P, MH, MSH), 
	'$search'([P|Pos], Neg, MSH, Hyp),

	assertz('$$hyp'(Hyp)),

	(P==Hyp -> 
	    (format('~n No Compression~n~n',[]),
	    '$learn'(Pos,Neg,MH))
	;
	(
	    format('~n Search Result is',[]),
	    \+(\+((
	         numbervars(Hyp,0,_),
		 '$writeHyp'(Hyp)
	     ))),
	    format('~n',[]),
	    assertz(Hyp),
	    '$$set'(h,H),
	    '$retract_ex'(H,Pos, Rest),

	    '$learn'(Rest, Neg,MH)
	)).

'$learn'([P|Pos],Neg, modeh(O,PMS,Mode,Var)):-
	format('~n No Compression~n~n',[]),
        (('$$set'(h,H),'$peval'(P,Mode,H,Red),
	  '$all_ground'(Red),'$all_notinDB'(Red))->

	  '$assertHyp'(Red); assertz('$$hyp'(P))),
	  '$learn'(Pos,Neg, modeh(O,PMS,Mode,Var)).

'$assertHyp'([]).
'$assertHyp'([H|T]):- clause(H,true),!,
        assertz('$$hyp'),'$assertHyp'(T).
'$assertHyp'([H|T]):- assertz(H),
        assertz('$$hyp'),'$assertHyp'(T).


'$retract_ex'(_H, [],[]).
%'$retract_ex'(H, [X|Y], Y1):- '$pos_eval'(X,H),!,'$retract_ex'(H,Y,Y1).
'$retract_ex'(H, [X|Y], Y1):- '$pos_eval'(X,H),!,
	retract(X),
	'$retract_ex'(H,Y,Y1).
'$retract_ex'(H, [X|Y],[X|Y1]):- '$retract_ex'(H,Y,Y1).


'$show_result':-
	format('~n Obtained Hypotheses...',[]),
	clause('$$hyp'(Hyp),true),
	\+(\+((
	     numbervars(Hyp,0,_),
	     '$writeHyp'(Hyp)
	 ))),
	fail.

'$show_result'.
