/**
 * XTerm.java Version 32f2 7-Sep-1998
 * Copyright (c) 1997, 1998 Kyushu University
 */

class XTerm extends Term {
  public static int EQ=0;
  public static int NE=1;
  public static int GT=2;
  public static int GE=3;
  public static int LT=4;
  public static int LE=5;

  public static String[] opString
  = new String[] {"==","!=",">",">=","<","<="};
  
  Term left,right; int rop;

  XTerm() {}
  XTerm(Term l, Term r, int o) {left=l; right=r; rop=o;}
  XTerm(Term l, Term r, String op) {
    left=l; right=r;
    for (int i=0; i<opString.length; i++)
      if (opString[i].equals(op)) {rop=i; break;}
  }

  public String toString() {return left+opString[rop]+right;}

  void satisfied(AConj ai) {
    boolean b;
    switch (rop) {
    case 0: b=(left.ieval()==right.ieval());
      break;
    case 1: b=(left.ieval()!=right.ieval());
      break;
    case 2: b=(left.ieval()>right.ieval());
      break;
    case 3: b=(left.ieval()>=right.ieval());
      break;
    case 4: b=(left.ieval()<right.ieval());
      break;
    case 5: b=(left.ieval()<=right.ieval());
      break;
    default: b=false;
    }
    if (b) {
      if (ai.tl==null) {
	Counter.putBuf++;
	ai.cnsq.putBuf(ai.mgtp);
      } else {
	ai.tl.hd.satisfied(ai.tl);
      }
    }
  }

}

// eof
