/**
 * Term.java Version 32g 9-Oct-1998
 * Copyright (c) 1997, 1998 Kyushu University
 *
 * Based on Version 27cT 11-Aug-1998
 * notsubsumed_ac,onTM and setac added    // R.H. 98.08.15
 * to support putBuf/putUnitBuf and prove
 */

abstract class Term {
  String name; Term next,arg; int index;
  Term() {}
  //  public String toString() {return super.toString();}
  public String toString() {return "";}
  public String toString1() {return "";}
  Term ground() {return null;}
  Term vground(Term x) {return null;}
  Term vgroundL() {return null;}
  boolean match(Term x) {return false;}
  boolean vmatch(Term x) {return false;}
  boolean satisfied() {return false;}
  boolean subsumed() {return false;}
  boolean conflict() {return false;}
  boolean notsubsumed_ac(MGTP mg) {return false;} // added R.H. 98.08.14
  void setac(MGTP mg) {} // added R.H. 98.08.14
  void satisfied(AConj ai) {}
  void leafProc(GTerm t, AConj ante) {}
  int ieval() {return 0;}
}

abstract class GTerm extends Term {
  ACell pac,nac; TMNode up; CList Cls;
  GTerm() {}
  boolean satisfied() {
    Counter.sat++;
    return pac.act;
  }
  void setac(MGTP mg) { // added R.H.98.08.14
    pac=mg.ac; 
  }
  boolean notsubsumed_ac(MGTP mg) { // added R.H. 98.08.14
    if (pac.act) return false;
    pac=mg.ac;
    if (nac.act) { // added R.H. 98.08.15
//      mg.unsat=true;
//      System.out.println(" conflict detected by "+this);
      mg.closed=true;
    };
    return true;
  }
  void onTM(MGTP mg) {}
}

class SGTerm extends GTerm {
  GTerm atm; SLCnsq cns;
  SGTerm() {}
  SGTerm(GTerm t) {atm=t;}
  public String toString() {return "SGTerm:"+atm;}
  boolean satisfied() {
    Counter.sat++;
    if (atm.pac.act) {cns.sel=1; return true;}
    else if (atm.nac.act) {cns.sel=-1; return true;}
    else return false;
  }
}

class SNGTerm extends SGTerm {
  SNGTerm(GTerm t) {atm=t;}
  public String toString() {return "SNGTerm:-"+atm;}
  boolean satisfied() {
    Counter.sat++;
    if (atm.nac.act) {cns.sel=1; return true;}
    else if (atm.pac.act) {cns.sel=-1; return true;}
    else return false;
  }
}

class GNLiteral extends GTerm {
  GTerm atm;
  GNLiteral(GTerm t) {atm=t;}
  GNLiteral(GTerm t, CList cls) {atm=t; Cls=cls;}
  public String toString() {return "-"+atm;}
  boolean match(GTerm x) {
    if (!(x instanceof GNLiteral)) return false;
    return atm.match(((GNLiteral)x).atm); }
  boolean satisfied() {
    Counter.sat++;
    return atm.nac.act;
  }
  boolean subsumed() {
    Counter.subs++;
    return atm.nac.act;
  }
  boolean conflict() {
    Counter.conf++;
    return atm.pac.act;
  }
  void setac(MGTP mg) { // added R.H.98.08.14
    atm.nac=mg.ac; 
  }
  boolean notsubsumed_ac(MGTP mg) {
    if (atm.nac.act) return false;
    atm.nac=mg.ac;
    if (atm.pac.act) { // added R.H. 98.08.15
//      System.out.println(" conflict detected by "+atm);
//      mg.unsat=true;
      mg.closed=true; 
    };
    return true;
  }
  void onTM(MGTP mg) {
    if (atm instanceof GCTermF) {
      Counter.onTM++; 
      TMNode n;
      n=atm.up;
      while (n!=mg.TM) {
        if (!n.ndac.act)n.ndac=mg.ac;
        n=n.up;
      }
    };
  }

}

class UATerm extends GTerm {
  UATerm(String s) {name=s; pac=nac=ACell.OFF;}
  public String toString() {return name;}
  Term ground() {return this;}
  Term vgroundL() {return this;}
  boolean match(Term x) {
    Counter.match++;
    return this==x;
  }
  boolean vmatch(Term x) {return this==x;}
  boolean subsumed() {
    Counter.subs++;
    return pac.act;
  }
  boolean conflict() {
    Counter.conf++;
    return nac.act;
  }
  void onTM(MGTP mg) {} // added R.H. 98.08.15
}

class ATerm extends Term {
  ATerm() {}
  ATerm(String s) {name=s;}
  ATerm(String s, int i) {name=s; index=i;}
  ATerm(String s, Term x) {name=s; next=x;}
  ATerm(String s, Term x, int i) {name=s; next=x; index=i;}
  public String toString() {return name+","+next;}
  public String toString1() {return name;}
  Term ground() {return new ATerm(name, next.ground(), index);}
  Term vground(Term x) {return new ATerm(name,x,index);}
  Term vgroundL() {return new ATermL(name,index);}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return next.match(x.next);
  }
  boolean vmatch(Term x) {return name==x.name;}
}

class ATermL extends ATerm {
  ATermL(String s) {name=s;}
  ATermL(String s, int i) {name=s; index=i;}
  public String toString() {return name;}
  //  public String toString() {
  //    return "ATermL:"+name+(next==null ? "" : "<"+next+">");}
  Term ground() {return this;}
  Term vgroundL() {return this;}
  boolean match(Term x) {return name==x.name;}
}

class ITerm extends Term {
  int val;
  ITerm() {}
  ITerm(int v) {val=v;}
  ITerm(int v, int i) {val=v; index=i;}
  ITerm(int v, Term x) {val=v; next=x;}
  ITerm(int v, Term x, int i) {val=v; next=x; index=i;}
  public String toString() {return Integer.toString(val)+","+next;}
  public String toString1() {return Integer.toString(val);}
  Term ground() {return new ITerm(val, next.ground(),index);}
  Term vground(Term x) {return new ITerm(val,x,index);}
  Term vgroundL() {return new ITermL(val,index);}
  boolean match(Term x) {
    if (!(x instanceof ITerm)) return false;
    if (val!=((ITerm)x).val) return false;
    return next.match(x.next);
  }
  boolean vmatch(Term x) {
    if (!(x instanceof ITerm)) return false;
    return val==((ITerm)x).val;
  }
  int ieval() {return val;}
}

class ITermL extends ITerm {
  ITermL(int v) {val=v;}
  ITermL(int v, int i) {val=v; index=i;}
  public String toString() {return Integer.toString(val);}
  Term ground() {return this;}
  Term vgroundL() {return this;}
  boolean match(Term x) {
    if (!(x instanceof ITerm)) return false;
    return val==((ITerm)x).val;
  }
}

class FVar extends Term {
  FVar() {}
  FVar(String s) {name=s;}
  FVar(String s, Term x) {name=s; next=x;}
  //  public String toString() {return "?"+name+"<"+super.toString()+">,"+next;}
  public String toString() {return "?"+name+","+next;}
  public String toString1() {return "?"+name;}
  boolean match(Term x) {arg=x; return next.match(x.next);}
}

class FVarL extends FVar {
  FVarL() {}
  FVarL(String s) {name=s;}
  //  public String toString() {return "<"+super.toString()+">";}
  public String toString() {return "?"+name;}
  //  public String toString() {
  //    return "FVarL:"+name+(next==null ? "" : "<"+next+">");}
  boolean match(Term x) {arg=x; return true;}
}

class AVar extends FVar {
  AVar(String s) {name=s;}
  AVar(String s, Term x) {name=s; next=x;}
  public String toString() {return name+","+next;}
  boolean match(Term x) {return next.match(x.next);}
}

class AVarL extends FVarL {
  AVarL(String s) {name=s;}
  public String toString() {return name;}
  boolean match(Term x) {return true;}
}

class BVar extends Term {
  BVar() {}
  BVar(String s, Term t) {name=s; arg=t;}
  BVar(String s, Term t, Term x) {name=s; arg=t; next=x;}
  //  public String toString() {return "!"+name+"<"+arg+">,"+next;}
  public String toString() {return "!"+name+","+next;}
  public String toString1() {return "!"+name;}
  Term ground() {return arg.arg.vground(next.ground());}
  boolean match(Term x) {
    if (!arg.arg.vmatch(x)) return false;
    return next.match(x.next);
  }
  int ieval() {return ((ITerm)arg.arg).val;}
}

class BVarL extends BVar {
  BVarL(String s, Term t) {name=s; arg=t;}
  //  public String toString() {return "!"+name+"<"+arg+">";}
  public String toString() {return "!"+name;}
  //  public String toString() {
  //    return "BVarL:"+name+(next==null ? "" : "<"+next+">");}
  GTerm ground(TMNode tm) {return (GTerm)arg.arg;}
  Term ground() {return arg.arg.vgroundL();}
  boolean match(Term x) {return arg.arg.vmatch(x);}
}

class CTerm extends Term {
  CTerm() {}
  CTerm(String s, int i) {name=s; index=i;}
  CTerm(String s, Term a, Term x) {name=s; arg=a; next=x;}
  CTerm(String s, Term a, int i) {name=s; arg=a; index=i;}
  CTerm(String s, Term a, Term x, int i) {name=s; arg=a; next=x; index=i;}
  public String toString() {
    return name.substring(0,name.indexOf("/"))+"("+arg+"),"+next;
  }
  public String toString1() {
    return "CTerm:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  Term ground() {return new CTerm(name, arg.ground(), next.ground(), index);}
  Term vground(Term x) {return new CTerm(name,arg,x,index);}
  Term vgroundL() {return new CTermL(name,arg,index);}
  boolean match(Term x) {
    if (name!=x.name) return false;
    if (!arg.match(x.arg)) return false;
    return next.match(x.next);
  }
  boolean vmatch(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }
}

class CTermL extends CTerm {
  CTermL(String s, int i) {name=s; index=i;}
  CTermL(String s, Term a) {name=s; arg=a;}
  CTermL(String s, Term a, int i) {name=s; arg=a; index=i;}
  public String toString() {
    return "CTermL:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  public String toString1() {
    return "CTermL:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  Term ground() {return new CTermL(name, arg.ground(),index);}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }
}

class CCTerm extends Term {
  SkipList skipl;
  CCTerm() {}
  CCTerm(String s, int i) {name=s; index=i;}
  CCTerm(String s, Term a, Term x) {name=s; arg=a; next=x;}
  CCTerm(String s, Term a, int i) {name=s; arg=a; index=i;}
  CCTerm(String s, Term a, Term x, int i) {name=s; arg=a; next=x; index=i;}
  public String toString() {
    return "CCTerm:"+name.substring(0,name.indexOf("/"))+"("+arg+"),"+next;
  }
  public String toString1() {
    return "CCTerm:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  Term ground() {
   Term t=new CTerm(name, arg.ground(), next.ground(), index);
   //   skipl.term=t; // BUG!! 98-10-09
   if (skipl!=null) skipl.term=t; // BUG fix 98-10-09
   return t;
  }
}

class CCTermL extends CCTerm {
  CCTermL(String s, int i) {name=s; index=i;}
  CCTermL(String s, Term a) {name=s; arg=a;}
  CCTermL(String s, Term a, int i) {name=s; arg=a; index=i;}
  public String toString() {
    return "CCTermL:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  /*
  public String toString() {
    return name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  */
  public String toString1() {
    return "CCTermL:"+name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  Term ground() {
   Term t=new CTermL(name, arg.ground(), index);
   //   skipl.term=t; // BUG!! 98-11-10
   if (skipl!=null) skipl.term=t; // BUG fix 98-11-10
   return t;
  }
}

class CTermF extends CTerm {
  CList Cls;
  CTermF() {}
  CTermF(String s, Term a) {name=s; arg=a;}
  CTermF(String s, int i) {name=s; index=i;}
  CTermF(String s, Term a, int i) {name=s; arg=a; index=i;}
  CTermF(String s, int i, CList cls) {name=s; index=i; Cls=cls;}
  CTermF(String s, Term a, int i, CList cls) {
    name=s; arg=a; index=i; Cls=cls;
  }
  public String toString() {
    return name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  /*
  public String toString() {
    return name.substring(0,name.indexOf("/"))+"{"+index+"}"+"("+arg+")";
  }
  */
  Term ground() {return new GCTermF(name, arg.ground(), index, Cls);}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }

  void satisfied(AConj ai) {
    //    Counter.matchTM++;
    //    System.out.println("Top.matchTM: "+t);
    TMNode son=ai.tmn.farray[index];
    if (son!=null&&son.ndac.act) {
      Counter.matchtmBV++;
      son.matchTMBV(this,ai);
    }
  }

  void leafProc(GTerm t, AConj ante) {
    //    Counter.leafProc++;
    if (t.pac.act) {
      //        Counter.leafact++;
      if (ante.tl==null) {
	Counter.putBuf++;
	ante.cnsq.putBuf(ante.mgtp);
      } else {
	//	Counter.matchtmBV++; // comment out R.H. 98.09.06
	ante.tl.hd.satisfied(ante.tl);
      }
    }
  }
  
}

class NCTermF extends CTermF {
  NCTermF(String s, Term a) {name=s; arg=a;}
  NCTermF(String s, int i) {name=s; index=i;}
  NCTermF(String s, Term a, int i) {name=s; arg=a; index=i;}
  NCTermF(String s, int i, CList cls) {name=s; index=i; Cls=cls;}
  NCTermF(String s, Term a, int i, CList cls) {
    name=s; arg=a; index=i; Cls=cls;
  }
  public String toString() {
    return "NCTermF:-"+name.substring(0,name.indexOf("/"))+"{"+index+"}"+"("+arg+")";
  }
  boolean match(Term x) {
    if (!(x instanceof GNLiteral)) return false;
    if (((GNLiteral)x).atm.name!=name) return false;
    return arg.match(((GNLiteral)x).atm.arg);
  }

  void leafProc(GTerm t, AConj ante) {
    //    Counter.leafProc++;
    //System.out.println("leafProc("+ante.hd+","+lf);
    if (t.nac.act) {
      //        Counter.leafact++;
      if (ante.tl==null) {
	Counter.putBuf++;
	ante.cnsq.putBuf(ante.mgtp);
      } else {
	//	Counter.matchtmBV++; // comment out R.H. 98.09.06
	ante.tl.hd.satisfied(ante.tl);
      }
    }
  }

}

class SCTermF extends CTermF {
  SLCnsq cns;
  SCTermF() {}
  SCTermF(String s, Term a, int i) {name=s; arg=a; index=i;}
  public String toString() {
    return "SCTermF:"+name.substring(0,name.indexOf("/"))+"{"+index+"}"+"("+arg+")";
  }
  void leafProc(GTerm t, AConj ante) {
    if (t.pac.act) {
      cns.sel=1; 
      Counter.putBuf++;
      cns.putBuf(null);
      if (t.nac.act) System.out.println("ERROR!!");
    }
    else if (t.nac.act) {
      cns.sel=-1; 
      Counter.putBuf++;
      cns.putBuf(null);
    }
  }
}

class SNCTermF extends SCTermF {
  SNCTermF(String s, Term a, int i) {name=s; arg=a; index=i;}
  public String toString() {
    return "SNCTermF:-"+name.substring(0,name.indexOf("/"))+"{"+index+"}"+"("+arg+")";
  }
  void leafProc(GTerm t, AConj ante) {
    if (t.nac.act) {
      cns.sel=1; 
      Counter.putBuf++;
      cns.putBuf(null);
      //      if (t.pac.act) System.out.println("ERROR!!");
    }
    else if (t.pac.act) {
      cns.sel=-1; 
      Counter.putBuf++;
      cns.putBuf(null);
    }
  }
}

class GCTermF extends GTerm {
  GCTermF(String s, int i) {name=s; index=i; pac=nac=ACell.OFF;}
  GCTermF(String s, Term a) {name=s; arg=a; pac=nac=ACell.OFF;}
  GCTermF(String s, Term a, int i) {
    name=s; arg=a; index=i; pac=nac=ACell.OFF;
  }
  GCTermF(String s, Term a, int i, CList cls) {
    name=s; arg=a; index=i; pac=nac=ACell.OFF; Cls=cls;
  }

  public String toString() {
    return name.substring(0,name.indexOf("/"))+"("+arg+")";
  }
  /*
  public String toString() {
    return name.substring(0,name.indexOf("/"))+"{"+index+"}"+"("+arg+")";
  }
  */
  Term ground() {return this;}
  boolean match(Term x) {
    if (name!=x.name) return false;
    return arg.match(x.arg);
  }
  boolean subsumed() {
    Counter.subs++;
    return pac.act;
  }
  boolean conflict() {
    Counter.conf++;
    return nac.act;
  }
  void onTM(MGTP mg) { // added R.H. 98.08.14
      Counter.onTM++; 
      TMNode n;
      n=up;
      while (n!=mg.TM) {
        if (!n.ndac.act)n.ndac=mg.ac;
        n=n.up;
      };
  }

}

// eof
