import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.text.*;
import java.util.*;

class PTVisualizer extends Frame implements ActionListener,TextListener,ItemListener{
    MGTP mgtp;

    Panel p;
    Panel exec_panel;
    Panel e_but_panel;    
    Panel readf_panel;
    Panel readf1_panel;
    Panel zoom_panel;
    Panel z_but_panel;
    Panel z_txt_panel;
    Panel z_txt_h_panel;
    Panel z_txt_v_panel;
    Panel cv_panel;   
    Panel s_but_panel;

    MenuBar menuBar;
    Choice zoomChoice;
    Menu engineMenu;
    Menu dspMenu;
    Menu treeMenu;
    Menu optionMenu;
    //CheckboxMenuItem e_mgtp,e_cmgtp,e_ivmgtp;
    CheckboxMenuItem e_cmgtp,e_cmgtpPickupMin;
    CheckboxMenuItem t_fixed,t_weighted;
    CheckboxMenuItem d_tree,d_radial,d_rad_local;
    CheckboxMenuItem o_verbose,o_allSol,o_selectMin,o_compileExt;

    Button run_button;
    Button readf_button;
    Button stop_button;
    //Button zoom_cancel;
    Button reset_button;
    Button status_button;
    TextField readf_txt;
    TextField zoom_h_txt;
    TextField zoom_v_txt;
    String fil1;
    //String dir1="c:\\mydocu~1\\jprob";
    String dir1;
    
    static PTCanvas ptc;
    static int cvw_height=600;		
    static int cvw_width=800;
    static int lgw_height=cvw_height;		
    static int lgw_width=cvw_width;
    static int cur_select_zoom=0;
    static int old_select_zoom=0;

    static int guiw_height=cvw_height+155;
    static int guiw_width=cvw_width+25;
 //   float default_step=100;
    
    ProveT pt;
    boolean sus=false;
    boolean run=false;
    char cursor_state='n';
    char tree_mode='f';
    volatile char disp_mode='t';
    char engine='c';

    STWindow stwindow;
    
    PTVisualizer(){}

    public static void main(String Args[]){
        //setPriority(Thread.MAX_PRIORITY);
        PTVisualizer ptvis=new PTVisualizer();
	    ptvis.init(); 
        ptvis.show();
        
    }

    void init(){
	    setTitle("Proof Tree Visualizer");
//	    setLayout(new BorderLayout());
	    menuBar = new MenuBar();
        zoomChoice = new Choice();
	    zoomChoice.addItem("X1");
    	zoomChoice.addItem("X2");    
    	zoomChoice.addItem("X4");
    	zoomChoice.addItem("X10");
    	zoomChoice.addItem("X50");
    	zoomChoice.addItem("X100");
    	zoomChoice.addItem("Custom");
    	zoomChoice.addItemListener(this);
    	//menuBar.add(zoomMenu);

    	engineMenu = new Menu("Engine");
    	
    	//e_mgtp=new CheckboxMenuItem("MGTP",true);
    	e_cmgtp=new CheckboxMenuItem("CMGTP(Normal)",true);
    	e_cmgtpPickupMin=new CheckboxMenuItem("CMGTP(Pickup Min)",false);
    	//e_ivmgtp=new CheckboxMenuItem("IVMGTP",false);
    	//e_mgtp.addItemListener(this);
    	e_cmgtp.addItemListener(this);
    	e_cmgtpPickupMin.addItemListener(this);
    	//e_ivmgtp.addItemListener(this);
    	//engineMenu.add(e_mgtp);
    	engineMenu.add(e_cmgtp);
    	engineMenu.add(e_cmgtpPickupMin);
    	//engineMenu.add(e_ivmgtp);
//    	addMenuItem(new MenuItem("MGTP"),engineMenu);
//    	addMenuItem(new MenuItem("CMGTP"),engineMenu);    
//    	addMenuItem(new MenuItem("IVMGTP"),engineMenu);
    	menuBar.add(engineMenu);
   
    	dspMenu = new Menu("Display");
    	d_tree=new CheckboxMenuItem("Tree",true);
    	d_radial=new CheckboxMenuItem("Radial(Global)",false);
    	d_rad_local=new CheckboxMenuItem("Radial(Local)",false);
    	d_tree.addItemListener(this);
    	d_radial.addItemListener(this);
    	d_rad_local.addItemListener(this);
    	dspMenu.add(d_tree);
    	dspMenu.add(d_radial);
    	dspMenu.add(d_rad_local);
//    	addMenuItem(new MenuItem("Tree"),dspMenu);
//    	addMenuItem(new MenuItem("Radial"),dspMenu);    
//    	addMenuItem(new MenuItem("Rectangle"),dspMenu);
    	menuBar.add(dspMenu);

    	treeMenu = new Menu("Alloc");
    	t_weighted=new CheckboxMenuItem("Weighted",false);
    	t_fixed=new CheckboxMenuItem("Fixed",true);
    	t_weighted.addItemListener(this);
    	t_fixed.addItemListener(this);
    	
    	treeMenu.add(t_fixed);
    	treeMenu.add(t_weighted);
//    	addMenuItem(new MenuItem("Weighted"),treeMenu);
//    	addMenuItem(new MenuItem("Fixed"),treeMenu);    
    	menuBar.add(treeMenu);
    	
    	optionMenu = new Menu("Option");
    	o_verbose=new CheckboxMenuItem("Verbose",false);
    	o_allSol=new CheckboxMenuItem("All Solve",false);
    	o_selectMin=new CheckboxMenuItem("Select Min",false);
    	o_compileExt=new CheckboxMenuItem("Compile Ext",false);
    	
    	optionMenu.add(o_verbose);
    	optionMenu.add(o_allSol);
    	optionMenu.add(o_selectMin);
    	optionMenu.add(o_compileExt);
    	
    	menuBar.add(optionMenu);



	    setMenuBar(menuBar);


    	p=new Panel(new FlowLayout());
    	exec_panel=new Panel(new BorderLayout());
    	e_but_panel=new Panel();
    	readf_panel=new Panel(new BorderLayout());
	    readf1_panel=new Panel();
    	zoom_panel=new Panel(new BorderLayout());
    	z_but_panel=new Panel();
    	z_txt_panel=new Panel();
        z_txt_h_panel=new Panel(new BorderLayout());
        z_txt_v_panel=new Panel(new BorderLayout());
    	cv_panel=new Panel(new BorderLayout());
	s_but_panel=new Panel();

	    add(p,"North");
	    add(cv_panel,"South");
    	p.add(exec_panel,"West");
    	p.add(zoom_panel,"Center");
	p.add(s_but_panel,"East");

    	readf_button=new Button(" Read File ");
    	run_button=new Button(" Run ");
    	stop_button=new Button("   Stop   ");
    	readf_button.addActionListener(this);
    	run_button.addActionListener(this);
    	stop_button.addActionListener(this);
    	e_but_panel.add(readf_button);
    	e_but_panel.add(run_button);
    	e_but_panel.add(stop_button);
    	
    	

    	Label readf_label = new Label(" File Name ",Label.CENTER);
    	readf_panel.add(readf_label,"West");
    	readf_txt = new TextField("", 20);
    	readf_txt.addTextListener(this);
    	readf_panel.add(readf_txt,"East");

    	readf1_panel.add(readf_panel);

    	exec_panel.add(e_but_panel,"North");
    	exec_panel.add(readf1_panel,"South");

    	zoom_panel.add(z_but_panel,"North");
    	zoom_panel.add(z_txt_panel,"South");
    	Label zoom_Label = new Label("Zoom",Label.RIGHT); 
 //       zoom_cancel = new Button("Zoom Cancel");
 //       zoom_cancel.addActionListener(this);
        z_but_panel.add(zoom_Label);
    	z_but_panel.add(zoomChoice);
//    	z_but_panel.add(zoom_cancel);
    	reset_button = new Button( "Reset ");
    	reset_button.addActionListener(this);
        z_but_panel.add(reset_button);
        
	    z_txt_panel.add(z_txt_h_panel);
        z_txt_panel.add(z_txt_v_panel);
	    Label zoom_h_label = new Label(" mult H ",Label.CENTER);
    	Label zoom_v_label = new Label(" mult V ",Label.CENTER);
        zoom_h_txt = new TextField("", 5);
    	zoom_v_txt = new TextField("", 5);
	    z_txt_h_panel.add(zoom_h_label,"West");
	    z_txt_h_panel.add(zoom_h_txt,"East");
	    z_txt_v_panel.add(zoom_v_label,"West");
	    z_txt_v_panel.add(zoom_v_txt,"East");

	    status_button = new Button("Status");
	    status_button.addActionListener(this);
	    s_but_panel.add(status_button);

	    ptc = new PTCanvas(cvw_width,cvw_height,lgw_width,lgw_height,this);    
    	ptc.h=new Scrollbar(Scrollbar.HORIZONTAL);
    	
    	ptc.v=new Scrollbar(Scrollbar.VERTICAL);
    	
        cv_panel.add(ptc.v,"East");
    	cv_panel.add(ptc.h,"South");
    	cv_panel.add(ptc,"Center");
	    ptc.setBackground(new Color(230,230,240));
    	ptc.setSize(cvw_width,cvw_height);

	    setSize(guiw_width,guiw_height);
	    addWindowListener(new PTWindowListener());
	    ptc.h.setValues(0,cvw_width,0,cvw_width);
        ptc.v.setValues(0,cvw_height,0,cvw_height);
        ptc.h.addAdjustmentListener(ptc);
        ptc.v.addAdjustmentListener(ptc);
	    //zoomMenu.setEnabled(false);
        //engineMenu.setEnabled(false);
        //dspMenu.setEnabled(false);
        //treeMenu.setEnabled(false);
        //e_cmgtp.setEnabled(false);
        //e_cmgtpPickupMin.setEnabled(false);
        
//        zoom_cancel.setEnabled(false);
//        reset_button.setEnabled(false);
        zoom_h_txt.setEnabled(false);
        zoom_v_txt.setEnabled(false);
        
	    run_button.setEnabled(false);
        stop_button.setEnabled(false);
        zoom_h_txt.setText(Float.toString(ptc.cur_mult_h));
        zoom_v_txt.setText(Float.toString(ptc.cur_mult_v));
        
    }

  //  void addMenuItem(MenuItem item,Menu parent){
  //      item.addActionListener(this);
  //      parent.add(item);
  //  }
   
    public void actionPerformed(ActionEvent e){
        if(e.getSource()==readf_button){
            readf_button_Clicked();
            return;
        }else if(e.getSource()==run_button){
            run_button_Clicked();
            return;
        }else if(e.getSource()==stop_button){       
            if(sus){
                mgtp.pt_top.sc.resu();
                //pt.pv.resume();
                //pt.resume();
                mgtp.pt_top.sc.ntfy();
                readf_txt.setText(fil1);
                readf_txt.setEnabled(false);
                readf_button.setEnabled(false);
                stop_button.setLabel("   Stop   ");
                sus=false;
                run_button.setEnabled(false);
                run=true;
            }else{
                System.out.println("suspend!");
                ptc.flush();
                mgtp.pt_top.sc.sus();
                //pt.interrupt();
                //pt.pv.interrupt();
                //pt.suspend();
                //pt.pv.suspend();
                System.out.println("suspended!");
                run_button.setEnabled(true);
                readf_txt.setEnabled(true);
                readf_button.setEnabled(true);
                run=false;
                ptc.zoom_redraw=false;
                stop_button.setLabel("Resume");
                sus=true;
                stop_button.setEnabled(true);
            }
        }else if(e.getSource()==reset_button){
            if(ptc.zoom_select){
                ptc.zoom_select=false;
                reset_button.setLabel("Reset");
                ptc.setCursor(ptc.cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                ptc.cur_mult_h=ptc.old_mult_h;
                ptc.cur_mult_v=ptc.old_mult_v;
                zoom_h_txt.setText(Float.toString(ptc.cur_mult_h));
                zoom_v_txt.setText(Float.toString(ptc.cur_mult_v));
                cur_select_zoom=old_select_zoom;
                zoomChoice.select(cur_select_zoom);
            }else{
                if(run==false && mgtp!=null){
                    ptc.zoomReset();
                    ptc.coordinate_offScr(ptc.gt);
                    if(sus) ptc.gt.zoom_Redraw(ptc,GT.curGT);
                    else ptc.gt.zoom_Redraw(ptc);
                    ptc.flush();
                }else if(run==true){
                    ptc.zoomReset();
                    ptc.zoom_redraw=true;
                    ptc.mouse_x=-1;ptc.mouse_y=-1;
                }
            }
        }else if(e.getSource()==status_button){
	   stwindow=new STWindow(mgtp);
	}
    }
   
    public void textValueChanged(TextEvent e){
        if(e.getSource()==readf_txt){
            File f=new File(dir1,readf_txt.getText());
            run_button.setEnabled((!run) && f.isFile() && f.canRead());
            //try{finalize();}catch(Throwable t){}
        }
    }
    
    public void itemStateChanged(ItemEvent e){
        float s;
        if(e.getSource()==t_fixed){
            t_fixed.setState(true);
            t_weighted.setState(false);
            tree_mode='f';
            if(run==false && sus==false && mgtp!=null){
                dspMenu.setEnabled(false);
                treeMenu.setEnabled(false);
                //ptc.og.dispose();
                ptc.coordinate_offScr(mgtp.pt_top);
                if(disp_mode=='t') mgtp.pt_top.fixed_recalc(0,cvw_width,ptc);
                else if(disp_mode=='r') mgtp.pt_top.r_fixed_recalc(0,(float)(Math.PI*2),ptc);
                else if(disp_mode=='l') mgtp.pt_top.r_local_fixed_recalc(0,(float)(Math.PI*2),ptc);
                ptc.flush();
                dspMenu.setEnabled(true);
                treeMenu.setEnabled(true);
            }
        }else if(e.getSource()==t_weighted){
            t_fixed.setState(false);
            t_weighted.setState(true);
            tree_mode='w';
            if(run==false && sus==false && mgtp!=null){
                dspMenu.setEnabled(false);
                treeMenu.setEnabled(false);
                //ptc.og.dispose();
                ptc.coordinate_offScr(mgtp.pt_top);
	            if(mgtp.pt_top.ds==0) mgtp.pt_top.leaf_calc();
                if(disp_mode=='t') mgtp.pt_top.weighted_offdraw(0,mgtp.pt_top.ds,cvw_width,cvw_width,ptc);
	            else if(disp_mode=='r') mgtp.pt_top.r_weighted_offdraw(0,mgtp.pt_top.ds,(float)(Math.PI*2),(float)(Math.PI*2),ptc);
	            else if(disp_mode=='l') mgtp.pt_top.r_local_weighted_offdraw(0,mgtp.pt_top.ds,(float)(Math.PI*2),(float)(Math.PI*2),ptc);
	            ptc.flush();
	            dspMenu.setEnabled(true);
                treeMenu.setEnabled(true);
            }
        }else if(e.getSource()==d_tree){
            d_tree.setState(true);
            d_radial.setState(false);
            d_rad_local.setState(false);
            disp_mode='t';
            if(run==false && sus==false && mgtp!=null){
                dspMenu.setEnabled(false);
                treeMenu.setEnabled(false);
                //ptc.og.dispose();
                ptc.coordinate_offScr(mgtp.pt_top);
                mgtp.pt_top.step=(float)cvw_height/(mgtp.pt_top.max_gene+2);
                mgtp.pt_top.y_recalc(null,ptc,false);
                if(tree_mode=='f'){
                    mgtp.pt_top.fixed_recalc(0,cvw_width,ptc);
                }else if(tree_mode=='w'){
                    if(mgtp.pt_top.ds==0) mgtp.pt_top.leaf_calc();
	                mgtp.pt_top.weighted_offdraw(0,mgtp.pt_top.ds,cvw_width,cvw_width,ptc);
                }
                ptc.flush();
                dspMenu.setEnabled(true);
                treeMenu.setEnabled(true);
            }else if(run==false && sus==true && mgtp!=null){
                mgtp.pt_top.sc.redraw();
                mgtp.pt_top.sc.ntfy();
            }
        }else if(e.getSource()==d_radial){
            d_tree.setState(false);
            d_radial.setState(true);
            d_rad_local.setState(false);
            disp_mode='r';
            if(run==false && sus==false && mgtp!=null){
                dspMenu.setEnabled(false);
                treeMenu.setEnabled(false);
                //ptc.og.dispose();
                ptc.coordinate_offScr(mgtp.pt_top);
                if(cvw_height<cvw_width) mgtp.pt_top.step=(float)cvw_height/(mgtp.pt_top.max_gene+1)/2;
                else mgtp.pt_top.step=(float)cvw_width/(mgtp.pt_top.max_gene+1)/2;
                mgtp.pt_top.r_recalc(null,ptc,false);
                if(tree_mode=='f'){
                    mgtp.pt_top.r_fixed_recalc(0,(float)(Math.PI*2),ptc);
                }else if(tree_mode=='w'){
                    if(mgtp.pt_top.ds==0) mgtp.pt_top.leaf_calc();
	                mgtp.pt_top.r_weighted_offdraw(0,mgtp.pt_top.ds,(float)(Math.PI*2),(float)(Math.PI*2),ptc);
                }
                 ptc.flush();
                 dspMenu.setEnabled(true);
                treeMenu.setEnabled(true);
            }else if(run==false && sus==true && mgtp!=null){
                mgtp.pt_top.sc.redraw();
                mgtp.pt_top.sc.ntfy();
            }
        }else if(e.getSource()==d_rad_local){
            d_tree.setState(false);
            d_radial.setState(false);
            d_rad_local.setState(true);
            disp_mode='l';
            if(run==false && sus==false && mgtp!=null){
                dspMenu.setEnabled(false);
                treeMenu.setEnabled(false);
                //ptc.og.dispose();
                ptc.coordinate_offScr(mgtp.pt_top);
                if(cvw_height<cvw_width) mgtp.pt_top.step=(float)cvw_height/(mgtp.pt_top.max_gene+1)/2;
                else mgtp.pt_top.step=(float)cvw_width/(mgtp.pt_top.max_gene+1)/2;
                //mgtp.pt_top.r_local_recalc(cvw_width/2,cvw_height/2,null,ptc,false);
                if(tree_mode=='f'){
                    mgtp.pt_top.r_local_fixed_recalc(0,(float)(Math.PI*2),ptc);
                }else if(tree_mode=='w'){
                    if(mgtp.pt_top.ds==0) mgtp.pt_top.leaf_calc();
	                mgtp.pt_top.r_local_weighted_offdraw(0,mgtp.pt_top.ds,(float)(Math.PI*2),(float)(Math.PI*2),ptc);
                }
                 ptc.flush();
                 dspMenu.setEnabled(true);
                treeMenu.setEnabled(true);
            }else if(run==false && sus==true && mgtp!=null){
                mgtp.pt_top.sc.redraw();
                mgtp.pt_top.sc.ntfy();
            }
        }else if(e.getSource()==e_cmgtp){
            e_cmgtp.setState(true);
            //e_mgtp.setState(false);
            e_cmgtpPickupMin.setState(false);
            engine='c';
        }else if(e.getSource()==e_cmgtpPickupMin){
            e_cmgtpPickupMin.setState(true);
            e_cmgtp.setState(false);
            //e_mgtp.setState(false);
            engine='p';
        }else if(e.getSource()==zoomChoice){
            cur_select_zoom=zoomChoice.getSelectedIndex();
            switch(cur_select_zoom){
                case 0:
                    ptc.cur_mult_h=ptc.cur_mult_v=1;
                    break;
                case 1:
                    ptc.cur_mult_h=ptc.cur_mult_v=2;
                    break;
                case 2:
                    ptc.cur_mult_h=ptc.cur_mult_v=4;
                    break;    
                case 3:
                    ptc.cur_mult_h=ptc.cur_mult_v=10;
                    break;    
                case 4:
                    ptc.cur_mult_h=ptc.cur_mult_v=50;
                    break;    
                case 5:
                    ptc.cur_mult_h=ptc.cur_mult_v=100;
                    break;    
                case 6:
                    CMDialog cmDialog=new CMDialog(this);
                    cmDialog.show();
                    break;                         
                //default:
            }
            if(ptc.cur_mult_h!=ptc.old_mult_h || ptc.cur_mult_v!=ptc.old_mult_v){
                zoom_h_txt.setText(Float.toString(ptc.cur_mult_h));
                zoom_v_txt.setText(Float.toString(ptc.cur_mult_v));
                ptc.zoom_select=true;
                reset_button.setLabel("Cancel");
                reset_button.setEnabled(true);
                ptc.setCursor(ptc.cursor.getPredefinedCursor(Cursor.CROSSHAIR_CURSOR));
                ptc.rect_width=(int)(cvw_width*ptc.old_mult_h/ptc.cur_mult_h+0.5);
                ptc.rect_height=(int)(cvw_height*ptc.old_mult_v/ptc.cur_mult_v+0.5);
            }
        }

    }
    
    class CMDialog extends Dialog implements ActionListener,TextListener{
        Panel panel;
        TextField h_text,v_text;
        Label h_label,v_label;
        Button okButton,cancelButton;
        boolean h_n_flag=true,v_n_flag=true;
        float h,v;
        CMDialog(Frame f){
            super(f,"Custom Multi Dialog",true);
            //setLayout(new BorderLayout(10,10));
            h=ptc.cur_mult_h;
            v=ptc.cur_mult_v;
            GridBagLayout gbl=new GridBagLayout();
            panel=new Panel(gbl);
            GridBagConstraints c = new GridBagConstraints();
            c.ipady=5;
            c.ipadx=5;
//            c.insets=10;
            c.fill=GridBagConstraints.HORIZONTAL;
            h_label=new Label(" mult H ",Label.CENTER);
            v_label=new Label(" mult V ",Label.CENTER);
            h_text=new TextField(Float.toString(h),8);
            v_text=new TextField(Float.toString(v),8);
            h_text.addTextListener(this);
            v_text.addTextListener(this);
            okButton=new Button("OK");
            cancelButton=new Button("Cancel");
            okButton.addActionListener(this);
            cancelButton.addActionListener(this);
            add(panel,"Center");
            c.gridx=0;c.gridy=0;
            gbl.setConstraints(h_label,c);
            panel.add(h_label);
            panel.add(h_text);
            panel.add(v_label);
            panel.add(v_text);
            c.gridx=2;c.gridy=1;
            gbl.setConstraints(okButton,c);            
            panel.add(okButton);
            c.gridx=3;c.gridy=1;
            gbl.setConstraints(cancelButton,c);
            panel.add(cancelButton);
            pack();
            setResizable(false);
            addWindowListener(new cmdl());
        }
        
        class cmdl extends WindowAdapter{
            public void windowClosing(WindowEvent e){
                zoomChoice.select(old_select_zoom);
                cur_select_zoom=old_select_zoom;
                dispose();                
            }
        }
        
        public void actionPerformed(ActionEvent e){
            if(e.getSource()==okButton){
                ptc.cur_mult_h=h;
                ptc.cur_mult_v=v;
                dispose();
            }else if(e.getSource()==cancelButton){
                zoomChoice.select(old_select_zoom);
                cur_select_zoom=old_select_zoom;
                dispose();
            }
        }
        
        public void textValueChanged(TextEvent e){
            if(e.getSource()==h_text){
                try{
                    h=(Float.valueOf(h_text.getText())).floatValue();
                    h_n_flag=true;
                }catch(NumberFormatException nfe){
                    h_n_flag=false;
                }
            }else if(e.getSource()==v_text){
                try{
                    v=(Float.valueOf(h_text.getText())).floatValue();
                    v_n_flag=true;
                }catch(NumberFormatException nfe){
                    v_n_flag=false;
                }  
            }
            if(h_n_flag && v_n_flag) okButton.setEnabled(true);
            else okButton.setEnabled(false);
            
        }
    }
    
    class PTWindowListener extends WindowAdapter {
	    public void windowClosing(WindowEvent e) {
	        if(pt!=null){
	            if(pt.pv!=null) pt.pv.stop();
	            pt.stop();
	        }
	        dispose();
	        System.exit(0);
	    }
    }



    void readf_button_Clicked() {
        readf_txt.setText("open file");
	    FileDialog fd=new FileDialog(this, "Open");
	    fd.setDirectory(dir1);
	    fd.setFilenameFilter(new MGFileFilter());
	    fd.show();
	    if(fd.getFile()!=null){
	        fil1=fd.getFile();
	        dir1=fd.getDirectory();
	        System.out.println("My Dir ="+dir1);
	    }
      	String filename = dir1+fil1;
	    readf_txt.setText(fil1);
    }


  void run_button_Clicked() {
    int i=1;
    o_verbose.setEnabled(false);
    o_allSol.setEnabled(false);
    o_selectMin.setEnabled(false);
    o_compileExt.setEnabled(false);
    if(o_verbose.getState()) i++;
    if(o_allSol.getState()) i++;
    if(o_selectMin.getState()) i++;
    if(o_compileExt.getState()) i++;
	String[] args=new String[i];
	System.out.print("Now reading file: " + dir1 + fil1 + "...\n");
	args[0]=dir1+fil1;
	i=0;
	if(o_verbose.getState()) {i++;args[i]="verbose";}
    if(o_allSol.getState()) {i++;args[i]="all";}
    if(o_selectMin.getState()) {i++;args[i]="min";}
    if(o_compileExt.getState()) {i++;args[i]="ext";}
    o_verbose.setEnabled(true);
    o_allSol.setEnabled(true);
    o_selectMin.setEnabled(true);
    o_compileExt.setEnabled(true);
	if(sus) {
        pt.pv.stop();
        pt.stop();
        sus=false;
        stop_button.setLabel("   Stop   ");
    }
    pt= new ProveT(this,args);
    pt.setPriority(Thread.MIN_PRIORITY);
    pt.start();
  }

  
}

class Prove extends Thread{
    String[] a;
    MGTP m;
    PTCanvas p;
    ProveT pt;
    java.io.FileInputStream fis=null;
    Prove(String args[],PTCanvas ptc,ProveT ptree){a=args;p=ptc;pt=ptree;}
    MGTP init(){
    System.out.println(MGTP.version);
    System.out.println(MGTP.copyRight);

    MGTP.verbose=false;
    MGTP.allSol=false;
    MGTP.selectMin=false;
    MGTP.compileExt=false;

    MGTP.setupOptions(a);
    //java.io.FileInputStream fis=null;
    try {
      fis=new java.io.FileInputStream(MGTP.ifile);
    } catch (java.io.FileNotFoundException e) {
      System.out.println("File "+MGTP.ifile+" not found.");
      return null;
    }
    if(pt.ptv.engine=='c') m=new MGTP(this);
    else if(pt.ptv.engine=='p') m=new MGTPpickupMin(this);
    
    //m=(MGTP.selectMin ? new MGTPpickupMin(this) : new MGTP(this));
    MGTP.mgtp=m;
      //m=new MGTP(this);
    //GT.ptm=m;
	return m;}
    public void run(){
	    MGTP.ptv_main(a,fis);
	    m.pt_top.sc.ntfy();
	    stop();
    }
}

class ProveT extends Thread{
    PTVisualizer ptv;
    String[] args;
    Prove pv;
    GT cur;
    boolean flag;
    ProveT(PTVisualizer ptvis,String[] a){ptv=ptvis;args=a;}
    public void run(){
        ptv.readf_txt.setEnabled(false);
        ptv.readf_button.setEnabled(false);
        ptv.run=true;
        ptv.run_button.setEnabled(false);
        pv=new Prove(args,ptv.ptc,this);
        pv.setPriority(MIN_PRIORITY);
        ptv.stop_button.setEnabled(true);
        ptv.mgtp=pv.init();
        ptv.ptc.zoomReset();
        ptv.ptc.coordinate_offScr(pv.m.pt_top);
	    pv.start();
        flag=true;
        cur=null;
        ptv.mgtp.pt_top.redraw_flag=false;
        while(flag){
            if(ptv.disp_mode=='t') {
                ptv.mgtp.pt_top.step=(float)(ptv.cvw_height/(ptv.mgtp.pt_top.max_gene+2.0));
                try{
                    ptv.mgtp.pt_top.position_calc(0,ptv.cvw_width,ptv.cvw_height,ptv.ptc,cur);
                    flag=false;
                }catch(DispModeException e){
                    cur=e.gt;
                    //ptv.ptc.og.dispose();
                    ptv.ptc.coordinate_offScr(ptv.mgtp.pt_top);
                    ptv.dspMenu.setEnabled(false);
                }
            }else if(ptv.disp_mode=='r') {
                try{
                    if(ptv.cvw_height<ptv.cvw_width){
                        ptv.mgtp.pt_top.step=(float)(ptv.cvw_height/2.0/(ptv.mgtp.pt_top.max_gene+1.0));
                        ptv.mgtp.pt_top.radial_position_calc(0,(float)Math.PI*2,(int)(ptv.cvw_height/2.0),ptv.ptc,cur);
                    }else{
                        ptv.mgtp.pt_top.step=(float)(ptv.cvw_width/2.0/(ptv.mgtp.pt_top.max_gene+1.0));
                        ptv.mgtp.pt_top.radial_position_calc(0,(float)Math.PI*2,(int)(ptv.cvw_width/2.0),ptv.ptc,cur);
                    }
                    flag=false;
                }catch(DispModeException e){
                    cur=e.gt;
                    //ptv.ptc.og.dispose();
                    ptv.ptc.coordinate_offScr(ptv.mgtp.pt_top);
                    ptv.dspMenu.setEnabled(false);
                }
            }else if(ptv.disp_mode=='l') {
                try{
                    if(ptv.cvw_height<ptv.cvw_width){
                        ptv.mgtp.pt_top.step=(float)(ptv.cvw_height/2.0/(ptv.mgtp.pt_top.max_gene+1.0));
                        ptv.mgtp.pt_top.rad_local_position_calc(0,(float)Math.PI*2,(int)(ptv.cvw_height/2.0),ptv.ptc,cur);
                    }else{
                        ptv.mgtp.pt_top.step=(float)(ptv.cvw_width/2.0/(ptv.mgtp.pt_top.max_gene+1.0));
                        ptv.mgtp.pt_top.rad_local_position_calc(0,(float)Math.PI*2,(int)(ptv.cvw_width/2.0),ptv.ptc,cur);
                    }
                    flag=false;
                }catch(DispModeException e){
                    cur=e.gt;
                    //ptv.ptc.og.dispose();
                    ptv.ptc.coordinate_offScr(ptv.mgtp.pt_top);
                    ptv.dspMenu.setEnabled(false);
                }
            }
        }
	//    ptv.ptc.og.dispose();
	    System.out.println("end");
	    ptv.treeMenu.setEnabled(false);
	    if(ptv.tree_mode=='w'){
	        ptv.dspMenu.setEnabled(false);
	        //ptv.ptc.og.dispose();
            ptv.ptc.coordinate_offScr(ptv.mgtp.pt_top);
	        ptv.mgtp.pt_top.leaf_calc();
	       // System.out.println("calc");
	        if(ptv.disp_mode=='t') 
	            ptv.mgtp.pt_top.weighted_offdraw(0,ptv.mgtp.pt_top.ds,ptv.cvw_width,ptv.cvw_width,ptv.ptc);
	        else if(ptv.disp_mode=='r')ptv.mgtp.pt_top.r_weighted_offdraw(0,ptv.mgtp.pt_top.ds,(float)Math.PI*2,(float)Math.PI*2,ptv.ptc);
	        else if(ptv.disp_mode=='l')ptv.mgtp.pt_top.r_local_weighted_offdraw(0,ptv.mgtp.pt_top.ds,(float)Math.PI*2,(float)Math.PI*2,ptv.ptc);
	        ptv.dspMenu.setEnabled(true);
            
	    }
	    ptv.treeMenu.setEnabled(true);
	    ptv.ptc.repaint();
	    ptv.stop_button.setEnabled(false);
	    ptv.run_button.setEnabled(true);
	    ptv.readf_txt.setEnabled(true);
	    ptv.readf_button.setEnabled(true);
	    ptv.run=false;
	    ptv.ptc.zoom_redraw=false;
	    stop();
    }
}

class MGFileFilter implements FilenameFilter{
    public boolean accept(File dir,String name){
	    return name.endsWith(".mg");
	    //return ".mg".endsWith(name);
    }
}




class PTCanvas extends Canvas implements ItemListener,AdjustmentListener{
    int cvw_height; 	
    int cvw_width;
    //int lgw_height;
    //int lgw_width;
    Scrollbar h,v;
    float cur_mult_h=1;
    float cur_mult_v=1;
    float old_mult_h=1;
    float old_mult_v=1;
    int oval_r=4;
    int root_oval_r=5;
    float zoom_left_x=0;
    float zoom_top_y=0;
    
    Image offScr;
    Graphics og;
    int od=oval_r*2;
    int rod=root_oval_r*2;
    GT gt;
    PTVisualizer ptv;
    GTWindow gtw;
    GTWindow select_gtw;
    Cursor cursor;
    boolean zoom_select=false;
    int rect_width,rect_height;
    volatile boolean zoom_redraw=false;
    int mouse_x;
    int mouse_y;
    float scroll_value;

    PTCanvas(){}
    PTCanvas(int cvww,int cvwh,int lgww,int lgwh,PTVisualizer ptvz){
  	    cvw_height=cvwh;
  	    cvw_width=cvww;
  	    //lgw_width=lgww;
  	    //lgw_height=lgwh;
  	    ptv=ptvz;
  	    addMouseListener(new PTMouseListener());
  	    addMouseMotionListener(new PTMouseMotionListener());
  	    cursor=new Cursor(Cursor.DEFAULT_CURSOR);
    }
    void zoomReset(){
        cur_mult_h=1;
        cur_mult_v=1;
        old_mult_h=1;
        old_mult_v=1;
        ptv.zoom_h_txt.setText(Float.toString(cur_mult_h));
        ptv.zoom_v_txt.setText(Float.toString(cur_mult_v));
        ptv.cur_select_zoom=ptv.old_select_zoom=0;
        ptv.zoomChoice.select(ptv.cur_select_zoom);
        zoom_left_x=0;
        zoom_top_y=0;
        //h.setMaximum(cvw_width);
        h.setValues(0,cvw_width,0,cvw_width);
        //v.setMaximum(cvw_height);
        v.setValues(0,cvw_height,0,cvw_height);        
    }
    
    void coordinate_offScr(GT g) {
        gt=g;
        offScr=createImage(cvw_width,cvw_height);
  	    og=offScr.getGraphics();
    }
    
   /* void drawNode(){
        og.setColor(cl);
        PTfillOval(og,x-oval_r,y-oval_r,od,od);
        og.setColor(Color.black);
    } */
    void drawNode(GT g){
        og.setColor(g.p_color);
        if(g==gt) PTfillOval(og,g.x,g.y,root_oval_r,rod);
        else PTfillOval(og,g.x,g.y,oval_r,od);
        og.setColor(Color.black);
    }
    
    
    void drawBranch(float fcx,float fcy,float w,int bros,float px,float py){
        int i;
        float x=fcx;
        for(i=0;i<bros;i++,x=x+w){
            PTdrawLine(og,px,py,x,fcy);
        }
    }
    
    void rad_drawBranch(float fcx,float fcy,float r,float f,float w,int bros,float px,float py){
        PTdrawLine(og,px,py,fcx,fcy);
        if(bros>1){
            float t=f+w;
            float x;
            float y;
            for(int i=1;i<bros;i++,t=t+w){
                y=(float)(r*Math.sin(t)+cvw_height/2.0);
                x=(float)(r*Math.cos(t)+cvw_width/2.0);
                PTdrawLine(og,px,py,x,y);
            }
        }
    }
    
    void rad_local_drawBranch(float fcx,float fcy,float s,float f,float w,int bros,float px,float py){
        PTdrawLine(og,px,py,fcx,fcy);
        if(bros>1){
            float t=f+w;
            float x;
            float y;
            for(int i=1;i<bros;i++,t=t+w){
                y=py+(float)(s*Math.sin(t));
                x=px+(float)(s*Math.cos(t));
                PTdrawLine(og,px,py,x,y);
            }
        }
    }
    
    
    
    void flush(){paint(getGraphics());}

    void ptcClear(){
        if(offScr!=null) flush();
        else getGraphics().clearRect(0,0,cvw_width,cvw_height);
    }
    void PTdrawLine(Graphics g,float x,float y,float to_x,float to_y){
        int x1=(int)((x-zoom_left_x)*old_mult_h+0.5);
        int y1=(int)((y-zoom_top_y)*old_mult_v+0.5);
        int x2=(int)((to_x-zoom_left_x)*old_mult_h+0.5);
        int y2=(int)((to_y-zoom_top_y)*old_mult_v+0.5);
	    if(((x1>=0)&&(x1<=cvw_width)&&(y1>=0)&&(y1<=cvw_height))||
	      ((x2>=0)&&(x2<=cvw_width)&&(y2>=0)&&(y2<=cvw_height))){
		    g.drawLine(x1,y1,x2,y2);
	    }
    }
    
    void PTfillOval(Graphics g,float x,float y,int r,int d){
        int x1=(int)((x-zoom_left_x)*old_mult_h-r+0.5);
        int y1=(int)((y-zoom_top_y)*old_mult_v-r+0.5);
	    if((x1+d>=0)&&(x1<=cvw_width)&&(y1+d>=0)&&(y1<=cvw_height)){
		    g.fillOval(x1,y1,d,d);
		}
	}	

    void PTdrawRect(Graphics g,int x,int y,int width,int height){
        g.setColor(Color.lightGray);
        g.drawRect(x,y,width,height);
        g.setColor(Color.black);
    }
    

    public void paint(Graphics g){
  	    if(offScr!=null) {
  	        g.drawImage(offScr,0,0,this);
  	    }
    }
    
    public void itemStateChanged(ItemEvent e){
        GTWindow gtw_w=gtw;
        char w=ptv.cursor_state;
        while(gtw_w!=null){
            if(w=='n') gtw_w.setCursor(cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
            else if(w=='s') gtw_w.setCursor(cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
            if(e.getSource()==gtw_w.tn_button){
                if(gtw_w.tn_button.getState()){
                    ptv.setCursor(cursor.getPredefinedCursor(Cursor.HAND_CURSOR));
                    ptv.cursor_state='s';
                    select_gtw=gtw_w;
                    
                }else {
                    ptv.setCursor(cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                    ptv.cursor_state='n';
                    select_gtw=null;
                }
            }else{
                if(w=='n') gtw_w.tn_button.setEnabled(false);
                else if(w=='s') gtw_w.tn_button.setEnabled(true);
                
            }
            gtw_w=gtw_w.prev;
        }
    }
    
    void s_To_n(){
        GTWindow gtw_w=gtw;
        while(gtw_w!=null){
           gtw_w.setCursor(cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
           gtw_w.tn_button.setEnabled(true); 
           gtw_w=gtw_w.prev; 
        }
        ptv.setCursor(cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
        ptv.cursor_state='n';
        select_gtw=null;
    }
    void ZoomRedraw(){
        if(mouse_x>=0 && mouse_y>=0){
            zoom_left_x=zoom_left_x+mouse_x/old_mult_h-cvw_width/cur_mult_h/2;
            zoom_top_y=zoom_top_y+mouse_y/old_mult_v-cvw_height/cur_mult_v/2;
            old_mult_h=cur_mult_h;
            old_mult_v=cur_mult_v;
            h.setMaximum((int)(cur_mult_h*cvw_width));
            h.setValue((int)(zoom_left_x*cur_mult_h));
            v.setMaximum((int)(cur_mult_v*cvw_height));
            v.setValue((int)(zoom_top_y*cur_mult_v));
        }else if(mouse_x==0) zoom_left_x=scroll_value;
        else if(mouse_y==0) zoom_top_y=scroll_value;
        coordinate_offScr(gt);
        gt.zoom_Redraw(PTCanvas.this,GT.curGT);
        flush();
        ptv.old_select_zoom=ptv.cur_select_zoom;
    }
 
    class PTMouseListener extends MouseAdapter{
        public void mouseClicked(MouseEvent e){
            GT select_gt;
            int mx=e.getX();
            int my=e.getY();
            if(zoom_select){
                zoom_select=false;
                ptv.reset_button.setLabel("Reset");
                setCursor(cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
                ptcClear();
                if(ptv.run==false && ptv.mgtp!=null){
                    zoom_left_x=zoom_left_x+mx/old_mult_h-cvw_width/cur_mult_h/2;
                    zoom_top_y=zoom_top_y+my/old_mult_v-cvw_height/cur_mult_v/2;
                    coordinate_offScr(gt);
                    old_mult_h=cur_mult_h;
                    old_mult_v=cur_mult_v;
                    h.setMaximum((int)(cur_mult_h*cvw_width));
                    h.setValue((int)(zoom_left_x*cur_mult_h));
                    v.setMaximum((int)(cur_mult_v*cvw_height));
                    v.setValue((int)(zoom_top_y*cur_mult_v));
                    if(ptv.sus) gt.zoom_Redraw(PTCanvas.this,GT.curGT);
                    else gt.zoom_Redraw(PTCanvas.this);
                    flush();
                    ptv.old_select_zoom=ptv.cur_select_zoom;
                }else if(ptv.run==true){
                    zoom_redraw=true;
                    mouse_x=mx;
                    mouse_y=my;
                }
            }else{
                if(gt!=null){
                    select_gt=gt.find(zoom_left_x+mx/cur_mult_h,zoom_top_y+my/cur_mult_v,5/cur_mult_h,5/cur_mult_v);
                    if(select_gt!=null) {
                        if(ptv.cursor_state=='n') {
                            if(select_gt.p_color==Color.red){
                                GTWindow wgtw=gtw;
                                while(wgtw!=null){
                                    if(wgtw.cur_gt==select_gt){wgtw.show();break;}
                                    wgtw=wgtw.prev;
                                }
                            }else gtw=new GTWindow(select_gt,gt,PTCanvas.this,gtw);
                        }else if(ptv.cursor_state=='s'){
                            select_gtw.set_to_gt(select_gt);
                            s_To_n();
                            drawNode(select_gt);
                            flush();
                        }
                    }
                }
            }
        }
        
        public void mouseExited(MouseEvent e){
            if(zoom_select) ptcClear();
        }
        
        public void mouseEntered(MouseEvent e){
            if(zoom_select) PTdrawRect(getGraphics(),e.getX()-rect_width/2,e.getY()-rect_height/2,rect_width,rect_height);
        }
        
    }
    
    class PTMouseMotionListener extends MouseMotionAdapter{
        public void mouseMoved(MouseEvent e){
            if(zoom_select){
                ptcClear();
                PTdrawRect(getGraphics(),e.getX()-rect_width/2,e.getY()-rect_height/2,rect_width,rect_height);
            }
        }
    }
    
    public void adjustmentValueChanged(AdjustmentEvent e){
        float work;
        if(e.getSource()==h){
            work=h.getValue()/old_mult_h;
            if(zoom_left_x!=work){
                zoom_left_x=work;
                if(ptv.run==false && ptv.mgtp!=null){
                    coordinate_offScr(gt);
                    if(ptv.sus) gt.zoom_Redraw(this,GT.curGT);
                    else gt.zoom_Redraw(this);
                    flush();
                }else if(ptv.run==true){
                    zoom_redraw=true;
                    mouse_x=0;
                    mouse_y=-1;
                    scroll_value=work;
                }
            }
            //System.out.println(zoom_left_x);
        }else if(e.getSource()==v){
            work=v.getValue()/old_mult_v;
            if(zoom_top_y!=work){
                zoom_top_y=work;
                if(ptv.run==false && ptv.mgtp!=null){
                    coordinate_offScr(gt);
                    if(ptv.sus) gt.zoom_Redraw(this,GT.curGT);
                    else gt.zoom_Redraw(this);
                    flush();
                }else if(ptv.run==true){
                    zoom_redraw=true;
                    mouse_x=-1;
                    mouse_y=0;
                    scroll_value=work;
                }
            }
            //System.out.println(zoom_top_y);
        }

        
    }
}

class GTWindow extends Frame implements ActionListener{
    GT cur_gt;
    GT root_gt;
    GT to_gt;
   // CheckboxGroup cg;
    Checkbox tn_button;
    Button dpr_button;
    Button dpt_button;
    Button rev_button;
    TextArea text1;
    TextArea text2;	
    TextArea text3;	
    Label label1;
    PTCanvas ptcanvas;
    String str_cur_gt,str_to_gt,str_disp="",str_rev="";
    GTWindow next;
    GTWindow prev;
    GTWMouseListener GTWML;
    
  GTWindow(GT gt,GT rgt,PTCanvas ptc,GTWindow prev_gtw){
	   super("Node Display Window : "+gt.m.hd);
	   ptcanvas=ptc;
	   prev=prev_gtw;
	   if(prev!=null) prev.next=this;
	   cur_gt=gt;
	   str_cur_gt=cur_gt.unparseS_txtF(0);
	   root_gt=rgt;
	   cur_gt.old_color=cur_gt.p_color;
	   cur_gt.p_color=Color.red;
	   ptcanvas.drawNode(cur_gt);
	   ptcanvas.flush();
	   addWindowListener(new GTWindowListener());
	   GTWML=new GTWMouseListener();
	   //addMouseListener(new GTWMouseListener());
	   setup();
//	   text1.setText(str_cur_gt);
	//   pack();
	   setSize(400,500);
	   setResizable(false);
	   show();
  }
  
  void setup() {
       Panel mainPanel = new Panel();
       Panel panels[] = new Panel[3];
       for (int i=0;i<3;++i){
      	    panels[i] = new Panel();
    	 //   panels[i].setLayout(new FlowLayout(FlowLayout.LEFT));
       }
 //    System.out.println("PANEL SETUPPED.");
       GridBagLayout gl;
       panels[0].setLayout(gl= new GridBagLayout());
       GridBagConstraints c = new GridBagConstraints();
       c.anchor=GridBagConstraints.NORTH;
       c.insets=new Insets(5,0,5,0);
       //c.fill=GridBagConstraints.HORIZONTAL;
       label1=new Label("cur  node",Label.RIGHT);
       text1=new TextArea(str_cur_gt,1,30,TextArea.SCROLLBARS_HORIZONTAL_ONLY);
       c.gridx=c.gridy=0;
       gl.setConstraints(label1,c);
       panels[0].add(label1);
       c.gridx=1;
       gl.setConstraints(text1,c);
       panels[0].add(text1);
       text1.setEditable(false);
       //cg=new CheckboxGroup();
       tn_button=new Checkbox("select  node");
       text2=new TextArea("",1,30,TextArea.SCROLLBARS_HORIZONTAL_ONLY);
        c.gridy=1;
        c.gridx=0;
       gl.setConstraints(tn_button,c);
       tn_button.addItemListener(ptcanvas);
       panels[0].add(tn_button);
       c.gridx=1;
       gl.setConstraints(text2,c);
       panels[0].add(text2);
       text2.setEditable(false);
       dpr_button=new Button("disp root");
       dpt_button=new Button(" disp  to  ");
       rev_button=new Button("   rev  ");
       dpr_button.addActionListener(this);
       dpt_button.addActionListener(this);
       rev_button.addActionListener(this);
       panels[1].add(dpr_button);
       panels[1].add(dpt_button);
       panels[1].add(rev_button);
       panels[2].add(text3=new TextArea(20,44));
       for (int i=0;i<3;++i){
            panels[i].addMouseListener(GTWML);
     	    mainPanel.add(panels[i]);
  	    add("Center",mainPanel);
       }
       mainPanel.addMouseListener(GTWML);
       label1.addMouseListener(GTWML);
  }
  
    void set_to_gt(GT tgt){
        if(to_gt!=null) if(to_gt.p_color!=Color.red){
            to_gt.p_color=to_gt.old_color;
            ptcanvas.drawNode(to_gt);
        }
        to_gt=tgt;
        str_to_gt=to_gt.unparseS_txtF(0);
        text2.setText(str_to_gt);
        if(to_gt.p_color!=Color.red) {
	  to_gt.old_color=to_gt.p_color;
	  to_gt.p_color=Color.yellow;
	}
        tn_button.setState(false);
        show();
    }
    
    public void actionPerformed(ActionEvent e){
        if(e.getSource()==dpr_button){
            str_disp="";
            str_rev="";
            GT wgt=cur_gt;            
            while(true){
                str_rev=wgt.unparseS_txtF(0)+"\n"+str_rev;
                str_disp=str_disp+wgt.unparseS_txtF(0)+"\n";
                if(wgt.par==null) break;
                wgt=wgt.par;
            }
//            str_rev=root_gt.unparseS_txtF(0)+"\n"+str_rev;
//            str_disp=str_disp+root_gt.unparseS_txtF(0)+"\n";
            text3.setText(str_disp);
        }else if(e.getSource()==rev_button){
            text3.setText(str_rev);
        }else if(e.getSource()==dpt_button && to_gt!=null){
            str_disp="";
            str_rev="";
            GT wgt; 
            if(cur_gt.gene>=to_gt.gene){
                wgt=cur_gt;
                while(true){
                    str_rev=wgt.unparseS_txtF(0)+"\n"+str_rev;
                    str_disp=str_disp+wgt.unparseS_txtF(0)+"\n";
                    if(wgt==to_gt) break;
                    if(wgt.par==null){
//                        if(to_gt==root_gt){
//                            str_rev=root_gt.unparseS_txtF(0)+"\n"+str_rev;
//                            str_disp=str_disp+root_gt.unparseS_txtF(0)+"\n"; 
//                        }else{
                            str_disp="";
                            str_rev="";
//                        }
                        break;
                    }
                    wgt=wgt.par;
                }
            }else{
                wgt=to_gt;
                while(true){
                    str_disp=wgt.unparseS_txtF(0)+"\n"+str_disp;
                    str_rev=str_rev+wgt.unparseS_txtF(0)+"\n";
                    if(wgt==cur_gt) break;
                    if(wgt.par==null){
                        if(cur_gt==root_gt){
                            str_disp=root_gt.unparseS_txtF(0)+"\n"+str_disp;
                            str_rev=str_rev+root_gt.unparseS_txtF(0)+"\n"; 
                        }else{
                            str_disp="";
                            str_rev="";
                        }
                        break;
                    }
                    wgt=wgt.par;
                }
            }
            text3.setText(str_disp);
        }
    }
    
    class GTWindowListener extends WindowAdapter {
	    public void windowClosing(WindowEvent e){
	        cur_gt.p_color=cur_gt.old_color;
	        ptcanvas.drawNode(cur_gt);
	        if(to_gt!=null)if(to_gt.p_color==Color.yellow){
                to_gt.p_color=to_gt.old_color;
                ptcanvas.drawNode(to_gt);
            }
	        ptcanvas.flush();
	        if(prev!=null) prev.next=next;
	        if(next!=null) next.prev=prev;
	        if(ptcanvas.select_gtw==GTWindow.this){
	            ptcanvas.select_gtw=null;
	            GTWindow wgtw=ptcanvas.gtw;
	            ptcanvas.ptv.setCursor(ptcanvas.cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	            ptcanvas.ptv.cursor_state='n';
	            while(wgtw!=null){
	                wgtw.tn_button.setEnabled(true);
	                wgtw.setCursor(ptcanvas.cursor.getPredefinedCursor(Cursor.DEFAULT_CURSOR));
	                wgtw=wgtw.prev;
	            }
	        }
	        dispose();
	    }
    }
    
    class GTWMouseListener extends MouseAdapter{
        public void mouseClicked(MouseEvent e){
            //System.out.println("clicked");
             if(ptcanvas.ptv.cursor_state=='s'){
                        //System.out.println("s");
                        ptcanvas.select_gtw.set_to_gt(cur_gt);
                        ptcanvas.s_To_n();
                        ptcanvas.drawNode(cur_gt);
                        ptcanvas.flush();
             }
        }
    }
    
}

class DispModeException extends Exception{
    GT gt;
    DispModeException(GT cur){super("change Display mode.");gt=cur;}
}


class STWindow extends Frame{
    GT cur_gt;
    GT root_gt;
    MGTP mgtp;
   // CheckboxGroup cg;


    Label label1,label2,label3,label4,label5,label6;
    TextField text1,text2,text3,text4,text5,text6;
    
  STWindow(MGTP mg){
       //Date d=new Date();
	   super();
	   mgtp=mg;
	   Date d=new Date();
	   DateFormat df=DateFormat.getTimeInstance(DateFormat.DEFAULT,Locale.JAPANESE);
	   setTitle("Status: "+df.format(d));
	   setup();
	   addWindowListener(new STWindowListener());
	   displaystatus();
//	   text1.setText(str_cur_gt);
           pack();
	   //   setSize(400,500);
	   setResizable(false);
	   show();
  }
  
  void setup() {
       GridBagLayout gl;
       Panel mainPanel= new Panel(new FlowLayout());
       mainPanel.setLayout(gl= new GridBagLayout());
       GridBagConstraints c = new GridBagConstraints();
       c.anchor=GridBagConstraints.WEST;
       //c.insets=new Insets(5,0,5,0);
       label1=new Label("Max Depth");
       label2=new Label("Cur Depth");
       label3=new Label("Cur Atom",Label.CENTER);
       label4=new Label("Failed Br");
       label5=new Label("Success Br");
       label6=new Label("Atoms");
       text1=new TextField(8);
       text2=new TextField(8);
       text3=new TextField(8);
       text4=new TextField(8);
       text5=new TextField(8);
       text6=new TextField(8);
       c.gridx=0;c.gridy=0;
       gl.setConstraints(label1,c);
       mainPanel.add(label1);
       c.gridx=1;c.gridy=0;
       gl.setConstraints(text1,c);
       mainPanel.add(text1);
       c.gridx=0;c.gridy=1;
       gl.setConstraints(label2,c);
       mainPanel.add(label2);
       c.gridx=1;c.gridy=1;
       gl.setConstraints(text2,c);
       //text3.setText("12345678");
       mainPanel.add(text2);

       c.gridx=0;c.gridy=2;
       gl.setConstraints(label4,c);
       mainPanel.add(label4);
       c.gridx=1;c.gridy=2;
       gl.setConstraints(text4,c);
       mainPanel.add(text4);
       c.gridx=0;c.gridy=3;
       gl.setConstraints(label5,c);
       mainPanel.add(label5);
       c.gridx=1;c.gridy=3;
       gl.setConstraints(text5,c);
       mainPanel.add(text5);
       c.gridx=0;c.gridy=4;
       gl.setConstraints(label6,c);
       mainPanel.add(label6);
       c.gridx=1;c.gridy=4;
       gl.setConstraints(text6,c);
       mainPanel.add(text6);
       c.gridx=0;c.gridy=5;
       c.gridwidth=2;
       c.fill=GridBagConstraints.HORIZONTAL;
       gl.setConstraints(label3,c);       
       mainPanel.add(label3);
       c.gridx=0;c.gridy=6;
       c.gridwidth=2;
        c.fill=GridBagConstraints.HORIZONTAL;
        gl.setConstraints(text3,c);
        mainPanel.add(text3);       

       add("Center",mainPanel);
  }

  

  void displaystatus(){
    try{
      text1.setText(rAdjust(Integer.toString(GT.max_gene),8));
      text2.setText(rAdjust(Integer.toString(mgtp.curGT.gene),8));
      text3.setText(""+mgtp.curGT.m.hd);
      text4.setText(rAdjust(Integer.toString(mgtp.failedBranches),8));
      text5.setText(rAdjust(Integer.toString(mgtp.models),8));
      text6.setText(rAdjust(Integer.toString(mgtp.atoms),8));
    }catch(NullPointerException e){
    }
    
  }

  String rAdjust(String str,int cls){
    int bn=cls-str.length();
    System.out.println(bn);
    String s="";
    while(bn!=0){
      s=s+"  ";
      bn--;
    }
    return  s+str;
  }


    class STWindowListener extends WindowAdapter {
	    public void windowClosing(WindowEvent e){
	        dispose();
	    }
    }
    
}
