/**
 * TMNode.java Version 32g 20-Nov-1998
 * Copyright (c) 1997, 1998 Kyushu University
 *
 * Based on Version 27cT 11-Aug-1998
 *  * Skip pointer test version //R.H. 98.08.04
 *  * matchTMBV (ant CT: ATermL/ITermL/FVarL/BVarL's next=successor)
 *    test version //R.H. 98.08.11
 *  * cl.unsat --> mgtp.closed //R.H. 98.08.16
 */

class TMNode {
  public static int PREDS,FUNCS;
  public static TMNode NIL=new TMNode();
  public static boolean createOn;

  TMNode up,downL,downR,left,right;
  ACell ndac;
  TMNode[] farray;
  Term uterm;
  SkipList skip;

  TMNode() {}
  TMNode(String s) { // Top node
    Counter.index++;
    up=downL=left=right=NIL; downR=this; ndac=ACell.OFF;
    farray=new TMNode[PREDS];
    uterm=new ATermL("Top");
  }

  public String toString() {return toString(0);}
  //public String toString() {return toString1();}
  String toString(int i) {
    if (this==NIL) return "";
    String s="";
    for (int j=0; j<i; j++) s+=" ";
    s+=(uterm.name==null ? ""+((ITerm)uterm).val : uterm.name);
    if (downL!=NIL) s+="\n"+downL.toString(i+1);
    if (right!=NIL) s+="\n"+right.toString(i);
    return s;
  }

  /*
  public String toStringR() {return toStringR(0);}
  String toStringR(int i) {
    if (this==NIL) return "";
    String s="";
    for (int j=0; j<i; j++) s+=" ";
    s+=(uterm.name==null ? ""+((ITerm)uterm).val : uterm.name);
    if (downR!=NIL) s+="\n"+downR.toStringR(i+1);
    if (left!=NIL) s+="\n"+left.toStringR(i);
    return s;
  }

  public String toStringAc() {return toStringAc(0);}
  String toStringAc(int i) {
    if (this==NIL) return "";
    String s="";
    if (ndac.act) {
      for (int j=0; j<i; j++) s+=" ";
      s+=(uterm.name==null ? ""+((ITerm)uterm).val : uterm.name);
    }
    if (downL!=NIL) s+="\n"+downL.toStringAc(i+1);
    if (right!=NIL) s+="\n"+right.toStringAc(i);
    return s;
  }

  String toString1() {
    //System.out.println(this.getClass().getName()+" uterm: "+uterm);
    return (this==NIL ? "" : 
	    (uterm.name==null ? ""+((ITerm)uterm).val : uterm.name));
  }
  */

  void mkSkip(Term t, TMNode n) {
    SkipList sl;
    if (t instanceof CCTerm) 
       ((CCTerm)t).skipl=sl=new SkipList(n,skip);
    else sl=new SkipList(t,n,skip);
    skip=sl;
    //        printSkl(sl);
  }

  void printSkl(SkipList sl) {
    String s="";
    while(sl!=null) {
      s=s+sl.term+(sl.tl!=null ? ", " : "");
      sl=sl.tl;
    }
    //System.out.println("Skiplist: "+s);
  }

  TMNode findNode(Term t) {
    if (downL==NIL) return null;
    TMNode n=downL;
    while (n!=NIL) {
      if (t instanceof ITerm) {
	if (((ITerm)n.uterm).val==((ITerm)t).val) return n;
      }
      else if (n.uterm.name==t.name) return n;
      n=n.right;  
    }
    return null;  
  }


  /************ indexBV **********************/

  GTerm indexBV(Term t) {
    Counter.indexBV++;
    Counter.index++;
  
    Term tt; TMLeaf lf; TMNode n;


    if (t instanceof GNLiteral) {
      tt=((GNLiteral)t).atm;
      n=farray[tt.index];
      if (n!=null) {
        createOn=false;
	lf=(TMLeaf)n.ixBVL(tt.arg);
      }
      else {
	createOn=true;
	n=farray[tt.index]=downR=downR.right=
	  new PTMNode(tt,this,downR);
        lf=(TMLeaf)n.crDBVL(tt.arg);
      }
      if (createOn) {
	Counter.indexBVCR++;
	lf.term=(GTerm)tt; lf.term.up=lf;
	//System.out.println("t= "+t+" , uterm= "+lf.uterm+" , grounded t = "+lf.term);
	return lf.nlit=(GNLiteral)t;
      } else if (lf.nlit==null) {
	((GNLiteral)t).atm=lf.term; // essential!!  98.07.27
	return lf.nlit=(GNLiteral)t;
      } else return lf.nlit;
    } else if (t instanceof NCTermF) {
      n=farray[t.index];
      if (n!=null) {
	createOn=false;
	lf=(TMLeaf)n.ixBVL(t.arg);
      }
      else {
	createOn=true;
	n=farray[t.index]=downR=downR.right=
	  new PTMNode(t,this,downR);
        lf=(TMLeaf)n.crDBVL(t.arg);
      }
      if (createOn) {
	Counter.indexBVCR++;
	Counter.groundTM++;
	lf.term=(GTerm)t.ground();
	lf.term.up=lf;
	//System.out.println("t= "+t+" , uterm= "+lf.uterm+" , grounded t = "+lf.term);
      }
      if (lf.nlit==null)
	return lf.nlit=
               new GNLiteral(lf.term,((NCTermF)t).Cls);
      return lf.nlit;
    } else {
      n=farray[t.index];
      if (n!=null) {
	createOn=false;
	lf=(TMLeaf)n.ixBVL(t.arg);
      }
      else {
	createOn=true;
	n=farray[t.index]=downR=downR.right=
	  new PTMNode(t,this,downR);
        lf=(TMLeaf)n.crDBVL(t.arg);
      }
      //      System.out.println("t= "+t+" ,lf.term= "+lf.term);
      if (createOn) {
	Counter.indexBVCR++;
	if (t instanceof GCTermF) {
	  lf.term=(GTerm)t;
	  lf.term.up=lf;
	} else { // t instanceof CTermF
	  Counter.groundTM++;
	  lf.term=(GTerm)t.ground();
	  lf.term.up=lf;
	  //System.out.println("t= "+t+" , uterm= "+lf.uterm+" , grounded t = "+lf.term);
	}
      }
      if (t instanceof GCTermF) 
	lf.term.Cls=((GCTermF)t).Cls; // H.F. 20-Nov-98
      else lf.term.Cls=((CTermF)t).Cls; // H.F. 20-Nov-98
      return lf.plit=lf.term;
    }
  }

  /*******  ixBV/ixBVL ***************************/

  private TMNode ixBV(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("ixBV: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);
    n=farray[tt.index];

    if (n!=null || (tt.index==0 && (n=findNode(tt))!=null)) {
                         // My Node exists
      //    if (n!=null) { // My Node exists
      if (tt.arg==null) { // I am AT
	if (t.next==null) // ST Leaf
	  return n;
	else 
	  return n.ixBV(t.next); // Through the value from t.next
      } 
      else { // I am Func
	if (t.next==null) { // CTL : without next
	  l=n.ixBV(tt.arg);
	  if (createOn) {
	    //System.out.println(" func: "+n+" to be added "+l);
	    n.mkSkip(tt,l);
	    //System.out.println("skip: "+n.skip);
	  }
	  return l;
	} 
	else { // CT : with next
	  l=n.ixBV(tt.arg);
	  if (createOn) {
	    //System.out.println(" func: "+n+" to be added "+l);
	    n.mkSkip(tt,l);
	    //System.out.println("skip: "+n.skip);           
	  }
	  return l.ixBV(t.next); // Through the value from t.next
	}
      }
    } 
    createOn=true;
    if (downR!=NIL) return crDRBV(t);
    else return crDBV(t);
  }

  private TMNode ixBVL(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("ixBV: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);
    n=farray[tt.index];

    if (n!=null || (tt.index==0 && (n=findNode(tt))!=null)) {
                         // My Node exists
      //    if (n!=null) { // My Node exists
      if (tt.arg==null) { // I am AT
	if (t.next==null) // Leaf
	  return n;
	else 
	  return n.ixBVL(t.next); // Through the value from t.next
      } 
      else { // I am Func
	if (t.next==null) { // CTL : without next
	  l=n.ixBVL(tt.arg);
	  if (createOn) {
	    //System.out.println(" func: "+n+" to be added "+l);
	    n.mkSkip(tt,l);
	    //System.out.println("skip: "+n.skip);
	  }
	  return l;
	} 
	else { // CT : with next
	  l=n.ixBV(tt.arg);
	  if (createOn) {
	    //System.out.println(" func: "+n+" to be added "+l);
	    n.mkSkip(tt,l);
	    //System.out.println("skip: "+n.skip);
	  }
	  return l.ixBVL(t.next); // Through the value from t.next
	}
      }
    }
    createOn=true;
    if (downR!=NIL) return crDRBVL(t);
    else return crDBVL(t);
  }

  /*******  crDBV/crDBVL/crDRBV/crDRBVL ***************************/

  private TMNode crDBV(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("crDBV: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);

    if (tt.arg==null) { // I am AT
      if (tt.index==0) n=downR=downL=new ATMNode(tt,this);
      else n=farray[tt.index]=downR=downL=new ATMNode(tt,this);
      if (t.next==null) // ST Leaf
	return n;
      else 
	return n.crDBV(t.next); // Through the value from t.next
    } 
    else { // I am Func
      n=farray[tt.index]=downR=downL=new FTMNode(tt,this);
      if (t.next==null) { // CTL : without next
	l=n.crDBV(tt.arg);
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l;
      } 
      else { // CT : with next
	l=n.crDBV(tt.arg);
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l.crDBV(t.next); // Through the value from t.next
      }
    }
  }

  private TMNode crDBVL(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("crDBVL: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);

    if (tt.arg==null) { // I am AT
      if (t.next==null) { // Leaf
	if (tt.index==0) n=downR=downL=new TMLeaf(tt,this);
	else n=farray[tt.index]=downR=downL=new TMLeaf(tt,this);
	return n;
      }
      else {
	if (tt.index==0) n=downR=downL=new ATMNode(tt,this);
	else n=farray[tt.index]=downR=downL=new ATMNode(tt,this);
	return n.crDBVL(t.next); // Through the value from t.next
      } 
    }
    else { // I am Func
      n=farray[tt.index]=downR=downL=new FTMNode(tt,this);

      if (t.next==null) { // CTL : without next
	l=n.crDBVL(tt.arg);
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l;
      } 
      else { // CT : with next
	l=n.crDBV(tt.arg);
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l.crDBVL(t.next); // Through the value from t.next
      }
    }
  }

  private TMNode crDRBV(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("crDRBV: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);

    if (tt.arg==null) { // I am AT
      if (tt.index==0) n=downR=downR.right=new ATMNode(tt,this,downR);
      else n=farray[tt.index]=downR=downR.right=new ATMNode(tt,this,downR);
      if (t.next==null) // ST Leaf
	return n;
      else 
	return n.crDBV(t.next); // H.F. 10-Aug-1998
    } 
    else { // I am Func
      n=farray[tt.index]=downR=downR.right=new FTMNode(tt,this,downR);
      if (t.next==null) { // CTL : without next
	l=n.crDBV(tt.arg); // H.F. 10-Aug-1998
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l;
      } 
      else { // CT : with next
	l=n.crDBV(tt.arg); // H.F. 10-Aug-1998
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l.crDBV(t.next); // H.F. 10-Aug-1998
      }
    }
  }

  private TMNode crDRBVL(Term t) {
    Term tt; TMNode n,l;
    //    System.out.println("crDRBVL: this:"+toString1()+" term: "+t);
    Counter.index++;
    tt=((t instanceof BVar) ? t.arg.arg : t);

    if (tt.arg==null) { // I am AT
      if (t.next==null) { // Leaf
	if (tt.index==0) n=downR=downR.right=new TMLeaf(tt,this,downR);
	else 
	  n=farray[tt.index]=downR=downR.right=new TMLeaf(tt,this,downR);
	return n;
      }
      else {
	if (tt.index==0) n=downR=downR.right=new ATMNode(tt,this,downR);
	else n=farray[tt.index]=downR=downR.right=new ATMNode(tt,this,downR);
	return n.crDBVL(t.next); // H.F. 10-Aug-1998
      } 
    }
    else { // I am Func
      n=farray[tt.index]=downR=downR.right=new FTMNode(tt,this,downR);

      if (t.next==null) { // CTL : without next
	l=n.crDBVL(tt.arg); // H.F. 10-Aug-1998
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l;
      } 
      else { // CT : with next
	l=n.crDBV(tt.arg); // H.F. 10-Aug-1998
	//System.out.println(" func: "+n+" to be added "+l);
	n.mkSkip(tt,l);
	//System.out.println("skip: "+n.skip);
	return l.crDBVL(t.next); // H.F. 10-Aug-1998
      }
    }
  }

  /**********************************/

  /*
  void matchTM(AConj ai) {
    Counter.matchTM++;
    Term t=ai.hd;
    //    System.out.println("Top.matchTM: "+t);
    TMNode son=farray[t.index];
    if (son!=null&&son.ndac.act) son.matchTMBV(t,ai);
  }
  */

  void matchTMBV(Term t, AConj ai) {}
  void matchTMskip(Term t, AConj ai) {}
  TMNode bfmatchTMBV(Term t) {return NIL;}
  TMNode bfmatchTMBVL(Term t) {return NIL;}

}

class TMLeaf extends TMNode {
  GTerm term,plit,nlit;

  TMLeaf(Term t, TMNode u) {
    //System.out.println("new TMLeaf: "+t+" index: "+t.index);
    Counter.index++;
    up=u; downL=downR=left=right=NIL; ndac=ACell.OFF;
    uterm=t;
  }

  TMLeaf(Term t, TMNode u, TMNode l) {
    //System.out.println("new TMLeaf: "+t+" index: "+t.index);
    Counter.index++;
    up=u; left=l; downL=downR=right=NIL; ndac=ACell.OFF;
    uterm=t;
  }

  public String toString(int i) {
    String s="";
    for (int j=0; j<i; j++) s+=" ";
    return s+=(uterm.name==null ? ""+((ITerm)uterm).val : 
	       uterm.name)+": "+
      plit+" "+nlit+"\n"+right.toString(i);
  }

  /*
  public String toStringR(int i) {
    String s="";
    for (int j=0; j<i; j++) s+=" ";
    return s+=(uterm.name==null ? ""+((ITerm)uterm).val : 
	       uterm.name)+": "+
      plit+" "+nlit+"\n"+left.toStringR(i);
  }

  public String toStringAc(int i) {
    String s="";
    if (ndac.act) {
      for (int j=0; j<i; j++) s+=" ";
      s+=(uterm.name==null ? ""+((ITerm)uterm).val : 
	  uterm.name)+": "+
	(term.pac.act ? ""+plit : null )+" "+
	(term.nac.act ? ""+nlit : null )+"\n";
    }
    return s+=right.toStringAc(i);
  }

  String toString1() {
    //System.out.println(this.getClass().getName()+" uterm: "+uterm);
    return (this==NIL ? "" : 
	    (uterm.name==null ? ""+((ITerm)uterm).val : uterm.name));
  }
  */

  TMNode bfmatchTMBVL(Term t) {
    //System.out.println("TMLeaf:"+uterm.name+".bfmatchTMBVL: "+t);
    Counter.matchTM++;
    if (ndac.act) return this; else return NIL;
  }

  void matchTMskip(Term t, AConj ai) {
    //System.out.println("TMLeaf:"+uterm.name+".matchTMskip: "+t);
    Counter.matchTM++;
    t.arg=uterm;
    //    cl.leafProc(ai,this);
    ai.hd.leafProc(term,ai);
  }
}

class ATMNode extends TMNode {

  ATMNode(Term t, TMNode u) {
    //System.out.println("new ATMNode: "+t+" index: "+t.index);
    Counter.index++;
    up=u; downL=downR=left=right=NIL; ndac=ACell.OFF;
    farray=new TMNode[FUNCS];
    uterm=t;
  }
  ATMNode(Term t, TMNode u, TMNode l) {
    //System.out.println("new ATMNode: "+t+" index: "+t.index);
    Counter.index++;
    up=u; left=l; downL=downR=right=NIL; ndac=ACell.OFF;
    farray=new TMNode[FUNCS];
    uterm=t;
  }

  void matchTMBV(Term t, AConj ai) {
    //System.out.println("ATMNode:"+uterm.name+".matchTMBV: "+t);
    TMNode n; Term ts=t.next; Term tt; //Term ts=t.succ;
    Counter.matchTM++;
    if (ts instanceof FVar) {
      n=downR;
      while (n!=NIL) {
	//        Counter.nodeFV++;
	if (n.ndac.act) {
	  //	  Counter.nodeFVact++;
	  n.matchTMskip(ts,ai);
	  if (ai.mgtp.closed) return; // R.H. 98.08.15
	}
	n=n.left;
      }
      return;
    }
    tt=((ts instanceof BVar) ? ts.arg.arg : ts);
    n=(tt.index==0 ? findNode(tt) : 
       farray[tt.index]);
    if (n!=null&&n.ndac.act) {
      if (n instanceof TMLeaf) {
	//System.out.println("leafProc at matchTMBV: "+ts);
	//	cl.leafProc(ai,(TMLeaf)n);
	//((TMLeaf)n).leafProc(ai);
	ai.hd.leafProc(((TMLeaf)n).term,ai);
      }
      else n.matchTMBV(ts,ai);
    }
  }

  TMNode bfmatchTMBV(Term t) {
    //System.out.println("ATMNode:"+uterm.name+".bfmatchTMBV: "+t);
    TMNode n; Term ts=t.next;
    Counter.matchTM++;
    if (ts==null) return this;
    n=(ts.index==0 ? findNode(ts) : 
       farray[ts.index]);
    if (n!=null&&n.ndac.act) return n.bfmatchTMBV(ts);
    return NIL;
  }

  TMNode bfmatchTMBVL(Term t) {
    //System.out.println("ATMNode:"+uterm.name+".bfmatchTMBVL: "+t);
    TMNode n; Term ts=t.next;
    Counter.matchTM++;
    if (ts==null) return this;
    n=(ts.index==0 ? findNode(ts) : 
       farray[ts.index]);
    if (n!=null&&n.ndac.act) return n.bfmatchTMBVL(ts);
    return NIL;
  }

  void matchTMskip(Term t, AConj ai) {
    //System.out.println("ATMNode:"+uterm.name+".matchTMskip: "+t);
    Counter.matchTM++;
      t.arg=uterm;
      matchTMBV(t,ai);
  }

}

class PTMNode extends TMNode {

  PTMNode(Term t, TMNode u, TMNode l) {
    //System.out.println("new PTMNode: "+t+" index: "+t.index);
    Counter.index++;
    up=u; left=l; right=downL=downR=NIL; ndac=ACell.OFF;
    farray=new TMNode[FUNCS];
    uterm=t;
  }

  void matchTMBV(Term t, AConj ai) {
    //System.out.println("PTMNode:"+uterm.name+".matchTMBV: "+t);
    TMNode n; Term ts=t.arg; Term tt; //Term ts=t.succ;
    Counter.matchTM++;
    if (ts instanceof FVar) {
      n=downR;
      while (n!=NIL) {
	//        Counter.nodeFV++;
	if (n.ndac.act) {
	  //	  Counter.nodeFVact++;
	  n.matchTMskip(ts,ai);
	  if (ai.mgtp.closed) return; // R.H. 98.08.15
	}
	n=n.left;
      }
      return;
    }
    tt=((ts instanceof BVar) ? ts.arg.arg : ts);
    n=(tt.index==0 ? findNode(tt) : 
       farray[tt.index]);
    if (n!=null&&n.ndac.act) {
      if (n instanceof TMLeaf) {
	//System.out.println("leafProc at matchTMBV: "+ts);
	//	cl.leafProc(ai,(TMLeaf)n);
	//((TMLeaf)n).leafProc(ai);
	ai.hd.leafProc(((TMLeaf)n).term,ai);
      }
      else n.matchTMBV(ts,ai);
    }
  }

  void matchTMskip(Term t, AConj ai) {
    //System.out.println("PTMNode:"+uterm.name+".matchTMskip: "+t);
    Counter.matchTM++;
    t.arg=uterm;
    matchTMBV(t,ai);
  }

}

class FTMNode extends TMNode {

  FTMNode(Term t, TMNode u) {
    //System.out.println("new FTMNode: "+t+" index: "+t.index);
    Counter.index++;
    up=u; downL=downR=left=right=NIL; ndac=ACell.OFF;
    farray=new TMNode[FUNCS];
    uterm=t;
  }
  FTMNode(Term t, TMNode u, TMNode l) {
    //System.out.println("new FTMNode: "+t+" index: "+t.index);
    Counter.index++;
    up=u; left=l; downL=downR=right=NIL; ndac=ACell.OFF;
    farray=new TMNode[FUNCS];
    uterm=t;
  }

  void matchTMBV(Term t, AConj ai) {
    //System.out.println("FTMNode:"+uterm.name+".matchTMBV: "+t);
    TMNode n,l; Term ts,tt,tts; 
    Counter.matchTM++;
    if (t instanceof BVar) { 
      tts=t.arg.arg.arg;
      n=(tts.index==0 ? findNode(tts) : 
	 farray[tts.index]);
      if ((n!=null)&&n.ndac.act) {
	l=n.bfmatchTMBVL(tts);
	if (l!=NIL) {
	  if (l instanceof TMLeaf) {
	    //System.out.println("leafProc at FTMNode.matchTMBV: l: "+l);
	    //	    cl.leafProc(ai,(TMLeaf)l);
	    //((TMLeaf)l).leafProc(ai);
	    ai.hd.leafProc(((TMLeaf)l).term,ai);
	  }
	  else l.matchTMBV(t,ai);  // last node:<- matchTMBV(t=X!,ts)
	}
      }
    } 
    else {
      ts=t.arg; //ts=t.succ;
      if (ts instanceof FVar) {
	n=downR;
	while (n!=NIL) {
	  //	  Counter.nodeFV++;
	  if (n.ndac.act) {
	    //	    Counter.nodeFVact++;
	    n.matchTMskip(ts,ai);
            if (ai.mgtp.closed) return; // R.H. 98.08.15
	  }
	  n=n.left;
	}
	return;
      }
      tt=((ts instanceof BVar) ? ts.arg.arg : ts);
      n=(tt.index==0 ? findNode(tt) : 
	 farray[tt.index]);
      if (n!=null&&n.ndac.act) {
	if (n instanceof TMLeaf) {
	  //System.out.println("leafProc at matchTMBV: "+ts);
	  //	  cl.leafProc(ai,(TMLeaf)n);
	  //((TMLeaf)n).leafProc(ai);
	  ai.hd.leafProc(((TMLeaf)n).term,ai);
	}
	else n.matchTMBV(ts,ai);
      }
    }
  }

  TMNode bfmatchTMBV(Term t) {
    //System.out.println("FTMNode:"+uterm.name+".bfmatchTMBV: "+t);
    TMNode n; Term ts=t.arg;
    Counter.matchTM++;
    n=(ts.index==0 ? findNode(ts) : 
       farray[ts.index]);
    if (n!=null&&n.ndac.act) {
      if (t.next==null)
	return n.bfmatchTMBV(ts);
      else return n.bfmatchTMBV(ts).bfmatchTMBV(t);
    }
    return NIL;
  }

  TMNode bfmatchTMBVL(Term t) {
    //System.out.println("FTMNode:"+uterm.name+".bfmatchTMBVL: "+t);
    TMNode n; Term ts=t.arg;
    Counter.matchTM++;
    n=(ts.index==0 ? findNode(ts) : 
       farray[ts.index]);
    if (n!=null&&n.ndac.act) {
      if (t.next==null)
	return n.bfmatchTMBVL(ts);
      else return n.bfmatchTMBV(ts).bfmatchTMBVL(t);
    }
    return NIL;
  }

  void matchTMskip(Term t, AConj ai) {
    //System.out.println("FTMNode:"+uterm.name+".matchTMskip: "+t);
    Counter.matchTM++;
    SkipList l=skip; TMNode to;
    while(l!=null) {
     to=l.node;
     if (to.ndac.act) {
       t.arg=l.term;
       if (to instanceof TMLeaf) 
	 //	 cl.leafProc(ai,(TMLeaf)to);
	 //((TMLeaf)to).leafProc(ai);
	 ai.hd.leafProc(((TMLeaf)to).term,ai);
       else to.matchTMBV(t,ai);
     }
     l=l.tl;
    }
  }

}

class SkipList {
  Term term;
  TMNode node;
  SkipList tl;
  SkipList(TMNode n, SkipList s) {node=n; tl=s;}
  SkipList(Term t, TMNode n, SkipList s) {term=t; node=n; tl=s;}

  public String toString() {
    SkipList l=this; String s="";
    while (l!=null) {
      s+="sbterm["+l.term+"] skipTo "+node+"\n"; 
      l=l.tl;
    }
    return s;
  }

}

// eof
