/**
 * MGTP.java Version 32g 20-Nov-1998
 * Copyright (c) 1997, 1998 Kyushu University
 *
 * Based on v27cT 11-Aug-1998
 * array-indexing for TM
 * Skip pointer test version //R.H. 98.08.04
 * prove() updated           //R.H. 98.08.16
 */

class MGTP {
  static String version="JavaCMGTP Version 32g 11-Sep-1998";
  static String copyRight="Copyright (c) 1997, 1998 Kyushu University";
  static String ifile;
  static boolean verbose,allSol,selectMin,compileExt;
  static MGTPParser parser;
  static MGTP mgtp;
  static long time;

  CList Cls=new CList();
  Clauses posCls=new Clauses();
  Clauses negCls=new Clauses();
  Clauses cntCls=new Clauses();
  Clauses mixCls=new Clauses();

  public static void main(String args[]) {
    System.out.println(version);
    System.out.println(copyRight);
    setupOptions(args);
    java.io.FileInputStream fis=null;
    try {
      fis=new java.io.FileInputStream(ifile);
    } catch (java.io.FileNotFoundException e) {
      System.out.println("File "+ifile+" not found.");
      return;
    }
    parser=new MGTPParser(fis);
    mgtp=(selectMin ? new MGTPpickupMin() : new MGTP());
    System.out.println("Reading from file "+ifile+" . . .");
    time=System.currentTimeMillis();
    if (!parser.parse(mgtp)) return;
    //System.out.println(mgtp.TM);
    time=System.currentTimeMillis()-time;
    System.out.println("Parsing time: "+time+" msec");
    if (verbose) {
      System.out.println("\n"
			 +"Positive clause(s):\n"+mgtp.posCls
			 +"Negative clause(s):\n"+mgtp.negCls
			 +"Cont. clause(s):\n"+mgtp.cntCls
			 +"Mixed clause(s):\n"+mgtp.mixCls);
    }
    //System.out.println(mgtp.TM);
    //System.out.println(mgtp.TM.toStringR());
    System.gc();
    System.out.println("Proving . . .");
    time=System.currentTimeMillis();
    mgtp.posCls.first.cjmCL(null);
    mgtp.prove();
    time=System.currentTimeMillis()-time;
    //System.out.println(mgtp.TM);
    //System.out.println(mgtp.TM.toStringR());
    System.out.println("\n"
		       +"Number of models: "+mgtp.models+"\n"
		       +"Number of failed branches: "+mgtp.failedBranches+"\n"
		       +"Number of total branches: "+mgtp.branches+"\n"
		       +"Number of total atoms: "+mgtp.atoms+"\n"
		       //+"ground: "+Counter.ground+"\n"
		       +"putBuf: "+Counter.putBuf+"\n"
		       +"groundTM: "+Counter.groundTM+"\n"
		       +"conf: "+Counter.conf+"\n"
		       +"subs: "+Counter.subs+"\n"
		       //+"accheck: "+Counter.accheck+"\n"
		       +"uBufpickup: "+Counter.upickup+"\n"
       		       +"dBufpickup: "+Counter.dsubspass+"\n"
       		       +"nxtdpickup: "+Counter.npickup+"\n"
		       +"onTM: "+Counter.onTM+"\n"
		       +"usubs: "+Counter.usubs+"\n"
		       +"usubspass: "+Counter.usubspass+"\n"
		       +"dsubs: "+Counter.dsubs+"\n"
		       +"dsubspass: "+Counter.dsubspass+"\n"
		       +"dmatch: "+Counter.dmatch+"\n"
		       +"match: "+Counter.match+"\n"
		       +"indexBV: "+Counter.indexBV+"\n"
		       +"indexBVCR: "+Counter.indexBVCR+"\n"
		       +"index: "+Counter.index+"\n"
		       +"matchtmBV: "+Counter.matchtmBV+"\n"
		       +"matchTM: "+Counter.matchTM+"\n"
		       //+"nodeFV: "+Counter.nodeFV+"\n"
		       //+"nodeFVact: "+Counter.nodeFVact+"\n"
		       //+"leafProc: "+Counter.leafProc+"\n"
		       //+"leafact: "+Counter.leafact+"\n"
		       +"sat: "+Counter.sat+"\n"
		       +"cjm: "+Counter.cjm+"\n"
		       +(mgtp.sat? "SAT": "UNSAT")
		       +"\nProving time: "+time+" msec");

  }
  
  public static void setupOptions(String args[]) {
    for (int i=0; i<args.length; i++) {
      if ("verbose".startsWith(args[i])) {verbose=true; continue;}
      if ("all".startsWith(args[i])) {allSol=true; continue;}
      if ("min".startsWith(args[i])) {selectMin=true; continue;}
      if ("ext".startsWith(args[i])) {compileExt=true; continue;}
      ifile=args[i];
    }
  }

  int models,failedBranches,branches,atoms;
  boolean sat;

  Model pModel=Model.NIL; Model nModel=Model.NIL;
  TMNode TM; 
  GStack gstack;
  UList unitF,unitL,domsF,domsL;
  DList pdlF=DList.NIL; DList pdlL=DList.NIL; DList pdlnF=DList.NIL;
  DList ndlF=DList.NIL; DList ndlL=DList.NIL; DList ndlnF=DList.NIL;
  DList mdlF=DList.NIL; DList mdlL=DList.NIL; DList mdlnF=DList.NIL;
  Cnsq disj,nextd; GTerm delta; int atomID;
  boolean closed=false; // R.H. 98.08.15
  RDlList rll=RDlList.NIL;
  RDjList rjl=RDjList.NIL;
  ACell ac=new ACell();

  void prove() {
    main_loop: do {
      delta=null;
      pickup: do {
        if (unitF!=null) { 
          // Pickup from Unit Buf
          Counter.upickup++; //added R.H. 98.08.14 
	  delta=unitF.atm; unitF=unitF.tl; 
	  delta.setac(mgtp); // H.F. 98.08.28
          break;
        }
        if (pdlF!=DList.NIL || ndlF!=DList.NIL || mdlF!=DList.NIL) {
          // Disj Buf Simplification
          if (pdlF!=DList.NIL&&nModel!=Model.NIL) {
            pdlF.psimplify(this); pdlnF=DList.NIL; }
          if (ndlF!=DList.NIL&&pModel!=Model.NIL) {
	    ndlF.nsimplify(this); ndlnF=DList.NIL; }
          if (mdlF!=DList.NIL&&(nModel!=Model.NIL||pModel!=Model.NIL)) {
	  mdlF.msimplify(this); mdlnF=DList.NIL; }

          if (closed) break; // UNSAT by simplification
          if (unitF!=null) continue pickup;

          // Pickup from Disj Buf
          if (pickupDisj()) {
            nextd=disj.moveToBuf(disj.dn,this);
	    gstack=new GStack(pModel,nModel,nextd,atomID,
	                      pdlF,pdlL,ndlF,ndlL,mdlF,mdlL,domsF,domsL,
		              rjl,rll,ac,gstack);
            rjl=RDjList.NIL;
	    rll=RDlList.NIL;
	    ac=new ACell();
	    delta=(GTerm)disj.hd;
            delta.setac(mgtp); // added R.H. 98.08.14
            break;
          }
        }
        if (domsF!=null) {
          // Pickup from Dom Buf
          delta=domsF.atm; domsF=domsF.tl; 
	  delta.setac(mgtp); // H.F. 98.08.28
          break;
        }
        break;  // important
      } while(true); // pickup end

      if (delta==null&&!closed) {
        // SAT
	if (verbose) {
	  if (pModel==Model.NIL) System.out.println("pModel: []");
	  else System.out.println("pModel: "+pModel);
	  if (nModel==Model.NIL) System.out.println("nModel: []");
	  else System.out.println("nModel: "+nModel);
	}
	branches++; models++; sat=true;
	//	System.out.println(""+TM.toStringAc());
	if (!allSol||gstack==null) return;
	nextBranch();
      }

      fcheck: do {
        if (closed) {
          // UNSAT
	  if (verbose) {
	    System.out.println("reject: "+pModel+"\n"+
			       "        "+nModel);
	  }
          branches++; failedBranches++;
	  if (gstack==null) return;
          nextBranch();
          closed=false;
        }
        // Add delta to Model
        atomID++; atoms++;
        delta.onTM(mgtp); // added R.H. 98.08.14

        if (verbose) {
          System.out.print(""+atomID+": "+delta+Cnsq.clist(delta)+".\n");
          //System.out.print(""+atomID+": "+delta+".\n");
        }
        if (delta instanceof GNLiteral)
          nModel=new Model(delta, nModel);
        else
	  pModel=new Model(delta, pModel);

        // False check with delta
        // Model Candidate Generation with delta
        delta.Cls.cjmCL(delta);
        if (closed) continue fcheck;
        break;

      } while(true); // fcheck end

    } while (true); // main_loop end
  }

/*
  // for original
  void onTM(GTerm delta) {
    TMNode n;
    Counter.onTM++; // added R.H. 98.08.14
    if (delta instanceof GNLiteral) n=((GNLiteral)delta).atm.up;
    else n=delta.up;
    while (n!=TM) {
      //System.out.println("visiting node: "+n.key+" "+n.val+
                                           " ac: "+n.ndac.act);
      if (!n.ndac.act) {n.ndac=ac;}
      n=n.up;
    }
  }
*/

  class GStack {
    Model pModel,nModel;
    Cnsq nextd; int atomID;
    DList pdlF,pdlL,ndlF,ndlL,mdlF,mdlL;
    UList domsF,domsL;
    RDjList rjl;
    RDlList rll;
    ACell ac;
    GStack tl;
    GStack(Model pm, Model nm,
	   Cnsq nd, int id,
	   DList pf, DList pl, DList nf, DList nl, DList mf, DList ml,
	   UList of, UList ol,
	   RDjList rj,
	   RDlList rl,
	   ACell a,
	   GStack s) {
      pModel=pm; nModel=nm;
      nextd=nd; atomID=id;
      pdlF=pf; pdlL=pl; ndlF=nf; ndlL=nl; mdlF=mf; mdlL=ml;
      domsF=of; domsL=ol;
      rjl=rj;
      rll=rl;
      ac=a;
      tl=s;}
  }

  void nextBranch() {
    rjl.restore();
    rll.restore();
    ac.reset();
    ac=new ACell();
    pModel=gstack.pModel;
    nModel=gstack.nModel;
    unitF=unitL=null;
    atomID=gstack.atomID;
    pdlF=gstack.pdlF;
    pdlL=gstack.pdlL;
    if (pdlL!=DList.NIL) {pdlL.tl=DList.NIL;}
    ndlF=gstack.ndlF;
    ndlL=gstack.ndlL;
    if (ndlL!=DList.NIL) {ndlL.tl=DList.NIL;}
    mdlF=gstack.mdlF;
    mdlL=gstack.mdlL;
    if (mdlL!=DList.NIL) {mdlL.tl=DList.NIL;}
    domsF=gstack.domsF;
    domsL=gstack.domsL;
    if (domsL!=null) {domsL.tl=null;}
    pdlnF=ndlnF=mdlnF=DList.NIL;
    nextd=gstack.nextd;

    delta=(GTerm)nextd.hd;

    // added R.H. 98.08.14
    //Counter.accheck++;
    Counter.npickup++;
//    if (delta instanceof GNLiteral) {
//      (((GNLiteral)delta).atm).nac=ac;
//    } else delta.pac=ac;
    delta.setac(mgtp);

    //    if (nextd.tl!=null) nextd=nextd.tl.moveToBuf(nextd.dn,this);
    //    else nextd=null;
    nextd=nextd.moveToBuf(nextd.dn,this);

    if (nextd==null) { // pop up
      rjl=gstack.rjl; // commit rightmost child's restore to parent
      rll=gstack.rll;
      ac.tl=gstack.ac;
      gstack=gstack.tl;
    } else gstack.nextd=nextd;
  }

  boolean pickupDisj() {
  next: do {
    if (pdlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=pdlF.disj.subsumedDj(this);
      pdlF=pdlF.tl;
      pdlnF=pdlF; // H.F. 6-July-98
      if (disj==null) continue next;
      else  Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else if (ndlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=ndlF.disj.subsumedDj(this);
      ndlF=ndlF.tl;
      ndlnF=ndlF; // H.F. 6-July-98
      if (disj==null) continue next;
      else Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else if (mdlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=mdlF.disj.subsumedDj(this);
      mdlF=mdlF.tl;
      mdlnF=mdlF; // H.F. 6-July-98
      if (disj==null) continue next;
      else Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else {
      return false;
    }
    return true;
  } while (true);
  }

}

class MGTPpickupMin extends MGTP {
  boolean pickupDisj() {
  next: do {
    if (pdlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=pdlF.pfind_Min(this).subsumedDj(this);
      if (disj==null) continue next;
      else Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else if (ndlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=ndlF.nfind_Min(this).subsumedDj(this);
      if (disj==null) continue next;
      else Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else if (mdlF!=DList.NIL) {
      Counter.dsubs++;  //added R.H. 98.08.14 
      disj=mdlF.mfind_Min(this).subsumedDj(this);
      if (disj==null) continue next;
      else Counter.dsubspass++;  //added R.H. 98.08.14 	
    } else return false;
    return true;
  } while (true);
  }
}

class Model {
  public static Model NIL=new Model();
  Term hd; Model tl;
  Model() {}
  Model(GTerm delta) {hd=delta; tl=NIL;}
  Model(GTerm delta, Model model) {hd=delta; tl=model;}
  public String toString() {
    if (this==NIL) return "[]";
    String s="[ "; Model m=this;
    while (m.tl!=NIL) {s=s+m.hd+", "; m=m.tl;}
    return s+m.hd+" ]";
  }
}

class UList {
  GTerm atm; UList tl;
  UList(Term t) {atm=(GTerm)t;}
  public String toString() {return ""+atm;}
}

class ACell {
  public static ACell OFF=new ACell(false);
  boolean act; ACell tl;
  ACell() {act=true;}
  ACell(boolean b) {act=b;}
  void reset() {ACell r=this; while (r!=null) {r.act=false; r=r.tl;}}
}

// eof
