/**
 * DList.java v25b 26-July-1998
 * Copyright (c) 1997, 1998 Kyushu University
 */

class DList {
  static DList NIL=new DList(9999);
  int dsize; Cnsq disj; DList tl;
  DList() {}
  DList(int i) {dsize=i; tl=NIL;}
  DList(int i, Cnsq d) {dsize=i; disj=d; tl=NIL;}
  DList(int i, Cnsq d, DList t) {dsize=i; disj=d; tl=t;}

  public String toString() {
    DList d=this; String s="[";
    while (d!=NIL) {s+=d.disj+"|\n"; d=d.tl;}
    return s+"NIL]";
  }

  Cnsq pfind_Min(MGTP mg) {
    DList pd,d,prval,rval; int min=9999; d=this; pd=NIL; prval=rval=NIL;
    while (d!=NIL) {
      if (d.dsize<min) {prval=pd; rval=d; min=d.dsize;}
      pd=d; d=d.tl;
    }
    if (rval==this) {
      mg.pdlF=mg.pdlF.tl;
      mg.pdlnF=mg.pdlF; // H.F. 6-July-98
      return rval.disj;
    }
    mg.rll=new RDlList(prval,rval,mg.rll);
    prval.tl=rval.tl;
    if (rval==mg.pdlL) mg.pdlL=prval;
    return rval.disj;
  }  

  Cnsq nfind_Min(MGTP mg) {
    DList pd,d,prval,rval; int min=9999; d=this; pd=NIL; prval=rval=NIL;
    while (d!=NIL) {
      if (d.dsize<min) {prval=pd; rval=d; min=d.dsize;}
      pd=d; d=d.tl;
    }
    if (rval==this) {
      mg.ndlF=mg.ndlF.tl;
      mg.ndlnF=mg.ndlF; // H.F. 6-July-98
      return rval.disj;
    }
    mg.rll=new RDlList(prval,rval,mg.rll);
    prval.tl=rval.tl;
    if (rval==mg.ndlL) mg.ndlL=prval;
    return rval.disj;
  }  

  Cnsq mfind_Min(MGTP mg) {
    DList pd,d,prval,rval; int min=9999; d=this; pd=NIL; prval=rval=NIL;
    while (d!=NIL) {
      if (d.dsize<min) {prval=pd; rval=d; min=d.dsize;}
      pd=d; d=d.tl;
    }
    if (rval==this) {
      mg.mdlF=mg.mdlF.tl;
      mg.mdlnF=mg.mdlF; // H.F. 6-July-98
      return rval.disj;
    }
    mg.rll=new RDlList(prval,rval,mg.rll);
    prval.tl=rval.tl;
    if (rval==mg.mdlL) mg.mdlL=prval;
    return rval.disj;
  }  

  void psimplify(MGTP mg) {
    if (this==NIL) return;
    DList tdhp,d,rval; tdhp=this; d=this; rval=NIL;
    while (d!=mg.pdlnF) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;}
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    }
    while (d!=NIL) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;} // UNSAT
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    }
    if (tdhp.tl!=d) {
      mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
      tdhp.tl=NIL;
      mg.pdlL=tdhp;
    }
    mg.pdlF=rval;
  }

  void nsimplify(MGTP mg) {
    DList tdhp,d,rval; tdhp=this; d=this; rval=NIL;
    while (d!=mg.ndlnF) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;} // UNSAT
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    } 
    while (d!=NIL) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;} // UNSAT
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    } 
    if (tdhp.tl!=d) {
      mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
      tdhp.tl=NIL;
      mg.ndlL=tdhp;
    }
    mg.ndlF=rval;
  }

  void msimplify(MGTP mg) {
    DList tdhp,d,rval; tdhp=this; d=this; rval=NIL;
    while (d!=mg.mdlnF) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;} // UNSAT
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    }  
    while (d!=NIL) {
      if (d.disj.simplify(d,mg)) {mg.closed=true; return;} // UNSAT
      if (d.dsize==1) d.disj.putUnitBuf(mg);
      else { // not moved
	if (rval==NIL) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
	  tdhp.tl=d;
	}
	tdhp=d;
      }
      d=d.tl;
    } 
    if (tdhp.tl!=d) {
      mg.rll=new RDlList(tdhp,tdhp.tl,mg.rll);
      tdhp.tl=NIL;
      mg.mdlL=tdhp;
    }
    mg.mdlF=rval;
  }

  void update(int i, Cnsq d, MGTP mg) {
    if (i!=0) {
      if (i!=dsize) {
	if (d==disj) {
	  mg.rll=new RDlList(this,dsize,mg.rll);
	  dsize=i;
	} else {
	  mg.rll=new RDlList(this,dsize,disj,mg.rll);
	  dsize=i; disj=d;
	}
      } else if (d!=disj) {
	  mg.rll=new RDlList(this,disj,mg.rll);
	  disj=d;
      }
    }
  }

}

class RDlList {
  public static RDlList NIL=new RDlList();
  int kind; DList target; int olddsize; Cnsq olddisj; DList oldtl; RDlList tl;
  RDlList() {}

  RDlList(DList t, int i) {
    kind=0; target=t; olddsize=i; tl=NIL;}
  RDlList(DList t, Cnsq o) {
    kind=1; target=t; olddisj=o; tl=NIL;}
  RDlList(DList t, int i, Cnsq o) {
    kind=2; target=t; olddsize=i; olddisj=o; tl=NIL;}
  RDlList(DList t, DList s) {
    kind=3; target=t; oldtl=s; tl=NIL;}

  RDlList(DList t, int i, RDlList l) {
    kind=0; target=t; olddsize=i; tl=l;}
  RDlList(DList t, Cnsq o, RDlList l) {
    kind=1; target=t; olddisj=o; tl=l;}
  RDlList(DList t, int i, Cnsq o, RDlList l) {
    kind=2; target=t; olddsize=i; olddisj=o; tl=l;}
  RDlList(DList t, DList s, RDlList l) {
    kind=3; target=t; oldtl=s; tl=l;}

  public String toString() {
    RDlList r=this; String s="";
    while (r!=NIL) {
      switch (r.kind) {
      case 0: s+="ChangeDsize["+r.olddsize+"]\n"; break;
      case 1: s+="ChangeDisj["+r.olddisj+"]\n"; break;
      case 2: s+="ChangeDsizeDisj["+r.olddsize+", "+r.olddisj+"]\n"; break;
      case 3: s+="ChangeTl[ target: "+r.target+" oldtl: "+r.oldtl+"]\n"; break;
      default: break;
      }
      r=r.tl;
    }
    return s;
  }

  void restore() {
    RDlList r=this;
    while (r!=NIL) {
      switch (r.kind) {
      case 0: r.target.dsize=r.olddsize; break;
      case 1: r.target.disj=r.olddisj; break;
      case 2: r.target.dsize=r.olddsize; r.target.disj=r.olddisj; break;
      case 3: r.target.tl=r.oldtl; break;
      default: break;
      }
      r=r.tl;
    }
  }

}

// eof
