/**
 * Cnsq.java Version 32g 6-Nov-1998
 * Copyright (c) 1997, 1998 Kyushu University
 *
 * putBuf and putUnitBuf revised to
 * suppress generating new ULists // R.H.98.08.14
 */

/*
 * Cnsq
 *  +--FalseCnsq
 *  +--PCnsq
 *  +--NCnsq
 *  +--MCnsq
 *  +--GPCnsq
 *  +--GNCnsq
 *  +--GMCnsq
 *  +--Disj (abstract)
 *  |   +--PDisj
 *  |   +--NDisj
 *  |   +--MDisj
 *  |   +--GPDisj
 *  |   +--GNDisj
 *  |   +--GMDisj
 *  +--Conj
 *  |   +--GConj
 *  |   +--Unit
 *  |   |   +--GUnit
 *  |   +--DomConj
 *  |       +--GDomConj
 *  +--CLCnsq
 *  +--SLCnsq
 */

class Cnsq {
  int dn; Term hd; Cnsq tl;
  Cnsq() {}
  Cnsq(int i, Term t) {dn=i; hd=t;}
  Cnsq(int i, Term t, Cnsq c) {dn=i; hd=t; tl=c;}

  public String toString() {
    return "Cnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  public static String clist(Term t) {
    String s="[";

    if (t instanceof GTerm) {
      GTerm gt=(GTerm)t;
      s+=""+gt.Cls.listID();
    } else if (t instanceof CTermF) {
      CTermF ct=(CTermF)t;
      s+=""+ct.Cls.listID();
    }

    return s+"]";
  }

  Cnsq copy() {
    Cnsq cp=new Cnsq(dn,hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Cnsq(c.dn,c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {}
  void putUnitBuf(MGTP mg) {
    Cnsq c=this;
    while (c!=null) {
      Counter.usubs++;
      if (c.hd.notsubsumed_ac(mg)) {
        Counter.usubspass++;
        if (mg.unitF==null) mg.unitL=mg.unitF=new UList(c.hd);
        else {mg.unitL.tl=new UList(c.hd); mg.unitL=mg.unitL.tl;}
      }
      c=c.tl;
    }
  }

  Cnsq moveToBuf(int i, MGTP mg) {
    Cnsq d=tl;
    while (d!=null&&i==d.dn) {
      Counter.usubs++;
      if (d.hd.notsubsumed_ac(mg)) { // added R.H.98.08.14
        Counter.usubspass++;
     	if (mg.unitF==null) 
	  mg.unitF=mg.unitL=new UList(d.hd);
        else {
/*	  mg.unitL=new UList(d.hd);
	  mg.unitL=mg.unitL.tl; */   // bug 1998.10.9 

	  mg.unitL.tl=new UList(d.hd);
	  mg.unitL=mg.unitL.tl; 
        }
      } // added R.H.98.08.14
      d=d.tl;
    }
    return d;
  }
  /*
  Cnsq moveToBuf(int i, MGTP mg) {
    Cnsq d=tl;
    while (d!=null&&i==d.dn) {
      Counter.usubs++;
      if (d.hd.notsubsumed_ac(mg)) { // added R.H.98.08.14
        Counter.usubspass++;
     	if (mg.unitF==null) 
	  mg.unitF=mg.unitL=new UList(d.hd);
        else {
	  mg.unitL=new UList(d.hd);
	  mg.unitL=mg.unitL.tl;
        }
      } // added R.H.98.08.14
      d=d.tl;
    }
    return d;
  }
  */


  boolean simplify(DList me, MGTP mg) { // updated R.H. 98.10.12
    int dc=0; boolean cc=true; Cnsq f,l,d,rval;
    f=l=d=this; rval=null; 
    while (d!=null) {
      if (cc && d.hd.conflict()) cc=false; // simplified 
      if (d.tl==null || d.dn!=d.tl.dn) { // reaches disjunct boundary
	if (cc) {
	  if (rval==null) rval=f;
	  else if (l.tl!=f) {
	    mg.rjl=new RDjList(l,l.tl,mg.rjl);
	    l.tl=f;
	  }
	  l=d; f=d.tl; dc++;
	} else { f=d.tl; cc=true;}
      }
      d=d.tl;
    }
    if (l.tl!=f && dc!=0) {
      mg.rjl=new RDjList(l,l.tl,mg.rjl);
      l.tl=null;
    }
    me.update(dc,rval,mg);
    return (dc==0);
  }


  /*
  boolean simplify(DList me, MGTP mg) {
    int dc=0; boolean cc=false; Cnsq tdhp,d,rval;
    tdhp=me.disj; d=this; rval=null;
    while (d!=null) {
      if (!d.hd.conflict()) { // not simplified 
	cc=true;
        if (rval==null) rval=d;
	else if (tdhp.tl!=d) {
	    mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
	    tdhp.tl=d;
	}
        tdhp=d;
      }
      if ((d.tl==null || d.dn!=d.tl.dn) && cc) {dc++; cc=false;}
      d=d.tl;
    } 
    if (tdhp.tl!=d) {
      mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
      tdhp.tl=null;
    }
    me.update(dc,rval,mg);
    return (dc==0);
  }
  */

  Cnsq subsumedDj(MGTP mg) {
    RDjList wdl=RDjList.NIL; boolean cc=false; Cnsq tdhp,d,rval;
    tdhp=this; d=this; rval=null;
    while (d!=null) {
      if (!d.hd.subsumed()) { // not subsumed
	cc=true;
	if (rval==null) rval=d;
	else if (tdhp.tl!=d) wdl=new RDjList(tdhp,d,wdl);
	tdhp=d;
      } 
      if (d.tl==null||d.dn!=d.tl.dn) {
	if (!cc) return null;
	cc=false;
      }
      d=d.tl;
    } 
    if (tdhp.tl!=d) wdl=new RDjList(tdhp,null,wdl);
    if (wdl!=RDjList.NIL) {
      Cnsq tmp; RDjList pw,w; pw=w=wdl;
      while (w!=RDjList.NIL) {
	tmp=w.oldtl; w.oldtl=w.target.tl; w.target.tl=tmp;
	pw=w; w=w.tl;
      }
      pw.tl=mg.rjl; mg.rjl=wdl;
    }
    return rval;
  }

}

class FalseCnsq extends Cnsq {
  FalseCnsq() {}
  public String toString() {return "";}
  void putBuf(MGTP mg) {mg.closed=true;}
  Cnsq copy() {return this;}
}

class PCnsq extends Cnsq {
  int dsize;
  PCnsq(int i, Term a) {dn=i; hd=a;}
  PCnsq(int i, Term a, Cnsq t) {dn=i; hd=a; tl=t;}
  PCnsq(int i, Term a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "PCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {
    Cnsq cp=new PCnsq(dn,hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Cnsq(c.dn,c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GPCnsq(dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GPCnsq(dn,(t.hd instanceof GTerm ? t.hd :
			  mg.TM.indexBV(t.hd)));
    Cnsq gh=g; 
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GPCnsq(t.dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GPCnsq(t.dn,(t.hd instanceof GTerm ? t.hd :
			    mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);

    if (mg.pdlF==DList.NIL)
      mg.pdlL=mg.pdlF=new DList(dsize,gh);
    else {
      mg.pdlL.tl=new DList(dsize,gh);
      mg.pdlL=mg.pdlL.tl;
    }
    if (mg.pdlnF==DList.NIL) mg.pdlnF=mg.pdlL;
  }
}

class NCnsq extends Cnsq {
  int dsize;
  NCnsq(int i, Term a) {dn=i; hd=a;}
  NCnsq(int i, Term a, Cnsq t) {dn=i; hd=a; tl=t;}
  NCnsq(int i, Term a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}
  public String toString() {
    return "NCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {
    Cnsq cp=new NCnsq(dn,hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Cnsq(c.dn,c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GNCnsq(dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GNCnsq(dn,(t.hd instanceof GTerm ? t.hd :
			  mg.TM.indexBV(t.hd)));
    Cnsq gh=g;
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GNCnsq(t.dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GNCnsq(t.dn,(t.hd instanceof GTerm ? t.hd :
			    mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);

    if (mg.ndlF==DList.NIL)
      mg.ndlL=mg.ndlF=new DList(dsize,gh);
    else {
      mg.ndlL.tl=new DList(dsize,gh);
      mg.ndlL=mg.ndlL.tl;
    }
    if (mg.ndlnF==DList.NIL) mg.ndlnF=mg.ndlL;
  }
}

class MCnsq extends Cnsq {
  int dsize;
  MCnsq(int i, Term a) {dn=i; hd=a;}
  MCnsq(int i, Term a, Cnsq t) {dn=i; hd=a; tl=t;}
  MCnsq(int i, Term a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "MCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {
    Cnsq cp=new MCnsq(dn,hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Cnsq(c.dn,c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GMCnsq(dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GMCnsq(dn,(t.hd instanceof GTerm ? t.hd :
			  mg.TM.indexBV(t.hd)));
    Cnsq gh=g;
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GMCnsq(t.dn,mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GMCnsq(t.dn,(t.hd instanceof GTerm ? t.hd :
			    mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);

    if (mg.mdlF==DList.NIL)
      mg.mdlL=mg.mdlF=new DList(dsize,gh);
    else {
      mg.mdlL.tl=new DList(dsize,gh);
      mg.mdlL=mg.mdlL.tl;
    }
    if (mg.mdlnF==DList.NIL) mg.mdlnF=mg.mdlL;
  }
}

class GPCnsq extends Cnsq {
  int dsize;
  GPCnsq(int i, Term a) {dn=i; hd=a;} // GTerm-->Term R.H. 98.09.06
  GPCnsq(int i, GTerm a, Cnsq n) {dn=i; hd=a; tl=n;}
  GPCnsq(int i, GTerm a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GPCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {return this;}

  void putBuf(MGTP mg) {
    if (mg.pdlF==DList.NIL)
      mg.pdlL=mg.pdlF=new DList(dsize,this);
    else {
      mg.pdlL.tl=new DList(dsize,this);
      mg.pdlL=mg.pdlL.tl;
    }
    if (mg.pdlnF==DList.NIL) mg.pdlnF=mg.pdlL;
  }
}

class GNCnsq extends Cnsq {
  int dsize;
  GNCnsq(int i, Term a) {dn=i; hd=a;} // GTerm-->Term R.H. 98.09.06
  GNCnsq(int i, GTerm a, Cnsq n) {dn=i; hd=a; tl=n;} 
  GNCnsq(int i, GTerm a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GNCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {return this;}

  void putBuf(MGTP mg) {
    if (mg.ndlF==DList.NIL)
      mg.ndlL=mg.ndlF=new DList(dsize,this);
    else {
      mg.ndlL.tl=new DList(dsize,this);
      mg.ndlL=mg.ndlL.tl;
    }
    if (mg.ndlnF==DList.NIL) mg.ndlnF=mg.ndlL;
  }
}

class GMCnsq extends Cnsq {
  int dsize;
  GMCnsq(int i, Term a) {dn=i; hd=a;} // GTerm-->Term R.H. 98.09.06
  GMCnsq(int i, GTerm a, Cnsq n) {dn=i; hd=a; tl=n;}
  GMCnsq(int i, GTerm a, Cnsq t, int ds) {dn=i; hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GMCnsq:"+hd+clist(hd)+
//    return hd+clist(hd)+
      (tl==null ? "" : (dn==tl.dn ? ", " : "; ")+tl);
  }

  Cnsq copy() {return this;}

  void putBuf(MGTP mg) {
    if (mg.mdlF==DList.NIL)
      mg.mdlL=mg.mdlF=new DList(dsize,this);
    else {
      mg.mdlL.tl=new DList(dsize,this);
      mg.mdlL=mg.mdlL.tl;
    }
    if (mg.mdlnF==DList.NIL) mg.mdlnF=mg.mdlL;
  }
}

abstract class Disj extends Cnsq {
  Disj() {}
  Disj(Term a) {hd=a;}
  Disj(Term a, Cnsq n) {hd=a; tl=n;}

  public String toString() { 
    return "Disj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }
  /*
  Cnsq copy() {
    Cnsq cp=new Disj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Disj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }
  */
  void putUnitBuf(MGTP mg) {
    Counter.usubs++;
    if (hd.notsubsumed_ac(mg)) { // added R.H.98.08.14
      Counter.usubspass++;
      if (mg.unitF==null) mg.unitL=mg.unitF=new UList(hd);
      else {mg.unitL.tl=new UList(hd); mg.unitL=mg.unitL.tl;}
    } // added R.H.98.08.14
  }
  Cnsq moveToBuf(int i, MGTP mg) {return tl;}

  boolean simplify(DList me, MGTP mg) {
    int dc=0; Cnsq tdhp,d,rval;
    tdhp=me.disj; d=this; rval=null;
    while (d!=null) {
      if (!d.hd.conflict()) { // not simplified 
        if (rval==null) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
	  tdhp.tl=d;
	}
        tdhp=d;
        dc++;
      }
      d=d.tl;
    } 
    if (tdhp.tl!=d && dc!=0) {  // dc!=0 added R.H. 98.10.12
      mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
      tdhp.tl=null;
    }
    me.update(dc,rval,mg);
    return (dc==0);
  }

  /*
  boolean simplify(DList me, MGTP mg) {
    int dc=0; Cnsq tdhp,d,rval;
    tdhp=me.disj; d=this; rval=null;
    while (d!=null) {
      if (!d.hd.conflict()) { // not simplified 
        if (rval==null) rval=d;
	else if (tdhp.tl!=d) {
	  mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
	  tdhp.tl=d;
	}
        tdhp=d;
        dc++;
      }
      d=d.tl;
    } 
    if (tdhp.tl!=d) {
      mg.rjl=new RDjList(tdhp,tdhp.tl,mg.rjl);
      tdhp.tl=null;
    }
    me.update(dc,rval,mg);
    return (dc==0);
  }
  */

  Cnsq subsumedDj(MGTP mg) {
    Cnsq d=this;
    while (d!=null) {
      if (d.hd.subsumed()) return null;
      d=d.tl;
    } 
    return this;
  }

}

class PDisj extends Disj {
  int dsize;
  PDisj(Term a) {hd=a;}
  PDisj(Term a, Cnsq t) {hd=a; tl=t;}
  PDisj(Term a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "PDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {
    Cnsq cp=new PDisj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new PDisj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GPDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GPDisj((t.hd instanceof GTerm ? t.hd :
	       mg.TM.indexBV(t.hd)));
    Cnsq gh=g;
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GPDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GPDisj((t.hd instanceof GTerm ? t.hd :
		       mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);
    if (mg.pdlF==DList.NIL)
      mg.pdlL=mg.pdlF=new DList(dsize,gh);
    else {
      mg.pdlL.tl=new DList(dsize,gh);
      mg.pdlL=mg.pdlL.tl;
    }
    if (mg.pdlnF==DList.NIL) mg.pdlnF=mg.pdlL;
  }
}

class NDisj extends Disj {
  int dsize;
  NDisj(Term a) {hd=a;}
  NDisj(Term a, Cnsq t) {hd=a; tl=t;}
  NDisj(Term a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "NDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {
    Cnsq cp=new NDisj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new NDisj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GNDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GNDisj((t.hd instanceof GTerm ? t.hd :
		       mg.TM.indexBV(t.hd)));
    Cnsq gh=g;
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GNDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GNDisj((t.hd instanceof GTerm ? t.hd :
		       mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);
    if (mg.ndlF==DList.NIL)
      mg.ndlL=mg.ndlF=new DList(dsize,gh);
    else {
      mg.ndlL.tl=new DList(dsize,gh);
      mg.ndlL=mg.ndlL.tl;
    }
    if (mg.ndlnF==DList.NIL) mg.ndlnF=mg.ndlL;
  }
}

class MDisj extends Disj {
  int dsize;
  MDisj(Term a) {hd=a;}
  MDisj(Term a, Cnsq t) {hd=a; tl=t;}
  MDisj(Term a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "MDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {
    Cnsq cp=new MDisj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new MDisj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq t=this;
//    Cnsq g=new GMDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
    Cnsq g=new GMDisj((t.hd instanceof GTerm ? t.hd :
		       mg.TM.indexBV(t.hd)));
    Cnsq gh=g;
    do {
      t=t.tl;
      if (t==null) break;
//      g.tl=new GMDisj(mg.TM.indexBV(t.hd)); // R.H. 98.09.05
      g.tl=new GMDisj((t.hd instanceof GTerm ? t.hd :
		       mg.TM.indexBV(t.hd)));
      g=g.tl;
    } while (true);
    if (mg.mdlF==DList.NIL)
      mg.mdlL=mg.mdlF=new DList(dsize,gh);
    else {
      mg.mdlL.tl=new DList(dsize,gh);
      mg.mdlL=mg.mdlL.tl;
    }
    if (mg.mdlnF==DList.NIL) mg.mdlnF=mg.mdlL;
  }
}

class GPDisj extends Disj {
  int dsize;
  GPDisj(Term a) {hd=a;} // GTerm-->Term R.H. 98.09.06
  GPDisj(GTerm a, Cnsq n) {hd=a; tl=n;}
  GPDisj(GTerm a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GPDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {return this;}
  void putBuf(MGTP mg) {
    if (mg.pdlF==DList.NIL)
      mg.pdlL=mg.pdlF=new DList(dsize,this);
    else {
      mg.pdlL.tl=new DList(dsize,this);
      mg.pdlL=mg.pdlL.tl;
    }
    if (mg.pdlnF==DList.NIL) mg.pdlnF=mg.pdlL;
  }
}

class GNDisj extends Disj {
  int dsize;
  GNDisj(Term a) {hd=a;} // GTerm-->Term R.H. 98.09.06
  GNDisj(GTerm a, Cnsq n) {hd=a; tl=n;}
  GNDisj(GTerm a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GNDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {return this;}
  void putBuf(MGTP mg) {
    if (mg.ndlF==DList.NIL)
      mg.ndlL=mg.ndlF=new DList(dsize,this);
    else {
      mg.ndlL.tl=new DList(dsize,this);
      mg.ndlL=mg.ndlL.tl;
    }
    if (mg.ndlnF==DList.NIL) mg.ndlnF=mg.ndlL;
  }
}

class GMDisj extends Disj {
  int dsize;
  GMDisj(Term a) {hd=a;} // GTerm-->Term R.H. 98.09.06
  GMDisj(GTerm a, Cnsq n) {hd=a; tl=n;}
  GMDisj(GTerm a, Cnsq t, int ds) {hd=a; tl=t; dsize=ds;}

  public String toString() { 
    return "GMDisj:"+hd+clist(hd)+(tl==null ? "" : "; "+tl);
//    return hd+clist(hd)+(tl==null ? "" : "; "+tl);
  }

  Cnsq copy() {return this;}
  void putBuf(MGTP mg) {
    if (mg.mdlF==DList.NIL)
      mg.mdlL=mg.mdlF=new DList(dsize,this);
    else {
      mg.mdlL.tl=new DList(dsize,this);
      mg.mdlL=mg.mdlL.tl;
    }
    if (mg.mdlnF==DList.NIL) mg.mdlnF=mg.mdlL;
  }
}

class Conj extends Cnsq {
  int dsize=1;
  Conj() {}
  Conj(Term a) {hd=a;}
  Conj(Term a, Cnsq n) {hd=a; tl=n;}

  public String toString() { 
    return "Conj:"+hd+clist(hd)+(tl==null ? "" : ", "+tl);
//    return hd+clist(hd)+(tl==null ? "" : ", "+tl);
  }

  Cnsq copy() {
    Cnsq cp=new Conj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new Conj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) {
    Cnsq c=this;
    while (c!=null) {
//      GTerm t=mg.TM.indexBV(c.hd); // R.H. 98.09.05
      Term t=(c.hd instanceof GTerm ? c.hd :
	       mg.TM.indexBV(c.hd));
      Counter.usubs++;
      if (t.notsubsumed_ac(mg)) {
        Counter.usubspass++;
        if (mg.unitF==null) mg.unitL=mg.unitF=new UList(t);
        else {mg.unitL.tl=new UList(t); mg.unitL=mg.unitL.tl;}
      }
      c=c.tl;
    }
  }
}

class GConj extends Conj {
  GConj(Term a) {hd=a;} // GTerm-->Term R.H. 98.09.06
  GConj(GTerm a, Cnsq n) {hd=a; tl=n;}

  public String toString() { 
    return "GConj:"+hd+clist(hd)+(tl==null ? "" : ", "+tl);
//    return hd+clist(hd)+(tl==null ? "" : ", "+tl);
  }

  Cnsq copy() {return this;}

  void putBuf(MGTP mg) {
    Cnsq c=this;
    while (c!=null) {
      Counter.usubs++;
      if (c.hd.notsubsumed_ac(mg)) {
        Counter.usubspass++;
        if (mg.unitF==null) mg.unitL=mg.unitF=new UList(c.hd);
        else {mg.unitL.tl=new UList(c.hd); mg.unitL=mg.unitL.tl;}
      }
      c=c.tl;
    }
  }
}

class Unit extends Conj {
  Unit() {}
  Unit(Term a) {hd=a;}
  public String toString() {return "Unit:"+hd+clist(hd);}
//  public String toString() {return hd+clist(hd);}
  Cnsq copy() {return new Unit(hd);}
  void putBuf(MGTP mg) {
    Term a=mg.TM.indexBV(hd);
    Counter.usubs++;
    if (a.notsubsumed_ac(mg)) { // added R.H.98.08.14
      Counter.usubspass++;
      if (mg.unitF==null) mg.unitL=mg.unitF=new UList(a);
      else {mg.unitL.tl=new UList(a); mg.unitL=mg.unitL.tl;}
    } // added R.H.98.08.14
  }
}

class GUnit extends Unit {
  GUnit(GTerm a) {hd=a;}
  //  public String toString() {return "GUnit:"+hd+clist(hd);}
  public String toString() {return hd+clist(hd);}
  Cnsq copy() {return this;}
  void putBuf(MGTP mg) {
    Counter.usubs++;
    if (hd.notsubsumed_ac(mg)) { // added R.H.98.08.14
      Counter.usubspass++;
      if (mg.unitF==null) mg.unitL=mg.unitF=new UList(hd);
      else {mg.unitL.tl=new UList(hd); mg.unitL=mg.unitL.tl;}
    } // added R.H.98.08.14
  }
}

class DomConj extends Conj {
  DomConj() {}
  DomConj(Term a) {hd=a;}
  DomConj(Term a, Cnsq n) {hd=a; tl=n;}
  public String toString() { 
    return "DomConj:"+hd+clist(hd)+(tl==null ? "" : ", "+tl);
//    return hd+clist(hd)+(tl==null ? "" : ", "+tl);
  }

  Cnsq copy() {
    Cnsq cp=new DomConj(hd); Cnsq t=cp; Cnsq c=tl;
    while (c!=null) {t.tl=new DomConj(c.hd); t=t.tl; c=c.tl;}
    return cp;
  }

  void putBuf(MGTP mg) { // updated R.H. 98.09.10
    Cnsq c=this;
    while (c!=null) {
      Term t=(c.hd instanceof GTerm ? c.hd :
	      mg.TM.indexBV(c.hd));
      Counter.usubs++;
      if (t.notsubsumed_ac(mg)) {
	Counter.usubspass++;
        if (mg.domsF==null) mg.domsL=mg.domsF=new UList(t);
        else {mg.domsL.tl=new UList(t); mg.domsL=mg.domsL.tl;}
      }
      c=c.tl;
    }
  }
}

class GDomConj extends DomConj {
  GDomConj(Term a) {hd=a;} // GTerm-->Term R.H. 98.09.06
  GDomConj(GTerm a) {hd=a;}
  GDomConj(GTerm a, Cnsq n) {hd=a; tl=n;}
  public String toString() { 
    return "GDomConj:"+hd+clist(hd)+(tl==null ? "" : ", "+tl);
//    return hd+clist(hd)+(tl==null ? "" : ", "+tl);
  }

  Cnsq copy() {return this;}

  void putBuf(MGTP mg) { // updated R.H. 98.09.10
    Cnsq c=this;
    while (c!=null) {
      Counter.usubs++;
      if (c.hd.notsubsumed_ac(mg)) {
	Counter.usubspass++;
        if (mg.domsF==null) mg.domsL=mg.domsF=new UList(c.hd);
        else {mg.domsL.tl=new UList(c.hd); mg.domsL=mg.domsL.tl;}
      }
      c=c.tl;
    }
  }
}

class CLCnsq extends Cnsq {
  Clause hd; CLCnsq tl;
  CLCnsq() {}

  public String toString() { 
    String s="CLCnsq:["; CLCnsq c=this;
//    String s="["; CLCnsq c=this;
    while (c.tl!=null) {s+=c.hd.id+","; c=c.tl;}
    return s+c.hd.id+"]";
  }

  void putBuf(MGTP mg) {
    CLCnsq c=this;
    while (c!=null) {
      Counter.cjm++;
      c.hd.cjm(null);
      if (mg.closed) return;
      c=c.tl;
    }
  }
}

class SLCnsq extends Cnsq {
  Clause trueCl,falseCl; int sel;
  SLCnsq() {}

  public String toString() { 
    return "SLCnsq:"+"["+trueCl.id+";"+falseCl.id+"]";
//    return "["+trueCl.id+";"+falseCl.id+"]";
  }

  void putBuf(MGTP mg) {
    switch (sel) {
    case 1: Counter.cjm++; trueCl.cjm(null); return;
    case -1: Counter.cjm++; falseCl.cjm(null); return;
    }
  }
}

class RDjList {
  public static RDjList NIL=new RDjList();
  Cnsq target; Cnsq oldtl; RDjList tl;
  RDjList() {}
  RDjList(Cnsq t, Cnsq o) {target=t; oldtl=o; tl=NIL;}
  RDjList(Cnsq t, Cnsq o, RDjList l) {target=t; oldtl=o; tl=l;}
  public String toString() {
    RDjList r=this; String s="";
    while (r!=NIL) {
      s+="RDjList[("+r.target.hd+")'s old tl = "+r.oldtl+"]\n";
      r=r.tl;
    }
    return s;
  }
  void restore() {
    RDjList d=this;
    while (d!=NIL) {d.target.tl=d.oldtl; d=d.tl;}
  }
}

// eof
