/**
 * Clause.java Version 32f 6-Sep-1998
 * Copyright (c) 1997, 1998 Kyushu University
 */

/*
 * Clause
 *  +--EClause       
 *  +--NGClause      
 *  |   +--ENGClause     
 *  +--GClause         
 *  |   +--EGClause         
 *  +--PClause       
 */

class Clause {
  String tag;
  int id,subID;
  Term entry;
  AConj gante,ngante;
  Cnsq cnsq;
  int dsize;
  MGTP mgtp;
  ACell clac;

  Clause() {}
  Clause(String tg, int i, int si, Term ent, AConj ga, AConj nga,
	 Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; gante=ga; ngante=nga; cnsq=c; dsize=ds;
    mgtp=mg; clac=ACell.OFF;
  }

  public String toString() {
    return tag+"Cl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      (entry==null ? "" : "("+entry+") | ")+gante+", "+ngante+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }

  void cjm(GTerm delta) {
    Counter.cjm++;
    if (!clac.act) { 
      AConj a=gante;
      while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
      clac=mgtp.ac;
    }
    //    Counter.matchtmBV++;
    //    mgtp.TM.matchTM(this,ngante);
    ngante.hd.satisfied(ngante);
  }
}

class EClause extends Clause {
  EClause(String tg, int i, int si, Term ent, AConj ga, AConj nga,
	  Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; gante=ga; ngante=nga; cnsq=c; dsize=ds;
    mgtp=mg; clac=ACell.OFF;
  }

  public String toString() {
    return tag+"ECl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      entry+" | "+gante+(ngante==null ? "" : ", "+ngante)+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }

  void cjm(GTerm delta) {
    Counter.cjm++;
    Counter.dmatch++;
    if (entry.match(delta)) {
      if (!clac.act) { 
	AConj a=gante;
	while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
	clac=mgtp.ac;
      }
      if (ngante==null) {
        Counter.putBuf++;
	//        cnsq.putBuf(dsize,mgtp);
        cnsq.putBuf(mgtp);
      } else {
	//	Counter.matchtmBV++;
	//	mgtp.TM.matchTM(this,ngante);
	ngante.hd.satisfied(ngante);
      }
    }
  }

}

class NGClause extends Clause {
  NGClause() {}
  NGClause(String tg, int i, int si, Term ent, AConj nga,
	   Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; ngante=nga; cnsq=c; dsize=ds; mgtp=mg;
  }
  public String toString() {
    return tag+"NGCl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      (entry==null ? "" : "("+entry+") | ")+ngante+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }
  void cjm(GTerm delta) {
    Counter.cjm++;
    //    Counter.matchtmBV++;
    //    mgtp.TM.matchTM(this,ngante);
    ngante.hd.satisfied(ngante);
  }
}

class ENGClause extends NGClause {
  ENGClause(String tg, int i, int si, Term ent, AConj nga,
	    Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; ngante=nga; cnsq=c; dsize=ds; mgtp=mg;
  }

  public String toString() {
    return tag+"ENGCl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      entry+" | "+(ngante==null ? "" : ""+ngante)+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }

  void cjm(GTerm delta) {
    Counter.cjm++;
    Counter.dmatch++;
    if (entry.match(delta)) {
      //  R.H. 98.09.05
      //      if (id==20||id==27||id==34||id==41) 
      //	System.out.println("ClsENGCCl: cid = "+id);
      if (ngante==null) {
	Counter.putBuf++;
	//	cnsq.putBuf(dsize,mgtp);
	cnsq.putBuf(mgtp);
      } else {
	//	Counter.matchtmBV++;
	//	mgtp.TM.matchTM(this,ngante);
	ngante.hd.satisfied(ngante);
      }
    }
  }
}

class GClause extends Clause {
  GClause() {}
  GClause(String tg, int i, int si, Term ent, AConj ga,
	  Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; gante=ga; cnsq=c; dsize=ds; mgtp=mg; clac=ACell.OFF;
  }

  public String toString() {
    return tag+"GCl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      (entry==null ? "" : "("+entry+") | ")+
      (gante==null ? "" : ""+gante)+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }

/*
  void cjm(GTerm delta) {
    Counter.cjm++;
    if (!clac.act) { // disabled R.H. 98.09.05
      AConj a=gante;
      while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
      clac=mgtp.ac;
      Counter.putBuf++;
      //      cnsq.putBuf(dsize,mgtp);
      cnsq.putBuf(mgtp);
    }
  }
*/
  void cjm(GTerm delta) {
    Counter.cjm++;
    if (!clac.act) { 
//      System.out.println("ante.satisfied() performed");
      AConj a=gante;
      while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
      clac=mgtp.ac;
    }	
    Counter.putBuf++;
    //      cnsq.putBuf(dsize,mgtp);
    cnsq.putBuf(mgtp);
  }

}

class EGClause extends GClause {
  EGClause(String tg, int i, int si, Term ent, AConj ga,
	   Cnsq c, int ds, MGTP mg) {
    tag=tg; id=i; subID=si;
    entry=ent; gante=ga; cnsq=c; dsize=ds; mgtp=mg; clac=ACell.OFF;
  }

  public String toString() {
    return tag+"EGCl: c"+id+(subID==0 ? "" : "."+subID)+": "+
      entry+" | "+(gante==null ? "" : ""+gante)+
      " -> "+(tag=="N".intern() ? "" : ""+cnsq)+".";
  }
/*
  void cjm(GTerm delta) {
    Counter.cjm++;
    Counter.dmatch++;
    if (entry.match(delta)) {
      if (!clac.act) { 
//        System.out.println("ante.satisfied() performed");
	AConj a=gante;
	while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
	clac=mgtp.ac;
	Counter.putBuf++;
	//      cnsq.putBuf(dsize,mgtp);
	cnsq.putBuf(mgtp);
      }
    }
  }
*/
  void cjm(GTerm delta) {
    Counter.cjm++;
    Counter.dmatch++;
    if (entry.match(delta)) {
      if (!clac.act) { 
//        System.out.println("ante.satisfied() performed");
	AConj a=gante;
	while (a!=null) {if (!a.hd.satisfied()) return; a=a.tl;}
	clac=mgtp.ac;
      }
      Counter.putBuf++;
      //      cnsq.putBuf(dsize,mgtp);
      cnsq.putBuf(mgtp);
    }
  }

}

class PClause extends Clause {
  PClause(int i, Cnsq cns, int ds, MGTP mg) {
    id=i; cnsq=cns; dsize=ds; mgtp=mg;}
  public String toString() {return "PCl: c"+id+": -> "+cnsq+".";}
  void cjm(GTerm delta) {
    //    System.out.println("PCl.putBuf: "+cnsq);
    //    cnsq.putBuf(dsize,mgtp);}
    cnsq.putBuf(mgtp);}
}

class CList {
  public static CList NIL=new CList();
  Clause hd; CList tl;
  CList() {}
  CList(Clause h) {hd=h; tl=NIL;}
  CList(Clause h, CList t) {hd=h; tl=t;}
  public String toString() {
    String s=""; CList x=this;
    while (x!=NIL) {s=s+x.hd+"\n"; x=x.tl;}
    return s;
  }
  public String listID() {
    if (this==NIL) return "";
    String s=""; CList c=this;
    while (c.tl!=NIL) {
      s+=c.hd.id+(c.hd.subID==0 ? "" : "."+c.hd.subID)+", ";
      c=c.tl;
    }
    return s+=c.hd.id+(c.hd.subID==0 ? "" : "."+c.hd.subID);
  }
  public int length() {if (this==NIL) return 0; else return 1+tl.length();}
  void cjmCL(GTerm delta) {
    CList x=this;
    while (x!=NIL) {
      Counter.cjm++;
      x.hd.cjm(delta);
      if (x.hd.mgtp.closed) return;
      x=x.tl;
    }
  }
}

class Clauses {
  CList first,last;
  Clauses() {first=last=CList.NIL;}
  public String toString() {
    String s="";
    CList cls=first;
    while (true) {s+=cls.hd+"\n"; if (cls==last) break; cls=cls.tl;}
    return s;
  }
  void add(Clause c) {
    if (first==CList.NIL) {first=new CList(c); last=first;}
    else {last.tl=new CList(c); last=last.tl;}
  }
  void addNew(Clause c) {
    if (first==CList.NIL) first=last=new CList(c);
    else {
      CList cl=first;
      while (cl!=last) {if (cl.hd==c) return; cl=cl.tl;}
      if (cl.hd!=c) cl.tl=last=new CList(c);
    }
  }
}

// eof
