/* ----------------------------------------------------------
%                        Copyright (C) 1999
%               Hiroshi Nakashima, Kazuhiko Ohno
%              Namiyo Sugiyama, Kiyokazu Yokoishi
%        and Department of Information and Computer Sciences 
%                 Toyohashi University of Technology
%----------------------------------------------------------- */  

/* ----------------------------------------------------------
%                        Copyright (C) 1998
%        Hiroshi Nakashima, Kazuhiko Ohno, Namiyo Sugiyama,
%        and Department of Information and Computer Sciences 
%                 Toyohashi University of Technology
%----------------------------------------------------------- */  

#include <klic/basic.h>
#include <klic/struct.h>
#include <klic/primitives.h>
#include <klic/unify.h>
#include <klic/timing.h>
#include <klic/index.h>
#include <klic/schedule.h>
#include <stdio.h>
#include <klic/gb.h>
#include <klic/gobj.h>
#include <klic/susp.h>

extern q general_gc();
extern q *generator_unify();
extern q *resume_goals();
extern struct predicate predicate_unify__term__dcode_xunify_2;
extern struct predicate predicate_unify__term__dcode_xunify__goal_2;
static int malloc_margin = -1;

module KTH_create_thread();
module KTH_continue_thread();
module KTH_terminate_thread();
q* KTH_do_unify();
q* KTH_extend_stack();
q* KTH_gc_stack_as_root();
q* KTH_initiate();
static Inline q* KTH_generator_unify();
module KTH_second_stack_is_empty();
module KTH_call_native();

Const struct predicate KTH_create_thread_pred =
{ KTH_create_thread, 0, 0 };
Const struct predicate KTH_continue_thread_pred =
{ KTH_continue_thread, 0, 1 };
Const struct predicate KTH_terminate_thread_pred =
{ KTH_terminate_thread, 0, 0 };
Const struct predicate KTH_second_stack_is_empty_pred =
{ KTH_second_stack_is_empty, 0 ,3};
Const struct predicate predicate_main_xcall__native_0 =
{ KTH_call_native, 0 ,0};




module KTH_call_native(glbl,qp,allocp,toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  int t = KTH_current_thread;
  q *next_pred;
  q *x;
  allocp[0] = (q)qp->next;
  allocp[1] = (q)&KTH_continue_thread_pred;
  allocp[2] = makeint(t);
  qp->next = (struct goalrec*)&allocp[0];

  allocp += 3;
  heapp = allocp;
  KTH_thread_table[t].stackp = KTH_current_stackp -1;
  KTH_current_stackp = (q*)0;
  return (module)(qp->pred->func);
}

module KTH_create_thread(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  int i, t;
  int sold = KTH_thread_table_size , snew;
  q   *stackp, *argp,*tmp;
  struct predicate *pred;

  t = KTH_free_thread;
  if ( t == 0 ) {
    /* $B%9%l%C%I%F!<%V%k$NDI2C(B */
    snew = KTH_thread_table_size = sold * 2;
    KTH_thread_table = (struct KTH_thread_table_entry *)
      realloc((char *)KTH_thread_table,
	      snew * sizeof(struct KTH_thread_table_entry));
    for (i = sold ; i < snew ; i++ ) {
      KTH_thread_table[i].stack_top = NULL;
      KTH_thread_table[i].stackp = NULL;	/* unnecessary but ... */
      KTH_thread_table[i].slimit = NULL;	/* unnecessary but ... */
      KTH_thread_table[i].prev = i; 		/* unnecessary but ... */
      KTH_thread_table[i].next = i + 1;
      KTH_thread_table[i].stack_state = 0;
    }
    KTH_thread_table[snew-1].next = 0;
    t = sold ;
  }
  KTH_free_thread = KTH_thread_table[t].next;
  KTH_thread_table[t].prev = 1;
  KTH_thread_table[t].next = KTH_thread_table[1].next;
  KTH_thread_table[KTH_thread_table[1].next].prev = t;
  KTH_thread_table[1].next = t;
  stackp = KTH_thread_table[t].stack_top =
           (q*)malloc(KTH_STACK_SIZE * sizeof(q));
  if (stackp == 0)
    fatal("Cannot allocate stack space.");
  KTH_thread_table[t].slimit = stackp + KTH_STACK_SIZE - KTH_STACK_MARGIN;

  *stackp++ = (q)(&KTH_terminate_thread_pred);
/*  pred = (struct predicate*)(qp->args[0]);*/
/*  argp = (q*)(qp->args[1]) + 1 ;*/
  tmp= (q*)qp;
  pred = (struct predicate*)tmp[2];
  argp = &tmp[3];
/*  printf("pred->arity = %d\n",pred->arity);*/
  for (i = 0 ; i < pred->arity ; i++) {
    if(isref(argp[i])&&(derefone(argp[i])==argp[i]))
      {
	*stackp++ = allocp[0] = makeref(&allocp[0]);
	allocp++;
      }
    else
      *stackp++ = argp[i];
  }
  *stackp++ = (q)pred;
  KTH_current_stackp = KTH_thread_table[t].stackp = stackp;
  KTH_current_slimit = KTH_thread_table[t].slimit;
  KTH_current_thread = t;
  KTH_printf(("KTH_create_thread\n"));
  KTH_printf(("free thread = %d\n", KTH_free_thread));
  current_queue = qp->next;
  return (module)(pred->func);
}

module KTH_continue_thread(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  int t = intval(qp->args[0]);
  q   *stackp = KTH_thread_table[t].stackp;
/*  printf("continue thread\n");*/
  KTH_printf(("continue_thread\n"));
  KTH_current_stackp = stackp;
  KTH_current_slimit = KTH_thread_table[t].slimit;
  KTH_current_thread = t;
  
  current_queue = qp->next;
 
  return (module)(((struct predicate*)stackp[-1])->func);
}

module KTH_terminate_thread(glbl, qp, allocp, toppred)
  struct global_variables *glbl;
  struct goalrec *qp;
  q *allocp;
  Const struct predicate *toppred;
{
  int t = KTH_current_thread;
/*  printf("<<<<kth terminate thread>>>>\n");*/
  free(KTH_thread_table[t].stack_top);
  KTH_thread_table[KTH_thread_table[t].next].prev = KTH_thread_table[t].prev;
  KTH_thread_table[KTH_thread_table[t].prev].next = KTH_thread_table[t].next;
  KTH_thread_table[t].prev = t;		/* unnecessary but ... */
  KTH_thread_table[t].next = KTH_free_thread;
  KTH_free_thread = t;
  KTH_printf(("terminate_thread\n"));
  KTH_current_stackp = 0;
  KTH_printf(("qp(deq)=%d\n",qp));
  return (module)(qp->pred->func);
}

q* KTH_extend_stack()
{
/*  fatal("Can't extend stack");*/

  declare_globals;
  q *second_stack_top,*s_stackp,*tmp;
  int t = KTH_current_thread;
  size_t new_size=0,old_size =0;
  int arity_number,i,copy;
  size_t x ;
  KTH_declare_local;
  static q *pointer_check=NULL;
/*  printf("stack extend\n");*/

/*  printf("extend stack\n");*/

  if ((KTH_thread_table[t].stack_state == 1)
      ||(KTH_thread_table[t].stack_state==0)) /* state 0 ? */
    {
      
      
  /*    printf("nomal extend stack\n");*/

      x = KTH_STACK_SIZE2 * sizeof(q);

/*      if(pointer_check != NULL){      
	printf("p check : ");
	for (i=0;i<100;i++)
	  printf("%d ",pointer_check[i]);
	printf("\n");
      }*/
      second_stack_top = (q*)malloc(x);
      pointer_check = second_stack_top;
      

/*    tmp=(q*)malloc(x*2);  */

      if (second_stack_top == NULL) 
	fatal("Can't allocate second stack space\n");
      s_stackp = second_stack_top;
      
      s_stackp[1] = (q)KTH_thread_table[t].stack_top;
      s_stackp[2] = (q)slimit;
      s_stackp[3] = (q)(&KTH_second_stack_is_empty_pred);
      s_stackp+=4;
      
      
      
      copy=0;
      while(stackp >= slimit){
	arity_number = (int)(((struct predicate *)*(stackp-1))->arity) +1;
	copy+=arity_number;
	stackp -= arity_number;
      }
      
      
      for(i=0;i<copy;i++){
	  {
	    if(!isatomic(stackp[i]) && 
	       ((unsigned long)stackp[i] > (unsigned long)stackp) &&
	       ((unsigned long)stackp[i] < (unsigned long)(stackp+copy)))
	      {
		s_stackp[i]= 
		  (q)((q*)second_stack_top + 
		      ((q*)stackp[i] - (q*)KTH_thread_table[t].stack_top));
	    }else {
	      s_stackp[i]= stackp[i];
	    } 
	  }}
      s_stackp += copy;
      
      second_stack_top[0] = (q)stackp;
      
      KTH_thread_table[t].stack_top = second_stack_top;
      KTH_thread_table[t].stackp = KTH_current_stackp=stackp=s_stackp;
      KTH_thread_table[t].slimit = slimit=KTH_current_slimit
	= second_stack_top + (KTH_STACK_SIZE2 - KTH_STACK_MARGIN);
      KTH_thread_table[t].stack_state = 1;
      
      
  } else{    
    q * current_stack_tail = KTH_thread_table[t].slimit + KTH_STACK_MARGIN;
    
    if (malloc_margin < 0){
      q *memory1,*memory2,*memory1_tail,*realloc_alloc;
      memory1 = (q*)malloc(KTH_STACK_SIZE*sizeof(q));
      memory2 = (q*)malloc(KTH_STACK_SIZE*sizeof(q));
      memory1_tail = memory1+KTH_STACK_SIZE;
      malloc_margin = memory2 - memory1_tail;
/*      printf("malloc margin %d\n",malloc_margin);*/
      free(memory2);
      realloc_alloc = (q*)realloc(memory1,KTH_STACK_SIZE *2 *sizeof(q));
      if(realloc_alloc != memory1) {
	malloc_margin = -1;
	free(memory1);}
      free(realloc_alloc);
    }
/*      printf("abnomal extend stack\n");*/
    
    old_size = (KTH_thread_table[t].slimit + KTH_STACK_MARGIN
		- KTH_thread_table[t].stack_top);
    new_size = old_size*2;
/*    printf("old size %d,%d   %d\n",(size_t)old_size,(q*)old_size,
	   (q*)(second_stack_top + (new_size - KTH_STACK_MARGIN)*sizeof(q)));
*/

    /*
       second_stack_top = (q*)realloc(KTH_thread_table[t].stack_top,
       new_size*sizeof(q));
       */
    second_stack_top = (q*)malloc(new_size*sizeof(q));
    if (second_stack_top == NULL) fatal("Can't malloc .\n");
    

    if(current_stack_tail+malloc_margin == second_stack_top)
      { 
	q *tmp;
	q *current_stack_top = KTH_thread_table[t].stack_top;
/*	printf("lukky case\n");*/
	free(second_stack_top);
	tmp = (q*)realloc(current_stack_top,new_size*sizeof(q));
	if(tmp == NULL) fatal("can not realloc \n");
	if(tmp != current_stack_top) 
	  {/*fatal("not eq.\n");*/
	   /* realloc $B$7$?$1$I!"F1$8>l=j$KNN0h$,<h$l$F$$$J$$$N$G!"(B
	      $B;2>H%]%$%s%?$NCM$rJQ$($J$1$l$P$J$i$J$$!#(B*/
	   q *s_top = KTH_thread_table[t].stack_top;
	   q *sp,spval;
	   int i=0;
	   for(sp=s_top;sp <= stackp;sp++)
	     {
	       spval=*sp;
	       
	       if(!isatomic(spval) && 
		  ((unsigned long)spval > (unsigned long)s_top) &&
		  ((unsigned long)spval < (unsigned long)stackp))
		 {
		   tmp[i]= 
		     (q)((q*)tmp + ((q*)spval - (q*)s_top));
	       }else {
		 tmp[i]= spval;
	       } 
	       i++;
	     }
	   KTH_thread_table[t].stackp = KTH_current_stackp=stackp
	     =(q*)tmp - (q*)KTH_thread_table[t].stack_top
	       + (q*)KTH_thread_table[t].stackp;
	   KTH_thread_table[t].slimit = KTH_current_slimit = 
	     tmp + (new_size - KTH_STACK_MARGIN);
	   KTH_thread_table[t].stack_top = tmp;
	   
	}else{
	  KTH_thread_table[t].slimit = KTH_current_slimit =
	    current_stack_top + (new_size - KTH_STACK_MARGIN);
	}
      }
    else
      {
	/* $B%3%T!<(B($B%9%?%C%/Fb$X$N%]%$%s%?$rJQ$($D$D(B)*/
	q *sp,spval;
	q *s_top=KTH_thread_table[t].stack_top;
	int i=0;
	/*      printf("unlukky case pointer %d and %d\n",current_stack_tail,second_stack_top);
	 */    
	for(sp=s_top;sp <= stackp;sp++)
	  {
	    spval=*sp;
	    
	    if(!isatomic(spval) && 
	       ((unsigned long)spval > (unsigned long)s_top) &&
	       ((unsigned long)spval < (unsigned long)stackp))
	      {
		second_stack_top[i]= 
		  (q)((q*)second_stack_top + ((q*)spval - (q*)s_top));
	    }else {
	      second_stack_top[i]= spval;
	    } 
	    i++;
	  }
	
	KTH_thread_table[t].stackp = KTH_current_stackp=stackp
	  =(q*)second_stack_top - (q*)KTH_thread_table[t].stack_top
	    + (q*)KTH_thread_table[t].stackp;
	KTH_thread_table[t].slimit = KTH_current_slimit = 
	  second_stack_top + (new_size - KTH_STACK_MARGIN);
	KTH_thread_table[t].stack_top = second_stack_top;
	
      }
    
    KTH_thread_table[t].stack_state = 1;
    
    /*
       KTH_thread_table[t].stackp = KTH_current_stackp = stackp =
       (q*)second_stack_top - (q*)KTH_thread_table[t].stack_top 
       + (q*)KTH_thread_table[t].stackp;
       KTH_thread_table[t].slimit = KTH_current_slimit =
       second_stack_top + new_size*sizeof(q) - KTH_STACK_MARGIN;
       KTH_thread_table[t].stack_top = second_stack_top;
       */
  }
  
  /*  printf("? %d %d %d  margin %d\n",
      sizeof(q),old_size,new_size,KTH_STACK_MARGIN);
      printf("%d %d %d %d %d\n",new_size - KTH_STACK_MARGIN,second_stack_top,
      (new_size - KTH_STACK_MARGIN)*sizeof(q),
      second_stack_top+(new_size - KTH_STACK_MARGIN)*sizeof(q),
      second_stack_top+((new_size - KTH_STACK_MARGIN)));
      printf("<%d %d %d>\n",KTH_thread_table[t].stack_top,
      KTH_thread_table[t].slimit,KTH_thread_table[t].stackp);
      */
  
  
}


module  KTH_second_stack_is_empty(glbl, qp, allocp, toppred)
     struct global_variables *glbl;
     struct goalrec *qp;
     q *allocp;
     Const struct predicate *toppred;
{
  /* */
  int t = KTH_current_thread;
  KTH_declare_local;
  
/*  printf("* empty\n");*/
  
  free (KTH_thread_table[t].stack_top);
  
  KTH_thread_table[t].stack_state = -1;
  KTH_thread_table[t].slimit = KTH_current_slimit=(q*)stackp[-2];
  KTH_thread_table[t].stack_top =(q*)stackp[-3];
  KTH_thread_table[t].stackp = KTH_current_stackp = stackp = (q*)stackp[-4];

    
  return (module)(((struct predicate*)stackp[-1])->func);

}


q* KTH_gc_stack_as_root(allocp, ntop, otop, nsize, osize)
     q *allocp, *ntop, *otop;
     unsigned long nsize, osize;
{
  declare_globals;

  q *s;
  q x;
  int t;
  q *tmp_stack_top,*tmp_stackp;

  for (t = KTH_thread_table[1].next ; t != 0 ; t = KTH_thread_table[t].next) {
    for (s = KTH_thread_table[t].stack_top ;
	 s < KTH_thread_table[t].stackp ; s++) {
      x = *s ;
      if (!isatomic(x) && ((unsigned long)x - (unsigned long)otop <
			   (unsigned long)osize)) {
	*s = general_gc(s, allocp, gcsp);
	allocp = heapp;
      }
    }
    tmp_stack_top = KTH_thread_table[t].stack_top;
    while(*tmp_stack_top != (q)(&KTH_terminate_thread_pred))
      {
	tmp_stackp = (q*)tmp_stack_top[0];	
	tmp_stack_top =(q*)tmp_stack_top[1];
	

	for (s = tmp_stack_top ;
	     s < tmp_stackp ; s++) {
	  x = *s ;
	  if (!isatomic(x) && ((unsigned long)x - (unsigned long)otop <
			       (unsigned long)osize)) {
	    *s = general_gc(s, allocp, gcsp);
	    allocp = heapp;
	  }
	}
      }
  }
  return(allocp);
}

q* KTH_initiate()
{
  int i;
  q* KTH_gc_stack_as_root();
  declare_globals;
  KTH_thread_table = (struct KTH_thread_table_entry *)
    malloc(KTH_THREAD_TABLE_SIZE * sizeof(struct KTH_thread_table_entry));
  if (KTH_thread_table == 0)
    fatal("Cannot allocate thread table space.");
  for (i=0 ; i<KTH_THREAD_TABLE_SIZE ; i++) {
    KTH_thread_table[i].stack_top = NULL;
    KTH_thread_table[i].prev = i;
    KTH_thread_table[i].next = i+1;
  }
  KTH_thread_table_size = KTH_THREAD_TABLE_SIZE;
  KTH_thread_table[0].prev = 1;		/* unnecessary ... */
  KTH_thread_table[0].next = 0;
  KTH_thread_table[1].prev = 1;
  KTH_thread_table[1].next = 0;
  KTH_free_thread = 2;
  KTH_thread_table[KTH_THREAD_TABLE_SIZE-1].next = 0;

  register_gc_hook(KTH_gc_stack_as_root);


  KTH_printf(("KTH_initiate\n"));
}

#define enqueue_unify_terms(x, y) \
{ \
  struct goalrec *gp = (struct goalrec *)allocp; \
  gp->next = (struct goalrec*)makeint(current_prio); \
  gp->pred = &predicate_unify__term__dcode_xunify_2; \
  gp->args[0] = x; \
  gp->args[1] = y; \
  allocp += 4; \
  resume_same_prio(gp); \
}

#define enqueue_unify_goal(x, y) \
{ \
  struct goalrec *gp = (struct goalrec *)allocp; \
  gp->next = (struct goalrec*)makeint(current_prio); \
  gp->pred = &predicate_unify__term__dcode_xunify__goal_2; \
  gp->args[0] = (x); \
  gp->args[1] = (y); \
  allocp += 4; \
  resume_same_prio(gp); \
}

static Inline q*
KTH_generator_unify(gsx, sy, allocp)
     struct generator_susp *gsx;
     struct susprec *sy;
     q *allocp;
/*
   sx is a suspension structure
   and y is hook or generator
*/
{
  declare_globals;
  q *tmpallocp;

  /* At first, try unify method */
  tmpallocp = (method_table_of(untag_generator_susp(gsx->u.o))->
	       active_unify(gsx->backpt, sy->backpt, allocp));
  if(tmpallocp != (q*)0) {
    /* succeeded */
    allocp = tmpallocp;
/*
    derefone(gsx->backpt) = sy->backpt;
*/
  } else {
    /* unify of x is failed */
    if(is_generator_susp(sy->u)) {
      struct generator_susp *gsy = generator_suspp(sy);
      q *tempallocp =  
	method_table_of(untag_generator_susp(gsy->u.o))->
	  active_unify(gsy->backpt, gsx->backpt, allocp);
      if(tempallocp != (q*)0) {
	allocp = tempallocp;
/*
	derefone(gsy->backpt) = gsx->backpt;
*/
      } else {
	/* x and y are both generator,
	   but both failed. */
	struct generator_object *gobjx = untag_generator_susp(gsx->u.o);
	q tmpx = generic_generate(gobjx, allocp);
	switch((long)tmpx) {
	case (long)makeref(0): {
	  /* failed */
	  struct generator_object *gobjy = untag_generator_susp(gsy->u.o);
	  q tmpy = generic_generate(gobjy, allocp);
	  switch((long)tmpy) {
	  case (long)makeref(0):
	    enqueue_unify_goal(gsx->backpt, sy->backpt);
	    break;
	  case (long)makecons(0):
	    fatal("illegal sictuation at the generator unification");
	  default:
	    allocp = heapp;
	    derefone(gsy->backpt) = tmpy;
	    if(isref(tmpy) && tmpy == derefone(tmpy)) {
	      derefone(tmpy) = gsx->backpt;
	    } else {
	      allocp = KTH_do_unify(allocp, tmpy, gsx->backpt);
	    }
	  }
	}
	case (long)makecons(0):
	  fatal("illegal sictuation at the generator unification");
	default:
	  allocp = heapp;
	  gsx->backpt = tmpx;
	  if(isref(tmpx) && tmpx == derefone(tmpx)) {
	    derefone(sy->backpt) = tmpx;
	  } else {
	    return KTH_do_unify(allocp, tmpx, sy->backpt);
	  }
	}
      }
    } else {
      /* The unify method for x is failed and
	 y is hook */
      struct generator_object *gobjx = untag_generator_susp(gsx->u.o);
      q tmpx = generic_generate(gobjx, allocp);
      switch((long)tmpx) {
      case (long)makeref(0): /* GC request */
	enqueue_unify_goal(gsx->backpt, sy->backpt);
	break;
      case (long)makecons(0): /* illegal */
	fatal("illegal situation at the generator unification");
      default:
        allocp = heapp;
	derefone(gsx->backpt) = tmpx;
	if(isref(tmpx) && tmpx == derefone(tmpx)) {
	  derefone(tmpx) = sy->backpt;
	} else {
	  return KTH_do_unify(allocp, tmpx, sy->backpt);
	}
      }
    }
  }
  return allocp;
}

q *KTH_do_unify(allocp, x, y)
     q * allocp;
     q x, y;
{
  declare_globals;
#ifdef UNIFYDEBUG
  klic_fprintf(stdout, "Unify with ");
  print(x);
  klic_fprintf(stdout, ",");
  print(y);
  klic_fprintf(stdout, "\n");
#endif
  if (isref(x)) {
    q temp = derefone(x);
  deref_x:
    if (x != temp){
      if (isref(temp)) {
	q temp1 = derefone(temp);
	if (temp1 == x) {	/* x is hook */
	  while (isref(y)) {
	    q ytemp = derefone(y);
	    if (y == ytemp) {
	      /* Suspension records must be referenced through REF. */
	      /* Thus, doing "derefone(y) = temp;" here is buggy. */
	      derefone(y) = x;
	      return allocp;
	    } else {
	      if (isref(ytemp) && derefone(ytemp) == y) {
		y = ytemp;
		x =  temp;
		if (x != y) {
		  /* merge two hook chains */
		  struct susprec *sx = (struct susprec *)x;
		  struct susprec *sy = (struct susprec *)y;
		  if(is_generator_susp(sx->u)) {
		    return KTH_generator_unify(generator_suspp(sx), sy,
						 allocp);
		  } else if(is_generator_susp(sy->u)) {
		    return KTH_generator_unify(generator_suspp(sy), sx,
						 allocp);
		  } else {
		    /* Both x and y are not generator */
		    /* None of two is generator, then merge ... */
		    struct hook *second_of_x = sx->u.first_hook.next;
		    /* connect sx and topy */
		    sx->u.first_hook.next = sy->u.first_hook.next;
		    sy->u.first_hook.next = second_of_x;
		    derefone(sy->backpt) = sx->backpt;
		  }
		}
		return allocp;
	      }
	    }
	    y = ytemp;
	  }
	  /* x is hook variable and y points a real object */
	  return resume_goals(allocp, temp, y);
	} else {
	  x = temp;
	  temp = temp1;
	  goto deref_x;
	}
      } else {
	x = temp;
      }
    } else {
      /* dereference y */
      while (isref(y)) {
	temp = derefone(y);
	if (temp == y || (isref(temp) && derefone(temp) == y)) break;
	y = temp;
      }
      if (isref(y) && KTH_within_stack(y)) {
	if (KTH_within_stack(x)) {
	  derefone(x) = derefone(y) = *allocp = makeref(allocp++);
	}
	else
	  derefone(y) = x;
      }
      else
	derefone(x) = y;		/* this also handles x==y cases */
      return allocp;
    }
  }

  /* x is bound */
  while (isref(y)) {
    q temp = derefone(y);
    if (temp == y) { /* y is undef cell */
      derefone(y) = x;
      return allocp;
    } else {
      if(isref(temp) && derefone(temp) == y) {
	return resume_goals(allocp, temp, x);
      }
    }
    y = temp;
  }

  /* Both x and y are bound */
  if (x != y) {
    declare_globals;
    enqueue_unify_terms(x, y);
  }
  return allocp;
}
