%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : util.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: utilities
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
createDomainVar(X):-
    minmaxIntegers(Min,Max),
    domain(X,Min,Max).

hashtableCreate(N,Table):-
    N=<0 : functor(Table,hashtable,1).
hashtableCreate(N,Table):-
    N<256 : functor(Table,hashtable,N).
hashtableCreate(N,Table):-
    true : functor(Table,hashtable,253).

hashtableSize(Table,Size):-
    functor(Table,F,Size).

hashtableSet(Key,Value,Table):-
    var(Table) :
    functor(Table,hashtable,253),
    hashtableSet(Key,Value,Table).
hashtableSet(Key,Value,Table):-
    functor(Table,_,N),
    hashValue(Key,HashVal),
    Index is HashVal mod N + 1,
    arg(Index,Table,L),
    hashtableCollect(Table,All1),
    attach(elm(Key,Value),L). % built-in of B-Prolog

getTypeAndValueFromHashtable(Key,Type,Value,Table):-
    functor(Table,_,N),
    hashValue(Key,HashVal),
    Index is HashVal mod N + 1,
    arg(Index,Table,L),
    lookup(elm(Key,Elm),L),
    arg(1,Elm,Type),
    arg(2,Elm,Value). % Elm=component(Class,Object) or attribute(Type,DVar)

hashtableGet(Key,Value,Table):-var(Table) : fail.
hashtableGet(Key,Value,Table):-
    functor(Table,_,N),
    hashValue(Key,HashVal),
    Index is HashVal mod N + 1,
    arg(Index,Table,L),
    lookup(elm(Key,Value),L). % built-in of B-Prolog
    
hashValue(Key,HashVal):-
    atom(Key) :
    name(Key,L),
    hashValueSumList(L,0,HashVal).
hashValue(Key,HashVal):-
    integer(Key) :
    HashVal=Key.
hashValue(Key,HashVal):-
    var(Key) :
    HashVal=0.
hashValue(Key,HashVal):-
    true :
    functor(Key,F,N),
    hashValue(F,HashVal1),
    hashValue(Key,1,N,HashVal1,HashVal).

hashValue(Key,N0,N,HashVal0,HashVal):-
    N0>N : HashVal=HashVal0.
hashValue(Key,N0,N,HashVal0,HashVal):-
    true :
    arg(N0,Key,Arg),
    hashValue(Arg,HashVal1),
    HashVal2 is HashVal0+HashVal1,
    N1 is N0+1,
    hashValue(Key,N1,N,HashVal2,HashVal).

hashValueSumList([],Sum0,Sum):-
    true :
    Sum=Sum0.
hashValueSumList([X|Xs],Sum0,Sum):-
    true :
    Sum1 is Sum0+X,
    hashValueSumList(Xs,Sum1,Sum).

hashtableCollect(Table,Bag):-
    var(Table) : Bag=[].
hashtableCollect(Table,Bag):-
    true :
    functor(Table,F,N),
    hashtableCollect(Table,1,N,Bag).

hashtableCollect(Table,N0,N,Bag):-
    N0>N : Bag=[].
hashtableCollect(Table,N0,N,Bag):-true :
    arg(N0,Table,List),
    addListToBag(List,Bag,NewBag),
    N1 is N0+1,
    hashtableCollect(Table,N1,N,NewBag).

listToHashtable(List,Hashtable):-
    var(List) : true.
listToHashtable([],Hashtable):-
    true : true.
listToHashtable([X|Xs],Hashtable):-
    true :
    arg(1,X,A1),
    hashtableSet(A1,X,Hashtable),
    listToHashtable(Xs,Hashtable).

lookupCompAttrList(Id,List):-
    var(List) : fail.
lookupCompAttrList(Id,[X|Xs]):-
    arg(1,X,A1),
    Id==A1 : true.
lookupCompAttrList(Id,[X|Xs]):-
    true :
    lookupCompAttrList(Id,Xs).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
cmpError(Mes):-
    true :
    telling(File),
    tell(user),
    write('** error ** '),
    output_message(Mes),
    tell(File),
    fail.

cmpError(Mes,Goal):-
    true :
    telling(File),
    tell(user),
    write('** error ** '),
    output_message(Mes),
    call(Goal),
    tell(File),
    fail.

cmpWarning(Mes):-
    true :
    telling(File),
    tell(user),
    write('** warning ** '),
    output_message(Mes),
    tell(File).
        
output_message([]):-true : nl.
output_message([X|L]):-true :
    write(X),
    output_message(L).

runError(Mes):-
    true :
    telling(File),
    tell(user),
    write('** error ** '),
    output_message(Mes),
    tell(File),
    halt.

nextInstanceNo(N):-
    global_get('$instance_no',0,N),
    N1 is N+1,
    global_set('$instance_no',0,N1).
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
addListToBag(List,Bag,NewBag):-var(List) : NewBag=Bag.
addListToBag([],Bag,NewBag):-true : NewBag=Bag.
addListToBag([X|List],Bag,NewBag):-
    true :
    Bag=[X|Bag1],
    addListToBag(List,Bag1,NewBag).

listToAnd([],And):-true : And=true.
listToAnd([X],And):-true : And=X.
listToAnd([X|Xs],And):-
    true : 
    And=(X,AndXs),
    listToAnd(Xs,AndXs).
listToAnd(X,And):-
    true :
    And=X.

typeLub(bottom,Type2,Lub):-true : Lub=Type2.
typeLub(Type1,bottom,Lub):-true : Lub=Type1.
typeLub(Type1,Type2,Lub):-Type1==Type2 : Lub=Type1.
typeLub(Type1,Type2,Lub):-true : Lub='Object'.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
maximumConstraint([],Max):-true : true.
maximumConstraint([X],Max):-
    true : X #= Max.
maximumConstraint(Xs,Max):-
    true :
    leList(Xs,Max),
    aggregateMaxFix(Max,Xs).
    
minimumConstraint([],Min):-true : true.
minimumConstraint([X],Min):-
    true : X#=Min.
minimumConstraint(Xs,Min):-
    true :
    geList(Xs,Min),
    aggregateMinFix(Min,Xs).

leList([],Max):-true : true.
leList([X|Xs],Max):-true : X #=< Max, leList(Xs,Max).

geList([],Min):-true : true.
geList([X|Xs],Min):-true : X #>= Min, geList(Xs,Min).
    
positionInsideScreen(X,Y):-
    global_get(screenWidth,W),
    global_get(screenHeight,H),
    global_get(leftMargin,LM),
    global_get(topMargin,TM),
    domain(X,LM,W),
    domain(Y,TM,H).

sizeInsideScreen(W,H):-
    global_get(screenWidth,SW),
    global_get(screenHeight,SH),
    global_get(leftMargin,LM),
    global_get(rightMargin,RM),
    global_get(topMargin,TM),
    global_get(bottomMargin,BM),
    Width is SW-LM-RM,Width>0,
    Height is SH-TM-BM,Height>0,
    domain(W,0,Width),
    domain(H,0,Height).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
getComponentBound(Object,Bound):-
    isBaseClassObject(Object) :
    getBaseAttribute(bound,Bound,_,Object).
getComponentBound(Object,Bound):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound1)<=Object :
    Bound=Bound1.
getComponentBound(Object,Bound):-
    true :
    global_get('$error_is_here',0,Here),
    cmpError(['graphical component expected at:',Here]).

getComponentBound(Object,X,Y,Width,Height):-
    isBaseClassObject(Object) :
    getBaseAttribute(bound,$bound(X,Y,Width,Height),_,Object).
getComponentBound(Object,X,Y,Width,Height):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object :
    Bound=$bound(X,Y,Width,Height).
getComponentBound(Object,X,Y,Width,Height):-
    true :
    global_get('$error_is_here',0,Here),
    cmpError(['graphical component expected at:',Here]).

getComponentsBounds([],Bounds,BoundsR):-
    true :
    Bounds=BoundsR.
getComponentsBounds([elm(_,component(_,Object))|Objects],Bounds,BoundsR):-
    true :
    getComponentsBounds(Object,Bounds,Bounds1),
    getComponentsBounds(Objects,Bounds1,BoundsR).
getComponentsBounds([_|Objects],Bounds,BoundsR):-
    true : getComponentsBounds(Objects,Bounds,BoundsR).
getComponentsBounds(Object,Bounds,BoundsR):-
    array(Size,Type,Components)<=Object :
    hashtableCollect(Components,AllComponents),
    getComponentsBounds(AllComponents,Bounds,BoundsR).
getComponentsBounds(Object,Bounds,BoundsR):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object :
    hashtableCollect(Hashtable,SubComponents),
    Bounds=[Bound|Bounds1],
    getComponentsBounds(SubComponents,Bounds1,BoundsR).
getComponentsBounds(Object,Bounds,BoundsR):-
    isBaseClassObject(Object) :
    getBaseAttribute(bound,Bound,_,Object),
    Bounds=[Bound|BoundsR].


getComponentsBounds([],Bounds,BoundsR,PX,PY,PWidth,PHeight):-
    true :
    Bounds=BoundsR.
getComponentsBounds([elm(_,component(_,Object))|Objects],Bounds,BoundsR,PX,PY,PWidth,PHeight):-
    object(ObjectNo,_,Constants,SuperObject,Hashtable,Bound)<=Object :
    Bounds=[Bound|Bounds1],
    Bound = $bound(X,Y,Width,Height),
    PX #=< X,
    PY #=< Y,
    X+Width #=< PX+PWidth,
    Y+Height #=< PY+PHeight,
    getComponentsBounds(Objects,Bounds1,BoundsR,PX,PY,PWidth,PHeight).
getComponentsBounds([elm(_,component(_,Object))|Objects],Bounds,BoundsR,PX,PY,PWidth,PHeight):-
    array(Size,Type,Components)<=Object :
    hashtableCollect(Components,AllComponents),
    getComponentsBounds(AllComponents,Bounds,Bounds1,PX,PY,PWidth,PHeight),
    getComponentsBounds(Objects,Bounds1,BoundsR,PX,PY,PWidth,PHeight).
getComponentsBounds([elm(_,component(_,Object))|Objects],Bounds,BoundsR,PX,PY,PWidth,PHeight):-
    isBaseClassObject(Object) :
    getBaseAttribute(bound,Bound,_,Object),
    Bounds=[Bound|Bounds1],
    Bound=$bound(X,Y,Width,Height),
    PX #=< X,
    PY #=< Y,
    X+Width #=< PX+PWidth,
    Y+Height #=< PY+PHeight,
    getComponentsBounds(Objects,Bounds1,BoundsR,PX,PY,PWidth,PHeight).
getComponentsBounds([_|Objects],Bounds,BoundsR,PX,PY,PWidth,PHeight):-
    true : getComponentsBounds(Objects,Bounds,BoundsR,PX,PY,PWidth,PHeight).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
:-mode arithmeticConstraintSymbol(+).
arithmeticConstraintSymbol('#=').
arithmeticConstraintSymbol('#\=').
arithmeticConstraintSymbol('#>').
arithmeticConstraintSymbol('#>=').
arithmeticConstraintSymbol('#<').
arithmeticConstraintSymbol('#=<').

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
instanceof(Object,ClassName):-
    object(ObjectNo,ClassName1,Constants,SuperObject,Hashtable,Bound)<=Object :
    (ClassName1==ClassName->true;fail).
instanceof(Object,ClassName):-
    isBaseClassObject(Object) :
    functor(Object,F,N),
    (F==ClassName->true;fail).

newInternalName(Name):-
    nextInstanceNo(N),
    name(N,StringN),
    append("internal_",StringN,String),
    name(Name,String).

newInternalName([],Name,NewName):-
    true : NewName=Name.
newInternalName(PreString,Name,NewName):-
    true :
    name(Name,String),
    append(PreString,[0'_|String],String1),
    name(NewName,String1).


isObject(Object):-    
    object(ObjectNo,ClassName1,Constants,SuperObject,Hashtable,Bound)<=Object :
    true.
isObject(Object):-
    true :
    isBaseClassObject(Object).

getClassName(Object,ClassName):-    
    object(ObjectNo,ClassName1,Constants,SuperObject,Hashtable,Bound)<=Object :
    ClassName=ClassName1.
getClassName(Object,ClassName):-
    isBaseClassObject(Object) :
    functor(Object,ClassName,_).
getClassName(Object,ClassName):-
    true :
    runError(['getClassName has a non-object argument']).

unifyInstances(E1,E2):-var(E1) : E1=E2.
unifyInstances(E1,E2):-var(E2) : E1=E2.
unifyInstances(E1,E2):-
    object(ObjectNo1,ClassName1,Constants1,SuperObject1,Hashtable1,Bound1)<=E1,
    object(ObjectNo2,ClassName2,Constants2,SuperObject2,Hashtable2,Bound2)<=E2 :
    unifyInstances(SuperObject1,SuperObject2),
    functor(Hashtable1,F,N),
    functor(Hashtable2,F,N),
    unifyHashtables(Hashtable1,Hashtable2,N),
    Bound1=Bound2.
unifyInstances(E1,E2):-
    isBaseClassObject(E1),
    isBaseClassObject(E2),!,
    functor(E1,F,N),
    unifyStructure(E1,E2,2,N).
unifyInstances(E1,E2):-true : E1=E2.
    
unifyHashtables(Hashtable1,Hashtable2,N):-
    N=:=0 : true.
unifyHashtables(Hashtable1,Hashtable2,N):-
    true :
    arg(N,Hashtable1,A1),
    arg(N,Hashtable2,A2),
    unifyCompAttributes(A1,A2),
    N1 is N-1,
    unifyHashtables(Hashtable1,Hashtable2,N1).
    
unifyCompAttributes(L1,L2):-var(L1) : L1=L2.
unifyCompAttributes(L1,L2):-var(L2) : L1=L2.
unifyCompAttributes(L1,L2):-
    [elm(Identifier,component(Type,Instance1))|L11]<=L1,
    [elm(Identifier,component(Type,Instance2))|L22]<=L2 :
    unifyInstances(Instance1,Instance2),
    unifyCompAttributes(L11,L22).
unifyCompAttributes(L1,L2):-
    [elm(Identifier,attribute(Type,Value1))|L11]<=L1,
    [elm(Identifier,attribute(Type,Value2))|L22]<=L2 :
    Value1=Value2,
    unifyCompAttributes(L11,L22).

unifyStructure(E1,E2,N0,N):-
    N0>N : true.
unifyStructure(E1,E2,N0,N):-
    arg(N0,E1,A1),
    arg(N0,E2,A2),
    A1=A2,
    N1 is N0+1,
    unifyStructure(E1,E2,N1,N).
    


    

    

    



