%% file  : tokenizer.pl (version 0.0)
%% author: Sosuke Kaneko
%% date  : Feb.1998 - Mar.1998
%   COPYRIGHT (C) 1998 Sosuke Kaneko

tokenize([line(1)|Tokens]):-
	tokenize(Tokens,2).

tokenize(Tokens,LineNum):-
	next_token(Tok,Dilim),!,
	( Dilim=='LF' ->
		NDilim=line(LineNum),
		NLineNum is LineNum+1
	;
		NDilim=Dilim,
		NLineNum=LineNum
	),
	( Tok=='' ->
		Tokens=[NDilim|TokensRest]
	;
		Tokens=[Tok,NDilim|TokensRest]
	),
	tokenize(TokensRest,NLineNum).
tokenize([],_).
    
next_token(Token,Dilim):-	% Dilim is a dilimiter.
	get0(C),
	first_token(C,Codes,Dilim),
	name(Token,Codes).

:-mode first_token(+,-,-).
first_token( -1,[],''):-!,fail. %end_of_file
first_token( 10,[],'LF'):-!.	%line feed
first_token( 32,[],' '):-!.	%space
first_token( 13,[],' '):-!.	%br in MSDOS
first_token(  9,[],'	'):-!. 	%tab
first_token(123,[],'{'):-!.
first_token(125,[],'}'):-!.
first_token( 40,[],'('):-!.
first_token( 41,[],')'):-!.
first_token( 91,[],'['):-!.
first_token( 93,[],']'):-!.
first_token( 58,[],':'):-!.
first_token( 59,[],';'):-!.
first_token( 44,[],','):-!.
first_token( 46,[],'.'):-!.
first_token( 39,[],''''):-!.	%single quoto
first_token( 34,[],'"'):-!.
first_token( 43,[],'+'):-!.
first_token( 45,[],'-'):-!.
first_token( 47,[],'/'):-!.
first_token( 42,[],'*'):-!.
first_token( 37,[],'%'):-!.
first_token( 61,[],'='):-!.
first_token( 60,[],'<'):-!.
first_token( 62,[],'>'):-!.
first_token(126,[],'~'):-!.
first_token( 33,[],'!'):-!.
first_token( 38,[],'&'):-!.
first_token(124,[],'|'):-!.
first_token(Code,Codes,Dilim):-
	Codes=[Code|CodesRest],
	get0(NextCode),
	first_token(NextCode,CodesRest,Dilim).
	
