%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : star.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: draw n-stars
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
drawStar(N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill):-
    true :
    (var(N)->N=5;true),
    (var(SmallDiameter)->SmallDiameter is round(LargeDiameter/2.5);true),
    (var(Angle0)->Angle0=90;true),
    (var(X0)->
     X0 is CenterX+round(LargeDiameter/2*cos(Angle0/180*3.14159));
     true),
    (var(Y0)->
     Y0 is CenterY-round(LargeDiameter/2*sin(Angle0/180*3.14159));
     true),
    computeStarXY(N,CenterX,CenterY,X0,Y0,SmallDiameter,LargeDiameter,XYs),
    (Fill==true->fillStar(XYs,CenterX,CenterY,SmallDiameter);
     drawStar(XYs)).

drawStar(XYs):-
    [Point|_]<=XYs :
    append(XYs,[Point],NewXYs),
    drawStar1(NewXYs).
    

drawStar1([(X1,Y1),(X2,Y2)|XYs]):-
    tab(8),write('g.drawLine('),write(X1),write(','),write(Y1),write(','),
		 write(X2),write(','),write(Y2),write(');'),nl,
    drawStar1([(X2,Y2)|XYs]).
drawStar1(_):-
    true : true.

fillStar(XYs,CenterX,CenterY,Diameter):-
    X is round(CenterX-Diameter/2),
    Y is round(CenterY-Diameter/2),
    tab(8),write('g.fillOval('),write(X),write(','),write(Y),write(','),
		 write(Diameter),write(','),write(Diameter),write(');'),nl,
    XYs=[Point1|XYs1],
    append(XYs,[Point1],XYs2),
    fillTrianglesInStar(XYs2).

fillTrianglesInStar([(X1,Y1),(X2,Y2),(X3,Y3)|XYs]):-
    true : 
    displayDrawTriangle(fill,X1,Y1,X2,Y2,X3,Y3),
/*
    write('g.drawString("'),write(X1),write(','),write(Y1),write('",'),write(X1),write(','),write(Y1),write(');'),nl,
    write('g.drawString("'),write(X2),write(','),write(Y2),write('",'),write(X2),write(','),write(Y2),write(');'),nl,
*/
    fillTrianglesInStar([(X3,Y3)|XYs]).
fillTrianglesInStar(_):-true : true.

computeStarXY(N,CenterX,CenterY,X0,Y0,SmallDiameter,LargeDiameter,XYs):-
    N=<0 :
    XYs=[].
computeStarXY(N,CenterX,CenterY,X0,Y0,SmallDiameter,LargeDiameter,XYs):-
    true :
    Arc is 360/N,
    DifX is CenterX-X0,
    (abs(DifX)<1->Alpha is 90-Arc;
     Alpha is atan((CenterY-Y0)/DifX)*180/3.14159-Arc),
    SmallRadius is SmallDiameter/2,
    LargeRadius is LargeDiameter/2,
    computeStarXYAux(N,CenterX,CenterY,SmallRadius,LargeRadius,XYs,Arc,Alpha).
    
computeStarXYAux(N,CenterX,CenterY,SmallRadius,LargeRadius,XYs,Arc,Alpha):-
    N=:=0 :
    XYs=[].
computeStarXYAux(N,CenterX,CenterY,SmallRadius,LargeRadius,XYs,Arc,Alpha):-
    true :
    Angle1 is Alpha+Arc/2, 
    (Angle1>360->Angle11 is Angle1-360;Angle11=Angle1),
    Angle2 is Arc+Alpha,
    (Angle2>360->Angle22 is Angle2-360;Angle22=Angle2),
    Rad1 is (Angle11/180)*3.14159,
    Rad2 is (Angle22/180)*3.14159,
    SmallX is CenterX-round(SmallRadius*cos(Rad1)),
    SmallY is CenterY-round(SmallRadius*sin(Rad1)),
    LargeX is CenterX-round(LargeRadius*cos(Rad2)),
    LargeY is CenterY-round(LargeRadius*sin(Rad2)),
    XYs=[(SmallX,SmallY),(LargeX,LargeY)|XYs1],
    NewAlpha is Arc+Alpha,
    N1 is N-1,
    computeStarXYAux(N1,CenterX,CenterY,SmallRadius,LargeRadius,XYs1,Arc,NewAlpha).
    




