%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : solveCSP.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: invoke the constraint solver of B-Prolog
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
solveCSP(Vars):-
    divideVars(Vars,SizeVars,IntVars,NonIntVars),
%    write_dvars(SizeVars),
    instantiateSizeVars(SizeVars),
    extractPosVars(SizeVars,PosVars),
%    write(PosVars),nl,
    instantiatePosVars(PosVars),
%    write(IntVars),nl,
    labeling_ff(IntVars),
    instantiateNonPosVars(NonIntVars),
    instantiateNonPosVarsWithDefaults(NonIntVars).

divideVars([],SizeVars,IntVars,NonIntVars):-true : 
    SizeVars=[],NonIntVars=[],IntVars=[].
divideVars([Var|Vars],SizeVars,IntVars,NonIntVars):-
    rect(X,Y,W,H)<=Var :
    SizeVars=[Var|SizeVars1],
    divideVars(Vars,SizeVars1,IntVars,NonIntVars).
divideVars([Var|Vars],SizeVars,IntVars,NonIntVars):-
    int(DVar)<=Var :
    IntVars=[DVar|IntVars1],
    divideVars(Vars,SizeVars,IntVars1,NonIntVars).
divideVars([Var|Vars],SizeVars,IntVars,NonIntVars):-
    true :
    NonIntVars=[Var|NonIntVars1],
    divideVars(Vars,SizeVars,IntVars,NonIntVars1).

extractPosVars([],PosVars):-
    true : PosVars=[].
extractPosVars([rect(X,Y,W,H)|RectVars],PosVars):-
    true :
    PosVars=[pos(X,W),pos(Y,H)|PosVars1],
    extractPosVars(RectVars,PosVars1).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
instantiateSizeVars(RectVars):-
    selectSizeVar(RectVars,RectVar,RestRectVars),!,
    instantiateSizeVarRect(RectVar),
    instantiateSizeVars(RestRectVars).
instantiateSizeVars(RectVars):-
    true : true.

selectSizeVar([RectVar|RectVars],BestRectVar,RestRectVars):-
    rect(X,Y,W,H)<=RectVar :
    fd_min(W,MinW),
    fd_min(H,MinH),
    MinSize is MinW+MinH,
    selectSizeVar(RectVars,RectVar,MinSize,BestRectVar,RestRectVars).
    
selectSizeVar([],CurrRectVar,CurrSize,BestRectVar,RestRectVars):-
    true :
    BestRectVar=CurrRectVar,
    RestRectVars=[].
selectSizeVar([RectVar|RectVars],CurrRectVar,CurrSize,BestRectVar,RestRectVars):-
    rect(X,Y,W,H)<=RectVar :
    fd_min(W,MinW),
    fd_min(H,MinH),
    MinSize is MinW+MinH,
    chooseBetterSizeVar(RectVar,MinSize,CurrRectVar,CurrSize,BetterVar,BetterSize,RestRectVars,RestRectVars1),
    selectSizeVar(RectVars,BetterVar,BetterSize,BestRectVar,RestRectVars1).
    
chooseBetterSizeVar(RectVar,MinSize,CurrRectVar,CurrSize,BetterVar,BetterSize,RectVars,RectVarsR):-
    MinSize > CurrSize :
    BetterSize = MinSize,
    BetterVar = RectVar,
    RectVars=[CurrRectVar|RectVarsR].
chooseBetterSizeVar(RectVar,MinSize,CurrRectVar,CurrSize,BetterVar,BetterSize,RectVars,RectVarsR):-
    true :
    BetterSize = CurrSize,
    BetterVar = CurrRectVar,
    RectVars=[RectVar|RectVarsR].

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
instantiatePosVars(PosVars):-
    selectPosVar(PosVars,PosVar),!,
    indomain(PosVar),
    instantiatePosVars(PosVars).
instantiatePosVars(PosVars):-
    true : true.

selectPosVar([PosVar|PosVars],BestPosVar):-
    pos(X,W)<=PosVar,
    dvar(X) :
    fd_min(X,MinX),
    selectPosVar(PosVars,X,W,MinX,BestPosVar).
selectPosVar([PosVar|PosVars],BestPosVar):-
    true :
    selectPosVar(PosVars,BestPosVar).
    
selectPosVar([],CurrPosVar,CurrSize,CurrPos,BestPosVar):-
    true :
    BestPosVar=CurrPosVar.
selectPosVar([PosVar|PosVars],CurrPosVar,CurrSize,CurrPos,BestPosVar):-
    pos(X,Size)<=PosVar,
    dvar(X) :
    fd_min(X,MinX),
    chooseBetterPosVar(X,Size,MinX,CurrPosVar,CurrSize,CurrPos,BetterVar,BetterSize,BetterPos),
    selectPosVar(PosVars,BetterVar,BetterSize,BetterPos,BestPosVar).
selectPosVar([PosVar|PosVars],CurrPosVar,CurrSize,CurrPos,BestPosVar):-
    true :
    selectPosVar(PosVars,CurrPosVar,CurrSize,CurrPos,BestPosVar).
    
chooseBetterPosVar(PosVar,Size,MinPos,CurrPosVar,CurrSize,CurrPos,BetterVar,BetterSize,BetterPos):-
    Size > CurrSize :
    BetterSize = Size,
    BetterPos = MinPos,
    BetterVar = PosVar.
chooseBetterPosVar(PosVar,Size,MinPos,CurrPosVar,CurrSize,CurrPos,BetterVar,BetterSize,BetterPos):-
    Size =:= CurrSize,
    MinPos < CurrPos :
    BetterSize = Size,
    BetterPos = MinPos,
    BetterVar = PosVar.
chooseBetterPosVar(PosVar,Size,MinPos,CurrPosVar,CurrSize,CurrPos,BetterVar,BetterSize,BetterPos):-
    true :
    BetterSize = CurrSize,
    BetterPos = CurrPos,
    BetterVar = CurrPosVar.
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
instantiateSizeVarRect(rect(X,Y,W,H)):-
    instantiateSizeVar(W),
    instantiateSizeVar(H).

instantiateSizeVar(Var):-
    domain_min_max(Var,Min,Max),
    Mid is (Min+Max)//2,
    instantiateSizeVarBackward(Var,Min,Max,Mid,Mid).
    
instantiateSizeVarBackward(Var,Min,Max,BackwardElm,ForwardElm):-
    Var=BackwardElm.
instantiateSizeVarBackward(Var,Min,Max,BackwardElm,ForwardElm):-
    ForwardElm<Max :
    NextForwardElm is ForwardElm +1,
    instantiateSizeVarForward(Var,Min,Max,BackwardElm,NextForwardElm).
    
instantiateSizeVarForward(Var,Min,Max,BackwardElm,ForwardElm):-
    Var=ForwardElm.
instantiateSizeVarForward(Var,Min,Max,BackwardElm,ForwardElm):-
    BackwardElm>Min :
    NextBackwardElm is BackwardElm-1,
    instantiateSizeVarBackward(Var,Min,Max,NextBackwardElm,ForwardElm).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
instantiateNonPosVars([]):-true : true.
instantiateNonPosVars([Var|Vars]):-true : 
    instantiateNonPosVar(Var),
    instantiateNonPosVars(Vars).

instantiateNonPosVar(int(Var)):-true : nl,indomain(Var).
instantiateNonPosVar('String'(Var)):-var(Var) : true.
instantiateNonPosVar('String'((Var:Dom))):-var(Var) : member(Var,Dom).
instantiateNonPosVar(bool(Var)):-var(Var) : true.
instantiateNonPosVar(bool(Var)):-(Var=true;Var=false).
instantiateNonPosVar('$bf'(Background,Foreground)):-true :
	(var(Background)->true;
	 atom(Background)->true;
	 Background=(Back:Dom1)->member(Back,Dom1)),
	(var(Foreground)->true;
	 atom(Foreground)->true;
	 Foreground=(Fore:Dom2)->member(Fore,Dom2)).
instantiateNonPosVar('Color'(Var)):-var(Var) : true.
instantiateNonPosVar('Color'((Var:Dom))):-var(Var) : member(Var,Dom).
instantiateNonPosVar($font(FontName,FontSize,FontStyle)):-true :
    (var(FontName)->true;
	 atom(FontName)->true;
     FontName=(Var:Dom)->member(Var,Dom)),
    (var(FontSize)->true;
	 atomic(FontSize)->true;
     FontSize=(Var:Dom)->member(Var,Dom)),
    (var(FontStyle)->true;
	 atomic(FontStyle) ->true;
     FontStyle=(Var:Dom)->member(Var,Dom)).
instantiateNonPosVar('Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    true :
    (var(N)->runError('no value is give to the n attribute of Polygon');true),
    Xs=array(_,_,HashtableX),
    instantiatePolygonGetPos(0,N,HashtableX,[],Vars1),
    Ys=array(_,_,HashtableY),
    instantiatePolygonGetPos(0,N,HashtableY,Vars1,Vars),
    labeling_ff(Vars).
instantiateNonPosVar(_):-true : true.

instantiateNonPosVarsWithDefaults([]):-true : true.
instantiateNonPosVarsWithDefaults([Var|Vars]):-true : 
    instantiateNonPosVarWithDefault(Var),
    instantiateNonPosVarsWithDefaults(Vars).

instantiatePolygonGetPos(N0,N,Hashtable,Vars0,Vars):-
    N0>=N : Vars=Vars0.
instantiatePolygonPoints(N0,N,Hashtable,Vars0,Vars):-
    true :
    hashtableGet(N0,attribute(_,X),Hashtable),
    N1 is N0+1,
    instantiatePolygonPoints(N1,N,Hashtable,[X|Vars0],Vars).

instantiateNonPosVarWithDefault(int(Var)):-true : true.
instantiateNonPosVarWithDefault('String'(Var)):-var(Var) : Var=' '.
instantiateNonPosVarWithDefault(bool(Var)):-var(Var) : Var=true.
instantiateNonPosVarWithDefault('Color'(Var)):-var(Var) : Var=defaultForeground.
instantiateNonPosVarWithDefault($font(FontName,FontSize,FontStyle)):-
    true :
    (var(FontName)->FontName=defaultFontName; true),
    (var(FontSize)->FontSize=defaultFontSize; true),
    (var(FontStyle)->FontStyle=defaultFontStyle; true).
instantiateNonPosVarWithDefault('$bf'(Background,Foreground)):-true :
	(var(Background)->Background=defaultBackground;true),
	(var(Foreground)->Foreground=defaultForeground;true).
instantiateNonPosVarWithDefault(_):-true : true.
    








    
    

		    


    
