%   File   : postConstraint.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: Post extracted constraints
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
postConstraints(Constrs,ClassDecls,ConstrDecls,Object,Replaces):-var(Constrs) : true.
postConstraints([],ClassDecls,ConstrDecls,Object,Replaces):-true : true.
postConstraints([constraint(Constr)|Constrs],ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postConstraints(Constr,ClassDecls,ConstrDecls,Object,Replaces),
    postConstraints(Constrs,ClassDecls,ConstrDecls,Object,Replaces).
postConstraints([constraint(Constr,Type,Identifier)|Constrs],ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    addFullNameConstraint(Constr,Type,Identifier,ClassDecls,NConstr),
    postConstraints(NConstr,ClassDecls,ConstrDecls,Object,[]),
    postConstraints(Constrs,ClassDecls,ConstrDecls,Object,Replaces).
postConstraints([Constraint|Constraints],ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postConstraints(Constraint,ClassDecls,ConstrDecls,Object,Replaces),
    postConstraints(Constraints,ClassDecls,ConstrDecls,Object,Replaces).
postConstraints(Constraint,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postConstraint(Constraint,ClassDecls,ConstrDecls,Object,Replaces).
    
postConstraint({Constrs},ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postConstraints(Constrs,ClassDecls,ConstrDecls,Object,Replaces).
postConstraint(grid(Rows),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrArg(Rows,NRows,_,ConstrDecls,Object,Replaces),
    postGridConstraint(NRows,0,0).
postConstraint(grid(Rows,PadX,PadY),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrArg(Rows,NRows,_,ConstrDecls,Object,Replaces),
    evalConstrExp(PadX,NPadX,_,ConstrDecls,Object,Replaces,_),
    evalConstrExp(PadY,NPadY,_,ConstrDecls,Object,Replaces,_),
    postGridConstraint(NRows,NPadX,NPadY).
postConstraint(E1 in E2,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,_),
    evalConstrRange(E2,NewE2,Type2,ClassDecls,Object,Replaces),
    (Type1==Type2,Type1==int->NewE1 in NewE2;
     Type1==Type2->member(NewE1,NewE2);
     cmpError(['Type mismatch :',E1,E2])).
postConstraint('$entail'(Constr1,Constr2),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrAsExp(Constr1,NConstr1,_,ClassDecls,Object,Replaces),
    evalConstrAsExp(Constr2,NConstr2,_,ClassDecls,Object,Replaces),
    listToAnd(NConstr1,AndConstr1),
    listToAnd(NConstr2,AndConstr2),
%    write(user,AndConstr1 #=> AndConstr2),nl(user),
    AndConstr1 #=> AndConstr2.
postConstraint('$or'(Constr1,Constr2),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrAsExp(Constr1,NConstr1,_,ClassDecls,Object,Replaces),
    evalConstrAsExp(Constr2,NConstr2,_,ClassDecls,Object,Replaces),
    listToAnd(NConstr1,AndConstr1),
    listToAnd(NConstr2,AndConstr2),
    AndConstr1 #\/ AndConstr2.
postConstraint('$not'(Constr),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrAsExp(Constr,NConstr,_,ClassDecls,Object,Replaces),
    listToAnd(NConstr,AndConstr),
    #\ AndConstr.
postConstraint('$and'(Constr1,Constr2),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postConstraints(Constr1,ClassDecls,ConstrDecls,Object,Replaces),
    postConstraints(Constr2,ClassDecls,ConstrDecls,Object,Replaces).
postConstraint('$for'(Constr,EnumeratorConditionList),ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraint(EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
postConstraint(Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    functor(Constr,F,N),
    arithmeticConstraintSymbol(F),!,
    arg(1,Constr,E1),arg(2,Constr,E2),
    evalConstrExp(E1,NewE1,Type1,ClassDecls,Object,Replaces,_),
    evalConstrExp(E2,NewE2,Type2,ClassDecls,Object,Replaces,_),
    postArithmeticConstraint(F,NewE1,Type1,NewE2,Type2,E1,E2).
postConstraint(Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    functor(Constr,F,N),
    Constr=..[F|Args],
    evalConstrArgs(Args,NArgs,Types,ClassDecls,Object,Replaces),
    (isBuiltinConstraint(F,N)->postBuiltinConstraint(F,NArgs);
     postUserConstraint(F,NArgs,Types,ClassDecls,ConstrDecls)).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postForConstraint([],Constr,ClassDecls,ConstrDecls,Object,Replaces):-true :
    postConstraints(Constr,ClassDecls,ConstrDecls,Object,Replaces).
postForConstraint([X in Exp|EnumeratorConditionList],Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalConstrRange(Exp,NewE,Type,ClassDecls,Object,Replaces),
    postForConstraintLoop(X,NewE,Type,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
postForConstraint([Condition|EnumeratorConditionList],Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    evalCondition(Condition,Result,ClassDecls,Object,Replaces),
    postForConstraintCondition(Result,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).

postForConstraintLoop(X,L..U,ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraintLoop1(X,L,U,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
postForConstraintLoop(X,Range,ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-true :
    true :
    postForConstraintLoop2(X,Range,ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).

postForConstraintLoop2(X,[],ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-true : true.
postForConstraintLoop2(X,[Elm|Elms],ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-true :
    Pair=fa(X,ElmType,Elm),
    NewReplaces=[Pair|Replaces],
    postForConstraint(EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,NewReplaces),
    postForConstraintLoop2(X,Elms,ElmType,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
    
postForConstraintLoop1(X,L,U,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    L>U : true.
postForConstraintLoop1(X,L,U,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    Pair=fa(X,int,L),
    postForConstraint(EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,[Pair|Replaces]),
    L1 is L+1,
    postForConstraintLoop1(X,L1,U,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).

postForConstraintCondition(true,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraint(EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).
postForConstraintCondition(false,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true : true.
postForConstraintCondition(susp(Vars,Condition),EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces):-
    true :
    postForConstraintSuspCondition(Vars,Condition,EnumeratorConditionList,Constr,ClassDecls,ConstrDecls,Object,Replaces).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postBuiltinConstraint(inside,[O1,O2]):-
    true :
    postInsideConstraint(O1,O2).
postBuiltinConstraint(outside,[O1,O2]):-
    true :
    postInsideConstraint(O2,O1).
postBuiltinConstraint(left,[O1,O2]):-
    true :
    postLeftConstraint(O1,O2).
postBuiltinConstraint(right,[O1,O2]):-
    true :
    postLeftConstraint(O2,O1).
postBuiltinConstraint(above,[O1,O2]):-
    true :
    postAboveConstraint(O1,O2).
postBuiltinConstraint(below,[O1,O2]):-
    true :
    postAboveConstraint(O2,O1).
postBuiltinConstraint(samePosition,Args):-true :
    postSameGeometricConstraint(position,Args).
postBuiltinConstraint(sameX,Args):-true :
    postSameGeometricConstraint(x,Args).
postBuiltinConstraint(sameY,Args):-true :
    postSameGeometricConstraint(y,Args).
postBuiltinConstraint(sameSize,Args):-true :
    postSameGeometricConstraint(size,Args).
postBuiltinConstraint(sameWidth,Args):-true :
    postSameGeometricConstraint(width,Args).
postBuiltinConstraint(sameHeight,Args):-true :
    postSameGeometricConstraint(height,Args).
postBuiltinConstraint(sameCenterX,Args):-true :
    postSameGeometricConstraint(centerX,Args).
postBuiltinConstraint(sameCenterY,Args):-true :
    postSameGeometricConstraint(centerY,Args).
postBuiltinConstraint(sameDiameter,Args):-true :
    (allCircles(Args)->
     postSameGeometricConstraint(width,Args);
     cmpError(['The sameDiameter constraint can be applied to circles only'])).
postBuiltinConstraint(sameRow,Args):-true :
    postSameGeometricConstraint(y,Args),
    leftList(Args).
postBuiltinConstraint(sameColumn,Args):-true :
    postSameGeometricConstraint(x,Args),
    aboveList(Args).

allCircles([]):-true : true.
allCircles([Arg|Args]):-
    isBaseClassObject(Arg,'Circle'),
    allCircles(Args).

leftList([O1,O2|Os]):-
    true : 
    getGeometricAttribute(x,X1,O1),
    getGeometricAttribute(width,W1,O1),
    getGeometricAttribute(x,X2,O2),
    X1+W1 #=< X2,
    leftList([O2|Os]).
leftList(_):-true : true.

aboveList([O1,O2|Os]):-
    true : 
    getGeometricAttribute(y,Y1,O1),
    getGeometricAttribute(height,H1,O1),
    getGeometricAttribute(y,Y2,O2),
    Y1+H1 #=< Y2,
    aboveList([O2|Os]).
aboveList(_):-true : true.

postBuiltinConstraint(sameFont,Args):-true :
    postSameConstraint(font,Args).
postBuiltinConstraint(sameColor,Args):-true :
    postSameConstraint(color,Args).


postArithmeticConstraint('#=',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #= NewE2.
postArithmeticConstraint('#=',NewE1,Type,NewE2,Type,E1,E2):-true : 
    unifyInstances(NewE1,NewE2).
postArithmeticConstraint('#=',NewE1,Type1,NewE2,Type2,E1,E2):-true :
    cmpError(['Types mismatch:',Type1,' == ',Type2]).

postArithmeticConstraint('#\=',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #\= NewE2.
postArithmeticConstraint('#\=',NewE1,Type,NewE2,Type,E1,E2):-true : diff(NewE1,NewE2).
postArithmeticConstraint('#\=',NewE1,Type1,NewE2,Type2,E1,E2):-true :
    cmpError(['Types mismatch:',Type1,' != ',Type2]).

postArithmeticConstraint('#>',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #> NewE2.
postArithmeticConstraint('#>=',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #>= NewE2.
postArithmeticConstraint('#<',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #< NewE2.
postArithmeticConstraint('#=<',NewE1,int,NewE2,int,E1,E2):-true : NewE1 #=< NewE2.
postArithmeticConstraint(R,NewE1,_,NewE2,_,E1,E2):-true : 
    dj2proOperator(R1,R),
    cmpError(['Non-integer type appears in the arithmetic constraint: ',E1,R,E2]).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
postUserConstraint(F,Args,Types,ClassDecls,ConstrDecls):-
    hashtableGet(F,constraintDecl(_,FormalArguments,Body),ConstrDecls),!,
    postUserConstraint(F,Args,Types,FormalArguments,Body,ClassDecls,ConstrDecls).
postUserConstraint(F,Args,Types,ClassDecls,ConstrDecls):-
    cmpError(['Constraint ',F,' not defined']).

postUserConstraint(F,Arguments,Types,FormalArguments,Body,ClassDecls,ConstrDecls):-
    checkArgumentTypes(F,Types,FormalArguments),!,
%    write(FormalArguments),nl,
    formalActualArgumentPairs(FormalArguments,Arguments,Types,Pairs),
%    write(Pairs),nl,
    postConstraints(Body,ClassDecls,ConstrDecls,nil,Pairs).
postUserConstraint(F,Arguments,Types,FormalArguments,Body,ClassDecls,ConstrDecls):-
    cmpError(['Types of formal and actual arguments mismatch in: ',F]).

checkArgumentTypes(F,[],[]):-true : Pairs=[].
checkArgumentTypes(F,[],FormalArguments):-true :
    cmpError(['Numbers of Arguments do not match in ', F]).
checkArgumentTypes(F,Types,[]):-true :
    cmpError(['Numbers of Arguments do not match in ', F]).
checkArgumentTypes(F,[Type|Types],[(FType,_)|FArguments]):-true :
    not(not(typeSubsume(FType,Type))),!,
    checkArgumentTypes(F,Types,FArguments).
checkArgumentTypes(F,[Type|Types],[(FType,_)|FArguments]):-true :
    cmpError(['Types mismatch in ',F,': ',Type,FType]).    

formalActualArgumentPairs([],_,Types,Pairs):-true : Pairs=[].
formalActualArgumentPairs([(Type1,FArg)|FArgs],[Arg|Args],[Type2|Types],Pairs):-true : 
    Pairs=[fa(FArg,Type2,Arg)|Pairs1],
    formalActualArgumentPairs(FArgs,Args,Types,Pairs1).

typeSubsume('Object',Type):-true : true.
typeSubsume(Type,Type):-true : true.
typeSubsume(array(Type1),array(Size,Type2,_)):-true :
    typeSubsume(Type1,Type2).
typeSubsume(array(Type1),array([Dim],Type)):-true :
    typeSubsume(Type1,Type).
typeSubsume(array(Type1),array([Dim|Dims],Type)):-true :
    typeSubsume(Type1,array(Dims,Type)).
    




