%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%   File   : generateJava.pl
%   Author : Neng-Fa ZHOU
%   Last update : 1998
%   Purpose: generate Java classes
%   COPYRIGHT (C) 1998 Neng-Fa ZHOU
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

generateJava(ClassDecls,MainObject):-
    true : 
    getClassName(MainObject,ClassName),
    hashtableGet(ClassName,ClassDecl,ClassDecls),
    generateClass(ClassDecl,ClassDecls,MainObject).

generateClass(ClassDecl,ClassDecls,Object):-
    class(Identifier,Constants,SuperClass,CompAttributes,Constrs,Body,Args,TAPairs)<=ClassDecl :
    write('import java.awt.*;'),nl,
    write('import java.applet.Applet;'),nl,
    write('public class '),
    write(Identifier),
    write(' extends Applet '),
    write('{'),nl,
    generateClassBody(ClassDecls,Object),
    write('}'),nl.
    
generateClassBody(ClassDecls,Object):-
    generateAddDrawSentences(Object,ASentences,[],DSentences,[],ClassDecls),
    displayInitMethodHead,
    displayInitMethodBody(ASentences),
    displayPaint(DSentences).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

generateInitSentences(CompAttributes,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls,Object):-
    []<=CompAttributes :
    ASentences=ASentencesR, DSentences=DSentencesR.
generateInitSentences(CompAttributes,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls,Object):-
    var(CompAttributes) :
    ASentences=ASentencesR, DSentences=DSentencesR.
generateInitSentences([component(Identifier,Class)|ComAttributes],ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls,Object):-
    true :
    getComponent(Identifier,Component,Object),
    generateAddDrawSentences(Component,ASentences,ASentences1,DSentences,DSentences1,ClassDecls),
    generateInitSentences(ComAttributes,ASentences1,ASentencesR,DSentences1,DSentencesR,ClassDecls,Object).
generateInitSentences([attribute(Identifier,Type)|ComAttributes],ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls,Object):-
    true :
    generateInitSentences(ComAttributes,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls,Object).

generateAddDrawSentences([],ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    true :
    ASentences=ASentencesR,
    DSentences=DSentencesR.
generateAddDrawSentences([elm(_,component(_,Object))|Objects],ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    true :
    generateAddDrawSentences(Object,ASentences,ASentences1,DSentences,DSentences1,ClassDecls),
    generateAddDrawSentences(Objects,ASentences1,ASentencesR,DSentences1,DSentencesR,ClassDecls).
generateAddDrawSentences([_|Objects],ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    true :
    generateAddDrawSentences(Objects,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls).
generateAddDrawSentences(array(Size,Type,Components),ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    true :
    hashtableCollect(Components,AllComponents),
    generateAddDrawSentences(AllComponents,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls).
generateAddDrawSentences(Object,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    object(ObjectNo,ClassName,Constants,SuperObject,Hashtable,Bound)<=Object :
    hashtableGet(ClassName,ClassDecl,ClassDecls),
    ClassDecl=class(Identifier,Constants,SuperClass,CompAttributes,Constrs,Body,Args,TAPairs), %%%notice
    generateInitSentences(CompAttributes,ASentences,ASentences1,DSentences,DSentences1,ClassDecls,Object),
    generateAddDrawSentences(SuperObject,ASentences1,ASentencesR,DSentences1,DSentencesR,ClassDecls).
generateAddDrawSentences(Object,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    isBaseClassObject(Object,Type) :
    generateAddDrawSentencesAux(Object,ASentences,ASentencesR,DSentences,DSentencesR,Type).
generateAddDrawSentences(Object,ASentences,ASentencesR,DSentences,DSentencesR,ClassDecls):-
    true :
    ASentences=ASentencesR,
    DSentences=DSentencesR.

generateAddDrawSentencesAux(Object,ASentences,ASentencesR,DSentences,DSentencesR,Type):-
    isGraphicsClass(Type),!,
    ASentences=ASentencesR,
    generateDrawSentencesBase(Object,DSentences,DSentencesR).
generateAddDrawSentencesAux(Object,ASentences,ASentencesR,DSentences,DSentencesR,Type):-
    DSentences=DSentencesR,
    generateAddSentencesBase(Object,ASentences,ASentencesR).


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
displayInitMethodHead:-
    tab(4),write(public),space,write(void),space,write('init'),write('('),write(')'),nl.

displayInitMethodBody(Sentences):-
    tab(4),write('{'),nl,
    tab(8),write('setLayout(null);'),nl,
    displayInitSentences(Sentences),
    tab(4),write('}'),nl.

displayInitSentences([]):-true : true.
displayInitSentences([Sentence|Sentences]):-
    true :
    displayInitSentence(Sentence),
    displayInitSentences(Sentences).
    
displayInitSentence('Label'(ObjectNo,Component,Label,Alignment)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    getBaseAttribute(color,Color,_,Component),
    %
    newInternalName(Identifier),
    tab(8),write('Label '),write(Identifier),write(' = new Label("'),
    write(Label),write('")'),write(';'),nl,
    tab(8),write('this.add'(Identifier)),write(';'),nl,
    tab(8),displaySetLocation(Identifier,X,Y),
    tab(8),displaySetSize(Identifier,Width,Height).
displayInitSentence('Button'(ObjectNo,Component,Label)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    %
    newInternalName(Identifier),
    tab(8),write('Button '),write(Identifier),write(' = new Button("'),
    write(Label),write('")'),write(';'),nl,
    tab(8),write('this.add'(Identifier)),write(';'),nl,
    tab(8),displaySetLocation(Identifier,X,Y),
    tab(8),displaySetSize(Identifier,Width,Height).
displayInitSentence('TextField'(ObjectNo,Component,Text,Columns,MinimumSize,PreferredSize)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,Width,_,Component),
    getBaseAttribute(height,Height,_,Component),
    %
    newInternalName(Identifier),
    tab(8),write('TextField '),write(Identifier),write(' = new TextField("'),
    write(Text),write('",'),write(Columns),write(')'),write(';'),nl,
    tab(8),write('this.add'(Identifier)),write(';'),nl,
    tab(8),displaySetLocation(Identifier,X,Y),
    tab(8),displaySetSize(Identifier,Width,Height).
displayInitSentence('TextArea'(ObjectNo,Component,Text,Rows,Columns,MinimumSize,PreferredSize)):-
    true :
    newInternalName(Identifier),
    tab(8),write('TextField '),write(Identifier),write(' = new TextArea("'),
    write(Text),write('",'),write(Rows),write(','),write(Columns),write(')'),write(';'),nl,
    tab(8),write('this.add'(Identifier)),write(';'),nl,
    tab(8),displaySetLocation(Identifier,X,Y),
    tab(8),displaySetSize(Identifier,Width,Height).
displayInitSentence(_):-
    true : true.

displaySetLocation(Identifier,X,Y):-
    writePPrimary(Identifier),write('.'),write(setLocation),
    write('('),write(X),write(','),write(Y),write(');'),nl.

displaySetSize(Identifier,Width,Height):-
    writePPrimary(Identifier),write('.'),write(setSize),
    write('('),write(Width),write(','),write(Height),write(');'),nl.

    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
displayPaint([]):-true : true.
displayPaint(DSentences):-true :
    displayPaintHead,
    write('{'),nl,
    tab(8),write('Color defaultForeground = g.getColor();'),nl,
    displayDrawSentences(DSentences),
    tab(4),write('}'),nl.
    
displayPaintHead:-
    tab(4),write('public void paint(Graphics g)').

displayDrawSentences([]):-true : true.
displayDrawSentences([Component|Components]):-
    true :
    displaySetColorBefore(Component),
    displayDrawSentence(Component),
    displaySetColorAfter(Component),
    displayDrawSentences(Components).


displayDrawSentence('Arc'(ObjectNo,Component,CenterX,CenterY,StartAngle,ArcAngle,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillArc(X,Y,W,H,StartAngle,ArcAngle)
      ;
     DSentence=drawArc(X,Y,W,H,StartAngle,ArcAngle)),
    writeDrawSentence(DSentence).
displayDrawSentence('Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillOval(X,Y,W,W)
      ;
     DSentence=drawOval(X,Y,W,W)),
    writeDrawSentence(DSentence).
displayDrawSentence('Circle'(ObjectNo,Component,CenterX,CenterY,Diameter,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillOval(X,Y,W,W)
      ;
     DSentence=drawOval(X,Y,W,W)),
    writeDrawSentence(DSentence).
displayDrawSentence('Line'(ObjectNo,Component,X1,Y1,X2,Y2)):-
    true :
    getBaseAttribute(color,Color,_,Component),
    DSentence=drawLine(X1,Y1,X2,Y2),
    writeDrawSentence(DSentence).
displayDrawSentence('Oval'(ObjectNo,Component,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillOval(X,Y,W,H)
      ;
     DSentence=drawOval(X,Y,W,H)),
    writeDrawSentence(DSentence).
displayDrawSentence('Polygon'(ObjectNo,Component,N,Xs,Ys,Fill)):-
    true :
    Xs=array(Size,Type,HashtableX),
    Ys=array(Size,Type,HashtableY),
    displaySetColorBefore(Component),
    displayDrawPolygon(N,HashtableX,HashtableY,Fill).
displayDrawSentence('Square'(ObjectNo,Component,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillRect(X,Y,W,W)
      ;
     DSentence=drawRect(X,Y,W,W)),
    writeDrawSentence(DSentence).
displayDrawSentence('Rectangle'(ObjectNo,Component,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillRect(X,Y,W,H)
      ;
     DSentence=drawRect(X,Y,W,H)),
    writeDrawSentence(DSentence).
displayDrawSentence('RoundRectangle'(ObjectNo,Component,ArcWidth,ArcHeight,Fill)):-
    true :
    getBaseAttribute(x,X,_,Component),
    getBaseAttribute(y,Y,_,Component),
    getBaseAttribute(width,W,_,Component),
    getBaseAttribute(height,H,_,Component),
    getBaseAttribute(color,Color,_,Component),
    (Fill==true-> DSentence=fillRoundRect(X,Y,W,H,ArcWidth,ArcHeight)
      ;
     DSentence=drawRect(X,Y,W,H,ArcWidth,ArcHeight)),
    writeDrawSentence(DSentence).
displayDrawSentence('Triangle'(ObjectNo,Component,X1,Y1,X2,Y2,X3,Y3,Fill)):-
    true :
    (Fill==true -> 
     displayDrawTriangle(fill,X1,Y1,X2,Y2,X3,Y3);
     displayDrawTriangle(fill,X1,Y1,X2,Y2,X3,Y3)).
displayDrawSentence('Star'(ObjectNo,Component,N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill)):-
    true :
    drawStar(N,CenterX,CenterY,X0,Y0,Angle0,SmallDiameter,LargeDiameter,Fill).

displaySetColorBefore(Component):-
    getBaseAttribute(color,Color,_,Component),
    (Color==defaultForeground -> true;
     tab(8),write('g.'),
     write('setColor(Color.'),
     write(Color),write(');'),nl).

displaySetColorAfter(Component):-
    getBaseAttribute(color,Color,_,Component),
    (Color==defaultForeground -> true;
     tab(8),write('g.setColor(defaultForeground);'),nl).

writeDrawSentence(DSentence):-
    tab(8),write('g.'),
    write(DSentence),write(';'),nl.
    
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
displayDrawPolygon(N,HashtableX,HashtableY,Fill):-
    true :
    newInternalName(Identifier1),
    newInternalName(Identifier2),
    tab(8),write('{'),nl,
    tab(9),write('int '),write(Identifier1),write('[] = {'),
    displayDrawPolygonWritePoints(0,N,HashtableX),write('};'),nl,
    tab(9),write('int '),write(Identifier2),write('[] = {'),
    displayDrawPolygonWritePoints(0,N,HashtableY),write('};'),nl,
    tab(9),write('g.'),
    (Fill==true->write('fillPolygon(');write('drawPolygon(')),
    write(Identifier1),write(','),write(Identifier2),write(','),
    write(N),write(');'),nl,
    tab(8),write('}'),nl.
		 
displayDrawPolygonWritePoints(N0,N,Hashtable):-
    N0=:=N-1 : 
    hashtableGet(N0,attribute(_,X),Hashtable),
    write(X).
displayDrawPolygonWritePoints(N0,N,Hashtable):-
    true :
    hashtableGet(N0,attribute(_,X),Hashtable),
    write(X),write(','),
    N1 is N0+1,
    displayDrawPolygonWritePoints(N1,N,Hashtable).

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
displayDrawTriangle(Type,X1,Y1,X2,Y2,X3,Y3):-
    true :
    newInternalName(Identifier1),
    newInternalName(Identifier2),
    tab(8),write('{'),nl,
    tab(9),write('int '),write(Identifier1),write('[] = {'),
    write(X1),write(','),write(X2),write(','),write(X3),write(','),write(X1),write('};'),nl,
    tab(9),write('int '),write(Identifier2),write('[] = {'),
    write(Y1),write(','),write(Y2),write(','),write(Y3),write(','),write(Y1),write('};'),nl,
    tab(9),write('g.'),
    (Type==fill->write('fillPolygon(');write('drawPolygon(')),
    write(Identifier1),write(','),write(Identifier2),write(','),write('4);'),nl,
    tab(8),write('}'),nl.

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
writeDimExprs([]):-true : true.
writeDimExprs([D|Ds]):-
    true :
    write('['),write(D),write(']'),
    writeDimExprs(Ds).

writeline([]):-true : nl.
writeline([X|Xs]):-
    true : 
    write_token(X),
    write(' '),
    writeline(Xs).
    
write_token(X.Y):-
    true :
    write(X),write('.'),write_token(Y).
write_token(X):-
    write(X).

writeDotToUnderscore(X.Y):-
    true :
    writeDotToUnderscore(X),
    write('_'),
    writeDotToUnderscore(Y).
writeDotToUnderscore(true):-
    true : write(true).
writeDotToUnderscore(false):-
    true : write(false).
writeDotToUnderscore(X):-
    integer(X) :
    write(X).
writeDotToUnderscore('String'(X)):-
    isStringConstant(X) :
    write(X).
writeDotToUnderscore('String'(X)):-
    true :   % write String
    write('"'),write(X),write('"').
writeDotToUnderscore(X):-
    true :
    write(X).

:-mode isStringConstant(+).
isStringConstant(defaultFontName).
isStringConstant(defaultFontStyle).

space:-write(' ').

arrayDimExprs([component(N,Class)|_],PDimExprs):-
    true :
    arrayDimExprs(Class,PDimExprs).
arrayDimExprs(array(Size,Type,Components),PDimExprs):-
    true :
    PDimExprs=[Size|PDimExprs1],
    arrayDimExprs(Components,PDimExprs1).
arrayDimExprs(Class,PDimExprs):-
    true :
    PDimExprs=[].

writePPrimary(this.Something):-
    true :
    write(this),write('.'),
    writePPrimary(Something).
writePPrimary(Path.Index):-
    true :
    writePPrimary(Path),
    write('['),write(Index),write(']').
writePPrimary(Identifier):-
    true :
    write(Identifier).


    
    


    
    
    
    
